// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/privacy/dlp/v2beta2/dlp.proto

/*
Package dlp is a generated protocol buffer package.

It is generated from these files:
	google/privacy/dlp/v2beta2/dlp.proto
	google/privacy/dlp/v2beta2/storage.proto

It has these top-level messages:
	InspectConfig
	ContentItem
	Table
	InspectResult
	Finding
	Location
	TableLocation
	Range
	ImageLocation
	RedactImageRequest
	Color
	RedactImageResponse
	DeidentifyContentRequest
	DeidentifyContentResponse
	ReidentifyContentRequest
	ReidentifyContentResponse
	InspectContentRequest
	InspectContentResponse
	InspectDataSourceRequest
	OutputStorageConfig
	InfoTypeStatistics
	InspectDataSourceDetails
	InfoTypeDescription
	ListInfoTypesRequest
	ListInfoTypesResponse
	AnalyzeDataSourceRiskRequest
	RiskAnalysisJobConfig
	PrivacyMetric
	AnalyzeDataSourceRiskDetails
	ValueFrequency
	Value
	QuoteInfo
	DateTime
	DeidentifyConfig
	PrimitiveTransformation
	TimePartConfig
	CryptoHashConfig
	ReplaceValueConfig
	ReplaceWithInfoTypeConfig
	RedactConfig
	CharsToIgnore
	CharacterMaskConfig
	FixedSizeBucketingConfig
	BucketingConfig
	CryptoReplaceFfxFpeConfig
	CryptoKey
	TransientCryptoKey
	UnwrappedCryptoKey
	KmsWrappedCryptoKey
	DateShiftConfig
	InfoTypeTransformations
	FieldTransformation
	RecordTransformations
	RecordSuppression
	RecordCondition
	TransformationOverview
	TransformationSummary
	Schedule
	InspectTemplate
	DeidentifyTemplate
	JobTrigger
	Action
	CreateInspectTemplateRequest
	UpdateInspectTemplateRequest
	GetInspectTemplateRequest
	ListInspectTemplatesRequest
	ListInspectTemplatesResponse
	DeleteInspectTemplateRequest
	CreateJobTriggerRequest
	UpdateJobTriggerRequest
	GetJobTriggerRequest
	ListJobTriggersRequest
	ListJobTriggersResponse
	DeleteJobTriggerRequest
	InspectJobConfig
	DlpJob
	GetDlpJobRequest
	ListDlpJobsRequest
	ListDlpJobsResponse
	CancelDlpJobRequest
	DeleteDlpJobRequest
	CreateDeidentifyTemplateRequest
	UpdateDeidentifyTemplateRequest
	GetDeidentifyTemplateRequest
	ListDeidentifyTemplatesRequest
	ListDeidentifyTemplatesResponse
	DeleteDeidentifyTemplateRequest
	InfoType
	CustomInfoType
	FieldId
	PartitionId
	KindExpression
	DatastoreOptions
	CloudStorageOptions
	BigQueryOptions
	StorageConfig
	BigQueryKey
	CloudStorageKey
	DatastoreKey
	Key
	RecordKey
	BigQueryTable
	EntityId
*/
package dlp

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_protobuf2 "github.com/golang/protobuf/ptypes/duration"
import google_protobuf3 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf4 "google.golang.org/genproto/protobuf/field_mask"
import google_protobuf1 "github.com/golang/protobuf/ptypes/timestamp"
import google_rpc "google.golang.org/genproto/googleapis/rpc/status"
import google_type "google.golang.org/genproto/googleapis/type/date"
import google_type1 "google.golang.org/genproto/googleapis/type/dayofweek"
import google_type2 "google.golang.org/genproto/googleapis/type/timeofday"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Parts of the APIs which use certain infoTypes.
type InfoTypeSupportedBy int32

const (
	InfoTypeSupportedBy_ENUM_TYPE_UNSPECIFIED InfoTypeSupportedBy = 0
	// Supported by the inspect operations.
	InfoTypeSupportedBy_INSPECT InfoTypeSupportedBy = 1
	// Supported by the risk analysis operations.
	InfoTypeSupportedBy_RISK_ANALYSIS InfoTypeSupportedBy = 2
)

var InfoTypeSupportedBy_name = map[int32]string{
	0: "ENUM_TYPE_UNSPECIFIED",
	1: "INSPECT",
	2: "RISK_ANALYSIS",
}
var InfoTypeSupportedBy_value = map[string]int32{
	"ENUM_TYPE_UNSPECIFIED": 0,
	"INSPECT":               1,
	"RISK_ANALYSIS":         2,
}

func (x InfoTypeSupportedBy) String() string {
	return proto.EnumName(InfoTypeSupportedBy_name, int32(x))
}
func (InfoTypeSupportedBy) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// Operators available for comparing the value of fields.
type RelationalOperator int32

const (
	RelationalOperator_RELATIONAL_OPERATOR_UNSPECIFIED RelationalOperator = 0
	// Equal.
	RelationalOperator_EQUAL_TO RelationalOperator = 1
	// Not equal to.
	RelationalOperator_NOT_EQUAL_TO RelationalOperator = 2
	// Greater than.
	RelationalOperator_GREATER_THAN RelationalOperator = 3
	// Less than.
	RelationalOperator_LESS_THAN RelationalOperator = 4
	// Greater than or equals.
	RelationalOperator_GREATER_THAN_OR_EQUALS RelationalOperator = 5
	// Less than or equals.
	RelationalOperator_LESS_THAN_OR_EQUALS RelationalOperator = 6
	// Exists
	RelationalOperator_EXISTS RelationalOperator = 7
)

var RelationalOperator_name = map[int32]string{
	0: "RELATIONAL_OPERATOR_UNSPECIFIED",
	1: "EQUAL_TO",
	2: "NOT_EQUAL_TO",
	3: "GREATER_THAN",
	4: "LESS_THAN",
	5: "GREATER_THAN_OR_EQUALS",
	6: "LESS_THAN_OR_EQUALS",
	7: "EXISTS",
}
var RelationalOperator_value = map[string]int32{
	"RELATIONAL_OPERATOR_UNSPECIFIED": 0,
	"EQUAL_TO":                        1,
	"NOT_EQUAL_TO":                    2,
	"GREATER_THAN":                    3,
	"LESS_THAN":                       4,
	"GREATER_THAN_OR_EQUALS":          5,
	"LESS_THAN_OR_EQUALS":             6,
	"EXISTS":                          7,
}

func (x RelationalOperator) String() string {
	return proto.EnumName(RelationalOperator_name, int32(x))
}
func (RelationalOperator) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

// An enum to represent the various type of DLP jobs.
type DlpJobType int32

const (
	DlpJobType_DLP_JOB_TYPE_UNSPECIFIED DlpJobType = 0
	// The job inspected Google Cloud for sensitive data.
	DlpJobType_INSPECT_JOB DlpJobType = 1
	// The job executed a Risk Analysis computation.
	DlpJobType_RISK_ANALYSIS_JOB DlpJobType = 2
)

var DlpJobType_name = map[int32]string{
	0: "DLP_JOB_TYPE_UNSPECIFIED",
	1: "INSPECT_JOB",
	2: "RISK_ANALYSIS_JOB",
}
var DlpJobType_value = map[string]int32{
	"DLP_JOB_TYPE_UNSPECIFIED": 0,
	"INSPECT_JOB":              1,
	"RISK_ANALYSIS_JOB":        2,
}

func (x DlpJobType) String() string {
	return proto.EnumName(DlpJobType_name, int32(x))
}
func (DlpJobType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

// Predefined schemas for storing findings.
type OutputStorageConfig_OutputSchema int32

const (
	OutputStorageConfig_OUTPUT_SCHEMA_UNSPECIFIED OutputStorageConfig_OutputSchema = 0
	// Basic schema including only `info_type`, `quote`, `certainty`, and
	// `timestamp`.
	OutputStorageConfig_BASIC_COLUMNS OutputStorageConfig_OutputSchema = 1
	// Schema tailored to findings from scanning Google Cloud Storage.
	OutputStorageConfig_GCS_COLUMNS OutputStorageConfig_OutputSchema = 2
	// Schema tailored to findings from scanning Google Datastore.
	OutputStorageConfig_DATASTORE_COLUMNS OutputStorageConfig_OutputSchema = 3
	// Schema tailored to findings from scanning Google BigQuery.
	OutputStorageConfig_BIG_QUERY_COLUMNS OutputStorageConfig_OutputSchema = 4
	// Schema containing all columns.
	OutputStorageConfig_ALL_COLUMNS OutputStorageConfig_OutputSchema = 5
)

var OutputStorageConfig_OutputSchema_name = map[int32]string{
	0: "OUTPUT_SCHEMA_UNSPECIFIED",
	1: "BASIC_COLUMNS",
	2: "GCS_COLUMNS",
	3: "DATASTORE_COLUMNS",
	4: "BIG_QUERY_COLUMNS",
	5: "ALL_COLUMNS",
}
var OutputStorageConfig_OutputSchema_value = map[string]int32{
	"OUTPUT_SCHEMA_UNSPECIFIED": 0,
	"BASIC_COLUMNS":             1,
	"GCS_COLUMNS":               2,
	"DATASTORE_COLUMNS":         3,
	"BIG_QUERY_COLUMNS":         4,
	"ALL_COLUMNS":               5,
}

func (x OutputStorageConfig_OutputSchema) String() string {
	return proto.EnumName(OutputStorageConfig_OutputSchema_name, int32(x))
}
func (OutputStorageConfig_OutputSchema) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{19, 0}
}

type TimePartConfig_TimePart int32

const (
	TimePartConfig_TIME_PART_UNSPECIFIED TimePartConfig_TimePart = 0
	// [0-9999]
	TimePartConfig_YEAR TimePartConfig_TimePart = 1
	// [1-12]
	TimePartConfig_MONTH TimePartConfig_TimePart = 2
	// [1-31]
	TimePartConfig_DAY_OF_MONTH TimePartConfig_TimePart = 3
	// [1-7]
	TimePartConfig_DAY_OF_WEEK TimePartConfig_TimePart = 4
	// [1-52]
	TimePartConfig_WEEK_OF_YEAR TimePartConfig_TimePart = 5
	// [0-23]
	TimePartConfig_HOUR_OF_DAY TimePartConfig_TimePart = 6
)

var TimePartConfig_TimePart_name = map[int32]string{
	0: "TIME_PART_UNSPECIFIED",
	1: "YEAR",
	2: "MONTH",
	3: "DAY_OF_MONTH",
	4: "DAY_OF_WEEK",
	5: "WEEK_OF_YEAR",
	6: "HOUR_OF_DAY",
}
var TimePartConfig_TimePart_value = map[string]int32{
	"TIME_PART_UNSPECIFIED": 0,
	"YEAR":                  1,
	"MONTH":                 2,
	"DAY_OF_MONTH":          3,
	"DAY_OF_WEEK":           4,
	"WEEK_OF_YEAR":          5,
	"HOUR_OF_DAY":           6,
}

func (x TimePartConfig_TimePart) String() string {
	return proto.EnumName(TimePartConfig_TimePart_name, int32(x))
}
func (TimePartConfig_TimePart) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{35, 0} }

type CharsToIgnore_CommonCharsToIgnore int32

const (
	CharsToIgnore_COMMON_CHARS_TO_IGNORE_UNSPECIFIED CharsToIgnore_CommonCharsToIgnore = 0
	// 0-9
	CharsToIgnore_NUMERIC CharsToIgnore_CommonCharsToIgnore = 1
	// A-Z
	CharsToIgnore_ALPHA_UPPER_CASE CharsToIgnore_CommonCharsToIgnore = 2
	// a-z
	CharsToIgnore_ALPHA_LOWER_CASE CharsToIgnore_CommonCharsToIgnore = 3
	// US Punctuation, one of !"#$%&'()*+,-./:;<=>?@[\]^_`{|}~
	CharsToIgnore_PUNCTUATION CharsToIgnore_CommonCharsToIgnore = 4
	// Whitespace character, one of [ \t\n\x0B\f\r]
	CharsToIgnore_WHITESPACE CharsToIgnore_CommonCharsToIgnore = 5
)

var CharsToIgnore_CommonCharsToIgnore_name = map[int32]string{
	0: "COMMON_CHARS_TO_IGNORE_UNSPECIFIED",
	1: "NUMERIC",
	2: "ALPHA_UPPER_CASE",
	3: "ALPHA_LOWER_CASE",
	4: "PUNCTUATION",
	5: "WHITESPACE",
}
var CharsToIgnore_CommonCharsToIgnore_value = map[string]int32{
	"COMMON_CHARS_TO_IGNORE_UNSPECIFIED": 0,
	"NUMERIC":          1,
	"ALPHA_UPPER_CASE": 2,
	"ALPHA_LOWER_CASE": 3,
	"PUNCTUATION":      4,
	"WHITESPACE":       5,
}

func (x CharsToIgnore_CommonCharsToIgnore) String() string {
	return proto.EnumName(CharsToIgnore_CommonCharsToIgnore_name, int32(x))
}
func (CharsToIgnore_CommonCharsToIgnore) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{40, 0}
}

// These are commonly used subsets of the alphabet that the FFX mode
// natively supports. In the algorithm, the alphabet is selected using
// the "radix". Therefore each corresponds to particular radix.
type CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet int32

const (
	CryptoReplaceFfxFpeConfig_FFX_COMMON_NATIVE_ALPHABET_UNSPECIFIED CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet = 0
	// [0-9] (radix of 10)
	CryptoReplaceFfxFpeConfig_NUMERIC CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet = 1
	// [0-9A-F] (radix of 16)
	CryptoReplaceFfxFpeConfig_HEXADECIMAL CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet = 2
	// [0-9A-Z] (radix of 36)
	CryptoReplaceFfxFpeConfig_UPPER_CASE_ALPHA_NUMERIC CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet = 3
	// [0-9A-Za-z] (radix of 62)
	CryptoReplaceFfxFpeConfig_ALPHA_NUMERIC CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet = 4
)

var CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet_name = map[int32]string{
	0: "FFX_COMMON_NATIVE_ALPHABET_UNSPECIFIED",
	1: "NUMERIC",
	2: "HEXADECIMAL",
	3: "UPPER_CASE_ALPHA_NUMERIC",
	4: "ALPHA_NUMERIC",
}
var CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet_value = map[string]int32{
	"FFX_COMMON_NATIVE_ALPHABET_UNSPECIFIED": 0,
	"NUMERIC":                  1,
	"HEXADECIMAL":              2,
	"UPPER_CASE_ALPHA_NUMERIC": 3,
	"ALPHA_NUMERIC":            4,
}

func (x CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet) String() string {
	return proto.EnumName(CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet_name, int32(x))
}
func (CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{44, 0}
}

type RecordCondition_Expressions_LogicalOperator int32

const (
	RecordCondition_Expressions_LOGICAL_OPERATOR_UNSPECIFIED RecordCondition_Expressions_LogicalOperator = 0
	RecordCondition_Expressions_AND                          RecordCondition_Expressions_LogicalOperator = 1
)

var RecordCondition_Expressions_LogicalOperator_name = map[int32]string{
	0: "LOGICAL_OPERATOR_UNSPECIFIED",
	1: "AND",
}
var RecordCondition_Expressions_LogicalOperator_value = map[string]int32{
	"LOGICAL_OPERATOR_UNSPECIFIED": 0,
	"AND": 1,
}

func (x RecordCondition_Expressions_LogicalOperator) String() string {
	return proto.EnumName(RecordCondition_Expressions_LogicalOperator_name, int32(x))
}
func (RecordCondition_Expressions_LogicalOperator) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{54, 2, 0}
}

// Possible outcomes of transformations.
type TransformationSummary_TransformationResultCode int32

const (
	TransformationSummary_TRANSFORMATION_RESULT_CODE_UNSPECIFIED TransformationSummary_TransformationResultCode = 0
	TransformationSummary_SUCCESS                                TransformationSummary_TransformationResultCode = 1
	TransformationSummary_ERROR                                  TransformationSummary_TransformationResultCode = 2
)

var TransformationSummary_TransformationResultCode_name = map[int32]string{
	0: "TRANSFORMATION_RESULT_CODE_UNSPECIFIED",
	1: "SUCCESS",
	2: "ERROR",
}
var TransformationSummary_TransformationResultCode_value = map[string]int32{
	"TRANSFORMATION_RESULT_CODE_UNSPECIFIED": 0,
	"SUCCESS": 1,
	"ERROR":   2,
}

func (x TransformationSummary_TransformationResultCode) String() string {
	return proto.EnumName(TransformationSummary_TransformationResultCode_name, int32(x))
}
func (TransformationSummary_TransformationResultCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{56, 0}
}

// Whether the trigger is currently active. If PAUSED or CANCELLED, no jobs
// will be created with this configuration. The service may automatically
// pause triggers experiencing frequent errors. To restart a job, set the
// status to HEALTHY after correcting user errors.
type JobTrigger_Status int32

const (
	JobTrigger_STATUS_UNSPECIFIED JobTrigger_Status = 0
	// Trigger is healthy.
	JobTrigger_HEALTHY JobTrigger_Status = 1
	// Trigger is temporarily paused.
	JobTrigger_PAUSED JobTrigger_Status = 2
	// Trigger is cancelled and can not be resumed.
	JobTrigger_CANCELLED JobTrigger_Status = 3
)

var JobTrigger_Status_name = map[int32]string{
	0: "STATUS_UNSPECIFIED",
	1: "HEALTHY",
	2: "PAUSED",
	3: "CANCELLED",
}
var JobTrigger_Status_value = map[string]int32{
	"STATUS_UNSPECIFIED": 0,
	"HEALTHY":            1,
	"PAUSED":             2,
	"CANCELLED":          3,
}

func (x JobTrigger_Status) String() string {
	return proto.EnumName(JobTrigger_Status_name, int32(x))
}
func (JobTrigger_Status) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{60, 0} }

type DlpJob_JobState int32

const (
	DlpJob_JOB_STATE_UNSPECIFIED DlpJob_JobState = 0
	// The job has not yet started.
	DlpJob_PENDING DlpJob_JobState = 1
	// The job is currently running.
	DlpJob_RUNNING DlpJob_JobState = 2
	// The job is no longer running.
	DlpJob_DONE DlpJob_JobState = 3
	// The job was canceled before it could complete.
	DlpJob_CANCELED DlpJob_JobState = 4
	// The job had an error and did not complete.
	DlpJob_FAILED DlpJob_JobState = 5
)

var DlpJob_JobState_name = map[int32]string{
	0: "JOB_STATE_UNSPECIFIED",
	1: "PENDING",
	2: "RUNNING",
	3: "DONE",
	4: "CANCELED",
	5: "FAILED",
}
var DlpJob_JobState_value = map[string]int32{
	"JOB_STATE_UNSPECIFIED": 0,
	"PENDING":               1,
	"RUNNING":               2,
	"DONE":                  3,
	"CANCELED":              4,
	"FAILED":                5,
}

func (x DlpJob_JobState) String() string {
	return proto.EnumName(DlpJob_JobState_name, int32(x))
}
func (DlpJob_JobState) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{75, 0} }

// Configuration description of the scanning process.
// When used with redactContent only info_types and min_likelihood are currently
// used.
type InspectConfig struct {
	// Restricts what info_types to look for. The values must correspond to
	// InfoType values returned by ListInfoTypes or found in documentation.
	// Empty info_types runs all enabled detectors.
	InfoTypes []*InfoType `protobuf:"bytes,1,rep,name=info_types,json=infoTypes" json:"info_types,omitempty"`
	// Only returns findings equal or above this threshold. The default is
	// POSSIBLE.
	MinLikelihood Likelihood                   `protobuf:"varint,2,opt,name=min_likelihood,json=minLikelihood,enum=google.privacy.dlp.v2beta2.Likelihood" json:"min_likelihood,omitempty"`
	Limits        *InspectConfig_FindingLimits `protobuf:"bytes,3,opt,name=limits" json:"limits,omitempty"`
	// When true, a contextual quote from the data that triggered a finding is
	// included in the response; see Finding.quote.
	IncludeQuote bool `protobuf:"varint,4,opt,name=include_quote,json=includeQuote" json:"include_quote,omitempty"`
	// When true, excludes type information of the findings.
	ExcludeInfoTypes bool `protobuf:"varint,5,opt,name=exclude_info_types,json=excludeInfoTypes" json:"exclude_info_types,omitempty"`
	// Custom infoTypes provided by the user.
	CustomInfoTypes []*CustomInfoType `protobuf:"bytes,6,rep,name=custom_info_types,json=customInfoTypes" json:"custom_info_types,omitempty"`
}

func (m *InspectConfig) Reset()                    { *m = InspectConfig{} }
func (m *InspectConfig) String() string            { return proto.CompactTextString(m) }
func (*InspectConfig) ProtoMessage()               {}
func (*InspectConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *InspectConfig) GetInfoTypes() []*InfoType {
	if m != nil {
		return m.InfoTypes
	}
	return nil
}

func (m *InspectConfig) GetMinLikelihood() Likelihood {
	if m != nil {
		return m.MinLikelihood
	}
	return Likelihood_LIKELIHOOD_UNSPECIFIED
}

func (m *InspectConfig) GetLimits() *InspectConfig_FindingLimits {
	if m != nil {
		return m.Limits
	}
	return nil
}

func (m *InspectConfig) GetIncludeQuote() bool {
	if m != nil {
		return m.IncludeQuote
	}
	return false
}

func (m *InspectConfig) GetExcludeInfoTypes() bool {
	if m != nil {
		return m.ExcludeInfoTypes
	}
	return false
}

func (m *InspectConfig) GetCustomInfoTypes() []*CustomInfoType {
	if m != nil {
		return m.CustomInfoTypes
	}
	return nil
}

type InspectConfig_FindingLimits struct {
	// Max number of findings that will be returned for each item scanned.
	MaxFindingsPerItem int32 `protobuf:"varint,1,opt,name=max_findings_per_item,json=maxFindingsPerItem" json:"max_findings_per_item,omitempty"`
	// Max total number of findings that will be returned per request/job.
	MaxFindingsPerRequest int32 `protobuf:"varint,2,opt,name=max_findings_per_request,json=maxFindingsPerRequest" json:"max_findings_per_request,omitempty"`
	// Configuration of findings limit given for specified infoTypes.
	MaxFindingsPerInfoType []*InspectConfig_FindingLimits_InfoTypeLimit `protobuf:"bytes,3,rep,name=max_findings_per_info_type,json=maxFindingsPerInfoType" json:"max_findings_per_info_type,omitempty"`
}

func (m *InspectConfig_FindingLimits) Reset()                    { *m = InspectConfig_FindingLimits{} }
func (m *InspectConfig_FindingLimits) String() string            { return proto.CompactTextString(m) }
func (*InspectConfig_FindingLimits) ProtoMessage()               {}
func (*InspectConfig_FindingLimits) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0, 0} }

func (m *InspectConfig_FindingLimits) GetMaxFindingsPerItem() int32 {
	if m != nil {
		return m.MaxFindingsPerItem
	}
	return 0
}

func (m *InspectConfig_FindingLimits) GetMaxFindingsPerRequest() int32 {
	if m != nil {
		return m.MaxFindingsPerRequest
	}
	return 0
}

func (m *InspectConfig_FindingLimits) GetMaxFindingsPerInfoType() []*InspectConfig_FindingLimits_InfoTypeLimit {
	if m != nil {
		return m.MaxFindingsPerInfoType
	}
	return nil
}

// Max findings configuration per infoType, per content item or long
// running DlpJob.
type InspectConfig_FindingLimits_InfoTypeLimit struct {
	// Type of information the findings limit applies to. Only one limit per
	// info_type should be provided. If InfoTypeLimit does not have an
	// info_type, the DLP API applies the limit against all info_types that
	// are found but not specified in another InfoTypeLimit.
	InfoType *InfoType `protobuf:"bytes,1,opt,name=info_type,json=infoType" json:"info_type,omitempty"`
	// Max findings limit for the given infoType.
	MaxFindings int32 `protobuf:"varint,2,opt,name=max_findings,json=maxFindings" json:"max_findings,omitempty"`
}

func (m *InspectConfig_FindingLimits_InfoTypeLimit) Reset() {
	*m = InspectConfig_FindingLimits_InfoTypeLimit{}
}
func (m *InspectConfig_FindingLimits_InfoTypeLimit) String() string { return proto.CompactTextString(m) }
func (*InspectConfig_FindingLimits_InfoTypeLimit) ProtoMessage()    {}
func (*InspectConfig_FindingLimits_InfoTypeLimit) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{0, 0, 0}
}

func (m *InspectConfig_FindingLimits_InfoTypeLimit) GetInfoType() *InfoType {
	if m != nil {
		return m.InfoType
	}
	return nil
}

func (m *InspectConfig_FindingLimits_InfoTypeLimit) GetMaxFindings() int32 {
	if m != nil {
		return m.MaxFindings
	}
	return 0
}

// Container structure for the content to inspect.
type ContentItem struct {
	// Type of the content, as defined in Content-Type HTTP header.
	// Supported types are: all "text" types, octet streams, PNG images,
	// JPEG images.
	Type string `protobuf:"bytes,1,opt,name=type" json:"type,omitempty"`
	// Data of the item either in the byte array or UTF-8 string form.
	//
	// Types that are valid to be assigned to DataItem:
	//	*ContentItem_Data
	//	*ContentItem_Value
	//	*ContentItem_Table
	DataItem isContentItem_DataItem `protobuf_oneof:"data_item"`
}

func (m *ContentItem) Reset()                    { *m = ContentItem{} }
func (m *ContentItem) String() string            { return proto.CompactTextString(m) }
func (*ContentItem) ProtoMessage()               {}
func (*ContentItem) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

type isContentItem_DataItem interface {
	isContentItem_DataItem()
}

type ContentItem_Data struct {
	Data []byte `protobuf:"bytes,2,opt,name=data,proto3,oneof"`
}
type ContentItem_Value struct {
	Value string `protobuf:"bytes,3,opt,name=value,oneof"`
}
type ContentItem_Table struct {
	Table *Table `protobuf:"bytes,4,opt,name=table,oneof"`
}

func (*ContentItem_Data) isContentItem_DataItem()  {}
func (*ContentItem_Value) isContentItem_DataItem() {}
func (*ContentItem_Table) isContentItem_DataItem() {}

func (m *ContentItem) GetDataItem() isContentItem_DataItem {
	if m != nil {
		return m.DataItem
	}
	return nil
}

func (m *ContentItem) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *ContentItem) GetData() []byte {
	if x, ok := m.GetDataItem().(*ContentItem_Data); ok {
		return x.Data
	}
	return nil
}

func (m *ContentItem) GetValue() string {
	if x, ok := m.GetDataItem().(*ContentItem_Value); ok {
		return x.Value
	}
	return ""
}

func (m *ContentItem) GetTable() *Table {
	if x, ok := m.GetDataItem().(*ContentItem_Table); ok {
		return x.Table
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ContentItem) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ContentItem_OneofMarshaler, _ContentItem_OneofUnmarshaler, _ContentItem_OneofSizer, []interface{}{
		(*ContentItem_Data)(nil),
		(*ContentItem_Value)(nil),
		(*ContentItem_Table)(nil),
	}
}

func _ContentItem_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ContentItem)
	// data_item
	switch x := m.DataItem.(type) {
	case *ContentItem_Data:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.Data)
	case *ContentItem_Value:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Value)
	case *ContentItem_Table:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Table); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("ContentItem.DataItem has unexpected type %T", x)
	}
	return nil
}

func _ContentItem_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ContentItem)
	switch tag {
	case 2: // data_item.data
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.DataItem = &ContentItem_Data{x}
		return true, err
	case 3: // data_item.value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.DataItem = &ContentItem_Value{x}
		return true, err
	case 4: // data_item.table
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Table)
		err := b.DecodeMessage(msg)
		m.DataItem = &ContentItem_Table{msg}
		return true, err
	default:
		return false, nil
	}
}

func _ContentItem_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ContentItem)
	// data_item
	switch x := m.DataItem.(type) {
	case *ContentItem_Data:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Data)))
		n += len(x.Data)
	case *ContentItem_Value:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Value)))
		n += len(x.Value)
	case *ContentItem_Table:
		s := proto.Size(x.Table)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Structured content to inspect. Up to 50,000 `Value`s per request allowed.
type Table struct {
	Headers []*FieldId   `protobuf:"bytes,1,rep,name=headers" json:"headers,omitempty"`
	Rows    []*Table_Row `protobuf:"bytes,2,rep,name=rows" json:"rows,omitempty"`
}

func (m *Table) Reset()                    { *m = Table{} }
func (m *Table) String() string            { return proto.CompactTextString(m) }
func (*Table) ProtoMessage()               {}
func (*Table) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *Table) GetHeaders() []*FieldId {
	if m != nil {
		return m.Headers
	}
	return nil
}

func (m *Table) GetRows() []*Table_Row {
	if m != nil {
		return m.Rows
	}
	return nil
}

type Table_Row struct {
	Values []*Value `protobuf:"bytes,1,rep,name=values" json:"values,omitempty"`
}

func (m *Table_Row) Reset()                    { *m = Table_Row{} }
func (m *Table_Row) String() string            { return proto.CompactTextString(m) }
func (*Table_Row) ProtoMessage()               {}
func (*Table_Row) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2, 0} }

func (m *Table_Row) GetValues() []*Value {
	if m != nil {
		return m.Values
	}
	return nil
}

// All the findings for a single scanned item.
type InspectResult struct {
	// List of findings for an item.
	Findings []*Finding `protobuf:"bytes,1,rep,name=findings" json:"findings,omitempty"`
	// If true, then this item might have more findings than were returned,
	// and the findings returned are an arbitrary subset of all findings.
	// The findings list might be truncated because the input items were too
	// large, or because the server reached the maximum amount of resources
	// allowed for a single API call. For best results, divide the input into
	// smaller batches.
	FindingsTruncated bool `protobuf:"varint,2,opt,name=findings_truncated,json=findingsTruncated" json:"findings_truncated,omitempty"`
}

func (m *InspectResult) Reset()                    { *m = InspectResult{} }
func (m *InspectResult) String() string            { return proto.CompactTextString(m) }
func (*InspectResult) ProtoMessage()               {}
func (*InspectResult) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *InspectResult) GetFindings() []*Finding {
	if m != nil {
		return m.Findings
	}
	return nil
}

func (m *InspectResult) GetFindingsTruncated() bool {
	if m != nil {
		return m.FindingsTruncated
	}
	return false
}

// Represents a piece of potentially sensitive content.
type Finding struct {
	// The content that was found. Even if the content is not textual, it
	// may be converted to a textual representation here.
	// Provided if requested by the `InspectConfig` and the finding is
	// less than or equal to 4096 bytes long. If the finding exceeds 4096 bytes
	// in length, the quote may be omitted.
	Quote string `protobuf:"bytes,1,opt,name=quote" json:"quote,omitempty"`
	// The type of content that might have been found.
	// Provided if requested by the `InspectConfig`.
	InfoType *InfoType `protobuf:"bytes,2,opt,name=info_type,json=infoType" json:"info_type,omitempty"`
	// Estimate of how likely it is that the `info_type` is correct.
	Likelihood Likelihood `protobuf:"varint,3,opt,name=likelihood,enum=google.privacy.dlp.v2beta2.Likelihood" json:"likelihood,omitempty"`
	// Where the content was found.
	Location *Location `protobuf:"bytes,4,opt,name=location" json:"location,omitempty"`
	// Timestamp when finding was detected.
	CreateTime *google_protobuf1.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime" json:"create_time,omitempty"`
	// InfoType-dependent details parsed from quote.
	QuoteInfo *QuoteInfo `protobuf:"bytes,7,opt,name=quote_info,json=quoteInfo" json:"quote_info,omitempty"`
}

func (m *Finding) Reset()                    { *m = Finding{} }
func (m *Finding) String() string            { return proto.CompactTextString(m) }
func (*Finding) ProtoMessage()               {}
func (*Finding) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *Finding) GetQuote() string {
	if m != nil {
		return m.Quote
	}
	return ""
}

func (m *Finding) GetInfoType() *InfoType {
	if m != nil {
		return m.InfoType
	}
	return nil
}

func (m *Finding) GetLikelihood() Likelihood {
	if m != nil {
		return m.Likelihood
	}
	return Likelihood_LIKELIHOOD_UNSPECIFIED
}

func (m *Finding) GetLocation() *Location {
	if m != nil {
		return m.Location
	}
	return nil
}

func (m *Finding) GetCreateTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Finding) GetQuoteInfo() *QuoteInfo {
	if m != nil {
		return m.QuoteInfo
	}
	return nil
}

// Specifies the location of the finding.
type Location struct {
	// Zero-based byte offsets delimiting the finding.
	// These are relative to the finding's containing element.
	// Note that when the content is not textual, this references
	// the UTF-8 encoded textual representation of the content.
	// Omitted if content is an image.
	ByteRange *Range `protobuf:"bytes,1,opt,name=byte_range,json=byteRange" json:"byte_range,omitempty"`
	// Unicode character offsets delimiting the finding.
	// These are relative to the finding's containing element.
	// Provided when the content is text.
	CodepointRange *Range `protobuf:"bytes,2,opt,name=codepoint_range,json=codepointRange" json:"codepoint_range,omitempty"`
	// The area within the image that contained the finding.
	// Provided when the content is an image.
	ImageBoxes []*ImageLocation `protobuf:"bytes,3,rep,name=image_boxes,json=imageBoxes" json:"image_boxes,omitempty"`
	// The pointer to the record in storage that contained the field the
	// finding was found in.
	// Provided when the finding's containing element is a property
	// of a storage object.
	RecordKey *RecordKey `protobuf:"bytes,4,opt,name=record_key,json=recordKey" json:"record_key,omitempty"`
	// The pointer to the property or cell that contained the finding.
	// Provided when the finding's containing element is a cell in a table
	// or a property of storage object.
	FieldId *FieldId `protobuf:"bytes,5,opt,name=field_id,json=fieldId" json:"field_id,omitempty"`
	// The pointer to the row of the table that contained the finding.
	// Provided when the finding's containing element is a cell of a table.
	TableLocation *TableLocation `protobuf:"bytes,6,opt,name=table_location,json=tableLocation" json:"table_location,omitempty"`
}

func (m *Location) Reset()                    { *m = Location{} }
func (m *Location) String() string            { return proto.CompactTextString(m) }
func (*Location) ProtoMessage()               {}
func (*Location) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *Location) GetByteRange() *Range {
	if m != nil {
		return m.ByteRange
	}
	return nil
}

func (m *Location) GetCodepointRange() *Range {
	if m != nil {
		return m.CodepointRange
	}
	return nil
}

func (m *Location) GetImageBoxes() []*ImageLocation {
	if m != nil {
		return m.ImageBoxes
	}
	return nil
}

func (m *Location) GetRecordKey() *RecordKey {
	if m != nil {
		return m.RecordKey
	}
	return nil
}

func (m *Location) GetFieldId() *FieldId {
	if m != nil {
		return m.FieldId
	}
	return nil
}

func (m *Location) GetTableLocation() *TableLocation {
	if m != nil {
		return m.TableLocation
	}
	return nil
}

// Location of a finding within a table.
type TableLocation struct {
	// The zero-based index of the row where the finding is located.
	RowIndex int64 `protobuf:"varint,1,opt,name=row_index,json=rowIndex" json:"row_index,omitempty"`
}

func (m *TableLocation) Reset()                    { *m = TableLocation{} }
func (m *TableLocation) String() string            { return proto.CompactTextString(m) }
func (*TableLocation) ProtoMessage()               {}
func (*TableLocation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *TableLocation) GetRowIndex() int64 {
	if m != nil {
		return m.RowIndex
	}
	return 0
}

// Generic half-open interval [start, end)
type Range struct {
	// Index of the first character of the range (inclusive).
	Start int64 `protobuf:"varint,1,opt,name=start" json:"start,omitempty"`
	// Index of the last character of the range (exclusive).
	End int64 `protobuf:"varint,2,opt,name=end" json:"end,omitempty"`
}

func (m *Range) Reset()                    { *m = Range{} }
func (m *Range) String() string            { return proto.CompactTextString(m) }
func (*Range) ProtoMessage()               {}
func (*Range) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *Range) GetStart() int64 {
	if m != nil {
		return m.Start
	}
	return 0
}

func (m *Range) GetEnd() int64 {
	if m != nil {
		return m.End
	}
	return 0
}

// Bounding box encompassing detected text within an image.
type ImageLocation struct {
	// Top coordinate of the bounding box. (0,0) is upper left.
	Top int32 `protobuf:"varint,1,opt,name=top" json:"top,omitempty"`
	// Left coordinate of the bounding box. (0,0) is upper left.
	Left int32 `protobuf:"varint,2,opt,name=left" json:"left,omitempty"`
	// Width of the bounding box in pixels.
	Width int32 `protobuf:"varint,3,opt,name=width" json:"width,omitempty"`
	// Height of the bounding box in pixels.
	Height int32 `protobuf:"varint,4,opt,name=height" json:"height,omitempty"`
}

func (m *ImageLocation) Reset()                    { *m = ImageLocation{} }
func (m *ImageLocation) String() string            { return proto.CompactTextString(m) }
func (*ImageLocation) ProtoMessage()               {}
func (*ImageLocation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *ImageLocation) GetTop() int32 {
	if m != nil {
		return m.Top
	}
	return 0
}

func (m *ImageLocation) GetLeft() int32 {
	if m != nil {
		return m.Left
	}
	return 0
}

func (m *ImageLocation) GetWidth() int32 {
	if m != nil {
		return m.Width
	}
	return 0
}

func (m *ImageLocation) GetHeight() int32 {
	if m != nil {
		return m.Height
	}
	return 0
}

// Request to search for potentially sensitive info in a list of items
// and replace it with a default or provided content.
type RedactImageRequest struct {
	// The parent resource name, for example projects/my-project-id.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Configuration for the inspector.
	InspectConfig *InspectConfig `protobuf:"bytes,2,opt,name=inspect_config,json=inspectConfig" json:"inspect_config,omitempty"`
	// Type of the content, as defined in Content-Type HTTP header.
	// Supported types are: PNG, JPEG, SVG, & BMP.
	ImageType string `protobuf:"bytes,3,opt,name=image_type,json=imageType" json:"image_type,omitempty"`
	// The bytes of the image to redact.
	ImageData []byte `protobuf:"bytes,4,opt,name=image_data,json=imageData,proto3" json:"image_data,omitempty"`
	// The configuration for specifying what content to redact from images.
	ImageRedactionConfigs []*RedactImageRequest_ImageRedactionConfig `protobuf:"bytes,5,rep,name=image_redaction_configs,json=imageRedactionConfigs" json:"image_redaction_configs,omitempty"`
}

func (m *RedactImageRequest) Reset()                    { *m = RedactImageRequest{} }
func (m *RedactImageRequest) String() string            { return proto.CompactTextString(m) }
func (*RedactImageRequest) ProtoMessage()               {}
func (*RedactImageRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *RedactImageRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *RedactImageRequest) GetInspectConfig() *InspectConfig {
	if m != nil {
		return m.InspectConfig
	}
	return nil
}

func (m *RedactImageRequest) GetImageType() string {
	if m != nil {
		return m.ImageType
	}
	return ""
}

func (m *RedactImageRequest) GetImageData() []byte {
	if m != nil {
		return m.ImageData
	}
	return nil
}

func (m *RedactImageRequest) GetImageRedactionConfigs() []*RedactImageRequest_ImageRedactionConfig {
	if m != nil {
		return m.ImageRedactionConfigs
	}
	return nil
}

// Configuration for determining how redaction of images should occur.
type RedactImageRequest_ImageRedactionConfig struct {
	// Type of information to redact from images.
	//
	// Types that are valid to be assigned to Target:
	//	*RedactImageRequest_ImageRedactionConfig_InfoType
	//	*RedactImageRequest_ImageRedactionConfig_RedactAllText
	Target isRedactImageRequest_ImageRedactionConfig_Target `protobuf_oneof:"target"`
	// The color to use when redacting content from an image. If not specified,
	// the default is black.
	RedactionColor *Color `protobuf:"bytes,3,opt,name=redaction_color,json=redactionColor" json:"redaction_color,omitempty"`
}

func (m *RedactImageRequest_ImageRedactionConfig) Reset() {
	*m = RedactImageRequest_ImageRedactionConfig{}
}
func (m *RedactImageRequest_ImageRedactionConfig) String() string { return proto.CompactTextString(m) }
func (*RedactImageRequest_ImageRedactionConfig) ProtoMessage()    {}
func (*RedactImageRequest_ImageRedactionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{9, 0}
}

type isRedactImageRequest_ImageRedactionConfig_Target interface {
	isRedactImageRequest_ImageRedactionConfig_Target()
}

type RedactImageRequest_ImageRedactionConfig_InfoType struct {
	InfoType *InfoType `protobuf:"bytes,1,opt,name=info_type,json=infoType,oneof"`
}
type RedactImageRequest_ImageRedactionConfig_RedactAllText struct {
	RedactAllText bool `protobuf:"varint,2,opt,name=redact_all_text,json=redactAllText,oneof"`
}

func (*RedactImageRequest_ImageRedactionConfig_InfoType) isRedactImageRequest_ImageRedactionConfig_Target() {
}
func (*RedactImageRequest_ImageRedactionConfig_RedactAllText) isRedactImageRequest_ImageRedactionConfig_Target() {
}

func (m *RedactImageRequest_ImageRedactionConfig) GetTarget() isRedactImageRequest_ImageRedactionConfig_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *RedactImageRequest_ImageRedactionConfig) GetInfoType() *InfoType {
	if x, ok := m.GetTarget().(*RedactImageRequest_ImageRedactionConfig_InfoType); ok {
		return x.InfoType
	}
	return nil
}

func (m *RedactImageRequest_ImageRedactionConfig) GetRedactAllText() bool {
	if x, ok := m.GetTarget().(*RedactImageRequest_ImageRedactionConfig_RedactAllText); ok {
		return x.RedactAllText
	}
	return false
}

func (m *RedactImageRequest_ImageRedactionConfig) GetRedactionColor() *Color {
	if m != nil {
		return m.RedactionColor
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RedactImageRequest_ImageRedactionConfig) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RedactImageRequest_ImageRedactionConfig_OneofMarshaler, _RedactImageRequest_ImageRedactionConfig_OneofUnmarshaler, _RedactImageRequest_ImageRedactionConfig_OneofSizer, []interface{}{
		(*RedactImageRequest_ImageRedactionConfig_InfoType)(nil),
		(*RedactImageRequest_ImageRedactionConfig_RedactAllText)(nil),
	}
}

func _RedactImageRequest_ImageRedactionConfig_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RedactImageRequest_ImageRedactionConfig)
	// target
	switch x := m.Target.(type) {
	case *RedactImageRequest_ImageRedactionConfig_InfoType:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.InfoType); err != nil {
			return err
		}
	case *RedactImageRequest_ImageRedactionConfig_RedactAllText:
		t := uint64(0)
		if x.RedactAllText {
			t = 1
		}
		b.EncodeVarint(2<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case nil:
	default:
		return fmt.Errorf("RedactImageRequest_ImageRedactionConfig.Target has unexpected type %T", x)
	}
	return nil
}

func _RedactImageRequest_ImageRedactionConfig_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RedactImageRequest_ImageRedactionConfig)
	switch tag {
	case 1: // target.info_type
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(InfoType)
		err := b.DecodeMessage(msg)
		m.Target = &RedactImageRequest_ImageRedactionConfig_InfoType{msg}
		return true, err
	case 2: // target.redact_all_text
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Target = &RedactImageRequest_ImageRedactionConfig_RedactAllText{x != 0}
		return true, err
	default:
		return false, nil
	}
}

func _RedactImageRequest_ImageRedactionConfig_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RedactImageRequest_ImageRedactionConfig)
	// target
	switch x := m.Target.(type) {
	case *RedactImageRequest_ImageRedactionConfig_InfoType:
		s := proto.Size(x.InfoType)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RedactImageRequest_ImageRedactionConfig_RedactAllText:
		n += proto.SizeVarint(2<<3 | proto.WireVarint)
		n += 1
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Represents a color in the RGB color space.
type Color struct {
	// The amount of red in the color as a value in the interval [0, 1].
	Red float32 `protobuf:"fixed32,1,opt,name=red" json:"red,omitempty"`
	// The amount of green in the color as a value in the interval [0, 1].
	Green float32 `protobuf:"fixed32,2,opt,name=green" json:"green,omitempty"`
	// The amount of blue in the color as a value in the interval [0, 1].
	Blue float32 `protobuf:"fixed32,3,opt,name=blue" json:"blue,omitempty"`
}

func (m *Color) Reset()                    { *m = Color{} }
func (m *Color) String() string            { return proto.CompactTextString(m) }
func (*Color) ProtoMessage()               {}
func (*Color) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *Color) GetRed() float32 {
	if m != nil {
		return m.Red
	}
	return 0
}

func (m *Color) GetGreen() float32 {
	if m != nil {
		return m.Green
	}
	return 0
}

func (m *Color) GetBlue() float32 {
	if m != nil {
		return m.Blue
	}
	return 0
}

// Results of redacting an image.
type RedactImageResponse struct {
	// The redacted image. The type will be the same as the original image.
	RedactedImage []byte `protobuf:"bytes,1,opt,name=redacted_image,json=redactedImage,proto3" json:"redacted_image,omitempty"`
	// If an image was being inspected and the InspectConfig's include_quote was
	// set to true, then this field will include all text, if any, that was found
	// in the image.
	ExtractedText string `protobuf:"bytes,2,opt,name=extracted_text,json=extractedText" json:"extracted_text,omitempty"`
}

func (m *RedactImageResponse) Reset()                    { *m = RedactImageResponse{} }
func (m *RedactImageResponse) String() string            { return proto.CompactTextString(m) }
func (*RedactImageResponse) ProtoMessage()               {}
func (*RedactImageResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *RedactImageResponse) GetRedactedImage() []byte {
	if m != nil {
		return m.RedactedImage
	}
	return nil
}

func (m *RedactImageResponse) GetExtractedText() string {
	if m != nil {
		return m.ExtractedText
	}
	return ""
}

// Request to de-identify a list of items.
type DeidentifyContentRequest struct {
	// The parent resource name, for example projects/my-project-id.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Configuration for the de-identification of the content item.
	// Items specified here will override the template referenced by the
	// deidentify_template_name argument.
	DeidentifyConfig *DeidentifyConfig `protobuf:"bytes,2,opt,name=deidentify_config,json=deidentifyConfig" json:"deidentify_config,omitempty"`
	// Configuration for the inspector.
	// Items specified here will override the template referenced by the
	// inspect_template_name argument.
	InspectConfig *InspectConfig `protobuf:"bytes,3,opt,name=inspect_config,json=inspectConfig" json:"inspect_config,omitempty"`
	// The item to de-identify. Will be treated as text.
	Item *ContentItem `protobuf:"bytes,4,opt,name=item" json:"item,omitempty"`
	// Optional template to use. Any configuration directly specified in
	// inspect_config will override those set in the template. Singular fields
	// that are set in this request will replace their corresponding fields in the
	// template. Repeated fields are appended. Singular sub-messages and groups
	// are recursively merged.
	InspectTemplateName string `protobuf:"bytes,5,opt,name=inspect_template_name,json=inspectTemplateName" json:"inspect_template_name,omitempty"`
	// Optional template to use. Any configuration directly specified in
	// deidentify_config will override those set in the template. Singular fields
	// that are set in this request will replace their corresponding fields in the
	// template. Repeated fields are appended. Singular sub-messages and groups
	// are recursively merged.
	DeidentifyTemplateName string `protobuf:"bytes,6,opt,name=deidentify_template_name,json=deidentifyTemplateName" json:"deidentify_template_name,omitempty"`
}

func (m *DeidentifyContentRequest) Reset()                    { *m = DeidentifyContentRequest{} }
func (m *DeidentifyContentRequest) String() string            { return proto.CompactTextString(m) }
func (*DeidentifyContentRequest) ProtoMessage()               {}
func (*DeidentifyContentRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *DeidentifyContentRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *DeidentifyContentRequest) GetDeidentifyConfig() *DeidentifyConfig {
	if m != nil {
		return m.DeidentifyConfig
	}
	return nil
}

func (m *DeidentifyContentRequest) GetInspectConfig() *InspectConfig {
	if m != nil {
		return m.InspectConfig
	}
	return nil
}

func (m *DeidentifyContentRequest) GetItem() *ContentItem {
	if m != nil {
		return m.Item
	}
	return nil
}

func (m *DeidentifyContentRequest) GetInspectTemplateName() string {
	if m != nil {
		return m.InspectTemplateName
	}
	return ""
}

func (m *DeidentifyContentRequest) GetDeidentifyTemplateName() string {
	if m != nil {
		return m.DeidentifyTemplateName
	}
	return ""
}

// Results of de-identifying a ContentItem.
type DeidentifyContentResponse struct {
	// The de-identified item.
	Item *ContentItem `protobuf:"bytes,1,opt,name=item" json:"item,omitempty"`
	// An overview of the changes that were made on the `item`.
	Overview *TransformationOverview `protobuf:"bytes,2,opt,name=overview" json:"overview,omitempty"`
}

func (m *DeidentifyContentResponse) Reset()                    { *m = DeidentifyContentResponse{} }
func (m *DeidentifyContentResponse) String() string            { return proto.CompactTextString(m) }
func (*DeidentifyContentResponse) ProtoMessage()               {}
func (*DeidentifyContentResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *DeidentifyContentResponse) GetItem() *ContentItem {
	if m != nil {
		return m.Item
	}
	return nil
}

func (m *DeidentifyContentResponse) GetOverview() *TransformationOverview {
	if m != nil {
		return m.Overview
	}
	return nil
}

// Request to re-identify an item.
type ReidentifyContentRequest struct {
	// The parent resource name.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Configuration for the re-identification of the content item.
	// This field shares the same proto message type that is used for
	// de-identification, however its usage here is for the reversal of the
	// previous de-identification. Re-identification is performed by examining
	// the transformations used to de-identify the items and executing the
	// reverse. This requires that only reversible transformations
	// be provided here. The reversible transformations are:
	//
	//  - `CryptoReplaceFfxFpeConfig`
	ReidentifyConfig *DeidentifyConfig `protobuf:"bytes,2,opt,name=reidentify_config,json=reidentifyConfig" json:"reidentify_config,omitempty"`
	// Configuration for the inspector.
	InspectConfig *InspectConfig `protobuf:"bytes,3,opt,name=inspect_config,json=inspectConfig" json:"inspect_config,omitempty"`
	// The item to re-identify. Will be treated as text.
	Item *ContentItem `protobuf:"bytes,4,opt,name=item" json:"item,omitempty"`
	// Optional template to use. Any configuration directly specified in
	// `inspect_config` will override those set in the template. Singular fields
	// that are set in this request will replace their corresponding fields in the
	// template. Repeated fields are appended. Singular sub-messages and groups
	// are recursively merged.
	InspectTemplateName string `protobuf:"bytes,5,opt,name=inspect_template_name,json=inspectTemplateName" json:"inspect_template_name,omitempty"`
	// Optional template to use. References an instance of `DeidentifyTemplate`.
	// Any configuration directly specified in `reidentify_config` or
	// `inspect_config` will override those set in the template. Singular fields
	// that are set in this request will replace their corresponding fields in the
	// template. Repeated fields are appended. Singular sub-messages and groups
	// are recursively merged.
	ReidentifyTemplateName string `protobuf:"bytes,6,opt,name=reidentify_template_name,json=reidentifyTemplateName" json:"reidentify_template_name,omitempty"`
}

func (m *ReidentifyContentRequest) Reset()                    { *m = ReidentifyContentRequest{} }
func (m *ReidentifyContentRequest) String() string            { return proto.CompactTextString(m) }
func (*ReidentifyContentRequest) ProtoMessage()               {}
func (*ReidentifyContentRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *ReidentifyContentRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ReidentifyContentRequest) GetReidentifyConfig() *DeidentifyConfig {
	if m != nil {
		return m.ReidentifyConfig
	}
	return nil
}

func (m *ReidentifyContentRequest) GetInspectConfig() *InspectConfig {
	if m != nil {
		return m.InspectConfig
	}
	return nil
}

func (m *ReidentifyContentRequest) GetItem() *ContentItem {
	if m != nil {
		return m.Item
	}
	return nil
}

func (m *ReidentifyContentRequest) GetInspectTemplateName() string {
	if m != nil {
		return m.InspectTemplateName
	}
	return ""
}

func (m *ReidentifyContentRequest) GetReidentifyTemplateName() string {
	if m != nil {
		return m.ReidentifyTemplateName
	}
	return ""
}

// Results of re-identifying a item.
type ReidentifyContentResponse struct {
	// The re-identified item.
	Item *ContentItem `protobuf:"bytes,1,opt,name=item" json:"item,omitempty"`
	// An overview of the changes that were made to the `item`.
	Overview *TransformationOverview `protobuf:"bytes,2,opt,name=overview" json:"overview,omitempty"`
}

func (m *ReidentifyContentResponse) Reset()                    { *m = ReidentifyContentResponse{} }
func (m *ReidentifyContentResponse) String() string            { return proto.CompactTextString(m) }
func (*ReidentifyContentResponse) ProtoMessage()               {}
func (*ReidentifyContentResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *ReidentifyContentResponse) GetItem() *ContentItem {
	if m != nil {
		return m.Item
	}
	return nil
}

func (m *ReidentifyContentResponse) GetOverview() *TransformationOverview {
	if m != nil {
		return m.Overview
	}
	return nil
}

// Request to search for potentially sensitive info in a ContentItem.
type InspectContentRequest struct {
	// The parent resource name, for example projects/my-project-id.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Configuration for the inspector. What specified here will override
	// the template referenced by the inspect_template_name argument.
	InspectConfig *InspectConfig `protobuf:"bytes,2,opt,name=inspect_config,json=inspectConfig" json:"inspect_config,omitempty"`
	// The item to inspect.
	Item *ContentItem `protobuf:"bytes,3,opt,name=item" json:"item,omitempty"`
	// Optional template to use. Any configuration directly specified in
	// inspect_config will override those set in the template. Singular fields
	// that are set in this request will replace their corresponding fields in the
	// template. Repeated fields are appended. Singular sub-messages and groups
	// are recursively merged.
	InspectTemplateName string `protobuf:"bytes,4,opt,name=inspect_template_name,json=inspectTemplateName" json:"inspect_template_name,omitempty"`
}

func (m *InspectContentRequest) Reset()                    { *m = InspectContentRequest{} }
func (m *InspectContentRequest) String() string            { return proto.CompactTextString(m) }
func (*InspectContentRequest) ProtoMessage()               {}
func (*InspectContentRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *InspectContentRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *InspectContentRequest) GetInspectConfig() *InspectConfig {
	if m != nil {
		return m.InspectConfig
	}
	return nil
}

func (m *InspectContentRequest) GetItem() *ContentItem {
	if m != nil {
		return m.Item
	}
	return nil
}

func (m *InspectContentRequest) GetInspectTemplateName() string {
	if m != nil {
		return m.InspectTemplateName
	}
	return ""
}

// Results of inspecting an item.
type InspectContentResponse struct {
	// The findings.
	Result *InspectResult `protobuf:"bytes,1,opt,name=result" json:"result,omitempty"`
}

func (m *InspectContentResponse) Reset()                    { *m = InspectContentResponse{} }
func (m *InspectContentResponse) String() string            { return proto.CompactTextString(m) }
func (*InspectContentResponse) ProtoMessage()               {}
func (*InspectContentResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *InspectContentResponse) GetResult() *InspectResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// Request for scheduling a scan of a data subset from a Google Platform data
// repository.
type InspectDataSourceRequest struct {
	// The parent resource name, for example projects/my-project-id.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// A configuration for the job.
	JobConfig *InspectJobConfig `protobuf:"bytes,2,opt,name=job_config,json=jobConfig" json:"job_config,omitempty"`
	// Optional job ID to use for the created job. If not provided, a job ID will
	// automatically be generated. Must be unique within the project. The job ID
	// can contain uppercase and lowercase letters, numbers, and hyphens; that is,
	// it must match the regular expression: `[a-zA-Z\\d-]+`. The maximum length
	// is 100 characters. Can be empty to allow the system to generate one.
	JobId string `protobuf:"bytes,3,opt,name=job_id,json=jobId" json:"job_id,omitempty"`
}

func (m *InspectDataSourceRequest) Reset()                    { *m = InspectDataSourceRequest{} }
func (m *InspectDataSourceRequest) String() string            { return proto.CompactTextString(m) }
func (*InspectDataSourceRequest) ProtoMessage()               {}
func (*InspectDataSourceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *InspectDataSourceRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *InspectDataSourceRequest) GetJobConfig() *InspectJobConfig {
	if m != nil {
		return m.JobConfig
	}
	return nil
}

func (m *InspectDataSourceRequest) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

// Cloud repository for storing output.
type OutputStorageConfig struct {
	// Types that are valid to be assigned to Type:
	//	*OutputStorageConfig_Table
	Type isOutputStorageConfig_Type `protobuf_oneof:"type"`
	// Schema used for writing the findings. Columns are derived from the
	// `Finding` object. If appending to an existing table, any columns from the
	// predefined schema that are missing will be added. No columns in the
	// existing table will be deleted.
	//
	// If unspecified, then all available columns will be used for a new table,
	// and no changes will be made to an existing table.
	OutputSchema OutputStorageConfig_OutputSchema `protobuf:"varint,3,opt,name=output_schema,json=outputSchema,enum=google.privacy.dlp.v2beta2.OutputStorageConfig_OutputSchema" json:"output_schema,omitempty"`
}

func (m *OutputStorageConfig) Reset()                    { *m = OutputStorageConfig{} }
func (m *OutputStorageConfig) String() string            { return proto.CompactTextString(m) }
func (*OutputStorageConfig) ProtoMessage()               {}
func (*OutputStorageConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

type isOutputStorageConfig_Type interface {
	isOutputStorageConfig_Type()
}

type OutputStorageConfig_Table struct {
	Table *BigQueryTable `protobuf:"bytes,1,opt,name=table,oneof"`
}

func (*OutputStorageConfig_Table) isOutputStorageConfig_Type() {}

func (m *OutputStorageConfig) GetType() isOutputStorageConfig_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *OutputStorageConfig) GetTable() *BigQueryTable {
	if x, ok := m.GetType().(*OutputStorageConfig_Table); ok {
		return x.Table
	}
	return nil
}

func (m *OutputStorageConfig) GetOutputSchema() OutputStorageConfig_OutputSchema {
	if m != nil {
		return m.OutputSchema
	}
	return OutputStorageConfig_OUTPUT_SCHEMA_UNSPECIFIED
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*OutputStorageConfig) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _OutputStorageConfig_OneofMarshaler, _OutputStorageConfig_OneofUnmarshaler, _OutputStorageConfig_OneofSizer, []interface{}{
		(*OutputStorageConfig_Table)(nil),
	}
}

func _OutputStorageConfig_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*OutputStorageConfig)
	// type
	switch x := m.Type.(type) {
	case *OutputStorageConfig_Table:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Table); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("OutputStorageConfig.Type has unexpected type %T", x)
	}
	return nil
}

func _OutputStorageConfig_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*OutputStorageConfig)
	switch tag {
	case 1: // type.table
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(BigQueryTable)
		err := b.DecodeMessage(msg)
		m.Type = &OutputStorageConfig_Table{msg}
		return true, err
	default:
		return false, nil
	}
}

func _OutputStorageConfig_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*OutputStorageConfig)
	// type
	switch x := m.Type.(type) {
	case *OutputStorageConfig_Table:
		s := proto.Size(x.Table)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Statistics regarding a specific InfoType.
type InfoTypeStatistics struct {
	// The type of finding this stat is for.
	InfoType *InfoType `protobuf:"bytes,1,opt,name=info_type,json=infoType" json:"info_type,omitempty"`
	// Number of findings for this infoType.
	Count int64 `protobuf:"varint,2,opt,name=count" json:"count,omitempty"`
}

func (m *InfoTypeStatistics) Reset()                    { *m = InfoTypeStatistics{} }
func (m *InfoTypeStatistics) String() string            { return proto.CompactTextString(m) }
func (*InfoTypeStatistics) ProtoMessage()               {}
func (*InfoTypeStatistics) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *InfoTypeStatistics) GetInfoType() *InfoType {
	if m != nil {
		return m.InfoType
	}
	return nil
}

func (m *InfoTypeStatistics) GetCount() int64 {
	if m != nil {
		return m.Count
	}
	return 0
}

// The results of an inspect DataSource job.
type InspectDataSourceDetails struct {
	// The configuration used for this job.
	RequestedOptions *InspectDataSourceDetails_RequestedOptions `protobuf:"bytes,2,opt,name=requested_options,json=requestedOptions" json:"requested_options,omitempty"`
	// A summary of the outcome of this inspect job.
	Result *InspectDataSourceDetails_Result `protobuf:"bytes,3,opt,name=result" json:"result,omitempty"`
}

func (m *InspectDataSourceDetails) Reset()                    { *m = InspectDataSourceDetails{} }
func (m *InspectDataSourceDetails) String() string            { return proto.CompactTextString(m) }
func (*InspectDataSourceDetails) ProtoMessage()               {}
func (*InspectDataSourceDetails) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *InspectDataSourceDetails) GetRequestedOptions() *InspectDataSourceDetails_RequestedOptions {
	if m != nil {
		return m.RequestedOptions
	}
	return nil
}

func (m *InspectDataSourceDetails) GetResult() *InspectDataSourceDetails_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

type InspectDataSourceDetails_RequestedOptions struct {
	// If run with an inspect template, a snapshot of it's state at the time of
	// this run.
	SnapshotInspectTemplate *InspectTemplate  `protobuf:"bytes,1,opt,name=snapshot_inspect_template,json=snapshotInspectTemplate" json:"snapshot_inspect_template,omitempty"`
	JobConfig               *InspectJobConfig `protobuf:"bytes,3,opt,name=job_config,json=jobConfig" json:"job_config,omitempty"`
}

func (m *InspectDataSourceDetails_RequestedOptions) Reset() {
	*m = InspectDataSourceDetails_RequestedOptions{}
}
func (m *InspectDataSourceDetails_RequestedOptions) String() string { return proto.CompactTextString(m) }
func (*InspectDataSourceDetails_RequestedOptions) ProtoMessage()    {}
func (*InspectDataSourceDetails_RequestedOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{21, 0}
}

func (m *InspectDataSourceDetails_RequestedOptions) GetSnapshotInspectTemplate() *InspectTemplate {
	if m != nil {
		return m.SnapshotInspectTemplate
	}
	return nil
}

func (m *InspectDataSourceDetails_RequestedOptions) GetJobConfig() *InspectJobConfig {
	if m != nil {
		return m.JobConfig
	}
	return nil
}

type InspectDataSourceDetails_Result struct {
	// Total size in bytes that were processed.
	ProcessedBytes int64 `protobuf:"varint,1,opt,name=processed_bytes,json=processedBytes" json:"processed_bytes,omitempty"`
	// Estimate of the number of bytes to process.
	TotalEstimatedBytes int64 `protobuf:"varint,2,opt,name=total_estimated_bytes,json=totalEstimatedBytes" json:"total_estimated_bytes,omitempty"`
	// Statistics of how many instances of each info type were found during
	// inspect job.
	InfoTypeStats []*InfoTypeStatistics `protobuf:"bytes,3,rep,name=info_type_stats,json=infoTypeStats" json:"info_type_stats,omitempty"`
}

func (m *InspectDataSourceDetails_Result) Reset()         { *m = InspectDataSourceDetails_Result{} }
func (m *InspectDataSourceDetails_Result) String() string { return proto.CompactTextString(m) }
func (*InspectDataSourceDetails_Result) ProtoMessage()    {}
func (*InspectDataSourceDetails_Result) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{21, 1}
}

func (m *InspectDataSourceDetails_Result) GetProcessedBytes() int64 {
	if m != nil {
		return m.ProcessedBytes
	}
	return 0
}

func (m *InspectDataSourceDetails_Result) GetTotalEstimatedBytes() int64 {
	if m != nil {
		return m.TotalEstimatedBytes
	}
	return 0
}

func (m *InspectDataSourceDetails_Result) GetInfoTypeStats() []*InfoTypeStatistics {
	if m != nil {
		return m.InfoTypeStats
	}
	return nil
}

// InfoType description.
type InfoTypeDescription struct {
	// Internal name of the infoType.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Human readable form of the infoType name.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
	// Which parts of the API supports this InfoType.
	SupportedBy []InfoTypeSupportedBy `protobuf:"varint,3,rep,packed,name=supported_by,json=supportedBy,enum=google.privacy.dlp.v2beta2.InfoTypeSupportedBy" json:"supported_by,omitempty"`
}

func (m *InfoTypeDescription) Reset()                    { *m = InfoTypeDescription{} }
func (m *InfoTypeDescription) String() string            { return proto.CompactTextString(m) }
func (*InfoTypeDescription) ProtoMessage()               {}
func (*InfoTypeDescription) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *InfoTypeDescription) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *InfoTypeDescription) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *InfoTypeDescription) GetSupportedBy() []InfoTypeSupportedBy {
	if m != nil {
		return m.SupportedBy
	}
	return nil
}

// Request for the list of infoTypes.
type ListInfoTypesRequest struct {
	// Optional BCP-47 language code for localized infoType friendly
	// names. If omitted, or if localized strings are not available,
	// en-US strings will be returned.
	LanguageCode string `protobuf:"bytes,1,opt,name=language_code,json=languageCode" json:"language_code,omitempty"`
	// Optional filter to only return infoTypes supported by certain parts of the
	// API. Defaults to supported_by=INSPECT.
	Filter string `protobuf:"bytes,2,opt,name=filter" json:"filter,omitempty"`
}

func (m *ListInfoTypesRequest) Reset()                    { *m = ListInfoTypesRequest{} }
func (m *ListInfoTypesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListInfoTypesRequest) ProtoMessage()               {}
func (*ListInfoTypesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

func (m *ListInfoTypesRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *ListInfoTypesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

// Response to the ListInfoTypes request.
type ListInfoTypesResponse struct {
	// Set of sensitive infoTypes.
	InfoTypes []*InfoTypeDescription `protobuf:"bytes,1,rep,name=info_types,json=infoTypes" json:"info_types,omitempty"`
}

func (m *ListInfoTypesResponse) Reset()                    { *m = ListInfoTypesResponse{} }
func (m *ListInfoTypesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListInfoTypesResponse) ProtoMessage()               {}
func (*ListInfoTypesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{24} }

func (m *ListInfoTypesResponse) GetInfoTypes() []*InfoTypeDescription {
	if m != nil {
		return m.InfoTypes
	}
	return nil
}

// Request for creating a risk analysis DlpJob.
type AnalyzeDataSourceRiskRequest struct {
	// The parent resource name, for example projects/my-project-id.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Configuration for this risk analysis job.
	JobConfig *RiskAnalysisJobConfig `protobuf:"bytes,2,opt,name=job_config,json=jobConfig" json:"job_config,omitempty"`
	// Optional job ID to use for the created job. If not provided, a job ID will
	// automatically be generated. Must be unique within the project. The job ID
	// can contain uppercase and lowercase letters, numbers, and hyphens; that is,
	// it must match the regular expression: `[a-zA-Z\\d-]+`. The maximum length
	// is 100 characters. Can be empty to allow the system to generate one.
	JobId string `protobuf:"bytes,3,opt,name=job_id,json=jobId" json:"job_id,omitempty"`
}

func (m *AnalyzeDataSourceRiskRequest) Reset()                    { *m = AnalyzeDataSourceRiskRequest{} }
func (m *AnalyzeDataSourceRiskRequest) String() string            { return proto.CompactTextString(m) }
func (*AnalyzeDataSourceRiskRequest) ProtoMessage()               {}
func (*AnalyzeDataSourceRiskRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{25} }

func (m *AnalyzeDataSourceRiskRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *AnalyzeDataSourceRiskRequest) GetJobConfig() *RiskAnalysisJobConfig {
	if m != nil {
		return m.JobConfig
	}
	return nil
}

func (m *AnalyzeDataSourceRiskRequest) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

// Configuration for a risk analysis job.
type RiskAnalysisJobConfig struct {
	// Privacy metric to compute.
	PrivacyMetric *PrivacyMetric `protobuf:"bytes,1,opt,name=privacy_metric,json=privacyMetric" json:"privacy_metric,omitempty"`
	// Input dataset to compute metrics over.
	SourceTable *BigQueryTable `protobuf:"bytes,2,opt,name=source_table,json=sourceTable" json:"source_table,omitempty"`
	// Actions to execute at the completion of the job. Are executed in the order
	// provided.
	Actions []*Action `protobuf:"bytes,3,rep,name=actions" json:"actions,omitempty"`
}

func (m *RiskAnalysisJobConfig) Reset()                    { *m = RiskAnalysisJobConfig{} }
func (m *RiskAnalysisJobConfig) String() string            { return proto.CompactTextString(m) }
func (*RiskAnalysisJobConfig) ProtoMessage()               {}
func (*RiskAnalysisJobConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{26} }

func (m *RiskAnalysisJobConfig) GetPrivacyMetric() *PrivacyMetric {
	if m != nil {
		return m.PrivacyMetric
	}
	return nil
}

func (m *RiskAnalysisJobConfig) GetSourceTable() *BigQueryTable {
	if m != nil {
		return m.SourceTable
	}
	return nil
}

func (m *RiskAnalysisJobConfig) GetActions() []*Action {
	if m != nil {
		return m.Actions
	}
	return nil
}

// Privacy metric to compute for reidentification risk analysis.
type PrivacyMetric struct {
	// Types that are valid to be assigned to Type:
	//	*PrivacyMetric_NumericalStatsConfig_
	//	*PrivacyMetric_CategoricalStatsConfig_
	//	*PrivacyMetric_KAnonymityConfig_
	//	*PrivacyMetric_LDiversityConfig_
	//	*PrivacyMetric_KMapEstimationConfig_
	Type isPrivacyMetric_Type `protobuf_oneof:"type"`
}

func (m *PrivacyMetric) Reset()                    { *m = PrivacyMetric{} }
func (m *PrivacyMetric) String() string            { return proto.CompactTextString(m) }
func (*PrivacyMetric) ProtoMessage()               {}
func (*PrivacyMetric) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{27} }

type isPrivacyMetric_Type interface {
	isPrivacyMetric_Type()
}

type PrivacyMetric_NumericalStatsConfig_ struct {
	NumericalStatsConfig *PrivacyMetric_NumericalStatsConfig `protobuf:"bytes,1,opt,name=numerical_stats_config,json=numericalStatsConfig,oneof"`
}
type PrivacyMetric_CategoricalStatsConfig_ struct {
	CategoricalStatsConfig *PrivacyMetric_CategoricalStatsConfig `protobuf:"bytes,2,opt,name=categorical_stats_config,json=categoricalStatsConfig,oneof"`
}
type PrivacyMetric_KAnonymityConfig_ struct {
	KAnonymityConfig *PrivacyMetric_KAnonymityConfig `protobuf:"bytes,3,opt,name=k_anonymity_config,json=kAnonymityConfig,oneof"`
}
type PrivacyMetric_LDiversityConfig_ struct {
	LDiversityConfig *PrivacyMetric_LDiversityConfig `protobuf:"bytes,4,opt,name=l_diversity_config,json=lDiversityConfig,oneof"`
}
type PrivacyMetric_KMapEstimationConfig_ struct {
	KMapEstimationConfig *PrivacyMetric_KMapEstimationConfig `protobuf:"bytes,5,opt,name=k_map_estimation_config,json=kMapEstimationConfig,oneof"`
}

func (*PrivacyMetric_NumericalStatsConfig_) isPrivacyMetric_Type()   {}
func (*PrivacyMetric_CategoricalStatsConfig_) isPrivacyMetric_Type() {}
func (*PrivacyMetric_KAnonymityConfig_) isPrivacyMetric_Type()       {}
func (*PrivacyMetric_LDiversityConfig_) isPrivacyMetric_Type()       {}
func (*PrivacyMetric_KMapEstimationConfig_) isPrivacyMetric_Type()   {}

func (m *PrivacyMetric) GetType() isPrivacyMetric_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *PrivacyMetric) GetNumericalStatsConfig() *PrivacyMetric_NumericalStatsConfig {
	if x, ok := m.GetType().(*PrivacyMetric_NumericalStatsConfig_); ok {
		return x.NumericalStatsConfig
	}
	return nil
}

func (m *PrivacyMetric) GetCategoricalStatsConfig() *PrivacyMetric_CategoricalStatsConfig {
	if x, ok := m.GetType().(*PrivacyMetric_CategoricalStatsConfig_); ok {
		return x.CategoricalStatsConfig
	}
	return nil
}

func (m *PrivacyMetric) GetKAnonymityConfig() *PrivacyMetric_KAnonymityConfig {
	if x, ok := m.GetType().(*PrivacyMetric_KAnonymityConfig_); ok {
		return x.KAnonymityConfig
	}
	return nil
}

func (m *PrivacyMetric) GetLDiversityConfig() *PrivacyMetric_LDiversityConfig {
	if x, ok := m.GetType().(*PrivacyMetric_LDiversityConfig_); ok {
		return x.LDiversityConfig
	}
	return nil
}

func (m *PrivacyMetric) GetKMapEstimationConfig() *PrivacyMetric_KMapEstimationConfig {
	if x, ok := m.GetType().(*PrivacyMetric_KMapEstimationConfig_); ok {
		return x.KMapEstimationConfig
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*PrivacyMetric) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _PrivacyMetric_OneofMarshaler, _PrivacyMetric_OneofUnmarshaler, _PrivacyMetric_OneofSizer, []interface{}{
		(*PrivacyMetric_NumericalStatsConfig_)(nil),
		(*PrivacyMetric_CategoricalStatsConfig_)(nil),
		(*PrivacyMetric_KAnonymityConfig_)(nil),
		(*PrivacyMetric_LDiversityConfig_)(nil),
		(*PrivacyMetric_KMapEstimationConfig_)(nil),
	}
}

func _PrivacyMetric_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*PrivacyMetric)
	// type
	switch x := m.Type.(type) {
	case *PrivacyMetric_NumericalStatsConfig_:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.NumericalStatsConfig); err != nil {
			return err
		}
	case *PrivacyMetric_CategoricalStatsConfig_:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CategoricalStatsConfig); err != nil {
			return err
		}
	case *PrivacyMetric_KAnonymityConfig_:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.KAnonymityConfig); err != nil {
			return err
		}
	case *PrivacyMetric_LDiversityConfig_:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.LDiversityConfig); err != nil {
			return err
		}
	case *PrivacyMetric_KMapEstimationConfig_:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.KMapEstimationConfig); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("PrivacyMetric.Type has unexpected type %T", x)
	}
	return nil
}

func _PrivacyMetric_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*PrivacyMetric)
	switch tag {
	case 1: // type.numerical_stats_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PrivacyMetric_NumericalStatsConfig)
		err := b.DecodeMessage(msg)
		m.Type = &PrivacyMetric_NumericalStatsConfig_{msg}
		return true, err
	case 2: // type.categorical_stats_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PrivacyMetric_CategoricalStatsConfig)
		err := b.DecodeMessage(msg)
		m.Type = &PrivacyMetric_CategoricalStatsConfig_{msg}
		return true, err
	case 3: // type.k_anonymity_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PrivacyMetric_KAnonymityConfig)
		err := b.DecodeMessage(msg)
		m.Type = &PrivacyMetric_KAnonymityConfig_{msg}
		return true, err
	case 4: // type.l_diversity_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PrivacyMetric_LDiversityConfig)
		err := b.DecodeMessage(msg)
		m.Type = &PrivacyMetric_LDiversityConfig_{msg}
		return true, err
	case 5: // type.k_map_estimation_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PrivacyMetric_KMapEstimationConfig)
		err := b.DecodeMessage(msg)
		m.Type = &PrivacyMetric_KMapEstimationConfig_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _PrivacyMetric_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*PrivacyMetric)
	// type
	switch x := m.Type.(type) {
	case *PrivacyMetric_NumericalStatsConfig_:
		s := proto.Size(x.NumericalStatsConfig)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *PrivacyMetric_CategoricalStatsConfig_:
		s := proto.Size(x.CategoricalStatsConfig)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *PrivacyMetric_KAnonymityConfig_:
		s := proto.Size(x.KAnonymityConfig)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *PrivacyMetric_LDiversityConfig_:
		s := proto.Size(x.LDiversityConfig)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *PrivacyMetric_KMapEstimationConfig_:
		s := proto.Size(x.KMapEstimationConfig)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Compute numerical stats over an individual column, including
// min, max, and quantiles.
type PrivacyMetric_NumericalStatsConfig struct {
	// Field to compute numerical stats on. Supported types are
	// integer, float, date, datetime, timestamp, time.
	Field *FieldId `protobuf:"bytes,1,opt,name=field" json:"field,omitempty"`
}

func (m *PrivacyMetric_NumericalStatsConfig) Reset()         { *m = PrivacyMetric_NumericalStatsConfig{} }
func (m *PrivacyMetric_NumericalStatsConfig) String() string { return proto.CompactTextString(m) }
func (*PrivacyMetric_NumericalStatsConfig) ProtoMessage()    {}
func (*PrivacyMetric_NumericalStatsConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{27, 0}
}

func (m *PrivacyMetric_NumericalStatsConfig) GetField() *FieldId {
	if m != nil {
		return m.Field
	}
	return nil
}

// Compute numerical stats over an individual column, including
// number of distinct values and value count distribution.
type PrivacyMetric_CategoricalStatsConfig struct {
	// Field to compute categorical stats on. All column types are
	// supported except for arrays and structs. However, it may be more
	// informative to use NumericalStats when the field type is supported,
	// depending on the data.
	Field *FieldId `protobuf:"bytes,1,opt,name=field" json:"field,omitempty"`
}

func (m *PrivacyMetric_CategoricalStatsConfig) Reset()         { *m = PrivacyMetric_CategoricalStatsConfig{} }
func (m *PrivacyMetric_CategoricalStatsConfig) String() string { return proto.CompactTextString(m) }
func (*PrivacyMetric_CategoricalStatsConfig) ProtoMessage()    {}
func (*PrivacyMetric_CategoricalStatsConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{27, 1}
}

func (m *PrivacyMetric_CategoricalStatsConfig) GetField() *FieldId {
	if m != nil {
		return m.Field
	}
	return nil
}

// k-anonymity metric, used for analysis of reidentification risk.
type PrivacyMetric_KAnonymityConfig struct {
	// Set of fields to compute k-anonymity over. When multiple fields are
	// specified, they are considered a single composite key. Structs and
	// repeated data types are not supported; however, nested fields are
	// supported so long as they are not structs themselves or nested within
	// a repeated field.
	QuasiIds []*FieldId `protobuf:"bytes,1,rep,name=quasi_ids,json=quasiIds" json:"quasi_ids,omitempty"`
	// Optional message indicating that each distinct entity_id should not
	// contribute to the k-anonymity count more than once per equivalence class.
	// If an entity_id appears on several rows with different quasi-identifier
	// tuples, it will contribute to each count exactly once.
	//
	// This can lead to unexpected results. Consider a table where ID 1 is
	// associated to quasi-identifier "foo", ID 2 to "bar", and ID 3 to *both*
	// quasi-identifiers "foo" and "bar" (on separate rows), and where this ID
	// is used as entity_id. Then, the anonymity value associated to ID 3 will
	// be 2, even if it is the only ID to be associated to both values "foo" and
	// "bar".
	EntityId *EntityId `protobuf:"bytes,2,opt,name=entity_id,json=entityId" json:"entity_id,omitempty"`
}

func (m *PrivacyMetric_KAnonymityConfig) Reset()         { *m = PrivacyMetric_KAnonymityConfig{} }
func (m *PrivacyMetric_KAnonymityConfig) String() string { return proto.CompactTextString(m) }
func (*PrivacyMetric_KAnonymityConfig) ProtoMessage()    {}
func (*PrivacyMetric_KAnonymityConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{27, 2}
}

func (m *PrivacyMetric_KAnonymityConfig) GetQuasiIds() []*FieldId {
	if m != nil {
		return m.QuasiIds
	}
	return nil
}

func (m *PrivacyMetric_KAnonymityConfig) GetEntityId() *EntityId {
	if m != nil {
		return m.EntityId
	}
	return nil
}

// l-diversity metric, used for analysis of reidentification risk.
type PrivacyMetric_LDiversityConfig struct {
	// Set of quasi-identifiers indicating how equivalence classes are
	// defined for the l-diversity computation. When multiple fields are
	// specified, they are considered a single composite key.
	QuasiIds []*FieldId `protobuf:"bytes,1,rep,name=quasi_ids,json=quasiIds" json:"quasi_ids,omitempty"`
	// Sensitive field for computing the l-value.
	SensitiveAttribute *FieldId `protobuf:"bytes,2,opt,name=sensitive_attribute,json=sensitiveAttribute" json:"sensitive_attribute,omitempty"`
}

func (m *PrivacyMetric_LDiversityConfig) Reset()         { *m = PrivacyMetric_LDiversityConfig{} }
func (m *PrivacyMetric_LDiversityConfig) String() string { return proto.CompactTextString(m) }
func (*PrivacyMetric_LDiversityConfig) ProtoMessage()    {}
func (*PrivacyMetric_LDiversityConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{27, 3}
}

func (m *PrivacyMetric_LDiversityConfig) GetQuasiIds() []*FieldId {
	if m != nil {
		return m.QuasiIds
	}
	return nil
}

func (m *PrivacyMetric_LDiversityConfig) GetSensitiveAttribute() *FieldId {
	if m != nil {
		return m.SensitiveAttribute
	}
	return nil
}

// Reidentifiability metric. This corresponds to a risk model similar to what
// is called "journalist risk" in the literature, except the attack dataset is
// statistically modeled instead of being perfectly known. This can be done
// using publicly available data (like the US Census), or using a custom
// statistical model (indicated as one or several BigQuery tables), or by
// extrapolating from the distribution of values in the input dataset.
type PrivacyMetric_KMapEstimationConfig struct {
	// Fields considered to be quasi-identifiers. No two columns can have the
	// same tag. [required]
	QuasiIds []*PrivacyMetric_KMapEstimationConfig_TaggedField `protobuf:"bytes,1,rep,name=quasi_ids,json=quasiIds" json:"quasi_ids,omitempty"`
	// ISO 3166-1 alpha-2 region code to use in the statistical modeling.
	// Required if no column is tagged with a region-specific InfoType (like
	// US_ZIP_5) or a region code.
	RegionCode string `protobuf:"bytes,2,opt,name=region_code,json=regionCode" json:"region_code,omitempty"`
	// Several auxiliary tables can be used in the analysis. Each custom_tag
	// used to tag a quasi-identifiers column must appear in exactly one column
	// of one auxiliary table.
	AuxiliaryTables []*PrivacyMetric_KMapEstimationConfig_AuxiliaryTable `protobuf:"bytes,3,rep,name=auxiliary_tables,json=auxiliaryTables" json:"auxiliary_tables,omitempty"`
}

func (m *PrivacyMetric_KMapEstimationConfig) Reset()         { *m = PrivacyMetric_KMapEstimationConfig{} }
func (m *PrivacyMetric_KMapEstimationConfig) String() string { return proto.CompactTextString(m) }
func (*PrivacyMetric_KMapEstimationConfig) ProtoMessage()    {}
func (*PrivacyMetric_KMapEstimationConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{27, 4}
}

func (m *PrivacyMetric_KMapEstimationConfig) GetQuasiIds() []*PrivacyMetric_KMapEstimationConfig_TaggedField {
	if m != nil {
		return m.QuasiIds
	}
	return nil
}

func (m *PrivacyMetric_KMapEstimationConfig) GetRegionCode() string {
	if m != nil {
		return m.RegionCode
	}
	return ""
}

func (m *PrivacyMetric_KMapEstimationConfig) GetAuxiliaryTables() []*PrivacyMetric_KMapEstimationConfig_AuxiliaryTable {
	if m != nil {
		return m.AuxiliaryTables
	}
	return nil
}

// A column with a semantic tag attached.
type PrivacyMetric_KMapEstimationConfig_TaggedField struct {
	// Identifies the column. [required]
	Field *FieldId `protobuf:"bytes,1,opt,name=field" json:"field,omitempty"`
	// Semantic tag that identifies what a column contains, to determine which
	// statistical model to use to estimate the reidentifiability of each
	// value. [required]
	//
	// Types that are valid to be assigned to Tag:
	//	*PrivacyMetric_KMapEstimationConfig_TaggedField_InfoType
	//	*PrivacyMetric_KMapEstimationConfig_TaggedField_CustomTag
	//	*PrivacyMetric_KMapEstimationConfig_TaggedField_Inferred
	Tag isPrivacyMetric_KMapEstimationConfig_TaggedField_Tag `protobuf_oneof:"tag"`
}

func (m *PrivacyMetric_KMapEstimationConfig_TaggedField) Reset() {
	*m = PrivacyMetric_KMapEstimationConfig_TaggedField{}
}
func (m *PrivacyMetric_KMapEstimationConfig_TaggedField) String() string {
	return proto.CompactTextString(m)
}
func (*PrivacyMetric_KMapEstimationConfig_TaggedField) ProtoMessage() {}
func (*PrivacyMetric_KMapEstimationConfig_TaggedField) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{27, 4, 0}
}

type isPrivacyMetric_KMapEstimationConfig_TaggedField_Tag interface {
	isPrivacyMetric_KMapEstimationConfig_TaggedField_Tag()
}

type PrivacyMetric_KMapEstimationConfig_TaggedField_InfoType struct {
	InfoType *InfoType `protobuf:"bytes,2,opt,name=info_type,json=infoType,oneof"`
}
type PrivacyMetric_KMapEstimationConfig_TaggedField_CustomTag struct {
	CustomTag string `protobuf:"bytes,3,opt,name=custom_tag,json=customTag,oneof"`
}
type PrivacyMetric_KMapEstimationConfig_TaggedField_Inferred struct {
	Inferred *google_protobuf3.Empty `protobuf:"bytes,4,opt,name=inferred,oneof"`
}

func (*PrivacyMetric_KMapEstimationConfig_TaggedField_InfoType) isPrivacyMetric_KMapEstimationConfig_TaggedField_Tag() {
}
func (*PrivacyMetric_KMapEstimationConfig_TaggedField_CustomTag) isPrivacyMetric_KMapEstimationConfig_TaggedField_Tag() {
}
func (*PrivacyMetric_KMapEstimationConfig_TaggedField_Inferred) isPrivacyMetric_KMapEstimationConfig_TaggedField_Tag() {
}

func (m *PrivacyMetric_KMapEstimationConfig_TaggedField) GetTag() isPrivacyMetric_KMapEstimationConfig_TaggedField_Tag {
	if m != nil {
		return m.Tag
	}
	return nil
}

func (m *PrivacyMetric_KMapEstimationConfig_TaggedField) GetField() *FieldId {
	if m != nil {
		return m.Field
	}
	return nil
}

func (m *PrivacyMetric_KMapEstimationConfig_TaggedField) GetInfoType() *InfoType {
	if x, ok := m.GetTag().(*PrivacyMetric_KMapEstimationConfig_TaggedField_InfoType); ok {
		return x.InfoType
	}
	return nil
}

func (m *PrivacyMetric_KMapEstimationConfig_TaggedField) GetCustomTag() string {
	if x, ok := m.GetTag().(*PrivacyMetric_KMapEstimationConfig_TaggedField_CustomTag); ok {
		return x.CustomTag
	}
	return ""
}

func (m *PrivacyMetric_KMapEstimationConfig_TaggedField) GetInferred() *google_protobuf3.Empty {
	if x, ok := m.GetTag().(*PrivacyMetric_KMapEstimationConfig_TaggedField_Inferred); ok {
		return x.Inferred
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*PrivacyMetric_KMapEstimationConfig_TaggedField) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _PrivacyMetric_KMapEstimationConfig_TaggedField_OneofMarshaler, _PrivacyMetric_KMapEstimationConfig_TaggedField_OneofUnmarshaler, _PrivacyMetric_KMapEstimationConfig_TaggedField_OneofSizer, []interface{}{
		(*PrivacyMetric_KMapEstimationConfig_TaggedField_InfoType)(nil),
		(*PrivacyMetric_KMapEstimationConfig_TaggedField_CustomTag)(nil),
		(*PrivacyMetric_KMapEstimationConfig_TaggedField_Inferred)(nil),
	}
}

func _PrivacyMetric_KMapEstimationConfig_TaggedField_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*PrivacyMetric_KMapEstimationConfig_TaggedField)
	// tag
	switch x := m.Tag.(type) {
	case *PrivacyMetric_KMapEstimationConfig_TaggedField_InfoType:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.InfoType); err != nil {
			return err
		}
	case *PrivacyMetric_KMapEstimationConfig_TaggedField_CustomTag:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.CustomTag)
	case *PrivacyMetric_KMapEstimationConfig_TaggedField_Inferred:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Inferred); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("PrivacyMetric_KMapEstimationConfig_TaggedField.Tag has unexpected type %T", x)
	}
	return nil
}

func _PrivacyMetric_KMapEstimationConfig_TaggedField_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*PrivacyMetric_KMapEstimationConfig_TaggedField)
	switch tag {
	case 2: // tag.info_type
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(InfoType)
		err := b.DecodeMessage(msg)
		m.Tag = &PrivacyMetric_KMapEstimationConfig_TaggedField_InfoType{msg}
		return true, err
	case 3: // tag.custom_tag
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Tag = &PrivacyMetric_KMapEstimationConfig_TaggedField_CustomTag{x}
		return true, err
	case 4: // tag.inferred
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_protobuf3.Empty)
		err := b.DecodeMessage(msg)
		m.Tag = &PrivacyMetric_KMapEstimationConfig_TaggedField_Inferred{msg}
		return true, err
	default:
		return false, nil
	}
}

func _PrivacyMetric_KMapEstimationConfig_TaggedField_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*PrivacyMetric_KMapEstimationConfig_TaggedField)
	// tag
	switch x := m.Tag.(type) {
	case *PrivacyMetric_KMapEstimationConfig_TaggedField_InfoType:
		s := proto.Size(x.InfoType)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *PrivacyMetric_KMapEstimationConfig_TaggedField_CustomTag:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.CustomTag)))
		n += len(x.CustomTag)
	case *PrivacyMetric_KMapEstimationConfig_TaggedField_Inferred:
		s := proto.Size(x.Inferred)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// An auxiliary table contains statistical information on the relative
// frequency of different quasi-identifiers values. It has one or several
// quasi-identifiers columns, and one column that indicates the relative
// frequency of each quasi-identifier tuple.
// If a tuple is present in the data but not in the auxiliary table, the
// corresponding relative frequency is assumed to be zero (and thus, the
// tuple is highly reidentifiable).
type PrivacyMetric_KMapEstimationConfig_AuxiliaryTable struct {
	// Auxiliary table location. [required]
	Table *BigQueryTable `protobuf:"bytes,3,opt,name=table" json:"table,omitempty"`
	// Quasi-identifier columns. [required]
	QuasiIds []*PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField `protobuf:"bytes,1,rep,name=quasi_ids,json=quasiIds" json:"quasi_ids,omitempty"`
	// The relative frequency column must contain a floating-point number
	// between 0 and 1 (inclusive). Null values are assumed to be zero.
	// [required]
	RelativeFrequency *FieldId `protobuf:"bytes,2,opt,name=relative_frequency,json=relativeFrequency" json:"relative_frequency,omitempty"`
}

func (m *PrivacyMetric_KMapEstimationConfig_AuxiliaryTable) Reset() {
	*m = PrivacyMetric_KMapEstimationConfig_AuxiliaryTable{}
}
func (m *PrivacyMetric_KMapEstimationConfig_AuxiliaryTable) String() string {
	return proto.CompactTextString(m)
}
func (*PrivacyMetric_KMapEstimationConfig_AuxiliaryTable) ProtoMessage() {}
func (*PrivacyMetric_KMapEstimationConfig_AuxiliaryTable) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{27, 4, 1}
}

func (m *PrivacyMetric_KMapEstimationConfig_AuxiliaryTable) GetTable() *BigQueryTable {
	if m != nil {
		return m.Table
	}
	return nil
}

func (m *PrivacyMetric_KMapEstimationConfig_AuxiliaryTable) GetQuasiIds() []*PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField {
	if m != nil {
		return m.QuasiIds
	}
	return nil
}

func (m *PrivacyMetric_KMapEstimationConfig_AuxiliaryTable) GetRelativeFrequency() *FieldId {
	if m != nil {
		return m.RelativeFrequency
	}
	return nil
}

// A quasi-identifier column has a custom_tag, used to know which column
// in the data corresponds to which column in the statistical model.
type PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField struct {
	Field     *FieldId `protobuf:"bytes,1,opt,name=field" json:"field,omitempty"`
	CustomTag string   `protobuf:"bytes,2,opt,name=custom_tag,json=customTag" json:"custom_tag,omitempty"`
}

func (m *PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField) Reset() {
	*m = PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField{}
}
func (m *PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField) String() string {
	return proto.CompactTextString(m)
}
func (*PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField) ProtoMessage() {}
func (*PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{27, 4, 1, 0}
}

func (m *PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField) GetField() *FieldId {
	if m != nil {
		return m.Field
	}
	return nil
}

func (m *PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField) GetCustomTag() string {
	if m != nil {
		return m.CustomTag
	}
	return ""
}

// Result of a risk analysis operation request.
type AnalyzeDataSourceRiskDetails struct {
	// Privacy metric to compute.
	RequestedPrivacyMetric *PrivacyMetric `protobuf:"bytes,1,opt,name=requested_privacy_metric,json=requestedPrivacyMetric" json:"requested_privacy_metric,omitempty"`
	// Input dataset to compute metrics over.
	RequestedSourceTable *BigQueryTable `protobuf:"bytes,2,opt,name=requested_source_table,json=requestedSourceTable" json:"requested_source_table,omitempty"`
	// Values associated with this metric.
	//
	// Types that are valid to be assigned to Result:
	//	*AnalyzeDataSourceRiskDetails_NumericalStatsResult_
	//	*AnalyzeDataSourceRiskDetails_CategoricalStatsResult_
	//	*AnalyzeDataSourceRiskDetails_KAnonymityResult_
	//	*AnalyzeDataSourceRiskDetails_LDiversityResult_
	//	*AnalyzeDataSourceRiskDetails_KMapEstimationResult_
	Result isAnalyzeDataSourceRiskDetails_Result `protobuf_oneof:"result"`
}

func (m *AnalyzeDataSourceRiskDetails) Reset()                    { *m = AnalyzeDataSourceRiskDetails{} }
func (m *AnalyzeDataSourceRiskDetails) String() string            { return proto.CompactTextString(m) }
func (*AnalyzeDataSourceRiskDetails) ProtoMessage()               {}
func (*AnalyzeDataSourceRiskDetails) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28} }

type isAnalyzeDataSourceRiskDetails_Result interface {
	isAnalyzeDataSourceRiskDetails_Result()
}

type AnalyzeDataSourceRiskDetails_NumericalStatsResult_ struct {
	NumericalStatsResult *AnalyzeDataSourceRiskDetails_NumericalStatsResult `protobuf:"bytes,3,opt,name=numerical_stats_result,json=numericalStatsResult,oneof"`
}
type AnalyzeDataSourceRiskDetails_CategoricalStatsResult_ struct {
	CategoricalStatsResult *AnalyzeDataSourceRiskDetails_CategoricalStatsResult `protobuf:"bytes,4,opt,name=categorical_stats_result,json=categoricalStatsResult,oneof"`
}
type AnalyzeDataSourceRiskDetails_KAnonymityResult_ struct {
	KAnonymityResult *AnalyzeDataSourceRiskDetails_KAnonymityResult `protobuf:"bytes,5,opt,name=k_anonymity_result,json=kAnonymityResult,oneof"`
}
type AnalyzeDataSourceRiskDetails_LDiversityResult_ struct {
	LDiversityResult *AnalyzeDataSourceRiskDetails_LDiversityResult `protobuf:"bytes,6,opt,name=l_diversity_result,json=lDiversityResult,oneof"`
}
type AnalyzeDataSourceRiskDetails_KMapEstimationResult_ struct {
	KMapEstimationResult *AnalyzeDataSourceRiskDetails_KMapEstimationResult `protobuf:"bytes,7,opt,name=k_map_estimation_result,json=kMapEstimationResult,oneof"`
}

func (*AnalyzeDataSourceRiskDetails_NumericalStatsResult_) isAnalyzeDataSourceRiskDetails_Result()   {}
func (*AnalyzeDataSourceRiskDetails_CategoricalStatsResult_) isAnalyzeDataSourceRiskDetails_Result() {}
func (*AnalyzeDataSourceRiskDetails_KAnonymityResult_) isAnalyzeDataSourceRiskDetails_Result()       {}
func (*AnalyzeDataSourceRiskDetails_LDiversityResult_) isAnalyzeDataSourceRiskDetails_Result()       {}
func (*AnalyzeDataSourceRiskDetails_KMapEstimationResult_) isAnalyzeDataSourceRiskDetails_Result()   {}

func (m *AnalyzeDataSourceRiskDetails) GetResult() isAnalyzeDataSourceRiskDetails_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *AnalyzeDataSourceRiskDetails) GetRequestedPrivacyMetric() *PrivacyMetric {
	if m != nil {
		return m.RequestedPrivacyMetric
	}
	return nil
}

func (m *AnalyzeDataSourceRiskDetails) GetRequestedSourceTable() *BigQueryTable {
	if m != nil {
		return m.RequestedSourceTable
	}
	return nil
}

func (m *AnalyzeDataSourceRiskDetails) GetNumericalStatsResult() *AnalyzeDataSourceRiskDetails_NumericalStatsResult {
	if x, ok := m.GetResult().(*AnalyzeDataSourceRiskDetails_NumericalStatsResult_); ok {
		return x.NumericalStatsResult
	}
	return nil
}

func (m *AnalyzeDataSourceRiskDetails) GetCategoricalStatsResult() *AnalyzeDataSourceRiskDetails_CategoricalStatsResult {
	if x, ok := m.GetResult().(*AnalyzeDataSourceRiskDetails_CategoricalStatsResult_); ok {
		return x.CategoricalStatsResult
	}
	return nil
}

func (m *AnalyzeDataSourceRiskDetails) GetKAnonymityResult() *AnalyzeDataSourceRiskDetails_KAnonymityResult {
	if x, ok := m.GetResult().(*AnalyzeDataSourceRiskDetails_KAnonymityResult_); ok {
		return x.KAnonymityResult
	}
	return nil
}

func (m *AnalyzeDataSourceRiskDetails) GetLDiversityResult() *AnalyzeDataSourceRiskDetails_LDiversityResult {
	if x, ok := m.GetResult().(*AnalyzeDataSourceRiskDetails_LDiversityResult_); ok {
		return x.LDiversityResult
	}
	return nil
}

func (m *AnalyzeDataSourceRiskDetails) GetKMapEstimationResult() *AnalyzeDataSourceRiskDetails_KMapEstimationResult {
	if x, ok := m.GetResult().(*AnalyzeDataSourceRiskDetails_KMapEstimationResult_); ok {
		return x.KMapEstimationResult
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*AnalyzeDataSourceRiskDetails) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _AnalyzeDataSourceRiskDetails_OneofMarshaler, _AnalyzeDataSourceRiskDetails_OneofUnmarshaler, _AnalyzeDataSourceRiskDetails_OneofSizer, []interface{}{
		(*AnalyzeDataSourceRiskDetails_NumericalStatsResult_)(nil),
		(*AnalyzeDataSourceRiskDetails_CategoricalStatsResult_)(nil),
		(*AnalyzeDataSourceRiskDetails_KAnonymityResult_)(nil),
		(*AnalyzeDataSourceRiskDetails_LDiversityResult_)(nil),
		(*AnalyzeDataSourceRiskDetails_KMapEstimationResult_)(nil),
	}
}

func _AnalyzeDataSourceRiskDetails_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*AnalyzeDataSourceRiskDetails)
	// result
	switch x := m.Result.(type) {
	case *AnalyzeDataSourceRiskDetails_NumericalStatsResult_:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.NumericalStatsResult); err != nil {
			return err
		}
	case *AnalyzeDataSourceRiskDetails_CategoricalStatsResult_:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CategoricalStatsResult); err != nil {
			return err
		}
	case *AnalyzeDataSourceRiskDetails_KAnonymityResult_:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.KAnonymityResult); err != nil {
			return err
		}
	case *AnalyzeDataSourceRiskDetails_LDiversityResult_:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.LDiversityResult); err != nil {
			return err
		}
	case *AnalyzeDataSourceRiskDetails_KMapEstimationResult_:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.KMapEstimationResult); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("AnalyzeDataSourceRiskDetails.Result has unexpected type %T", x)
	}
	return nil
}

func _AnalyzeDataSourceRiskDetails_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*AnalyzeDataSourceRiskDetails)
	switch tag {
	case 3: // result.numerical_stats_result
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AnalyzeDataSourceRiskDetails_NumericalStatsResult)
		err := b.DecodeMessage(msg)
		m.Result = &AnalyzeDataSourceRiskDetails_NumericalStatsResult_{msg}
		return true, err
	case 4: // result.categorical_stats_result
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AnalyzeDataSourceRiskDetails_CategoricalStatsResult)
		err := b.DecodeMessage(msg)
		m.Result = &AnalyzeDataSourceRiskDetails_CategoricalStatsResult_{msg}
		return true, err
	case 5: // result.k_anonymity_result
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AnalyzeDataSourceRiskDetails_KAnonymityResult)
		err := b.DecodeMessage(msg)
		m.Result = &AnalyzeDataSourceRiskDetails_KAnonymityResult_{msg}
		return true, err
	case 6: // result.l_diversity_result
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AnalyzeDataSourceRiskDetails_LDiversityResult)
		err := b.DecodeMessage(msg)
		m.Result = &AnalyzeDataSourceRiskDetails_LDiversityResult_{msg}
		return true, err
	case 7: // result.k_map_estimation_result
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AnalyzeDataSourceRiskDetails_KMapEstimationResult)
		err := b.DecodeMessage(msg)
		m.Result = &AnalyzeDataSourceRiskDetails_KMapEstimationResult_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _AnalyzeDataSourceRiskDetails_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*AnalyzeDataSourceRiskDetails)
	// result
	switch x := m.Result.(type) {
	case *AnalyzeDataSourceRiskDetails_NumericalStatsResult_:
		s := proto.Size(x.NumericalStatsResult)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AnalyzeDataSourceRiskDetails_CategoricalStatsResult_:
		s := proto.Size(x.CategoricalStatsResult)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AnalyzeDataSourceRiskDetails_KAnonymityResult_:
		s := proto.Size(x.KAnonymityResult)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AnalyzeDataSourceRiskDetails_LDiversityResult_:
		s := proto.Size(x.LDiversityResult)
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AnalyzeDataSourceRiskDetails_KMapEstimationResult_:
		s := proto.Size(x.KMapEstimationResult)
		n += proto.SizeVarint(7<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Result of the numerical stats computation.
type AnalyzeDataSourceRiskDetails_NumericalStatsResult struct {
	// Minimum value appearing in the column.
	MinValue *Value `protobuf:"bytes,1,opt,name=min_value,json=minValue" json:"min_value,omitempty"`
	// Maximum value appearing in the column.
	MaxValue *Value `protobuf:"bytes,2,opt,name=max_value,json=maxValue" json:"max_value,omitempty"`
	// List of 99 values that partition the set of field values into 100 equal
	// sized buckets.
	QuantileValues []*Value `protobuf:"bytes,4,rep,name=quantile_values,json=quantileValues" json:"quantile_values,omitempty"`
}

func (m *AnalyzeDataSourceRiskDetails_NumericalStatsResult) Reset() {
	*m = AnalyzeDataSourceRiskDetails_NumericalStatsResult{}
}
func (m *AnalyzeDataSourceRiskDetails_NumericalStatsResult) String() string {
	return proto.CompactTextString(m)
}
func (*AnalyzeDataSourceRiskDetails_NumericalStatsResult) ProtoMessage() {}
func (*AnalyzeDataSourceRiskDetails_NumericalStatsResult) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{28, 0}
}

func (m *AnalyzeDataSourceRiskDetails_NumericalStatsResult) GetMinValue() *Value {
	if m != nil {
		return m.MinValue
	}
	return nil
}

func (m *AnalyzeDataSourceRiskDetails_NumericalStatsResult) GetMaxValue() *Value {
	if m != nil {
		return m.MaxValue
	}
	return nil
}

func (m *AnalyzeDataSourceRiskDetails_NumericalStatsResult) GetQuantileValues() []*Value {
	if m != nil {
		return m.QuantileValues
	}
	return nil
}

// Result of the categorical stats computation.
type AnalyzeDataSourceRiskDetails_CategoricalStatsResult struct {
	// Histogram of value frequencies in the column.
	ValueFrequencyHistogramBuckets []*AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket `protobuf:"bytes,5,rep,name=value_frequency_histogram_buckets,json=valueFrequencyHistogramBuckets" json:"value_frequency_histogram_buckets,omitempty"`
}

func (m *AnalyzeDataSourceRiskDetails_CategoricalStatsResult) Reset() {
	*m = AnalyzeDataSourceRiskDetails_CategoricalStatsResult{}
}
func (m *AnalyzeDataSourceRiskDetails_CategoricalStatsResult) String() string {
	return proto.CompactTextString(m)
}
func (*AnalyzeDataSourceRiskDetails_CategoricalStatsResult) ProtoMessage() {}
func (*AnalyzeDataSourceRiskDetails_CategoricalStatsResult) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{28, 1}
}

func (m *AnalyzeDataSourceRiskDetails_CategoricalStatsResult) GetValueFrequencyHistogramBuckets() []*AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket {
	if m != nil {
		return m.ValueFrequencyHistogramBuckets
	}
	return nil
}

type AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket struct {
	// Lower bound on the value frequency of the values in this bucket.
	ValueFrequencyLowerBound int64 `protobuf:"varint,1,opt,name=value_frequency_lower_bound,json=valueFrequencyLowerBound" json:"value_frequency_lower_bound,omitempty"`
	// Upper bound on the value frequency of the values in this bucket.
	ValueFrequencyUpperBound int64 `protobuf:"varint,2,opt,name=value_frequency_upper_bound,json=valueFrequencyUpperBound" json:"value_frequency_upper_bound,omitempty"`
	// Total number of values in this bucket.
	BucketSize int64 `protobuf:"varint,3,opt,name=bucket_size,json=bucketSize" json:"bucket_size,omitempty"`
	// Sample of value frequencies in this bucket. The total number of
	// values returned per bucket is capped at 20.
	BucketValues []*ValueFrequency `protobuf:"bytes,4,rep,name=bucket_values,json=bucketValues" json:"bucket_values,omitempty"`
}

func (m *AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket) Reset() {
	*m = AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket{}
}
func (m *AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket) String() string {
	return proto.CompactTextString(m)
}
func (*AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket) ProtoMessage() {
}
func (*AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{28, 1, 0}
}

func (m *AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket) GetValueFrequencyLowerBound() int64 {
	if m != nil {
		return m.ValueFrequencyLowerBound
	}
	return 0
}

func (m *AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket) GetValueFrequencyUpperBound() int64 {
	if m != nil {
		return m.ValueFrequencyUpperBound
	}
	return 0
}

func (m *AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket) GetBucketSize() int64 {
	if m != nil {
		return m.BucketSize
	}
	return 0
}

func (m *AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket) GetBucketValues() []*ValueFrequency {
	if m != nil {
		return m.BucketValues
	}
	return nil
}

// Result of the k-anonymity computation.
type AnalyzeDataSourceRiskDetails_KAnonymityResult struct {
	// Histogram of k-anonymity equivalence classes.
	EquivalenceClassHistogramBuckets []*AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket `protobuf:"bytes,5,rep,name=equivalence_class_histogram_buckets,json=equivalenceClassHistogramBuckets" json:"equivalence_class_histogram_buckets,omitempty"`
}

func (m *AnalyzeDataSourceRiskDetails_KAnonymityResult) Reset() {
	*m = AnalyzeDataSourceRiskDetails_KAnonymityResult{}
}
func (m *AnalyzeDataSourceRiskDetails_KAnonymityResult) String() string {
	return proto.CompactTextString(m)
}
func (*AnalyzeDataSourceRiskDetails_KAnonymityResult) ProtoMessage() {}
func (*AnalyzeDataSourceRiskDetails_KAnonymityResult) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{28, 2}
}

func (m *AnalyzeDataSourceRiskDetails_KAnonymityResult) GetEquivalenceClassHistogramBuckets() []*AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket {
	if m != nil {
		return m.EquivalenceClassHistogramBuckets
	}
	return nil
}

// The set of columns' values that share the same ldiversity value
type AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass struct {
	// Set of values defining the equivalence class. One value per
	// quasi-identifier column in the original KAnonymity metric message.
	// The order is always the same as the original request.
	QuasiIdsValues []*Value `protobuf:"bytes,1,rep,name=quasi_ids_values,json=quasiIdsValues" json:"quasi_ids_values,omitempty"`
	// Size of the equivalence class, for example number of rows with the
	// above set of values.
	EquivalenceClassSize int64 `protobuf:"varint,2,opt,name=equivalence_class_size,json=equivalenceClassSize" json:"equivalence_class_size,omitempty"`
}

func (m *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass) Reset() {
	*m = AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass{}
}
func (m *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass) String() string {
	return proto.CompactTextString(m)
}
func (*AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass) ProtoMessage() {}
func (*AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{28, 2, 0}
}

func (m *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass) GetQuasiIdsValues() []*Value {
	if m != nil {
		return m.QuasiIdsValues
	}
	return nil
}

func (m *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass) GetEquivalenceClassSize() int64 {
	if m != nil {
		return m.EquivalenceClassSize
	}
	return 0
}

type AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket struct {
	// Lower bound on the size of the equivalence classes in this bucket.
	EquivalenceClassSizeLowerBound int64 `protobuf:"varint,1,opt,name=equivalence_class_size_lower_bound,json=equivalenceClassSizeLowerBound" json:"equivalence_class_size_lower_bound,omitempty"`
	// Upper bound on the size of the equivalence classes in this bucket.
	EquivalenceClassSizeUpperBound int64 `protobuf:"varint,2,opt,name=equivalence_class_size_upper_bound,json=equivalenceClassSizeUpperBound" json:"equivalence_class_size_upper_bound,omitempty"`
	// Total number of equivalence classes in this bucket.
	BucketSize int64 `protobuf:"varint,3,opt,name=bucket_size,json=bucketSize" json:"bucket_size,omitempty"`
	// Sample of equivalence classes in this bucket. The total number of
	// classes returned per bucket is capped at 20.
	BucketValues []*AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass `protobuf:"bytes,4,rep,name=bucket_values,json=bucketValues" json:"bucket_values,omitempty"`
}

func (m *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket) Reset() {
	*m = AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket{}
}
func (m *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket) String() string {
	return proto.CompactTextString(m)
}
func (*AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket) ProtoMessage() {}
func (*AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{28, 2, 1}
}

func (m *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket) GetEquivalenceClassSizeLowerBound() int64 {
	if m != nil {
		return m.EquivalenceClassSizeLowerBound
	}
	return 0
}

func (m *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket) GetEquivalenceClassSizeUpperBound() int64 {
	if m != nil {
		return m.EquivalenceClassSizeUpperBound
	}
	return 0
}

func (m *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket) GetBucketSize() int64 {
	if m != nil {
		return m.BucketSize
	}
	return 0
}

func (m *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket) GetBucketValues() []*AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass {
	if m != nil {
		return m.BucketValues
	}
	return nil
}

// Result of the l-diversity computation.
type AnalyzeDataSourceRiskDetails_LDiversityResult struct {
	// Histogram of l-diversity equivalence class sensitive value frequencies.
	SensitiveValueFrequencyHistogramBuckets []*AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket `protobuf:"bytes,5,rep,name=sensitive_value_frequency_histogram_buckets,json=sensitiveValueFrequencyHistogramBuckets" json:"sensitive_value_frequency_histogram_buckets,omitempty"`
}

func (m *AnalyzeDataSourceRiskDetails_LDiversityResult) Reset() {
	*m = AnalyzeDataSourceRiskDetails_LDiversityResult{}
}
func (m *AnalyzeDataSourceRiskDetails_LDiversityResult) String() string {
	return proto.CompactTextString(m)
}
func (*AnalyzeDataSourceRiskDetails_LDiversityResult) ProtoMessage() {}
func (*AnalyzeDataSourceRiskDetails_LDiversityResult) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{28, 3}
}

func (m *AnalyzeDataSourceRiskDetails_LDiversityResult) GetSensitiveValueFrequencyHistogramBuckets() []*AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket {
	if m != nil {
		return m.SensitiveValueFrequencyHistogramBuckets
	}
	return nil
}

// The set of columns' values that share the same ldiversity value.
type AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass struct {
	// Quasi-identifier values defining the k-anonymity equivalence
	// class. The order is always the same as the original request.
	QuasiIdsValues []*Value `protobuf:"bytes,1,rep,name=quasi_ids_values,json=quasiIdsValues" json:"quasi_ids_values,omitempty"`
	// Size of the k-anonymity equivalence class.
	EquivalenceClassSize int64 `protobuf:"varint,2,opt,name=equivalence_class_size,json=equivalenceClassSize" json:"equivalence_class_size,omitempty"`
	// Number of distinct sensitive values in this equivalence class.
	NumDistinctSensitiveValues int64 `protobuf:"varint,3,opt,name=num_distinct_sensitive_values,json=numDistinctSensitiveValues" json:"num_distinct_sensitive_values,omitempty"`
	// Estimated frequencies of top sensitive values.
	TopSensitiveValues []*ValueFrequency `protobuf:"bytes,4,rep,name=top_sensitive_values,json=topSensitiveValues" json:"top_sensitive_values,omitempty"`
}

func (m *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass) Reset() {
	*m = AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass{}
}
func (m *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass) String() string {
	return proto.CompactTextString(m)
}
func (*AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass) ProtoMessage() {}
func (*AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{28, 3, 0}
}

func (m *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass) GetQuasiIdsValues() []*Value {
	if m != nil {
		return m.QuasiIdsValues
	}
	return nil
}

func (m *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass) GetEquivalenceClassSize() int64 {
	if m != nil {
		return m.EquivalenceClassSize
	}
	return 0
}

func (m *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass) GetNumDistinctSensitiveValues() int64 {
	if m != nil {
		return m.NumDistinctSensitiveValues
	}
	return 0
}

func (m *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass) GetTopSensitiveValues() []*ValueFrequency {
	if m != nil {
		return m.TopSensitiveValues
	}
	return nil
}

type AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket struct {
	// Lower bound on the sensitive value frequencies of the equivalence
	// classes in this bucket.
	SensitiveValueFrequencyLowerBound int64 `protobuf:"varint,1,opt,name=sensitive_value_frequency_lower_bound,json=sensitiveValueFrequencyLowerBound" json:"sensitive_value_frequency_lower_bound,omitempty"`
	// Upper bound on the sensitive value frequencies of the equivalence
	// classes in this bucket.
	SensitiveValueFrequencyUpperBound int64 `protobuf:"varint,2,opt,name=sensitive_value_frequency_upper_bound,json=sensitiveValueFrequencyUpperBound" json:"sensitive_value_frequency_upper_bound,omitempty"`
	// Total number of equivalence classes in this bucket.
	BucketSize int64 `protobuf:"varint,3,opt,name=bucket_size,json=bucketSize" json:"bucket_size,omitempty"`
	// Sample of equivalence classes in this bucket. The total number of
	// classes returned per bucket is capped at 20.
	BucketValues []*AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass `protobuf:"bytes,4,rep,name=bucket_values,json=bucketValues" json:"bucket_values,omitempty"`
}

func (m *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket) Reset() {
	*m = AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket{}
}
func (m *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket) String() string {
	return proto.CompactTextString(m)
}
func (*AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket) ProtoMessage() {}
func (*AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{28, 3, 1}
}

func (m *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket) GetSensitiveValueFrequencyLowerBound() int64 {
	if m != nil {
		return m.SensitiveValueFrequencyLowerBound
	}
	return 0
}

func (m *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket) GetSensitiveValueFrequencyUpperBound() int64 {
	if m != nil {
		return m.SensitiveValueFrequencyUpperBound
	}
	return 0
}

func (m *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket) GetBucketSize() int64 {
	if m != nil {
		return m.BucketSize
	}
	return 0
}

func (m *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket) GetBucketValues() []*AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass {
	if m != nil {
		return m.BucketValues
	}
	return nil
}

// Result of the reidentifiability analysis. Note that these results are an
// estimation, not exact values.
type AnalyzeDataSourceRiskDetails_KMapEstimationResult struct {
	// The intervals [min_anonymity, max_anonymity] do not overlap. If a value
	// doesn't correspond to any such interval, the associated frequency is
	// zero. For example, the following records:
	//   {min_anonymity: 1, max_anonymity: 1, frequency: 17}
	//   {min_anonymity: 2, max_anonymity: 3, frequency: 42}
	//   {min_anonymity: 5, max_anonymity: 10, frequency: 99}
	// mean that there are no record with an estimated anonymity of 4, 5, or
	// larger than 10.
	KMapEstimationHistogram []*AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket `protobuf:"bytes,1,rep,name=k_map_estimation_histogram,json=kMapEstimationHistogram" json:"k_map_estimation_histogram,omitempty"`
}

func (m *AnalyzeDataSourceRiskDetails_KMapEstimationResult) Reset() {
	*m = AnalyzeDataSourceRiskDetails_KMapEstimationResult{}
}
func (m *AnalyzeDataSourceRiskDetails_KMapEstimationResult) String() string {
	return proto.CompactTextString(m)
}
func (*AnalyzeDataSourceRiskDetails_KMapEstimationResult) ProtoMessage() {}
func (*AnalyzeDataSourceRiskDetails_KMapEstimationResult) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{28, 4}
}

func (m *AnalyzeDataSourceRiskDetails_KMapEstimationResult) GetKMapEstimationHistogram() []*AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket {
	if m != nil {
		return m.KMapEstimationHistogram
	}
	return nil
}

// A tuple of values for the quasi-identifier columns.
type AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues struct {
	// The quasi-identifier values.
	QuasiIdsValues []*Value `protobuf:"bytes,1,rep,name=quasi_ids_values,json=quasiIdsValues" json:"quasi_ids_values,omitempty"`
	// The estimated anonymity for these quasi-identifier values.
	EstimatedAnonymity int64 `protobuf:"varint,2,opt,name=estimated_anonymity,json=estimatedAnonymity" json:"estimated_anonymity,omitempty"`
}

func (m *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues) Reset() {
	*m = AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues{}
}
func (m *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues) String() string {
	return proto.CompactTextString(m)
}
func (*AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues) ProtoMessage() {}
func (*AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{28, 4, 0}
}

func (m *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues) GetQuasiIdsValues() []*Value {
	if m != nil {
		return m.QuasiIdsValues
	}
	return nil
}

func (m *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues) GetEstimatedAnonymity() int64 {
	if m != nil {
		return m.EstimatedAnonymity
	}
	return 0
}

// A KMapEstimationHistogramBucket message with the following values:
//   min_anonymity: 3
//   max_anonymity: 5
//   frequency: 42
// means that there are 42 records whose quasi-identifier values correspond
// to 3, 4 or 5 people in the overlying population. An important particular
// case is when min_anonymity = max_anonymity = 1: the frequency field then
// corresponds to the number of uniquely identifiable records.
type AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket struct {
	// Always positive.
	MinAnonymity int64 `protobuf:"varint,1,opt,name=min_anonymity,json=minAnonymity" json:"min_anonymity,omitempty"`
	// Always greater than or equal to min_anonymity.
	MaxAnonymity int64 `protobuf:"varint,2,opt,name=max_anonymity,json=maxAnonymity" json:"max_anonymity,omitempty"`
	// Number of records within these anonymity bounds.
	BucketSize int64 `protobuf:"varint,5,opt,name=bucket_size,json=bucketSize" json:"bucket_size,omitempty"`
	// Sample of quasi-identifier tuple values in this bucket. The total
	// number of classes returned per bucket is capped at 20.
	BucketValues []*AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues `protobuf:"bytes,6,rep,name=bucket_values,json=bucketValues" json:"bucket_values,omitempty"`
}

func (m *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket) Reset() {
	*m = AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket{}
}
func (m *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket) String() string {
	return proto.CompactTextString(m)
}
func (*AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket) ProtoMessage() {
}
func (*AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{28, 4, 1}
}

func (m *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket) GetMinAnonymity() int64 {
	if m != nil {
		return m.MinAnonymity
	}
	return 0
}

func (m *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket) GetMaxAnonymity() int64 {
	if m != nil {
		return m.MaxAnonymity
	}
	return 0
}

func (m *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket) GetBucketSize() int64 {
	if m != nil {
		return m.BucketSize
	}
	return 0
}

func (m *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket) GetBucketValues() []*AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues {
	if m != nil {
		return m.BucketValues
	}
	return nil
}

// A value of a field, including its frequency.
type ValueFrequency struct {
	// A value contained in the field in question.
	Value *Value `protobuf:"bytes,1,opt,name=value" json:"value,omitempty"`
	// How many times the value is contained in the field.
	Count int64 `protobuf:"varint,2,opt,name=count" json:"count,omitempty"`
}

func (m *ValueFrequency) Reset()                    { *m = ValueFrequency{} }
func (m *ValueFrequency) String() string            { return proto.CompactTextString(m) }
func (*ValueFrequency) ProtoMessage()               {}
func (*ValueFrequency) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{29} }

func (m *ValueFrequency) GetValue() *Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *ValueFrequency) GetCount() int64 {
	if m != nil {
		return m.Count
	}
	return 0
}

// Set of primitive values supported by the system.
// Note that for the purposes of inspection or transformation, the number
// of bytes considered to comprise a 'Value' is based on its representation
// as a UTF-8 encoded string. For example, if 'integer_value' is set to
// 123456789, the number of bytes would be counted as 9, even though an
// int64 only holds up to 8 bytes of data.
type Value struct {
	// Types that are valid to be assigned to Type:
	//	*Value_IntegerValue
	//	*Value_FloatValue
	//	*Value_StringValue
	//	*Value_BooleanValue
	//	*Value_TimestampValue
	//	*Value_TimeValue
	//	*Value_DateValue
	//	*Value_DayOfWeekValue
	Type isValue_Type `protobuf_oneof:"type"`
}

func (m *Value) Reset()                    { *m = Value{} }
func (m *Value) String() string            { return proto.CompactTextString(m) }
func (*Value) ProtoMessage()               {}
func (*Value) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{30} }

type isValue_Type interface {
	isValue_Type()
}

type Value_IntegerValue struct {
	IntegerValue int64 `protobuf:"varint,1,opt,name=integer_value,json=integerValue,oneof"`
}
type Value_FloatValue struct {
	FloatValue float64 `protobuf:"fixed64,2,opt,name=float_value,json=floatValue,oneof"`
}
type Value_StringValue struct {
	StringValue string `protobuf:"bytes,3,opt,name=string_value,json=stringValue,oneof"`
}
type Value_BooleanValue struct {
	BooleanValue bool `protobuf:"varint,4,opt,name=boolean_value,json=booleanValue,oneof"`
}
type Value_TimestampValue struct {
	TimestampValue *google_protobuf1.Timestamp `protobuf:"bytes,5,opt,name=timestamp_value,json=timestampValue,oneof"`
}
type Value_TimeValue struct {
	TimeValue *google_type2.TimeOfDay `protobuf:"bytes,6,opt,name=time_value,json=timeValue,oneof"`
}
type Value_DateValue struct {
	DateValue *google_type.Date `protobuf:"bytes,7,opt,name=date_value,json=dateValue,oneof"`
}
type Value_DayOfWeekValue struct {
	DayOfWeekValue google_type1.DayOfWeek `protobuf:"varint,8,opt,name=day_of_week_value,json=dayOfWeekValue,enum=google.type.DayOfWeek,oneof"`
}

func (*Value_IntegerValue) isValue_Type()   {}
func (*Value_FloatValue) isValue_Type()     {}
func (*Value_StringValue) isValue_Type()    {}
func (*Value_BooleanValue) isValue_Type()   {}
func (*Value_TimestampValue) isValue_Type() {}
func (*Value_TimeValue) isValue_Type()      {}
func (*Value_DateValue) isValue_Type()      {}
func (*Value_DayOfWeekValue) isValue_Type() {}

func (m *Value) GetType() isValue_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *Value) GetIntegerValue() int64 {
	if x, ok := m.GetType().(*Value_IntegerValue); ok {
		return x.IntegerValue
	}
	return 0
}

func (m *Value) GetFloatValue() float64 {
	if x, ok := m.GetType().(*Value_FloatValue); ok {
		return x.FloatValue
	}
	return 0
}

func (m *Value) GetStringValue() string {
	if x, ok := m.GetType().(*Value_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (m *Value) GetBooleanValue() bool {
	if x, ok := m.GetType().(*Value_BooleanValue); ok {
		return x.BooleanValue
	}
	return false
}

func (m *Value) GetTimestampValue() *google_protobuf1.Timestamp {
	if x, ok := m.GetType().(*Value_TimestampValue); ok {
		return x.TimestampValue
	}
	return nil
}

func (m *Value) GetTimeValue() *google_type2.TimeOfDay {
	if x, ok := m.GetType().(*Value_TimeValue); ok {
		return x.TimeValue
	}
	return nil
}

func (m *Value) GetDateValue() *google_type.Date {
	if x, ok := m.GetType().(*Value_DateValue); ok {
		return x.DateValue
	}
	return nil
}

func (m *Value) GetDayOfWeekValue() google_type1.DayOfWeek {
	if x, ok := m.GetType().(*Value_DayOfWeekValue); ok {
		return x.DayOfWeekValue
	}
	return google_type1.DayOfWeek_DAY_OF_WEEK_UNSPECIFIED
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Value) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Value_OneofMarshaler, _Value_OneofUnmarshaler, _Value_OneofSizer, []interface{}{
		(*Value_IntegerValue)(nil),
		(*Value_FloatValue)(nil),
		(*Value_StringValue)(nil),
		(*Value_BooleanValue)(nil),
		(*Value_TimestampValue)(nil),
		(*Value_TimeValue)(nil),
		(*Value_DateValue)(nil),
		(*Value_DayOfWeekValue)(nil),
	}
}

func _Value_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Value)
	// type
	switch x := m.Type.(type) {
	case *Value_IntegerValue:
		b.EncodeVarint(1<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.IntegerValue))
	case *Value_FloatValue:
		b.EncodeVarint(2<<3 | proto.WireFixed64)
		b.EncodeFixed64(math.Float64bits(x.FloatValue))
	case *Value_StringValue:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.StringValue)
	case *Value_BooleanValue:
		t := uint64(0)
		if x.BooleanValue {
			t = 1
		}
		b.EncodeVarint(4<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case *Value_TimestampValue:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TimestampValue); err != nil {
			return err
		}
	case *Value_TimeValue:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TimeValue); err != nil {
			return err
		}
	case *Value_DateValue:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DateValue); err != nil {
			return err
		}
	case *Value_DayOfWeekValue:
		b.EncodeVarint(8<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.DayOfWeekValue))
	case nil:
	default:
		return fmt.Errorf("Value.Type has unexpected type %T", x)
	}
	return nil
}

func _Value_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Value)
	switch tag {
	case 1: // type.integer_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Type = &Value_IntegerValue{int64(x)}
		return true, err
	case 2: // type.float_value
		if wire != proto.WireFixed64 {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeFixed64()
		m.Type = &Value_FloatValue{math.Float64frombits(x)}
		return true, err
	case 3: // type.string_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Type = &Value_StringValue{x}
		return true, err
	case 4: // type.boolean_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Type = &Value_BooleanValue{x != 0}
		return true, err
	case 5: // type.timestamp_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_protobuf1.Timestamp)
		err := b.DecodeMessage(msg)
		m.Type = &Value_TimestampValue{msg}
		return true, err
	case 6: // type.time_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_type2.TimeOfDay)
		err := b.DecodeMessage(msg)
		m.Type = &Value_TimeValue{msg}
		return true, err
	case 7: // type.date_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_type.Date)
		err := b.DecodeMessage(msg)
		m.Type = &Value_DateValue{msg}
		return true, err
	case 8: // type.day_of_week_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Type = &Value_DayOfWeekValue{google_type1.DayOfWeek(x)}
		return true, err
	default:
		return false, nil
	}
}

func _Value_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Value)
	// type
	switch x := m.Type.(type) {
	case *Value_IntegerValue:
		n += proto.SizeVarint(1<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.IntegerValue))
	case *Value_FloatValue:
		n += proto.SizeVarint(2<<3 | proto.WireFixed64)
		n += 8
	case *Value_StringValue:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.StringValue)))
		n += len(x.StringValue)
	case *Value_BooleanValue:
		n += proto.SizeVarint(4<<3 | proto.WireVarint)
		n += 1
	case *Value_TimestampValue:
		s := proto.Size(x.TimestampValue)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Value_TimeValue:
		s := proto.Size(x.TimeValue)
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Value_DateValue:
		s := proto.Size(x.DateValue)
		n += proto.SizeVarint(7<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Value_DayOfWeekValue:
		n += proto.SizeVarint(8<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.DayOfWeekValue))
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Message for infoType-dependent details parsed from quote.
type QuoteInfo struct {
	// Object representation of the quote.
	//
	// Types that are valid to be assigned to ParsedQuote:
	//	*QuoteInfo_DateTime
	ParsedQuote isQuoteInfo_ParsedQuote `protobuf_oneof:"parsed_quote"`
}

func (m *QuoteInfo) Reset()                    { *m = QuoteInfo{} }
func (m *QuoteInfo) String() string            { return proto.CompactTextString(m) }
func (*QuoteInfo) ProtoMessage()               {}
func (*QuoteInfo) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{31} }

type isQuoteInfo_ParsedQuote interface {
	isQuoteInfo_ParsedQuote()
}

type QuoteInfo_DateTime struct {
	DateTime *DateTime `protobuf:"bytes,2,opt,name=date_time,json=dateTime,oneof"`
}

func (*QuoteInfo_DateTime) isQuoteInfo_ParsedQuote() {}

func (m *QuoteInfo) GetParsedQuote() isQuoteInfo_ParsedQuote {
	if m != nil {
		return m.ParsedQuote
	}
	return nil
}

func (m *QuoteInfo) GetDateTime() *DateTime {
	if x, ok := m.GetParsedQuote().(*QuoteInfo_DateTime); ok {
		return x.DateTime
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*QuoteInfo) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _QuoteInfo_OneofMarshaler, _QuoteInfo_OneofUnmarshaler, _QuoteInfo_OneofSizer, []interface{}{
		(*QuoteInfo_DateTime)(nil),
	}
}

func _QuoteInfo_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*QuoteInfo)
	// parsed_quote
	switch x := m.ParsedQuote.(type) {
	case *QuoteInfo_DateTime:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DateTime); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("QuoteInfo.ParsedQuote has unexpected type %T", x)
	}
	return nil
}

func _QuoteInfo_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*QuoteInfo)
	switch tag {
	case 2: // parsed_quote.date_time
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DateTime)
		err := b.DecodeMessage(msg)
		m.ParsedQuote = &QuoteInfo_DateTime{msg}
		return true, err
	default:
		return false, nil
	}
}

func _QuoteInfo_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*QuoteInfo)
	// parsed_quote
	switch x := m.ParsedQuote.(type) {
	case *QuoteInfo_DateTime:
		s := proto.Size(x.DateTime)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Message for a date time object.
type DateTime struct {
	// One or more of the following must be set. All fields are optional, but
	// when set must be valid date or time values.
	Date      *google_type.Date       `protobuf:"bytes,1,opt,name=date" json:"date,omitempty"`
	DayOfWeek google_type1.DayOfWeek  `protobuf:"varint,2,opt,name=day_of_week,json=dayOfWeek,enum=google.type.DayOfWeek" json:"day_of_week,omitempty"`
	Time      *google_type2.TimeOfDay `protobuf:"bytes,3,opt,name=time" json:"time,omitempty"`
	TimeZone  *DateTime_TimeZone      `protobuf:"bytes,4,opt,name=time_zone,json=timeZone" json:"time_zone,omitempty"`
}

func (m *DateTime) Reset()                    { *m = DateTime{} }
func (m *DateTime) String() string            { return proto.CompactTextString(m) }
func (*DateTime) ProtoMessage()               {}
func (*DateTime) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{32} }

func (m *DateTime) GetDate() *google_type.Date {
	if m != nil {
		return m.Date
	}
	return nil
}

func (m *DateTime) GetDayOfWeek() google_type1.DayOfWeek {
	if m != nil {
		return m.DayOfWeek
	}
	return google_type1.DayOfWeek_DAY_OF_WEEK_UNSPECIFIED
}

func (m *DateTime) GetTime() *google_type2.TimeOfDay {
	if m != nil {
		return m.Time
	}
	return nil
}

func (m *DateTime) GetTimeZone() *DateTime_TimeZone {
	if m != nil {
		return m.TimeZone
	}
	return nil
}

type DateTime_TimeZone struct {
	// Set only if the offset can be determined. Positive for time ahead of UTC.
	// E.g. For "UTC-9", this value is -540.
	OffsetMinutes int32 `protobuf:"varint,1,opt,name=offset_minutes,json=offsetMinutes" json:"offset_minutes,omitempty"`
}

func (m *DateTime_TimeZone) Reset()                    { *m = DateTime_TimeZone{} }
func (m *DateTime_TimeZone) String() string            { return proto.CompactTextString(m) }
func (*DateTime_TimeZone) ProtoMessage()               {}
func (*DateTime_TimeZone) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{32, 0} }

func (m *DateTime_TimeZone) GetOffsetMinutes() int32 {
	if m != nil {
		return m.OffsetMinutes
	}
	return 0
}

// The configuration that controls how the data will change.
type DeidentifyConfig struct {
	// Types that are valid to be assigned to Transformation:
	//	*DeidentifyConfig_InfoTypeTransformations
	//	*DeidentifyConfig_RecordTransformations
	Transformation isDeidentifyConfig_Transformation `protobuf_oneof:"transformation"`
}

func (m *DeidentifyConfig) Reset()                    { *m = DeidentifyConfig{} }
func (m *DeidentifyConfig) String() string            { return proto.CompactTextString(m) }
func (*DeidentifyConfig) ProtoMessage()               {}
func (*DeidentifyConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{33} }

type isDeidentifyConfig_Transformation interface {
	isDeidentifyConfig_Transformation()
}

type DeidentifyConfig_InfoTypeTransformations struct {
	InfoTypeTransformations *InfoTypeTransformations `protobuf:"bytes,1,opt,name=info_type_transformations,json=infoTypeTransformations,oneof"`
}
type DeidentifyConfig_RecordTransformations struct {
	RecordTransformations *RecordTransformations `protobuf:"bytes,2,opt,name=record_transformations,json=recordTransformations,oneof"`
}

func (*DeidentifyConfig_InfoTypeTransformations) isDeidentifyConfig_Transformation() {}
func (*DeidentifyConfig_RecordTransformations) isDeidentifyConfig_Transformation()   {}

func (m *DeidentifyConfig) GetTransformation() isDeidentifyConfig_Transformation {
	if m != nil {
		return m.Transformation
	}
	return nil
}

func (m *DeidentifyConfig) GetInfoTypeTransformations() *InfoTypeTransformations {
	if x, ok := m.GetTransformation().(*DeidentifyConfig_InfoTypeTransformations); ok {
		return x.InfoTypeTransformations
	}
	return nil
}

func (m *DeidentifyConfig) GetRecordTransformations() *RecordTransformations {
	if x, ok := m.GetTransformation().(*DeidentifyConfig_RecordTransformations); ok {
		return x.RecordTransformations
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*DeidentifyConfig) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _DeidentifyConfig_OneofMarshaler, _DeidentifyConfig_OneofUnmarshaler, _DeidentifyConfig_OneofSizer, []interface{}{
		(*DeidentifyConfig_InfoTypeTransformations)(nil),
		(*DeidentifyConfig_RecordTransformations)(nil),
	}
}

func _DeidentifyConfig_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*DeidentifyConfig)
	// transformation
	switch x := m.Transformation.(type) {
	case *DeidentifyConfig_InfoTypeTransformations:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.InfoTypeTransformations); err != nil {
			return err
		}
	case *DeidentifyConfig_RecordTransformations:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RecordTransformations); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("DeidentifyConfig.Transformation has unexpected type %T", x)
	}
	return nil
}

func _DeidentifyConfig_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*DeidentifyConfig)
	switch tag {
	case 1: // transformation.info_type_transformations
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(InfoTypeTransformations)
		err := b.DecodeMessage(msg)
		m.Transformation = &DeidentifyConfig_InfoTypeTransformations{msg}
		return true, err
	case 2: // transformation.record_transformations
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RecordTransformations)
		err := b.DecodeMessage(msg)
		m.Transformation = &DeidentifyConfig_RecordTransformations{msg}
		return true, err
	default:
		return false, nil
	}
}

func _DeidentifyConfig_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*DeidentifyConfig)
	// transformation
	switch x := m.Transformation.(type) {
	case *DeidentifyConfig_InfoTypeTransformations:
		s := proto.Size(x.InfoTypeTransformations)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *DeidentifyConfig_RecordTransformations:
		s := proto.Size(x.RecordTransformations)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A rule for transforming a value.
type PrimitiveTransformation struct {
	// Types that are valid to be assigned to Transformation:
	//	*PrimitiveTransformation_ReplaceConfig
	//	*PrimitiveTransformation_RedactConfig
	//	*PrimitiveTransformation_CharacterMaskConfig
	//	*PrimitiveTransformation_CryptoReplaceFfxFpeConfig
	//	*PrimitiveTransformation_FixedSizeBucketingConfig
	//	*PrimitiveTransformation_BucketingConfig
	//	*PrimitiveTransformation_ReplaceWithInfoTypeConfig
	//	*PrimitiveTransformation_TimePartConfig
	//	*PrimitiveTransformation_CryptoHashConfig
	//	*PrimitiveTransformation_DateShiftConfig
	Transformation isPrimitiveTransformation_Transformation `protobuf_oneof:"transformation"`
}

func (m *PrimitiveTransformation) Reset()                    { *m = PrimitiveTransformation{} }
func (m *PrimitiveTransformation) String() string            { return proto.CompactTextString(m) }
func (*PrimitiveTransformation) ProtoMessage()               {}
func (*PrimitiveTransformation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{34} }

type isPrimitiveTransformation_Transformation interface {
	isPrimitiveTransformation_Transformation()
}

type PrimitiveTransformation_ReplaceConfig struct {
	ReplaceConfig *ReplaceValueConfig `protobuf:"bytes,1,opt,name=replace_config,json=replaceConfig,oneof"`
}
type PrimitiveTransformation_RedactConfig struct {
	RedactConfig *RedactConfig `protobuf:"bytes,2,opt,name=redact_config,json=redactConfig,oneof"`
}
type PrimitiveTransformation_CharacterMaskConfig struct {
	CharacterMaskConfig *CharacterMaskConfig `protobuf:"bytes,3,opt,name=character_mask_config,json=characterMaskConfig,oneof"`
}
type PrimitiveTransformation_CryptoReplaceFfxFpeConfig struct {
	CryptoReplaceFfxFpeConfig *CryptoReplaceFfxFpeConfig `protobuf:"bytes,4,opt,name=crypto_replace_ffx_fpe_config,json=cryptoReplaceFfxFpeConfig,oneof"`
}
type PrimitiveTransformation_FixedSizeBucketingConfig struct {
	FixedSizeBucketingConfig *FixedSizeBucketingConfig `protobuf:"bytes,5,opt,name=fixed_size_bucketing_config,json=fixedSizeBucketingConfig,oneof"`
}
type PrimitiveTransformation_BucketingConfig struct {
	BucketingConfig *BucketingConfig `protobuf:"bytes,6,opt,name=bucketing_config,json=bucketingConfig,oneof"`
}
type PrimitiveTransformation_ReplaceWithInfoTypeConfig struct {
	ReplaceWithInfoTypeConfig *ReplaceWithInfoTypeConfig `protobuf:"bytes,7,opt,name=replace_with_info_type_config,json=replaceWithInfoTypeConfig,oneof"`
}
type PrimitiveTransformation_TimePartConfig struct {
	TimePartConfig *TimePartConfig `protobuf:"bytes,8,opt,name=time_part_config,json=timePartConfig,oneof"`
}
type PrimitiveTransformation_CryptoHashConfig struct {
	CryptoHashConfig *CryptoHashConfig `protobuf:"bytes,9,opt,name=crypto_hash_config,json=cryptoHashConfig,oneof"`
}
type PrimitiveTransformation_DateShiftConfig struct {
	DateShiftConfig *DateShiftConfig `protobuf:"bytes,11,opt,name=date_shift_config,json=dateShiftConfig,oneof"`
}

func (*PrimitiveTransformation_ReplaceConfig) isPrimitiveTransformation_Transformation()             {}
func (*PrimitiveTransformation_RedactConfig) isPrimitiveTransformation_Transformation()              {}
func (*PrimitiveTransformation_CharacterMaskConfig) isPrimitiveTransformation_Transformation()       {}
func (*PrimitiveTransformation_CryptoReplaceFfxFpeConfig) isPrimitiveTransformation_Transformation() {}
func (*PrimitiveTransformation_FixedSizeBucketingConfig) isPrimitiveTransformation_Transformation()  {}
func (*PrimitiveTransformation_BucketingConfig) isPrimitiveTransformation_Transformation()           {}
func (*PrimitiveTransformation_ReplaceWithInfoTypeConfig) isPrimitiveTransformation_Transformation() {}
func (*PrimitiveTransformation_TimePartConfig) isPrimitiveTransformation_Transformation()            {}
func (*PrimitiveTransformation_CryptoHashConfig) isPrimitiveTransformation_Transformation()          {}
func (*PrimitiveTransformation_DateShiftConfig) isPrimitiveTransformation_Transformation()           {}

func (m *PrimitiveTransformation) GetTransformation() isPrimitiveTransformation_Transformation {
	if m != nil {
		return m.Transformation
	}
	return nil
}

func (m *PrimitiveTransformation) GetReplaceConfig() *ReplaceValueConfig {
	if x, ok := m.GetTransformation().(*PrimitiveTransformation_ReplaceConfig); ok {
		return x.ReplaceConfig
	}
	return nil
}

func (m *PrimitiveTransformation) GetRedactConfig() *RedactConfig {
	if x, ok := m.GetTransformation().(*PrimitiveTransformation_RedactConfig); ok {
		return x.RedactConfig
	}
	return nil
}

func (m *PrimitiveTransformation) GetCharacterMaskConfig() *CharacterMaskConfig {
	if x, ok := m.GetTransformation().(*PrimitiveTransformation_CharacterMaskConfig); ok {
		return x.CharacterMaskConfig
	}
	return nil
}

func (m *PrimitiveTransformation) GetCryptoReplaceFfxFpeConfig() *CryptoReplaceFfxFpeConfig {
	if x, ok := m.GetTransformation().(*PrimitiveTransformation_CryptoReplaceFfxFpeConfig); ok {
		return x.CryptoReplaceFfxFpeConfig
	}
	return nil
}

func (m *PrimitiveTransformation) GetFixedSizeBucketingConfig() *FixedSizeBucketingConfig {
	if x, ok := m.GetTransformation().(*PrimitiveTransformation_FixedSizeBucketingConfig); ok {
		return x.FixedSizeBucketingConfig
	}
	return nil
}

func (m *PrimitiveTransformation) GetBucketingConfig() *BucketingConfig {
	if x, ok := m.GetTransformation().(*PrimitiveTransformation_BucketingConfig); ok {
		return x.BucketingConfig
	}
	return nil
}

func (m *PrimitiveTransformation) GetReplaceWithInfoTypeConfig() *ReplaceWithInfoTypeConfig {
	if x, ok := m.GetTransformation().(*PrimitiveTransformation_ReplaceWithInfoTypeConfig); ok {
		return x.ReplaceWithInfoTypeConfig
	}
	return nil
}

func (m *PrimitiveTransformation) GetTimePartConfig() *TimePartConfig {
	if x, ok := m.GetTransformation().(*PrimitiveTransformation_TimePartConfig); ok {
		return x.TimePartConfig
	}
	return nil
}

func (m *PrimitiveTransformation) GetCryptoHashConfig() *CryptoHashConfig {
	if x, ok := m.GetTransformation().(*PrimitiveTransformation_CryptoHashConfig); ok {
		return x.CryptoHashConfig
	}
	return nil
}

func (m *PrimitiveTransformation) GetDateShiftConfig() *DateShiftConfig {
	if x, ok := m.GetTransformation().(*PrimitiveTransformation_DateShiftConfig); ok {
		return x.DateShiftConfig
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*PrimitiveTransformation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _PrimitiveTransformation_OneofMarshaler, _PrimitiveTransformation_OneofUnmarshaler, _PrimitiveTransformation_OneofSizer, []interface{}{
		(*PrimitiveTransformation_ReplaceConfig)(nil),
		(*PrimitiveTransformation_RedactConfig)(nil),
		(*PrimitiveTransformation_CharacterMaskConfig)(nil),
		(*PrimitiveTransformation_CryptoReplaceFfxFpeConfig)(nil),
		(*PrimitiveTransformation_FixedSizeBucketingConfig)(nil),
		(*PrimitiveTransformation_BucketingConfig)(nil),
		(*PrimitiveTransformation_ReplaceWithInfoTypeConfig)(nil),
		(*PrimitiveTransformation_TimePartConfig)(nil),
		(*PrimitiveTransformation_CryptoHashConfig)(nil),
		(*PrimitiveTransformation_DateShiftConfig)(nil),
	}
}

func _PrimitiveTransformation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*PrimitiveTransformation)
	// transformation
	switch x := m.Transformation.(type) {
	case *PrimitiveTransformation_ReplaceConfig:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ReplaceConfig); err != nil {
			return err
		}
	case *PrimitiveTransformation_RedactConfig:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RedactConfig); err != nil {
			return err
		}
	case *PrimitiveTransformation_CharacterMaskConfig:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CharacterMaskConfig); err != nil {
			return err
		}
	case *PrimitiveTransformation_CryptoReplaceFfxFpeConfig:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CryptoReplaceFfxFpeConfig); err != nil {
			return err
		}
	case *PrimitiveTransformation_FixedSizeBucketingConfig:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.FixedSizeBucketingConfig); err != nil {
			return err
		}
	case *PrimitiveTransformation_BucketingConfig:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BucketingConfig); err != nil {
			return err
		}
	case *PrimitiveTransformation_ReplaceWithInfoTypeConfig:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ReplaceWithInfoTypeConfig); err != nil {
			return err
		}
	case *PrimitiveTransformation_TimePartConfig:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TimePartConfig); err != nil {
			return err
		}
	case *PrimitiveTransformation_CryptoHashConfig:
		b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CryptoHashConfig); err != nil {
			return err
		}
	case *PrimitiveTransformation_DateShiftConfig:
		b.EncodeVarint(11<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DateShiftConfig); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("PrimitiveTransformation.Transformation has unexpected type %T", x)
	}
	return nil
}

func _PrimitiveTransformation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*PrimitiveTransformation)
	switch tag {
	case 1: // transformation.replace_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ReplaceValueConfig)
		err := b.DecodeMessage(msg)
		m.Transformation = &PrimitiveTransformation_ReplaceConfig{msg}
		return true, err
	case 2: // transformation.redact_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RedactConfig)
		err := b.DecodeMessage(msg)
		m.Transformation = &PrimitiveTransformation_RedactConfig{msg}
		return true, err
	case 3: // transformation.character_mask_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CharacterMaskConfig)
		err := b.DecodeMessage(msg)
		m.Transformation = &PrimitiveTransformation_CharacterMaskConfig{msg}
		return true, err
	case 4: // transformation.crypto_replace_ffx_fpe_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CryptoReplaceFfxFpeConfig)
		err := b.DecodeMessage(msg)
		m.Transformation = &PrimitiveTransformation_CryptoReplaceFfxFpeConfig{msg}
		return true, err
	case 5: // transformation.fixed_size_bucketing_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(FixedSizeBucketingConfig)
		err := b.DecodeMessage(msg)
		m.Transformation = &PrimitiveTransformation_FixedSizeBucketingConfig{msg}
		return true, err
	case 6: // transformation.bucketing_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(BucketingConfig)
		err := b.DecodeMessage(msg)
		m.Transformation = &PrimitiveTransformation_BucketingConfig{msg}
		return true, err
	case 7: // transformation.replace_with_info_type_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ReplaceWithInfoTypeConfig)
		err := b.DecodeMessage(msg)
		m.Transformation = &PrimitiveTransformation_ReplaceWithInfoTypeConfig{msg}
		return true, err
	case 8: // transformation.time_part_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TimePartConfig)
		err := b.DecodeMessage(msg)
		m.Transformation = &PrimitiveTransformation_TimePartConfig{msg}
		return true, err
	case 9: // transformation.crypto_hash_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CryptoHashConfig)
		err := b.DecodeMessage(msg)
		m.Transformation = &PrimitiveTransformation_CryptoHashConfig{msg}
		return true, err
	case 11: // transformation.date_shift_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DateShiftConfig)
		err := b.DecodeMessage(msg)
		m.Transformation = &PrimitiveTransformation_DateShiftConfig{msg}
		return true, err
	default:
		return false, nil
	}
}

func _PrimitiveTransformation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*PrimitiveTransformation)
	// transformation
	switch x := m.Transformation.(type) {
	case *PrimitiveTransformation_ReplaceConfig:
		s := proto.Size(x.ReplaceConfig)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *PrimitiveTransformation_RedactConfig:
		s := proto.Size(x.RedactConfig)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *PrimitiveTransformation_CharacterMaskConfig:
		s := proto.Size(x.CharacterMaskConfig)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *PrimitiveTransformation_CryptoReplaceFfxFpeConfig:
		s := proto.Size(x.CryptoReplaceFfxFpeConfig)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *PrimitiveTransformation_FixedSizeBucketingConfig:
		s := proto.Size(x.FixedSizeBucketingConfig)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *PrimitiveTransformation_BucketingConfig:
		s := proto.Size(x.BucketingConfig)
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *PrimitiveTransformation_ReplaceWithInfoTypeConfig:
		s := proto.Size(x.ReplaceWithInfoTypeConfig)
		n += proto.SizeVarint(7<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *PrimitiveTransformation_TimePartConfig:
		s := proto.Size(x.TimePartConfig)
		n += proto.SizeVarint(8<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *PrimitiveTransformation_CryptoHashConfig:
		s := proto.Size(x.CryptoHashConfig)
		n += proto.SizeVarint(9<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *PrimitiveTransformation_DateShiftConfig:
		s := proto.Size(x.DateShiftConfig)
		n += proto.SizeVarint(11<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// For use with `Date`, `Timestamp`, and `TimeOfDay`, extract or preserve a
// portion of the value.
type TimePartConfig struct {
	PartToExtract TimePartConfig_TimePart `protobuf:"varint,1,opt,name=part_to_extract,json=partToExtract,enum=google.privacy.dlp.v2beta2.TimePartConfig_TimePart" json:"part_to_extract,omitempty"`
}

func (m *TimePartConfig) Reset()                    { *m = TimePartConfig{} }
func (m *TimePartConfig) String() string            { return proto.CompactTextString(m) }
func (*TimePartConfig) ProtoMessage()               {}
func (*TimePartConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{35} }

func (m *TimePartConfig) GetPartToExtract() TimePartConfig_TimePart {
	if m != nil {
		return m.PartToExtract
	}
	return TimePartConfig_TIME_PART_UNSPECIFIED
}

// Pseudonymization method that generates surrogates via cryptographic hashing.
// Uses SHA-256.
// The key size must be either 32 or 64 bytes.
// Outputs a 32 byte digest as an uppercase hex string
// (for example, 41D1567F7F99F1DC2A5FAB886DEE5BEE).
// Currently, only string and integer values can be hashed.
type CryptoHashConfig struct {
	// The key used by the hash function.
	CryptoKey *CryptoKey `protobuf:"bytes,1,opt,name=crypto_key,json=cryptoKey" json:"crypto_key,omitempty"`
}

func (m *CryptoHashConfig) Reset()                    { *m = CryptoHashConfig{} }
func (m *CryptoHashConfig) String() string            { return proto.CompactTextString(m) }
func (*CryptoHashConfig) ProtoMessage()               {}
func (*CryptoHashConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{36} }

func (m *CryptoHashConfig) GetCryptoKey() *CryptoKey {
	if m != nil {
		return m.CryptoKey
	}
	return nil
}

// Replace each input value with a given `Value`.
type ReplaceValueConfig struct {
	// Value to replace it with.
	NewValue *Value `protobuf:"bytes,1,opt,name=new_value,json=newValue" json:"new_value,omitempty"`
}

func (m *ReplaceValueConfig) Reset()                    { *m = ReplaceValueConfig{} }
func (m *ReplaceValueConfig) String() string            { return proto.CompactTextString(m) }
func (*ReplaceValueConfig) ProtoMessage()               {}
func (*ReplaceValueConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{37} }

func (m *ReplaceValueConfig) GetNewValue() *Value {
	if m != nil {
		return m.NewValue
	}
	return nil
}

// Replace each matching finding with the name of the info_type.
type ReplaceWithInfoTypeConfig struct {
}

func (m *ReplaceWithInfoTypeConfig) Reset()                    { *m = ReplaceWithInfoTypeConfig{} }
func (m *ReplaceWithInfoTypeConfig) String() string            { return proto.CompactTextString(m) }
func (*ReplaceWithInfoTypeConfig) ProtoMessage()               {}
func (*ReplaceWithInfoTypeConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{38} }

// Redact a given value. For example, if used with an `InfoTypeTransformation`
// transforming PHONE_NUMBER, and input 'My phone number is 206-555-0123', the
// output would be 'My phone number is '.
type RedactConfig struct {
}

func (m *RedactConfig) Reset()                    { *m = RedactConfig{} }
func (m *RedactConfig) String() string            { return proto.CompactTextString(m) }
func (*RedactConfig) ProtoMessage()               {}
func (*RedactConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{39} }

// Characters to skip when doing deidentification of a value. These will be left
// alone and skipped.
type CharsToIgnore struct {
	// Types that are valid to be assigned to Characters:
	//	*CharsToIgnore_CharactersToSkip
	//	*CharsToIgnore_CommonCharactersToIgnore
	Characters isCharsToIgnore_Characters `protobuf_oneof:"characters"`
}

func (m *CharsToIgnore) Reset()                    { *m = CharsToIgnore{} }
func (m *CharsToIgnore) String() string            { return proto.CompactTextString(m) }
func (*CharsToIgnore) ProtoMessage()               {}
func (*CharsToIgnore) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{40} }

type isCharsToIgnore_Characters interface {
	isCharsToIgnore_Characters()
}

type CharsToIgnore_CharactersToSkip struct {
	CharactersToSkip string `protobuf:"bytes,1,opt,name=characters_to_skip,json=charactersToSkip,oneof"`
}
type CharsToIgnore_CommonCharactersToIgnore struct {
	CommonCharactersToIgnore CharsToIgnore_CommonCharsToIgnore `protobuf:"varint,2,opt,name=common_characters_to_ignore,json=commonCharactersToIgnore,enum=google.privacy.dlp.v2beta2.CharsToIgnore_CommonCharsToIgnore,oneof"`
}

func (*CharsToIgnore_CharactersToSkip) isCharsToIgnore_Characters()         {}
func (*CharsToIgnore_CommonCharactersToIgnore) isCharsToIgnore_Characters() {}

func (m *CharsToIgnore) GetCharacters() isCharsToIgnore_Characters {
	if m != nil {
		return m.Characters
	}
	return nil
}

func (m *CharsToIgnore) GetCharactersToSkip() string {
	if x, ok := m.GetCharacters().(*CharsToIgnore_CharactersToSkip); ok {
		return x.CharactersToSkip
	}
	return ""
}

func (m *CharsToIgnore) GetCommonCharactersToIgnore() CharsToIgnore_CommonCharsToIgnore {
	if x, ok := m.GetCharacters().(*CharsToIgnore_CommonCharactersToIgnore); ok {
		return x.CommonCharactersToIgnore
	}
	return CharsToIgnore_COMMON_CHARS_TO_IGNORE_UNSPECIFIED
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CharsToIgnore) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CharsToIgnore_OneofMarshaler, _CharsToIgnore_OneofUnmarshaler, _CharsToIgnore_OneofSizer, []interface{}{
		(*CharsToIgnore_CharactersToSkip)(nil),
		(*CharsToIgnore_CommonCharactersToIgnore)(nil),
	}
}

func _CharsToIgnore_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CharsToIgnore)
	// characters
	switch x := m.Characters.(type) {
	case *CharsToIgnore_CharactersToSkip:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.CharactersToSkip)
	case *CharsToIgnore_CommonCharactersToIgnore:
		b.EncodeVarint(2<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.CommonCharactersToIgnore))
	case nil:
	default:
		return fmt.Errorf("CharsToIgnore.Characters has unexpected type %T", x)
	}
	return nil
}

func _CharsToIgnore_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CharsToIgnore)
	switch tag {
	case 1: // characters.characters_to_skip
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Characters = &CharsToIgnore_CharactersToSkip{x}
		return true, err
	case 2: // characters.common_characters_to_ignore
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Characters = &CharsToIgnore_CommonCharactersToIgnore{CharsToIgnore_CommonCharsToIgnore(x)}
		return true, err
	default:
		return false, nil
	}
}

func _CharsToIgnore_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CharsToIgnore)
	// characters
	switch x := m.Characters.(type) {
	case *CharsToIgnore_CharactersToSkip:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.CharactersToSkip)))
		n += len(x.CharactersToSkip)
	case *CharsToIgnore_CommonCharactersToIgnore:
		n += proto.SizeVarint(2<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.CommonCharactersToIgnore))
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Partially mask a string by replacing a given number of characters with a
// fixed character. Masking can start from the beginning or end of the string.
// This can be used on data of any type (numbers, longs, and so on) and when
// de-identifying structured data we'll attempt to preserve the original data's
// type. (This allows you to take a long like 123 and modify it to a string like
// **3.
type CharacterMaskConfig struct {
	// Character to mask the sensitive values&mdash;for example, "*" for an
	// alphabetic string such as name, or "0" for a numeric string such as ZIP
	// code or credit card number. String must have length 1. If not supplied, we
	// will default to "*" for strings, 0 for digits.
	MaskingCharacter string `protobuf:"bytes,1,opt,name=masking_character,json=maskingCharacter" json:"masking_character,omitempty"`
	// Number of characters to mask. If not set, all matching chars will be
	// masked. Skipped characters do not count towards this tally.
	NumberToMask int32 `protobuf:"varint,2,opt,name=number_to_mask,json=numberToMask" json:"number_to_mask,omitempty"`
	// Mask characters in reverse order. For example, if `masking_character` is
	// '0', number_to_mask is 14, and `reverse_order` is false, then
	// 1234-5678-9012-3456 -> 00000000000000-3456
	// If `masking_character` is '*', `number_to_mask` is 3, and `reverse_order`
	// is true, then 12345 -> 12***
	ReverseOrder bool `protobuf:"varint,3,opt,name=reverse_order,json=reverseOrder" json:"reverse_order,omitempty"`
	// When masking a string, items in this list will be skipped when replacing.
	// For example, if your string is 555-555-5555 and you ask us to skip `-` and
	// mask 5 chars with * we would produce ***-*55-5555.
	CharactersToIgnore []*CharsToIgnore `protobuf:"bytes,4,rep,name=characters_to_ignore,json=charactersToIgnore" json:"characters_to_ignore,omitempty"`
}

func (m *CharacterMaskConfig) Reset()                    { *m = CharacterMaskConfig{} }
func (m *CharacterMaskConfig) String() string            { return proto.CompactTextString(m) }
func (*CharacterMaskConfig) ProtoMessage()               {}
func (*CharacterMaskConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{41} }

func (m *CharacterMaskConfig) GetMaskingCharacter() string {
	if m != nil {
		return m.MaskingCharacter
	}
	return ""
}

func (m *CharacterMaskConfig) GetNumberToMask() int32 {
	if m != nil {
		return m.NumberToMask
	}
	return 0
}

func (m *CharacterMaskConfig) GetReverseOrder() bool {
	if m != nil {
		return m.ReverseOrder
	}
	return false
}

func (m *CharacterMaskConfig) GetCharactersToIgnore() []*CharsToIgnore {
	if m != nil {
		return m.CharactersToIgnore
	}
	return nil
}

// Buckets values based on fixed size ranges. The
// Bucketing transformation can provide all of this functionality,
// but requires more configuration. This message is provided as a convenience to
// the user for simple bucketing strategies.
//
// The transformed value will be a hyphenated string of
// <lower_bound>-<upper_bound>, i.e if lower_bound = 10 and upper_bound = 20
// all values that are within this bucket will be replaced with "10-20".
//
// This can be used on data of type: double, long.
//
// If the bound Value type differs from the type of data
// being transformed, we will first attempt converting the type of the data to
// be transformed to match the type of the bound before comparing.
type FixedSizeBucketingConfig struct {
	// Lower bound value of buckets. All values less than `lower_bound` are
	// grouped together into a single bucket; for example if `lower_bound` = 10,
	// then all values less than 10 are replaced with the value “-10”. [Required].
	LowerBound *Value `protobuf:"bytes,1,opt,name=lower_bound,json=lowerBound" json:"lower_bound,omitempty"`
	// Upper bound value of buckets. All values greater than upper_bound are
	// grouped together into a single bucket; for example if `upper_bound` = 89,
	// then all values greater than 89 are replaced with the value “89+”.
	// [Required].
	UpperBound *Value `protobuf:"bytes,2,opt,name=upper_bound,json=upperBound" json:"upper_bound,omitempty"`
	// Size of each bucket (except for minimum and maximum buckets). So if
	// `lower_bound` = 10, `upper_bound` = 89, and `bucket_size` = 10, then the
	// following buckets would be used: -10, 10-20, 20-30, 30-40, 40-50, 50-60,
	// 60-70, 70-80, 80-89, 89+. Precision up to 2 decimals works. [Required].
	BucketSize float64 `protobuf:"fixed64,3,opt,name=bucket_size,json=bucketSize" json:"bucket_size,omitempty"`
}

func (m *FixedSizeBucketingConfig) Reset()                    { *m = FixedSizeBucketingConfig{} }
func (m *FixedSizeBucketingConfig) String() string            { return proto.CompactTextString(m) }
func (*FixedSizeBucketingConfig) ProtoMessage()               {}
func (*FixedSizeBucketingConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{42} }

func (m *FixedSizeBucketingConfig) GetLowerBound() *Value {
	if m != nil {
		return m.LowerBound
	}
	return nil
}

func (m *FixedSizeBucketingConfig) GetUpperBound() *Value {
	if m != nil {
		return m.UpperBound
	}
	return nil
}

func (m *FixedSizeBucketingConfig) GetBucketSize() float64 {
	if m != nil {
		return m.BucketSize
	}
	return 0
}

// Generalization function that buckets values based on ranges. The ranges and
// replacement values are dynamically provided by the user for custom behavior,
// such as 1-30 -> LOW 31-65 -> MEDIUM 66-100 -> HIGH
// This can be used on
// data of type: number, long, string, timestamp.
// If the bound `Value` type differs from the type of data being transformed, we
// will first attempt converting the type of the data to be transformed to match
// the type of the bound before comparing.
type BucketingConfig struct {
	// Set of buckets. Ranges must be non-overlapping.
	Buckets []*BucketingConfig_Bucket `protobuf:"bytes,1,rep,name=buckets" json:"buckets,omitempty"`
}

func (m *BucketingConfig) Reset()                    { *m = BucketingConfig{} }
func (m *BucketingConfig) String() string            { return proto.CompactTextString(m) }
func (*BucketingConfig) ProtoMessage()               {}
func (*BucketingConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{43} }

func (m *BucketingConfig) GetBuckets() []*BucketingConfig_Bucket {
	if m != nil {
		return m.Buckets
	}
	return nil
}

// Bucket is represented as a range, along with replacement values.
type BucketingConfig_Bucket struct {
	// Lower bound of the range, inclusive. Type should be the same as max if
	// used.
	Min *Value `protobuf:"bytes,1,opt,name=min" json:"min,omitempty"`
	// Upper bound of the range, exclusive; type must match min.
	Max *Value `protobuf:"bytes,2,opt,name=max" json:"max,omitempty"`
	// Replacement value for this bucket. If not provided
	// the default behavior will be to hyphenate the min-max range.
	ReplacementValue *Value `protobuf:"bytes,3,opt,name=replacement_value,json=replacementValue" json:"replacement_value,omitempty"`
}

func (m *BucketingConfig_Bucket) Reset()                    { *m = BucketingConfig_Bucket{} }
func (m *BucketingConfig_Bucket) String() string            { return proto.CompactTextString(m) }
func (*BucketingConfig_Bucket) ProtoMessage()               {}
func (*BucketingConfig_Bucket) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{43, 0} }

func (m *BucketingConfig_Bucket) GetMin() *Value {
	if m != nil {
		return m.Min
	}
	return nil
}

func (m *BucketingConfig_Bucket) GetMax() *Value {
	if m != nil {
		return m.Max
	}
	return nil
}

func (m *BucketingConfig_Bucket) GetReplacementValue() *Value {
	if m != nil {
		return m.ReplacementValue
	}
	return nil
}

// Replaces an identifier with a surrogate using FPE with the FFX
// mode of operation; however when used in the `ReidentifyContent` API method,
// it serves the opposite function by reversing the surrogate back into
// the original identifier.
// The identifier must be encoded as ASCII.
// For a given crypto key and context, the same identifier will be
// replaced with the same surrogate.
// Identifiers must be at least two characters long.
// In the case that the identifier is the empty string, it will be skipped.
type CryptoReplaceFfxFpeConfig struct {
	// The key used by the encryption algorithm. [required]
	CryptoKey *CryptoKey `protobuf:"bytes,1,opt,name=crypto_key,json=cryptoKey" json:"crypto_key,omitempty"`
	// The 'tweak', a context may be used for higher security since the same
	// identifier in two different contexts won't be given the same surrogate. If
	// the context is not set, a default tweak will be used.
	//
	// If the context is set but:
	//
	// 1. there is no record present when transforming a given value or
	// 1. the field is not present when transforming a given value,
	//
	// a default tweak will be used.
	//
	// Note that case (1) is expected when an `InfoTypeTransformation` is
	// applied to both structured and non-structured `ContentItem`s.
	// Currently, the referenced field may be of value type integer or string.
	//
	// The tweak is constructed as a sequence of bytes in big endian byte order
	// such that:
	//
	// - a 64 bit integer is encoded followed by a single byte of value 1
	// - a string is encoded in UTF-8 format followed by a single byte of value
	//  å 2
	Context *FieldId `protobuf:"bytes,2,opt,name=context" json:"context,omitempty"`
	// Types that are valid to be assigned to Alphabet:
	//	*CryptoReplaceFfxFpeConfig_CommonAlphabet
	//	*CryptoReplaceFfxFpeConfig_CustomAlphabet
	//	*CryptoReplaceFfxFpeConfig_Radix
	Alphabet isCryptoReplaceFfxFpeConfig_Alphabet `protobuf_oneof:"alphabet"`
	// The custom infoType to annotate the surrogate with.
	// This annotation will be applied to the surrogate by prefixing it with
	// the name of the custom infoType followed by the number of
	// characters comprising the surrogate. The following scheme defines the
	// format: info_type_name(surrogate_character_count):surrogate
	//
	// For example, if the name of custom infoType is 'MY_TOKEN_INFO_TYPE' and
	// the surrogate is 'abc', the full replacement value
	// will be: 'MY_TOKEN_INFO_TYPE(3):abc'
	//
	// This annotation identifies the surrogate when inspecting content using the
	// custom infoType
	// [`SurrogateType`](/dlp/docs/reference/rest/v2beta2/InspectConfig#surrogatetype).
	// This facilitates reversal of the surrogate when it occurs in free text.
	//
	// In order for inspection to work properly, the name of this infoType must
	// not occur naturally anywhere in your data; otherwise, inspection may
	// find a surrogate that does not correspond to an actual identifier.
	// Therefore, choose your custom infoType name carefully after considering
	// what your data looks like. One way to select a name that has a high chance
	// of yielding reliable detection is to include one or more unicode characters
	// that are highly improbable to exist in your data.
	// For example, assuming your data is entered from a regular ASCII keyboard,
	// the symbol with the hex code point 29DD might be used like so:
	// ⧝MY_TOKEN_TYPE
	SurrogateInfoType *InfoType `protobuf:"bytes,8,opt,name=surrogate_info_type,json=surrogateInfoType" json:"surrogate_info_type,omitempty"`
}

func (m *CryptoReplaceFfxFpeConfig) Reset()                    { *m = CryptoReplaceFfxFpeConfig{} }
func (m *CryptoReplaceFfxFpeConfig) String() string            { return proto.CompactTextString(m) }
func (*CryptoReplaceFfxFpeConfig) ProtoMessage()               {}
func (*CryptoReplaceFfxFpeConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{44} }

type isCryptoReplaceFfxFpeConfig_Alphabet interface {
	isCryptoReplaceFfxFpeConfig_Alphabet()
}

type CryptoReplaceFfxFpeConfig_CommonAlphabet struct {
	CommonAlphabet CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet `protobuf:"varint,4,opt,name=common_alphabet,json=commonAlphabet,enum=google.privacy.dlp.v2beta2.CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet,oneof"`
}
type CryptoReplaceFfxFpeConfig_CustomAlphabet struct {
	CustomAlphabet string `protobuf:"bytes,5,opt,name=custom_alphabet,json=customAlphabet,oneof"`
}
type CryptoReplaceFfxFpeConfig_Radix struct {
	Radix int32 `protobuf:"varint,6,opt,name=radix,oneof"`
}

func (*CryptoReplaceFfxFpeConfig_CommonAlphabet) isCryptoReplaceFfxFpeConfig_Alphabet() {}
func (*CryptoReplaceFfxFpeConfig_CustomAlphabet) isCryptoReplaceFfxFpeConfig_Alphabet() {}
func (*CryptoReplaceFfxFpeConfig_Radix) isCryptoReplaceFfxFpeConfig_Alphabet()          {}

func (m *CryptoReplaceFfxFpeConfig) GetAlphabet() isCryptoReplaceFfxFpeConfig_Alphabet {
	if m != nil {
		return m.Alphabet
	}
	return nil
}

func (m *CryptoReplaceFfxFpeConfig) GetCryptoKey() *CryptoKey {
	if m != nil {
		return m.CryptoKey
	}
	return nil
}

func (m *CryptoReplaceFfxFpeConfig) GetContext() *FieldId {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *CryptoReplaceFfxFpeConfig) GetCommonAlphabet() CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet {
	if x, ok := m.GetAlphabet().(*CryptoReplaceFfxFpeConfig_CommonAlphabet); ok {
		return x.CommonAlphabet
	}
	return CryptoReplaceFfxFpeConfig_FFX_COMMON_NATIVE_ALPHABET_UNSPECIFIED
}

func (m *CryptoReplaceFfxFpeConfig) GetCustomAlphabet() string {
	if x, ok := m.GetAlphabet().(*CryptoReplaceFfxFpeConfig_CustomAlphabet); ok {
		return x.CustomAlphabet
	}
	return ""
}

func (m *CryptoReplaceFfxFpeConfig) GetRadix() int32 {
	if x, ok := m.GetAlphabet().(*CryptoReplaceFfxFpeConfig_Radix); ok {
		return x.Radix
	}
	return 0
}

func (m *CryptoReplaceFfxFpeConfig) GetSurrogateInfoType() *InfoType {
	if m != nil {
		return m.SurrogateInfoType
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CryptoReplaceFfxFpeConfig) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CryptoReplaceFfxFpeConfig_OneofMarshaler, _CryptoReplaceFfxFpeConfig_OneofUnmarshaler, _CryptoReplaceFfxFpeConfig_OneofSizer, []interface{}{
		(*CryptoReplaceFfxFpeConfig_CommonAlphabet)(nil),
		(*CryptoReplaceFfxFpeConfig_CustomAlphabet)(nil),
		(*CryptoReplaceFfxFpeConfig_Radix)(nil),
	}
}

func _CryptoReplaceFfxFpeConfig_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CryptoReplaceFfxFpeConfig)
	// alphabet
	switch x := m.Alphabet.(type) {
	case *CryptoReplaceFfxFpeConfig_CommonAlphabet:
		b.EncodeVarint(4<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.CommonAlphabet))
	case *CryptoReplaceFfxFpeConfig_CustomAlphabet:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.CustomAlphabet)
	case *CryptoReplaceFfxFpeConfig_Radix:
		b.EncodeVarint(6<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.Radix))
	case nil:
	default:
		return fmt.Errorf("CryptoReplaceFfxFpeConfig.Alphabet has unexpected type %T", x)
	}
	return nil
}

func _CryptoReplaceFfxFpeConfig_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CryptoReplaceFfxFpeConfig)
	switch tag {
	case 4: // alphabet.common_alphabet
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Alphabet = &CryptoReplaceFfxFpeConfig_CommonAlphabet{CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet(x)}
		return true, err
	case 5: // alphabet.custom_alphabet
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Alphabet = &CryptoReplaceFfxFpeConfig_CustomAlphabet{x}
		return true, err
	case 6: // alphabet.radix
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Alphabet = &CryptoReplaceFfxFpeConfig_Radix{int32(x)}
		return true, err
	default:
		return false, nil
	}
}

func _CryptoReplaceFfxFpeConfig_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CryptoReplaceFfxFpeConfig)
	// alphabet
	switch x := m.Alphabet.(type) {
	case *CryptoReplaceFfxFpeConfig_CommonAlphabet:
		n += proto.SizeVarint(4<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.CommonAlphabet))
	case *CryptoReplaceFfxFpeConfig_CustomAlphabet:
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.CustomAlphabet)))
		n += len(x.CustomAlphabet)
	case *CryptoReplaceFfxFpeConfig_Radix:
		n += proto.SizeVarint(6<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.Radix))
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// This is a data encryption key (DEK) (as opposed to
// a key encryption key (KEK) stored by KMS).
// When using KMS to wrap/unwrap DEKs, be sure to set an appropriate
// IAM policy on the KMS CryptoKey (KEK) to ensure an attacker cannot
// unwrap the data crypto key.
type CryptoKey struct {
	// Types that are valid to be assigned to Source:
	//	*CryptoKey_Transient
	//	*CryptoKey_Unwrapped
	//	*CryptoKey_KmsWrapped
	Source isCryptoKey_Source `protobuf_oneof:"source"`
}

func (m *CryptoKey) Reset()                    { *m = CryptoKey{} }
func (m *CryptoKey) String() string            { return proto.CompactTextString(m) }
func (*CryptoKey) ProtoMessage()               {}
func (*CryptoKey) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{45} }

type isCryptoKey_Source interface {
	isCryptoKey_Source()
}

type CryptoKey_Transient struct {
	Transient *TransientCryptoKey `protobuf:"bytes,1,opt,name=transient,oneof"`
}
type CryptoKey_Unwrapped struct {
	Unwrapped *UnwrappedCryptoKey `protobuf:"bytes,2,opt,name=unwrapped,oneof"`
}
type CryptoKey_KmsWrapped struct {
	KmsWrapped *KmsWrappedCryptoKey `protobuf:"bytes,3,opt,name=kms_wrapped,json=kmsWrapped,oneof"`
}

func (*CryptoKey_Transient) isCryptoKey_Source()  {}
func (*CryptoKey_Unwrapped) isCryptoKey_Source()  {}
func (*CryptoKey_KmsWrapped) isCryptoKey_Source() {}

func (m *CryptoKey) GetSource() isCryptoKey_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *CryptoKey) GetTransient() *TransientCryptoKey {
	if x, ok := m.GetSource().(*CryptoKey_Transient); ok {
		return x.Transient
	}
	return nil
}

func (m *CryptoKey) GetUnwrapped() *UnwrappedCryptoKey {
	if x, ok := m.GetSource().(*CryptoKey_Unwrapped); ok {
		return x.Unwrapped
	}
	return nil
}

func (m *CryptoKey) GetKmsWrapped() *KmsWrappedCryptoKey {
	if x, ok := m.GetSource().(*CryptoKey_KmsWrapped); ok {
		return x.KmsWrapped
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CryptoKey) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CryptoKey_OneofMarshaler, _CryptoKey_OneofUnmarshaler, _CryptoKey_OneofSizer, []interface{}{
		(*CryptoKey_Transient)(nil),
		(*CryptoKey_Unwrapped)(nil),
		(*CryptoKey_KmsWrapped)(nil),
	}
}

func _CryptoKey_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CryptoKey)
	// source
	switch x := m.Source.(type) {
	case *CryptoKey_Transient:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Transient); err != nil {
			return err
		}
	case *CryptoKey_Unwrapped:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Unwrapped); err != nil {
			return err
		}
	case *CryptoKey_KmsWrapped:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.KmsWrapped); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("CryptoKey.Source has unexpected type %T", x)
	}
	return nil
}

func _CryptoKey_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CryptoKey)
	switch tag {
	case 1: // source.transient
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TransientCryptoKey)
		err := b.DecodeMessage(msg)
		m.Source = &CryptoKey_Transient{msg}
		return true, err
	case 2: // source.unwrapped
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(UnwrappedCryptoKey)
		err := b.DecodeMessage(msg)
		m.Source = &CryptoKey_Unwrapped{msg}
		return true, err
	case 3: // source.kms_wrapped
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(KmsWrappedCryptoKey)
		err := b.DecodeMessage(msg)
		m.Source = &CryptoKey_KmsWrapped{msg}
		return true, err
	default:
		return false, nil
	}
}

func _CryptoKey_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CryptoKey)
	// source
	switch x := m.Source.(type) {
	case *CryptoKey_Transient:
		s := proto.Size(x.Transient)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *CryptoKey_Unwrapped:
		s := proto.Size(x.Unwrapped)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *CryptoKey_KmsWrapped:
		s := proto.Size(x.KmsWrapped)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Use this to have a random data crypto key generated.
// It will be discarded after the request finishes.
type TransientCryptoKey struct {
	// Name of the key. [required]
	// This is an arbitrary string used to differentiate different keys.
	// A unique key is generated per name: two separate `TransientCryptoKey`
	// protos share the same generated key if their names are the same.
	// When the data crypto key is generated, this name is not used in any way
	// (repeating the api call will result in a different key being generated).
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *TransientCryptoKey) Reset()                    { *m = TransientCryptoKey{} }
func (m *TransientCryptoKey) String() string            { return proto.CompactTextString(m) }
func (*TransientCryptoKey) ProtoMessage()               {}
func (*TransientCryptoKey) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{46} }

func (m *TransientCryptoKey) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Using raw keys is prone to security risks due to accidentally
// leaking the key. Choose another type of key if possible.
type UnwrappedCryptoKey struct {
	// The AES 128/192/256 bit key. [required]
	Key []byte `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
}

func (m *UnwrappedCryptoKey) Reset()                    { *m = UnwrappedCryptoKey{} }
func (m *UnwrappedCryptoKey) String() string            { return proto.CompactTextString(m) }
func (*UnwrappedCryptoKey) ProtoMessage()               {}
func (*UnwrappedCryptoKey) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{47} }

func (m *UnwrappedCryptoKey) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

// Include to use an existing data crypto key wrapped by KMS.
// Authorization requires the following IAM permissions when sending a request
// to perform a crypto transformation using a kms-wrapped crypto key:
// dlp.kms.encrypt
type KmsWrappedCryptoKey struct {
	// The wrapped data crypto key. [required]
	WrappedKey []byte `protobuf:"bytes,1,opt,name=wrapped_key,json=wrappedKey,proto3" json:"wrapped_key,omitempty"`
	// The resource name of the KMS CryptoKey to use for unwrapping. [required]
	CryptoKeyName string `protobuf:"bytes,2,opt,name=crypto_key_name,json=cryptoKeyName" json:"crypto_key_name,omitempty"`
}

func (m *KmsWrappedCryptoKey) Reset()                    { *m = KmsWrappedCryptoKey{} }
func (m *KmsWrappedCryptoKey) String() string            { return proto.CompactTextString(m) }
func (*KmsWrappedCryptoKey) ProtoMessage()               {}
func (*KmsWrappedCryptoKey) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{48} }

func (m *KmsWrappedCryptoKey) GetWrappedKey() []byte {
	if m != nil {
		return m.WrappedKey
	}
	return nil
}

func (m *KmsWrappedCryptoKey) GetCryptoKeyName() string {
	if m != nil {
		return m.CryptoKeyName
	}
	return ""
}

// Shifts dates by random number of days, with option to be consistent for the
// same context.
type DateShiftConfig struct {
	// Range of shift in days. Actual shift will be selected at random within this
	// range (inclusive ends). Negative means shift to earlier in time. Must not
	// be more than 365250 days (1000 years) each direction.
	//
	// For example, 3 means shift date to at most 3 days into the future.
	// [Required]
	UpperBoundDays int32 `protobuf:"varint,1,opt,name=upper_bound_days,json=upperBoundDays" json:"upper_bound_days,omitempty"`
	// For example, -5 means shift date to at most 5 days back in the past.
	// [Required]
	LowerBoundDays int32 `protobuf:"varint,2,opt,name=lower_bound_days,json=lowerBoundDays" json:"lower_bound_days,omitempty"`
	// Points to the field that contains the context, for example, an entity id.
	// If set, must also set method. If set, shift will be consistent for the
	// given context.
	Context *FieldId `protobuf:"bytes,3,opt,name=context" json:"context,omitempty"`
	// Method for calculating shift that takes context into consideration. If
	// set, must also set context. Can only be applied to table items.
	//
	// Types that are valid to be assigned to Method:
	//	*DateShiftConfig_CryptoKey
	Method isDateShiftConfig_Method `protobuf_oneof:"method"`
}

func (m *DateShiftConfig) Reset()                    { *m = DateShiftConfig{} }
func (m *DateShiftConfig) String() string            { return proto.CompactTextString(m) }
func (*DateShiftConfig) ProtoMessage()               {}
func (*DateShiftConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{49} }

type isDateShiftConfig_Method interface {
	isDateShiftConfig_Method()
}

type DateShiftConfig_CryptoKey struct {
	CryptoKey *CryptoKey `protobuf:"bytes,4,opt,name=crypto_key,json=cryptoKey,oneof"`
}

func (*DateShiftConfig_CryptoKey) isDateShiftConfig_Method() {}

func (m *DateShiftConfig) GetMethod() isDateShiftConfig_Method {
	if m != nil {
		return m.Method
	}
	return nil
}

func (m *DateShiftConfig) GetUpperBoundDays() int32 {
	if m != nil {
		return m.UpperBoundDays
	}
	return 0
}

func (m *DateShiftConfig) GetLowerBoundDays() int32 {
	if m != nil {
		return m.LowerBoundDays
	}
	return 0
}

func (m *DateShiftConfig) GetContext() *FieldId {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *DateShiftConfig) GetCryptoKey() *CryptoKey {
	if x, ok := m.GetMethod().(*DateShiftConfig_CryptoKey); ok {
		return x.CryptoKey
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*DateShiftConfig) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _DateShiftConfig_OneofMarshaler, _DateShiftConfig_OneofUnmarshaler, _DateShiftConfig_OneofSizer, []interface{}{
		(*DateShiftConfig_CryptoKey)(nil),
	}
}

func _DateShiftConfig_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*DateShiftConfig)
	// method
	switch x := m.Method.(type) {
	case *DateShiftConfig_CryptoKey:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CryptoKey); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("DateShiftConfig.Method has unexpected type %T", x)
	}
	return nil
}

func _DateShiftConfig_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*DateShiftConfig)
	switch tag {
	case 4: // method.crypto_key
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CryptoKey)
		err := b.DecodeMessage(msg)
		m.Method = &DateShiftConfig_CryptoKey{msg}
		return true, err
	default:
		return false, nil
	}
}

func _DateShiftConfig_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*DateShiftConfig)
	// method
	switch x := m.Method.(type) {
	case *DateShiftConfig_CryptoKey:
		s := proto.Size(x.CryptoKey)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A type of transformation that will scan unstructured text and
// apply various `PrimitiveTransformation`s to each finding, where the
// transformation is applied to only values that were identified as a specific
// info_type.
type InfoTypeTransformations struct {
	// Transformation for each infoType. Cannot specify more than one
	// for a given infoType. [required]
	Transformations []*InfoTypeTransformations_InfoTypeTransformation `protobuf:"bytes,1,rep,name=transformations" json:"transformations,omitempty"`
}

func (m *InfoTypeTransformations) Reset()                    { *m = InfoTypeTransformations{} }
func (m *InfoTypeTransformations) String() string            { return proto.CompactTextString(m) }
func (*InfoTypeTransformations) ProtoMessage()               {}
func (*InfoTypeTransformations) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{50} }

func (m *InfoTypeTransformations) GetTransformations() []*InfoTypeTransformations_InfoTypeTransformation {
	if m != nil {
		return m.Transformations
	}
	return nil
}

// A transformation to apply to text that is identified as a specific
// info_type.
type InfoTypeTransformations_InfoTypeTransformation struct {
	// InfoTypes to apply the transformation to. Empty list will match all
	// available infoTypes for this transformation.
	InfoTypes []*InfoType `protobuf:"bytes,1,rep,name=info_types,json=infoTypes" json:"info_types,omitempty"`
	// Primitive transformation to apply to the infoType. [required]
	PrimitiveTransformation *PrimitiveTransformation `protobuf:"bytes,2,opt,name=primitive_transformation,json=primitiveTransformation" json:"primitive_transformation,omitempty"`
}

func (m *InfoTypeTransformations_InfoTypeTransformation) Reset() {
	*m = InfoTypeTransformations_InfoTypeTransformation{}
}
func (m *InfoTypeTransformations_InfoTypeTransformation) String() string {
	return proto.CompactTextString(m)
}
func (*InfoTypeTransformations_InfoTypeTransformation) ProtoMessage() {}
func (*InfoTypeTransformations_InfoTypeTransformation) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{50, 0}
}

func (m *InfoTypeTransformations_InfoTypeTransformation) GetInfoTypes() []*InfoType {
	if m != nil {
		return m.InfoTypes
	}
	return nil
}

func (m *InfoTypeTransformations_InfoTypeTransformation) GetPrimitiveTransformation() *PrimitiveTransformation {
	if m != nil {
		return m.PrimitiveTransformation
	}
	return nil
}

// The transformation to apply to the field.
type FieldTransformation struct {
	// Input field(s) to apply the transformation to. [required]
	Fields []*FieldId `protobuf:"bytes,1,rep,name=fields" json:"fields,omitempty"`
	// Only apply the transformation if the condition evaluates to true for the
	// given `RecordCondition`. The conditions are allowed to reference fields
	// that are not used in the actual transformation. [optional]
	//
	// Example Use Cases:
	//
	// - Apply a different bucket transformation to an age column if the zip code
	// column for the same record is within a specific range.
	// - Redact a field if the date of birth field is greater than 85.
	Condition *RecordCondition `protobuf:"bytes,3,opt,name=condition" json:"condition,omitempty"`
	// Transformation to apply. [required]
	//
	// Types that are valid to be assigned to Transformation:
	//	*FieldTransformation_PrimitiveTransformation
	//	*FieldTransformation_InfoTypeTransformations
	Transformation isFieldTransformation_Transformation `protobuf_oneof:"transformation"`
}

func (m *FieldTransformation) Reset()                    { *m = FieldTransformation{} }
func (m *FieldTransformation) String() string            { return proto.CompactTextString(m) }
func (*FieldTransformation) ProtoMessage()               {}
func (*FieldTransformation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{51} }

type isFieldTransformation_Transformation interface {
	isFieldTransformation_Transformation()
}

type FieldTransformation_PrimitiveTransformation struct {
	PrimitiveTransformation *PrimitiveTransformation `protobuf:"bytes,4,opt,name=primitive_transformation,json=primitiveTransformation,oneof"`
}
type FieldTransformation_InfoTypeTransformations struct {
	InfoTypeTransformations *InfoTypeTransformations `protobuf:"bytes,5,opt,name=info_type_transformations,json=infoTypeTransformations,oneof"`
}

func (*FieldTransformation_PrimitiveTransformation) isFieldTransformation_Transformation() {}
func (*FieldTransformation_InfoTypeTransformations) isFieldTransformation_Transformation() {}

func (m *FieldTransformation) GetTransformation() isFieldTransformation_Transformation {
	if m != nil {
		return m.Transformation
	}
	return nil
}

func (m *FieldTransformation) GetFields() []*FieldId {
	if m != nil {
		return m.Fields
	}
	return nil
}

func (m *FieldTransformation) GetCondition() *RecordCondition {
	if m != nil {
		return m.Condition
	}
	return nil
}

func (m *FieldTransformation) GetPrimitiveTransformation() *PrimitiveTransformation {
	if x, ok := m.GetTransformation().(*FieldTransformation_PrimitiveTransformation); ok {
		return x.PrimitiveTransformation
	}
	return nil
}

func (m *FieldTransformation) GetInfoTypeTransformations() *InfoTypeTransformations {
	if x, ok := m.GetTransformation().(*FieldTransformation_InfoTypeTransformations); ok {
		return x.InfoTypeTransformations
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*FieldTransformation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _FieldTransformation_OneofMarshaler, _FieldTransformation_OneofUnmarshaler, _FieldTransformation_OneofSizer, []interface{}{
		(*FieldTransformation_PrimitiveTransformation)(nil),
		(*FieldTransformation_InfoTypeTransformations)(nil),
	}
}

func _FieldTransformation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*FieldTransformation)
	// transformation
	switch x := m.Transformation.(type) {
	case *FieldTransformation_PrimitiveTransformation:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PrimitiveTransformation); err != nil {
			return err
		}
	case *FieldTransformation_InfoTypeTransformations:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.InfoTypeTransformations); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("FieldTransformation.Transformation has unexpected type %T", x)
	}
	return nil
}

func _FieldTransformation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*FieldTransformation)
	switch tag {
	case 4: // transformation.primitive_transformation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PrimitiveTransformation)
		err := b.DecodeMessage(msg)
		m.Transformation = &FieldTransformation_PrimitiveTransformation{msg}
		return true, err
	case 5: // transformation.info_type_transformations
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(InfoTypeTransformations)
		err := b.DecodeMessage(msg)
		m.Transformation = &FieldTransformation_InfoTypeTransformations{msg}
		return true, err
	default:
		return false, nil
	}
}

func _FieldTransformation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*FieldTransformation)
	// transformation
	switch x := m.Transformation.(type) {
	case *FieldTransformation_PrimitiveTransformation:
		s := proto.Size(x.PrimitiveTransformation)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *FieldTransformation_InfoTypeTransformations:
		s := proto.Size(x.InfoTypeTransformations)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A type of transformation that is applied over structured data such as a
// table.
type RecordTransformations struct {
	// Transform the record by applying various field transformations.
	FieldTransformations []*FieldTransformation `protobuf:"bytes,1,rep,name=field_transformations,json=fieldTransformations" json:"field_transformations,omitempty"`
	// Configuration defining which records get suppressed entirely. Records that
	// match any suppression rule are omitted from the output [optional].
	RecordSuppressions []*RecordSuppression `protobuf:"bytes,2,rep,name=record_suppressions,json=recordSuppressions" json:"record_suppressions,omitempty"`
}

func (m *RecordTransformations) Reset()                    { *m = RecordTransformations{} }
func (m *RecordTransformations) String() string            { return proto.CompactTextString(m) }
func (*RecordTransformations) ProtoMessage()               {}
func (*RecordTransformations) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{52} }

func (m *RecordTransformations) GetFieldTransformations() []*FieldTransformation {
	if m != nil {
		return m.FieldTransformations
	}
	return nil
}

func (m *RecordTransformations) GetRecordSuppressions() []*RecordSuppression {
	if m != nil {
		return m.RecordSuppressions
	}
	return nil
}

// Configuration to suppress records whose suppression conditions evaluate to
// true.
type RecordSuppression struct {
	// A condition that when it evaluates to true will result in the record being
	// evaluated to be suppressed from the transformed content.
	Condition *RecordCondition `protobuf:"bytes,1,opt,name=condition" json:"condition,omitempty"`
}

func (m *RecordSuppression) Reset()                    { *m = RecordSuppression{} }
func (m *RecordSuppression) String() string            { return proto.CompactTextString(m) }
func (*RecordSuppression) ProtoMessage()               {}
func (*RecordSuppression) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{53} }

func (m *RecordSuppression) GetCondition() *RecordCondition {
	if m != nil {
		return m.Condition
	}
	return nil
}

// A condition for determining whether a transformation should be applied to
// a field.
type RecordCondition struct {
	// An expression.
	Expressions *RecordCondition_Expressions `protobuf:"bytes,3,opt,name=expressions" json:"expressions,omitempty"`
}

func (m *RecordCondition) Reset()                    { *m = RecordCondition{} }
func (m *RecordCondition) String() string            { return proto.CompactTextString(m) }
func (*RecordCondition) ProtoMessage()               {}
func (*RecordCondition) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{54} }

func (m *RecordCondition) GetExpressions() *RecordCondition_Expressions {
	if m != nil {
		return m.Expressions
	}
	return nil
}

// The field type of `value` and `field` do not need to match to be
// considered equal, but not all comparisons are possible.
//
// A `value` of type:
//
// - `string` can be compared against all other types
// - `boolean` can only be compared against other booleans
// - `integer` can be compared against doubles or a string if the string value
// can be parsed as an integer.
// - `double` can be compared against integers or a string if the string can
// be parsed as a double.
// - `Timestamp` can be compared against strings in RFC 3339 date string
// format.
// - `TimeOfDay` can be compared against timestamps and strings in the format
// of 'HH:mm:ss'.
//
// If we fail to compare do to type mismatch, a warning will be given and
// the condition will evaluate to false.
type RecordCondition_Condition struct {
	// Field within the record this condition is evaluated against. [required]
	Field *FieldId `protobuf:"bytes,1,opt,name=field" json:"field,omitempty"`
	// Operator used to compare the field or infoType to the value. [required]
	Operator RelationalOperator `protobuf:"varint,3,opt,name=operator,enum=google.privacy.dlp.v2beta2.RelationalOperator" json:"operator,omitempty"`
	// Value to compare against. [Required, except for `EXISTS` tests.]
	Value *Value `protobuf:"bytes,4,opt,name=value" json:"value,omitempty"`
}

func (m *RecordCondition_Condition) Reset()                    { *m = RecordCondition_Condition{} }
func (m *RecordCondition_Condition) String() string            { return proto.CompactTextString(m) }
func (*RecordCondition_Condition) ProtoMessage()               {}
func (*RecordCondition_Condition) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{54, 0} }

func (m *RecordCondition_Condition) GetField() *FieldId {
	if m != nil {
		return m.Field
	}
	return nil
}

func (m *RecordCondition_Condition) GetOperator() RelationalOperator {
	if m != nil {
		return m.Operator
	}
	return RelationalOperator_RELATIONAL_OPERATOR_UNSPECIFIED
}

func (m *RecordCondition_Condition) GetValue() *Value {
	if m != nil {
		return m.Value
	}
	return nil
}

// A collection of conditions.
type RecordCondition_Conditions struct {
	Conditions []*RecordCondition_Condition `protobuf:"bytes,1,rep,name=conditions" json:"conditions,omitempty"`
}

func (m *RecordCondition_Conditions) Reset()                    { *m = RecordCondition_Conditions{} }
func (m *RecordCondition_Conditions) String() string            { return proto.CompactTextString(m) }
func (*RecordCondition_Conditions) ProtoMessage()               {}
func (*RecordCondition_Conditions) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{54, 1} }

func (m *RecordCondition_Conditions) GetConditions() []*RecordCondition_Condition {
	if m != nil {
		return m.Conditions
	}
	return nil
}

// An expression, consisting or an operator and conditions.
type RecordCondition_Expressions struct {
	// The operator to apply to the result of conditions. Default and currently
	// only supported value is `AND`.
	LogicalOperator RecordCondition_Expressions_LogicalOperator `protobuf:"varint,1,opt,name=logical_operator,json=logicalOperator,enum=google.privacy.dlp.v2beta2.RecordCondition_Expressions_LogicalOperator" json:"logical_operator,omitempty"`
	// Types that are valid to be assigned to Type:
	//	*RecordCondition_Expressions_Conditions
	Type isRecordCondition_Expressions_Type `protobuf_oneof:"type"`
}

func (m *RecordCondition_Expressions) Reset()                    { *m = RecordCondition_Expressions{} }
func (m *RecordCondition_Expressions) String() string            { return proto.CompactTextString(m) }
func (*RecordCondition_Expressions) ProtoMessage()               {}
func (*RecordCondition_Expressions) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{54, 2} }

type isRecordCondition_Expressions_Type interface {
	isRecordCondition_Expressions_Type()
}

type RecordCondition_Expressions_Conditions struct {
	Conditions *RecordCondition_Conditions `protobuf:"bytes,3,opt,name=conditions,oneof"`
}

func (*RecordCondition_Expressions_Conditions) isRecordCondition_Expressions_Type() {}

func (m *RecordCondition_Expressions) GetType() isRecordCondition_Expressions_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *RecordCondition_Expressions) GetLogicalOperator() RecordCondition_Expressions_LogicalOperator {
	if m != nil {
		return m.LogicalOperator
	}
	return RecordCondition_Expressions_LOGICAL_OPERATOR_UNSPECIFIED
}

func (m *RecordCondition_Expressions) GetConditions() *RecordCondition_Conditions {
	if x, ok := m.GetType().(*RecordCondition_Expressions_Conditions); ok {
		return x.Conditions
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RecordCondition_Expressions) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RecordCondition_Expressions_OneofMarshaler, _RecordCondition_Expressions_OneofUnmarshaler, _RecordCondition_Expressions_OneofSizer, []interface{}{
		(*RecordCondition_Expressions_Conditions)(nil),
	}
}

func _RecordCondition_Expressions_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RecordCondition_Expressions)
	// type
	switch x := m.Type.(type) {
	case *RecordCondition_Expressions_Conditions:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Conditions); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("RecordCondition_Expressions.Type has unexpected type %T", x)
	}
	return nil
}

func _RecordCondition_Expressions_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RecordCondition_Expressions)
	switch tag {
	case 3: // type.conditions
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RecordCondition_Conditions)
		err := b.DecodeMessage(msg)
		m.Type = &RecordCondition_Expressions_Conditions{msg}
		return true, err
	default:
		return false, nil
	}
}

func _RecordCondition_Expressions_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RecordCondition_Expressions)
	// type
	switch x := m.Type.(type) {
	case *RecordCondition_Expressions_Conditions:
		s := proto.Size(x.Conditions)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Overview of the modifications that occurred.
type TransformationOverview struct {
	// Total size in bytes that were transformed in some way.
	TransformedBytes int64 `protobuf:"varint,2,opt,name=transformed_bytes,json=transformedBytes" json:"transformed_bytes,omitempty"`
	// Transformations applied to the dataset.
	TransformationSummaries []*TransformationSummary `protobuf:"bytes,3,rep,name=transformation_summaries,json=transformationSummaries" json:"transformation_summaries,omitempty"`
}

func (m *TransformationOverview) Reset()                    { *m = TransformationOverview{} }
func (m *TransformationOverview) String() string            { return proto.CompactTextString(m) }
func (*TransformationOverview) ProtoMessage()               {}
func (*TransformationOverview) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{55} }

func (m *TransformationOverview) GetTransformedBytes() int64 {
	if m != nil {
		return m.TransformedBytes
	}
	return 0
}

func (m *TransformationOverview) GetTransformationSummaries() []*TransformationSummary {
	if m != nil {
		return m.TransformationSummaries
	}
	return nil
}

// Summary of a single tranformation.
// Only one of 'transformation', 'field_transformation', or 'record_suppress'
// will be set.
type TransformationSummary struct {
	// Set if the transformation was limited to a specific info_type.
	InfoType *InfoType `protobuf:"bytes,1,opt,name=info_type,json=infoType" json:"info_type,omitempty"`
	// Set if the transformation was limited to a specific FieldId.
	Field *FieldId `protobuf:"bytes,2,opt,name=field" json:"field,omitempty"`
	// The specific transformation these stats apply to.
	Transformation *PrimitiveTransformation `protobuf:"bytes,3,opt,name=transformation" json:"transformation,omitempty"`
	// The field transformation that was applied.
	// If multiple field transformations are requested for a single field,
	// this list will contain all of them; otherwise, only one is supplied.
	FieldTransformations []*FieldTransformation `protobuf:"bytes,5,rep,name=field_transformations,json=fieldTransformations" json:"field_transformations,omitempty"`
	// The specific suppression option these stats apply to.
	RecordSuppress *RecordSuppression                     `protobuf:"bytes,6,opt,name=record_suppress,json=recordSuppress" json:"record_suppress,omitempty"`
	Results        []*TransformationSummary_SummaryResult `protobuf:"bytes,4,rep,name=results" json:"results,omitempty"`
	// Total size in bytes that were transformed in some way.
	TransformedBytes int64 `protobuf:"varint,7,opt,name=transformed_bytes,json=transformedBytes" json:"transformed_bytes,omitempty"`
}

func (m *TransformationSummary) Reset()                    { *m = TransformationSummary{} }
func (m *TransformationSummary) String() string            { return proto.CompactTextString(m) }
func (*TransformationSummary) ProtoMessage()               {}
func (*TransformationSummary) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{56} }

func (m *TransformationSummary) GetInfoType() *InfoType {
	if m != nil {
		return m.InfoType
	}
	return nil
}

func (m *TransformationSummary) GetField() *FieldId {
	if m != nil {
		return m.Field
	}
	return nil
}

func (m *TransformationSummary) GetTransformation() *PrimitiveTransformation {
	if m != nil {
		return m.Transformation
	}
	return nil
}

func (m *TransformationSummary) GetFieldTransformations() []*FieldTransformation {
	if m != nil {
		return m.FieldTransformations
	}
	return nil
}

func (m *TransformationSummary) GetRecordSuppress() *RecordSuppression {
	if m != nil {
		return m.RecordSuppress
	}
	return nil
}

func (m *TransformationSummary) GetResults() []*TransformationSummary_SummaryResult {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *TransformationSummary) GetTransformedBytes() int64 {
	if m != nil {
		return m.TransformedBytes
	}
	return 0
}

// A collection that informs the user the number of times a particular
// `TransformationResultCode` and error details occurred.
type TransformationSummary_SummaryResult struct {
	Count int64                                          `protobuf:"varint,1,opt,name=count" json:"count,omitempty"`
	Code  TransformationSummary_TransformationResultCode `protobuf:"varint,2,opt,name=code,enum=google.privacy.dlp.v2beta2.TransformationSummary_TransformationResultCode" json:"code,omitempty"`
	// A place for warnings or errors to show up if a transformation didn't
	// work as expected.
	Details string `protobuf:"bytes,3,opt,name=details" json:"details,omitempty"`
}

func (m *TransformationSummary_SummaryResult) Reset()         { *m = TransformationSummary_SummaryResult{} }
func (m *TransformationSummary_SummaryResult) String() string { return proto.CompactTextString(m) }
func (*TransformationSummary_SummaryResult) ProtoMessage()    {}
func (*TransformationSummary_SummaryResult) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{56, 0}
}

func (m *TransformationSummary_SummaryResult) GetCount() int64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *TransformationSummary_SummaryResult) GetCode() TransformationSummary_TransformationResultCode {
	if m != nil {
		return m.Code
	}
	return TransformationSummary_TRANSFORMATION_RESULT_CODE_UNSPECIFIED
}

func (m *TransformationSummary_SummaryResult) GetDetails() string {
	if m != nil {
		return m.Details
	}
	return ""
}

// Schedule for triggeredJobs.
type Schedule struct {
	// Types that are valid to be assigned to Option:
	//	*Schedule_ReccurrencePeriodDuration
	Option isSchedule_Option `protobuf_oneof:"option"`
}

func (m *Schedule) Reset()                    { *m = Schedule{} }
func (m *Schedule) String() string            { return proto.CompactTextString(m) }
func (*Schedule) ProtoMessage()               {}
func (*Schedule) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{57} }

type isSchedule_Option interface {
	isSchedule_Option()
}

type Schedule_ReccurrencePeriodDuration struct {
	ReccurrencePeriodDuration *google_protobuf2.Duration `protobuf:"bytes,1,opt,name=reccurrence_period_duration,json=reccurrencePeriodDuration,oneof"`
}

func (*Schedule_ReccurrencePeriodDuration) isSchedule_Option() {}

func (m *Schedule) GetOption() isSchedule_Option {
	if m != nil {
		return m.Option
	}
	return nil
}

func (m *Schedule) GetReccurrencePeriodDuration() *google_protobuf2.Duration {
	if x, ok := m.GetOption().(*Schedule_ReccurrencePeriodDuration); ok {
		return x.ReccurrencePeriodDuration
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Schedule) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Schedule_OneofMarshaler, _Schedule_OneofUnmarshaler, _Schedule_OneofSizer, []interface{}{
		(*Schedule_ReccurrencePeriodDuration)(nil),
	}
}

func _Schedule_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Schedule)
	// option
	switch x := m.Option.(type) {
	case *Schedule_ReccurrencePeriodDuration:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ReccurrencePeriodDuration); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Schedule.Option has unexpected type %T", x)
	}
	return nil
}

func _Schedule_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Schedule)
	switch tag {
	case 1: // option.reccurrence_period_duration
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_protobuf2.Duration)
		err := b.DecodeMessage(msg)
		m.Option = &Schedule_ReccurrencePeriodDuration{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Schedule_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Schedule)
	// option
	switch x := m.Option.(type) {
	case *Schedule_ReccurrencePeriodDuration:
		s := proto.Size(x.ReccurrencePeriodDuration)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The inspectTemplate contains a configuration (set of types of sensitive data
// to be detected) to be used anywhere you otherwise would normally specify
// InspectConfig.
type InspectTemplate struct {
	// The template name. Output only.
	//
	// The template will have one of the following formats:
	// `projects/PROJECT_ID/inspectTemplates/TEMPLATE_ID` OR
	// `organizations/ORGANIZATION_ID/inspectTemplates/TEMPLATE_ID`
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Display name (max 256 chars).
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
	// Short description (max 256 chars).
	Description string `protobuf:"bytes,3,opt,name=description" json:"description,omitempty"`
	// The creation timestamp of a inspectTemplate, output only field.
	CreateTime *google_protobuf1.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime" json:"create_time,omitempty"`
	// The last update timestamp of a inspectTemplate, output only field.
	UpdateTime *google_protobuf1.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime" json:"update_time,omitempty"`
	// The core content of the template. Configuration of the scanning process.
	InspectConfig *InspectConfig `protobuf:"bytes,6,opt,name=inspect_config,json=inspectConfig" json:"inspect_config,omitempty"`
}

func (m *InspectTemplate) Reset()                    { *m = InspectTemplate{} }
func (m *InspectTemplate) String() string            { return proto.CompactTextString(m) }
func (*InspectTemplate) ProtoMessage()               {}
func (*InspectTemplate) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{58} }

func (m *InspectTemplate) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *InspectTemplate) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *InspectTemplate) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *InspectTemplate) GetCreateTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *InspectTemplate) GetUpdateTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *InspectTemplate) GetInspectConfig() *InspectConfig {
	if m != nil {
		return m.InspectConfig
	}
	return nil
}

// The DeidentifyTemplates contains instructions on how to deidentify content.
type DeidentifyTemplate struct {
	// The template name. Output only.
	//
	// The template will have one of the following formats:
	// `projects/PROJECT_ID/deidentifyTemplates/TEMPLATE_ID` OR
	// `organizations/ORGANIZATION_ID/deidentifyTemplates/TEMPLATE_ID`
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Display name (max 256 chars).
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
	// Short description (max 256 chars).
	Description string `protobuf:"bytes,3,opt,name=description" json:"description,omitempty"`
	// The creation timestamp of a inspectTemplate, output only field.
	CreateTime *google_protobuf1.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime" json:"create_time,omitempty"`
	// The last update timestamp of a inspectTemplate, output only field.
	UpdateTime *google_protobuf1.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime" json:"update_time,omitempty"`
	// ///////////// // The core content of the template  // ///////////////
	DeidentifyConfig *DeidentifyConfig `protobuf:"bytes,6,opt,name=deidentify_config,json=deidentifyConfig" json:"deidentify_config,omitempty"`
}

func (m *DeidentifyTemplate) Reset()                    { *m = DeidentifyTemplate{} }
func (m *DeidentifyTemplate) String() string            { return proto.CompactTextString(m) }
func (*DeidentifyTemplate) ProtoMessage()               {}
func (*DeidentifyTemplate) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{59} }

func (m *DeidentifyTemplate) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DeidentifyTemplate) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *DeidentifyTemplate) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *DeidentifyTemplate) GetCreateTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *DeidentifyTemplate) GetUpdateTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *DeidentifyTemplate) GetDeidentifyConfig() *DeidentifyConfig {
	if m != nil {
		return m.DeidentifyConfig
	}
	return nil
}

// Contains a configuration to make dlp api calls on a repeating basis.
type JobTrigger struct {
	// Unique resource name for the triggeredJob, assigned by the service when the
	// triggeredJob is created, for example
	// `projects/dlp-test-project/triggeredJobs/53234423`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Display name (max 100 chars)
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
	// User provided description (max 256 chars)
	Description string `protobuf:"bytes,3,opt,name=description" json:"description,omitempty"`
	// The configuration details for the specific type of job to run.
	//
	// Types that are valid to be assigned to Job:
	//	*JobTrigger_InspectJob
	Job isJobTrigger_Job `protobuf_oneof:"job"`
	// A list of triggers which will be OR'ed together. Only one in the list
	// needs to trigger for a job to be started. The list may contain only
	// a single Schedule trigger and must have at least one object.
	Triggers []*JobTrigger_Trigger `protobuf:"bytes,5,rep,name=triggers" json:"triggers,omitempty"`
	// A stream of errors encountered when the trigger was activated. Repeated
	// errors may result in the JobTrigger automaticaly being paused.
	// Will return the last 100 errors. Whenever the JobTrigger is modified
	// this list will be cleared. Output only field.
	Errors []*JobTrigger_Error `protobuf:"bytes,6,rep,name=errors" json:"errors,omitempty"`
	// The creation timestamp of a triggeredJob, output only field.
	CreateTime *google_protobuf1.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime" json:"create_time,omitempty"`
	// The last update timestamp of a triggeredJob, output only field.
	UpdateTime *google_protobuf1.Timestamp `protobuf:"bytes,8,opt,name=update_time,json=updateTime" json:"update_time,omitempty"`
	// The timestamp of the last time this trigger executed.
	LastRunTime *google_protobuf1.Timestamp `protobuf:"bytes,9,opt,name=last_run_time,json=lastRunTime" json:"last_run_time,omitempty"`
	// A status for this trigger. [required]
	Status JobTrigger_Status `protobuf:"varint,10,opt,name=status,enum=google.privacy.dlp.v2beta2.JobTrigger_Status" json:"status,omitempty"`
}

func (m *JobTrigger) Reset()                    { *m = JobTrigger{} }
func (m *JobTrigger) String() string            { return proto.CompactTextString(m) }
func (*JobTrigger) ProtoMessage()               {}
func (*JobTrigger) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{60} }

type isJobTrigger_Job interface {
	isJobTrigger_Job()
}

type JobTrigger_InspectJob struct {
	InspectJob *InspectJobConfig `protobuf:"bytes,4,opt,name=inspect_job,json=inspectJob,oneof"`
}

func (*JobTrigger_InspectJob) isJobTrigger_Job() {}

func (m *JobTrigger) GetJob() isJobTrigger_Job {
	if m != nil {
		return m.Job
	}
	return nil
}

func (m *JobTrigger) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *JobTrigger) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *JobTrigger) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *JobTrigger) GetInspectJob() *InspectJobConfig {
	if x, ok := m.GetJob().(*JobTrigger_InspectJob); ok {
		return x.InspectJob
	}
	return nil
}

func (m *JobTrigger) GetTriggers() []*JobTrigger_Trigger {
	if m != nil {
		return m.Triggers
	}
	return nil
}

func (m *JobTrigger) GetErrors() []*JobTrigger_Error {
	if m != nil {
		return m.Errors
	}
	return nil
}

func (m *JobTrigger) GetCreateTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *JobTrigger) GetUpdateTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *JobTrigger) GetLastRunTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.LastRunTime
	}
	return nil
}

func (m *JobTrigger) GetStatus() JobTrigger_Status {
	if m != nil {
		return m.Status
	}
	return JobTrigger_STATUS_UNSPECIFIED
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*JobTrigger) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _JobTrigger_OneofMarshaler, _JobTrigger_OneofUnmarshaler, _JobTrigger_OneofSizer, []interface{}{
		(*JobTrigger_InspectJob)(nil),
	}
}

func _JobTrigger_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*JobTrigger)
	// job
	switch x := m.Job.(type) {
	case *JobTrigger_InspectJob:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.InspectJob); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("JobTrigger.Job has unexpected type %T", x)
	}
	return nil
}

func _JobTrigger_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*JobTrigger)
	switch tag {
	case 4: // job.inspect_job
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(InspectJobConfig)
		err := b.DecodeMessage(msg)
		m.Job = &JobTrigger_InspectJob{msg}
		return true, err
	default:
		return false, nil
	}
}

func _JobTrigger_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*JobTrigger)
	// job
	switch x := m.Job.(type) {
	case *JobTrigger_InspectJob:
		s := proto.Size(x.InspectJob)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// What event needs to occur for a new job to be started.
type JobTrigger_Trigger struct {
	// Types that are valid to be assigned to Trigger:
	//	*JobTrigger_Trigger_Schedule
	Trigger isJobTrigger_Trigger_Trigger `protobuf_oneof:"trigger"`
}

func (m *JobTrigger_Trigger) Reset()                    { *m = JobTrigger_Trigger{} }
func (m *JobTrigger_Trigger) String() string            { return proto.CompactTextString(m) }
func (*JobTrigger_Trigger) ProtoMessage()               {}
func (*JobTrigger_Trigger) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{60, 0} }

type isJobTrigger_Trigger_Trigger interface {
	isJobTrigger_Trigger_Trigger()
}

type JobTrigger_Trigger_Schedule struct {
	Schedule *Schedule `protobuf:"bytes,1,opt,name=schedule,oneof"`
}

func (*JobTrigger_Trigger_Schedule) isJobTrigger_Trigger_Trigger() {}

func (m *JobTrigger_Trigger) GetTrigger() isJobTrigger_Trigger_Trigger {
	if m != nil {
		return m.Trigger
	}
	return nil
}

func (m *JobTrigger_Trigger) GetSchedule() *Schedule {
	if x, ok := m.GetTrigger().(*JobTrigger_Trigger_Schedule); ok {
		return x.Schedule
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*JobTrigger_Trigger) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _JobTrigger_Trigger_OneofMarshaler, _JobTrigger_Trigger_OneofUnmarshaler, _JobTrigger_Trigger_OneofSizer, []interface{}{
		(*JobTrigger_Trigger_Schedule)(nil),
	}
}

func _JobTrigger_Trigger_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*JobTrigger_Trigger)
	// trigger
	switch x := m.Trigger.(type) {
	case *JobTrigger_Trigger_Schedule:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Schedule); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("JobTrigger_Trigger.Trigger has unexpected type %T", x)
	}
	return nil
}

func _JobTrigger_Trigger_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*JobTrigger_Trigger)
	switch tag {
	case 1: // trigger.schedule
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Schedule)
		err := b.DecodeMessage(msg)
		m.Trigger = &JobTrigger_Trigger_Schedule{msg}
		return true, err
	default:
		return false, nil
	}
}

func _JobTrigger_Trigger_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*JobTrigger_Trigger)
	// trigger
	switch x := m.Trigger.(type) {
	case *JobTrigger_Trigger_Schedule:
		s := proto.Size(x.Schedule)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The results of an unsuccessful activation of the JobTrigger.
type JobTrigger_Error struct {
	Details *google_rpc.Status `protobuf:"bytes,1,opt,name=details" json:"details,omitempty"`
	// The times the error occurred.
	Timestamps []*google_protobuf1.Timestamp `protobuf:"bytes,2,rep,name=timestamps" json:"timestamps,omitempty"`
}

func (m *JobTrigger_Error) Reset()                    { *m = JobTrigger_Error{} }
func (m *JobTrigger_Error) String() string            { return proto.CompactTextString(m) }
func (*JobTrigger_Error) ProtoMessage()               {}
func (*JobTrigger_Error) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{60, 1} }

func (m *JobTrigger_Error) GetDetails() *google_rpc.Status {
	if m != nil {
		return m.Details
	}
	return nil
}

func (m *JobTrigger_Error) GetTimestamps() []*google_protobuf1.Timestamp {
	if m != nil {
		return m.Timestamps
	}
	return nil
}

// A task to execute on the completion of a job.
type Action struct {
	// Types that are valid to be assigned to Action:
	//	*Action_SaveFindings_
	//	*Action_PubSub
	Action isAction_Action `protobuf_oneof:"action"`
}

func (m *Action) Reset()                    { *m = Action{} }
func (m *Action) String() string            { return proto.CompactTextString(m) }
func (*Action) ProtoMessage()               {}
func (*Action) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{61} }

type isAction_Action interface {
	isAction_Action()
}

type Action_SaveFindings_ struct {
	SaveFindings *Action_SaveFindings `protobuf:"bytes,1,opt,name=save_findings,json=saveFindings,oneof"`
}
type Action_PubSub struct {
	PubSub *Action_PublishToPubSub `protobuf:"bytes,2,opt,name=pub_sub,json=pubSub,oneof"`
}

func (*Action_SaveFindings_) isAction_Action() {}
func (*Action_PubSub) isAction_Action()        {}

func (m *Action) GetAction() isAction_Action {
	if m != nil {
		return m.Action
	}
	return nil
}

func (m *Action) GetSaveFindings() *Action_SaveFindings {
	if x, ok := m.GetAction().(*Action_SaveFindings_); ok {
		return x.SaveFindings
	}
	return nil
}

func (m *Action) GetPubSub() *Action_PublishToPubSub {
	if x, ok := m.GetAction().(*Action_PubSub); ok {
		return x.PubSub
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Action) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Action_OneofMarshaler, _Action_OneofUnmarshaler, _Action_OneofSizer, []interface{}{
		(*Action_SaveFindings_)(nil),
		(*Action_PubSub)(nil),
	}
}

func _Action_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Action)
	// action
	switch x := m.Action.(type) {
	case *Action_SaveFindings_:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SaveFindings); err != nil {
			return err
		}
	case *Action_PubSub:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PubSub); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Action.Action has unexpected type %T", x)
	}
	return nil
}

func _Action_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Action)
	switch tag {
	case 1: // action.save_findings
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Action_SaveFindings)
		err := b.DecodeMessage(msg)
		m.Action = &Action_SaveFindings_{msg}
		return true, err
	case 2: // action.pub_sub
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Action_PublishToPubSub)
		err := b.DecodeMessage(msg)
		m.Action = &Action_PubSub{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Action_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Action)
	// action
	switch x := m.Action.(type) {
	case *Action_SaveFindings_:
		s := proto.Size(x.SaveFindings)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Action_PubSub:
		s := proto.Size(x.PubSub)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// If set, the detailed findings will be persisted to the specified
// OutputStorageConfig. Compatible with: Inspect
type Action_SaveFindings struct {
	OutputConfig *OutputStorageConfig `protobuf:"bytes,1,opt,name=output_config,json=outputConfig" json:"output_config,omitempty"`
}

func (m *Action_SaveFindings) Reset()                    { *m = Action_SaveFindings{} }
func (m *Action_SaveFindings) String() string            { return proto.CompactTextString(m) }
func (*Action_SaveFindings) ProtoMessage()               {}
func (*Action_SaveFindings) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{61, 0} }

func (m *Action_SaveFindings) GetOutputConfig() *OutputStorageConfig {
	if m != nil {
		return m.OutputConfig
	}
	return nil
}

// Publish the results of a DlpJob to a pub sub channel.
// Compatible with: Inpect, Risk
type Action_PublishToPubSub struct {
	// Cloud Pub/Sub topic to send notifications to. The topic must have given
	// publishing access rights to the DLP API service account executing
	// the long running DlpJob sending the notifications.
	// Format is projects/{project}/topics/{topic}.
	Topic string `protobuf:"bytes,1,opt,name=topic" json:"topic,omitempty"`
}

func (m *Action_PublishToPubSub) Reset()                    { *m = Action_PublishToPubSub{} }
func (m *Action_PublishToPubSub) String() string            { return proto.CompactTextString(m) }
func (*Action_PublishToPubSub) ProtoMessage()               {}
func (*Action_PublishToPubSub) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{61, 1} }

func (m *Action_PublishToPubSub) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

// Request message for CreateInspectTemplate.
type CreateInspectTemplateRequest struct {
	// The parent resource name, for example projects/my-project-id or
	// organizations/my-org-id.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// The InspectTemplate to create.
	InspectTemplate *InspectTemplate `protobuf:"bytes,2,opt,name=inspect_template,json=inspectTemplate" json:"inspect_template,omitempty"`
	// The template id can contain uppercase and lowercase letters,
	// numbers, and hyphens; that is, it must match the regular
	// expression: `[a-zA-Z\\d-]+`. The maximum length is 100
	// characters. Can be empty to allow the system to generate one.
	TemplateId string `protobuf:"bytes,3,opt,name=template_id,json=templateId" json:"template_id,omitempty"`
}

func (m *CreateInspectTemplateRequest) Reset()                    { *m = CreateInspectTemplateRequest{} }
func (m *CreateInspectTemplateRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateInspectTemplateRequest) ProtoMessage()               {}
func (*CreateInspectTemplateRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{62} }

func (m *CreateInspectTemplateRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateInspectTemplateRequest) GetInspectTemplate() *InspectTemplate {
	if m != nil {
		return m.InspectTemplate
	}
	return nil
}

func (m *CreateInspectTemplateRequest) GetTemplateId() string {
	if m != nil {
		return m.TemplateId
	}
	return ""
}

// Request message for UpdateInspectTemplate.
type UpdateInspectTemplateRequest struct {
	// Resource name of organization and inspectTemplate to be updated, for
	// example `organizations/433245324/inspectTemplates/432452342` or
	// projects/project-id/inspectTemplates/432452342.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// New InspectTemplate value.
	InspectTemplate *InspectTemplate `protobuf:"bytes,2,opt,name=inspect_template,json=inspectTemplate" json:"inspect_template,omitempty"`
	// Mask to control which fields get updated.
	UpdateMask *google_protobuf4.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
}

func (m *UpdateInspectTemplateRequest) Reset()                    { *m = UpdateInspectTemplateRequest{} }
func (m *UpdateInspectTemplateRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateInspectTemplateRequest) ProtoMessage()               {}
func (*UpdateInspectTemplateRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{63} }

func (m *UpdateInspectTemplateRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateInspectTemplateRequest) GetInspectTemplate() *InspectTemplate {
	if m != nil {
		return m.InspectTemplate
	}
	return nil
}

func (m *UpdateInspectTemplateRequest) GetUpdateMask() *google_protobuf4.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for GetInspectTemplate.
type GetInspectTemplateRequest struct {
	// Resource name of the organization and inspectTemplate to be read, for
	// example `organizations/433245324/inspectTemplates/432452342` or
	// projects/project-id/inspectTemplates/432452342.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetInspectTemplateRequest) Reset()                    { *m = GetInspectTemplateRequest{} }
func (m *GetInspectTemplateRequest) String() string            { return proto.CompactTextString(m) }
func (*GetInspectTemplateRequest) ProtoMessage()               {}
func (*GetInspectTemplateRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{64} }

func (m *GetInspectTemplateRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for ListInspectTemplates.
type ListInspectTemplatesRequest struct {
	// The parent resource name, for example projects/my-project-id or
	// organizations/my-org-id.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Optional page token to continue retrieval. Comes from previous call
	// to `ListInspectTemplates`.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// Optional size of the page, can be limited by server. If zero server returns
	// a page of max size 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
}

func (m *ListInspectTemplatesRequest) Reset()                    { *m = ListInspectTemplatesRequest{} }
func (m *ListInspectTemplatesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListInspectTemplatesRequest) ProtoMessage()               {}
func (*ListInspectTemplatesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{65} }

func (m *ListInspectTemplatesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListInspectTemplatesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListInspectTemplatesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// Response message for ListInspectTemplates.
type ListInspectTemplatesResponse struct {
	// List of inspectTemplates, up to page_size in ListInspectTemplatesRequest.
	InspectTemplates []*InspectTemplate `protobuf:"bytes,1,rep,name=inspect_templates,json=inspectTemplates" json:"inspect_templates,omitempty"`
	// If the next page is available then the next page token to be used
	// in following ListInspectTemplates request.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListInspectTemplatesResponse) Reset()                    { *m = ListInspectTemplatesResponse{} }
func (m *ListInspectTemplatesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListInspectTemplatesResponse) ProtoMessage()               {}
func (*ListInspectTemplatesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{66} }

func (m *ListInspectTemplatesResponse) GetInspectTemplates() []*InspectTemplate {
	if m != nil {
		return m.InspectTemplates
	}
	return nil
}

func (m *ListInspectTemplatesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for DeleteInspectTemplate.
type DeleteInspectTemplateRequest struct {
	// Resource name of the organization and inspectTemplate to be deleted, for
	// example `organizations/433245324/inspectTemplates/432452342` or
	// projects/project-id/inspectTemplates/432452342.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteInspectTemplateRequest) Reset()                    { *m = DeleteInspectTemplateRequest{} }
func (m *DeleteInspectTemplateRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteInspectTemplateRequest) ProtoMessage()               {}
func (*DeleteInspectTemplateRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{67} }

func (m *DeleteInspectTemplateRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for CreateJobTrigger.
type CreateJobTriggerRequest struct {
	// The parent resource name, for example projects/my-project-id.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// The JobTrigger to create.
	JobTrigger *JobTrigger `protobuf:"bytes,2,opt,name=job_trigger,json=jobTrigger" json:"job_trigger,omitempty"`
	// The trigger id can contain uppercase and lowercase letters,
	// numbers, and hyphens; that is, it must match the regular
	// expression: `[a-zA-Z\\d-]+`. The maximum length is 100
	// characters. Can be empty to allow the system to generate one.
	TriggerId string `protobuf:"bytes,3,opt,name=trigger_id,json=triggerId" json:"trigger_id,omitempty"`
}

func (m *CreateJobTriggerRequest) Reset()                    { *m = CreateJobTriggerRequest{} }
func (m *CreateJobTriggerRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateJobTriggerRequest) ProtoMessage()               {}
func (*CreateJobTriggerRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{68} }

func (m *CreateJobTriggerRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateJobTriggerRequest) GetJobTrigger() *JobTrigger {
	if m != nil {
		return m.JobTrigger
	}
	return nil
}

func (m *CreateJobTriggerRequest) GetTriggerId() string {
	if m != nil {
		return m.TriggerId
	}
	return ""
}

// Request message for UpdateJobTrigger.
type UpdateJobTriggerRequest struct {
	// Resource name of the project and the triggeredJob, for example
	// `projects/dlp-test-project/jobTriggers/53234423`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// New JobTrigger value.
	JobTrigger *JobTrigger `protobuf:"bytes,2,opt,name=job_trigger,json=jobTrigger" json:"job_trigger,omitempty"`
	// Mask to control which fields get updated.
	UpdateMask *google_protobuf4.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
}

func (m *UpdateJobTriggerRequest) Reset()                    { *m = UpdateJobTriggerRequest{} }
func (m *UpdateJobTriggerRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateJobTriggerRequest) ProtoMessage()               {}
func (*UpdateJobTriggerRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{69} }

func (m *UpdateJobTriggerRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateJobTriggerRequest) GetJobTrigger() *JobTrigger {
	if m != nil {
		return m.JobTrigger
	}
	return nil
}

func (m *UpdateJobTriggerRequest) GetUpdateMask() *google_protobuf4.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for GetJobTrigger.
type GetJobTriggerRequest struct {
	// Resource name of the project and the triggeredJob, for example
	// `projects/dlp-test-project/jobTriggers/53234423`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetJobTriggerRequest) Reset()                    { *m = GetJobTriggerRequest{} }
func (m *GetJobTriggerRequest) String() string            { return proto.CompactTextString(m) }
func (*GetJobTriggerRequest) ProtoMessage()               {}
func (*GetJobTriggerRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{70} }

func (m *GetJobTriggerRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for ListJobTriggers.
type ListJobTriggersRequest struct {
	// The parent resource name, for example projects/my-project-id.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Optional page token to continue retrieval. Comes from previous call
	// to ListJobTriggers. `order_by` and `filter` should not change for
	// subsequent calls, but can be omitted if token is specified.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// Optional size of the page, can be limited by a server.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Optional comma separated list of triggeredJob fields to order by,
	// followed by 'asc/desc' postfix, i.e.
	// `"create_time asc,name desc,schedule_mode asc"`. This list is
	// case-insensitive.
	//
	// Example: `"name asc,schedule_mode desc, status desc"`
	//
	// Supported filters keys and values are:
	//
	// - `create_time`: corresponds to time the triggeredJob was created.
	// - `update_time`: corresponds to time the triggeredJob was last updated.
	// - `name`: corresponds to JobTrigger's display name.
	// - `status`: corresponds to the triggeredJob status.
	OrderBy string `protobuf:"bytes,4,opt,name=order_by,json=orderBy" json:"order_by,omitempty"`
}

func (m *ListJobTriggersRequest) Reset()                    { *m = ListJobTriggersRequest{} }
func (m *ListJobTriggersRequest) String() string            { return proto.CompactTextString(m) }
func (*ListJobTriggersRequest) ProtoMessage()               {}
func (*ListJobTriggersRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{71} }

func (m *ListJobTriggersRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListJobTriggersRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListJobTriggersRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListJobTriggersRequest) GetOrderBy() string {
	if m != nil {
		return m.OrderBy
	}
	return ""
}

// Response message for ListJobTriggers.
type ListJobTriggersResponse struct {
	// List of triggeredJobs, up to page_size in ListJobTriggersRequest.
	JobTriggers []*JobTrigger `protobuf:"bytes,1,rep,name=job_triggers,json=jobTriggers" json:"job_triggers,omitempty"`
	// If the next page is available then the next page token to be used
	// in following ListJobTriggers request.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListJobTriggersResponse) Reset()                    { *m = ListJobTriggersResponse{} }
func (m *ListJobTriggersResponse) String() string            { return proto.CompactTextString(m) }
func (*ListJobTriggersResponse) ProtoMessage()               {}
func (*ListJobTriggersResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{72} }

func (m *ListJobTriggersResponse) GetJobTriggers() []*JobTrigger {
	if m != nil {
		return m.JobTriggers
	}
	return nil
}

func (m *ListJobTriggersResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for DeleteJobTrigger.
type DeleteJobTriggerRequest struct {
	// Resource name of the project and the triggeredJob, for example
	// `projects/dlp-test-project/jobTriggers/53234423`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteJobTriggerRequest) Reset()                    { *m = DeleteJobTriggerRequest{} }
func (m *DeleteJobTriggerRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteJobTriggerRequest) ProtoMessage()               {}
func (*DeleteJobTriggerRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{73} }

func (m *DeleteJobTriggerRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type InspectJobConfig struct {
	// The data to scan.
	StorageConfig *StorageConfig `protobuf:"bytes,1,opt,name=storage_config,json=storageConfig" json:"storage_config,omitempty"`
	// Where to put the findings.
	OutputConfig *OutputStorageConfig `protobuf:"bytes,2,opt,name=output_config,json=outputConfig" json:"output_config,omitempty"`
	// How and what to scan for.
	InspectConfig *InspectConfig `protobuf:"bytes,3,opt,name=inspect_config,json=inspectConfig" json:"inspect_config,omitempty"`
	// If provided, will be used as the default for all values in InspectConfig.
	// `inspect_config` will be merged into the values persisted as part of the
	// template.
	InspectTemplateName string `protobuf:"bytes,4,opt,name=inspect_template_name,json=inspectTemplateName" json:"inspect_template_name,omitempty"`
	// Actions to execute at the completion of the job. Are executed in the order
	// provided.
	Actions []*Action `protobuf:"bytes,5,rep,name=actions" json:"actions,omitempty"`
}

func (m *InspectJobConfig) Reset()                    { *m = InspectJobConfig{} }
func (m *InspectJobConfig) String() string            { return proto.CompactTextString(m) }
func (*InspectJobConfig) ProtoMessage()               {}
func (*InspectJobConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{74} }

func (m *InspectJobConfig) GetStorageConfig() *StorageConfig {
	if m != nil {
		return m.StorageConfig
	}
	return nil
}

func (m *InspectJobConfig) GetOutputConfig() *OutputStorageConfig {
	if m != nil {
		return m.OutputConfig
	}
	return nil
}

func (m *InspectJobConfig) GetInspectConfig() *InspectConfig {
	if m != nil {
		return m.InspectConfig
	}
	return nil
}

func (m *InspectJobConfig) GetInspectTemplateName() string {
	if m != nil {
		return m.InspectTemplateName
	}
	return ""
}

func (m *InspectJobConfig) GetActions() []*Action {
	if m != nil {
		return m.Actions
	}
	return nil
}

// Combines all of the information about a DLP job.
type DlpJob struct {
	// The server-assigned name.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The type of job.
	Type DlpJobType `protobuf:"varint,2,opt,name=type,enum=google.privacy.dlp.v2beta2.DlpJobType" json:"type,omitempty"`
	// State of a job.
	State DlpJob_JobState `protobuf:"varint,3,opt,name=state,enum=google.privacy.dlp.v2beta2.DlpJob_JobState" json:"state,omitempty"`
	// Types that are valid to be assigned to Details:
	//	*DlpJob_RiskDetails
	//	*DlpJob_InspectDetails
	Details isDlpJob_Details `protobuf_oneof:"details"`
	// Time when the job was created.
	CreateTime *google_protobuf1.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime" json:"create_time,omitempty"`
	// Time when the job started.
	StartTime *google_protobuf1.Timestamp `protobuf:"bytes,7,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// Time when the job finished.
	EndTime *google_protobuf1.Timestamp `protobuf:"bytes,8,opt,name=end_time,json=endTime" json:"end_time,omitempty"`
	// A stream of errors encountered running the job.
	ErrorResults []*google_rpc.Status `protobuf:"bytes,9,rep,name=error_results,json=errorResults" json:"error_results,omitempty"`
	// If created by a job trigger, the resource name of the trigger that
	// instantiated the job.
	JobTriggerName string `protobuf:"bytes,10,opt,name=job_trigger_name,json=jobTriggerName" json:"job_trigger_name,omitempty"`
}

func (m *DlpJob) Reset()                    { *m = DlpJob{} }
func (m *DlpJob) String() string            { return proto.CompactTextString(m) }
func (*DlpJob) ProtoMessage()               {}
func (*DlpJob) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{75} }

type isDlpJob_Details interface {
	isDlpJob_Details()
}

type DlpJob_RiskDetails struct {
	RiskDetails *AnalyzeDataSourceRiskDetails `protobuf:"bytes,4,opt,name=risk_details,json=riskDetails,oneof"`
}
type DlpJob_InspectDetails struct {
	InspectDetails *InspectDataSourceDetails `protobuf:"bytes,5,opt,name=inspect_details,json=inspectDetails,oneof"`
}

func (*DlpJob_RiskDetails) isDlpJob_Details()    {}
func (*DlpJob_InspectDetails) isDlpJob_Details() {}

func (m *DlpJob) GetDetails() isDlpJob_Details {
	if m != nil {
		return m.Details
	}
	return nil
}

func (m *DlpJob) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DlpJob) GetType() DlpJobType {
	if m != nil {
		return m.Type
	}
	return DlpJobType_DLP_JOB_TYPE_UNSPECIFIED
}

func (m *DlpJob) GetState() DlpJob_JobState {
	if m != nil {
		return m.State
	}
	return DlpJob_JOB_STATE_UNSPECIFIED
}

func (m *DlpJob) GetRiskDetails() *AnalyzeDataSourceRiskDetails {
	if x, ok := m.GetDetails().(*DlpJob_RiskDetails); ok {
		return x.RiskDetails
	}
	return nil
}

func (m *DlpJob) GetInspectDetails() *InspectDataSourceDetails {
	if x, ok := m.GetDetails().(*DlpJob_InspectDetails); ok {
		return x.InspectDetails
	}
	return nil
}

func (m *DlpJob) GetCreateTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *DlpJob) GetStartTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *DlpJob) GetEndTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *DlpJob) GetErrorResults() []*google_rpc.Status {
	if m != nil {
		return m.ErrorResults
	}
	return nil
}

func (m *DlpJob) GetJobTriggerName() string {
	if m != nil {
		return m.JobTriggerName
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*DlpJob) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _DlpJob_OneofMarshaler, _DlpJob_OneofUnmarshaler, _DlpJob_OneofSizer, []interface{}{
		(*DlpJob_RiskDetails)(nil),
		(*DlpJob_InspectDetails)(nil),
	}
}

func _DlpJob_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*DlpJob)
	// details
	switch x := m.Details.(type) {
	case *DlpJob_RiskDetails:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RiskDetails); err != nil {
			return err
		}
	case *DlpJob_InspectDetails:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.InspectDetails); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("DlpJob.Details has unexpected type %T", x)
	}
	return nil
}

func _DlpJob_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*DlpJob)
	switch tag {
	case 4: // details.risk_details
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AnalyzeDataSourceRiskDetails)
		err := b.DecodeMessage(msg)
		m.Details = &DlpJob_RiskDetails{msg}
		return true, err
	case 5: // details.inspect_details
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(InspectDataSourceDetails)
		err := b.DecodeMessage(msg)
		m.Details = &DlpJob_InspectDetails{msg}
		return true, err
	default:
		return false, nil
	}
}

func _DlpJob_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*DlpJob)
	// details
	switch x := m.Details.(type) {
	case *DlpJob_RiskDetails:
		s := proto.Size(x.RiskDetails)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *DlpJob_InspectDetails:
		s := proto.Size(x.InspectDetails)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The request message for [DlpJobs.GetDlpJob][].
type GetDlpJobRequest struct {
	// The name of the DlpJob resource.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetDlpJobRequest) Reset()                    { *m = GetDlpJobRequest{} }
func (m *GetDlpJobRequest) String() string            { return proto.CompactTextString(m) }
func (*GetDlpJobRequest) ProtoMessage()               {}
func (*GetDlpJobRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{76} }

func (m *GetDlpJobRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request message for listing DLP jobs.
type ListDlpJobsRequest struct {
	// The parent resource name, for example projects/my-project-id.
	Parent string `protobuf:"bytes,4,opt,name=parent" json:"parent,omitempty"`
	// Optional. Allows filtering.
	//
	// Supported syntax:
	//
	// * Filter expressions are made up of one or more restrictions.
	// * Restrictions can be combined by `AND` or `OR` logical operators. A
	// sequence of restrictions implicitly uses `AND`.
	// * A restriction has the form of `<field> <operator> <value>`.
	// * Supported fields/values for inspect jobs:
	//     - `state` - PENDING|RUNNING|CANCELED|FINISHED|FAILED
	//     - `inspected_storage` - DATASTORE|CLOUD_STORAGE|BIGQUERY
	//     - `trigger_name` - The resource name of the trigger that created job.
	// * Supported fields for risk analysis jobs:
	//     - `state` - RUNNING|CANCELED|FINISHED|FAILED
	// * The operator must be `=` or `!=`.
	//
	// Examples:
	//
	// * inspected_storage = cloud_storage AND state = done
	// * inspected_storage = cloud_storage OR inspected_storage = bigquery
	// * inspected_storage = cloud_storage AND (state = done OR state = canceled)
	//
	// The length of this field should be no more than 500 characters.
	Filter string `protobuf:"bytes,1,opt,name=filter" json:"filter,omitempty"`
	// The standard list page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// The standard list page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// The type of job. Defaults to `DlpJobType.INSPECT`
	Type DlpJobType `protobuf:"varint,5,opt,name=type,enum=google.privacy.dlp.v2beta2.DlpJobType" json:"type,omitempty"`
}

func (m *ListDlpJobsRequest) Reset()                    { *m = ListDlpJobsRequest{} }
func (m *ListDlpJobsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListDlpJobsRequest) ProtoMessage()               {}
func (*ListDlpJobsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{77} }

func (m *ListDlpJobsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListDlpJobsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListDlpJobsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListDlpJobsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListDlpJobsRequest) GetType() DlpJobType {
	if m != nil {
		return m.Type
	}
	return DlpJobType_DLP_JOB_TYPE_UNSPECIFIED
}

// The response message for listing DLP jobs.
type ListDlpJobsResponse struct {
	// A list of DlpJobs that matches the specified filter in the request.
	Jobs []*DlpJob `protobuf:"bytes,1,rep,name=jobs" json:"jobs,omitempty"`
	// The standard List next-page token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListDlpJobsResponse) Reset()                    { *m = ListDlpJobsResponse{} }
func (m *ListDlpJobsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListDlpJobsResponse) ProtoMessage()               {}
func (*ListDlpJobsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{78} }

func (m *ListDlpJobsResponse) GetJobs() []*DlpJob {
	if m != nil {
		return m.Jobs
	}
	return nil
}

func (m *ListDlpJobsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request message for canceling a DLP job.
type CancelDlpJobRequest struct {
	// The name of the DlpJob resource to be cancelled.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *CancelDlpJobRequest) Reset()                    { *m = CancelDlpJobRequest{} }
func (m *CancelDlpJobRequest) String() string            { return proto.CompactTextString(m) }
func (*CancelDlpJobRequest) ProtoMessage()               {}
func (*CancelDlpJobRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{79} }

func (m *CancelDlpJobRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request message for deleting a DLP job.
type DeleteDlpJobRequest struct {
	// The name of the DlpJob resource to be deleted.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteDlpJobRequest) Reset()                    { *m = DeleteDlpJobRequest{} }
func (m *DeleteDlpJobRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteDlpJobRequest) ProtoMessage()               {}
func (*DeleteDlpJobRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{80} }

func (m *DeleteDlpJobRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for CreateDeidentifyTemplate.
type CreateDeidentifyTemplateRequest struct {
	// The parent resource name, for example projects/my-project-id or
	// organizations/my-org-id.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// The DeidentifyTemplate to create.
	DeidentifyTemplate *DeidentifyTemplate `protobuf:"bytes,2,opt,name=deidentify_template,json=deidentifyTemplate" json:"deidentify_template,omitempty"`
	// The template id can contain uppercase and lowercase letters,
	// numbers, and hyphens; that is, it must match the regular
	// expression: `[a-zA-Z\\d-]+`. The maximum length is 100
	// characters. Can be empty to allow the system to generate one.
	TemplateId string `protobuf:"bytes,3,opt,name=template_id,json=templateId" json:"template_id,omitempty"`
}

func (m *CreateDeidentifyTemplateRequest) Reset()         { *m = CreateDeidentifyTemplateRequest{} }
func (m *CreateDeidentifyTemplateRequest) String() string { return proto.CompactTextString(m) }
func (*CreateDeidentifyTemplateRequest) ProtoMessage()    {}
func (*CreateDeidentifyTemplateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{81}
}

func (m *CreateDeidentifyTemplateRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateDeidentifyTemplateRequest) GetDeidentifyTemplate() *DeidentifyTemplate {
	if m != nil {
		return m.DeidentifyTemplate
	}
	return nil
}

func (m *CreateDeidentifyTemplateRequest) GetTemplateId() string {
	if m != nil {
		return m.TemplateId
	}
	return ""
}

// Request message for UpdateDeidentifyTemplate.
type UpdateDeidentifyTemplateRequest struct {
	// Resource name of organization and deidentify template to be updated, for
	// example `organizations/433245324/deidentifyTemplates/432452342` or
	// projects/project-id/deidentifyTemplates/432452342.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// New DeidentifyTemplate value.
	DeidentifyTemplate *DeidentifyTemplate `protobuf:"bytes,2,opt,name=deidentify_template,json=deidentifyTemplate" json:"deidentify_template,omitempty"`
	// Mask to control which fields get updated.
	UpdateMask *google_protobuf4.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
}

func (m *UpdateDeidentifyTemplateRequest) Reset()         { *m = UpdateDeidentifyTemplateRequest{} }
func (m *UpdateDeidentifyTemplateRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateDeidentifyTemplateRequest) ProtoMessage()    {}
func (*UpdateDeidentifyTemplateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{82}
}

func (m *UpdateDeidentifyTemplateRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateDeidentifyTemplateRequest) GetDeidentifyTemplate() *DeidentifyTemplate {
	if m != nil {
		return m.DeidentifyTemplate
	}
	return nil
}

func (m *UpdateDeidentifyTemplateRequest) GetUpdateMask() *google_protobuf4.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for GetDeidentifyTemplate.
type GetDeidentifyTemplateRequest struct {
	// Resource name of the organization and deidentify template to be read, for
	// example `organizations/433245324/deidentifyTemplates/432452342` or
	// projects/project-id/deidentifyTemplates/432452342.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetDeidentifyTemplateRequest) Reset()                    { *m = GetDeidentifyTemplateRequest{} }
func (m *GetDeidentifyTemplateRequest) String() string            { return proto.CompactTextString(m) }
func (*GetDeidentifyTemplateRequest) ProtoMessage()               {}
func (*GetDeidentifyTemplateRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{83} }

func (m *GetDeidentifyTemplateRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for ListDeidentifyTemplates.
type ListDeidentifyTemplatesRequest struct {
	// The parent resource name, for example projects/my-project-id or
	// organizations/my-org-id.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Optional page token to continue retrieval. Comes from previous call
	// to `ListDeidentifyTemplates`.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// Optional size of the page, can be limited by server. If zero server returns
	// a page of max size 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
}

func (m *ListDeidentifyTemplatesRequest) Reset()                    { *m = ListDeidentifyTemplatesRequest{} }
func (m *ListDeidentifyTemplatesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListDeidentifyTemplatesRequest) ProtoMessage()               {}
func (*ListDeidentifyTemplatesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{84} }

func (m *ListDeidentifyTemplatesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListDeidentifyTemplatesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListDeidentifyTemplatesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// Response message for ListDeidentifyTemplates.
type ListDeidentifyTemplatesResponse struct {
	// List of deidentify templates, up to page_size in
	// ListDeidentifyTemplatesRequest.
	DeidentifyTemplates []*DeidentifyTemplate `protobuf:"bytes,1,rep,name=deidentify_templates,json=deidentifyTemplates" json:"deidentify_templates,omitempty"`
	// If the next page is available then the next page token to be used
	// in following ListDeidentifyTemplates request.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListDeidentifyTemplatesResponse) Reset()         { *m = ListDeidentifyTemplatesResponse{} }
func (m *ListDeidentifyTemplatesResponse) String() string { return proto.CompactTextString(m) }
func (*ListDeidentifyTemplatesResponse) ProtoMessage()    {}
func (*ListDeidentifyTemplatesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{85}
}

func (m *ListDeidentifyTemplatesResponse) GetDeidentifyTemplates() []*DeidentifyTemplate {
	if m != nil {
		return m.DeidentifyTemplates
	}
	return nil
}

func (m *ListDeidentifyTemplatesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for DeleteDeidentifyTemplate.
type DeleteDeidentifyTemplateRequest struct {
	// Resource name of the organization and deidentify template to be deleted,
	// for example `organizations/433245324/deidentifyTemplates/432452342` or
	// projects/project-id/deidentifyTemplates/432452342.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteDeidentifyTemplateRequest) Reset()         { *m = DeleteDeidentifyTemplateRequest{} }
func (m *DeleteDeidentifyTemplateRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteDeidentifyTemplateRequest) ProtoMessage()    {}
func (*DeleteDeidentifyTemplateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{86}
}

func (m *DeleteDeidentifyTemplateRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func init() {
	proto.RegisterType((*InspectConfig)(nil), "google.privacy.dlp.v2beta2.InspectConfig")
	proto.RegisterType((*InspectConfig_FindingLimits)(nil), "google.privacy.dlp.v2beta2.InspectConfig.FindingLimits")
	proto.RegisterType((*InspectConfig_FindingLimits_InfoTypeLimit)(nil), "google.privacy.dlp.v2beta2.InspectConfig.FindingLimits.InfoTypeLimit")
	proto.RegisterType((*ContentItem)(nil), "google.privacy.dlp.v2beta2.ContentItem")
	proto.RegisterType((*Table)(nil), "google.privacy.dlp.v2beta2.Table")
	proto.RegisterType((*Table_Row)(nil), "google.privacy.dlp.v2beta2.Table.Row")
	proto.RegisterType((*InspectResult)(nil), "google.privacy.dlp.v2beta2.InspectResult")
	proto.RegisterType((*Finding)(nil), "google.privacy.dlp.v2beta2.Finding")
	proto.RegisterType((*Location)(nil), "google.privacy.dlp.v2beta2.Location")
	proto.RegisterType((*TableLocation)(nil), "google.privacy.dlp.v2beta2.TableLocation")
	proto.RegisterType((*Range)(nil), "google.privacy.dlp.v2beta2.Range")
	proto.RegisterType((*ImageLocation)(nil), "google.privacy.dlp.v2beta2.ImageLocation")
	proto.RegisterType((*RedactImageRequest)(nil), "google.privacy.dlp.v2beta2.RedactImageRequest")
	proto.RegisterType((*RedactImageRequest_ImageRedactionConfig)(nil), "google.privacy.dlp.v2beta2.RedactImageRequest.ImageRedactionConfig")
	proto.RegisterType((*Color)(nil), "google.privacy.dlp.v2beta2.Color")
	proto.RegisterType((*RedactImageResponse)(nil), "google.privacy.dlp.v2beta2.RedactImageResponse")
	proto.RegisterType((*DeidentifyContentRequest)(nil), "google.privacy.dlp.v2beta2.DeidentifyContentRequest")
	proto.RegisterType((*DeidentifyContentResponse)(nil), "google.privacy.dlp.v2beta2.DeidentifyContentResponse")
	proto.RegisterType((*ReidentifyContentRequest)(nil), "google.privacy.dlp.v2beta2.ReidentifyContentRequest")
	proto.RegisterType((*ReidentifyContentResponse)(nil), "google.privacy.dlp.v2beta2.ReidentifyContentResponse")
	proto.RegisterType((*InspectContentRequest)(nil), "google.privacy.dlp.v2beta2.InspectContentRequest")
	proto.RegisterType((*InspectContentResponse)(nil), "google.privacy.dlp.v2beta2.InspectContentResponse")
	proto.RegisterType((*InspectDataSourceRequest)(nil), "google.privacy.dlp.v2beta2.InspectDataSourceRequest")
	proto.RegisterType((*OutputStorageConfig)(nil), "google.privacy.dlp.v2beta2.OutputStorageConfig")
	proto.RegisterType((*InfoTypeStatistics)(nil), "google.privacy.dlp.v2beta2.InfoTypeStatistics")
	proto.RegisterType((*InspectDataSourceDetails)(nil), "google.privacy.dlp.v2beta2.InspectDataSourceDetails")
	proto.RegisterType((*InspectDataSourceDetails_RequestedOptions)(nil), "google.privacy.dlp.v2beta2.InspectDataSourceDetails.RequestedOptions")
	proto.RegisterType((*InspectDataSourceDetails_Result)(nil), "google.privacy.dlp.v2beta2.InspectDataSourceDetails.Result")
	proto.RegisterType((*InfoTypeDescription)(nil), "google.privacy.dlp.v2beta2.InfoTypeDescription")
	proto.RegisterType((*ListInfoTypesRequest)(nil), "google.privacy.dlp.v2beta2.ListInfoTypesRequest")
	proto.RegisterType((*ListInfoTypesResponse)(nil), "google.privacy.dlp.v2beta2.ListInfoTypesResponse")
	proto.RegisterType((*AnalyzeDataSourceRiskRequest)(nil), "google.privacy.dlp.v2beta2.AnalyzeDataSourceRiskRequest")
	proto.RegisterType((*RiskAnalysisJobConfig)(nil), "google.privacy.dlp.v2beta2.RiskAnalysisJobConfig")
	proto.RegisterType((*PrivacyMetric)(nil), "google.privacy.dlp.v2beta2.PrivacyMetric")
	proto.RegisterType((*PrivacyMetric_NumericalStatsConfig)(nil), "google.privacy.dlp.v2beta2.PrivacyMetric.NumericalStatsConfig")
	proto.RegisterType((*PrivacyMetric_CategoricalStatsConfig)(nil), "google.privacy.dlp.v2beta2.PrivacyMetric.CategoricalStatsConfig")
	proto.RegisterType((*PrivacyMetric_KAnonymityConfig)(nil), "google.privacy.dlp.v2beta2.PrivacyMetric.KAnonymityConfig")
	proto.RegisterType((*PrivacyMetric_LDiversityConfig)(nil), "google.privacy.dlp.v2beta2.PrivacyMetric.LDiversityConfig")
	proto.RegisterType((*PrivacyMetric_KMapEstimationConfig)(nil), "google.privacy.dlp.v2beta2.PrivacyMetric.KMapEstimationConfig")
	proto.RegisterType((*PrivacyMetric_KMapEstimationConfig_TaggedField)(nil), "google.privacy.dlp.v2beta2.PrivacyMetric.KMapEstimationConfig.TaggedField")
	proto.RegisterType((*PrivacyMetric_KMapEstimationConfig_AuxiliaryTable)(nil), "google.privacy.dlp.v2beta2.PrivacyMetric.KMapEstimationConfig.AuxiliaryTable")
	proto.RegisterType((*PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField)(nil), "google.privacy.dlp.v2beta2.PrivacyMetric.KMapEstimationConfig.AuxiliaryTable.QuasiIdField")
	proto.RegisterType((*AnalyzeDataSourceRiskDetails)(nil), "google.privacy.dlp.v2beta2.AnalyzeDataSourceRiskDetails")
	proto.RegisterType((*AnalyzeDataSourceRiskDetails_NumericalStatsResult)(nil), "google.privacy.dlp.v2beta2.AnalyzeDataSourceRiskDetails.NumericalStatsResult")
	proto.RegisterType((*AnalyzeDataSourceRiskDetails_CategoricalStatsResult)(nil), "google.privacy.dlp.v2beta2.AnalyzeDataSourceRiskDetails.CategoricalStatsResult")
	proto.RegisterType((*AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket)(nil), "google.privacy.dlp.v2beta2.AnalyzeDataSourceRiskDetails.CategoricalStatsResult.CategoricalStatsHistogramBucket")
	proto.RegisterType((*AnalyzeDataSourceRiskDetails_KAnonymityResult)(nil), "google.privacy.dlp.v2beta2.AnalyzeDataSourceRiskDetails.KAnonymityResult")
	proto.RegisterType((*AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass)(nil), "google.privacy.dlp.v2beta2.AnalyzeDataSourceRiskDetails.KAnonymityResult.KAnonymityEquivalenceClass")
	proto.RegisterType((*AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket)(nil), "google.privacy.dlp.v2beta2.AnalyzeDataSourceRiskDetails.KAnonymityResult.KAnonymityHistogramBucket")
	proto.RegisterType((*AnalyzeDataSourceRiskDetails_LDiversityResult)(nil), "google.privacy.dlp.v2beta2.AnalyzeDataSourceRiskDetails.LDiversityResult")
	proto.RegisterType((*AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass)(nil), "google.privacy.dlp.v2beta2.AnalyzeDataSourceRiskDetails.LDiversityResult.LDiversityEquivalenceClass")
	proto.RegisterType((*AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket)(nil), "google.privacy.dlp.v2beta2.AnalyzeDataSourceRiskDetails.LDiversityResult.LDiversityHistogramBucket")
	proto.RegisterType((*AnalyzeDataSourceRiskDetails_KMapEstimationResult)(nil), "google.privacy.dlp.v2beta2.AnalyzeDataSourceRiskDetails.KMapEstimationResult")
	proto.RegisterType((*AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues)(nil), "google.privacy.dlp.v2beta2.AnalyzeDataSourceRiskDetails.KMapEstimationResult.KMapEstimationQuasiIdValues")
	proto.RegisterType((*AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket)(nil), "google.privacy.dlp.v2beta2.AnalyzeDataSourceRiskDetails.KMapEstimationResult.KMapEstimationHistogramBucket")
	proto.RegisterType((*ValueFrequency)(nil), "google.privacy.dlp.v2beta2.ValueFrequency")
	proto.RegisterType((*Value)(nil), "google.privacy.dlp.v2beta2.Value")
	proto.RegisterType((*QuoteInfo)(nil), "google.privacy.dlp.v2beta2.QuoteInfo")
	proto.RegisterType((*DateTime)(nil), "google.privacy.dlp.v2beta2.DateTime")
	proto.RegisterType((*DateTime_TimeZone)(nil), "google.privacy.dlp.v2beta2.DateTime.TimeZone")
	proto.RegisterType((*DeidentifyConfig)(nil), "google.privacy.dlp.v2beta2.DeidentifyConfig")
	proto.RegisterType((*PrimitiveTransformation)(nil), "google.privacy.dlp.v2beta2.PrimitiveTransformation")
	proto.RegisterType((*TimePartConfig)(nil), "google.privacy.dlp.v2beta2.TimePartConfig")
	proto.RegisterType((*CryptoHashConfig)(nil), "google.privacy.dlp.v2beta2.CryptoHashConfig")
	proto.RegisterType((*ReplaceValueConfig)(nil), "google.privacy.dlp.v2beta2.ReplaceValueConfig")
	proto.RegisterType((*ReplaceWithInfoTypeConfig)(nil), "google.privacy.dlp.v2beta2.ReplaceWithInfoTypeConfig")
	proto.RegisterType((*RedactConfig)(nil), "google.privacy.dlp.v2beta2.RedactConfig")
	proto.RegisterType((*CharsToIgnore)(nil), "google.privacy.dlp.v2beta2.CharsToIgnore")
	proto.RegisterType((*CharacterMaskConfig)(nil), "google.privacy.dlp.v2beta2.CharacterMaskConfig")
	proto.RegisterType((*FixedSizeBucketingConfig)(nil), "google.privacy.dlp.v2beta2.FixedSizeBucketingConfig")
	proto.RegisterType((*BucketingConfig)(nil), "google.privacy.dlp.v2beta2.BucketingConfig")
	proto.RegisterType((*BucketingConfig_Bucket)(nil), "google.privacy.dlp.v2beta2.BucketingConfig.Bucket")
	proto.RegisterType((*CryptoReplaceFfxFpeConfig)(nil), "google.privacy.dlp.v2beta2.CryptoReplaceFfxFpeConfig")
	proto.RegisterType((*CryptoKey)(nil), "google.privacy.dlp.v2beta2.CryptoKey")
	proto.RegisterType((*TransientCryptoKey)(nil), "google.privacy.dlp.v2beta2.TransientCryptoKey")
	proto.RegisterType((*UnwrappedCryptoKey)(nil), "google.privacy.dlp.v2beta2.UnwrappedCryptoKey")
	proto.RegisterType((*KmsWrappedCryptoKey)(nil), "google.privacy.dlp.v2beta2.KmsWrappedCryptoKey")
	proto.RegisterType((*DateShiftConfig)(nil), "google.privacy.dlp.v2beta2.DateShiftConfig")
	proto.RegisterType((*InfoTypeTransformations)(nil), "google.privacy.dlp.v2beta2.InfoTypeTransformations")
	proto.RegisterType((*InfoTypeTransformations_InfoTypeTransformation)(nil), "google.privacy.dlp.v2beta2.InfoTypeTransformations.InfoTypeTransformation")
	proto.RegisterType((*FieldTransformation)(nil), "google.privacy.dlp.v2beta2.FieldTransformation")
	proto.RegisterType((*RecordTransformations)(nil), "google.privacy.dlp.v2beta2.RecordTransformations")
	proto.RegisterType((*RecordSuppression)(nil), "google.privacy.dlp.v2beta2.RecordSuppression")
	proto.RegisterType((*RecordCondition)(nil), "google.privacy.dlp.v2beta2.RecordCondition")
	proto.RegisterType((*RecordCondition_Condition)(nil), "google.privacy.dlp.v2beta2.RecordCondition.Condition")
	proto.RegisterType((*RecordCondition_Conditions)(nil), "google.privacy.dlp.v2beta2.RecordCondition.Conditions")
	proto.RegisterType((*RecordCondition_Expressions)(nil), "google.privacy.dlp.v2beta2.RecordCondition.Expressions")
	proto.RegisterType((*TransformationOverview)(nil), "google.privacy.dlp.v2beta2.TransformationOverview")
	proto.RegisterType((*TransformationSummary)(nil), "google.privacy.dlp.v2beta2.TransformationSummary")
	proto.RegisterType((*TransformationSummary_SummaryResult)(nil), "google.privacy.dlp.v2beta2.TransformationSummary.SummaryResult")
	proto.RegisterType((*Schedule)(nil), "google.privacy.dlp.v2beta2.Schedule")
	proto.RegisterType((*InspectTemplate)(nil), "google.privacy.dlp.v2beta2.InspectTemplate")
	proto.RegisterType((*DeidentifyTemplate)(nil), "google.privacy.dlp.v2beta2.DeidentifyTemplate")
	proto.RegisterType((*JobTrigger)(nil), "google.privacy.dlp.v2beta2.JobTrigger")
	proto.RegisterType((*JobTrigger_Trigger)(nil), "google.privacy.dlp.v2beta2.JobTrigger.Trigger")
	proto.RegisterType((*JobTrigger_Error)(nil), "google.privacy.dlp.v2beta2.JobTrigger.Error")
	proto.RegisterType((*Action)(nil), "google.privacy.dlp.v2beta2.Action")
	proto.RegisterType((*Action_SaveFindings)(nil), "google.privacy.dlp.v2beta2.Action.SaveFindings")
	proto.RegisterType((*Action_PublishToPubSub)(nil), "google.privacy.dlp.v2beta2.Action.PublishToPubSub")
	proto.RegisterType((*CreateInspectTemplateRequest)(nil), "google.privacy.dlp.v2beta2.CreateInspectTemplateRequest")
	proto.RegisterType((*UpdateInspectTemplateRequest)(nil), "google.privacy.dlp.v2beta2.UpdateInspectTemplateRequest")
	proto.RegisterType((*GetInspectTemplateRequest)(nil), "google.privacy.dlp.v2beta2.GetInspectTemplateRequest")
	proto.RegisterType((*ListInspectTemplatesRequest)(nil), "google.privacy.dlp.v2beta2.ListInspectTemplatesRequest")
	proto.RegisterType((*ListInspectTemplatesResponse)(nil), "google.privacy.dlp.v2beta2.ListInspectTemplatesResponse")
	proto.RegisterType((*DeleteInspectTemplateRequest)(nil), "google.privacy.dlp.v2beta2.DeleteInspectTemplateRequest")
	proto.RegisterType((*CreateJobTriggerRequest)(nil), "google.privacy.dlp.v2beta2.CreateJobTriggerRequest")
	proto.RegisterType((*UpdateJobTriggerRequest)(nil), "google.privacy.dlp.v2beta2.UpdateJobTriggerRequest")
	proto.RegisterType((*GetJobTriggerRequest)(nil), "google.privacy.dlp.v2beta2.GetJobTriggerRequest")
	proto.RegisterType((*ListJobTriggersRequest)(nil), "google.privacy.dlp.v2beta2.ListJobTriggersRequest")
	proto.RegisterType((*ListJobTriggersResponse)(nil), "google.privacy.dlp.v2beta2.ListJobTriggersResponse")
	proto.RegisterType((*DeleteJobTriggerRequest)(nil), "google.privacy.dlp.v2beta2.DeleteJobTriggerRequest")
	proto.RegisterType((*InspectJobConfig)(nil), "google.privacy.dlp.v2beta2.InspectJobConfig")
	proto.RegisterType((*DlpJob)(nil), "google.privacy.dlp.v2beta2.DlpJob")
	proto.RegisterType((*GetDlpJobRequest)(nil), "google.privacy.dlp.v2beta2.GetDlpJobRequest")
	proto.RegisterType((*ListDlpJobsRequest)(nil), "google.privacy.dlp.v2beta2.ListDlpJobsRequest")
	proto.RegisterType((*ListDlpJobsResponse)(nil), "google.privacy.dlp.v2beta2.ListDlpJobsResponse")
	proto.RegisterType((*CancelDlpJobRequest)(nil), "google.privacy.dlp.v2beta2.CancelDlpJobRequest")
	proto.RegisterType((*DeleteDlpJobRequest)(nil), "google.privacy.dlp.v2beta2.DeleteDlpJobRequest")
	proto.RegisterType((*CreateDeidentifyTemplateRequest)(nil), "google.privacy.dlp.v2beta2.CreateDeidentifyTemplateRequest")
	proto.RegisterType((*UpdateDeidentifyTemplateRequest)(nil), "google.privacy.dlp.v2beta2.UpdateDeidentifyTemplateRequest")
	proto.RegisterType((*GetDeidentifyTemplateRequest)(nil), "google.privacy.dlp.v2beta2.GetDeidentifyTemplateRequest")
	proto.RegisterType((*ListDeidentifyTemplatesRequest)(nil), "google.privacy.dlp.v2beta2.ListDeidentifyTemplatesRequest")
	proto.RegisterType((*ListDeidentifyTemplatesResponse)(nil), "google.privacy.dlp.v2beta2.ListDeidentifyTemplatesResponse")
	proto.RegisterType((*DeleteDeidentifyTemplateRequest)(nil), "google.privacy.dlp.v2beta2.DeleteDeidentifyTemplateRequest")
	proto.RegisterEnum("google.privacy.dlp.v2beta2.InfoTypeSupportedBy", InfoTypeSupportedBy_name, InfoTypeSupportedBy_value)
	proto.RegisterEnum("google.privacy.dlp.v2beta2.RelationalOperator", RelationalOperator_name, RelationalOperator_value)
	proto.RegisterEnum("google.privacy.dlp.v2beta2.DlpJobType", DlpJobType_name, DlpJobType_value)
	proto.RegisterEnum("google.privacy.dlp.v2beta2.OutputStorageConfig_OutputSchema", OutputStorageConfig_OutputSchema_name, OutputStorageConfig_OutputSchema_value)
	proto.RegisterEnum("google.privacy.dlp.v2beta2.TimePartConfig_TimePart", TimePartConfig_TimePart_name, TimePartConfig_TimePart_value)
	proto.RegisterEnum("google.privacy.dlp.v2beta2.CharsToIgnore_CommonCharsToIgnore", CharsToIgnore_CommonCharsToIgnore_name, CharsToIgnore_CommonCharsToIgnore_value)
	proto.RegisterEnum("google.privacy.dlp.v2beta2.CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet", CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet_name, CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet_value)
	proto.RegisterEnum("google.privacy.dlp.v2beta2.RecordCondition_Expressions_LogicalOperator", RecordCondition_Expressions_LogicalOperator_name, RecordCondition_Expressions_LogicalOperator_value)
	proto.RegisterEnum("google.privacy.dlp.v2beta2.TransformationSummary_TransformationResultCode", TransformationSummary_TransformationResultCode_name, TransformationSummary_TransformationResultCode_value)
	proto.RegisterEnum("google.privacy.dlp.v2beta2.JobTrigger_Status", JobTrigger_Status_name, JobTrigger_Status_value)
	proto.RegisterEnum("google.privacy.dlp.v2beta2.DlpJob_JobState", DlpJob_JobState_name, DlpJob_JobState_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for DlpService service

type DlpServiceClient interface {
	// Finds potentially sensitive info in content.
	// This method has limits on input size, processing time, and output size.
	// [How-to guide for text](/dlp/docs/inspecting-text), [How-to guide for
	// images](/dlp/docs/inspecting-images)
	InspectContent(ctx context.Context, in *InspectContentRequest, opts ...grpc.CallOption) (*InspectContentResponse, error)
	// Redacts potentially sensitive info from an image.
	// This method has limits on input size, processing time, and output size.
	// [How-to guide](/dlp/docs/redacting-sensitive-data-images)
	RedactImage(ctx context.Context, in *RedactImageRequest, opts ...grpc.CallOption) (*RedactImageResponse, error)
	// De-identifies potentially sensitive info from a ContentItem.
	// This method has limits on input size and output size.
	// [How-to guide](/dlp/docs/deidentify-sensitive-data)
	DeidentifyContent(ctx context.Context, in *DeidentifyContentRequest, opts ...grpc.CallOption) (*DeidentifyContentResponse, error)
	// Re-identify content that has been de-identified.
	ReidentifyContent(ctx context.Context, in *ReidentifyContentRequest, opts ...grpc.CallOption) (*ReidentifyContentResponse, error)
	// Schedules a job scanning content in a Google Cloud Platform data
	// repository. [How-to guide](/dlp/docs/inspecting-storage)
	InspectDataSource(ctx context.Context, in *InspectDataSourceRequest, opts ...grpc.CallOption) (*DlpJob, error)
	// Schedules a job to compute risk analysis metrics over content in a Google
	// Cloud Platform repository. [How-to guide](/dlp/docs/compute-risk-analysis)
	AnalyzeDataSourceRisk(ctx context.Context, in *AnalyzeDataSourceRiskRequest, opts ...grpc.CallOption) (*DlpJob, error)
	// Returns sensitive information types DLP supports.
	ListInfoTypes(ctx context.Context, in *ListInfoTypesRequest, opts ...grpc.CallOption) (*ListInfoTypesResponse, error)
	// Creates an inspect template for re-using frequently used configuration
	// for inspecting content, images, and storage.
	CreateInspectTemplate(ctx context.Context, in *CreateInspectTemplateRequest, opts ...grpc.CallOption) (*InspectTemplate, error)
	// Updates the inspect template.
	UpdateInspectTemplate(ctx context.Context, in *UpdateInspectTemplateRequest, opts ...grpc.CallOption) (*InspectTemplate, error)
	// Gets an inspect template.
	GetInspectTemplate(ctx context.Context, in *GetInspectTemplateRequest, opts ...grpc.CallOption) (*InspectTemplate, error)
	// Lists inspect templates.
	ListInspectTemplates(ctx context.Context, in *ListInspectTemplatesRequest, opts ...grpc.CallOption) (*ListInspectTemplatesResponse, error)
	// Deletes inspect templates.
	DeleteInspectTemplate(ctx context.Context, in *DeleteInspectTemplateRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error)
	// Creates an Deidentify template for re-using frequently used configuration
	// for Deidentifying content, images, and storage.
	CreateDeidentifyTemplate(ctx context.Context, in *CreateDeidentifyTemplateRequest, opts ...grpc.CallOption) (*DeidentifyTemplate, error)
	// Updates the inspect template.
	UpdateDeidentifyTemplate(ctx context.Context, in *UpdateDeidentifyTemplateRequest, opts ...grpc.CallOption) (*DeidentifyTemplate, error)
	// Gets an inspect template.
	GetDeidentifyTemplate(ctx context.Context, in *GetDeidentifyTemplateRequest, opts ...grpc.CallOption) (*DeidentifyTemplate, error)
	// Lists inspect templates.
	ListDeidentifyTemplates(ctx context.Context, in *ListDeidentifyTemplatesRequest, opts ...grpc.CallOption) (*ListDeidentifyTemplatesResponse, error)
	// Deletes inspect templates.
	DeleteDeidentifyTemplate(ctx context.Context, in *DeleteDeidentifyTemplateRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error)
	// Creates a job to run DLP actions such as scanning storage for sensitive
	// information on a set schedule.
	CreateJobTrigger(ctx context.Context, in *CreateJobTriggerRequest, opts ...grpc.CallOption) (*JobTrigger, error)
	// Updates a job trigger.
	UpdateJobTrigger(ctx context.Context, in *UpdateJobTriggerRequest, opts ...grpc.CallOption) (*JobTrigger, error)
	// Gets a job trigger.
	GetJobTrigger(ctx context.Context, in *GetJobTriggerRequest, opts ...grpc.CallOption) (*JobTrigger, error)
	// Lists job triggers.
	ListJobTriggers(ctx context.Context, in *ListJobTriggersRequest, opts ...grpc.CallOption) (*ListJobTriggersResponse, error)
	// Deletes a job trigger.
	DeleteJobTrigger(ctx context.Context, in *DeleteJobTriggerRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error)
	// Lists DlpJobs that match the specified filter in the request.
	ListDlpJobs(ctx context.Context, in *ListDlpJobsRequest, opts ...grpc.CallOption) (*ListDlpJobsResponse, error)
	// Gets the latest state of a long-running DlpJob.
	GetDlpJob(ctx context.Context, in *GetDlpJobRequest, opts ...grpc.CallOption) (*DlpJob, error)
	// Deletes a long-running DlpJob. This method indicates that the client is
	// no longer interested in the DlpJob result. The job will be cancelled if
	// possible.
	DeleteDlpJob(ctx context.Context, in *DeleteDlpJobRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error)
	// Starts asynchronous cancellation on a long-running DlpJob.  The server
	// makes a best effort to cancel the DlpJob, but success is not
	// guaranteed.
	CancelDlpJob(ctx context.Context, in *CancelDlpJobRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error)
}

type dlpServiceClient struct {
	cc *grpc.ClientConn
}

func NewDlpServiceClient(cc *grpc.ClientConn) DlpServiceClient {
	return &dlpServiceClient{cc}
}

func (c *dlpServiceClient) InspectContent(ctx context.Context, in *InspectContentRequest, opts ...grpc.CallOption) (*InspectContentResponse, error) {
	out := new(InspectContentResponse)
	err := grpc.Invoke(ctx, "/google.privacy.dlp.v2beta2.DlpService/InspectContent", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) RedactImage(ctx context.Context, in *RedactImageRequest, opts ...grpc.CallOption) (*RedactImageResponse, error) {
	out := new(RedactImageResponse)
	err := grpc.Invoke(ctx, "/google.privacy.dlp.v2beta2.DlpService/RedactImage", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) DeidentifyContent(ctx context.Context, in *DeidentifyContentRequest, opts ...grpc.CallOption) (*DeidentifyContentResponse, error) {
	out := new(DeidentifyContentResponse)
	err := grpc.Invoke(ctx, "/google.privacy.dlp.v2beta2.DlpService/DeidentifyContent", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) ReidentifyContent(ctx context.Context, in *ReidentifyContentRequest, opts ...grpc.CallOption) (*ReidentifyContentResponse, error) {
	out := new(ReidentifyContentResponse)
	err := grpc.Invoke(ctx, "/google.privacy.dlp.v2beta2.DlpService/ReidentifyContent", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) InspectDataSource(ctx context.Context, in *InspectDataSourceRequest, opts ...grpc.CallOption) (*DlpJob, error) {
	out := new(DlpJob)
	err := grpc.Invoke(ctx, "/google.privacy.dlp.v2beta2.DlpService/InspectDataSource", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) AnalyzeDataSourceRisk(ctx context.Context, in *AnalyzeDataSourceRiskRequest, opts ...grpc.CallOption) (*DlpJob, error) {
	out := new(DlpJob)
	err := grpc.Invoke(ctx, "/google.privacy.dlp.v2beta2.DlpService/AnalyzeDataSourceRisk", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) ListInfoTypes(ctx context.Context, in *ListInfoTypesRequest, opts ...grpc.CallOption) (*ListInfoTypesResponse, error) {
	out := new(ListInfoTypesResponse)
	err := grpc.Invoke(ctx, "/google.privacy.dlp.v2beta2.DlpService/ListInfoTypes", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) CreateInspectTemplate(ctx context.Context, in *CreateInspectTemplateRequest, opts ...grpc.CallOption) (*InspectTemplate, error) {
	out := new(InspectTemplate)
	err := grpc.Invoke(ctx, "/google.privacy.dlp.v2beta2.DlpService/CreateInspectTemplate", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) UpdateInspectTemplate(ctx context.Context, in *UpdateInspectTemplateRequest, opts ...grpc.CallOption) (*InspectTemplate, error) {
	out := new(InspectTemplate)
	err := grpc.Invoke(ctx, "/google.privacy.dlp.v2beta2.DlpService/UpdateInspectTemplate", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) GetInspectTemplate(ctx context.Context, in *GetInspectTemplateRequest, opts ...grpc.CallOption) (*InspectTemplate, error) {
	out := new(InspectTemplate)
	err := grpc.Invoke(ctx, "/google.privacy.dlp.v2beta2.DlpService/GetInspectTemplate", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) ListInspectTemplates(ctx context.Context, in *ListInspectTemplatesRequest, opts ...grpc.CallOption) (*ListInspectTemplatesResponse, error) {
	out := new(ListInspectTemplatesResponse)
	err := grpc.Invoke(ctx, "/google.privacy.dlp.v2beta2.DlpService/ListInspectTemplates", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) DeleteInspectTemplate(ctx context.Context, in *DeleteInspectTemplateRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error) {
	out := new(google_protobuf3.Empty)
	err := grpc.Invoke(ctx, "/google.privacy.dlp.v2beta2.DlpService/DeleteInspectTemplate", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) CreateDeidentifyTemplate(ctx context.Context, in *CreateDeidentifyTemplateRequest, opts ...grpc.CallOption) (*DeidentifyTemplate, error) {
	out := new(DeidentifyTemplate)
	err := grpc.Invoke(ctx, "/google.privacy.dlp.v2beta2.DlpService/CreateDeidentifyTemplate", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) UpdateDeidentifyTemplate(ctx context.Context, in *UpdateDeidentifyTemplateRequest, opts ...grpc.CallOption) (*DeidentifyTemplate, error) {
	out := new(DeidentifyTemplate)
	err := grpc.Invoke(ctx, "/google.privacy.dlp.v2beta2.DlpService/UpdateDeidentifyTemplate", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) GetDeidentifyTemplate(ctx context.Context, in *GetDeidentifyTemplateRequest, opts ...grpc.CallOption) (*DeidentifyTemplate, error) {
	out := new(DeidentifyTemplate)
	err := grpc.Invoke(ctx, "/google.privacy.dlp.v2beta2.DlpService/GetDeidentifyTemplate", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) ListDeidentifyTemplates(ctx context.Context, in *ListDeidentifyTemplatesRequest, opts ...grpc.CallOption) (*ListDeidentifyTemplatesResponse, error) {
	out := new(ListDeidentifyTemplatesResponse)
	err := grpc.Invoke(ctx, "/google.privacy.dlp.v2beta2.DlpService/ListDeidentifyTemplates", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) DeleteDeidentifyTemplate(ctx context.Context, in *DeleteDeidentifyTemplateRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error) {
	out := new(google_protobuf3.Empty)
	err := grpc.Invoke(ctx, "/google.privacy.dlp.v2beta2.DlpService/DeleteDeidentifyTemplate", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) CreateJobTrigger(ctx context.Context, in *CreateJobTriggerRequest, opts ...grpc.CallOption) (*JobTrigger, error) {
	out := new(JobTrigger)
	err := grpc.Invoke(ctx, "/google.privacy.dlp.v2beta2.DlpService/CreateJobTrigger", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) UpdateJobTrigger(ctx context.Context, in *UpdateJobTriggerRequest, opts ...grpc.CallOption) (*JobTrigger, error) {
	out := new(JobTrigger)
	err := grpc.Invoke(ctx, "/google.privacy.dlp.v2beta2.DlpService/UpdateJobTrigger", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) GetJobTrigger(ctx context.Context, in *GetJobTriggerRequest, opts ...grpc.CallOption) (*JobTrigger, error) {
	out := new(JobTrigger)
	err := grpc.Invoke(ctx, "/google.privacy.dlp.v2beta2.DlpService/GetJobTrigger", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) ListJobTriggers(ctx context.Context, in *ListJobTriggersRequest, opts ...grpc.CallOption) (*ListJobTriggersResponse, error) {
	out := new(ListJobTriggersResponse)
	err := grpc.Invoke(ctx, "/google.privacy.dlp.v2beta2.DlpService/ListJobTriggers", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) DeleteJobTrigger(ctx context.Context, in *DeleteJobTriggerRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error) {
	out := new(google_protobuf3.Empty)
	err := grpc.Invoke(ctx, "/google.privacy.dlp.v2beta2.DlpService/DeleteJobTrigger", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) ListDlpJobs(ctx context.Context, in *ListDlpJobsRequest, opts ...grpc.CallOption) (*ListDlpJobsResponse, error) {
	out := new(ListDlpJobsResponse)
	err := grpc.Invoke(ctx, "/google.privacy.dlp.v2beta2.DlpService/ListDlpJobs", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) GetDlpJob(ctx context.Context, in *GetDlpJobRequest, opts ...grpc.CallOption) (*DlpJob, error) {
	out := new(DlpJob)
	err := grpc.Invoke(ctx, "/google.privacy.dlp.v2beta2.DlpService/GetDlpJob", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) DeleteDlpJob(ctx context.Context, in *DeleteDlpJobRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error) {
	out := new(google_protobuf3.Empty)
	err := grpc.Invoke(ctx, "/google.privacy.dlp.v2beta2.DlpService/DeleteDlpJob", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) CancelDlpJob(ctx context.Context, in *CancelDlpJobRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error) {
	out := new(google_protobuf3.Empty)
	err := grpc.Invoke(ctx, "/google.privacy.dlp.v2beta2.DlpService/CancelDlpJob", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for DlpService service

type DlpServiceServer interface {
	// Finds potentially sensitive info in content.
	// This method has limits on input size, processing time, and output size.
	// [How-to guide for text](/dlp/docs/inspecting-text), [How-to guide for
	// images](/dlp/docs/inspecting-images)
	InspectContent(context.Context, *InspectContentRequest) (*InspectContentResponse, error)
	// Redacts potentially sensitive info from an image.
	// This method has limits on input size, processing time, and output size.
	// [How-to guide](/dlp/docs/redacting-sensitive-data-images)
	RedactImage(context.Context, *RedactImageRequest) (*RedactImageResponse, error)
	// De-identifies potentially sensitive info from a ContentItem.
	// This method has limits on input size and output size.
	// [How-to guide](/dlp/docs/deidentify-sensitive-data)
	DeidentifyContent(context.Context, *DeidentifyContentRequest) (*DeidentifyContentResponse, error)
	// Re-identify content that has been de-identified.
	ReidentifyContent(context.Context, *ReidentifyContentRequest) (*ReidentifyContentResponse, error)
	// Schedules a job scanning content in a Google Cloud Platform data
	// repository. [How-to guide](/dlp/docs/inspecting-storage)
	InspectDataSource(context.Context, *InspectDataSourceRequest) (*DlpJob, error)
	// Schedules a job to compute risk analysis metrics over content in a Google
	// Cloud Platform repository. [How-to guide](/dlp/docs/compute-risk-analysis)
	AnalyzeDataSourceRisk(context.Context, *AnalyzeDataSourceRiskRequest) (*DlpJob, error)
	// Returns sensitive information types DLP supports.
	ListInfoTypes(context.Context, *ListInfoTypesRequest) (*ListInfoTypesResponse, error)
	// Creates an inspect template for re-using frequently used configuration
	// for inspecting content, images, and storage.
	CreateInspectTemplate(context.Context, *CreateInspectTemplateRequest) (*InspectTemplate, error)
	// Updates the inspect template.
	UpdateInspectTemplate(context.Context, *UpdateInspectTemplateRequest) (*InspectTemplate, error)
	// Gets an inspect template.
	GetInspectTemplate(context.Context, *GetInspectTemplateRequest) (*InspectTemplate, error)
	// Lists inspect templates.
	ListInspectTemplates(context.Context, *ListInspectTemplatesRequest) (*ListInspectTemplatesResponse, error)
	// Deletes inspect templates.
	DeleteInspectTemplate(context.Context, *DeleteInspectTemplateRequest) (*google_protobuf3.Empty, error)
	// Creates an Deidentify template for re-using frequently used configuration
	// for Deidentifying content, images, and storage.
	CreateDeidentifyTemplate(context.Context, *CreateDeidentifyTemplateRequest) (*DeidentifyTemplate, error)
	// Updates the inspect template.
	UpdateDeidentifyTemplate(context.Context, *UpdateDeidentifyTemplateRequest) (*DeidentifyTemplate, error)
	// Gets an inspect template.
	GetDeidentifyTemplate(context.Context, *GetDeidentifyTemplateRequest) (*DeidentifyTemplate, error)
	// Lists inspect templates.
	ListDeidentifyTemplates(context.Context, *ListDeidentifyTemplatesRequest) (*ListDeidentifyTemplatesResponse, error)
	// Deletes inspect templates.
	DeleteDeidentifyTemplate(context.Context, *DeleteDeidentifyTemplateRequest) (*google_protobuf3.Empty, error)
	// Creates a job to run DLP actions such as scanning storage for sensitive
	// information on a set schedule.
	CreateJobTrigger(context.Context, *CreateJobTriggerRequest) (*JobTrigger, error)
	// Updates a job trigger.
	UpdateJobTrigger(context.Context, *UpdateJobTriggerRequest) (*JobTrigger, error)
	// Gets a job trigger.
	GetJobTrigger(context.Context, *GetJobTriggerRequest) (*JobTrigger, error)
	// Lists job triggers.
	ListJobTriggers(context.Context, *ListJobTriggersRequest) (*ListJobTriggersResponse, error)
	// Deletes a job trigger.
	DeleteJobTrigger(context.Context, *DeleteJobTriggerRequest) (*google_protobuf3.Empty, error)
	// Lists DlpJobs that match the specified filter in the request.
	ListDlpJobs(context.Context, *ListDlpJobsRequest) (*ListDlpJobsResponse, error)
	// Gets the latest state of a long-running DlpJob.
	GetDlpJob(context.Context, *GetDlpJobRequest) (*DlpJob, error)
	// Deletes a long-running DlpJob. This method indicates that the client is
	// no longer interested in the DlpJob result. The job will be cancelled if
	// possible.
	DeleteDlpJob(context.Context, *DeleteDlpJobRequest) (*google_protobuf3.Empty, error)
	// Starts asynchronous cancellation on a long-running DlpJob.  The server
	// makes a best effort to cancel the DlpJob, but success is not
	// guaranteed.
	CancelDlpJob(context.Context, *CancelDlpJobRequest) (*google_protobuf3.Empty, error)
}

func RegisterDlpServiceServer(s *grpc.Server, srv DlpServiceServer) {
	s.RegisterService(&_DlpService_serviceDesc, srv)
}

func _DlpService_InspectContent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InspectContentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).InspectContent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2beta2.DlpService/InspectContent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).InspectContent(ctx, req.(*InspectContentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_RedactImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RedactImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).RedactImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2beta2.DlpService/RedactImage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).RedactImage(ctx, req.(*RedactImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_DeidentifyContent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeidentifyContentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).DeidentifyContent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2beta2.DlpService/DeidentifyContent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).DeidentifyContent(ctx, req.(*DeidentifyContentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_ReidentifyContent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReidentifyContentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).ReidentifyContent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2beta2.DlpService/ReidentifyContent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).ReidentifyContent(ctx, req.(*ReidentifyContentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_InspectDataSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InspectDataSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).InspectDataSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2beta2.DlpService/InspectDataSource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).InspectDataSource(ctx, req.(*InspectDataSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_AnalyzeDataSourceRisk_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeDataSourceRiskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).AnalyzeDataSourceRisk(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2beta2.DlpService/AnalyzeDataSourceRisk",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).AnalyzeDataSourceRisk(ctx, req.(*AnalyzeDataSourceRiskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_ListInfoTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInfoTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).ListInfoTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2beta2.DlpService/ListInfoTypes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).ListInfoTypes(ctx, req.(*ListInfoTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_CreateInspectTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInspectTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).CreateInspectTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2beta2.DlpService/CreateInspectTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).CreateInspectTemplate(ctx, req.(*CreateInspectTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_UpdateInspectTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInspectTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).UpdateInspectTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2beta2.DlpService/UpdateInspectTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).UpdateInspectTemplate(ctx, req.(*UpdateInspectTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_GetInspectTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInspectTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).GetInspectTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2beta2.DlpService/GetInspectTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).GetInspectTemplate(ctx, req.(*GetInspectTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_ListInspectTemplates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInspectTemplatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).ListInspectTemplates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2beta2.DlpService/ListInspectTemplates",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).ListInspectTemplates(ctx, req.(*ListInspectTemplatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_DeleteInspectTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInspectTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).DeleteInspectTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2beta2.DlpService/DeleteInspectTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).DeleteInspectTemplate(ctx, req.(*DeleteInspectTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_CreateDeidentifyTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDeidentifyTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).CreateDeidentifyTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2beta2.DlpService/CreateDeidentifyTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).CreateDeidentifyTemplate(ctx, req.(*CreateDeidentifyTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_UpdateDeidentifyTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDeidentifyTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).UpdateDeidentifyTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2beta2.DlpService/UpdateDeidentifyTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).UpdateDeidentifyTemplate(ctx, req.(*UpdateDeidentifyTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_GetDeidentifyTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDeidentifyTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).GetDeidentifyTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2beta2.DlpService/GetDeidentifyTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).GetDeidentifyTemplate(ctx, req.(*GetDeidentifyTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_ListDeidentifyTemplates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDeidentifyTemplatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).ListDeidentifyTemplates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2beta2.DlpService/ListDeidentifyTemplates",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).ListDeidentifyTemplates(ctx, req.(*ListDeidentifyTemplatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_DeleteDeidentifyTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDeidentifyTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).DeleteDeidentifyTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2beta2.DlpService/DeleteDeidentifyTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).DeleteDeidentifyTemplate(ctx, req.(*DeleteDeidentifyTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_CreateJobTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateJobTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).CreateJobTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2beta2.DlpService/CreateJobTrigger",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).CreateJobTrigger(ctx, req.(*CreateJobTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_UpdateJobTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateJobTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).UpdateJobTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2beta2.DlpService/UpdateJobTrigger",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).UpdateJobTrigger(ctx, req.(*UpdateJobTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_GetJobTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).GetJobTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2beta2.DlpService/GetJobTrigger",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).GetJobTrigger(ctx, req.(*GetJobTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_ListJobTriggers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListJobTriggersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).ListJobTriggers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2beta2.DlpService/ListJobTriggers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).ListJobTriggers(ctx, req.(*ListJobTriggersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_DeleteJobTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteJobTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).DeleteJobTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2beta2.DlpService/DeleteJobTrigger",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).DeleteJobTrigger(ctx, req.(*DeleteJobTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_ListDlpJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDlpJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).ListDlpJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2beta2.DlpService/ListDlpJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).ListDlpJobs(ctx, req.(*ListDlpJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_GetDlpJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDlpJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).GetDlpJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2beta2.DlpService/GetDlpJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).GetDlpJob(ctx, req.(*GetDlpJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_DeleteDlpJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDlpJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).DeleteDlpJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2beta2.DlpService/DeleteDlpJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).DeleteDlpJob(ctx, req.(*DeleteDlpJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_CancelDlpJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelDlpJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).CancelDlpJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2beta2.DlpService/CancelDlpJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).CancelDlpJob(ctx, req.(*CancelDlpJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DlpService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.privacy.dlp.v2beta2.DlpService",
	HandlerType: (*DlpServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "InspectContent",
			Handler:    _DlpService_InspectContent_Handler,
		},
		{
			MethodName: "RedactImage",
			Handler:    _DlpService_RedactImage_Handler,
		},
		{
			MethodName: "DeidentifyContent",
			Handler:    _DlpService_DeidentifyContent_Handler,
		},
		{
			MethodName: "ReidentifyContent",
			Handler:    _DlpService_ReidentifyContent_Handler,
		},
		{
			MethodName: "InspectDataSource",
			Handler:    _DlpService_InspectDataSource_Handler,
		},
		{
			MethodName: "AnalyzeDataSourceRisk",
			Handler:    _DlpService_AnalyzeDataSourceRisk_Handler,
		},
		{
			MethodName: "ListInfoTypes",
			Handler:    _DlpService_ListInfoTypes_Handler,
		},
		{
			MethodName: "CreateInspectTemplate",
			Handler:    _DlpService_CreateInspectTemplate_Handler,
		},
		{
			MethodName: "UpdateInspectTemplate",
			Handler:    _DlpService_UpdateInspectTemplate_Handler,
		},
		{
			MethodName: "GetInspectTemplate",
			Handler:    _DlpService_GetInspectTemplate_Handler,
		},
		{
			MethodName: "ListInspectTemplates",
			Handler:    _DlpService_ListInspectTemplates_Handler,
		},
		{
			MethodName: "DeleteInspectTemplate",
			Handler:    _DlpService_DeleteInspectTemplate_Handler,
		},
		{
			MethodName: "CreateDeidentifyTemplate",
			Handler:    _DlpService_CreateDeidentifyTemplate_Handler,
		},
		{
			MethodName: "UpdateDeidentifyTemplate",
			Handler:    _DlpService_UpdateDeidentifyTemplate_Handler,
		},
		{
			MethodName: "GetDeidentifyTemplate",
			Handler:    _DlpService_GetDeidentifyTemplate_Handler,
		},
		{
			MethodName: "ListDeidentifyTemplates",
			Handler:    _DlpService_ListDeidentifyTemplates_Handler,
		},
		{
			MethodName: "DeleteDeidentifyTemplate",
			Handler:    _DlpService_DeleteDeidentifyTemplate_Handler,
		},
		{
			MethodName: "CreateJobTrigger",
			Handler:    _DlpService_CreateJobTrigger_Handler,
		},
		{
			MethodName: "UpdateJobTrigger",
			Handler:    _DlpService_UpdateJobTrigger_Handler,
		},
		{
			MethodName: "GetJobTrigger",
			Handler:    _DlpService_GetJobTrigger_Handler,
		},
		{
			MethodName: "ListJobTriggers",
			Handler:    _DlpService_ListJobTriggers_Handler,
		},
		{
			MethodName: "DeleteJobTrigger",
			Handler:    _DlpService_DeleteJobTrigger_Handler,
		},
		{
			MethodName: "ListDlpJobs",
			Handler:    _DlpService_ListDlpJobs_Handler,
		},
		{
			MethodName: "GetDlpJob",
			Handler:    _DlpService_GetDlpJob_Handler,
		},
		{
			MethodName: "DeleteDlpJob",
			Handler:    _DlpService_DeleteDlpJob_Handler,
		},
		{
			MethodName: "CancelDlpJob",
			Handler:    _DlpService_CancelDlpJob_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/privacy/dlp/v2beta2/dlp.proto",
}

func init() { proto.RegisterFile("google/privacy/dlp/v2beta2/dlp.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 7722 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xdc, 0x7d, 0x5b, 0x6c, 0x23, 0x57,
	0x96, 0x98, 0x8a, 0x14, 0x25, 0xf2, 0x90, 0x94, 0xa8, 0xab, 0x47, 0xab, 0xd9, 0xdd, 0xee, 0x76,
	0x79, 0xdc, 0xd3, 0x96, 0x6d, 0xc9, 0x96, 0xdd, 0xe3, 0x71, 0x7b, 0xec, 0x31, 0x45, 0xb1, 0x5b,
	0x6a, 0x4b, 0xa2, 0x5c, 0xa4, 0xda, 0x6e, 0xdb, 0x71, 0xa5, 0x44, 0x5e, 0x51, 0xd5, 0x22, 0xab,
	0xd8, 0x55, 0xc5, 0x96, 0xe8, 0xcd, 0x26, 0x9b, 0x04, 0x9b, 0xec, 0x66, 0x83, 0x64, 0x17, 0x3b,
	0xc8, 0x24, 0x98, 0x20, 0xb3, 0x0b, 0xcc, 0xc7, 0x66, 0xb1, 0xc8, 0x13, 0xc8, 0xc7, 0xee, 0x04,
	0x48, 0x76, 0x3e, 0xb2, 0xc8, 0xe3, 0x6b, 0x81, 0x01, 0x82, 0x60, 0x91, 0x60, 0x93, 0x60, 0x91,
	0x07, 0xf2, 0x42, 0x32, 0x7f, 0x09, 0x82, 0xfb, 0xa8, 0x27, 0x8b, 0xc5, 0xa2, 0xa4, 0x46, 0xb2,
	0xfb, 0x25, 0xd6, 0xb9, 0xe7, 0x9c, 0x7b, 0xee, 0xb9, 0xe7, 0x9e, 0x7b, 0xee, 0xb9, 0x0f, 0xc1,
	0xd7, 0x5a, 0xba, 0xde, 0x6a, 0xe3, 0xb5, 0xae, 0xa1, 0x3e, 0x53, 0x1a, 0xfd, 0xb5, 0x66, 0xbb,
	0xbb, 0xf6, 0x6c, 0xfd, 0x10, 0x5b, 0xca, 0x3a, 0xf9, 0xbd, 0xda, 0x35, 0x74, 0x4b, 0x47, 0x45,
	0x86, 0xb5, 0xca, 0xb1, 0x56, 0x49, 0x09, 0xc7, 0x2a, 0x5e, 0xe7, 0x1c, 0x94, 0xae, 0xba, 0xa6,
	0x68, 0x9a, 0x6e, 0x29, 0x96, 0xaa, 0x6b, 0x26, 0xa3, 0x2c, 0xde, 0x89, 0xe0, 0x6f, 0x5a, 0xba,
	0xa1, 0xb4, 0x30, 0xc7, 0x7c, 0xc1, 0xc1, 0xd4, 0x2d, 0xfd, 0xb0, 0x77, 0xb4, 0xd6, 0xec, 0x19,
	0x94, 0x15, 0x2f, 0xbf, 0x16, 0x2c, 0xc7, 0x9d, 0xae, 0xd5, 0xe7, 0x85, 0xb7, 0x82, 0x85, 0x47,
	0x2a, 0x6e, 0x37, 0xe5, 0x8e, 0x62, 0x9e, 0x70, 0x8c, 0x9b, 0x41, 0x0c, 0x4b, 0xed, 0x60, 0xd3,
	0x52, 0x3a, 0xbc, 0x8d, 0xc5, 0x2b, 0x1c, 0xc1, 0xe8, 0x36, 0xd6, 0x4c, 0x4b, 0xb1, 0x7a, 0x76,
	0x13, 0x96, 0x78, 0x81, 0xd5, 0xef, 0xe2, 0xb5, 0xa6, 0x62, 0xe1, 0x80, 0x40, 0x1c, 0xde, 0xd7,
	0x8f, 0x4e, 0x31, 0x3e, 0x09, 0x2b, 0x24, 0x55, 0xe9, 0x47, 0x4d, 0x85, 0x4b, 0x2b, 0xfe, 0xd5,
	0x29, 0xc8, 0x6f, 0x6b, 0x66, 0x17, 0x37, 0xac, 0xb2, 0xae, 0x1d, 0xa9, 0x2d, 0x54, 0x06, 0x50,
	0xb5, 0x23, 0x5d, 0x26, 0xe8, 0xe6, 0xb2, 0x70, 0x2b, 0x79, 0x27, 0xbb, 0xfe, 0xb5, 0xd5, 0xe1,
	0x5a, 0x5f, 0xdd, 0xd6, 0x8e, 0xf4, 0x7a, 0xbf, 0x8b, 0xa5, 0x8c, 0xca, 0x7f, 0x99, 0x68, 0x17,
	0x66, 0x3a, 0xaa, 0x26, 0xb7, 0xd5, 0x13, 0xdc, 0x56, 0x8f, 0x75, 0xbd, 0xb9, 0x9c, 0xb8, 0x25,
	0xdc, 0x99, 0x59, 0xbf, 0x1d, 0xc5, 0x68, 0xc7, 0xc1, 0x96, 0xf2, 0x1d, 0x55, 0x73, 0x3f, 0x51,
	0x15, 0xa6, 0xda, 0x6a, 0x47, 0xb5, 0xcc, 0xe5, 0xe4, 0x2d, 0xe1, 0x4e, 0x76, 0xfd, 0x9d, 0x68,
	0x79, 0x3c, 0xcd, 0x59, 0xbd, 0xaf, 0x6a, 0x4d, 0x55, 0x6b, 0xed, 0x50, 0x72, 0x89, 0xb3, 0x41,
	0x2f, 0x41, 0x5e, 0xd5, 0x1a, 0xed, 0x5e, 0x13, 0xcb, 0x4f, 0x7b, 0xba, 0x85, 0x97, 0x27, 0x6f,
	0x09, 0x77, 0xd2, 0x52, 0x8e, 0x03, 0x3f, 0x26, 0x30, 0xf4, 0x1a, 0x20, 0x7c, 0xc6, 0x90, 0x3c,
	0x1a, 0x49, 0x51, 0xcc, 0x02, 0x2f, 0xd9, 0x76, 0x9a, 0xfc, 0x08, 0xe6, 0x1a, 0x3d, 0xd3, 0xd2,
	0x3b, 0x5e, 0xe4, 0x29, 0xaa, 0xbe, 0x95, 0x28, 0x71, 0xcb, 0x94, 0xc8, 0x51, 0xe2, 0x6c, 0xc3,
	0xf7, 0x6d, 0x16, 0x7f, 0x92, 0x80, 0xbc, 0xaf, 0x11, 0xe8, 0x4d, 0x58, 0xec, 0x28, 0x67, 0xf2,
	0x11, 0x03, 0x9a, 0x72, 0x17, 0x1b, 0xb2, 0x6a, 0xe1, 0xce, 0xb2, 0x70, 0x4b, 0xb8, 0x93, 0x92,
	0x50, 0x47, 0x39, 0xe3, 0x04, 0xe6, 0x3e, 0x36, 0xb6, 0x2d, 0xdc, 0x41, 0xef, 0xc0, 0xf2, 0x00,
	0x89, 0x81, 0x9f, 0xf6, 0xb0, 0x69, 0xd1, 0x9e, 0x49, 0x49, 0x8b, 0x7e, 0x2a, 0x89, 0x15, 0xa2,
	0x3f, 0x2d, 0x40, 0x71, 0xb0, 0x32, 0xbb, 0x81, 0xcb, 0x49, 0xda, 0xbe, 0xca, 0x39, 0xbb, 0xc3,
	0x31, 0x1d, 0xfa, 0x29, 0x2d, 0x05, 0x04, 0xe7, 0x85, 0xc5, 0x1e, 0x31, 0x51, 0x0f, 0x22, 0x2a,
	0x41, 0xc6, 0x15, 0x41, 0xa0, 0x16, 0x11, 0xcf, 0x42, 0xd3, 0xb6, 0x85, 0xa2, 0x17, 0x21, 0xe7,
	0x6d, 0x16, 0x57, 0x42, 0xd6, 0x23, 0x81, 0xf8, 0x5d, 0x01, 0xb2, 0x65, 0x5d, 0xb3, 0xb0, 0x66,
	0x51, 0x1d, 0x22, 0x98, 0x74, 0x2a, 0xcc, 0x48, 0xf4, 0x37, 0x5a, 0x80, 0xc9, 0xa6, 0x62, 0x29,
	0x94, 0x3c, 0xb7, 0x35, 0x21, 0xd1, 0x2f, 0xb4, 0x04, 0xa9, 0x67, 0x4a, 0xbb, 0x87, 0xa9, 0xb5,
	0x66, 0xb6, 0x26, 0x24, 0xf6, 0x89, 0xde, 0x85, 0x94, 0xa5, 0x1c, 0xb6, 0x99, 0xb5, 0x65, 0xd7,
	0x5f, 0x8c, 0x92, 0xb9, 0x4e, 0x10, 0x09, 0x29, 0xa5, 0xd8, 0xc8, 0x42, 0x86, 0xb0, 0xa6, 0xfd,
	0x2c, 0xfe, 0x48, 0x80, 0x14, 0x2d, 0x47, 0xef, 0xc3, 0xf4, 0x31, 0x56, 0x9a, 0xd8, 0xb0, 0x47,
	0xea, 0x4b, 0x51, 0x3c, 0xef, 0x13, 0x4f, 0xb4, 0xdd, 0x94, 0x6c, 0x1a, 0xf4, 0x2e, 0x4c, 0x1a,
	0xfa, 0x29, 0x69, 0x3d, 0xa1, 0x7d, 0x79, 0xa4, 0x3c, 0xab, 0x92, 0x7e, 0x2a, 0x51, 0x92, 0xe2,
	0x87, 0x90, 0x94, 0xf4, 0x53, 0xf4, 0x2e, 0x4c, 0xd1, 0xb6, 0xd9, 0xf5, 0x47, 0xb6, 0xe9, 0x11,
	0xc1, 0x94, 0x38, 0x81, 0xf8, 0xa7, 0x1c, 0xcf, 0x23, 0x61, 0xb3, 0xd7, 0xb6, 0xd0, 0xb7, 0x21,
	0xed, 0xf4, 0x47, 0xac, 0xd6, 0x50, 0x5c, 0xc9, 0x21, 0x42, 0xaf, 0x03, 0x72, 0xec, 0xd4, 0x32,
	0x7a, 0x5a, 0x43, 0xb1, 0x30, 0xf3, 0x3c, 0x69, 0x69, 0xce, 0x2e, 0xa9, 0xdb, 0x05, 0xe2, 0x7f,
	0x4d, 0xc0, 0x34, 0x67, 0x82, 0x16, 0x20, 0xc5, 0x1c, 0x01, 0xeb, 0x5d, 0xf6, 0xe1, 0x37, 0xb4,
	0xc4, 0xb9, 0x0c, 0xed, 0x3e, 0x80, 0xc7, 0x0b, 0x26, 0xc7, 0xf2, 0x82, 0x1e, 0x4a, 0xf4, 0x21,
	0xa4, 0xdb, 0x7a, 0x83, 0xce, 0x42, 0xdc, 0x7c, 0x22, 0x25, 0xd9, 0xe1, 0xb8, 0x92, 0x43, 0x85,
	0xde, 0x83, 0x6c, 0xc3, 0xc0, 0x8a, 0x85, 0x65, 0x32, 0x09, 0x2c, 0x4f, 0x51, 0x26, 0x45, 0x97,
	0x09, 0x9b, 0x8c, 0x56, 0xeb, 0xf6, 0x64, 0x24, 0x01, 0x43, 0x27, 0x00, 0xb4, 0x09, 0x40, 0x55,
	0x42, 0xc7, 0xfe, 0xf2, 0x34, 0xa5, 0x8d, 0xb4, 0x17, 0xea, 0x42, 0x89, 0x3e, 0xa4, 0xcc, 0x53,
	0xfb, 0xa7, 0xf8, 0xc3, 0x24, 0xa4, 0x6d, 0xc9, 0xd0, 0x87, 0x00, 0x87, 0x7d, 0x0b, 0xcb, 0x86,
	0xa2, 0xb5, 0xec, 0x61, 0x1c, 0x69, 0x3e, 0x12, 0x41, 0x94, 0x32, 0x84, 0x88, 0xfe, 0x44, 0x0f,
	0x61, 0xb6, 0xa1, 0x37, 0x71, 0x57, 0x57, 0x35, 0x8b, 0xb3, 0x49, 0xc4, 0x65, 0x33, 0xe3, 0x50,
	0xda, 0xbc, 0xb2, 0x6a, 0x47, 0x69, 0x61, 0xf9, 0x50, 0x3f, 0xc3, 0x26, 0x77, 0x6c, 0xaf, 0x44,
	0x76, 0x36, 0x41, 0x77, 0xf4, 0x0c, 0x94, 0x7a, 0x83, 0x10, 0x13, 0x65, 0x19, 0xb8, 0xa1, 0x1b,
	0x4d, 0xf9, 0x04, 0xf7, 0x79, 0x6f, 0x45, 0x2a, 0x4b, 0xa2, 0xd8, 0x1f, 0xe1, 0xbe, 0x94, 0x31,
	0xec, 0x9f, 0xe8, 0x03, 0x32, 0x1c, 0x48, 0xe8, 0xa0, 0x36, 0xe9, 0xa4, 0x13, 0x77, 0x70, 0x1f,
	0xb1, 0x1f, 0x68, 0x1f, 0x66, 0xa8, 0xef, 0x90, 0x1d, 0xbb, 0x61, 0x5d, 0xfe, 0xca, 0xc8, 0x61,
	0xee, 0x34, 0x2a, 0x6f, 0x79, 0x3f, 0xc5, 0xd7, 0x20, 0xef, 0x2b, 0x47, 0xd7, 0x20, 0x63, 0xe8,
	0xa7, 0xb2, 0xaa, 0x35, 0xf1, 0x19, 0xed, 0xc1, 0xa4, 0x94, 0x36, 0xf4, 0xd3, 0x6d, 0xf2, 0x2d,
	0xae, 0x41, 0x8a, 0xa9, 0x76, 0x01, 0x52, 0xa6, 0xa5, 0x18, 0x16, 0xc7, 0x60, 0x1f, 0xa8, 0x00,
	0x49, 0xac, 0xb1, 0xd1, 0x99, 0x94, 0xc8, 0x4f, 0xb1, 0x01, 0x79, 0x9f, 0x4e, 0x09, 0x8a, 0xa5,
	0x77, 0xf9, 0xb4, 0x46, 0x7e, 0x12, 0x1f, 0xdc, 0xc6, 0x47, 0xf6, 0x9c, 0x45, 0x7f, 0x13, 0xf6,
	0xa7, 0x6a, 0xd3, 0x3a, 0xa6, 0x83, 0x2b, 0x25, 0xb1, 0x0f, 0xb4, 0x04, 0x53, 0xc7, 0x58, 0x6d,
	0x1d, 0x5b, 0x54, 0xff, 0x29, 0x89, 0x7f, 0x89, 0xdf, 0x9d, 0x04, 0x24, 0xe1, 0xa6, 0xd2, 0xb0,
	0x68, 0x5d, 0xf6, 0x3c, 0xb7, 0x04, 0x53, 0x5d, 0xc5, 0xc0, 0x9a, 0xc5, 0x1d, 0x00, 0xff, 0x22,
	0x4a, 0x54, 0x99, 0x93, 0x92, 0x1b, 0x74, 0x06, 0xe3, 0x16, 0xf6, 0x4a, 0xec, 0x29, 0x4f, 0xca,
	0xab, 0xbe, 0xf8, 0xea, 0x06, 0x30, 0x53, 0xb1, 0x27, 0x50, 0x52, 0x5b, 0x86, 0x42, 0xa8, 0xbf,
	0x70, 0x8a, 0xe9, 0xbc, 0x42, 0x64, 0xcf, 0xf1, 0xe2, 0x4d, 0x32, 0xb5, 0xfc, 0x14, 0x5c, 0x61,
	0xc5, 0x06, 0x6d, 0x83, 0xaa, 0x6b, 0x5c, 0x2e, 0x12, 0x98, 0x10, 0x93, 0x2d, 0x47, 0xdb, 0x59,
	0xb0, 0xe1, 0xab, 0xfc, 0x83, 0x33, 0xe3, 0x22, 0x2f, 0xaa, 0x21, 0x50, 0xb3, 0xf8, 0xaf, 0x04,
	0x58, 0x08, 0xc3, 0x47, 0xe5, 0x73, 0x4e, 0xc8, 0x5b, 0x13, 0x1e, 0x4f, 0x79, 0x07, 0x66, 0x59,
	0xa3, 0x64, 0xa5, 0xdd, 0x96, 0x2d, 0x7c, 0xc6, 0xba, 0x39, 0xbd, 0x35, 0x21, 0xe5, 0x59, 0x41,
	0xa9, 0xdd, 0xae, 0xe3, 0x33, 0x8b, 0x8c, 0x7b, 0x6f, 0xf3, 0xdb, 0xba, 0xc1, 0xe3, 0xc2, 0xc8,
	0x71, 0x5f, 0x26, 0x88, 0xd2, 0x8c, 0xe1, 0xca, 0xde, 0xd6, 0x8d, 0x8d, 0x34, 0x4c, 0x59, 0x8a,
	0xd1, 0xc2, 0x96, 0x58, 0x86, 0x14, 0x05, 0x11, 0xb3, 0x33, 0x70, 0x93, 0xb6, 0x23, 0x21, 0x91,
	0x9f, 0xc4, 0xc4, 0x5a, 0x06, 0xc6, 0x1a, 0x15, 0x28, 0x21, 0xb1, 0x0f, 0x62, 0x8c, 0x87, 0xf6,
	0x2c, 0x9f, 0x90, 0xe8, 0x6f, 0xb1, 0x01, 0xf3, 0x3e, 0x25, 0x9b, 0x5d, 0x5d, 0x33, 0x31, 0x7a,
	0x19, 0x78, 0xbd, 0xb8, 0x29, 0x53, 0xdd, 0x52, 0xee, 0x39, 0xbb, 0x61, 0xb8, 0x49, 0xd1, 0x09,
	0x1a, 0x3e, 0xb3, 0x0c, 0x86, 0xe7, 0x68, 0x20, 0x23, 0xe5, 0x1d, 0x28, 0x69, 0xbf, 0xf8, 0x17,
	0x92, 0xb0, 0xbc, 0x89, 0xd5, 0x26, 0xd6, 0x2c, 0xf5, 0xa8, 0xcf, 0x63, 0x94, 0x51, 0x96, 0xfc,
	0x18, 0xe6, 0x9a, 0x0e, 0x8d, 0xdf, 0x98, 0x5f, 0x8b, 0x52, 0x9b, 0xaf, 0x22, 0x62, 0x1c, 0x85,
	0x66, 0x00, 0x12, 0x32, 0x48, 0x92, 0x17, 0x1c, 0x24, 0xef, 0xc1, 0x24, 0x8d, 0x68, 0x99, 0xef,
	0xfc, 0x7a, 0x74, 0xb7, 0x3a, 0x21, 0x9a, 0x44, 0x89, 0xd0, 0x3a, 0x2c, 0xda, 0xe2, 0x58, 0xb8,
	0xd3, 0x6d, 0x93, 0x29, 0x4f, 0x53, 0x3a, 0x98, 0x7a, 0xd1, 0x8c, 0x34, 0xcf, 0x0b, 0xeb, 0xbc,
	0x6c, 0x4f, 0xe9, 0x60, 0xf4, 0x4d, 0x58, 0xf6, 0x68, 0xc7, 0x4f, 0x36, 0x45, 0xc9, 0x96, 0xdc,
	0x72, 0x2f, 0xa5, 0xf8, 0x6b, 0x02, 0x5c, 0x0d, 0xe9, 0x0c, 0xde, 0xf1, 0x76, 0x43, 0x84, 0xf3,
	0x34, 0x64, 0x0f, 0xd2, 0xfa, 0x33, 0x6c, 0x3c, 0x53, 0xf1, 0x29, 0xef, 0xa9, 0xf5, 0x48, 0xdf,
	0x6d, 0x28, 0x9a, 0x79, 0xa4, 0x1b, 0x1d, 0xea, 0x3d, 0xab, 0x9c, 0x52, 0x72, 0x78, 0x50, 0xbb,
	0x91, 0xce, 0x61, 0x37, 0xc6, 0xe5, 0xd8, 0x8d, 0xf1, 0x47, 0xd3, 0x6e, 0x8c, 0x11, 0x76, 0x63,
	0x0c, 0xb7, 0x1b, 0xe9, 0x0f, 0x87, 0xdd, 0xfc, 0x0f, 0x01, 0x16, 0x5d, 0xb5, 0xc7, 0x31, 0x9a,
	0xcb, 0x9f, 0x36, 0x6d, 0x85, 0x24, 0x2f, 0xb5, 0x67, 0x27, 0x87, 0xf6, 0xac, 0xf8, 0x39, 0x2c,
	0x05, 0xdb, 0xcc, 0xfb, 0xa6, 0x04, 0x53, 0x06, 0x5d, 0xb1, 0xf0, 0xde, 0x89, 0xd3, 0x28, 0xb6,
	0xc4, 0x91, 0x38, 0xa1, 0xf8, 0x57, 0x04, 0x58, 0xe6, 0x25, 0x64, 0x5a, 0xaf, 0xe9, 0x3d, 0xa3,
	0x31, 0x32, 0x16, 0xf9, 0x08, 0xe0, 0x89, 0x7e, 0x38, 0xc6, 0x10, 0xe4, 0x35, 0x3c, 0xd4, 0x0f,
	0xb9, 0x4e, 0x33, 0x4f, 0xec, 0x9f, 0x68, 0x11, 0xa6, 0x08, 0x33, 0xb5, 0xc9, 0x43, 0x90, 0xd4,
	0x13, 0xfd, 0x70, 0xbb, 0x29, 0xfe, 0x38, 0x01, 0xf3, 0xd5, 0x9e, 0xd5, 0xed, 0x59, 0x35, 0x96,
	0x12, 0xe3, 0xe8, 0x25, 0x7b, 0xe9, 0x1a, 0xa3, 0xc9, 0x1b, 0x6a, 0xeb, 0xe3, 0x1e, 0x36, 0xfa,
	0xfe, 0x25, 0x2c, 0x52, 0x20, 0xaf, 0x53, 0xce, 0xb2, 0xd9, 0x38, 0xc6, 0x1d, 0x85, 0x2f, 0x86,
	0xbe, 0x15, 0xc5, 0x2a, 0x44, 0x14, 0x1b, 0x46, 0x79, 0x48, 0x39, 0xdd, 0xf3, 0x25, 0xfe, 0xa2,
	0x00, 0x39, 0x6f, 0x31, 0xba, 0x01, 0x57, 0xab, 0x07, 0xf5, 0xfd, 0x83, 0xba, 0x5c, 0x2b, 0x6f,
	0x55, 0x76, 0x4b, 0xf2, 0xc1, 0x5e, 0x6d, 0xbf, 0x52, 0xde, 0xbe, 0xbf, 0x5d, 0xd9, 0x2c, 0x4c,
	0xa0, 0x39, 0xc8, 0x6f, 0x94, 0x6a, 0xdb, 0x65, 0xb9, 0x5c, 0xdd, 0x39, 0xd8, 0xdd, 0xab, 0x15,
	0x04, 0x34, 0x0b, 0xd9, 0x07, 0xe5, 0x9a, 0x03, 0x48, 0xa0, 0x45, 0x98, 0xdb, 0x2c, 0xd5, 0x4b,
	0xb5, 0x7a, 0x55, 0xaa, 0x38, 0xe0, 0x24, 0x01, 0x6f, 0x6c, 0x3f, 0x90, 0x3f, 0x3e, 0xa8, 0x48,
	0x8f, 0x1d, 0xf0, 0x24, 0x21, 0x2f, 0xed, 0xec, 0x38, 0x80, 0xd4, 0xc6, 0x14, 0xcb, 0x1a, 0x88,
	0x1d, 0x40, 0x76, 0xd4, 0x53, 0xb3, 0x14, 0x4b, 0x35, 0x2d, 0xb5, 0x61, 0x5e, 0x46, 0x26, 0x63,
	0x01, 0x52, 0x0d, 0xbd, 0xa7, 0x59, 0x3c, 0x92, 0x66, 0x1f, 0xe2, 0x7f, 0x99, 0x0c, 0x31, 0xb0,
	0x4d, 0x6c, 0x29, 0x6a, 0xdb, 0x44, 0x06, 0x71, 0xe9, 0xd4, 0xd6, 0x70, 0x53, 0xd6, 0xbb, 0x34,
	0x49, 0xca, 0xed, 0x29, 0x4e, 0x2a, 0x67, 0x80, 0xe1, 0xaa, 0x64, 0x73, 0xab, 0x32, 0x66, 0xc4,
	0xd7, 0xfb, 0x21, 0xa8, 0xe6, 0x0c, 0x1a, 0x36, 0x82, 0xdf, 0x3b, 0x67, 0x45, 0xde, 0x61, 0x54,
	0xfc, 0x1d, 0x01, 0x0a, 0xc1, 0xba, 0x51, 0x0b, 0xae, 0x9a, 0x9a, 0xd2, 0x35, 0x8f, 0x75, 0x4b,
	0x0e, 0x8e, 0x7a, 0xae, 0xe3, 0x57, 0x63, 0x54, 0x6e, 0x3b, 0x03, 0xe9, 0x8a, 0xcd, 0x2d, 0x50,
	0x10, 0x18, 0x8f, 0xc9, 0x0b, 0x8d, 0xc7, 0xe2, 0x3f, 0x14, 0x60, 0x8a, 0xe7, 0x41, 0xbe, 0x0e,
	0xb3, 0x5d, 0x43, 0x6f, 0x60, 0xd3, 0xc4, 0x4d, 0x99, 0xac, 0x76, 0x4d, 0xbe, 0x72, 0x9a, 0x71,
	0xc0, 0x1b, 0x04, 0x4a, 0xdc, 0x9a, 0xa5, 0x5b, 0x4a, 0x5b, 0xc6, 0xa6, 0xa5, 0x76, 0x14, 0xcb,
	0x41, 0x67, 0xa6, 0x30, 0x4f, 0x0b, 0x2b, 0x76, 0x19, 0xa3, 0x79, 0x04, 0xb3, 0x8e, 0xc5, 0xc9,
	0xa6, 0xa5, 0x58, 0xf6, 0x5a, 0x77, 0x35, 0x8e, 0xdd, 0xb9, 0xa6, 0x4b, 0xfc, 0xb3, 0x0b, 0x33,
	0xc5, 0x5f, 0x11, 0x60, 0xde, 0xc6, 0xda, 0xc4, 0x66, 0xc3, 0x50, 0x69, 0x77, 0x90, 0x20, 0x99,
	0x7a, 0x5a, 0x9e, 0x35, 0x23, 0xbf, 0xd1, 0x8b, 0x90, 0x6b, 0xaa, 0x66, 0xb7, 0xad, 0xf4, 0x99,
	0x17, 0x66, 0x41, 0x6e, 0x96, 0xc3, 0xe8, 0xbc, 0x2a, 0x41, 0xce, 0xec, 0x75, 0xbb, 0xba, 0xc1,
	0x1a, 0x45, 0x65, 0x9c, 0x59, 0x5f, 0x8b, 0x25, 0xa3, 0x4d, 0xb7, 0xd1, 0x97, 0xb2, 0xa6, 0xfb,
	0x21, 0xd6, 0x60, 0x61, 0x47, 0x35, 0x2d, 0x27, 0xb5, 0x6a, 0xfb, 0xdb, 0x97, 0x20, 0xdf, 0x56,
	0xb4, 0x56, 0x8f, 0x2c, 0xab, 0x1a, 0x7a, 0xd3, 0x96, 0x35, 0x67, 0x03, 0xcb, 0x7a, 0x13, 0x13,
	0xa7, 0x7c, 0xa4, 0xb6, 0x2d, 0x6c, 0x70, 0x69, 0xf9, 0x97, 0xd8, 0x82, 0xc5, 0x00, 0x53, 0x3e,
	0x4b, 0xec, 0x85, 0xe4, 0xd1, 0x63, 0xc9, 0xef, 0xd1, 0x9e, 0x27, 0xa5, 0x2e, 0x7e, 0x5f, 0x80,
	0xeb, 0x25, 0x4d, 0x69, 0xf7, 0xbf, 0xc2, 0x9e, 0x29, 0x43, 0x35, 0x4f, 0x46, 0xcf, 0xc5, 0x83,
	0xd3, 0xc6, 0x9b, 0x91, 0xab, 0x44, 0xd5, 0x3c, 0xa1, 0x35, 0x99, 0xaa, 0x39, 0xce, 0xdc, 0xf1,
	0xbf, 0x04, 0x58, 0x0c, 0xa5, 0x25, 0xe1, 0x00, 0xaf, 0x48, 0xee, 0x60, 0xcb, 0x50, 0x1b, 0x71,
	0xa6, 0x91, 0x7d, 0x06, 0xdb, 0xa5, 0x04, 0x52, 0xbe, 0xeb, 0xfd, 0x44, 0x3b, 0x90, 0x33, 0xa9,
	0x06, 0x64, 0x36, 0x2d, 0x25, 0xc6, 0x9c, 0x96, 0xa4, 0x2c, 0x23, 0x67, 0x69, 0xd4, 0x6f, 0xc1,
	0x34, 0x5b, 0x13, 0xda, 0x83, 0x41, 0x8c, 0x62, 0x54, 0xa2, 0xa8, 0x92, 0x4d, 0x22, 0xfe, 0xdb,
	0x59, 0xc8, 0xfb, 0x84, 0x45, 0xcf, 0x60, 0x49, 0xeb, 0x75, 0xb0, 0xa1, 0x36, 0x94, 0x36, 0x1b,
	0x64, 0xb6, 0xfa, 0x59, 0xbb, 0x3f, 0x88, 0xdd, 0xee, 0xd5, 0x3d, 0x9b, 0x0f, 0x1d, 0x66, 0x4c,
	0x9f, 0x5b, 0x13, 0xd2, 0x82, 0x16, 0x02, 0x47, 0x7f, 0x02, 0x96, 0x1b, 0x8a, 0x85, 0x5b, 0x7a,
	0x48, 0xcd, 0x4c, 0x43, 0x1f, 0xc6, 0xaf, 0xb9, 0xec, 0x72, 0xf2, 0xd7, 0xbd, 0xd4, 0x08, 0x2d,
	0x41, 0x4f, 0x00, 0x9d, 0xc8, 0x8a, 0xa6, 0x6b, 0xfd, 0x8e, 0x6a, 0xf5, 0xfd, 0x7e, 0xf1, 0x5e,
	0xfc, 0x7a, 0x3f, 0x2a, 0xd9, 0x2c, 0x9c, 0x1a, 0x0b, 0x27, 0x01, 0x18, 0xa9, 0xab, 0x2d, 0x37,
	0xd5, 0x67, 0xd8, 0x30, 0x3d, 0x75, 0x4d, 0x8e, 0x5b, 0xd7, 0xce, 0xa6, 0xcd, 0xc2, 0xad, 0xab,
	0x1d, 0x80, 0xa1, 0x53, 0xb8, 0x72, 0x22, 0x77, 0x94, 0xae, 0xed, 0x66, 0xdd, 0xa4, 0x0b, 0xcf,
	0xcb, 0x8d, 0xd1, 0x9d, 0x1f, 0xed, 0x2a, 0xdd, 0x8a, 0xc3, 0xc6, 0xed, 0xce, 0x93, 0x10, 0x78,
	0xf1, 0x63, 0x58, 0x08, 0xeb, 0x7e, 0xf4, 0x2e, 0xa4, 0x68, 0x92, 0x8f, 0x5b, 0x53, 0xac, 0xb4,
	0x20, 0xa3, 0x28, 0xd6, 0x60, 0x29, 0xbc, 0x5f, 0x2f, 0xc2, 0xf4, 0xbb, 0x02, 0x14, 0x82, 0xbd,
	0x86, 0x3e, 0x84, 0xcc, 0xd3, 0x9e, 0x62, 0xaa, 0xb2, 0xda, 0x1c, 0x6b, 0x73, 0x22, 0x4d, 0xa9,
	0xb6, 0x9b, 0x34, 0x38, 0x22, 0x8b, 0x23, 0xab, 0x4f, 0x3c, 0x4d, 0x8c, 0xec, 0x7b, 0x85, 0x22,
	0x13, 0x16, 0x98, 0xff, 0x2a, 0xfe, 0xba, 0x00, 0x85, 0x60, 0x1f, 0x5f, 0x82, 0x64, 0x75, 0x98,
	0x37, 0xb1, 0x66, 0xaa, 0x96, 0xfa, 0x0c, 0xcb, 0x8a, 0x65, 0x19, 0xea, 0x61, 0xcf, 0xb2, 0x9d,
	0x50, 0x2c, 0x5e, 0xc8, 0xa1, 0x2f, 0xd9, 0xe4, 0xc5, 0x5f, 0x9e, 0x86, 0x85, 0x30, 0xfb, 0x40,
	0xad, 0x41, 0x81, 0x1f, 0x5e, 0xcc, 0xe4, 0x56, 0xeb, 0x4a, 0xab, 0x85, 0x9b, 0x54, 0x1a, 0x4f,
	0xbb, 0x6e, 0x42, 0xd6, 0xc0, 0x2d, 0x66, 0xdf, 0x4d, 0x7b, 0x5e, 0x06, 0x06, 0xa2, 0xb3, 0xe0,
	0x19, 0x14, 0x94, 0xde, 0x99, 0xda, 0x56, 0x15, 0xa3, 0xcf, 0x3c, 0xaf, 0xed, 0x31, 0x77, 0x2f,
	0x28, 0x50, 0xc9, 0x66, 0xcb, 0xdc, 0xf3, 0xac, 0xe2, 0xfb, 0x36, 0x8b, 0xff, 0x49, 0x80, 0xac,
	0x47, 0xe8, 0x0b, 0x98, 0xab, 0x3f, 0x5b, 0x99, 0x38, 0x67, 0xb6, 0xf2, 0x26, 0x00, 0xdf, 0xee,
	0xb5, 0x94, 0x96, 0xb3, 0xd1, 0x97, 0x61, 0xb0, 0xba, 0xd2, 0x42, 0x6f, 0x03, 0x41, 0xc6, 0x86,
	0x81, 0x9b, 0xdc, 0x2f, 0x2d, 0x0d, 0xec, 0xb5, 0x54, 0x3a, 0x5d, 0xab, 0xcf, 0xd9, 0x52, 0xcc,
	0x8d, 0x14, 0x24, 0x2d, 0xa5, 0x55, 0xfc, 0xb9, 0x24, 0xcc, 0xf8, 0x35, 0x82, 0xbe, 0x6d, 0xaf,
	0xc0, 0x92, 0xe3, 0x4e, 0x75, 0x7c, 0xfd, 0x75, 0x3a, 0x68, 0x45, 0x9f, 0x5d, 0x6a, 0xa7, 0xad,
	0x7e, 0xcc, 0xec, 0x28, 0x68, 0x55, 0x12, 0x20, 0x03, 0xb7, 0x15, 0x3a, 0x58, 0x8e, 0xe8, 0xc2,
	0x40, 0x6b, 0xf4, 0xc7, 0x19, 0x2c, 0x73, 0x36, 0xf9, 0x7d, 0x9b, 0xba, 0x78, 0x0c, 0x39, 0x6f,
	0x6d, 0x17, 0x31, 0x87, 0x1b, 0xbe, 0x9e, 0x64, 0x36, 0xef, 0xf6, 0xa3, 0xb3, 0x80, 0xfb, 0x5b,
	0x2f, 0x0c, 0x89, 0xbf, 0xec, 0x55, 0x55, 0x03, 0x96, 0xdd, 0x55, 0xd5, 0x45, 0xc3, 0x9d, 0x25,
	0x87, 0x95, 0x3f, 0xb2, 0x90, 0xc1, 0x2d, 0x91, 0x2f, 0x16, 0x01, 0x2d, 0x38, 0x8c, 0x6a, 0x9e,
	0x50, 0xe8, 0x67, 0x85, 0xc1, 0xd8, 0xc5, 0xb7, 0x70, 0x8b, 0x1c, 0xe8, 0x51, 0x0a, 0x0a, 0x84,
	0x32, 0x6c, 0xb1, 0x33, 0x18, 0xca, 0xf0, 0x45, 0xd0, 0x2f, 0x08, 0x61, 0xb1, 0x0c, 0x97, 0x84,
	0x8d, 0xa7, 0xea, 0xb9, 0x25, 0x09, 0x4e, 0x81, 0x8e, 0x2c, 0x03, 0xa1, 0x0d, 0x97, 0xa6, 0xef,
	0x0f, 0x6d, 0xb8, 0x18, 0x6c, 0xf6, 0xdf, 0x3e, 0xb7, 0x18, 0xee, 0x9c, 0xe9, 0x08, 0xe0, 0x89,
	0x74, 0xdc, 0xaa, 0xbd, 0x91, 0x0e, 0xaf, 0x7a, 0xea, 0x82, 0x55, 0xbb, 0x93, 0xa2, 0x5b, 0x75,
	0x3b, 0x00, 0x43, 0x7f, 0x4e, 0x08, 0x89, 0x7c, 0xb8, 0x00, 0xd3, 0x17, 0x34, 0x06, 0xbf, 0x3f,
	0x71, 0x8d, 0xe1, 0x24, 0x04, 0x5e, 0xfc, 0x7d, 0x21, 0x18, 0x09, 0x71, 0x09, 0x3f, 0x80, 0x4c,
	0x47, 0xd5, 0x64, 0x76, 0xda, 0x22, 0xc6, 0x16, 0x32, 0x3b, 0x81, 0x90, 0xee, 0xa8, 0x1a, 0xfd,
	0x45, 0xe9, 0x95, 0x33, 0x4e, 0x9f, 0x88, 0x4f, 0xaf, 0x9c, 0x31, 0xfa, 0x87, 0x30, 0xfb, 0xb4,
	0xa7, 0x68, 0x96, 0xda, 0xc6, 0x32, 0x3f, 0x07, 0x31, 0x19, 0xf7, 0x1c, 0xc4, 0x8c, 0x4d, 0x49,
	0x3f, 0xcd, 0xe2, 0x7f, 0x48, 0x0e, 0xc6, 0x66, 0xbc, 0x99, 0xbf, 0x29, 0xc0, 0x8b, 0x94, 0xbd,
	0xeb, 0x3f, 0xe5, 0x63, 0xd5, 0xb4, 0xf4, 0x96, 0xa1, 0x74, 0xe4, 0xc3, 0x5e, 0xe3, 0x04, 0x5b,
	0xf6, 0x06, 0xa0, 0x7e, 0xc9, 0xa3, 0x62, 0x00, 0xbc, 0x65, 0x57, 0xbc, 0x41, 0xeb, 0x95, 0x5e,
	0xa0, 0x92, 0x39, 0xae, 0x39, 0x50, 0x6c, 0x16, 0x7f, 0x29, 0x01, 0x37, 0x47, 0xf0, 0x40, 0xef,
	0xc3, 0xb5, 0x60, 0xfb, 0xda, 0xfa, 0x29, 0x36, 0xe4, 0x43, 0xbd, 0xa7, 0x35, 0x79, 0xfa, 0x63,
	0xd9, 0x5f, 0xd1, 0x0e, 0x41, 0xd8, 0x20, 0xe5, 0x61, 0xe4, 0xbd, 0x6e, 0xd7, 0x21, 0x4f, 0x84,
	0x91, 0x1f, 0x10, 0x04, 0x46, 0x7e, 0x13, 0xb2, 0x4c, 0x87, 0xb2, 0xa9, 0x7e, 0xc5, 0x26, 0xd8,
	0xa4, 0x04, 0x0c, 0x54, 0x53, 0xbf, 0xc2, 0xa8, 0x0a, 0x79, 0x8e, 0xe0, 0xeb, 0xe4, 0x95, 0x91,
	0x9d, 0xec, 0xd4, 0x26, 0xe5, 0x18, 0x03, 0xde, 0xd7, 0xff, 0x3c, 0xe5, 0x8d, 0x98, 0x79, 0x2f,
	0xff, 0x3d, 0x01, 0x5e, 0xc2, 0x4f, 0x7b, 0xea, 0x33, 0xa5, 0x8d, 0xb5, 0x06, 0x96, 0x1b, 0x6d,
	0xc5, 0x34, 0x87, 0xf6, 0x73, 0xe3, 0xd2, 0xdc, 0x8e, 0x07, 0x10, 0xec, 0xdb, 0x5b, 0x1e, 0x79,
	0xca, 0x44, 0x9c, 0x81, 0xde, 0xfd, 0xbe, 0x00, 0x45, 0x97, 0xbe, 0x12, 0x40, 0x47, 0x1f, 0x41,
	0xc1, 0x09, 0x3a, 0xe4, 0x71, 0x4f, 0x0a, 0xcd, 0xd8, 0x21, 0x04, 0xd3, 0x1a, 0x7a, 0x1b, 0x96,
	0x06, 0xf5, 0x43, 0xbb, 0x8c, 0xf5, 0xf0, 0x42, 0x50, 0x5a, 0xd2, 0x79, 0xc5, 0x7f, 0x93, 0x80,
	0xab, 0x43, 0x5b, 0x88, 0x1e, 0x82, 0x18, 0xce, 0x33, 0xc4, 0x00, 0x5f, 0x08, 0xe3, 0xef, 0x31,
	0xc3, 0xe1, 0xbc, 0x06, 0xad, 0x31, 0x94, 0xd7, 0x38, 0x36, 0xf9, 0xf3, 0x42, 0xb8, 0x51, 0x36,
	0x9f, 0x87, 0x5d, 0x04, 0xfb, 0x35, 0x60, 0xce, 0x3f, 0x37, 0xed, 0x5d, 0x66, 0x71, 0x73, 0xfe,
	0xc7, 0x02, 0xbc, 0xea, 0xae, 0x92, 0xe2, 0xba, 0xaf, 0xc6, 0xa5, 0x4d, 0x69, 0x1e, 0x40, 0xd0,
	0xac, 0xbf, 0xee, 0xc8, 0xf5, 0x28, 0xda, 0x77, 0xfd, 0xa3, 0x04, 0x14, 0x5d, 0x36, 0xff, 0x1f,
	0x5a, 0x37, 0x2a, 0xc1, 0x0d, 0xad, 0xd7, 0x91, 0x9b, 0xaa, 0x69, 0xa9, 0x5a, 0xc3, 0x92, 0x03,
	0x1a, 0x37, 0xb9, 0xe5, 0x14, 0xb5, 0x5e, 0x67, 0x93, 0xe3, 0xd4, 0x7c, 0x8d, 0x37, 0xd1, 0x17,
	0xb0, 0x60, 0xe9, 0xdd, 0x41, 0xca, 0xf1, 0x9d, 0x1c, 0xb2, 0xf4, 0x6e, 0x80, 0x7b, 0xf1, 0x3f,
	0x27, 0xe0, 0xea, 0xd0, 0x9e, 0x40, 0xfb, 0xf0, 0xf2, 0x70, 0x1b, 0x19, 0x1c, 0x81, 0x2f, 0x0e,
	0xe9, 0x38, 0xcf, 0x20, 0x8c, 0xe4, 0x38, 0x38, 0x0e, 0x87, 0x71, 0xfc, 0x7f, 0x3b, 0x14, 0x23,
	0x6c, 0x79, 0xc4, 0x50, 0xfc, 0xdf, 0x93, 0xc1, 0x24, 0x02, 0x1f, 0x8e, 0xbf, 0x26, 0x40, 0x71,
	0x20, 0x98, 0x73, 0x46, 0x21, 0x37, 0xdb, 0x93, 0x4b, 0x8d, 0xe7, 0x02, 0xc0, 0xe0, 0x28, 0xbc,
	0x72, 0x12, 0x5e, 0x5c, 0xfc, 0x9e, 0x00, 0xd7, 0xfc, 0xa4, 0x7c, 0xad, 0xc7, 0x0d, 0xf6, 0x52,
	0x87, 0xdd, 0x1a, 0xcc, 0xbb, 0xdb, 0x27, 0x4e, 0x88, 0xcf, 0xad, 0x03, 0x39, 0x45, 0x8e, 0x2b,
	0x2c, 0x7e, 0x2f, 0x01, 0x37, 0x22, 0x1b, 0x86, 0x5e, 0x82, 0x3c, 0x89, 0x4a, 0x5d, 0x66, 0xcc,
	0x78, 0x73, 0x1d, 0x55, 0x73, 0xd8, 0x50, 0x24, 0xe5, 0x6c, 0xa0, 0xc6, 0x5c, 0x47, 0x39, 0x73,
	0x91, 0x02, 0xa6, 0x97, 0x1a, 0x30, 0xbd, 0xbf, 0x34, 0x60, 0x7a, 0xec, 0xc8, 0xb9, 0xfa, 0x3c,
	0x3b, 0xd2, 0xd7, 0x1b, 0x7e, 0xfb, 0xdb, 0x48, 0xdb, 0xfb, 0x7c, 0xa2, 0x0c, 0x33, 0xfe, 0x21,
	0x85, 0xde, 0xb1, 0xcf, 0x45, 0xc7, 0x8e, 0xd4, 0xf9, 0xc1, 0xe9, 0xf0, 0x3d, 0xce, 0xbf, 0x91,
	0x84, 0x14, 0x0b, 0xc3, 0x5f, 0x86, 0xbc, 0xaa, 0x59, 0xb8, 0x85, 0x0d, 0xcf, 0x52, 0x20, 0xb9,
	0x35, 0x21, 0xe5, 0x38, 0x98, 0xa1, 0xbd, 0x08, 0xd9, 0xa3, 0xb6, 0xae, 0x58, 0x9e, 0x78, 0x5f,
	0xd8, 0x9a, 0x90, 0x80, 0x02, 0x19, 0xca, 0x4b, 0x90, 0x33, 0x2d, 0x43, 0xd5, 0x5a, 0xb2, 0xff,
	0x04, 0x77, 0x96, 0x41, 0x9d, 0xea, 0x0e, 0x75, 0xbd, 0x8d, 0x15, 0x7b, 0xe5, 0x31, 0xc9, 0xcf,
	0xa9, 0xe5, 0x38, 0x98, 0xa1, 0x55, 0x60, 0xd6, 0xb9, 0xd9, 0xc1, 0x11, 0x53, 0xa3, 0x0e, 0xdd,
	0x6e, 0x4d, 0x48, 0x33, 0x0e, 0x11, 0x63, 0xf3, 0x0e, 0x00, 0x81, 0x70, 0x0e, 0x53, 0xfe, 0x54,
	0x92, 0xd5, 0xef, 0x62, 0x4a, 0x5d, 0x3d, 0xda, 0x54, 0xfa, 0x5b, 0x13, 0x52, 0x86, 0xe0, 0x32,
	0xc2, 0x75, 0x80, 0xa6, 0x62, 0xd9, 0x84, 0x6c, 0xc1, 0x36, 0xe7, 0x23, 0xdc, 0x54, 0x2c, 0x4c,
	0x68, 0x08, 0x1a, 0xa3, 0x29, 0xc3, 0x5c, 0x53, 0xe9, 0xcb, 0xfa, 0x91, 0x7c, 0x8a, 0xf1, 0x09,
	0x27, 0x4d, 0xd3, 0x8d, 0xfa, 0xa5, 0x00, 0x69, 0xbf, 0x7a, 0xf4, 0x09, 0xc6, 0x27, 0x44, 0xe2,
	0xa6, 0xfd, 0x41, 0x99, 0x38, 0x29, 0x93, 0x3f, 0x0e, 0x19, 0xe7, 0x18, 0x30, 0x2a, 0xd3, 0x13,
	0xec, 0xfc, 0xf0, 0x71, 0x8c, 0xac, 0xdb, 0x26, 0x3f, 0x7a, 0xbc, 0x35, 0x21, 0xa5, 0x9b, 0xfc,
	0xf7, 0xc6, 0x0c, 0xe4, 0xba, 0x8a, 0x61, 0xe2, 0x26, 0xbb, 0xb6, 0x21, 0x7e, 0x27, 0x01, 0x69,
	0x1b, 0x11, 0xbd, 0x4c, 0x0f, 0xe3, 0xdb, 0xd6, 0x35, 0xd8, 0x52, 0x7a, 0x3a, 0x1f, 0xa3, 0x6f,
	0x40, 0xd6, 0xd3, 0x44, 0x7e, 0x31, 0x65, 0x48, 0xe3, 0x88, 0x6a, 0xf8, 0x4f, 0xb4, 0x02, 0x93,
	0x54, 0xf6, 0x64, 0x54, 0x0f, 0x48, 0x14, 0x07, 0x3d, 0x04, 0xda, 0x0f, 0xf2, 0x57, 0xba, 0x66,
	0x9f, 0xf6, 0x7f, 0x3d, 0x4e, 0x63, 0x29, 0xa3, 0xcf, 0x74, 0x0d, 0x4b, 0x69, 0x8b, 0xff, 0x2a,
	0xbe, 0x09, 0x69, 0x1b, 0x8a, 0x5e, 0x86, 0x19, 0xfd, 0xe8, 0xc8, 0xc4, 0x96, 0xdc, 0x51, 0xb5,
	0x9e, 0xbd, 0x33, 0x9c, 0x92, 0xf2, 0x0c, 0xba, 0xcb, 0x80, 0xe2, 0x9f, 0x4d, 0x40, 0x21, 0x78,
	0xfe, 0x0a, 0x3d, 0x85, 0xab, 0xee, 0xce, 0xaf, 0xe5, 0x3b, 0xf3, 0x63, 0x72, 0x9d, 0xbd, 0x15,
	0x27, 0x0d, 0xea, 0x3f, 0x2e, 0x64, 0x6e, 0x4d, 0x48, 0x57, 0xd4, 0xf0, 0x22, 0xf4, 0x04, 0x96,
	0xf8, 0x41, 0xe8, 0x60, 0x7d, 0x71, 0xb6, 0x21, 0x29, 0xe5, 0x60, 0x6d, 0x8b, 0x46, 0x58, 0xc1,
	0x46, 0x01, 0x66, 0xfc, 0x95, 0x88, 0xdf, 0x49, 0xc3, 0x95, 0x7d, 0x43, 0xed, 0xd0, 0xd9, 0xdd,
	0x8f, 0x8e, 0x3e, 0x81, 0x19, 0x03, 0x77, 0xdb, 0x0a, 0x09, 0xb4, 0xbc, 0x3b, 0x73, 0xab, 0xd1,
	0x12, 0x51, 0x0a, 0x6a, 0xe4, 0xce, 0xd6, 0x4d, 0x9e, 0xf3, 0xe1, 0x5a, 0xae, 0x02, 0x3f, 0xd3,
	0xe9, 0xdf, 0x77, 0xbb, 0x33, 0xfa, 0x58, 0xae, 0xc3, 0x31, 0x67, 0x78, 0xbe, 0x11, 0x86, 0xc5,
	0xc6, 0xb1, 0x42, 0x4f, 0x7f, 0x1a, 0xf4, 0x16, 0x99, 0x7f, 0x63, 0x2d, 0x72, 0x4b, 0xb9, 0x6c,
	0x13, 0xee, 0x2a, 0xe6, 0x89, 0xc3, 0x7f, 0xbe, 0x31, 0x08, 0x46, 0x7d, 0xb8, 0xd1, 0x30, 0xfa,
	0x5d, 0x4b, 0x97, 0x6d, 0xbd, 0x1c, 0x1d, 0x9d, 0xc9, 0x47, 0x5d, 0xec, 0xdf, 0x5b, 0xbb, 0x1b,
	0x59, 0x1d, 0x65, 0xc0, 0xb5, 0x74, 0xff, 0xe8, 0xec, 0x7e, 0xd7, 0x55, 0xd3, 0xd5, 0xc6, 0xb0,
	0x42, 0xd4, 0x83, 0x6b, 0x47, 0xea, 0x19, 0x6e, 0xb2, 0xa5, 0x12, 0x9b, 0x4d, 0x88, 0x07, 0xf6,
	0xed, 0xb1, 0xbd, 0x1d, 0x9d, 0xd1, 0x3d, 0xc3, 0x4d, 0x32, 0x1f, 0x6e, 0xd8, 0xc4, 0x4e, 0xbd,
	0xcb, 0x47, 0x43, 0xca, 0xd0, 0xa7, 0x50, 0x18, 0xa8, 0x6b, 0x6a, 0xf4, 0xf1, 0x90, 0xc1, 0x2a,
	0x66, 0x0f, 0x03, 0x9c, 0xfb, 0x70, 0xc3, 0x56, 0xe2, 0xa9, 0x6a, 0x1d, 0xbb, 0xf7, 0xa5, 0xec,
	0x6a, 0xa6, 0x47, 0xeb, 0x92, 0x2b, 0xea, 0x13, 0xd5, 0x3a, 0xb6, 0x07, 0x9e, 0xab, 0x4b, 0x63,
	0x58, 0x21, 0x7a, 0x04, 0x05, 0xea, 0x78, 0xba, 0x8a, 0xe1, 0x58, 0x60, 0x9a, 0xd6, 0x16, 0x19,
	0xc7, 0x13, 0x07, 0xb3, 0xaf, 0x18, 0xae, 0x0d, 0xd2, 0x49, 0xc8, 0x85, 0xa0, 0x2f, 0x00, 0x71,
	0xf3, 0x38, 0x56, 0xcc, 0x63, 0x9b, 0x73, 0x66, 0xf4, 0x99, 0x17, 0x66, 0x13, 0x5b, 0x8a, 0x79,
	0xec, 0xee, 0xb0, 0x36, 0x02, 0x30, 0x7a, 0x36, 0x99, 0xcc, 0x0d, 0xe6, 0xb1, 0x7a, 0xe4, 0x88,
	0x9d, 0x1d, 0xdd, 0x17, 0xc4, 0x6d, 0xd6, 0x08, 0x8d, 0xdb, 0x17, 0x4d, 0x3f, 0x28, 0xc4, 0x2d,
	0xfc, 0x37, 0x01, 0x66, 0xfc, 0xed, 0x45, 0x9f, 0xc3, 0x2c, 0x55, 0x98, 0xa5, 0xcb, 0xfc, 0xa4,
	0x35, 0x75, 0x07, 0x33, 0xd1, 0x0e, 0xd1, 0xcf, 0xc4, 0xf9, 0x94, 0xf2, 0x84, 0x57, 0x5d, 0xaf,
	0x30, 0x4e, 0xe2, 0xcf, 0x08, 0xcc, 0x81, 0x93, 0x32, 0x74, 0x15, 0x16, 0xeb, 0xdb, 0xbb, 0x15,
	0x79, 0xbf, 0x24, 0xd5, 0x03, 0x87, 0xd1, 0xd2, 0x30, 0xf9, 0xb8, 0x52, 0x92, 0x0a, 0x02, 0xca,
	0x40, 0x6a, 0xb7, 0xba, 0x57, 0xdf, 0x2a, 0x24, 0x50, 0x01, 0x72, 0x9b, 0xa5, 0xc7, 0x72, 0xf5,
	0xbe, 0xcc, 0x20, 0x49, 0x34, 0x0b, 0x59, 0x0e, 0xf9, 0xa4, 0x52, 0xf9, 0xa8, 0x30, 0x49, 0x50,
	0xc8, 0x2f, 0x02, 0xa1, 0xf4, 0x29, 0x82, 0xb2, 0x55, 0x3d, 0x90, 0x08, 0x64, 0xb3, 0xf4, 0xb8,
	0x30, 0x25, 0x7e, 0x0a, 0x85, 0x60, 0x3f, 0xa0, 0x4d, 0x00, 0xde, 0xa3, 0x27, 0xb8, 0xcf, 0xbd,
	0xdf, 0xcb, 0xa3, 0x7b, 0x92, 0x5e, 0x52, 0x69, 0xd8, 0x3f, 0xc5, 0x3a, 0xa0, 0x41, 0xaf, 0x88,
	0x3e, 0x80, 0x8c, 0x86, 0x4f, 0xc7, 0x4e, 0xcb, 0x6a, 0xf8, 0x94, 0xfe, 0x12, 0xaf, 0xc1, 0xd5,
	0xa1, 0xf6, 0x2f, 0xce, 0x40, 0xce, 0xeb, 0x30, 0xc5, 0x3f, 0x48, 0x40, 0x9e, 0x38, 0x3a, 0xb3,
	0xae, 0x6f, 0xb7, 0x34, 0xdd, 0xc0, 0x68, 0x15, 0x90, 0xe3, 0xe2, 0x4c, 0xd2, 0xa9, 0xe6, 0x89,
	0xca, 0xae, 0x91, 0x64, 0xa8, 0xf9, 0x39, 0x65, 0x75, 0xbd, 0x76, 0xa2, 0x76, 0xd1, 0x9f, 0x84,
	0x6b, 0x0d, 0xbd, 0xd3, 0xd1, 0x35, 0xd9, 0x4f, 0xa6, 0x52, 0x76, 0x3c, 0x42, 0x78, 0x7f, 0x94,
	0xa3, 0x75, 0xea, 0x5f, 0x2d, 0x53, 0x66, 0x3e, 0x18, 0xf1, 0x44, 0x0d, 0x07, 0x6c, 0xd7, 0xce,
	0xca, 0xc4, 0xef, 0x0a, 0x30, 0x1f, 0x42, 0x83, 0x6e, 0x83, 0x58, 0xae, 0xee, 0xee, 0x56, 0xf7,
	0xe4, 0xf2, 0x56, 0x49, 0xaa, 0xc9, 0xf5, 0xaa, 0xbc, 0xfd, 0x60, 0xaf, 0x2a, 0x55, 0x02, 0x96,
	0x93, 0x85, 0xe9, 0xbd, 0x83, 0xdd, 0x8a, 0xb4, 0x5d, 0x2e, 0x08, 0x68, 0x01, 0x0a, 0xa5, 0x9d,
	0xfd, 0xad, 0x92, 0x7c, 0xb0, 0xbf, 0x5f, 0x91, 0xe4, 0x72, 0xa9, 0x56, 0x29, 0x24, 0x5c, 0xe8,
	0x4e, 0xf5, 0x13, 0x1b, 0x4a, 0x6d, 0x69, 0xff, 0x60, 0xaf, 0x5c, 0x3f, 0x28, 0xd5, 0xb7, 0xab,
	0x7b, 0x85, 0x49, 0x34, 0x03, 0xf0, 0xc9, 0xd6, 0x76, 0xbd, 0x52, 0xdb, 0x2f, 0x95, 0x2b, 0x85,
	0xd4, 0x46, 0x0e, 0xc0, 0x55, 0x89, 0xf8, 0x1f, 0x89, 0x9c, 0x21, 0x73, 0xc7, 0xab, 0x30, 0x47,
	0x26, 0x26, 0xea, 0x47, 0xed, 0x62, 0x7e, 0x08, 0xa9, 0xc0, 0x0b, 0x1c, 0x32, 0xf4, 0x35, 0x98,
	0xd1, 0x7a, 0x9d, 0x43, 0x6c, 0x10, 0x0d, 0x93, 0x52, 0x7e, 0x99, 0x27, 0xc7, 0xa0, 0x75, 0x9d,
	0x30, 0x26, 0xab, 0x23, 0x03, 0x93, 0x15, 0x2f, 0x96, 0x75, 0xa3, 0x89, 0xd9, 0x05, 0x8f, 0x34,
	0x99, 0x1a, 0x29, 0xb0, 0x4a, 0x60, 0xe8, 0x73, 0x58, 0x08, 0xed, 0xb0, 0xc9, 0xd1, 0x97, 0xb7,
	0x7c, 0x8a, 0x96, 0x50, 0x63, 0xb0, 0x53, 0x7e, 0x24, 0xc0, 0xf2, 0xb0, 0x79, 0x05, 0x6d, 0x40,
	0x36, 0x98, 0x9c, 0x88, 0x65, 0xe2, 0xd0, 0x76, 0x13, 0x15, 0x1b, 0x90, 0x0d, 0xa6, 0x23, 0xe2,
	0xf1, 0xe8, 0x45, 0xa6, 0x26, 0x04, 0xef, 0xfa, 0x50, 0xfc, 0x41, 0x02, 0x66, 0x83, 0xc2, 0xef,
	0xc0, 0xb4, 0x9d, 0x73, 0x63, 0xab, 0xe6, 0xf5, 0x31, 0xe6, 0x3b, 0xfe, 0x2d, 0xd9, 0x2c, 0x8a,
	0xbf, 0x2d, 0xc0, 0x14, 0x5f, 0xf7, 0xbe, 0x05, 0xc9, 0x8e, 0xaa, 0xc5, 0xd7, 0x06, 0xc1, 0xa6,
	0x44, 0xca, 0x59, 0xfc, 0xe6, 0x13, 0x6c, 0xb4, 0x07, 0x73, 0x7c, 0x0e, 0xec, 0x60, 0xcd, 0xf2,
	0xac, 0xd5, 0x62, 0xb1, 0x28, 0x78, 0x68, 0x99, 0xc3, 0xf9, 0xf1, 0x24, 0x5c, 0x1d, 0x1a, 0xbd,
	0x5c, 0x8e, 0xab, 0x44, 0xef, 0xc3, 0x74, 0x43, 0xd7, 0x9c, 0x5b, 0x3d, 0x71, 0xaf, 0xf3, 0x71,
	0x1a, 0x74, 0x06, 0xb3, 0xdc, 0x49, 0x29, 0xed, 0xee, 0xb1, 0x72, 0x88, 0xd9, 0x36, 0xe8, 0x4c,
	0xf4, 0x1e, 0xdc, 0xd0, 0x46, 0xad, 0xde, 0x3f, 0x3a, 0x63, 0x3e, 0x67, 0x8f, 0x6e, 0xad, 0x97,
	0x38, 0x53, 0x32, 0xf7, 0xb3, 0x7a, 0x6c, 0x08, 0x7a, 0x05, 0xf8, 0xa5, 0x74, 0xb7, 0xe6, 0x14,
	0xf7, 0xa5, 0x33, 0xac, 0xc0, 0x41, 0x5d, 0x82, 0x94, 0xa1, 0x34, 0xd5, 0x33, 0x1a, 0x48, 0xa5,
	0xb6, 0x26, 0x24, 0xf6, 0x49, 0x0f, 0xcc, 0xf4, 0x0c, 0x43, 0x6f, 0x29, 0x96, 0xe7, 0x32, 0x3d,
	0x8f, 0x4c, 0xe2, 0x9d, 0x78, 0x9e, 0x73, 0x18, 0xd8, 0x20, 0xf1, 0x3b, 0x02, 0x5c, 0x19, 0xd2,
	0x0c, 0xb4, 0x02, 0xb7, 0xef, 0xdf, 0xff, 0x54, 0xe6, 0xfe, 0x73, 0xaf, 0x54, 0xdf, 0x7e, 0x54,
	0x91, 0xa9, 0x0b, 0xdc, 0xa8, 0xd4, 0xa3, 0xfc, 0x27, 0x99, 0x3c, 0x2b, 0x9f, 0x96, 0x36, 0x2b,
	0xe5, 0xed, 0xdd, 0xd2, 0x4e, 0x21, 0x81, 0xae, 0xc3, 0xb2, 0xeb, 0x4a, 0x19, 0x0b, 0xd9, 0x46,
	0x4f, 0xa2, 0x39, 0xc8, 0xfb, 0x41, 0x93, 0x1b, 0x00, 0x69, 0x5b, 0x51, 0xe2, 0xcf, 0x27, 0x20,
	0xe3, 0x58, 0x03, 0xda, 0x83, 0x0c, 0x0d, 0x46, 0x54, 0xfb, 0x94, 0xe6, 0x88, 0x05, 0x47, 0xdd,
	0x46, 0x76, 0x58, 0xd0, 0x15, 0xbe, 0x0d, 0x25, 0xfc, 0x7a, 0xda, 0xa9, 0xa1, 0x74, 0xbb, 0xd8,
	0x76, 0x20, 0x91, 0xfc, 0x0e, 0x6c, 0x64, 0x1f, 0x3f, 0x87, 0x05, 0x92, 0x20, 0x7b, 0xd2, 0x31,
	0x65, 0x9b, 0x63, 0x8c, 0x15, 0xc6, 0x47, 0x1d, 0xf3, 0x93, 0x41, 0x96, 0x70, 0xe2, 0x80, 0x37,
	0xd2, 0x30, 0xc5, 0xce, 0x29, 0x88, 0x77, 0x00, 0x0d, 0x36, 0x28, 0xec, 0x80, 0xb0, 0x78, 0x1b,
	0xd0, 0xa0, 0xa8, 0xa8, 0x00, 0x49, 0x7b, 0xfc, 0xe5, 0x24, 0xf2, 0x53, 0xfc, 0x12, 0xe6, 0x43,
	0x04, 0x20, 0x5e, 0x91, 0x13, 0xcb, 0x2e, 0x01, 0x70, 0x10, 0x41, 0xb8, 0x0d, 0xb3, 0xee, 0x80,
	0xf6, 0x9e, 0x41, 0xce, 0x3b, 0xc3, 0x95, 0xde, 0x01, 0xf9, 0x89, 0x00, 0xb3, 0x81, 0x18, 0x13,
	0xdd, 0x81, 0x82, 0xc7, 0x6d, 0xcb, 0x4d, 0xa5, 0x6f, 0x2f, 0xc2, 0x67, 0x5c, 0xc7, 0xbc, 0xa9,
	0xf4, 0x4d, 0x82, 0xe9, 0x99, 0x24, 0x18, 0x26, 0x9b, 0xeb, 0x66, 0xdc, 0x69, 0x80, 0x62, 0x7a,
	0x5c, 0x43, 0xf2, 0x1c, 0xae, 0xe1, 0xbe, 0xcf, 0x3f, 0x4d, 0x8e, 0xe1, 0x9f, 0xe8, 0x91, 0x25,
	0xfb, 0x83, 0x74, 0x55, 0x07, 0x5b, 0xc7, 0x7a, 0x53, 0xfc, 0xd7, 0x09, 0xb8, 0x32, 0x64, 0xbd,
	0x8f, 0x2c, 0x98, 0x1d, 0xcc, 0x1e, 0x8c, 0x3c, 0x93, 0x36, 0x84, 0xdb, 0x10, 0xb8, 0x14, 0xac,
	0xa2, 0xf8, 0x2f, 0x04, 0x58, 0x0a, 0xc7, 0xbd, 0x9c, 0x17, 0x4b, 0x34, 0x58, 0xee, 0xda, 0xb9,
	0x82, 0x40, 0xb6, 0x82, 0x8f, 0xac, 0xb7, 0x46, 0x9c, 0xde, 0x09, 0xcb, 0x33, 0x48, 0x57, 0xba,
	0xe1, 0x05, 0xe2, 0x77, 0x92, 0x30, 0x4f, 0x3b, 0x32, 0xd0, 0x98, 0xf7, 0x60, 0x8a, 0x1e, 0x4b,
	0x1a, 0xeb, 0x64, 0x22, 0x27, 0x41, 0xdb, 0x90, 0x69, 0xe8, 0x5a, 0x53, 0xa5, 0x52, 0x27, 0x47,
	0xaf, 0x9f, 0x58, 0x8a, 0xa5, 0x6c, 0x93, 0x48, 0x2e, 0x35, 0xea, 0x46, 0xe8, 0x63, 0xf2, 0xdc,
	0xfa, 0xd8, 0x9a, 0x18, 0xaa, 0x91, 0xe8, 0xfc, 0x54, 0xea, 0x79, 0xe4, 0xa7, 0x42, 0x16, 0x87,
	0xbf, 0x27, 0xc0, 0x62, 0x68, 0xe2, 0x09, 0x35, 0x61, 0x91, 0x5d, 0xc7, 0x0f, 0x37, 0xfe, 0xb5,
	0x91, 0xfd, 0x14, 0xb0, 0x8c, 0x85, 0xa3, 0x41, 0xa0, 0x89, 0xbe, 0x84, 0x79, 0x9e, 0x31, 0x33,
	0x7b, 0xdd, 0xae, 0x81, 0x4d, 0x93, 0xa7, 0xcb, 0x92, 0xa3, 0x52, 0x88, 0x4c, 0xea, 0x9a, 0x4b,
	0x25, 0x21, 0x23, 0x08, 0x32, 0xc5, 0x2f, 0x61, 0x6e, 0x00, 0xd1, 0x6f, 0x36, 0xc2, 0x45, 0xcc,
	0x46, 0xfc, 0x51, 0x0a, 0x66, 0x03, 0xc5, 0xe8, 0x31, 0x64, 0xf1, 0x99, 0xdb, 0x96, 0x18, 0x4f,
	0xf8, 0x04, 0x38, 0xac, 0x56, 0x5c, 0x72, 0xc9, 0xcb, 0xab, 0xf8, 0xcf, 0x04, 0xc8, 0xb8, 0x15,
	0x5d, 0xe0, 0x10, 0xe0, 0x43, 0x48, 0xeb, 0x5d, 0x6c, 0x28, 0x16, 0xbf, 0x4b, 0x3e, 0x33, 0x2a,
	0x13, 0xd8, 0xa6, 0x1d, 0xa6, 0xb4, 0xab, 0x9c, 0x4a, 0x72, 0xe8, 0xdd, 0x6d, 0x8e, 0xc9, 0xf1,
	0xb6, 0x39, 0x8a, 0x0d, 0x00, 0xa7, 0x31, 0x26, 0x3a, 0x00, 0x70, 0xf4, 0x6a, 0x5b, 0xd9, 0xdd,
	0x71, 0xb4, 0xe6, 0x76, 0x90, 0x87, 0x51, 0xf1, 0x57, 0x13, 0x90, 0xf5, 0xe8, 0x13, 0x19, 0x64,
	0x96, 0x6a, 0xd1, 0x33, 0x76, 0x8e, 0x06, 0x58, 0xf2, 0xe3, 0xc1, 0x39, 0xbb, 0x68, 0x75, 0x87,
	0xf1, 0x73, 0x54, 0x33, 0xdb, 0xf6, 0x03, 0xd0, 0xa7, 0xbe, 0xa6, 0x31, 0x83, 0xf8, 0xc6, 0xb9,
	0x9a, 0x46, 0x86, 0xb7, 0x87, 0x97, 0xf8, 0x2d, 0x98, 0x0d, 0xd4, 0x8e, 0x6e, 0xc1, 0xf5, 0x9d,
	0xea, 0x83, 0xed, 0x72, 0x69, 0x47, 0xae, 0xee, 0x57, 0xa4, 0x52, 0xbd, 0x2a, 0x05, 0xe2, 0xbf,
	0x69, 0x48, 0x96, 0xf6, 0x36, 0x0b, 0x82, 0xb3, 0x71, 0xf1, 0xf7, 0x05, 0x58, 0x0a, 0xbf, 0x15,
	0x4b, 0xd6, 0xba, 0x8e, 0x03, 0x08, 0xdc, 0xb7, 0x2a, 0x78, 0x0a, 0xd8, 0x65, 0xab, 0x36, 0x2c,
	0xfb, 0xbd, 0x85, 0x6c, 0xf6, 0x3a, 0x1d, 0xc5, 0x50, 0x9d, 0x63, 0xd3, 0x6f, 0xc6, 0xbf, 0x98,
	0x5b, 0xa3, 0xa4, 0x7d, 0xe9, 0x8a, 0x15, 0x02, 0x56, 0xb1, 0x29, 0xfe, 0xe6, 0x14, 0x2c, 0x86,
	0x92, 0x5c, 0xc6, 0x35, 0x43, 0x67, 0x6c, 0x25, 0xc6, 0x1e, 0x5b, 0x9f, 0x07, 0xbd, 0x2c, 0xef,
	0xf1, 0x73, 0x4d, 0xa8, 0x01, 0x56, 0xc3, 0xdd, 0x72, 0xea, 0x32, 0xdd, 0xf2, 0x23, 0x98, 0x0d,
	0xb8, 0x65, 0x9e, 0x2a, 0x1e, 0xd3, 0x25, 0xcf, 0xf8, 0x5d, 0x32, 0x7a, 0x0c, 0xd3, 0x6c, 0xb7,
	0xd4, 0x3e, 0x32, 0xf0, 0xed, 0xb1, 0xed, 0x61, 0xd5, 0xb6, 0x0b, 0x76, 0x35, 0xd2, 0xe6, 0x17,
	0x6e, 0xa8, 0xd3, 0xe1, 0x86, 0x5a, 0xfc, 0xbe, 0x00, 0x79, 0x1f, 0x1f, 0x77, 0xcb, 0x55, 0xf0,
	0x6c, 0xb9, 0xa2, 0x2f, 0x61, 0xd2, 0xb9, 0x19, 0x30, 0x13, 0x1d, 0xf0, 0x85, 0x0b, 0x1b, 0xd0,
	0x36, 0xad, 0xab, 0xac, 0x37, 0xb1, 0x44, 0xf9, 0xa2, 0x65, 0x98, 0x6e, 0xb2, 0x7d, 0x68, 0x7e,
	0xb5, 0xcc, 0xfe, 0x14, 0xbf, 0x84, 0xe5, 0x61, 0xb4, 0x64, 0xad, 0x57, 0x97, 0x4a, 0x7b, 0xb5,
	0xfb, 0x55, 0x69, 0x97, 0x66, 0xb2, 0x64, 0xa9, 0x52, 0x3b, 0xd8, 0xa9, 0xcb, 0xe5, 0xea, 0x66,
	0x48, 0xae, 0xac, 0x76, 0x50, 0x2e, 0x57, 0x6a, 0x35, 0x96, 0x68, 0xad, 0x48, 0x52, 0x55, 0x2a,
	0x24, 0xc4, 0xa7, 0x90, 0xae, 0x35, 0x8e, 0x71, 0xb3, 0xd7, 0xc6, 0xe8, 0x73, 0xb8, 0x66, 0xe0,
	0x46, 0xa3, 0x67, 0x18, 0xf4, 0x24, 0x4e, 0x17, 0x1b, 0xaa, 0xde, 0x94, 0xed, 0x47, 0x00, 0xf9,
	0x00, 0xba, 0x3a, 0xb0, 0x89, 0xbb, 0xc9, 0x11, 0x58, 0x86, 0xde, 0xa1, 0xdf, 0xa7, 0xe4, 0x76,
	0x21, 0x09, 0xb2, 0xd9, 0x95, 0x5b, 0xf1, 0x1f, 0x24, 0x60, 0x36, 0x78, 0xa7, 0xf4, 0x9c, 0xd7,
	0x25, 0x6f, 0x41, 0xb6, 0xe9, 0x5e, 0x1b, 0xe4, 0xba, 0xf3, 0x82, 0x82, 0xaf, 0x3f, 0x4d, 0x8e,
	0xf5, 0xfa, 0xd3, 0x7b, 0x90, 0xed, 0x75, 0xdd, 0xdd, 0xdb, 0xd4, 0x68, 0x62, 0x86, 0x4e, 0x89,
	0x07, 0xdf, 0x02, 0x98, 0xba, 0xd8, 0x5b, 0x00, 0xe2, 0x6f, 0x27, 0x00, 0x6d, 0x0e, 0xbc, 0xaa,
	0xf0, 0x47, 0x51, 0x77, 0xa1, 0x8f, 0xb6, 0x4c, 0x5d, 0xc6, 0xa3, 0x2d, 0xe2, 0x1f, 0x4c, 0x01,
	0x3c, 0xd4, 0x0f, 0xeb, 0x86, 0xda, 0x6a, 0x61, 0xe3, 0xf9, 0x29, 0xaf, 0x0a, 0x59, 0xbb, 0xfb,
	0x9f, 0xe8, 0x87, 0x5c, 0x79, 0x63, 0x5d, 0x93, 0x26, 0x53, 0xbc, 0xea, 0xc0, 0x48, 0xa8, 0x66,
	0x31, 0xa1, 0x6d, 0x27, 0x1f, 0x19, 0xaa, 0xb9, 0x6d, 0x5c, 0xe5, 0x7f, 0x25, 0x87, 0x1e, 0x6d,
	0xc2, 0x14, 0x36, 0x0c, 0xdd, 0xb0, 0x8f, 0xcd, 0xbc, 0x16, 0x93, 0x53, 0x85, 0x10, 0x49, 0x9c,
	0x36, 0x68, 0x1f, 0xd3, 0x17, 0xb1, 0x8f, 0xf4, 0x58, 0xf6, 0xf1, 0x01, 0xe4, 0xdb, 0x8a, 0x69,
	0xc9, 0x46, 0x4f, 0x63, 0xe4, 0x99, 0x91, 0xe4, 0x59, 0x42, 0x20, 0xf5, 0x34, 0x4a, 0x5f, 0x81,
	0x29, 0xf6, 0xc0, 0xe8, 0x32, 0x50, 0x8f, 0xfe, 0x7a, 0xcc, 0xf6, 0xd7, 0x28, 0x91, 0xc4, 0x89,
	0x8b, 0x9f, 0xc2, 0xb4, 0x6d, 0x47, 0x1b, 0x90, 0x36, 0xb9, 0x1f, 0x8d, 0x13, 0x69, 0xd8, 0x3e,
	0x77, 0x6b, 0x42, 0x72, 0xe8, 0x36, 0x32, 0x30, 0xcd, 0x7b, 0xa8, 0xf8, 0x14, 0x52, 0x54, 0xd7,
	0xe8, 0x35, 0x77, 0x66, 0x60, 0x6c, 0x91, 0xcd, 0xd6, 0xe8, 0x36, 0x6c, 0x79, 0x6c, 0x14, 0x74,
	0x8f, 0x9d, 0x99, 0xa1, 0x2d, 0xb6, 0x57, 0x4f, 0x91, 0x3a, 0x75, 0xb1, 0xc5, 0x2d, 0x98, 0x62,
	0xec, 0xd0, 0x12, 0xa0, 0x5a, 0xbd, 0x54, 0x3f, 0xa8, 0x0d, 0xce, 0x21, 0x5b, 0x95, 0xd2, 0x4e,
	0x7d, 0xeb, 0x71, 0x41, 0x40, 0x00, 0x53, 0xfb, 0xa5, 0x83, 0x5a, 0x65, 0xb3, 0x90, 0x40, 0x79,
	0xc8, 0x94, 0x4b, 0x7b, 0xe5, 0xca, 0xce, 0x4e, 0x65, 0xb3, 0x90, 0xdc, 0x48, 0x41, 0xf2, 0x89,
	0x7e, 0x28, 0xfe, 0x4e, 0x02, 0xa6, 0xd8, 0x9d, 0x61, 0xf4, 0x08, 0xf2, 0xa6, 0xf2, 0x0c, 0xcb,
	0x9e, 0x77, 0x0e, 0x47, 0xa6, 0xd8, 0x18, 0xe9, 0x6a, 0x4d, 0x79, 0x86, 0xed, 0xb7, 0x29, 0xb7,
	0x26, 0xa4, 0x9c, 0xe9, 0xf9, 0x46, 0xbb, 0x30, 0xdd, 0xed, 0x1d, 0xca, 0x66, 0xef, 0x30, 0xce,
	0x83, 0x2f, 0x9c, 0xe3, 0x7e, 0xef, 0xb0, 0xad, 0x9a, 0xc7, 0x75, 0x7d, 0xbf, 0x77, 0x58, 0xeb,
	0x1d, 0x6e, 0x4d, 0x48, 0x53, 0x5d, 0xfa, 0xab, 0xd8, 0x84, 0x9c, 0xb7, 0x3a, 0x54, 0x77, 0x9e,
	0xee, 0xf0, 0x1d, 0x96, 0x58, 0x1b, 0xf3, 0xe9, 0x0e, 0xfb, 0xb5, 0x0e, 0x7e, 0xbd, 0xf5, 0xeb,
	0x30, 0x1b, 0x10, 0x81, 0x44, 0x1d, 0x96, 0xde, 0xe5, 0x17, 0xa6, 0x32, 0x12, 0xfb, 0x20, 0x53,
	0x26, 0xbb, 0x6b, 0x2d, 0xfe, 0x6d, 0x01, 0xae, 0x97, 0xe9, 0xd8, 0x09, 0xbe, 0xd2, 0x30, 0xe2,
	0x12, 0xfc, 0x23, 0x28, 0x0c, 0xbc, 0x05, 0x91, 0x18, 0xff, 0x2d, 0x88, 0xd9, 0xc0, 0x4b, 0x31,
	0xe8, 0x26, 0x64, 0x9d, 0x17, 0x65, 0x9c, 0xfb, 0xf0, 0x60, 0x83, 0xb6, 0x9b, 0xe2, 0x3f, 0x11,
	0xe0, 0xfa, 0x01, 0x1d, 0xb0, 0x43, 0x24, 0x0e, 0x73, 0xbc, 0xcf, 0x4b, 0x5a, 0xd7, 0xd7, 0xd0,
	0x8d, 0xb7, 0xe4, 0x10, 0x67, 0x41, 0xe3, 0xe2, 0x5d, 0xc5, 0x3c, 0xb1, 0x7d, 0x0d, 0xf9, 0x2d,
	0xae, 0xc1, 0xd5, 0x07, 0xd8, 0x8a, 0xdf, 0x0a, 0xf1, 0x29, 0x5c, 0x63, 0x4f, 0x23, 0xf8, 0x28,
	0xcc, 0x51, 0x5d, 0x75, 0x03, 0xa0, 0x4b, 0xdf, 0xc7, 0xd3, 0x4f, 0xf8, 0x8b, 0x6b, 0x19, 0x29,
	0x43, 0x20, 0x75, 0x02, 0x40, 0xd7, 0x80, 0x7e, 0xb8, 0x1b, 0x5e, 0x29, 0x29, 0x4d, 0x00, 0x74,
	0xbb, 0xeb, 0x57, 0x04, 0xb8, 0x1e, 0x5e, 0x27, 0x7f, 0x95, 0xe1, 0x53, 0x98, 0x0b, 0x6a, 0xd6,
	0x5e, 0x5b, 0x8f, 0xa5, 0xda, 0x42, 0x40, 0xb5, 0x26, 0xba, 0x0d, 0xb3, 0x1a, 0x3e, 0xb3, 0xe4,
	0x01, 0xd9, 0xf3, 0x04, 0xbc, 0x6f, 0xcb, 0x2f, 0xae, 0xc3, 0xf5, 0x4d, 0xdc, 0xc6, 0xe3, 0xd8,
	0x83, 0xf8, 0xd7, 0x04, 0xb8, 0xc2, 0xcc, 0xde, 0xf5, 0xc1, 0xa3, 0xd4, 0xf8, 0x00, 0xb2, 0x4f,
	0xf4, 0x43, 0x99, 0x3b, 0x52, 0x6e, 0x3e, 0xb7, 0xe3, 0xf9, 0x77, 0x09, 0x9e, 0xb8, 0x91, 0xc1,
	0x0d, 0x00, 0xce, 0xc4, 0xb5, 0xf0, 0x0c, 0x87, 0x6c, 0x37, 0xc9, 0x5a, 0xf9, 0x0a, 0x33, 0xf0,
	0x41, 0xd9, 0xc2, 0x6c, 0xfb, 0xd2, 0xe4, 0xba, 0x90, 0x31, 0xaf, 0xc0, 0xc2, 0x03, 0x6c, 0xc5,
	0x92, 0x58, 0xfc, 0xf3, 0x02, 0x2c, 0x11, 0xa3, 0x72, 0xb1, 0x9f, 0xa7, 0x0d, 0xa3, 0xab, 0x90,
	0xa6, 0x5b, 0xde, 0xf2, 0x61, 0x9f, 0xbf, 0x4f, 0x35, 0x4d, 0xbf, 0x37, 0xfa, 0xe2, 0x5f, 0x14,
	0xe0, 0xca, 0x80, 0x24, 0xdc, 0xb2, 0xb7, 0x21, 0xe7, 0xd1, 0xab, 0x6d, 0xd4, 0x71, 0x15, 0x9b,
	0x75, 0x15, 0x1b, 0xdf, 0x94, 0x5f, 0x87, 0x2b, 0xcc, 0x94, 0xe3, 0xe9, 0xf1, 0xff, 0x24, 0xa0,
	0x10, 0x8c, 0xed, 0xc8, 0xea, 0x80, 0x3f, 0xbe, 0xee, 0x9f, 0x5b, 0x22, 0x57, 0x07, 0xfe, 0x59,
	0x25, 0x6f, 0xfa, 0x9e, 0xaa, 0x1a, 0x98, 0xac, 0x12, 0x97, 0x30, 0x59, 0x3d, 0x87, 0xb7, 0xea,
	0xce, 0xf1, 0x28, 0x99, 0xf7, 0xa1, 0x92, 0xd4, 0xf8, 0x0f, 0x95, 0xfc, 0x5e, 0x0a, 0xa6, 0x36,
	0xdb, 0x5d, 0x12, 0x44, 0x87, 0x8d, 0xcc, 0x7b, 0xfc, 0x81, 0xeb, 0x18, 0x4f, 0xb5, 0x33, 0x2e,
	0x34, 0x45, 0xc4, 0x1e, 0xc2, 0x2e, 0xd1, 0x37, 0x5e, 0x2d, 0xcc, 0x93, 0xa7, 0xaf, 0x8e, 0x26,
	0x26, 0xd6, 0x47, 0xe2, 0x2c, 0x2c, 0x31, 0x4a, 0xf4, 0xc7, 0x20, 0x67, 0xa8, 0xe6, 0x89, 0x6c,
	0x87, 0x79, 0x6c, 0xa5, 0xf0, 0xcd, 0xf3, 0x1e, 0x64, 0xdf, 0x9a, 0x90, 0xb2, 0x86, 0xe7, 0x7a,
	0xb6, 0x0c, 0xf6, 0x74, 0xe8, 0xd4, 0x10, 0xe3, 0x64, 0xe1, 0xb0, 0x97, 0xa8, 0xb6, 0x26, 0x24,
	0xdb, 0x1e, 0xec, 0x0a, 0x2e, 0xf4, 0xbe, 0xf2, 0xbb, 0x00, 0xf4, 0x59, 0xdc, 0xb8, 0x2b, 0x88,
	0x0c, 0xc5, 0xa6, 0xa4, 0x77, 0x21, 0x8d, 0xb5, 0x66, 0xdc, 0xd5, 0xc3, 0x34, 0xd6, 0x9a, 0x94,
	0xec, 0x1d, 0xc8, 0xd3, 0xe5, 0x8b, 0x6c, 0x27, 0xa0, 0x32, 0xd4, 0xa0, 0xc2, 0xc2, 0xea, 0x1c,
	0x45, 0x94, 0x78, 0x62, 0xe9, 0x0e, 0x14, 0x3c, 0x8e, 0x86, 0x99, 0x2c, 0x50, 0x33, 0x9a, 0x71,
	0x9d, 0x08, 0xdd, 0x3e, 0x6d, 0x40, 0xda, 0xee, 0x64, 0x74, 0x15, 0x16, 0x1f, 0x56, 0x37, 0x64,
	0x12, 0x4f, 0x87, 0xa4, 0x64, 0xf6, 0x2b, 0x7b, 0x9b, 0xdb, 0x7b, 0x0f, 0x0a, 0x02, 0xf9, 0x90,
	0x0e, 0xf6, 0xf6, 0xc8, 0x47, 0x02, 0xa5, 0x61, 0x72, 0xb3, 0xba, 0x57, 0x29, 0x24, 0x51, 0x0e,
	0xd2, 0x2c, 0xb2, 0xae, 0x6c, 0x16, 0x26, 0x49, 0xcc, 0x7d, 0xbf, 0xb4, 0x4d, 0x7e, 0xa7, 0xc8,
	0x62, 0xc1, 0xce, 0x11, 0xdd, 0x86, 0xc2, 0x03, 0x6c, 0x31, 0xf3, 0x8a, 0x72, 0x44, 0x3f, 0x14,
	0x00, 0x11, 0x37, 0xca, 0x30, 0x43, 0x9c, 0xf9, 0xa4, 0xcf, 0x99, 0xbb, 0x4f, 0x3f, 0x09, 0xde,
	0xa7, 0x9f, 0xfc, 0x5e, 0x3c, 0x11, 0xf0, 0xe2, 0xfe, 0x19, 0x20, 0x19, 0x9c, 0x01, 0xec, 0xb1,
	0x96, 0x1a, 0x7f, 0xac, 0x89, 0x3d, 0x98, 0xf7, 0x49, 0xcf, 0x27, 0x80, 0x6f, 0xc0, 0xe4, 0x13,
	0xfd, 0xd0, 0x76, 0xfc, 0xe2, 0x68, 0x96, 0x12, 0xc5, 0x8f, 0xed, 0xed, 0x5f, 0x81, 0xf9, 0xb2,
	0xa2, 0x35, 0x70, 0x7b, 0xb4, 0x82, 0x5f, 0x81, 0x79, 0x36, 0x31, 0x8c, 0x46, 0xfd, 0x2d, 0x01,
	0x6e, 0xb2, 0xd0, 0x66, 0x30, 0xa3, 0x33, 0x6a, 0x96, 0x95, 0x61, 0x3e, 0xe4, 0xd1, 0xd6, 0x38,
	0x07, 0x21, 0x42, 0xea, 0x42, 0x83, 0xef, 0xbb, 0x8e, 0x8e, 0xee, 0x7f, 0x57, 0x80, 0x9b, 0x2c,
	0xf8, 0x19, 0x2e, 0x7d, 0x98, 0xab, 0x7d, 0xee, 0x92, 0x5f, 0x28, 0x38, 0x5a, 0x87, 0xeb, 0x64,
	0x1c, 0x8d, 0xd3, 0x22, 0xd1, 0x82, 0x17, 0xa8, 0x51, 0x0e, 0x10, 0x3d, 0xd7, 0x78, 0xff, 0x37,
	0x04, 0xb8, 0x39, 0xb4, 0x5a, 0x3e, 0x2e, 0x14, 0x58, 0x08, 0xd1, 0xb5, 0x3d, 0x4e, 0xc6, 0x55,
	0xf6, 0xfc, 0xa0, 0xb2, 0xe3, 0x0f, 0xa1, 0xbb, 0x70, 0x93, 0x8f, 0x8b, 0x71, 0x74, 0xbb, 0xb2,
	0xef, 0x3e, 0xad, 0xe7, 0x79, 0xdc, 0x8e, 0xb8, 0xd4, 0xca, 0xde, 0xc1, 0xae, 0x5c, 0x7f, 0xbc,
	0x1f, 0xe2, 0x52, 0xb7, 0x29, 0xa0, 0x5e, 0x10, 0xd0, 0x1c, 0xe4, 0xa5, 0xed, 0xda, 0x47, 0x72,
	0x69, 0xaf, 0xb4, 0xf3, 0xb8, 0xb6, 0x5d, 0x2b, 0x24, 0x56, 0x7e, 0x4b, 0x00, 0x34, 0xb8, 0x87,
	0x89, 0x5e, 0x82, 0x9b, 0x52, 0x65, 0x87, 0xa6, 0xd0, 0x87, 0xef, 0x96, 0xe5, 0x20, 0x5d, 0xf9,
	0xf8, 0xa0, 0xb4, 0x23, 0xd7, 0xab, 0x05, 0x01, 0x15, 0x20, 0xb7, 0x57, 0xad, 0xcb, 0x0e, 0x84,
	0x1e, 0x59, 0x7e, 0x20, 0x55, 0x4a, 0xf5, 0x8a, 0x24, 0xd7, 0xb7, 0x4a, 0x7b, 0x85, 0x24, 0xca,
	0x43, 0x66, 0xa7, 0x52, 0xab, 0xb1, 0xcf, 0x49, 0x54, 0x84, 0x25, 0x2f, 0x82, 0x5c, 0x95, 0x18,
	0x79, 0xad, 0x90, 0x42, 0x57, 0x60, 0xde, 0x41, 0xf5, 0x14, 0x4c, 0x11, 0x97, 0x5f, 0xf9, 0x74,
	0xbb, 0x56, 0xaf, 0x15, 0xa6, 0x57, 0x24, 0x00, 0xd7, 0x29, 0xa2, 0xeb, 0xb0, 0xbc, 0xb9, 0xb3,
	0x2f, 0x93, 0xd9, 0x25, 0x44, 0x13, 0xb3, 0x90, 0xe5, 0x9a, 0x20, 0x18, 0x05, 0x01, 0x2d, 0xc2,
	0x9c, 0x4f, 0x1b, 0x14, 0x9c, 0x58, 0xff, 0x97, 0x5f, 0xa7, 0x4c, 0x6b, 0xd8, 0x78, 0xa6, 0x36,
	0x30, 0xfa, 0x3b, 0x02, 0xcc, 0xf8, 0x9f, 0x7f, 0x45, 0x6f, 0xc6, 0x8b, 0xf4, 0x3c, 0xcf, 0xe3,
	0x16, 0xd7, 0xc7, 0x21, 0x61, 0xe6, 0x2a, 0xbe, 0xf3, 0x67, 0x7e, 0xf7, 0xdf, 0xfd, 0x72, 0xe2,
	0x4d, 0xf1, 0x35, 0xe7, 0x9f, 0x13, 0xfd, 0x14, 0x1b, 0x28, 0xef, 0x77, 0x0d, 0xfd, 0x09, 0x6e,
	0x58, 0xe6, 0xda, 0xca, 0x4f, 0xaf, 0x35, 0x18, 0xd5, 0x3d, 0x1e, 0x83, 0xdc, 0x13, 0x56, 0xd0,
	0x0f, 0x04, 0xc8, 0x7a, 0xde, 0x1e, 0x47, 0xab, 0xe3, 0xbd, 0x04, 0x5f, 0x5c, 0x8b, 0x8d, 0xcf,
	0x25, 0x7d, 0x9b, 0x4a, 0xba, 0x2a, 0xbe, 0x12, 0x29, 0x29, 0x7d, 0xee, 0xfc, 0x1e, 0xbb, 0xd2,
	0x42, 0xc4, 0xfc, 0xa1, 0x00, 0x73, 0x03, 0xef, 0x65, 0xa3, 0xb7, 0x63, 0x67, 0xb3, 0xbd, 0xfa,
	0xbd, 0x3b, 0x26, 0x15, 0x17, 0xfc, 0x1e, 0x15, 0xfc, 0x6d, 0x71, 0x2d, 0x96, 0x8a, 0xdd, 0x01,
	0x6f, 0x8b, 0x2f, 0x8d, 0x27, 0xbe, 0x74, 0x2e, 0xf1, 0xa5, 0x4b, 0x12, 0xdf, 0xf0, 0x89, 0xff,
	0x37, 0x05, 0x98, 0x1b, 0x88, 0x69, 0xd1, 0x78, 0x21, 0xb0, 0x2d, 0x7e, 0x8c, 0x10, 0x23, 0xa6,
	0xac, 0x4d, 0x87, 0xb7, 0xd7, 0xa0, 0xff, 0xae, 0x00, 0x8b, 0xa1, 0x11, 0x3e, 0x1a, 0x7f, 0x51,
	0xf0, 0x5c, 0x65, 0x56, 0x58, 0x8d, 0x44, 0xe6, 0x5f, 0x14, 0x20, 0xef, 0x7b, 0x0f, 0x14, 0xbd,
	0x11, 0xfd, 0xcf, 0x5e, 0x06, 0xdf, 0x23, 0x2d, 0xbe, 0x39, 0x06, 0x05, 0x37, 0x89, 0x22, 0x15,
	0x79, 0x01, 0x21, 0x47, 0x64, 0xf7, 0x64, 0xdb, 0x7f, 0x17, 0x60, 0x31, 0x34, 0x67, 0x1a, 0xad,
	0xc6, 0xa8, 0x34, 0x6b, 0x71, 0x9c, 0x5c, 0x99, 0xf8, 0x94, 0x0a, 0x77, 0x22, 0xae, 0x0f, 0xe8,
	0x53, 0x37, 0x5a, 0x8a, 0xa6, 0x7e, 0xc5, 0x36, 0xd9, 0xa9, 0xb3, 0x08, 0x64, 0xd5, 0xee, 0x09,
	0x2b, 0x9f, 0xad, 0x8b, 0xaf, 0x47, 0x3b, 0x98, 0x41, 0x1a, 0xda, 0xe6, 0xd0, 0xac, 0x6b, 0x74,
	0x9b, 0xa3, 0x12, 0xb5, 0xe7, 0x6a, 0xf3, 0xba, 0xa7, 0xcd, 0x64, 0x2a, 0x0f, 0xb6, 0x78, 0x40,
	0xf8, 0xb5, 0x95, 0x9f, 0xa6, 0x6d, 0x5e, 0x7f, 0x3d, 0x40, 0xe8, 0xb6, 0x78, 0x08, 0x0d, 0xfa,
	0xf7, 0x02, 0xa0, 0xc1, 0x04, 0x2d, 0x8a, 0x74, 0x32, 0x43, 0x13, 0xba, 0xe3, 0xb5, 0xf6, 0x84,
	0xb6, 0x16, 0xa3, 0x73, 0xb4, 0xf6, 0xb3, 0x35, 0x34, 0x5e, 0x53, 0xd1, 0x4f, 0x04, 0xfb, 0x1d,
	0xdf, 0x40, 0x06, 0xf6, 0x9d, 0xd1, 0xe3, 0x26, 0x34, 0x13, 0x5d, 0xfc, 0xe6, 0xf8, 0x84, 0x7c,
	0xdc, 0x85, 0x34, 0x3c, 0xae, 0x69, 0xfb, 0x1b, 0x1e, 0xc3, 0xae, 0xd1, 0x8f, 0x05, 0x58, 0x0c,
	0x4d, 0x1d, 0x47, 0x1b, 0x75, 0x54, 0xb6, 0xb9, 0x38, 0xe4, 0x4d, 0x42, 0xbb, 0x61, 0x2b, 0xe7,
	0xea, 0xd1, 0x95, 0x31, 0x7b, 0xf4, 0x67, 0x12, 0xb0, 0x3c, 0x6c, 0x0d, 0x88, 0xde, 0x1b, 0xed,
	0xa4, 0x86, 0x46, 0xd3, 0xc5, 0x31, 0xa3, 0x7b, 0xf1, 0x94, 0x36, 0xfb, 0xa9, 0x78, 0x77, 0x74,
	0x7f, 0x86, 0xac, 0x03, 0xc8, 0xc8, 0xbd, 0x2b, 0xbe, 0x11, 0x3d, 0x6d, 0x84, 0x92, 0x51, 0x15,
	0x0c, 0x5b, 0x48, 0x46, 0xab, 0x60, 0xc4, 0xf2, 0xf3, 0xbc, 0x2a, 0x58, 0xbf, 0x3b, 0xa2, 0xe7,
	0x43, 0x1a, 0xc2, 0x9d, 0xd7, 0xdd, 0xf5, 0x37, 0x86, 0xf7, 0xff, 0x50, 0x32, 0xf4, 0x3f, 0x05,
	0x58, 0x0c, 0x5d, 0x76, 0x46, 0x9b, 0x77, 0xd4, 0x4a, 0x75, 0xec, 0xc6, 0x73, 0xb7, 0x8d, 0xce,
	0xd7, 0xf8, 0xcf, 0xd6, 0xd1, 0xd8, 0x2d, 0x47, 0x3f, 0x9b, 0x60, 0x39, 0xfd, 0x90, 0x25, 0x2c,
	0xba, 0x37, 0xca, 0x31, 0x0d, 0x5f, 0x6e, 0x17, 0xdf, 0x3b, 0x17, 0x2d, 0xf7, 0x6b, 0x21, 0x7a,
	0x18, 0x63, 0x1c, 0xf8, 0xf5, 0x10, 0x6f, 0x10, 0xa0, 0xdf, 0x17, 0x60, 0x79, 0xd8, 0xe2, 0x38,
	0x7a, 0x04, 0x8c, 0x58, 0x52, 0x0f, 0xf5, 0x71, 0xbc, 0x91, 0x2b, 0xe7, 0xed, 0xec, 0x95, 0xf1,
	0x3b, 0xfb, 0x07, 0x02, 0x14, 0x82, 0x1b, 0x79, 0xe8, 0xad, 0xd1, 0x1e, 0x6e, 0x60, 0x83, 0xa5,
	0x18, 0x73, 0x63, 0x47, 0x7c, 0x8b, 0x36, 0xf2, 0x75, 0xf1, 0x4e, 0x64, 0x87, 0x78, 0x76, 0x7f,
	0xf8, 0x52, 0xb2, 0x10, 0xdc, 0xd3, 0x8b, 0x16, 0x73, 0xc8, 0x0e, 0xe0, 0xb8, 0x62, 0xae, 0xdf,
	0x19, 0xae, 0x52, 0x8f, 0x8c, 0xdc, 0x63, 0x7c, 0x4f, 0x80, 0xbc, 0x6f, 0x17, 0x2f, 0x3a, 0xd8,
	0x0e, 0xdb, 0xf0, 0x8b, 0x2d, 0xe0, 0x1b, 0x54, 0xc0, 0x15, 0x14, 0x5b, 0x40, 0xf4, 0x1b, 0x02,
	0xcc, 0x06, 0x36, 0xeb, 0xd0, 0xfa, 0xa8, 0x41, 0x39, 0xb8, 0xc7, 0x58, 0x7c, 0x6b, 0x2c, 0x1a,
	0x3e, 0x80, 0x43, 0xc4, 0x8d, 0xee, 0x76, 0xf4, 0x4b, 0x02, 0x14, 0x82, 0xbb, 0x79, 0xd1, 0x7d,
	0x3e, 0x64, 0xef, 0x6f, 0xe8, 0x78, 0xe3, 0x32, 0xad, 0xc4, 0x57, 0xe1, 0x5f, 0x17, 0x20, 0xeb,
	0x49, 0x75, 0x47, 0xa7, 0x34, 0x06, 0x33, 0xfa, 0xd1, 0x29, 0x8d, 0x90, 0x1c, 0xba, 0xf8, 0x1a,
	0x15, 0xf1, 0x36, 0xfa, 0x5a, 0xb4, 0xfb, 0xe2, 0xe2, 0xfc, 0x82, 0x00, 0x19, 0x67, 0xc3, 0x01,
	0xbd, 0x36, 0x6a, 0x96, 0xf2, 0xe6, 0xc2, 0x63, 0x2d, 0x44, 0x43, 0xa4, 0x19, 0xf0, 0x33, 0x4c,
	0x14, 0x3a, 0x91, 0x08, 0x90, 0xf3, 0x66, 0xdd, 0xd1, 0x5a, 0x0c, 0xa7, 0xe9, 0x93, 0x69, 0x58,
	0xc7, 0x71, 0x39, 0x56, 0xe2, 0xc9, 0xf1, 0x97, 0x05, 0xc8, 0x79, 0x37, 0x0a, 0xa2, 0xe5, 0x08,
	0xd9, 0x52, 0x18, 0x2a, 0xc7, 0x37, 0xa8, 0x1c, 0x6f, 0x88, 0xaf, 0xc6, 0x91, 0xe3, 0x5e, 0x83,
	0x72, 0xbe, 0x27, 0xac, 0x6c, 0xfc, 0xaa, 0x00, 0x2f, 0x34, 0xf4, 0x4e, 0x84, 0x18, 0x1b, 0xe9,
	0xcd, 0x76, 0x77, 0x9f, 0xd4, 0xb6, 0x2f, 0x7c, 0xf6, 0x3e, 0xc7, 0x6b, 0xe9, 0x6d, 0x45, 0x6b,
	0xad, 0xea, 0x46, 0x6b, 0xad, 0x85, 0x35, 0x2a, 0xcb, 0x1a, 0x2b, 0x52, 0xba, 0xaa, 0x19, 0xf6,
	0x7f, 0xc4, 0xdf, 0x6b, 0xb6, 0xbb, 0xbf, 0x9e, 0x58, 0x7e, 0xc0, 0xe8, 0xcb, 0x6d, 0xbd, 0xd7,
	0x24, 0x7d, 0xb9, 0xfa, 0x68, 0x7d, 0x83, 0x14, 0xff, 0x53, 0xbb, 0xe8, 0x0b, 0x5a, 0xf4, 0xc5,
	0x66, 0xbb, 0xfb, 0xc5, 0x23, 0x46, 0x79, 0x38, 0x45, 0xf9, 0xbf, 0xf5, 0x7f, 0x03, 0x00, 0x00,
	0xff, 0xff, 0x25, 0x3f, 0xe2, 0xc3, 0x06, 0x7d, 0x00, 0x00,
}
