/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.features;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.Feature;
import java.util.Collections;
import java.util.Set;

@GwtCompatible
public final class TesterRequirements {
    private final Set<Feature<?>> presentFeatures;
    private final Set<Feature<?>> absentFeatures;
    private static final long serialVersionUID = 0L;

    public TesterRequirements(Set<Feature<?>> presentFeatures, Set<Feature<?>> absentFeatures) {
        this.presentFeatures = Helpers.copyToSet(presentFeatures);
        this.absentFeatures = Helpers.copyToSet(absentFeatures);
    }

    public TesterRequirements(TesterRequirements tr) {
        this(tr.getPresentFeatures(), tr.getAbsentFeatures());
    }

    public TesterRequirements() {
        this(Collections.emptySet(), Collections.emptySet());
    }

    public final Set<Feature<?>> getPresentFeatures() {
        return this.presentFeatures;
    }

    public final Set<Feature<?>> getAbsentFeatures() {
        return this.absentFeatures;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof TesterRequirements) {
            TesterRequirements that = (TesterRequirements)object;
            return ((Object)this.presentFeatures).equals(that.presentFeatures) && ((Object)this.absentFeatures).equals(that.absentFeatures);
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.presentFeatures).hashCode() * 31 + ((Object)this.absentFeatures).hashCode();
    }

    public String toString() {
        return "{TesterRequirements: present=" + this.presentFeatures + ", absent=" + this.absentFeatures + "}";
    }
}

