/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *
 */

#ifndef CActionClassDoc_h_
#define CActionClassDoc_h_


#include "Doc/SchemaTypesDoc/CCollectMethodDoc.h"
#include "Doc/SchemaTypesDoc/CMethodDoc.h"

namespace Caf {

/// Definition of an action class that may be generated by the provider
class SCHEMATYPESDOC_LINKAGE CActionClassDoc {
public:
	CActionClassDoc();
	virtual ~CActionClassDoc();

public:
	/// Initializes the object with everything required by this
	/// container. Once initialized, this object cannot
	/// be changed (i.e. it is immutable).
	void initialize(
		const std::string namespaceVal,
		const std::string name,
		const std::string version,
		const SmartPtrCCollectMethodDoc collectMethod,
		const std::deque<SmartPtrCMethodDoc> methodCollection,
		const std::string displayName = std::string(),
		const std::string description = std::string());

public:
	/// Accessor for the NamespaceVal
	std::string getNamespaceVal() const;

	/// Accessor for the Name
	std::string getName() const;

	/// Accessor for the Version
	std::string getVersion() const;

	/// Accessor for the CollectMethod
	SmartPtrCCollectMethodDoc getCollectMethod() const;

	/// Accessor for the Method
	std::deque<SmartPtrCMethodDoc> getMethodCollection() const;

	/// A hint as to what this class should be called when displaying it to a human
	std::string getDisplayName() const;

	/// A phrase to describe the class for mouse-over text, etc
	std::string getDescription() const;

private:
	bool _isInitialized;

	std::string _namespaceVal;
	std::string _name;
	std::string _version;
	SmartPtrCCollectMethodDoc _collectMethod;
	std::deque<SmartPtrCMethodDoc> _methodCollection;
	std::string _displayName;
	std::string _description;

private:
	CAF_CM_DECLARE_NOCOPY(CActionClassDoc);
};

CAF_DECLARE_SMART_POINTER(CActionClassDoc);

}

#endif
