/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/DocXml/CafCoreTypesXml/ClassSpecifierXml.h"

#include "Doc/CafCoreTypesDoc/CClassSpecifierDoc.h"
#include "Doc/CafCoreTypesDoc/COperationDoc.h"
#include "Doc/MgmtTypesDoc/CMgmtInvokeOperationDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/MgmtTypesXml/MgmtInvokeOperationXml.h"
#include "Doc/DocXml/CafCoreTypesXml/OperationXml.h"

using namespace Caf;

void MgmtInvokeOperationXml::add(
	const SmartPtrCMgmtInvokeOperationDoc mgmtInvokeOperationDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("MgmtInvokeOperationXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(mgmtInvokeOperationDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string jobIdVal =
			BasePlatform::UuidToString(mgmtInvokeOperationDoc->getJobId());
		CAF_CM_VALIDATE_STRING(jobIdVal);
		thisXml->addAttribute("jobId", jobIdVal);

		const SmartPtrCClassSpecifierDoc classSpecifierVal =
			mgmtInvokeOperationDoc->getClassSpecifier();
		CAF_CM_VALIDATE_SMARTPTR(classSpecifierVal);

		const SmartPtrCXmlElement classSpecifierXml =
			thisXml->createAndAddElement("classSpecifier");
		ClassSpecifierXml::add(classSpecifierVal, classSpecifierXml);

		const SmartPtrCOperationDoc operationVal =
			mgmtInvokeOperationDoc->getOperation();
		CAF_CM_VALIDATE_SMARTPTR(operationVal);

		const SmartPtrCXmlElement operationXml =
			thisXml->createAndAddElement("operation");
		OperationXml::add(operationVal, operationXml);
	}
	CAF_CM_EXIT;
}

SmartPtrCMgmtInvokeOperationDoc MgmtInvokeOperationXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("MgmtInvokeOperationXml", "parse");

	SmartPtrCMgmtInvokeOperationDoc mgmtInvokeOperationDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string jobIdStrVal =
			thisXml->findRequiredAttribute("jobId");
		UUID jobIdVal = CAFCOMMON_GUID_NULL;
		if (! jobIdStrVal.empty()) {
			BasePlatform::UuidFromString(jobIdStrVal.c_str(), jobIdVal);
		}

		const SmartPtrCXmlElement classSpecifierXml =
			thisXml->findRequiredChild("classSpecifier");

		SmartPtrCClassSpecifierDoc classSpecifierVal;
		if (! classSpecifierXml.IsNull()) {
			classSpecifierVal = ClassSpecifierXml::parse(classSpecifierXml);
		}

		const SmartPtrCXmlElement operationXml =
			thisXml->findRequiredChild("operation");

		SmartPtrCOperationDoc operationVal;
		if (! operationXml.IsNull()) {
			operationVal = OperationXml::parse(operationXml);
		}

		mgmtInvokeOperationDoc.CreateInstance();
		mgmtInvokeOperationDoc->initialize(
			jobIdVal,
			classSpecifierVal,
			operationVal);
	}
	CAF_CM_EXIT;

	return mgmtInvokeOperationDoc;
}

