/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/DocUtils/EnumConvertersXml.h"
#include "Doc/DocXml/SchemaTypesXml/ClassFieldXml.h"
#include "Doc/SchemaTypesDoc/SchemaTypesDocTypes.h"

#include "Doc/SchemaTypesDoc/CClassFieldDoc.h"
#include "Doc/SchemaTypesDoc/CJoinTypeDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/SchemaTypesXml/JoinTypeXml.h"

using namespace Caf;

void JoinTypeXml::add(
	const SmartPtrCJoinTypeDoc joinTypeDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("JoinTypeXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(joinTypeDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string operandVal =
			EnumConvertersXml::convertOperatorTypeToString(joinTypeDoc->getOperand());
		CAF_CM_VALIDATE_STRING(operandVal);
		thisXml->addAttribute("operand", operandVal);

		const SmartPtrCClassFieldDoc dataClassLeftVal =
			joinTypeDoc->getDataClassLeft();
		CAF_CM_VALIDATE_SMARTPTR(dataClassLeftVal);

		const SmartPtrCXmlElement dataClassLeftXml =
			thisXml->createAndAddElement("dataClassLeft");
		ClassFieldXml::add(dataClassLeftVal, dataClassLeftXml);

		const SmartPtrCClassFieldDoc dataClassRightVal =
			joinTypeDoc->getDataClassRight();
		CAF_CM_VALIDATE_SMARTPTR(dataClassRightVal);

		const SmartPtrCXmlElement dataClassRightXml =
			thisXml->createAndAddElement("dataClassRight");
		ClassFieldXml::add(dataClassRightVal, dataClassRightXml);

		const std::string descriptionVal = joinTypeDoc->getDescription();
		if (! descriptionVal.empty()) {
			thisXml->addAttribute("description", descriptionVal);
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCJoinTypeDoc JoinTypeXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("JoinTypeXml", "parse");

	SmartPtrCJoinTypeDoc joinTypeDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string operandStrVal =
			thisXml->findRequiredAttribute("operand");
		OPERATOR_TYPE operandVal = OPERATOR_NONE;
		if (! operandStrVal.empty()) {
			operandVal = EnumConvertersXml::convertStringToOperatorType(operandStrVal);
		}

		const SmartPtrCXmlElement dataClassLeftXml =
			thisXml->findRequiredChild("dataClassLeft");

		SmartPtrCClassFieldDoc dataClassLeftVal;
		if (! dataClassLeftXml.IsNull()) {
			dataClassLeftVal = ClassFieldXml::parse(dataClassLeftXml);
		}

		const SmartPtrCXmlElement dataClassRightXml =
			thisXml->findRequiredChild("dataClassRight");

		SmartPtrCClassFieldDoc dataClassRightVal;
		if (! dataClassRightXml.IsNull()) {
			dataClassRightVal = ClassFieldXml::parse(dataClassRightXml);
		}

		const std::string descriptionStrVal =
			thisXml->findOptionalAttribute("description");
		const std::string descriptionVal = descriptionStrVal;

		joinTypeDoc.CreateInstance();
		joinTypeDoc->initialize(
			operandVal,
			dataClassLeftVal,
			dataClassRightVal,
			descriptionVal);
	}
	CAF_CM_EXIT;

	return joinTypeDoc;
}

