#!/usr/bin/python
# GPL. (C) 2007 Paolo Patruno.

# ToDo:
# controllare gli inserimenti al livello di django ADMIN INTERFACE
# controllare altri conflitti in districa oltre ai jingles
# utilizzare mp3splt sper spezzare i programmi per fare gli inserimenti pubblicitari
# alternare meglio i jingle tenendo in considerazione la priorita
# a cavallo della mezzanotte verificare il funzionamento

####
amarok=True
#playlistdir="playlist"
playlistdir="spots"

logfile='/tmp/autoradio.log'
lockfile = "/tmp/autoradio.lock"
timestampfile = "/tmp/autoradio.timestamp"
BASE_PATH="/home/autoradio"
dir=(BASE_PATH+"/autoradio",)

####

import logging,os,sys,errno,signal,time
from datetime import *

logging.basicConfig(
    level=logging.DEBUG,
    format='%(asctime)s %(levelname)s %(message)s',
    filename=logfile,
    filemode='a'
)

#def myhandler(x): print x
#logi=logging.getLoggerClass()
#logi.handleError=myhandler


logging.debug('Starting up')

f = open(timestampfile, "w")
f.write(str(datetime.now()))
f.close()

def custom_path(dir):
    # Switch to the directory of your project.

    logging.debug("cd in %s",str(dir[0]))
    os.chdir(dir[0])

    # Add a custom Python path, you'll want to add the parent folder of
    # your project directory. (Optional.)
    for directory in dir:
            sys.path.insert(0, directory)

custom_path(dir)



# Set the DJANGO_SETTINGS_MODULE environment variable.
os.environ['DJANGO_SETTINGS_MODULE'] = "settings"

from gest_program import *
from gest_spot import *
from gest_jingle import *
from gest_playlist import *

if (amarok) :
    from manageamarok import *
else:
    from managepytone import *

from time import *

#intervatto di tempo in avanti e indietro per testare eventuali conflitti
minelab=120

#tempo di tolleranza per recuperare emissioni mancate ( tempo indietro )
# e per correggere all'ultimo minuto il palinsesto (tempo in avanti )
minsched=5


sleepsec=minsched/5*60


def districa(schedules):
    '''
    cerca di sdistricarsi tra un insieme di schedule
    la prima operazione da fare e' togliere i jingle che coincidono con programmi e pubblicita'
    '''
    logging.debug("eseguo districa")

#Jingles
    v=0
    for schedulej in schedules:

        scheduledatetimej=schedulej[1]
        if ( scheduledatetimej == None ): continue

        lengthj=schedulej[3]
        typej=schedulej[4]
        endscheduledatetimej=scheduledatetimej+timedelta(seconds=lengthj)
        #print "elaboro          ",typej,scheduledatetimej,endscheduledatetimej

        if (typej == "jingle"):
            for schedule in schedules:

                scheduledatetime=schedule[1]
                if ( scheduledatetime== None ): continue

                length=schedule[3]
                type=schedule[4]
                endscheduledatetime=scheduledatetime+timedelta(seconds=length)

                if (type == "jingle" or type == "playlist"): continue
                # ora qui sono jingle contro programmi e spot

                if (( scheduledatetime < scheduledatetimej and scheduledatetimej < endscheduledatetime )\
                        or \
                    ( scheduledatetime < endscheduledatetimej and endscheduledatetimej < endscheduledatetime )): 
                    logging.debug( "elimino questo jingle sovrapposto %s", str(schedules[v]))
                    schedules[v][1]=None

        v += 1


#Spots
    v=0
    for schedulej in schedules:

        scheduledatetimej=schedulej[1]
        if ( scheduledatetimej == None ): continue

        lengthj=schedulej[3]
        typej=schedulej[4]
        endscheduledatetimej=scheduledatetimej+timedelta(seconds=lengthj)
        #print "elaboro          ",typej,scheduledatetimej,endscheduledatetimej

        if (typej == "spot"):

            for schedule in schedules:

                scheduledatetime=schedule[1]
                if ( scheduledatetime== None ): continue

                length=schedule[3]
                type=schedule[4]
                endscheduledatetime=scheduledatetime+timedelta(seconds=length)
                halfscheduledatetime=scheduledatetime+timedelta(seconds=length/2)

                if (type == "spot" or type == "playlist" or type == "jingle" ): continue
                
                # ora qui sono spot contro programmi
                
                if ( scheduledatetime < scheduledatetimej and scheduledatetimej < halfscheduledatetime ): 
                    logging.debug( "anticipo questo spot sovrapposto %s", str(schedules[v]))

                    schedules[v][1]=scheduledatetime

        v += 1


def main():

  #we want to run a single process

  try:

        f = open(lockfile, "r")

        # the lock file exists
        # read it's contents to report the owner PID
        pid = int(f.readline())
        f.close()
        logging.debug("ho trovato questo pid: %s",pid)
        
        try:
            logging.error("ho trovato il file %s ; provo a killare il processo %s",lockfile,pid)
            os.kill(pid, signal.SIGTERM)

        except:
            logging.error("kill del processo %s fallito",pid)
            pass

        # wait a while and remove
        time.sleep(1)        
        os.remove(lockfile)

  except:
        pass


  try:

    # if we get here. we are alone.
    # record our PID in lockfile

    f = open(lockfile, "w")
    f.write("%d\n" % os.getpid())
    f.close()
    
    #now we can start to do our work
      


    # costanti di tempo

    #questa e' l'unica volta che imposto now col tempo corrente
    now=datetime.now()

    first = True

    if (amarok) :
        kapp=KdeInit()
        function=ManageAmarok
        ok=amarok_watchdog(kapp)


    else:
        function=ManagePytone

    while ( True):

        schedules=[]

        spots=gest_spot(now,minelab,playlistdir)

        for fascia in spots.get_fasce():

            media = spots.ar_filename
            scheduledatetime=spots.ar_scheduledatetime
            length=spots.ar_length
            emission_done=spots.ar_emission_done
            number=spots.ar_spots_in_fascia
            #print scheduledatetime,media,length,number,emission_done
            if (number <> 0 ):
                schedule=[fascia,scheduledatetime,media,length,"spot",emission_done]
                schedules.append(schedule)

        programs=gest_program(now,minelab)

        for programma in programs.get_program():

            media = programs.ar_filename
            scheduledatetime=programs.ar_scheduledatetime
            length=programs.ar_length
            emission_done=programs.ar_emission_done

            #print scheduledatetime,media,length,emission_done
            schedule=[programma,scheduledatetime,media,length,"program",emission_done]
            schedules.append(schedule)


        playlists=gest_playlist(now,minelab)

        for playlist in playlists.get_playlist():

            media = playlists.ar_filename
            scheduledatetime=playlists.ar_scheduledatetime
            length=playlists.ar_length
            emission_done=playlists.ar_emission_done

            #print scheduledatetime,media,length,emission_done
            schedule=[playlist,scheduledatetime,media,length,"playlist",emission_done]
            schedules.append(schedule)


        jingles=gest_jingle(now,minelab)

        for jingle in jingles.get_jingle():

            media = jingles.ar_filename
            scheduledatetime=jingles.ar_scheduledatetime
            length=jingles.ar_length
            emission_done=jingles.ar_emission_done

            #print scheduledatetime,media,length,emission_done
            schedule=[jingle,scheduledatetime,media,length,"jingle",emission_done]
            schedules.append(schedule)


        districa(schedules)


        for schedule in schedules:

            obj=schedule[0]
            scheduledatetime=schedule[1]
            media=schedule[2]
            type=schedule[4]
            emission_done=schedule[5]

            #print type,obj,scheduledatetime,media,emission_done

            #testa se e' una schedula eliminata da districa
            if ( scheduledatetime == None ):
                logging.debug( "districa ha eliminato una schedulazione della classe: %s",type)
                continue

            if ( emission_done <> None ):
                if ( type == "program" ):
                    #la trasmissione ha una schedula con un'unica emissione prevista
                    logging.debug( " %s %s %s schedula gia effettuata; la ignoro ",type,scheduledatetime,emission_done)
                    continue

                if ( type == "spot" ):
                    # considero una emissione effettuata se e' avvenuta nell'intorno delle 3 ore
                    if ( abs(emission_done - scheduledatetime) < timedelta(minutes=180)): 
                        logging.debug(" %s %s %s schedula gia effettuata; la ignoro !", type,scheduledatetime,emission_done)
                        continue

                if ( type == "playlist" ):
                    # considero una emissione effettuata se e' avvenuta nell'intorno delle 3 ore
                    if ( abs(emission_done - scheduledatetime) < timedelta(minutes=180)): 
                        logging.debug (" %s %s %s schedula gia effettuata; la ignoro !",type,scheduledatetime,emission_done)
                        continue


            delta=( scheduledatetime - datetime.now())
            sec=secondi(delta)
            #print "secondi di distanza", sec
            #schedulo i successivi minsched minuti a partire da minsched minuti in avanti
            #se e' la prima volta inizio da minsched minuti nel passato
            if (first and ( type == "program" or type == "spot" or type == "playlist")): 
                #recupero programmi, playlist e pubblicita' non emessi in un lasso di tempo accettabile
                startschedsec=-60*minsched
            elif (first and ( type == "jingle")):
                startschedsec=0
            else:
                startschedsec=60*minsched


            endschedsec = 60*minsched*2
            if ( startschedsec < sec and sec <= endschedsec ):

                #print "ora schedulata", scheduledatetime
                #print "ora attuale", datetime.now()

                if ( type == "spot" ): operation="queueMedia"
                if ( type == "program" ): operation="queueMedia"
                if ( type == "jingle" ): operation="queueMedia"
                if ( type == "playlist" ): operation="loadPlaylist"

                if (amarok) :
                    schedule=ScheduleProgram(kapp,function,operation,media,scheduledatetime,obj)
                else:
                    schedule=ScheduleProgram(function,operation,media,scheduledatetime,obj)

                logging.debug (" %s %s programmato tra %s", obj,media,schedule.deltasec)
                schedule.start()

        first = False

        #ora avanzo di minsched e aspetto il momento giusto per procedere
        now=now+timedelta(0,60*minsched)
        while ( datetime.now() < now):
            logging.debug ( "apetto %s sec",sleepsec)
            if (amarok):
                ok=save_status(kapp)
                if ( ok ) :

                    f = open(timestampfile, "w")
                    f.write(str(datetime.now()))
                    f.close()

            sleep (sleepsec)

        #ogni tanto risistemo la playlist (dovremo toglierlo)
        if (amarok) :
            ok=amarok_watchdog(kapp)


  except:
    import traceback
    msg = traceback.format_exc()
    logging.error(msg)
    logging.debug('Stopping')

    os.remove(lockfile)
    return 2

  else:
    msg = "errore senza possibilita di traceback; what happens ?!?!"
    logging.error(msg)
    logging.debug('Stopping')

    os.remove(lockfile)
    return 2

    
if __name__ == '__main__':
    sys.exit(main())  # (this code was run as script)
    
