# -*- coding: utf-8 -*-

# Bluemindo: A really simple but powerful audio player in Python/PyGTK.
# Copyright (C) 2007-2009  Erwan Briand

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 3 of the License.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from common.sqlite import SQLite

class Statistics(object):
    """A class to gets and updates statistics."""
    def _get_value(self, params):
        sql = SQLite()

        if params.has_key('file'):
            sqlsyntax = 'select * from stats_songs where filename=:file'
        elif params.has_key('artist'):
            sqlsyntax = 'select * from stats_artists where artist=:artist'
        elif params.has_key('album'):
            sqlsyntax = 'select * from stats_albums where album=:album'

        cur_nb = sql.execute(sqlsyntax, params)
        song = cur_nb.fetchone()

        if song is not None:
            song_tracks = song[1]
        else:
            song_tracks = 0

        sql.close()
        return song_tracks

    def _set_value(self, params):
        sql = SQLite()

        if params.has_key('file'):
            i_param = [params['file'], params['value']]
            i = 'insert into stats_songs (filename, tracks) values (?, ?)'
            u = 'update stats_songs set tracks=:value where filename=:file'
        elif params.has_key('artist'):
            i_param = [params['artist'], params['value']]
            i = 'insert into stats_artists (artist, tracks) values (?, ?)'
            u = 'update stats_artists set tracks=:value where artist=:artist'
        elif params.has_key('album'):
            i_param = [params['album'], params['value']]
            i = 'insert into stats_albums (album, tracks) values (?, ?)'
            u = 'update stats_albums set tracks=:value where album=:album'

        value = self._get_value(params)
        if params['value'] is None:
            params['value'] = int(value + 1)
            i_param[1] = int(value + 1)

        if value == 0:
            sql.execute(i, i_param)
        else:
            sql.execute(u, params)

        sql.close()

    def get_stats_for_song(self, filename):
        value = self._get_value({'file': filename})
        return value

    def get_stats_for_artist(self, artist):
        value = self._get_value({'artist': artist})
        return value

    def get_stats_for_album(self, album):
        value = self._get_value({'album':album})
        return value

    def set_stats_for_song(self, filename, value):
        self._set_value({'file': filename, 'value': value})

    def set_stats_for_artist(self, artist, value):
        self._set_value({'artist': artist, 'value': value})

    def set_stats_for_album(self, album, value):
        self._set_value({'album': album, 'value': value})

    def get_top(self, by='filename', limit=50):
        if by == 'filename':
            tbl = 'stats_songs'
        elif by == 'artist':
            tbl = 'stats_artists'
        elif by == 'album':
            tbl = 'stats_albums'

        result = []
        txt = ('select * from %s order by tracks desc '
               'limit %u' % (tbl, limit))

        sql = SQLite()
        cur = sql.execute(txt)

        for sg in cur:
            result.append(sg)

        sql.close()
        return result