# -*- coding: utf-8 -*-

# Bluemindo: A really simple but powerful audio player in Python/PyGTK.
# Copyright (C) 2007-2009  Erwan Briand

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 3 of the License.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from thread import start_new_thread
from xml.sax.saxutils import unescape as xml_unescape

from common.webservices import Amazon
amazon = Amazon()

def unescape(string):
    """Unescape an escaped string with markup_escape_text."""
    _str = xml_unescape(string, {'&apos;': "'", '&quot;': '"'})

    return _str


def insensitive_sort(x, y):
    """Sort a list, no matter of case."""
    if isinstance(x, dict) and isinstance(y, dict):
        x = x['album']
        y = y['album']
    else:
        x = x[0]
        y = y[0]

    if x.lower() == y.lower():
        return 0
    elif x.lower() < y.lower():
        return -1
    else:
        return 1


def get_representation(list_songs, fetch_artwork=True):
    """This function returns a artist→album→songs presentation."""

    def unique(seq, keepstr=True):
        """This function ensures there are only unique values."""
        t = type(seq)
        if t in (str, unicode):
            t = (list, ''.join)[bool(keepstr)]
        seen = []
        return t(c for c in seq if not (c in seen or seen.append(c)))

    def song_sort(x, y):
        """This function sorts songs."""
        if x[3] == y[3]:
            return 0
        elif x[3] < y[3]:
            return -1
        else:
            return 1

    songs_tree = {}
    artists = []
    albums = []
    albums_dl = []

    for result in list_songs:
        artists.append(result[1])
        albums.append((result[1], result[2]))

    artists = unique(artists)
    albums = unique(albums)

    for a in artists:
        songs_tree[a] = {}

    for a in albums:
        if fetch_artwork and (a[0] != '' and a[1] != ''):
            albums_dl.append((a[0], a[1]))

        songs_tree[a[0]][a[1]] = []

    # Download albums pictures
    if fetch_artwork:
        start_new_thread(amazon.get_pictures, (albums_dl,))

    # Add songs
    for result in list_songs:
        songs_tree[result[1]][result[2]].append(result)

    # Sort songs
    for artist in songs_tree.values():
        for album in artist.values():
            album.sort(song_sort)

    return songs_tree