# -*- coding: utf-8 -*-

# Bluemindo: A really simple but powerful audio player in Python/PyGTK.
# Copyright (C) 2007-2009  Erwan Briand

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 3 of the License.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from gettext import gettext as _
from urllib2 import urlopen, Request, quote as urllib_quote, HTTPError
from re import findall as re_findall
from os.path import isfile, join

from common.webservices import WebServices
from common.functions import Functions
functions = Functions()

class LyricsDownloader:
    """A class to handles many lyrics websites."""

    def __init__(self, config):
        self.config = config

    def reload_config(self, newconf):
        """Update the module configuration."""
        del self.config
        self.config = newconf

    def get_lyrics(self, title, artist, force_download):
        """Return lyrics for a song."""
        song_hash = functions.get_hash(title, artist)
        lyrics_file = join(self.config['__data-dir'], '%s.lyrics' % song_hash)

        if not self.config['active']:
            return _('Lyrics fetching is currently disabled.')

        if isfile(lyrics_file) and not force_download:
            # The lyrics already exists, return them
            file_ = open(lyrics_file)
            lyrics = file_.read()
            file_.close()
        else:
            # We need to download lyrics for this song

            # Choose a server
            if self.config['server'] == 'lyricwiki.org':
                lrc = LyricWiki
            elif self.config['server'] == 'lyrc.com.ar':
                lrc = Lyrc
            else:
                lrc = Lyriki

            # Get the lyrics
            lrcobj = lrc()
            lyrics = lrcobj.get_lyrics(title, artist)

            if lyrics != '':
                # Save the lyrics
                file_ = open(lyrics_file, 'w')
                file_.write(lyrics)
                file_.close()

        # Return the lyrics
        return lyrics


class LyricWiki(WebServices):
    """Wrapper for lyricwiki.org."""

    def get_lyrics(self, title, artist):
        lyrics = ''
        artist.replace(' ', '_')
        title.replace(' ', '_')

        url = ("http://www.lyricwiki.org/%s:%s" % (
               urllib_quote(str(artist)), urllib_quote(str(title))))

        try:
            page = self.get_html(url)
        except HTTPError:
            page = ''

        for lyrics in re_findall("(?s)<div class='lyricbox' >(.*?)\n", page):
            lyrics = lyrics.replace('<br />', '\n')

        return lyrics


class Lyrc(WebServices):
    """Wrapper for lyrc.com.ar."""

    def get_lyrics(self, title, artist):
        lyrics = ''
        url = ('http://lyrc.com.ar/en/tema1en.php?artist=%s&songname=%s' % (
               urllib_quote(str(artist)), urllib_quote(str(title))))

        page = self.get_html(url)
        for lyrics in re_findall('(?s)</script></td></tr></table>(.*?)<br>'
                                 '<br><a href="', page):
            lyrics = lyrics.replace('<br />', '')

        return lyrics


class Lyriki(WebServices):
    """Wrapper for lyriki.com."""

    def get_lyrics(self, title, artist):
        lyrics = ''
        artist.replace(' ', '_')
        title.replace(' ', '_')

        url = ('http://www.lyriki.com/%s:%s' % (
               urllib_quote(str(artist)), urllib_quote(str(title))))

        page = self.get_html(url)
        for lyrics in re_findall('(?s)<p>(.*?)</p>', page):
            lyrics = lyrics.replace('<br />', '\n')

        return lyrics