# -*- coding: utf-8 -*-

# Bluemindo: A really simple but powerful audio player in Python/PyGTK.
# Copyright (C) 2007-2009  Erwan Briand

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 3 of the License.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from gettext import gettext as _
from gtk import STOCK_DIALOG_INFO
from ConfigParser import ConfigParser, NoSectionError
from os.path import join

from common.config import ConfigLoader

from plugins.notification.notify import Notify
from plugins.notification.config import Config

class Notification:
    def __init__(self, extensionsloader):
        self.extensions = extensionsloader
        self.plugin = {'name': 'Notification',
                       'version': 0.2,
                       'logo': STOCK_DIALOG_INFO,
                       'configurable': True,
                       'authors': 'Erwan Briand <erwan@codingteam.net>',
                       'license': 'GNU General Public License 3',
                       'description': _('Show desktop notification')}

    def start_plugin(self):
        # Start configuration
        name = self.plugin['name'].lower() + '.cfg'
        self.config = ConfigLoader()
        self.config_file = join(self.config.confdir, 'plugins', name)
        self.player_dir = join(self.config.datadir, 'modules', 'player')

        # Start notification agent
        config = self.get_configuration()
        self.notify = Notify(config)

        self.config_gui = Config(self.plugin, self.notify,
                                 self.config_file,self.get_configuration)

        def loadconfig(args):
            self.config_gui.configuration(args)

        def saveconfig(args):
            self.config_gui.save_config(args)

        # Connect to Bluemindo's signals
        self.extensions.connect('OnTrayIconAnswer', self.notify._get_tray)
        self.extensions.connect('OnPlayNewSong', self.notify.load_new_song)
        self.extensions.connect('OnNotificationRequest', self.notify.show)
        self.extensions.connect('OnModuleConfiguration', loadconfig)
        self.extensions.connect('OnModuleConfigurationSave', saveconfig)

    def stop_plugin(self):
        self.notify._stop_plugin()

    def get_configuration(self):
        configparser = ConfigParser()
        configparser.read(self.config_file)
        config = {}

        try:
            for item in configparser.items(self.plugin['name']):
                try:
                    value = int(item[1])
                except ValueError:
                    value = str(item[1])

                config[item[0]] = value
        except NoSectionError:
            config['title'] = '{title}'
            config['text'] = '<i>{artist}</i>\n{album}'
            config['timeout'] = 10000

        config['__player-data'] = self.player_dir

        return config