//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Device/InstrumentNotifier.cpp
//! @brief     Implements class InstrumentNotifier
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/Model/Device/InstrumentNotifier.h"
#include "Device/Coord/ICoordSystem.h"
#include "GUI/Model/Axis/PointwiseAxisItem.h"
#include "GUI/Model/Beam/SourceItems.h"
#include "GUI/Model/Device/InstrumentItems.h"
#include "GUI/Model/Device/MultiInstrumentNotifier.h"

InstrumentNotifier::InstrumentNotifier(MultiInstrumentNotifier* ec, InstrumentItem* instrument)
    : m_instrumentItem(instrument)
    , m_ec(ec)
{
}

void InstrumentNotifier::setInstrumentName(const QString& name)
{
    m_ec->setInstrumentName(m_instrumentItem, name);
}

void InstrumentNotifier::notifyInstrumentChanged()
{
    m_ec->instrumentChanged(m_instrumentItem);
}

void InstrumentNotifier::notifyWavelengthDistributionChanged()
{
    // Update values in pointwise axis. This is necessary after a change of the mean wavelength.
    if (auto* iiI = dynamic_cast<SpecularInstrumentItem*>(m_instrumentItem)) {
        if (auto* pw = dynamic_cast<PointwiseAxisItem*>(iiI->scanItem()->inclinationAxisItem())) {
            std::unique_ptr<const ICoordSystem> converter = m_instrumentItem->createCoordSystem();
            pw->updateAxIndicators(*converter);
        }
    }

    m_ec->instrumentChanged(m_instrumentItem);
}

void InstrumentNotifier::notifyInclinationAxisChanged()
{
    m_ec->instrumentChanged(m_instrumentItem);
}
