//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Support/Data/JobWorker.h
//! @brief     Defines class JobWorker
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_SUPPORT_DATA_JOBWORKER_H
#define BORNAGAIN_GUI_SUPPORT_DATA_JOBWORKER_H

#include "GUI/Support/Data/JobStatus.h"
#include <QDateTime>
#include <QObject>
#include <memory>

class ISimulation;
class SimulationResult;

//! The JobWorker class provides running the domain simulation in a thread.

class JobWorker : public QObject {
    Q_OBJECT
public:
    JobWorker(QString identifier, ISimulation* simulation);
    ~JobWorker();

    QString identifier() const;

    int progress() const;

    JobStatus status() const;

    QString failureMessage() const;

    const QDateTime& simulationStart() const;
    const QDateTime& simulationEnd() const;

    const SimulationResult* result() const;

signals:
    void started();
    void finished();
    void progressUpdate();

public slots:
    void start();
    void terminate();

private:
    bool updateProgress(int percentage_done);

    QString m_identifier;
    ISimulation* m_simulation;
    int m_percentage_done;
    JobStatus m_job_status;
    bool m_terminate_request_flag;
    QString m_failure_message;
    QDateTime m_simulation_start;
    QDateTime m_simulation_end;
    std::unique_ptr<const SimulationResult> m_result;
};

#endif // BORNAGAIN_GUI_SUPPORT_DATA_JOBWORKER_H
