//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Support/Util/QCP_Util.cpp
//! @brief     Implements RangeUtil namespace
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/Support/Util/QCP_Util.h"
#include "GUI/Support/Util/Style.h"
#include <qcustomplot.h>

namespace {

QMargins defaultMargins(const QWidget& widget)
{
    auto base_size = GUI::Style::SizeOfLetterM(&widget);
    int left = static_cast<int>(base_size.width() * 6.0);
    int top = static_cast<int>(base_size.height() * 1.5);
    int right = static_cast<int>(base_size.width() * 1.2);
    int bottom = static_cast<int>(base_size.height() * 4.5);
    return QMargins(left, top, right, bottom);
}

} // namespace

void GUI::QCP_Util::setLogz(QCPColorScale* scale, bool isLogz)
{
    if (isLogz && scale->dataScaleType() != QCPAxis::stLogarithmic)
        scale->setDataScaleType(QCPAxis::stLogarithmic);

    else if (!isLogz && scale->dataScaleType() != QCPAxis::stLinear)
        scale->setDataScaleType(QCPAxis::stLinear);

    setLogz(scale->axis(), isLogz);
}

void GUI::QCP_Util::setLogz(QCPAxis* axis, bool isLogz)
{
    if (isLogz) {
        axis->setNumberFormat("e");
        axis->setNumberPrecision(0);
        axis->setScaleType(QCPAxis::stLogarithmic);
        QSharedPointer<QCPAxisTicker> ticker(new QCPAxisTickerLog);
        axis->setTicker(ticker);
    } else {
        axis->setNumberFormat("g");
        axis->setScaleType(QCPAxis::stLinear);
        QSharedPointer<QCPAxisTicker> ticker(new QCPAxisTicker);
        axis->setTicker(ticker);
    }
}

void GUI::QCP_Util::setDefaultMargins(QCustomPlot* customPlot)
{
    auto* axisRectangle = customPlot->axisRect();
    axisRectangle->setAutoMargins(QCP::msTop | QCP::msBottom);
    axisRectangle->setMargins(defaultMargins(*customPlot));
}

// colors taken and converted to int from
// github.com/matplotlib/matplotlib/blob/main/lib/matplotlib/_cm_listed.py
QCPColorGradient GUI::QCP_Util::colorGradientInferno()
{
    QCPColorGradient result;
    result.setColorStopAt(0.0 / 255.0, {0, 0, 3});
    result.setColorStopAt(1.0 / 255.0, {0, 0, 4});
    result.setColorStopAt(2.0 / 255.0, {0, 0, 6});
    result.setColorStopAt(3.0 / 255.0, {1, 0, 7});
    result.setColorStopAt(4.0 / 255.0, {1, 1, 9});
    result.setColorStopAt(5.0 / 255.0, {1, 1, 11});
    result.setColorStopAt(6.0 / 255.0, {2, 1, 14});
    result.setColorStopAt(7.0 / 255.0, {2, 2, 16});
    result.setColorStopAt(8.0 / 255.0, {3, 2, 18});
    result.setColorStopAt(9.0 / 255.0, {4, 3, 20});
    result.setColorStopAt(10.0 / 255.0, {4, 3, 22});
    result.setColorStopAt(11.0 / 255.0, {5, 4, 24});
    result.setColorStopAt(12.0 / 255.0, {6, 4, 27});
    result.setColorStopAt(13.0 / 255.0, {7, 5, 29});
    result.setColorStopAt(14.0 / 255.0, {8, 6, 31});
    result.setColorStopAt(15.0 / 255.0, {9, 6, 33});
    result.setColorStopAt(16.0 / 255.0, {10, 7, 35});
    result.setColorStopAt(17.0 / 255.0, {11, 7, 38});
    result.setColorStopAt(18.0 / 255.0, {13, 8, 40});
    result.setColorStopAt(19.0 / 255.0, {14, 8, 42});
    result.setColorStopAt(20.0 / 255.0, {15, 9, 45});
    result.setColorStopAt(21.0 / 255.0, {16, 9, 47});
    result.setColorStopAt(22.0 / 255.0, {18, 10, 50});
    result.setColorStopAt(23.0 / 255.0, {19, 10, 52});
    result.setColorStopAt(24.0 / 255.0, {20, 11, 54});
    result.setColorStopAt(25.0 / 255.0, {22, 11, 57});
    result.setColorStopAt(26.0 / 255.0, {23, 11, 59});
    result.setColorStopAt(27.0 / 255.0, {25, 11, 62});
    result.setColorStopAt(28.0 / 255.0, {26, 11, 64});
    result.setColorStopAt(29.0 / 255.0, {28, 12, 67});
    result.setColorStopAt(30.0 / 255.0, {29, 12, 69});
    result.setColorStopAt(31.0 / 255.0, {31, 12, 71});
    result.setColorStopAt(32.0 / 255.0, {32, 12, 74});
    result.setColorStopAt(33.0 / 255.0, {34, 11, 76});
    result.setColorStopAt(34.0 / 255.0, {36, 11, 78});
    result.setColorStopAt(35.0 / 255.0, {38, 11, 80});
    result.setColorStopAt(36.0 / 255.0, {39, 11, 82});
    result.setColorStopAt(37.0 / 255.0, {41, 11, 84});
    result.setColorStopAt(38.0 / 255.0, {43, 10, 86});
    result.setColorStopAt(39.0 / 255.0, {45, 10, 88});
    result.setColorStopAt(40.0 / 255.0, {46, 10, 90});
    result.setColorStopAt(41.0 / 255.0, {48, 10, 92});
    result.setColorStopAt(42.0 / 255.0, {50, 9, 93});
    result.setColorStopAt(43.0 / 255.0, {52, 9, 95});
    result.setColorStopAt(44.0 / 255.0, {53, 9, 96});
    result.setColorStopAt(45.0 / 255.0, {55, 9, 97});
    result.setColorStopAt(46.0 / 255.0, {57, 9, 98});
    result.setColorStopAt(47.0 / 255.0, {59, 9, 100});
    result.setColorStopAt(48.0 / 255.0, {60, 9, 101});
    result.setColorStopAt(49.0 / 255.0, {62, 9, 102});
    result.setColorStopAt(50.0 / 255.0, {64, 9, 102});
    result.setColorStopAt(51.0 / 255.0, {65, 9, 103});
    result.setColorStopAt(52.0 / 255.0, {67, 10, 104});
    result.setColorStopAt(53.0 / 255.0, {69, 10, 105});
    result.setColorStopAt(54.0 / 255.0, {70, 10, 105});
    result.setColorStopAt(55.0 / 255.0, {72, 11, 106});
    result.setColorStopAt(56.0 / 255.0, {74, 11, 106});
    result.setColorStopAt(57.0 / 255.0, {75, 12, 107});
    result.setColorStopAt(58.0 / 255.0, {77, 12, 107});
    result.setColorStopAt(59.0 / 255.0, {79, 13, 108});
    result.setColorStopAt(60.0 / 255.0, {80, 13, 108});
    result.setColorStopAt(61.0 / 255.0, {82, 14, 108});
    result.setColorStopAt(62.0 / 255.0, {83, 14, 109});
    result.setColorStopAt(63.0 / 255.0, {85, 15, 109});
    result.setColorStopAt(64.0 / 255.0, {87, 15, 109});
    result.setColorStopAt(65.0 / 255.0, {88, 16, 109});
    result.setColorStopAt(66.0 / 255.0, {90, 17, 109});
    result.setColorStopAt(67.0 / 255.0, {91, 17, 110});
    result.setColorStopAt(68.0 / 255.0, {93, 18, 110});
    result.setColorStopAt(69.0 / 255.0, {95, 18, 110});
    result.setColorStopAt(70.0 / 255.0, {96, 19, 110});
    result.setColorStopAt(71.0 / 255.0, {98, 20, 110});
    result.setColorStopAt(72.0 / 255.0, {99, 20, 110});
    result.setColorStopAt(73.0 / 255.0, {101, 21, 110});
    result.setColorStopAt(74.0 / 255.0, {102, 21, 110});
    result.setColorStopAt(75.0 / 255.0, {104, 22, 110});
    result.setColorStopAt(76.0 / 255.0, {106, 23, 110});
    result.setColorStopAt(77.0 / 255.0, {107, 23, 110});
    result.setColorStopAt(78.0 / 255.0, {109, 24, 110});
    result.setColorStopAt(79.0 / 255.0, {110, 24, 110});
    result.setColorStopAt(80.0 / 255.0, {112, 25, 110});
    result.setColorStopAt(81.0 / 255.0, {114, 25, 109});
    result.setColorStopAt(82.0 / 255.0, {115, 26, 109});
    result.setColorStopAt(83.0 / 255.0, {117, 27, 109});
    result.setColorStopAt(84.0 / 255.0, {118, 27, 109});
    result.setColorStopAt(85.0 / 255.0, {120, 28, 109});
    result.setColorStopAt(86.0 / 255.0, {122, 28, 109});
    result.setColorStopAt(87.0 / 255.0, {123, 29, 108});
    result.setColorStopAt(88.0 / 255.0, {125, 29, 108});
    result.setColorStopAt(89.0 / 255.0, {126, 30, 108});
    result.setColorStopAt(90.0 / 255.0, {128, 31, 107});
    result.setColorStopAt(91.0 / 255.0, {129, 31, 107});
    result.setColorStopAt(92.0 / 255.0, {131, 32, 107});
    result.setColorStopAt(93.0 / 255.0, {133, 32, 106});
    result.setColorStopAt(94.0 / 255.0, {134, 33, 106});
    result.setColorStopAt(95.0 / 255.0, {136, 33, 106});
    result.setColorStopAt(96.0 / 255.0, {137, 34, 105});
    result.setColorStopAt(97.0 / 255.0, {139, 34, 105});
    result.setColorStopAt(98.0 / 255.0, {141, 35, 105});
    result.setColorStopAt(99.0 / 255.0, {142, 36, 104});
    result.setColorStopAt(100.0 / 255.0, {144, 36, 104});
    result.setColorStopAt(101.0 / 255.0, {145, 37, 103});
    result.setColorStopAt(102.0 / 255.0, {147, 37, 103});
    result.setColorStopAt(103.0 / 255.0, {149, 38, 102});
    result.setColorStopAt(104.0 / 255.0, {150, 38, 102});
    result.setColorStopAt(105.0 / 255.0, {152, 39, 101});
    result.setColorStopAt(106.0 / 255.0, {153, 40, 100});
    result.setColorStopAt(107.0 / 255.0, {155, 40, 100});
    result.setColorStopAt(108.0 / 255.0, {156, 41, 99});
    result.setColorStopAt(109.0 / 255.0, {158, 41, 99});
    result.setColorStopAt(110.0 / 255.0, {160, 42, 98});
    result.setColorStopAt(111.0 / 255.0, {161, 43, 97});
    result.setColorStopAt(112.0 / 255.0, {163, 43, 97});
    result.setColorStopAt(113.0 / 255.0, {164, 44, 96});
    result.setColorStopAt(114.0 / 255.0, {166, 44, 95});
    result.setColorStopAt(115.0 / 255.0, {167, 45, 95});
    result.setColorStopAt(116.0 / 255.0, {169, 46, 94});
    result.setColorStopAt(117.0 / 255.0, {171, 46, 93});
    result.setColorStopAt(118.0 / 255.0, {172, 47, 92});
    result.setColorStopAt(119.0 / 255.0, {174, 48, 91});
    result.setColorStopAt(120.0 / 255.0, {175, 49, 91});
    result.setColorStopAt(121.0 / 255.0, {177, 49, 90});
    result.setColorStopAt(122.0 / 255.0, {178, 50, 89});
    result.setColorStopAt(123.0 / 255.0, {180, 51, 88});
    result.setColorStopAt(124.0 / 255.0, {181, 51, 87});
    result.setColorStopAt(125.0 / 255.0, {183, 52, 86});
    result.setColorStopAt(126.0 / 255.0, {184, 53, 86});
    result.setColorStopAt(127.0 / 255.0, {186, 54, 85});
    result.setColorStopAt(128.0 / 255.0, {187, 55, 84});
    result.setColorStopAt(129.0 / 255.0, {189, 55, 83});
    result.setColorStopAt(130.0 / 255.0, {190, 56, 82});
    result.setColorStopAt(131.0 / 255.0, {191, 57, 81});
    result.setColorStopAt(132.0 / 255.0, {193, 58, 80});
    result.setColorStopAt(133.0 / 255.0, {194, 59, 79});
    result.setColorStopAt(134.0 / 255.0, {196, 60, 78});
    result.setColorStopAt(135.0 / 255.0, {197, 61, 77});
    result.setColorStopAt(136.0 / 255.0, {199, 62, 76});
    result.setColorStopAt(137.0 / 255.0, {200, 62, 75});
    result.setColorStopAt(138.0 / 255.0, {201, 63, 74});
    result.setColorStopAt(139.0 / 255.0, {203, 64, 73});
    result.setColorStopAt(140.0 / 255.0, {204, 65, 72});
    result.setColorStopAt(141.0 / 255.0, {205, 66, 71});
    result.setColorStopAt(142.0 / 255.0, {207, 68, 70});
    result.setColorStopAt(143.0 / 255.0, {208, 69, 68});
    result.setColorStopAt(144.0 / 255.0, {209, 70, 67});
    result.setColorStopAt(145.0 / 255.0, {210, 71, 66});
    result.setColorStopAt(146.0 / 255.0, {212, 72, 65});
    result.setColorStopAt(147.0 / 255.0, {213, 73, 64});
    result.setColorStopAt(148.0 / 255.0, {214, 74, 63});
    result.setColorStopAt(149.0 / 255.0, {215, 75, 62});
    result.setColorStopAt(150.0 / 255.0, {217, 77, 61});
    result.setColorStopAt(151.0 / 255.0, {218, 78, 59});
    result.setColorStopAt(152.0 / 255.0, {219, 79, 58});
    result.setColorStopAt(153.0 / 255.0, {220, 80, 57});
    result.setColorStopAt(154.0 / 255.0, {221, 82, 56});
    result.setColorStopAt(155.0 / 255.0, {222, 83, 55});
    result.setColorStopAt(156.0 / 255.0, {223, 84, 54});
    result.setColorStopAt(157.0 / 255.0, {224, 86, 52});
    result.setColorStopAt(158.0 / 255.0, {226, 87, 51});
    result.setColorStopAt(159.0 / 255.0, {227, 88, 50});
    result.setColorStopAt(160.0 / 255.0, {228, 90, 49});
    result.setColorStopAt(161.0 / 255.0, {229, 91, 48});
    result.setColorStopAt(162.0 / 255.0, {230, 92, 46});
    result.setColorStopAt(163.0 / 255.0, {230, 94, 45});
    result.setColorStopAt(164.0 / 255.0, {231, 95, 44});
    result.setColorStopAt(165.0 / 255.0, {232, 97, 43});
    result.setColorStopAt(166.0 / 255.0, {233, 98, 42});
    result.setColorStopAt(167.0 / 255.0, {234, 100, 40});
    result.setColorStopAt(168.0 / 255.0, {235, 101, 39});
    result.setColorStopAt(169.0 / 255.0, {236, 103, 38});
    result.setColorStopAt(170.0 / 255.0, {237, 104, 37});
    result.setColorStopAt(171.0 / 255.0, {237, 106, 35});
    result.setColorStopAt(172.0 / 255.0, {238, 108, 34});
    result.setColorStopAt(173.0 / 255.0, {239, 109, 33});
    result.setColorStopAt(174.0 / 255.0, {240, 111, 31});
    result.setColorStopAt(175.0 / 255.0, {240, 112, 30});
    result.setColorStopAt(176.0 / 255.0, {241, 114, 29});
    result.setColorStopAt(177.0 / 255.0, {242, 116, 28});
    result.setColorStopAt(178.0 / 255.0, {242, 117, 26});
    result.setColorStopAt(179.0 / 255.0, {243, 119, 25});
    result.setColorStopAt(180.0 / 255.0, {243, 121, 24});
    result.setColorStopAt(181.0 / 255.0, {244, 122, 22});
    result.setColorStopAt(182.0 / 255.0, {245, 124, 21});
    result.setColorStopAt(183.0 / 255.0, {245, 126, 20});
    result.setColorStopAt(184.0 / 255.0, {246, 128, 18});
    result.setColorStopAt(185.0 / 255.0, {246, 129, 17});
    result.setColorStopAt(186.0 / 255.0, {247, 131, 16});
    result.setColorStopAt(187.0 / 255.0, {247, 133, 14});
    result.setColorStopAt(188.0 / 255.0, {248, 135, 13});
    result.setColorStopAt(189.0 / 255.0, {248, 136, 12});
    result.setColorStopAt(190.0 / 255.0, {248, 138, 11});
    result.setColorStopAt(191.0 / 255.0, {249, 140, 9});
    result.setColorStopAt(192.0 / 255.0, {249, 142, 8});
    result.setColorStopAt(193.0 / 255.0, {249, 144, 8});
    result.setColorStopAt(194.0 / 255.0, {250, 145, 7});
    result.setColorStopAt(195.0 / 255.0, {250, 147, 6});
    result.setColorStopAt(196.0 / 255.0, {250, 149, 6});
    result.setColorStopAt(197.0 / 255.0, {250, 151, 6});
    result.setColorStopAt(198.0 / 255.0, {251, 153, 6});
    result.setColorStopAt(199.0 / 255.0, {251, 155, 6});
    result.setColorStopAt(200.0 / 255.0, {251, 157, 6});
    result.setColorStopAt(201.0 / 255.0, {251, 158, 7});
    result.setColorStopAt(202.0 / 255.0, {251, 160, 7});
    result.setColorStopAt(203.0 / 255.0, {251, 162, 8});
    result.setColorStopAt(204.0 / 255.0, {251, 164, 10});
    result.setColorStopAt(205.0 / 255.0, {251, 166, 11});
    result.setColorStopAt(206.0 / 255.0, {251, 168, 13});
    result.setColorStopAt(207.0 / 255.0, {251, 170, 14});
    result.setColorStopAt(208.0 / 255.0, {251, 172, 16});
    result.setColorStopAt(209.0 / 255.0, {251, 174, 18});
    result.setColorStopAt(210.0 / 255.0, {251, 176, 20});
    result.setColorStopAt(211.0 / 255.0, {251, 177, 22});
    result.setColorStopAt(212.0 / 255.0, {251, 179, 24});
    result.setColorStopAt(213.0 / 255.0, {251, 181, 26});
    result.setColorStopAt(214.0 / 255.0, {251, 183, 28});
    result.setColorStopAt(215.0 / 255.0, {251, 185, 30});
    result.setColorStopAt(216.0 / 255.0, {250, 187, 33});
    result.setColorStopAt(217.0 / 255.0, {250, 189, 35});
    result.setColorStopAt(218.0 / 255.0, {250, 191, 37});
    result.setColorStopAt(219.0 / 255.0, {250, 193, 40});
    result.setColorStopAt(220.0 / 255.0, {249, 195, 42});
    result.setColorStopAt(221.0 / 255.0, {249, 197, 44});
    result.setColorStopAt(222.0 / 255.0, {249, 199, 47});
    result.setColorStopAt(223.0 / 255.0, {248, 201, 49});
    result.setColorStopAt(224.0 / 255.0, {248, 203, 52});
    result.setColorStopAt(225.0 / 255.0, {248, 205, 55});
    result.setColorStopAt(226.0 / 255.0, {247, 207, 58});
    result.setColorStopAt(227.0 / 255.0, {247, 209, 60});
    result.setColorStopAt(228.0 / 255.0, {246, 211, 63});
    result.setColorStopAt(229.0 / 255.0, {246, 213, 66});
    result.setColorStopAt(230.0 / 255.0, {245, 215, 69});
    result.setColorStopAt(231.0 / 255.0, {245, 217, 72});
    result.setColorStopAt(232.0 / 255.0, {244, 219, 75});
    result.setColorStopAt(233.0 / 255.0, {244, 220, 79});
    result.setColorStopAt(234.0 / 255.0, {243, 222, 82});
    result.setColorStopAt(235.0 / 255.0, {243, 224, 86});
    result.setColorStopAt(236.0 / 255.0, {243, 226, 89});
    result.setColorStopAt(237.0 / 255.0, {242, 228, 93});
    result.setColorStopAt(238.0 / 255.0, {242, 230, 96});
    result.setColorStopAt(239.0 / 255.0, {241, 232, 100});
    result.setColorStopAt(240.0 / 255.0, {241, 233, 104});
    result.setColorStopAt(241.0 / 255.0, {241, 235, 108});
    result.setColorStopAt(242.0 / 255.0, {241, 237, 112});
    result.setColorStopAt(243.0 / 255.0, {241, 238, 116});
    result.setColorStopAt(244.0 / 255.0, {241, 240, 121});
    result.setColorStopAt(245.0 / 255.0, {241, 242, 125});
    result.setColorStopAt(246.0 / 255.0, {242, 243, 129});
    result.setColorStopAt(247.0 / 255.0, {242, 244, 133});
    result.setColorStopAt(248.0 / 255.0, {243, 246, 137});
    result.setColorStopAt(249.0 / 255.0, {244, 247, 141});
    result.setColorStopAt(250.0 / 255.0, {245, 248, 145});
    result.setColorStopAt(251.0 / 255.0, {246, 250, 149});
    result.setColorStopAt(252.0 / 255.0, {247, 251, 153});
    result.setColorStopAt(253.0 / 255.0, {249, 252, 157});
    result.setColorStopAt(254.0 / 255.0, {250, 253, 160});
    result.setColorStopAt(255.0 / 255.0, {252, 254, 164});
    return result;
}
