//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Projection/ProjectionsEditorActions.h
//! @brief     Defines class ProjectionsEditorActions
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_PROJECTION_PROJECTIONSEDITORACTIONS_H
#define BORNAGAIN_GUI_VIEW_PROJECTION_PROJECTIONSEDITORACTIONS_H

#include <QAction>
#include <QItemSelectionModel>

class IntensityDataItem;
class MaskContainerModel;
class ProjectionContainerItem;

//! Provides various actions for ProjectionsEditor.

class ProjectionsEditorActions : public QObject {
    Q_OBJECT

public:
    ProjectionsEditorActions(QWidget* parent = nullptr);

    void setContext(IntensityDataItem* intensityItem);

    QList<QAction*> topToolbarActions();

public slots:
    void onDeleteAction();
    void onSaveAction();

signals:
    void resetViewRequest();
    void propertyPanelRequest();

private:
    QAction* m_resetViewAction;
    QAction* m_togglePanelAction;
    QAction* m_deleteAction;
    MaskContainerModel* m_maskContainerModel;
    IntensityDataItem* m_intensityDataItem;
    QItemSelectionModel* m_selectionModel;
    QWidget* m_parent;
};

#endif // BORNAGAIN_GUI_VIEW_PROJECTION_PROJECTIONSEDITORACTIONS_H
