/* Copyright (C) 2003 MORIOKA Tomohiko
   This file is part of the CHISE Library.

   The CHISE Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The CHISE Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the CHISE Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.  */

#ifndef _CHISE_NAME_H
#define _CHISE_NAME_H

typedef struct CHISE_HASH_TABLE_ENTRY CHISE_HASH_TABLE_ENTRY;
typedef struct CHISE_HASH_TABLE CHISE_HASH_TABLE;

typedef CHISE_HASH_TABLE CHISE_NAME_TABLE;
typedef CHISE_HASH_TABLE_ENTRY CHISE_NAME_TABLE_ENTRY;

CHISE_NAME_TABLE* chise_make_name_table (void);
void chise_destroy_name_table (CHISE_NAME_TABLE* table);
int chise_name_table_put (CHISE_NAME_TABLE* table,
			  const unsigned char *key, void *value);
void* chise_name_table_get (CHISE_NAME_TABLE* table, const unsigned char *key);
int chise_name_table_grow (CHISE_NAME_TABLE* table);

#endif /* !_CHISE_NAME_H */
