package tacustom;

import com.db4o.instrumentation.core.*;

public class AnnotationClassFilter implements ClassFilter {

	@SuppressWarnings("unchecked")
	public boolean accept(Class clazz) {
		boolean hasAnnotation = false;
		try {
			ClassLoader loader = clazz.getClassLoader();
			if(loader != null) {
				Class<?> loaderClazz = loader.loadClass(Db4oPersistent.class.getName());
				hasAnnotation = clazz.isAnnotationPresent(loaderClazz);
			}
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		}
		return hasAnnotation;
	}
}
