// { dg-do run { target c++11 } }
// { dg-options "-D__STDCPP_WANT_MATH_SPEC_FUNCS__" }
//
// Copyright (C) 2016-2018 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING3.  If not see
// <http://www.gnu.org/licenses/>.

//  airy_ai

//  Compare against values generated by the GNU Scientific Library.
//  The GSL can be found on the web: http://www.gnu.org/software/gsl/
#include <limits>
#include <cmath>
#if defined(__TEST_DEBUG)
#  include <iostream>
#  define VERIFY(A) \
  if (!(A)) \
    { \
      std::cout << "line " << __LINE__ \
	<< "  max_abs_frac = " << max_abs_frac \
	<< std::endl; \
    }
#else
#  include <testsuite_hooks.h>
#endif
#include <specfun_testcase.h>

// Test data.
// max(|f - f_GSL|): 2.0261570199409107e-15 at index 0
// max(|f - f_GSL| / |f_GSL|): 5.7527019513802774e-14
// mean(f - f_GSL): 5.7893945880945940e-17
// variance(f - f_GSL): 8.5887539970087062e-35
// stddev(f - f_GSL): 9.2675530734971811e-18
const testcase_airy_ai<double>
data001[41] =
{
  { 0.040241238486444071, -10.000000000000000, 0.0 },
  { 0.31910324771912801, -9.5000000000000000, 0.0 },
  { -0.022133721547341240, -9.0000000000000000, 0.0 },
  { -0.33029023763020882, -8.5000000000000000, 0.0 },
  { -0.052705050356385910, -8.0000000000000000, 0.0 },
  { 0.32177571638064789, -7.5000000000000000, 0.0 },
  { 0.18428083525050609, -7.0000000000000000, 0.0 },
  { -0.23802030199711663, -6.5000000000000000, 0.0 },
  { -0.32914517362982321, -6.0000000000000000, 0.0 },
  { 0.017781541276574383, -5.5000000000000000, 0.0 },
  { 0.35076100902411411, -5.0000000000000000, 0.0 },
  { 0.29215278105595921, -4.5000000000000000, 0.0 },
  { -0.070265532949289680, -4.0000000000000000, 0.0 },
  { -0.37553382314043182, -3.5000000000000000, 0.0 },
  { -0.37881429367765823, -3.0000000000000000, 0.0 },
  { -0.11232506769296607, -2.5000000000000000, 0.0 },
  { 0.22740742820168561, -2.0000000000000000, 0.0 },
  { 0.46425657774886947, -1.5000000000000000, 0.0 },
  { 0.53556088329235207, -1.0000000000000000, 0.0 },
  { 0.47572809161053958, -0.50000000000000000, 0.0 },
  { 0.35502805388781722, 0.0000000000000000, 0.0 },
  { 0.23169360648083348, 0.50000000000000000, 0.0 },
  { 0.13529241631288141, 1.0000000000000000, 0.0 },
  { 0.071749497008105428, 1.5000000000000000, 0.0 },
  { 0.034924130423274372, 2.0000000000000000, 0.0 },
  { 0.015725923380470481, 2.5000000000000000, 0.0 },
  { 0.0065911393574607175, 3.0000000000000000, 0.0 },
  { 0.0025840987869896349, 3.5000000000000000, 0.0 },
  { 0.00095156385120480195, 4.0000000000000000, 0.0 },
  { 0.00033025032351430934, 4.5000000000000000, 0.0 },
  { 0.00010834442813607434, 5.0000000000000000, 0.0 },
  { 3.3685311908599812e-05, 5.5000000000000000, 0.0 },
  { 9.9476943602528973e-06, 6.0000000000000000, 0.0 },
  { 2.7958823432049148e-06, 6.5000000000000000, 0.0 },
  { 7.4921288639971570e-07, 7.0000000000000000, 0.0 },
  { 1.9172560675134295e-07, 7.5000000000000000, 0.0 },
  { 4.6922076160992236e-08, 8.0000000000000000, 0.0 },
  { 1.0997009755195515e-08, 8.5000000000000000, 0.0 },
  { 2.4711684308724904e-09, 9.0000000000000000, 0.0 },
  { 5.3302637046174900e-10, 9.5000000000000000, 0.0 },
  { 1.1047532552898652e-10, 10.000000000000000, 0.0 },
};
const double toler001 = 5.0000000000000029e-12;

template<typename Ret, unsigned int Num>
  void
  test(const testcase_airy_ai<Ret> (&data)[Num], Ret toler)
  {
    bool test __attribute__((unused)) = true;
    const Ret eps = std::numeric_limits<Ret>::epsilon();
    Ret max_abs_diff = -Ret(1);
    Ret max_abs_frac = -Ret(1);
    unsigned int num_datum = Num;
    for (unsigned int i = 0; i < num_datum; ++i)
      {
	const Ret f = __gnu_cxx::airy_ai(data[i].x);
	const Ret f0 = data[i].f0;
	const Ret diff = f - f0;
	if (std::abs(diff) > max_abs_diff)
	  max_abs_diff = std::abs(diff);
	if (std::abs(f0) > Ret(10) * eps
	 && std::abs(f) > Ret(10) * eps)
	  {
	    const Ret frac = diff / f0;
	    if (std::abs(frac) > max_abs_frac)
	      max_abs_frac = std::abs(frac);
	  }
      }
    VERIFY(max_abs_frac < toler);
  }

int
main()
{
  test(data001, toler001);
  return 0;
}
