/*
 * Decompiled with CFR 0.152.
 */
package geotrans3.gui;

import geotrans3.exception.CoordinateConversionException;
import geotrans3.gui._3ParamDatumPanel;
import geotrans3.gui._7ParamDatumPanel;
import geotrans3.jni.JNICoordinateConversionService;
import geotrans3.jni.JNIDatumLibrary;
import geotrans3.jni.JNIEllipsoidLibrary;
import geotrans3.utility.Platform;
import geotrans3.utility.Utility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;

public class CreateDatumDlg
extends JDialog {
    private _3ParamDatumPanel __3ParamDatumPanel;
    private _7ParamDatumPanel __7ParamDatumPanel;
    private boolean datumCreated;
    private JPanel buttonsPanel;
    private JButton cancelButton;
    private JTabbedPane createDatumTabbedPane;
    private JButton okButton;
    private JPanel okCancelPanel;
    private JSeparator okCancelSeparator;

    public CreateDatumDlg(JNICoordinateConversionService jNICoordinateConversionService, Frame frame, boolean bl) throws CoordinateConversionException {
        super(frame, bl);
        JNIDatumLibrary jNIDatumLibrary = new JNIDatumLibrary(jNICoordinateConversionService.getDatumLibrary());
        JNIEllipsoidLibrary jNIEllipsoidLibrary = new JNIEllipsoidLibrary(jNICoordinateConversionService.getEllipsoidLibrary());
        this.__3ParamDatumPanel = new _3ParamDatumPanel(jNIDatumLibrary, jNIEllipsoidLibrary);
        this.__7ParamDatumPanel = new _7ParamDatumPanel(jNIDatumLibrary, jNIEllipsoidLibrary);
        this.datumCreated = false;
        this.initComponents();
        this.createDatumTabbedPane.addTab("3 Parameter Datum", this.__3ParamDatumPanel);
        this.createDatumTabbedPane.addTab("7 Parameter Datum", this.__7ParamDatumPanel);
        if (Platform.isUnix) {
            this.okButton.setFont(new Font("Dialog", 1, 10));
            this.cancelButton.setFont(new Font("Dialog", 1, 10));
            this.okButton.setMaximumSize(new Dimension(21, 19));
            this.okButton.setMinimumSize(new Dimension(21, 19));
            this.okButton.setPreferredSize(new Dimension(21, 19));
            this.cancelButton.setMaximumSize(new Dimension(43, 19));
            this.cancelButton.setMinimumSize(new Dimension(43, 19));
            this.cancelButton.setPreferredSize(new Dimension(43, 19));
        }
        this.pack();
        Utility.center(frame, this);
    }

    private void initComponents() {
        this.createDatumTabbedPane = new JTabbedPane();
        this.okCancelPanel = new JPanel();
        this.okCancelSeparator = new JSeparator();
        this.buttonsPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setTitle("Create Datum");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CreateDatumDlg.this.closeDialog(windowEvent);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.createDatumTabbedPane.setMinimumSize(new Dimension(435, 350));
        this.createDatumTabbedPane.setPreferredSize(new Dimension(435, 350));
        this.getContentPane().add((Component)this.createDatumTabbedPane, new GridBagConstraints());
        this.okCancelPanel.setLayout(new GridLayout(2, 1));
        this.okCancelSeparator.setForeground(Color.black);
        this.okCancelPanel.add(this.okCancelSeparator);
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.okButton.setMnemonic(79);
        this.okButton.setText("OK");
        this.okButton.setBorder(BorderFactory.createBevelBorder(0));
        this.okButton.setMaximumSize(new Dimension(19, 22));
        this.okButton.setMinimumSize(new Dimension(19, 22));
        this.okButton.setOpaque(false);
        this.okButton.setPreferredSize(new Dimension(19, 22));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateDatumDlg.this.okActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 55;
        gridBagConstraints.insets = new Insets(0, 0, 1, 35);
        this.buttonsPanel.add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setMnemonic(67);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setBorder(BorderFactory.createBevelBorder(0));
        this.cancelButton.setMaximumSize(new Dimension(37, 22));
        this.cancelButton.setMinimumSize(new Dimension(37, 22));
        this.cancelButton.setPreferredSize(new Dimension(37, 22));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateDatumDlg.this.cancelActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 30;
        gridBagConstraints.insets = new Insets(0, 35, 1, 0);
        this.buttonsPanel.add((Component)this.cancelButton, gridBagConstraints);
        this.okCancelPanel.add(this.buttonsPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 7, 0);
        this.getContentPane().add((Component)this.okCancelPanel, gridBagConstraints);
    }

    private void cancelActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
        this.datumCreated = false;
    }

    private void okActionPerformed(ActionEvent actionEvent) {
        this.datumCreated = false;
        int n = this.createDatumTabbedPane.getSelectedIndex();
        this.datumCreated = n == 0 ? this.__3ParamDatumPanel.createDatum() : this.__7ParamDatumPanel.createDatum();
        if (this.datumCreated) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void ellipsoidComboBoxActionPerformed(ActionEvent actionEvent) {
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
        this.datumCreated = false;
    }

    public static void main(String[] stringArray) {
    }

    public boolean getDatumCreated() {
        return this.datumCreated;
    }
}

