/*******************************************************************************
*
*       This file is part of the General Hidden Markov Model Library,
*       GHMM version __VERSION__, see http://ghmm.org
*
*       Filename: ghmm/ghmm/sgenerate.h
*       Authors:  Bernhard Knab, Benjamin Georgi
*
*       Copyright (C) 1998-2004 Alexander Schliep 
*       Copyright (C) 1998-2001 ZAIK/ZPR, Universitaet zu Koeln
*	Copyright (C) 2002-2004 Max-Planck-Institut fuer Molekulare Genetik, 
*                               Berlin
*                                   
*       Contact: schliep@ghmm.org             
*
*       This library is free software; you can redistribute it and/or
*       modify it under the terms of the GNU Library General Public
*       License as published by the Free Software Foundation; either
*       version 2 of the License, or (at your option) any later version.
*
*       This library is distributed in the hope that it will be useful,
*       but WITHOUT ANY WARRANTY; without even the implied warranty of
*       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*       Library General Public License for more details.
*
*       You should have received a copy of the GNU Library General Public
*       License along with this library; if not, write to the Free
*       Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
*
*       This file is version $Revision: 2262 $ 
*                       from $Date: 2009-04-22 09:44:25 -0400 (Wed, 22 Apr 2009) $
*             last change by $Author: grunau $.
*
*******************************************************************************/
#ifndef GHMM_SGENERATE_H
#define GHMM_SGENERATE_H


#include "smodel.h"
#include "sequence.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
   @name generation and extension of sequences from shmm
*/

/*@{
 */

/**
 Help "modus" for sgenerate_extensions.
*/

  typedef enum {
    viterbi_viterbi,
    viterbi_all,
    all_viterbi,
    all_all
  } sgeneration_mode_t;

/**
   Makes part sequences longer given a model. There are some different possibilities
   to do this (only Viterbi or take all paths into account, combined with 
   sequence begin and end).

   Which method to use (@todo ?only all_all implemented):
   0 = viterbi_viterbi, 
   1 = viterbi_all, 
   2 = all_viterbi, 
   3 = all_all

   @return pointer to a vector of all sequences (given initial sequence and
           generated end sequence)
   @param smo:         given Model
   @param sqd_short:   vector of initial sequences
   @param seed:        initial value for random value generator (int)
   @param global_len:  wanted length of sequences (=0: automatically over final
                       states)
   @param mode:        which method to use for the generator
 */
  ghmm_cseq *ghmm_sgenerate_extensions (ghmm_cmodel * smo, ghmm_cseq * sqd_short,
                                      int seed, int global_len,
                                      sgeneration_mode_t mode);


/** 
    Makes one sequences longer given a model. See ghmm_sgenerate_extensions()
    for details.
    @return pointer to the whole sequence
    @param smo:        model
    @param O:          given sequence to make longer
    @param len:        original length of sequence
    @param new_len:    wanted length of sequence
    @param alpha:
    @param mode:
*/
  double *ghmm_sgenerate_single_ext (ghmm_cmodel * smo, double *O, const int len,
                                int *new_len, double **alpha,
                                sgeneration_mode_t mode);


/** Generate a single next value based on a trained model and on a seq of
   length "len". Use the most prob. state given the seq as an initial state
   and determin the next state und the symbol with the RNG. 
   @param smo:        given model
   @param O:          given sequence 
   @param len:        length of sequence
*/
  double ghmm_sgenerate_next_value (ghmm_cmodel * smo, double *O, const int len);

/*@} sgenerate section */

#ifdef __cplusplus
}
#endif
#endif                          /* GHMM_SGENERATE_H */
