/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
 
/*
 * $Header: /cvs/glassfish/appserv-api/src/java/com/sun/appserv/management/j2ee/statistics/TimeStatisticImpl.java,v 1.2 2007/05/05 05:30:52 tcfujii Exp $
 * $Revision: 1.2 $
 * $Date: 2007/05/05 05:30:52 $
 */

package com.sun.appserv.management.j2ee.statistics;

import java.util.Map;
import java.io.Serializable;

import javax.management.openmbean.CompositeData;

import javax.management.j2ee.statistics.TimeStatistic;

import com.sun.appserv.management.util.jmx.OpenMBeanUtil;


/**
	
 */
public final class TimeStatisticImpl
	extends StatisticImpl implements TimeStatistic, Serializable
{
	static final long serialVersionUID = 1090185734375468511L;
	
	/* member names as defined by JSR 77 */
	private final long	Count;
	private final long	MinTime;
	private final long	MaxTime;
	private final long	TotalTime;
	
		public
	TimeStatisticImpl( final CompositeData compositeData )
	{
		this( OpenMBeanUtil.compositeDataToMap( compositeData ) );
	}
	
		public
	TimeStatisticImpl( final Map<String,?> m )
	{
		this( new MapStatisticImpl( m ) );
	}
	
		public
	TimeStatisticImpl( final TimeStatistic s )
	{
		super( s );
		
		Count		= s.getCount();
		MinTime		= s.getMinTime();
		MaxTime		= s.getMaxTime();
		TotalTime	= s.getTotalTime();
	}
	
		public
	TimeStatisticImpl( final MapStatistic s )
	{
		super( s );
		
		Count		= s.getlong( "Count" );
		MinTime		= s.getlong( "MinTime" );
		MaxTime		= s.getlong( "MaxTime" );
		TotalTime	= s.getlong( "TotalTime" );
	}
	
		public
	TimeStatisticImpl(
		final String	name,
		final String	description,
		final String	unit,
		final long		startTime,
		final long		lastSampleTime,
		final long		count,
		final long		maxTime,
		final long		minTime,
		final long		totalTime )
	{
		super( name, description, unit, startTime, lastSampleTime );
		Count		= count;
		MaxTime		= maxTime;
		MinTime		= minTime;
		TotalTime	= totalTime;
	}


 		public long
 	getCount()
 	{
 		return( Count );
 	}

 		public long
 	getMaxTime()
 	{
 		return( MaxTime );
 	}

 		public long
 	getMinTime()
 	{
 		return( MinTime );
 	}

 		public long
 	getTotalTime()
 	{
 		return( TotalTime );
 	}
}





