/*
 * Copyright 2008 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.gmetrics.metricset

import org.gmetrics.test.AbstractTestCase

/**
 * Tests for DefaultMetricSet
 *
 * @author Chris Mair
 * @version $Revision: 79 $ - $Date: 2010-02-20 21:51:05 -0500 (Sat, 20 Feb 2010) $
 */
class DefaultMetricSetTest extends AbstractTestCase {

    void testThatDefaultContentsAreCorrect() {
        def metricSet = new DefaultMetricSet()
        def metrics = metricSet.getMetrics()
        assert metrics.name == ['CyclomaticComplexity', 'ClassLineCount', 'MethodLineCount']
    }
}