.\" Copyright (c) 2004 Free Software Foundation, Inc.
.\" See section COPYING for conditions for redistribution
.\" getclose, Find PRs fixed in a particular release, Chad Walstrom
.\" <chewie@wookimus.net>
.TH getclose 8 "April 2004" "GNATS @VERSION@" "GNATS User Utilities"
.de BP
.sp
.ti -.2i
\(**
..
.SH NAME
getclose \- Find PRs fixed in a particular release
.SH SYNOPSIS
.hy 0
.na
.B getclose
.BI [OPTIONS]
.BI MIGRATION 
.BI FREEZE
.BI LASTFREEZE
.ad b
.hy 1
.SH DESCRIPTION
\fBgetclose\fR uses the three dates specified on the commandline to find and
label PRs fixed in a particular release.
.TP
.B MIGRATION\fR \-\- the date of the migration for the current release
.TP
.B FREEZE\fR \-\- the date of the freeze for the current release
.TP
.B LASTFREEZE\fR \-\- the date of the freeze for the previous release
.P
.SH RESULTS
FIXED:foo:1234:the synopsis
.br
MAYBE:bar:1235:the synopsis
.P
Those marked \fBFIXED\fR were closed before the migration into the
current release. Those marked as \fBMAYBE\fR were closed after the
migration, but before the freeze; thus, the fix may or may not have
made it into the current release.  These need to be researched to find
out if the changes, if any, were included.
.SH OPTIONS
.TP 1i
.B -h\fR,\fB --help
Prints a brief usage message for
.BR getclose .
.TP
.B -V\fR,\fB --version
Prints the version number for
.BR getclose .
.TP
.B -d DATABASE\fR,\fB --database=DATABASE
Specifies the database containing the PR to be edited; if no database is
specified, the database named \fIdefault\fR is assumed.  This option
overrides the database specified in the \fBGNATSDB\fR environment variable.
.SS
GNATS network options:
.TP
.B -H HOSTNAME\fR,\fB --host=HOSTNAME
Hostname of the GNATS server.
.TP
.B -P PORT\fR,\fB --port=PORT
The port that the GNATS server runs on.
.TP
.B -v USERNAME\fR,\fB --username=USERNAME
Username used to log into the GNATS server.
.TP
.B -w PASSWORD\fR,\fB --passwd=PASSWORD
Password used to log into the GNATS server.
.B
.SH ENVIRONMENT VARIABLES
The \fBGNATSDB\fR environment variable is used to determine which database to
use.  For a local database, it contains the name of the database to access.
.P
For network access via \fIgnatsd\fR, it contains a colon-separated list
of strings that describe the remote database, in the form
.TP
\fIserver\fR:\fIport\fR:\fIdatabasename\fR:\fIusername\fR:\fIpassword\fR
.P
Any of the fields may be omitted, but at least one colon must appear;
otherwise, the value is assumed to be the name of a local database.
.P
If \fBGNATSDB\fR is not set, it is assumed that the database is local
and that its name is \fIdefault\fR.
.SH "SEE ALSO"
.I Keeping Track: Managing Messages With GNATS
(also installed as the GNU Info file
.BR gnats.info )
.LP
.BR databases (5),
.BR dbconfig (5),
.BR delete-pr (8),
.BR edit-pr (1)
.BR file-pr (8),
.BR gen-index (8),
.BR gnats (7),
.BR gnatsd (8),
.BR mkcat (8),
.BR mkdb (8),
.BR pr-edit (8),
.BR query-pr (1),
.BR queue-pr (8),
.BR send-pr (1).
.SH COPYING
Copyright (c) 2004 Free Software Foundation, Inc.
.PP
Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.
.PP
Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.
.PP
Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
