.\" Copyright (c) 1993, 94, 95, 96, 1997, 1999, 2003 Free Software Foundation, Inc.
.\" See section COPYING for conditions for redistribution .in +0.9i
.TH query-pr 1 "August 2003" "GNATS @VERSION@" "GNATS User Utilities"
.de BP
.sp
.ti -.2i
\(**
..
.SH NAME
query-pr \- query problem reports in the GNATS database
.SH SYNOPSIS
.hy 0
.na
.B query\-pr
.RS
[\fB\-\-output\fR\ \fIfile\fR\ |\ \fB\-o\fR\ \fIfile\fR]
.br
[\fB\-\-list\-databases\fR]
[\fB\-\-list\-fields\fR]
[\fB\-\-list\-input\-fields\fR]
.br
[\fB\-\-responsible\-address\fR\ \fIaddress\fR]
.br
[\fB\-\-field\-type\fR\ \fItype\fR]
.br
[\fB\-\-field\-description\fR\ \fIdescription\fR]
.br
[\fB\-\-valid\-values\fR\ \fIvalues\fR]
.br
[\fB\-\-format\fR\ \fIformat\fR\ |\ \fB\-f\fR\ \fIformat\fR]
.br
[\fB\-\-full\fR\ |\ \fB\-F\fR]
[\fB\-\-summary\fR\ |\ \fB\-q\fR]
.br
[\fB\-\-database\fR\ \fIdatabase\fR\ |\ \fB\-d\fR\ \fIdatabase\fR]
.br
[\fB\-\-and\fR\ |\ \fB\-&\fR]
[\fB\-\-or\fR\ |\ \fB\-|\fR]
.br
[\fB\-\-expr\fR\ \fIexpr\fR]
.br
[\fB\-\-debug\fR\ |\ \fB\-D\fR]
.br
[\fB\-\-help\fR\ |\ \fB\-h\fR]
[\fB\-\-version\fR\ |\ \fB\-V\fR]
.br
[\fIPR .\|.\|.\fR]
.SS Non-network-mode options:
.RS
[\fB\-\-print\-sh\-vars\fR]
[\fB\-\-print\-directory\-for\-database\fR]
.SS Network-mode-only options:
.RS
[\fB\-\-host\fR\ \fIhost\fR\ |\ \fB\-H\fR\ \fIhost\fR]
[\fB\-\-port\fR\ \fIport\fR]
[\fB\-\-user\fR\ \fIuser\fR\ |\ \fB\-v\fR\ \fIuser\fR]
[\fB\-\-passwd\fR\ \fIpasswd\fR\ |\ \fB\-w\fR\ \fIpasswd\fR]
.SS Deprecated Options
.RS
[\fB\-\-list\-categories\fR\ |\ \fB\-j\fR]
[\fB\-\-list\-classes\fR\ |\ \fB\-J\fR]
[\fB\-\-list\-responsible\fR\ |\ \fB\-k\fR]
[\fB\-\-list\-submitters\fR\ |\ \fB\-l\fR]
[\fB\-\-list\-states\fR\ |\ \fB\-T\fR]
[\fB\-\-category\fR\ \fIcategory\fR\ |\ \fB\-c\fR\ \fIcategory\fR]
[\fB\-\-synopsis\fR\ \fIsynopsis\fR\ |\ \fB\-y\fR\ \fIsynopsis\fR]
[\fB\-\-confidential\fR\ \fIconfidential\fR\ |\ \fB\-C\fR\ \fIconfidential\fR]
[\fB\-\-multitext\fR\ \fImultitext\fR\ |\ \fB\-m\fR\ \fImultitext\fR]
[\fB\-\-originator\fR\ \fIoriginator\fR\ |\ \fB\-O\fR\ \fIoriginator\fR]
[\fB\-\-release\fR\ \fIrelease\fR\ |\ \fB\-A\fR\ \fIrelease\fR]
[\fB\-\-class\fR\ \fIclass\fR\ |\ \fB\-L\fR\ \fIclass\fR]
[\fB\-\-cases\fR\ \fIcases\fR\ |\ \fB\-E\fR\ \fIcases\fR]
[\fB\-\-quarter\fR\ \fIquarter\fR\ |\ \fB\-Q\fR\ \fIquarter\fR]
[\fB\-\-keywords\fR\ \fIkeywords\fR\ |\ \fB\-K\fR\ \fIkeywords\fR]
[\fB\-\-priority\fR\ \fIpriority\fR\ |\ \fB\-p\fR\ \fIpriority\fR]
[\fB\-\-responsible\fR\ \fIresponsible\fR\ |\ \fB\-r\fR\ \fIresponsible\fR]
[\fB\-\-restricted\fR\ |\ \fB\-R\fR]
[\fB\-\-severity\fR\ \fIseverity\fR\ |\ \fB\-e\fR\ \fIseverity\fR]
[\fB\-\-skip\-closed\fR\ |\ \fB\-x\fR]
[\fB\-\-sql\fR\ |\ \fB\-i\fR]
[\fB\-\-sql2\fR\ |\ \fB\-I\fR]
[\fB\-\-state\fR\ \fIstate\fR\ |\ \fB\-s\fR\ \fIstate\fR]
[\fB\-\-submitter\fR\ \fIsubmitter\fR\ |\ \fB\-S\fR\ \fIsubmitter\fR]
[\fB\-\-text\fR\ \fItext\fR\ |\ \fB\-t\fR\ \fItext\fR]
[\fB\-\-required\-before\fR\ \fIdate\fR\ |\ \fB\-u\fR\ \fIdate\fR]
[\fB\-\-required\-after\fR\ \fIdate\fR\ |\ \fB\-U\fR\ \fIdate\fR]
[\fB\-\-arrived\-before\fR\ \fIdate\fR\ |\ \fB\-b\fR\ \fIdate\fR]
[\fB\-\-arrived\-after\fR\ \fIdate\fR\ |\ \fB\-a\fR\ \fIdate\fR]
[\fB\-\-modified\-before\fR\ \fIdate\fR\ |\ \fB\-B\fR\ \fIdate\fR]
[\fB\-\-modified\-after\fR\ \fIdate\fR\ |\ \fB\-M\fR\ \fIdate\fR]
[\fB\-\-closed\-before\fR\ \fIdate\fR\ |\ \fB\-z\fR\ \fIdate\fR]
[\fB\-\-closed\-after\fR\ \fIdate\fR\ |\ \fB\-Z\fR\ \fIdate\fR]
.ad b
.hy 1
.SH DESCRIPTION
Queries the 
.B GNATS
database according to options and returns either selected Problem
Reports (\fIPR\fRs) or other requested information.  \fBquery-pr\fR
can query \fIPR\fRs located in either a local database or via
\fBgnatsd\fR.
.LP
\fIPR\fRs may be selected via the use of the \fB\-\-expr\fR option,
directly by number, or by the use of the (now deprecated)
field-specific query operators.
.LP
By default, query options are connected with a logical
.BR AND .
For example,
.RS
\fBquery\-pr\fR \fB\-\-category=\fIfoo\fR \fB\-\-responsible=\fIbar\fR
.RE
only prints PRs which have a \fBCategory\fR field of \fIfoo\fR and a 
\fBResponsible\fR field of \fIbar\fR.
.LP
The
.B \-\-or
option may be used to connect query options with a logical \fBOR\fR. For
example,
.RS
\fBquery\-pr\fR \fB\-\-category=\fIbaz\fR \fB\-\-or\fR \fB\-\-responsible=\fIblee\fR
.RE
prints PRs which have either a \fBCategory\fR field of \fIbaz\fR \fIor\fR a
\fBResponsible\fR field of \fIblee\fR.
.LP
The use of these options is strongly discouraged, as they will be
deleted in the next release.  The expressions specified by the
\fB\-\-expr\fR option are much more flexible.
.SH OPTIONS
.TP 0.5i
\fB\-\-help\fR,\ \fB\-h\fR
Prints a (rather longish) help message.
.TP
\fB\-\-version\fR,\ \fB\-V\fR
Displays the program version to stdout.
.TP
\fB\-\-output\fR\ \fIfile\fR,\ \fB\-o\fR\ \fIfile\fR
The results of the query will be placed in this file.
.TP
\fB\-\-database\fR\ \fIdatabase\fR,\ \fB\-d\fR\ \fIdatabase\fR
Specifies the database to be used for the query.  If no database is
specified, the database named \fIdefault\fR is assumed.  (This option
overrides the database specified in the \fBGNATSDB\fR environment
variable; see the \fBENVIRONMENT VARIABLES\fR section for more
information.)
.TP
\fB\-\-list\-categories\fR,\ \fB\-j\fR
Lists the available \fIPR\fR categories for the selected database.  
.TP
\fB\-\-list\-classes\fR,\ \fB\-J\fR
Lists the available \fIPR\fR classes for the selected database.
.TP
\fB\-\-list\-responsible\fR,\ \fB\-k\fR
Lists the users that appear in the database's responsible list.
.TP
\fB\-\-list\-submitters\fR,\ \fB\-l\fR
Lists the valid submitters for this database.
.TP
\fB\-\-list\-states\fR,\ \fB\-T\fR
Lists the valid \fIPR\fR states for \fIPR\fRs in this database.
.PP
The previous \fB\-\-list-*\fR options are deprecated and will be removed in
the next release; their functionality can be replaced with
.RE
.PP
.RS 1.5i
\fBquery-pr\fR \fB\-\-valid-values\fR \fIfield\fR
.RE
.PP
where \fIfield\fR is one of \fBCategory\fR, \fBClass\fR, \fBResponsible\fR,
\fBSubmitter-Id\fR, or \fBState\fR.
.TP
\fB\-\-list\-databases\fR
Lists the known databases.
.TP
\fB\-\-list\-fields\fR
Lists the entire set of field names for \fIPR\fRs in the selected
database.
.TP
\fB\-\-list\-input\-fields\fR
Lists the fields that should be provided when creating a new \fIPR\fR
for the currently-specified database.  The fields are listed in an
order that would make sense when used in a template or form.
.TP
\fB\-\-field\-type\fR\ \fIfield\fR
Returns the data type contained in \fIPR\fR field \fIfield\fR.  The
current set of data types includes \fBtext\fR, \fBmultitext\fR,
\fBenum\fR, \fBmultienum\fR, \fBinteger\fR, \fBdate\fR, and
\fBtext-with-regex-qualifier\fR.
.TP
\fB\-\-field\-description\fR\ \fIfield\fR
Returns a human-readable description of the intended purpose of \fIfield\fR.
.TP
\fB\-\-valid\-values\fR\ \fIfield\fR
For fields of type \fBenum\fR, a list of valid values (one per line) is
returned.  Otherwise, a regular expression is returned that describes the
legal values in \fIfield\fR.
.TP
\fB\-\-responsible\-address\fR\ \fIname\fR
The mail address of \fIname\fR is returned; \fIname\fR is assumed to
be a name either appearing in the database's \fBresponsible\fR list,
or is otherwise a user on the system.
.TP
\fB\-\-print\-sh\-vars\fR
A set of \fI/bin/sh\fR variables is returned that describe the selected
database.  They include:
.RS
.TP
GNATSDB
The name of the currently-selected database.
.TP
GNATSDB_VALID
Set to 1 if the selected database is valid.
.TP
GNATSDBDIR
The directory where the database contents are stored.
.TP
DEBUG_MODE
Set to 1 if debug mode has been enabled for the database.
.TP
DEFAULTCATEGORY
The default category for \fIPR\fRs in the database.
.TP
DEFAULTSTATE
The default state for \fIPR\fRs in the database.
.RE
.TP
\fB\-\-print\-directory\-for\-database\fR
Returns the directory where the selected database is located.
.TP
\fB\-\-format\fR\ \fIformat\fR,\ \fB\-f\fR\ \fIformat\fR
Used to specify the format of the output \fIPR\fRs, See FORMATS below
for a complete description.
.TP
\fB\-\-full\fR,\ \fB\-F\fR
When printing \fIPR\fRs, the entre PR is displayed.  This is exactly
equivalent to
.PP
.RS 1i
\fBquery-pr\fR \fB\-\-format\fR \fBfull\fR
.RE
.TP
\fB\-\-summary\fR,\ \fB\-q\fR
When printing \fIPR\fRs, a summary format is used.  This is exactly 
equivalent to
.PP
.RS 1i
\fBquery-pr\fR \fB\-\-format\fR \fBsummary\fR
.RE
.TP
\fB\-\-debug\fR,\ \fB\-D\fR
Enables debugging output for network queries.
.TP
\fB\-\-host\fR\ \fIhost\fR,\ \fB\-H\fR\ \fIhost\fR
Specifies the hostname of the \fBgnatsd\fR server to communicate with.
This overrides the value in the \fBGNATSDB\fR environment variable.
.TP
\fB\-\-port\fR\ \fIport\fR
Specifies the port number of the \fBgnatsd\fR server to communicate with.
This overrides the value in the \fBGNATSDB\fR environment variable.
.TP
\fB\-\-user\fR\ \fIuser\fR,\ \fB\-v\fR\ \fIuser\fR
Specifies the username to login with when connecting to the \fBgnatsd\fR 
server.  This overrides the value in the \fBGNATSDB\fR environment variable.
.TP
\fB\-\-passwd\fR\ \fIpasswd\fR,\ \fB\-w\fR\ \fIpasswd\fR
Specifies the password to login with when connecting to the \fBgnatsd\fR 
server.  This overrides the value in the \fBGNATSDB\fR environment variable.
.TP
\fB\-\-and\fR,\ \fB\-&\fR, \fB\-\-or\fR,\ \fB\-|,\fR
These options are used when connecting multiple query operators together.
They specify whether the previous and subsequent options are to be logically
\fBAND\fRed or logically \fBOR\fRed.
.TP
\fB\-\-expr\fR\ \fIexpr\fR
Specifies a query expression to use when searching for PRs.  See the
\fBQUERY EXPRESSIONS\fR section.
.PP
The remaining deprecated options are not described here, since their
use is fairly obvious and their functionality is completely replaced
by the use of the \fB\-\-expr\fR option.  (Some sort of shorthand
option for querying fields may appear in the next release.)
.SH FORMATS
Printing formats for \fIPR\fRs are in one of three forms:
.TP
\fBformatname\fR
This is a \fInamed format\fR which is described by the database
(specifically, these formats are described in the \fIdbconfig\fR
file associated with the database).  The default configuration
contains five such formats: \fIstandard\fR, \fIfull\fR, \fIsummary\fR,
\fIsql\fR, and \fIsql2\fR.
.PP
.RS
The first three are the ones most commonly used when performing queries.
\fIstandard\fR is the format used by default if no other format is specified.
.PP
Use of the latter two are discouraged; they are merely kept for historical
purposes.
.PP
Other named formats may have been added by the database administrator.
.RE
.TP
\fBfieldname\fR
A single field name may appear here.  Only the contents of this field will
be displayed.
.TP
\'"\fIprintf string\fR" \fIfieldname\fR \fIfieldname\fR . . .\'

This provides a rather flexible mechanism for formatting \fIPR\fR
output.  (The formatting is identical to that provided by the named
formats described by the database configuration.)  The printf string
can contain the following % sequences:
.PP
.RS
\fB%[positionalspecifiers]s\fR:  Prints the field as a string.  The positional
specifiers are similar to those of printf, as +, - and digit qualifiers
can be used to force a particular alignment of the field contents.
.PP
\fB%[positionalspecifiers]S\fR: Similar to %s, except that the field contents
are terminated at the first space character.
.PP
\fB%[positionalspecifiers]d\fR: Similar to %s, except that the field
contents are written as a numeric value.  For integer fields, the
value is written as a number.  For enumerated fields, the field is
converted into a numeric equivalent (i.e. if the field can have two
possible values, the result will be either 1 or 2).  For date fields,
the value is written as seconds since Jan 1, 1970.
.PP
\fB%F\fR: The field is written as it would appear within a \fIPR\fR,
complete with field header.
.PP
\fB%D\fR: For date fields, the date is written in a standard GNATS format.
.PP
\fB%Q\fR: For date fields, the date is written in an arbitrary "SQL" format.
.PP
An example printf formatted query (note the quoting of the whole
format specification):
.PP
query-pr --format '"%s, %s" Synopsis State'
.RE
.SH QUERY EXPRESSIONS
Query expressions are used to select specific \fIPR\fRs based on their field
contents.  The general form is
.P
.RS
\fIfieldname\fR|"\fIvalue\fR" \fIoperator\fR \fIfieldname\fR|"\fIvalue\fR" [\fIbooleanop\fR ...]
.RE
.P
\fIvalue\fR is a literal string or regular expression; it must be
surrounded by double quotes, otherwise it is interpreted as a
\fIfieldname\fR.
.P
\fIfieldname\fR is the name of a field in the \fIPR\fR.
.P
\fIoperator\fR is one of:
.TP
\fI=\fR
The value of the left-hand side of the expression must exactly match
the regular expression on the right-hand side of the expression.
.TP
\fI~\fR
Some portion of the left-hand side of the expression must match the
regular expression on the right-hand side.
.TP
\fI==\fR
The value of the left-hand side must be equal to the value
on the right-hand side of the expression.
.RS
.PP
The equality of two values depends on what type of data is stored in
the field(s) being queried.  For example, when querying a field
containing integer values, literal strings are interpreted as
integers.  The query expression
.P
.RS
Number == "0123"
.RE
.P
is identical to
.P
.RS
Number == "123"
.RE
.P
as the leading zero is ignored.  If the values were treated as strings instead
of integers, then the two comparisons would return different results.
.RE
.TP
\fI!=\fR
The not-equal operator. Produces the opposite result of the \fI==\fR
operator.
.TP
\fI<\fR,\fI>\fR
The left-hand side must have a value less than or greater than the
right-hand side.  Comparisons are done depending on the type of data
being queried; in particular, integer fields and dates use a numeric
comparison, and enumerated fields are ordered depending on the numeric
equivalent of their enumerated values.
.PP
\fIbooleanop\fR is either | [or], or & [and].  The query expression
.RS
Category="baz" | Responsible="blee"
.RE
is identical to the second query example with \fB\-\-or\fR given earlier;
it selects all \fIPR\fRs with a Category field of \fIbaz\fR or a Responsible
field of \fIblee\fR.
.PP
The not operator \fI!\fR may be used to negate a test:
.RS
! Category="foo"
.RE
searches for \fIPR\fRs where the category is \fInot\fR equal to the 
regular expression \fIfoo\fR.
.PP
Parenthesis may be used to force a particular interpretation of the
expression:
.RS
!(Category="foo" & Submitter-Id="blaz")
.RE
skips \fIPR\fRs where the \fBCategory\fR field is equal to \fIfoo\fR and the
\fBSubmitter-Id\fR field is equal to \fIblaz\fR.  Parenthesis may be
nested to any arbitrary depth.
.P
Fieldnames can be specified in several ways.  The simplest and most obvious
is just a name:
.RS
Category="foo"
.RE
checks the value of the category field for the value "foo".  
.P
A fieldname qualifier may be prepended to the name of the field; a
colon is used to separate the qualifier from the name.  To refer
directly to a builtin field name:
.P
.RS
builtin:Number="123"
.RE
.P
In this case, \fINumber\fR is interpreted as the builtin name of the field
to check.  (This is useful if the fields have been renamed.  For more
discussion of builtin field names, see dbconfig(5).)
.P
To scan all fields of a particular type, the \fIfieldtype\fR qualifier may
be used:
.P
.RS
fieldtype:Text="bar"
.RE
.P
searches all text fields for the regular expression \fIbar\fR.
.P
Note that it is not necessary that the right-hand side of the expression be
a literal string.  To query all \fIPR\fRs where the \fIPR\fR has been modified 
since it was closed, the expression
.P
.RS
Last-Modified != Closed-Date
.RE
.P
will work; for each \fIPR\fR, it compares the value of its Last-Modified
field against its Closed-Date field, and returns those \fIPR\fRs where the
values differ.  However, this query will also return all \fIPR\fRs with
empty Last-Modified or Closed-Date fields.  To further narrow the
search:
.P
.RS
Last-Modified != Closed-Date & Last-Modified != "" & Closed-Date != ""
.RE
.P
In general, comparing fields of two different types (an integer field
against a date field, for example) will probably not do what you want.
.P
Also, a field specifier may be followed by the name of a subfield
in braces:
.P
.RS
State[type] != "closed"
.RE
.P
or even
.P
.RS
builtin:State[type] != "closed"
.RE
.P
Subfields are further discussed in dbconfig(5).

.SH QUERY BY MAIL
.B query-pr
can also be accessed by electronic mail, if your version
of GNATS is configured for this.  To use this feature, simply send
mail to the address 
.BI query-pr@ your-site
with command line arguments or options in the 
.B Subject:
line of the mail header.  GNATS replies to your mail with the results
of your query.  The default settings for the
.B query-pr
mail server are shown below; to override the
.B \-\-state
parameter, specify
.BI \-\-state= state
in the
.B Subject:
line of the mail header.  You can not query on confidential Problem
Reports by mail.
.TP 1i
.B \-\-restricted \-\-state="open|analyzed|feedback|suspended"
.SH ENVIRONMENT VARIABLES
The \fBGNATSDB\fR environment variable is used to determine which database to
use.  For a local database, it contains the name of the database to access.
.P
For network access via \fIgnatsd\fR, it contains a colon-separated list
of strings that describe the remote database in the form
.TP
\fIserver\fR:\fIport\fR:\fIdatabasename\fR:\fIusername\fR:\fIpassword\fR
.P
Any of the fields may be omitted except for \fIserver\fR, but at
least one colon must appear; otherwise, the value is assumed to be the
name of a local database.
.P
If \fBGNATSDB\fR is not set, it is assumed that the database is local
and that its name is \fIdefault\fR.
.SH "SEE ALSO"
.I Keeping Track: Managing Messages With GNATS
(also installed as the GNU Info file
.BR gnats.info )
.LP
.BR databases (5),
.BR dbconfig (5),
.BR delete-pr (8),
.BR edit-pr (1)
.BR file-pr (8),
.BR gen-index (8),
.BR gnats (7),
.BR gnatsd (8),
.BR mkcat (8),
.BR mkdb (8),
.BR pr-edit (8),
.BR query-pr (1),
.BR queue-pr (8),
.BR send-pr (1).
.SH COPYING
Copyright (c) 1993, 94, 95, 96, 1997, 1999, 2003, Free Software Foundation, Inc.
.PP
Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.
.PP
Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.
.PP
Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
