=begin  
  misc.rb
    Copyright (c) 2004 by Jesse van den Kieboom <jesse@icecrew.nl>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
	Defines:
	  open - open a world
	  sendall - send all connected worlds the same text
=end

def register_functions
  $scripts.register("open", "use: /open <worldname>\nopen a world")
  $scripts.register("sendall", "use: /sendall <some>\nsends <some> to all currently connected worlds")
  $scripts.register("sendfile", "use: /sendfile <file-on-disk>\nsends contents of <file-on-disk> to world")
end

def open(argstr)
  $client.open(argstr)
end

def sendall(argstr)
  $client.worlds.each {|wld|
    if (wld.loaded? && wld.connected?)
      wld.sendln(argstr) 
    end
  }
end

def sendfile(argstr)
  if FileTest.exists?(argstr)
    lines = IO.readlines(argstr)
    $world.writeln("Sending contents of file #{argstr} (#{lines.length})")
    lines.each do |line|
      $world.sendln(line.chomp)
    end
  else
    $world.writeln("File #{argstr} does not exist!")
  end
end
