// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package hook

import (
	"context"
	"fmt"

	"entgo.io/ent/entc/integration/customid/ent"
)

// The AccountFunc type is an adapter to allow the use of ordinary
// function as Account mutator.
type AccountFunc func(context.Context, *ent.AccountMutation) (ent.Value, error)

// Mutate calls f(ctx, m).
func (f AccountFunc) Mutate(ctx context.Context, m ent.Mutation) (ent.Value, error) {
	mv, ok := m.(*ent.AccountMutation)
	if !ok {
		return nil, fmt.Errorf("unexpected mutation type %T. expect *ent.AccountMutation", m)
	}
	return f(ctx, mv)
}

// The BlobFunc type is an adapter to allow the use of ordinary
// function as Blob mutator.
type BlobFunc func(context.Context, *ent.BlobMutation) (ent.Value, error)

// Mutate calls f(ctx, m).
func (f BlobFunc) Mutate(ctx context.Context, m ent.Mutation) (ent.Value, error) {
	mv, ok := m.(*ent.BlobMutation)
	if !ok {
		return nil, fmt.Errorf("unexpected mutation type %T. expect *ent.BlobMutation", m)
	}
	return f(ctx, mv)
}

// The BlobLinkFunc type is an adapter to allow the use of ordinary
// function as BlobLink mutator.
type BlobLinkFunc func(context.Context, *ent.BlobLinkMutation) (ent.Value, error)

// Mutate calls f(ctx, m).
func (f BlobLinkFunc) Mutate(ctx context.Context, m ent.Mutation) (ent.Value, error) {
	mv, ok := m.(*ent.BlobLinkMutation)
	if !ok {
		return nil, fmt.Errorf("unexpected mutation type %T. expect *ent.BlobLinkMutation", m)
	}
	return f(ctx, mv)
}

// The CarFunc type is an adapter to allow the use of ordinary
// function as Car mutator.
type CarFunc func(context.Context, *ent.CarMutation) (ent.Value, error)

// Mutate calls f(ctx, m).
func (f CarFunc) Mutate(ctx context.Context, m ent.Mutation) (ent.Value, error) {
	mv, ok := m.(*ent.CarMutation)
	if !ok {
		return nil, fmt.Errorf("unexpected mutation type %T. expect *ent.CarMutation", m)
	}
	return f(ctx, mv)
}

// The DeviceFunc type is an adapter to allow the use of ordinary
// function as Device mutator.
type DeviceFunc func(context.Context, *ent.DeviceMutation) (ent.Value, error)

// Mutate calls f(ctx, m).
func (f DeviceFunc) Mutate(ctx context.Context, m ent.Mutation) (ent.Value, error) {
	mv, ok := m.(*ent.DeviceMutation)
	if !ok {
		return nil, fmt.Errorf("unexpected mutation type %T. expect *ent.DeviceMutation", m)
	}
	return f(ctx, mv)
}

// The DocFunc type is an adapter to allow the use of ordinary
// function as Doc mutator.
type DocFunc func(context.Context, *ent.DocMutation) (ent.Value, error)

// Mutate calls f(ctx, m).
func (f DocFunc) Mutate(ctx context.Context, m ent.Mutation) (ent.Value, error) {
	mv, ok := m.(*ent.DocMutation)
	if !ok {
		return nil, fmt.Errorf("unexpected mutation type %T. expect *ent.DocMutation", m)
	}
	return f(ctx, mv)
}

// The GroupFunc type is an adapter to allow the use of ordinary
// function as Group mutator.
type GroupFunc func(context.Context, *ent.GroupMutation) (ent.Value, error)

// Mutate calls f(ctx, m).
func (f GroupFunc) Mutate(ctx context.Context, m ent.Mutation) (ent.Value, error) {
	mv, ok := m.(*ent.GroupMutation)
	if !ok {
		return nil, fmt.Errorf("unexpected mutation type %T. expect *ent.GroupMutation", m)
	}
	return f(ctx, mv)
}

// The IntSIDFunc type is an adapter to allow the use of ordinary
// function as IntSID mutator.
type IntSIDFunc func(context.Context, *ent.IntSIDMutation) (ent.Value, error)

// Mutate calls f(ctx, m).
func (f IntSIDFunc) Mutate(ctx context.Context, m ent.Mutation) (ent.Value, error) {
	mv, ok := m.(*ent.IntSIDMutation)
	if !ok {
		return nil, fmt.Errorf("unexpected mutation type %T. expect *ent.IntSIDMutation", m)
	}
	return f(ctx, mv)
}

// The LinkFunc type is an adapter to allow the use of ordinary
// function as Link mutator.
type LinkFunc func(context.Context, *ent.LinkMutation) (ent.Value, error)

// Mutate calls f(ctx, m).
func (f LinkFunc) Mutate(ctx context.Context, m ent.Mutation) (ent.Value, error) {
	mv, ok := m.(*ent.LinkMutation)
	if !ok {
		return nil, fmt.Errorf("unexpected mutation type %T. expect *ent.LinkMutation", m)
	}
	return f(ctx, mv)
}

// The MixinIDFunc type is an adapter to allow the use of ordinary
// function as MixinID mutator.
type MixinIDFunc func(context.Context, *ent.MixinIDMutation) (ent.Value, error)

// Mutate calls f(ctx, m).
func (f MixinIDFunc) Mutate(ctx context.Context, m ent.Mutation) (ent.Value, error) {
	mv, ok := m.(*ent.MixinIDMutation)
	if !ok {
		return nil, fmt.Errorf("unexpected mutation type %T. expect *ent.MixinIDMutation", m)
	}
	return f(ctx, mv)
}

// The NoteFunc type is an adapter to allow the use of ordinary
// function as Note mutator.
type NoteFunc func(context.Context, *ent.NoteMutation) (ent.Value, error)

// Mutate calls f(ctx, m).
func (f NoteFunc) Mutate(ctx context.Context, m ent.Mutation) (ent.Value, error) {
	mv, ok := m.(*ent.NoteMutation)
	if !ok {
		return nil, fmt.Errorf("unexpected mutation type %T. expect *ent.NoteMutation", m)
	}
	return f(ctx, mv)
}

// The OtherFunc type is an adapter to allow the use of ordinary
// function as Other mutator.
type OtherFunc func(context.Context, *ent.OtherMutation) (ent.Value, error)

// Mutate calls f(ctx, m).
func (f OtherFunc) Mutate(ctx context.Context, m ent.Mutation) (ent.Value, error) {
	mv, ok := m.(*ent.OtherMutation)
	if !ok {
		return nil, fmt.Errorf("unexpected mutation type %T. expect *ent.OtherMutation", m)
	}
	return f(ctx, mv)
}

// The PetFunc type is an adapter to allow the use of ordinary
// function as Pet mutator.
type PetFunc func(context.Context, *ent.PetMutation) (ent.Value, error)

// Mutate calls f(ctx, m).
func (f PetFunc) Mutate(ctx context.Context, m ent.Mutation) (ent.Value, error) {
	mv, ok := m.(*ent.PetMutation)
	if !ok {
		return nil, fmt.Errorf("unexpected mutation type %T. expect *ent.PetMutation", m)
	}
	return f(ctx, mv)
}

// The RevisionFunc type is an adapter to allow the use of ordinary
// function as Revision mutator.
type RevisionFunc func(context.Context, *ent.RevisionMutation) (ent.Value, error)

// Mutate calls f(ctx, m).
func (f RevisionFunc) Mutate(ctx context.Context, m ent.Mutation) (ent.Value, error) {
	mv, ok := m.(*ent.RevisionMutation)
	if !ok {
		return nil, fmt.Errorf("unexpected mutation type %T. expect *ent.RevisionMutation", m)
	}
	return f(ctx, mv)
}

// The SessionFunc type is an adapter to allow the use of ordinary
// function as Session mutator.
type SessionFunc func(context.Context, *ent.SessionMutation) (ent.Value, error)

// Mutate calls f(ctx, m).
func (f SessionFunc) Mutate(ctx context.Context, m ent.Mutation) (ent.Value, error) {
	mv, ok := m.(*ent.SessionMutation)
	if !ok {
		return nil, fmt.Errorf("unexpected mutation type %T. expect *ent.SessionMutation", m)
	}
	return f(ctx, mv)
}

// The TokenFunc type is an adapter to allow the use of ordinary
// function as Token mutator.
type TokenFunc func(context.Context, *ent.TokenMutation) (ent.Value, error)

// Mutate calls f(ctx, m).
func (f TokenFunc) Mutate(ctx context.Context, m ent.Mutation) (ent.Value, error) {
	mv, ok := m.(*ent.TokenMutation)
	if !ok {
		return nil, fmt.Errorf("unexpected mutation type %T. expect *ent.TokenMutation", m)
	}
	return f(ctx, mv)
}

// The UserFunc type is an adapter to allow the use of ordinary
// function as User mutator.
type UserFunc func(context.Context, *ent.UserMutation) (ent.Value, error)

// Mutate calls f(ctx, m).
func (f UserFunc) Mutate(ctx context.Context, m ent.Mutation) (ent.Value, error) {
	mv, ok := m.(*ent.UserMutation)
	if !ok {
		return nil, fmt.Errorf("unexpected mutation type %T. expect *ent.UserMutation", m)
	}
	return f(ctx, mv)
}

// Condition is a hook condition function.
type Condition func(context.Context, ent.Mutation) bool

// And groups conditions with the AND operator.
func And(first, second Condition, rest ...Condition) Condition {
	return func(ctx context.Context, m ent.Mutation) bool {
		if !first(ctx, m) || !second(ctx, m) {
			return false
		}
		for _, cond := range rest {
			if !cond(ctx, m) {
				return false
			}
		}
		return true
	}
}

// Or groups conditions with the OR operator.
func Or(first, second Condition, rest ...Condition) Condition {
	return func(ctx context.Context, m ent.Mutation) bool {
		if first(ctx, m) || second(ctx, m) {
			return true
		}
		for _, cond := range rest {
			if cond(ctx, m) {
				return true
			}
		}
		return false
	}
}

// Not negates a given condition.
func Not(cond Condition) Condition {
	return func(ctx context.Context, m ent.Mutation) bool {
		return !cond(ctx, m)
	}
}

// HasOp is a condition testing mutation operation.
func HasOp(op ent.Op) Condition {
	return func(_ context.Context, m ent.Mutation) bool {
		return m.Op().Is(op)
	}
}

// HasAddedFields is a condition validating `.AddedField` on fields.
func HasAddedFields(field string, fields ...string) Condition {
	return func(_ context.Context, m ent.Mutation) bool {
		if _, exists := m.AddedField(field); !exists {
			return false
		}
		for _, field := range fields {
			if _, exists := m.AddedField(field); !exists {
				return false
			}
		}
		return true
	}
}

// HasClearedFields is a condition validating `.FieldCleared` on fields.
func HasClearedFields(field string, fields ...string) Condition {
	return func(_ context.Context, m ent.Mutation) bool {
		if exists := m.FieldCleared(field); !exists {
			return false
		}
		for _, field := range fields {
			if exists := m.FieldCleared(field); !exists {
				return false
			}
		}
		return true
	}
}

// HasFields is a condition validating `.Field` on fields.
func HasFields(field string, fields ...string) Condition {
	return func(_ context.Context, m ent.Mutation) bool {
		if _, exists := m.Field(field); !exists {
			return false
		}
		for _, field := range fields {
			if _, exists := m.Field(field); !exists {
				return false
			}
		}
		return true
	}
}

// If executes the given hook under condition.
//
//	hook.If(ComputeAverage, And(HasFields(...), HasAddedFields(...)))
func If(hk ent.Hook, cond Condition) ent.Hook {
	return func(next ent.Mutator) ent.Mutator {
		return ent.MutateFunc(func(ctx context.Context, m ent.Mutation) (ent.Value, error) {
			if cond(ctx, m) {
				return hk(next).Mutate(ctx, m)
			}
			return next.Mutate(ctx, m)
		})
	}
}

// On executes the given hook only for the given operation.
//
//	hook.On(Log, ent.Delete|ent.Create)
func On(hk ent.Hook, op ent.Op) ent.Hook {
	return If(hk, HasOp(op))
}

// Unless skips the given hook only for the given operation.
//
//	hook.Unless(Log, ent.Update|ent.UpdateOne)
func Unless(hk ent.Hook, op ent.Op) ent.Hook {
	return If(hk, Not(HasOp(op)))
}

// FixedError is a hook returning a fixed error.
func FixedError(err error) ent.Hook {
	return func(ent.Mutator) ent.Mutator {
		return ent.MutateFunc(func(context.Context, ent.Mutation) (ent.Value, error) {
			return nil, err
		})
	}
}

// Reject returns a hook that rejects all operations that match op.
//
//	func (T) Hooks() []ent.Hook {
//		return []ent.Hook{
//			Reject(ent.Delete|ent.Update),
//		}
//	}
func Reject(op ent.Op) ent.Hook {
	hk := FixedError(fmt.Errorf("%s operation is not allowed", op))
	return On(hk, op)
}

// Chain acts as a list of hooks and is effectively immutable.
// Once created, it will always hold the same set of hooks in the same order.
type Chain struct {
	hooks []ent.Hook
}

// NewChain creates a new chain of hooks.
func NewChain(hooks ...ent.Hook) Chain {
	return Chain{append([]ent.Hook(nil), hooks...)}
}

// Hook chains the list of hooks and returns the final hook.
func (c Chain) Hook() ent.Hook {
	return func(mutator ent.Mutator) ent.Mutator {
		for i := len(c.hooks) - 1; i >= 0; i-- {
			mutator = c.hooks[i](mutator)
		}
		return mutator
	}
}

// Append extends a chain, adding the specified hook
// as the last ones in the mutation flow.
func (c Chain) Append(hooks ...ent.Hook) Chain {
	newHooks := make([]ent.Hook, 0, len(c.hooks)+len(hooks))
	newHooks = append(newHooks, c.hooks...)
	newHooks = append(newHooks, hooks...)
	return Chain{newHooks}
}

// Extend extends a chain, adding the specified chain
// as the last ones in the mutation flow.
func (c Chain) Extend(chain Chain) Chain {
	return c.Append(chain.hooks...)
}
