// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package fieldtype

import (
	"database/sql"
	"net"
	"net/http"
	"time"

	"entgo.io/ent/dialect/gremlin/graph/dsl"
	"entgo.io/ent/dialect/gremlin/graph/dsl/__"
	"entgo.io/ent/dialect/gremlin/graph/dsl/p"
	"entgo.io/ent/entc/integration/ent/role"
	"entgo.io/ent/entc/integration/ent/schema"
	"entgo.io/ent/entc/integration/gremlin/ent/predicate"
	"github.com/google/uuid"
)

// ID filters vertices based on their ID field.
func ID(id string) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasID(id)
	})
}

// IDEQ applies the EQ predicate on the ID field.
func IDEQ(id string) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasID(p.EQ(id))
	})
}

// IDNEQ applies the NEQ predicate on the ID field.
func IDNEQ(id string) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasID(p.NEQ(id))
	})
}

// IDIn applies the In predicate on the ID field.
func IDIn(ids ...string) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		v := make([]any, len(ids))
		for i := range v {
			v[i] = ids[i]
		}
		t.HasID(p.Within(v...))
	})
}

// IDNotIn applies the NotIn predicate on the ID field.
func IDNotIn(ids ...string) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		v := make([]any, len(ids))
		for i := range v {
			v[i] = ids[i]
		}
		t.HasID(p.Without(v...))
	})
}

// IDGT applies the GT predicate on the ID field.
func IDGT(id string) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasID(p.GT(id))
	})
}

// IDGTE applies the GTE predicate on the ID field.
func IDGTE(id string) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasID(p.GTE(id))
	})
}

// IDLT applies the LT predicate on the ID field.
func IDLT(id string) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasID(p.LT(id))
	})
}

// IDLTE applies the LTE predicate on the ID field.
func IDLTE(id string) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasID(p.LTE(id))
	})
}

// Int applies equality check predicate on the "int" field. It's identical to IntEQ.
func Int(v int) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt, p.EQ(v))
	})
}

// Int8 applies equality check predicate on the "int8" field. It's identical to Int8EQ.
func Int8(v int8) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt8, p.EQ(v))
	})
}

// Int16 applies equality check predicate on the "int16" field. It's identical to Int16EQ.
func Int16(v int16) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt16, p.EQ(v))
	})
}

// Int32 applies equality check predicate on the "int32" field. It's identical to Int32EQ.
func Int32(v int32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt32, p.EQ(v))
	})
}

// Int64 applies equality check predicate on the "int64" field. It's identical to Int64EQ.
func Int64(v int64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt64, p.EQ(v))
	})
}

// OptionalInt applies equality check predicate on the "optional_int" field. It's identical to OptionalIntEQ.
func OptionalInt(v int) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt, p.EQ(v))
	})
}

// OptionalInt8 applies equality check predicate on the "optional_int8" field. It's identical to OptionalInt8EQ.
func OptionalInt8(v int8) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt8, p.EQ(v))
	})
}

// OptionalInt16 applies equality check predicate on the "optional_int16" field. It's identical to OptionalInt16EQ.
func OptionalInt16(v int16) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt16, p.EQ(v))
	})
}

// OptionalInt32 applies equality check predicate on the "optional_int32" field. It's identical to OptionalInt32EQ.
func OptionalInt32(v int32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt32, p.EQ(v))
	})
}

// OptionalInt64 applies equality check predicate on the "optional_int64" field. It's identical to OptionalInt64EQ.
func OptionalInt64(v int64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt64, p.EQ(v))
	})
}

// NillableInt applies equality check predicate on the "nillable_int" field. It's identical to NillableIntEQ.
func NillableInt(v int) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt, p.EQ(v))
	})
}

// NillableInt8 applies equality check predicate on the "nillable_int8" field. It's identical to NillableInt8EQ.
func NillableInt8(v int8) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt8, p.EQ(v))
	})
}

// NillableInt16 applies equality check predicate on the "nillable_int16" field. It's identical to NillableInt16EQ.
func NillableInt16(v int16) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt16, p.EQ(v))
	})
}

// NillableInt32 applies equality check predicate on the "nillable_int32" field. It's identical to NillableInt32EQ.
func NillableInt32(v int32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt32, p.EQ(v))
	})
}

// NillableInt64 applies equality check predicate on the "nillable_int64" field. It's identical to NillableInt64EQ.
func NillableInt64(v int64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt64, p.EQ(v))
	})
}

// ValidateOptionalInt32 applies equality check predicate on the "validate_optional_int32" field. It's identical to ValidateOptionalInt32EQ.
func ValidateOptionalInt32(v int32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldValidateOptionalInt32, p.EQ(v))
	})
}

// OptionalUint applies equality check predicate on the "optional_uint" field. It's identical to OptionalUintEQ.
func OptionalUint(v uint) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint, p.EQ(v))
	})
}

// OptionalUint8 applies equality check predicate on the "optional_uint8" field. It's identical to OptionalUint8EQ.
func OptionalUint8(v uint8) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint8, p.EQ(v))
	})
}

// OptionalUint16 applies equality check predicate on the "optional_uint16" field. It's identical to OptionalUint16EQ.
func OptionalUint16(v uint16) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint16, p.EQ(v))
	})
}

// OptionalUint32 applies equality check predicate on the "optional_uint32" field. It's identical to OptionalUint32EQ.
func OptionalUint32(v uint32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint32, p.EQ(v))
	})
}

// OptionalUint64 applies equality check predicate on the "optional_uint64" field. It's identical to OptionalUint64EQ.
func OptionalUint64(v uint64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint64, p.EQ(v))
	})
}

// OptionalFloat applies equality check predicate on the "optional_float" field. It's identical to OptionalFloatEQ.
func OptionalFloat(v float64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalFloat, p.EQ(v))
	})
}

// OptionalFloat32 applies equality check predicate on the "optional_float32" field. It's identical to OptionalFloat32EQ.
func OptionalFloat32(v float32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalFloat32, p.EQ(v))
	})
}

// Text applies equality check predicate on the "text" field. It's identical to TextEQ.
func Text(v string) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldText, p.EQ(v))
	})
}

// Datetime applies equality check predicate on the "datetime" field. It's identical to DatetimeEQ.
func Datetime(v time.Time) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDatetime, p.EQ(v))
	})
}

// Decimal applies equality check predicate on the "decimal" field. It's identical to DecimalEQ.
func Decimal(v float64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDecimal, p.EQ(v))
	})
}

// LinkOther applies equality check predicate on the "link_other" field. It's identical to LinkOtherEQ.
func LinkOther(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldLinkOther, p.EQ(v))
	})
}

// LinkOtherFunc applies equality check predicate on the "link_other_func" field. It's identical to LinkOtherFuncEQ.
func LinkOtherFunc(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldLinkOtherFunc, p.EQ(v))
	})
}

// MAC applies equality check predicate on the "mac" field. It's identical to MACEQ.
func MAC(v schema.MAC) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldMAC, p.EQ(v))
	})
}

// StringArray applies equality check predicate on the "string_array" field. It's identical to StringArrayEQ.
func StringArray(v schema.Strings) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldStringArray, p.EQ(v))
	})
}

// Password applies equality check predicate on the "password" field. It's identical to PasswordEQ.
func Password(v string) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldPassword, p.EQ(v))
	})
}

// StringScanner applies equality check predicate on the "string_scanner" field. It's identical to StringScannerEQ.
func StringScanner(v schema.StringScanner) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldStringScanner, p.EQ(v))
	})
}

// Duration applies equality check predicate on the "duration" field. It's identical to DurationEQ.
func Duration(v time.Duration) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDuration, p.EQ(vc))
	})
}

// Dir applies equality check predicate on the "dir" field. It's identical to DirEQ.
func Dir(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDir, p.EQ(vc))
	})
}

// Ndir applies equality check predicate on the "ndir" field. It's identical to NdirEQ.
func Ndir(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNdir, p.EQ(vc))
	})
}

// Str applies equality check predicate on the "str" field. It's identical to StrEQ.
func Str(v sql.NullString) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldStr, p.EQ(v))
	})
}

// NullStr applies equality check predicate on the "null_str" field. It's identical to NullStrEQ.
func NullStr(v *sql.NullString) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullStr, p.EQ(v))
	})
}

// Link applies equality check predicate on the "link" field. It's identical to LinkEQ.
func Link(v schema.Link) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldLink, p.EQ(v))
	})
}

// NullLink applies equality check predicate on the "null_link" field. It's identical to NullLinkEQ.
func NullLink(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullLink, p.EQ(v))
	})
}

// Active applies equality check predicate on the "active" field. It's identical to ActiveEQ.
func Active(v schema.Status) predicate.FieldType {
	vc := bool(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldActive, p.EQ(vc))
	})
}

// NullActive applies equality check predicate on the "null_active" field. It's identical to NullActiveEQ.
func NullActive(v schema.Status) predicate.FieldType {
	vc := bool(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullActive, p.EQ(vc))
	})
}

// Deleted applies equality check predicate on the "deleted" field. It's identical to DeletedEQ.
func Deleted(v *sql.NullBool) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDeleted, p.EQ(v))
	})
}

// DeletedAt applies equality check predicate on the "deleted_at" field. It's identical to DeletedAtEQ.
func DeletedAt(v *sql.NullTime) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDeletedAt, p.EQ(v))
	})
}

// RawData applies equality check predicate on the "raw_data" field. It's identical to RawDataEQ.
func RawData(v []byte) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldRawData, p.EQ(v))
	})
}

// Sensitive applies equality check predicate on the "sensitive" field. It's identical to SensitiveEQ.
func Sensitive(v []byte) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSensitive, p.EQ(v))
	})
}

// IP applies equality check predicate on the "ip" field. It's identical to IPEQ.
func IP(v net.IP) predicate.FieldType {
	vc := []byte(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldIP, p.EQ(vc))
	})
}

// NullInt64 applies equality check predicate on the "null_int64" field. It's identical to NullInt64EQ.
func NullInt64(v *sql.NullInt64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullInt64, p.EQ(v))
	})
}

// SchemaInt applies equality check predicate on the "schema_int" field. It's identical to SchemaIntEQ.
func SchemaInt(v schema.Int) predicate.FieldType {
	vc := int(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaInt, p.EQ(vc))
	})
}

// SchemaInt8 applies equality check predicate on the "schema_int8" field. It's identical to SchemaInt8EQ.
func SchemaInt8(v schema.Int8) predicate.FieldType {
	vc := int8(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaInt8, p.EQ(vc))
	})
}

// SchemaInt64 applies equality check predicate on the "schema_int64" field. It's identical to SchemaInt64EQ.
func SchemaInt64(v schema.Int64) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaInt64, p.EQ(vc))
	})
}

// SchemaFloat applies equality check predicate on the "schema_float" field. It's identical to SchemaFloatEQ.
func SchemaFloat(v schema.Float64) predicate.FieldType {
	vc := float64(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaFloat, p.EQ(vc))
	})
}

// SchemaFloat32 applies equality check predicate on the "schema_float32" field. It's identical to SchemaFloat32EQ.
func SchemaFloat32(v schema.Float32) predicate.FieldType {
	vc := float32(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaFloat32, p.EQ(vc))
	})
}

// NullFloat applies equality check predicate on the "null_float" field. It's identical to NullFloatEQ.
func NullFloat(v *sql.NullFloat64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullFloat, p.EQ(v))
	})
}

// OptionalUUID applies equality check predicate on the "optional_uuid" field. It's identical to OptionalUUIDEQ.
func OptionalUUID(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUUID, p.EQ(v))
	})
}

// NillableUUID applies equality check predicate on the "nillable_uuid" field. It's identical to NillableUUIDEQ.
func NillableUUID(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableUUID, p.EQ(v))
	})
}

// Pair applies equality check predicate on the "pair" field. It's identical to PairEQ.
func Pair(v schema.Pair) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldPair, p.EQ(v))
	})
}

// NilPair applies equality check predicate on the "nil_pair" field. It's identical to NilPairEQ.
func NilPair(v *schema.Pair) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNilPair, p.EQ(v))
	})
}

// Vstring applies equality check predicate on the "vstring" field. It's identical to VstringEQ.
func Vstring(v schema.VString) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldVstring, p.EQ(v))
	})
}

// Triple applies equality check predicate on the "triple" field. It's identical to TripleEQ.
func Triple(v schema.Triple) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldTriple, p.EQ(v))
	})
}

// BigInt applies equality check predicate on the "big_int" field. It's identical to BigIntEQ.
func BigInt(v schema.BigInt) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldBigInt, p.EQ(v))
	})
}

// PasswordOther applies equality check predicate on the "password_other" field. It's identical to PasswordOtherEQ.
func PasswordOther(v schema.Password) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldPasswordOther, p.EQ(v))
	})
}

// IntEQ applies the EQ predicate on the "int" field.
func IntEQ(v int) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt, p.EQ(v))
	})
}

// IntNEQ applies the NEQ predicate on the "int" field.
func IntNEQ(v int) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt, p.NEQ(v))
	})
}

// IntIn applies the In predicate on the "int" field.
func IntIn(vs ...int) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt, p.Within(v...))
	})
}

// IntNotIn applies the NotIn predicate on the "int" field.
func IntNotIn(vs ...int) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt, p.Without(v...))
	})
}

// IntGT applies the GT predicate on the "int" field.
func IntGT(v int) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt, p.GT(v))
	})
}

// IntGTE applies the GTE predicate on the "int" field.
func IntGTE(v int) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt, p.GTE(v))
	})
}

// IntLT applies the LT predicate on the "int" field.
func IntLT(v int) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt, p.LT(v))
	})
}

// IntLTE applies the LTE predicate on the "int" field.
func IntLTE(v int) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt, p.LTE(v))
	})
}

// Int8EQ applies the EQ predicate on the "int8" field.
func Int8EQ(v int8) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt8, p.EQ(v))
	})
}

// Int8NEQ applies the NEQ predicate on the "int8" field.
func Int8NEQ(v int8) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt8, p.NEQ(v))
	})
}

// Int8In applies the In predicate on the "int8" field.
func Int8In(vs ...int8) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt8, p.Within(v...))
	})
}

// Int8NotIn applies the NotIn predicate on the "int8" field.
func Int8NotIn(vs ...int8) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt8, p.Without(v...))
	})
}

// Int8GT applies the GT predicate on the "int8" field.
func Int8GT(v int8) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt8, p.GT(v))
	})
}

// Int8GTE applies the GTE predicate on the "int8" field.
func Int8GTE(v int8) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt8, p.GTE(v))
	})
}

// Int8LT applies the LT predicate on the "int8" field.
func Int8LT(v int8) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt8, p.LT(v))
	})
}

// Int8LTE applies the LTE predicate on the "int8" field.
func Int8LTE(v int8) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt8, p.LTE(v))
	})
}

// Int16EQ applies the EQ predicate on the "int16" field.
func Int16EQ(v int16) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt16, p.EQ(v))
	})
}

// Int16NEQ applies the NEQ predicate on the "int16" field.
func Int16NEQ(v int16) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt16, p.NEQ(v))
	})
}

// Int16In applies the In predicate on the "int16" field.
func Int16In(vs ...int16) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt16, p.Within(v...))
	})
}

// Int16NotIn applies the NotIn predicate on the "int16" field.
func Int16NotIn(vs ...int16) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt16, p.Without(v...))
	})
}

// Int16GT applies the GT predicate on the "int16" field.
func Int16GT(v int16) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt16, p.GT(v))
	})
}

// Int16GTE applies the GTE predicate on the "int16" field.
func Int16GTE(v int16) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt16, p.GTE(v))
	})
}

// Int16LT applies the LT predicate on the "int16" field.
func Int16LT(v int16) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt16, p.LT(v))
	})
}

// Int16LTE applies the LTE predicate on the "int16" field.
func Int16LTE(v int16) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt16, p.LTE(v))
	})
}

// Int32EQ applies the EQ predicate on the "int32" field.
func Int32EQ(v int32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt32, p.EQ(v))
	})
}

// Int32NEQ applies the NEQ predicate on the "int32" field.
func Int32NEQ(v int32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt32, p.NEQ(v))
	})
}

// Int32In applies the In predicate on the "int32" field.
func Int32In(vs ...int32) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt32, p.Within(v...))
	})
}

// Int32NotIn applies the NotIn predicate on the "int32" field.
func Int32NotIn(vs ...int32) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt32, p.Without(v...))
	})
}

// Int32GT applies the GT predicate on the "int32" field.
func Int32GT(v int32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt32, p.GT(v))
	})
}

// Int32GTE applies the GTE predicate on the "int32" field.
func Int32GTE(v int32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt32, p.GTE(v))
	})
}

// Int32LT applies the LT predicate on the "int32" field.
func Int32LT(v int32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt32, p.LT(v))
	})
}

// Int32LTE applies the LTE predicate on the "int32" field.
func Int32LTE(v int32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt32, p.LTE(v))
	})
}

// Int64EQ applies the EQ predicate on the "int64" field.
func Int64EQ(v int64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt64, p.EQ(v))
	})
}

// Int64NEQ applies the NEQ predicate on the "int64" field.
func Int64NEQ(v int64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt64, p.NEQ(v))
	})
}

// Int64In applies the In predicate on the "int64" field.
func Int64In(vs ...int64) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt64, p.Within(v...))
	})
}

// Int64NotIn applies the NotIn predicate on the "int64" field.
func Int64NotIn(vs ...int64) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt64, p.Without(v...))
	})
}

// Int64GT applies the GT predicate on the "int64" field.
func Int64GT(v int64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt64, p.GT(v))
	})
}

// Int64GTE applies the GTE predicate on the "int64" field.
func Int64GTE(v int64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt64, p.GTE(v))
	})
}

// Int64LT applies the LT predicate on the "int64" field.
func Int64LT(v int64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt64, p.LT(v))
	})
}

// Int64LTE applies the LTE predicate on the "int64" field.
func Int64LTE(v int64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldInt64, p.LTE(v))
	})
}

// OptionalIntEQ applies the EQ predicate on the "optional_int" field.
func OptionalIntEQ(v int) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt, p.EQ(v))
	})
}

// OptionalIntNEQ applies the NEQ predicate on the "optional_int" field.
func OptionalIntNEQ(v int) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt, p.NEQ(v))
	})
}

// OptionalIntIn applies the In predicate on the "optional_int" field.
func OptionalIntIn(vs ...int) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt, p.Within(v...))
	})
}

// OptionalIntNotIn applies the NotIn predicate on the "optional_int" field.
func OptionalIntNotIn(vs ...int) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt, p.Without(v...))
	})
}

// OptionalIntGT applies the GT predicate on the "optional_int" field.
func OptionalIntGT(v int) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt, p.GT(v))
	})
}

// OptionalIntGTE applies the GTE predicate on the "optional_int" field.
func OptionalIntGTE(v int) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt, p.GTE(v))
	})
}

// OptionalIntLT applies the LT predicate on the "optional_int" field.
func OptionalIntLT(v int) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt, p.LT(v))
	})
}

// OptionalIntLTE applies the LTE predicate on the "optional_int" field.
func OptionalIntLTE(v int) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt, p.LTE(v))
	})
}

// OptionalIntIsNil applies the IsNil predicate on the "optional_int" field.
func OptionalIntIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldOptionalInt)
	})
}

// OptionalIntNotNil applies the NotNil predicate on the "optional_int" field.
func OptionalIntNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldOptionalInt)
	})
}

// OptionalInt8EQ applies the EQ predicate on the "optional_int8" field.
func OptionalInt8EQ(v int8) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt8, p.EQ(v))
	})
}

// OptionalInt8NEQ applies the NEQ predicate on the "optional_int8" field.
func OptionalInt8NEQ(v int8) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt8, p.NEQ(v))
	})
}

// OptionalInt8In applies the In predicate on the "optional_int8" field.
func OptionalInt8In(vs ...int8) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt8, p.Within(v...))
	})
}

// OptionalInt8NotIn applies the NotIn predicate on the "optional_int8" field.
func OptionalInt8NotIn(vs ...int8) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt8, p.Without(v...))
	})
}

// OptionalInt8GT applies the GT predicate on the "optional_int8" field.
func OptionalInt8GT(v int8) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt8, p.GT(v))
	})
}

// OptionalInt8GTE applies the GTE predicate on the "optional_int8" field.
func OptionalInt8GTE(v int8) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt8, p.GTE(v))
	})
}

// OptionalInt8LT applies the LT predicate on the "optional_int8" field.
func OptionalInt8LT(v int8) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt8, p.LT(v))
	})
}

// OptionalInt8LTE applies the LTE predicate on the "optional_int8" field.
func OptionalInt8LTE(v int8) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt8, p.LTE(v))
	})
}

// OptionalInt8IsNil applies the IsNil predicate on the "optional_int8" field.
func OptionalInt8IsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldOptionalInt8)
	})
}

// OptionalInt8NotNil applies the NotNil predicate on the "optional_int8" field.
func OptionalInt8NotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldOptionalInt8)
	})
}

// OptionalInt16EQ applies the EQ predicate on the "optional_int16" field.
func OptionalInt16EQ(v int16) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt16, p.EQ(v))
	})
}

// OptionalInt16NEQ applies the NEQ predicate on the "optional_int16" field.
func OptionalInt16NEQ(v int16) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt16, p.NEQ(v))
	})
}

// OptionalInt16In applies the In predicate on the "optional_int16" field.
func OptionalInt16In(vs ...int16) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt16, p.Within(v...))
	})
}

// OptionalInt16NotIn applies the NotIn predicate on the "optional_int16" field.
func OptionalInt16NotIn(vs ...int16) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt16, p.Without(v...))
	})
}

// OptionalInt16GT applies the GT predicate on the "optional_int16" field.
func OptionalInt16GT(v int16) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt16, p.GT(v))
	})
}

// OptionalInt16GTE applies the GTE predicate on the "optional_int16" field.
func OptionalInt16GTE(v int16) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt16, p.GTE(v))
	})
}

// OptionalInt16LT applies the LT predicate on the "optional_int16" field.
func OptionalInt16LT(v int16) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt16, p.LT(v))
	})
}

// OptionalInt16LTE applies the LTE predicate on the "optional_int16" field.
func OptionalInt16LTE(v int16) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt16, p.LTE(v))
	})
}

// OptionalInt16IsNil applies the IsNil predicate on the "optional_int16" field.
func OptionalInt16IsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldOptionalInt16)
	})
}

// OptionalInt16NotNil applies the NotNil predicate on the "optional_int16" field.
func OptionalInt16NotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldOptionalInt16)
	})
}

// OptionalInt32EQ applies the EQ predicate on the "optional_int32" field.
func OptionalInt32EQ(v int32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt32, p.EQ(v))
	})
}

// OptionalInt32NEQ applies the NEQ predicate on the "optional_int32" field.
func OptionalInt32NEQ(v int32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt32, p.NEQ(v))
	})
}

// OptionalInt32In applies the In predicate on the "optional_int32" field.
func OptionalInt32In(vs ...int32) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt32, p.Within(v...))
	})
}

// OptionalInt32NotIn applies the NotIn predicate on the "optional_int32" field.
func OptionalInt32NotIn(vs ...int32) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt32, p.Without(v...))
	})
}

// OptionalInt32GT applies the GT predicate on the "optional_int32" field.
func OptionalInt32GT(v int32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt32, p.GT(v))
	})
}

// OptionalInt32GTE applies the GTE predicate on the "optional_int32" field.
func OptionalInt32GTE(v int32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt32, p.GTE(v))
	})
}

// OptionalInt32LT applies the LT predicate on the "optional_int32" field.
func OptionalInt32LT(v int32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt32, p.LT(v))
	})
}

// OptionalInt32LTE applies the LTE predicate on the "optional_int32" field.
func OptionalInt32LTE(v int32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt32, p.LTE(v))
	})
}

// OptionalInt32IsNil applies the IsNil predicate on the "optional_int32" field.
func OptionalInt32IsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldOptionalInt32)
	})
}

// OptionalInt32NotNil applies the NotNil predicate on the "optional_int32" field.
func OptionalInt32NotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldOptionalInt32)
	})
}

// OptionalInt64EQ applies the EQ predicate on the "optional_int64" field.
func OptionalInt64EQ(v int64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt64, p.EQ(v))
	})
}

// OptionalInt64NEQ applies the NEQ predicate on the "optional_int64" field.
func OptionalInt64NEQ(v int64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt64, p.NEQ(v))
	})
}

// OptionalInt64In applies the In predicate on the "optional_int64" field.
func OptionalInt64In(vs ...int64) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt64, p.Within(v...))
	})
}

// OptionalInt64NotIn applies the NotIn predicate on the "optional_int64" field.
func OptionalInt64NotIn(vs ...int64) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt64, p.Without(v...))
	})
}

// OptionalInt64GT applies the GT predicate on the "optional_int64" field.
func OptionalInt64GT(v int64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt64, p.GT(v))
	})
}

// OptionalInt64GTE applies the GTE predicate on the "optional_int64" field.
func OptionalInt64GTE(v int64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt64, p.GTE(v))
	})
}

// OptionalInt64LT applies the LT predicate on the "optional_int64" field.
func OptionalInt64LT(v int64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt64, p.LT(v))
	})
}

// OptionalInt64LTE applies the LTE predicate on the "optional_int64" field.
func OptionalInt64LTE(v int64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalInt64, p.LTE(v))
	})
}

// OptionalInt64IsNil applies the IsNil predicate on the "optional_int64" field.
func OptionalInt64IsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldOptionalInt64)
	})
}

// OptionalInt64NotNil applies the NotNil predicate on the "optional_int64" field.
func OptionalInt64NotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldOptionalInt64)
	})
}

// NillableIntEQ applies the EQ predicate on the "nillable_int" field.
func NillableIntEQ(v int) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt, p.EQ(v))
	})
}

// NillableIntNEQ applies the NEQ predicate on the "nillable_int" field.
func NillableIntNEQ(v int) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt, p.NEQ(v))
	})
}

// NillableIntIn applies the In predicate on the "nillable_int" field.
func NillableIntIn(vs ...int) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt, p.Within(v...))
	})
}

// NillableIntNotIn applies the NotIn predicate on the "nillable_int" field.
func NillableIntNotIn(vs ...int) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt, p.Without(v...))
	})
}

// NillableIntGT applies the GT predicate on the "nillable_int" field.
func NillableIntGT(v int) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt, p.GT(v))
	})
}

// NillableIntGTE applies the GTE predicate on the "nillable_int" field.
func NillableIntGTE(v int) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt, p.GTE(v))
	})
}

// NillableIntLT applies the LT predicate on the "nillable_int" field.
func NillableIntLT(v int) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt, p.LT(v))
	})
}

// NillableIntLTE applies the LTE predicate on the "nillable_int" field.
func NillableIntLTE(v int) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt, p.LTE(v))
	})
}

// NillableIntIsNil applies the IsNil predicate on the "nillable_int" field.
func NillableIntIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldNillableInt)
	})
}

// NillableIntNotNil applies the NotNil predicate on the "nillable_int" field.
func NillableIntNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldNillableInt)
	})
}

// NillableInt8EQ applies the EQ predicate on the "nillable_int8" field.
func NillableInt8EQ(v int8) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt8, p.EQ(v))
	})
}

// NillableInt8NEQ applies the NEQ predicate on the "nillable_int8" field.
func NillableInt8NEQ(v int8) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt8, p.NEQ(v))
	})
}

// NillableInt8In applies the In predicate on the "nillable_int8" field.
func NillableInt8In(vs ...int8) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt8, p.Within(v...))
	})
}

// NillableInt8NotIn applies the NotIn predicate on the "nillable_int8" field.
func NillableInt8NotIn(vs ...int8) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt8, p.Without(v...))
	})
}

// NillableInt8GT applies the GT predicate on the "nillable_int8" field.
func NillableInt8GT(v int8) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt8, p.GT(v))
	})
}

// NillableInt8GTE applies the GTE predicate on the "nillable_int8" field.
func NillableInt8GTE(v int8) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt8, p.GTE(v))
	})
}

// NillableInt8LT applies the LT predicate on the "nillable_int8" field.
func NillableInt8LT(v int8) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt8, p.LT(v))
	})
}

// NillableInt8LTE applies the LTE predicate on the "nillable_int8" field.
func NillableInt8LTE(v int8) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt8, p.LTE(v))
	})
}

// NillableInt8IsNil applies the IsNil predicate on the "nillable_int8" field.
func NillableInt8IsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldNillableInt8)
	})
}

// NillableInt8NotNil applies the NotNil predicate on the "nillable_int8" field.
func NillableInt8NotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldNillableInt8)
	})
}

// NillableInt16EQ applies the EQ predicate on the "nillable_int16" field.
func NillableInt16EQ(v int16) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt16, p.EQ(v))
	})
}

// NillableInt16NEQ applies the NEQ predicate on the "nillable_int16" field.
func NillableInt16NEQ(v int16) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt16, p.NEQ(v))
	})
}

// NillableInt16In applies the In predicate on the "nillable_int16" field.
func NillableInt16In(vs ...int16) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt16, p.Within(v...))
	})
}

// NillableInt16NotIn applies the NotIn predicate on the "nillable_int16" field.
func NillableInt16NotIn(vs ...int16) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt16, p.Without(v...))
	})
}

// NillableInt16GT applies the GT predicate on the "nillable_int16" field.
func NillableInt16GT(v int16) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt16, p.GT(v))
	})
}

// NillableInt16GTE applies the GTE predicate on the "nillable_int16" field.
func NillableInt16GTE(v int16) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt16, p.GTE(v))
	})
}

// NillableInt16LT applies the LT predicate on the "nillable_int16" field.
func NillableInt16LT(v int16) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt16, p.LT(v))
	})
}

// NillableInt16LTE applies the LTE predicate on the "nillable_int16" field.
func NillableInt16LTE(v int16) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt16, p.LTE(v))
	})
}

// NillableInt16IsNil applies the IsNil predicate on the "nillable_int16" field.
func NillableInt16IsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldNillableInt16)
	})
}

// NillableInt16NotNil applies the NotNil predicate on the "nillable_int16" field.
func NillableInt16NotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldNillableInt16)
	})
}

// NillableInt32EQ applies the EQ predicate on the "nillable_int32" field.
func NillableInt32EQ(v int32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt32, p.EQ(v))
	})
}

// NillableInt32NEQ applies the NEQ predicate on the "nillable_int32" field.
func NillableInt32NEQ(v int32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt32, p.NEQ(v))
	})
}

// NillableInt32In applies the In predicate on the "nillable_int32" field.
func NillableInt32In(vs ...int32) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt32, p.Within(v...))
	})
}

// NillableInt32NotIn applies the NotIn predicate on the "nillable_int32" field.
func NillableInt32NotIn(vs ...int32) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt32, p.Without(v...))
	})
}

// NillableInt32GT applies the GT predicate on the "nillable_int32" field.
func NillableInt32GT(v int32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt32, p.GT(v))
	})
}

// NillableInt32GTE applies the GTE predicate on the "nillable_int32" field.
func NillableInt32GTE(v int32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt32, p.GTE(v))
	})
}

// NillableInt32LT applies the LT predicate on the "nillable_int32" field.
func NillableInt32LT(v int32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt32, p.LT(v))
	})
}

// NillableInt32LTE applies the LTE predicate on the "nillable_int32" field.
func NillableInt32LTE(v int32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt32, p.LTE(v))
	})
}

// NillableInt32IsNil applies the IsNil predicate on the "nillable_int32" field.
func NillableInt32IsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldNillableInt32)
	})
}

// NillableInt32NotNil applies the NotNil predicate on the "nillable_int32" field.
func NillableInt32NotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldNillableInt32)
	})
}

// NillableInt64EQ applies the EQ predicate on the "nillable_int64" field.
func NillableInt64EQ(v int64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt64, p.EQ(v))
	})
}

// NillableInt64NEQ applies the NEQ predicate on the "nillable_int64" field.
func NillableInt64NEQ(v int64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt64, p.NEQ(v))
	})
}

// NillableInt64In applies the In predicate on the "nillable_int64" field.
func NillableInt64In(vs ...int64) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt64, p.Within(v...))
	})
}

// NillableInt64NotIn applies the NotIn predicate on the "nillable_int64" field.
func NillableInt64NotIn(vs ...int64) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt64, p.Without(v...))
	})
}

// NillableInt64GT applies the GT predicate on the "nillable_int64" field.
func NillableInt64GT(v int64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt64, p.GT(v))
	})
}

// NillableInt64GTE applies the GTE predicate on the "nillable_int64" field.
func NillableInt64GTE(v int64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt64, p.GTE(v))
	})
}

// NillableInt64LT applies the LT predicate on the "nillable_int64" field.
func NillableInt64LT(v int64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt64, p.LT(v))
	})
}

// NillableInt64LTE applies the LTE predicate on the "nillable_int64" field.
func NillableInt64LTE(v int64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableInt64, p.LTE(v))
	})
}

// NillableInt64IsNil applies the IsNil predicate on the "nillable_int64" field.
func NillableInt64IsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldNillableInt64)
	})
}

// NillableInt64NotNil applies the NotNil predicate on the "nillable_int64" field.
func NillableInt64NotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldNillableInt64)
	})
}

// ValidateOptionalInt32EQ applies the EQ predicate on the "validate_optional_int32" field.
func ValidateOptionalInt32EQ(v int32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldValidateOptionalInt32, p.EQ(v))
	})
}

// ValidateOptionalInt32NEQ applies the NEQ predicate on the "validate_optional_int32" field.
func ValidateOptionalInt32NEQ(v int32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldValidateOptionalInt32, p.NEQ(v))
	})
}

// ValidateOptionalInt32In applies the In predicate on the "validate_optional_int32" field.
func ValidateOptionalInt32In(vs ...int32) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldValidateOptionalInt32, p.Within(v...))
	})
}

// ValidateOptionalInt32NotIn applies the NotIn predicate on the "validate_optional_int32" field.
func ValidateOptionalInt32NotIn(vs ...int32) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldValidateOptionalInt32, p.Without(v...))
	})
}

// ValidateOptionalInt32GT applies the GT predicate on the "validate_optional_int32" field.
func ValidateOptionalInt32GT(v int32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldValidateOptionalInt32, p.GT(v))
	})
}

// ValidateOptionalInt32GTE applies the GTE predicate on the "validate_optional_int32" field.
func ValidateOptionalInt32GTE(v int32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldValidateOptionalInt32, p.GTE(v))
	})
}

// ValidateOptionalInt32LT applies the LT predicate on the "validate_optional_int32" field.
func ValidateOptionalInt32LT(v int32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldValidateOptionalInt32, p.LT(v))
	})
}

// ValidateOptionalInt32LTE applies the LTE predicate on the "validate_optional_int32" field.
func ValidateOptionalInt32LTE(v int32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldValidateOptionalInt32, p.LTE(v))
	})
}

// ValidateOptionalInt32IsNil applies the IsNil predicate on the "validate_optional_int32" field.
func ValidateOptionalInt32IsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldValidateOptionalInt32)
	})
}

// ValidateOptionalInt32NotNil applies the NotNil predicate on the "validate_optional_int32" field.
func ValidateOptionalInt32NotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldValidateOptionalInt32)
	})
}

// OptionalUintEQ applies the EQ predicate on the "optional_uint" field.
func OptionalUintEQ(v uint) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint, p.EQ(v))
	})
}

// OptionalUintNEQ applies the NEQ predicate on the "optional_uint" field.
func OptionalUintNEQ(v uint) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint, p.NEQ(v))
	})
}

// OptionalUintIn applies the In predicate on the "optional_uint" field.
func OptionalUintIn(vs ...uint) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint, p.Within(v...))
	})
}

// OptionalUintNotIn applies the NotIn predicate on the "optional_uint" field.
func OptionalUintNotIn(vs ...uint) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint, p.Without(v...))
	})
}

// OptionalUintGT applies the GT predicate on the "optional_uint" field.
func OptionalUintGT(v uint) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint, p.GT(v))
	})
}

// OptionalUintGTE applies the GTE predicate on the "optional_uint" field.
func OptionalUintGTE(v uint) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint, p.GTE(v))
	})
}

// OptionalUintLT applies the LT predicate on the "optional_uint" field.
func OptionalUintLT(v uint) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint, p.LT(v))
	})
}

// OptionalUintLTE applies the LTE predicate on the "optional_uint" field.
func OptionalUintLTE(v uint) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint, p.LTE(v))
	})
}

// OptionalUintIsNil applies the IsNil predicate on the "optional_uint" field.
func OptionalUintIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldOptionalUint)
	})
}

// OptionalUintNotNil applies the NotNil predicate on the "optional_uint" field.
func OptionalUintNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldOptionalUint)
	})
}

// OptionalUint8EQ applies the EQ predicate on the "optional_uint8" field.
func OptionalUint8EQ(v uint8) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint8, p.EQ(v))
	})
}

// OptionalUint8NEQ applies the NEQ predicate on the "optional_uint8" field.
func OptionalUint8NEQ(v uint8) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint8, p.NEQ(v))
	})
}

// OptionalUint8In applies the In predicate on the "optional_uint8" field.
func OptionalUint8In(vs ...uint8) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint8, p.Within(v...))
	})
}

// OptionalUint8NotIn applies the NotIn predicate on the "optional_uint8" field.
func OptionalUint8NotIn(vs ...uint8) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint8, p.Without(v...))
	})
}

// OptionalUint8GT applies the GT predicate on the "optional_uint8" field.
func OptionalUint8GT(v uint8) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint8, p.GT(v))
	})
}

// OptionalUint8GTE applies the GTE predicate on the "optional_uint8" field.
func OptionalUint8GTE(v uint8) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint8, p.GTE(v))
	})
}

// OptionalUint8LT applies the LT predicate on the "optional_uint8" field.
func OptionalUint8LT(v uint8) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint8, p.LT(v))
	})
}

// OptionalUint8LTE applies the LTE predicate on the "optional_uint8" field.
func OptionalUint8LTE(v uint8) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint8, p.LTE(v))
	})
}

// OptionalUint8IsNil applies the IsNil predicate on the "optional_uint8" field.
func OptionalUint8IsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldOptionalUint8)
	})
}

// OptionalUint8NotNil applies the NotNil predicate on the "optional_uint8" field.
func OptionalUint8NotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldOptionalUint8)
	})
}

// OptionalUint16EQ applies the EQ predicate on the "optional_uint16" field.
func OptionalUint16EQ(v uint16) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint16, p.EQ(v))
	})
}

// OptionalUint16NEQ applies the NEQ predicate on the "optional_uint16" field.
func OptionalUint16NEQ(v uint16) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint16, p.NEQ(v))
	})
}

// OptionalUint16In applies the In predicate on the "optional_uint16" field.
func OptionalUint16In(vs ...uint16) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint16, p.Within(v...))
	})
}

// OptionalUint16NotIn applies the NotIn predicate on the "optional_uint16" field.
func OptionalUint16NotIn(vs ...uint16) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint16, p.Without(v...))
	})
}

// OptionalUint16GT applies the GT predicate on the "optional_uint16" field.
func OptionalUint16GT(v uint16) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint16, p.GT(v))
	})
}

// OptionalUint16GTE applies the GTE predicate on the "optional_uint16" field.
func OptionalUint16GTE(v uint16) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint16, p.GTE(v))
	})
}

// OptionalUint16LT applies the LT predicate on the "optional_uint16" field.
func OptionalUint16LT(v uint16) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint16, p.LT(v))
	})
}

// OptionalUint16LTE applies the LTE predicate on the "optional_uint16" field.
func OptionalUint16LTE(v uint16) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint16, p.LTE(v))
	})
}

// OptionalUint16IsNil applies the IsNil predicate on the "optional_uint16" field.
func OptionalUint16IsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldOptionalUint16)
	})
}

// OptionalUint16NotNil applies the NotNil predicate on the "optional_uint16" field.
func OptionalUint16NotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldOptionalUint16)
	})
}

// OptionalUint32EQ applies the EQ predicate on the "optional_uint32" field.
func OptionalUint32EQ(v uint32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint32, p.EQ(v))
	})
}

// OptionalUint32NEQ applies the NEQ predicate on the "optional_uint32" field.
func OptionalUint32NEQ(v uint32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint32, p.NEQ(v))
	})
}

// OptionalUint32In applies the In predicate on the "optional_uint32" field.
func OptionalUint32In(vs ...uint32) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint32, p.Within(v...))
	})
}

// OptionalUint32NotIn applies the NotIn predicate on the "optional_uint32" field.
func OptionalUint32NotIn(vs ...uint32) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint32, p.Without(v...))
	})
}

// OptionalUint32GT applies the GT predicate on the "optional_uint32" field.
func OptionalUint32GT(v uint32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint32, p.GT(v))
	})
}

// OptionalUint32GTE applies the GTE predicate on the "optional_uint32" field.
func OptionalUint32GTE(v uint32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint32, p.GTE(v))
	})
}

// OptionalUint32LT applies the LT predicate on the "optional_uint32" field.
func OptionalUint32LT(v uint32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint32, p.LT(v))
	})
}

// OptionalUint32LTE applies the LTE predicate on the "optional_uint32" field.
func OptionalUint32LTE(v uint32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint32, p.LTE(v))
	})
}

// OptionalUint32IsNil applies the IsNil predicate on the "optional_uint32" field.
func OptionalUint32IsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldOptionalUint32)
	})
}

// OptionalUint32NotNil applies the NotNil predicate on the "optional_uint32" field.
func OptionalUint32NotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldOptionalUint32)
	})
}

// OptionalUint64EQ applies the EQ predicate on the "optional_uint64" field.
func OptionalUint64EQ(v uint64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint64, p.EQ(v))
	})
}

// OptionalUint64NEQ applies the NEQ predicate on the "optional_uint64" field.
func OptionalUint64NEQ(v uint64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint64, p.NEQ(v))
	})
}

// OptionalUint64In applies the In predicate on the "optional_uint64" field.
func OptionalUint64In(vs ...uint64) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint64, p.Within(v...))
	})
}

// OptionalUint64NotIn applies the NotIn predicate on the "optional_uint64" field.
func OptionalUint64NotIn(vs ...uint64) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint64, p.Without(v...))
	})
}

// OptionalUint64GT applies the GT predicate on the "optional_uint64" field.
func OptionalUint64GT(v uint64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint64, p.GT(v))
	})
}

// OptionalUint64GTE applies the GTE predicate on the "optional_uint64" field.
func OptionalUint64GTE(v uint64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint64, p.GTE(v))
	})
}

// OptionalUint64LT applies the LT predicate on the "optional_uint64" field.
func OptionalUint64LT(v uint64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint64, p.LT(v))
	})
}

// OptionalUint64LTE applies the LTE predicate on the "optional_uint64" field.
func OptionalUint64LTE(v uint64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUint64, p.LTE(v))
	})
}

// OptionalUint64IsNil applies the IsNil predicate on the "optional_uint64" field.
func OptionalUint64IsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldOptionalUint64)
	})
}

// OptionalUint64NotNil applies the NotNil predicate on the "optional_uint64" field.
func OptionalUint64NotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldOptionalUint64)
	})
}

// StateEQ applies the EQ predicate on the "state" field.
func StateEQ(v State) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldState, p.EQ(v))
	})
}

// StateNEQ applies the NEQ predicate on the "state" field.
func StateNEQ(v State) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldState, p.NEQ(v))
	})
}

// StateIn applies the In predicate on the "state" field.
func StateIn(vs ...State) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldState, p.Within(v...))
	})
}

// StateNotIn applies the NotIn predicate on the "state" field.
func StateNotIn(vs ...State) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldState, p.Without(v...))
	})
}

// StateIsNil applies the IsNil predicate on the "state" field.
func StateIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldState)
	})
}

// StateNotNil applies the NotNil predicate on the "state" field.
func StateNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldState)
	})
}

// OptionalFloatEQ applies the EQ predicate on the "optional_float" field.
func OptionalFloatEQ(v float64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalFloat, p.EQ(v))
	})
}

// OptionalFloatNEQ applies the NEQ predicate on the "optional_float" field.
func OptionalFloatNEQ(v float64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalFloat, p.NEQ(v))
	})
}

// OptionalFloatIn applies the In predicate on the "optional_float" field.
func OptionalFloatIn(vs ...float64) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalFloat, p.Within(v...))
	})
}

// OptionalFloatNotIn applies the NotIn predicate on the "optional_float" field.
func OptionalFloatNotIn(vs ...float64) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalFloat, p.Without(v...))
	})
}

// OptionalFloatGT applies the GT predicate on the "optional_float" field.
func OptionalFloatGT(v float64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalFloat, p.GT(v))
	})
}

// OptionalFloatGTE applies the GTE predicate on the "optional_float" field.
func OptionalFloatGTE(v float64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalFloat, p.GTE(v))
	})
}

// OptionalFloatLT applies the LT predicate on the "optional_float" field.
func OptionalFloatLT(v float64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalFloat, p.LT(v))
	})
}

// OptionalFloatLTE applies the LTE predicate on the "optional_float" field.
func OptionalFloatLTE(v float64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalFloat, p.LTE(v))
	})
}

// OptionalFloatIsNil applies the IsNil predicate on the "optional_float" field.
func OptionalFloatIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldOptionalFloat)
	})
}

// OptionalFloatNotNil applies the NotNil predicate on the "optional_float" field.
func OptionalFloatNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldOptionalFloat)
	})
}

// OptionalFloat32EQ applies the EQ predicate on the "optional_float32" field.
func OptionalFloat32EQ(v float32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalFloat32, p.EQ(v))
	})
}

// OptionalFloat32NEQ applies the NEQ predicate on the "optional_float32" field.
func OptionalFloat32NEQ(v float32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalFloat32, p.NEQ(v))
	})
}

// OptionalFloat32In applies the In predicate on the "optional_float32" field.
func OptionalFloat32In(vs ...float32) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalFloat32, p.Within(v...))
	})
}

// OptionalFloat32NotIn applies the NotIn predicate on the "optional_float32" field.
func OptionalFloat32NotIn(vs ...float32) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalFloat32, p.Without(v...))
	})
}

// OptionalFloat32GT applies the GT predicate on the "optional_float32" field.
func OptionalFloat32GT(v float32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalFloat32, p.GT(v))
	})
}

// OptionalFloat32GTE applies the GTE predicate on the "optional_float32" field.
func OptionalFloat32GTE(v float32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalFloat32, p.GTE(v))
	})
}

// OptionalFloat32LT applies the LT predicate on the "optional_float32" field.
func OptionalFloat32LT(v float32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalFloat32, p.LT(v))
	})
}

// OptionalFloat32LTE applies the LTE predicate on the "optional_float32" field.
func OptionalFloat32LTE(v float32) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalFloat32, p.LTE(v))
	})
}

// OptionalFloat32IsNil applies the IsNil predicate on the "optional_float32" field.
func OptionalFloat32IsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldOptionalFloat32)
	})
}

// OptionalFloat32NotNil applies the NotNil predicate on the "optional_float32" field.
func OptionalFloat32NotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldOptionalFloat32)
	})
}

// TextEQ applies the EQ predicate on the "text" field.
func TextEQ(v string) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldText, p.EQ(v))
	})
}

// TextNEQ applies the NEQ predicate on the "text" field.
func TextNEQ(v string) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldText, p.NEQ(v))
	})
}

// TextIn applies the In predicate on the "text" field.
func TextIn(vs ...string) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldText, p.Within(v...))
	})
}

// TextNotIn applies the NotIn predicate on the "text" field.
func TextNotIn(vs ...string) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldText, p.Without(v...))
	})
}

// TextGT applies the GT predicate on the "text" field.
func TextGT(v string) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldText, p.GT(v))
	})
}

// TextGTE applies the GTE predicate on the "text" field.
func TextGTE(v string) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldText, p.GTE(v))
	})
}

// TextLT applies the LT predicate on the "text" field.
func TextLT(v string) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldText, p.LT(v))
	})
}

// TextLTE applies the LTE predicate on the "text" field.
func TextLTE(v string) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldText, p.LTE(v))
	})
}

// TextContains applies the Contains predicate on the "text" field.
func TextContains(v string) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldText, p.Containing(v))
	})
}

// TextHasPrefix applies the HasPrefix predicate on the "text" field.
func TextHasPrefix(v string) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldText, p.StartingWith(v))
	})
}

// TextHasSuffix applies the HasSuffix predicate on the "text" field.
func TextHasSuffix(v string) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldText, p.EndingWith(v))
	})
}

// TextIsNil applies the IsNil predicate on the "text" field.
func TextIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldText)
	})
}

// TextNotNil applies the NotNil predicate on the "text" field.
func TextNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldText)
	})
}

// DatetimeEQ applies the EQ predicate on the "datetime" field.
func DatetimeEQ(v time.Time) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDatetime, p.EQ(v))
	})
}

// DatetimeNEQ applies the NEQ predicate on the "datetime" field.
func DatetimeNEQ(v time.Time) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDatetime, p.NEQ(v))
	})
}

// DatetimeIn applies the In predicate on the "datetime" field.
func DatetimeIn(vs ...time.Time) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDatetime, p.Within(v...))
	})
}

// DatetimeNotIn applies the NotIn predicate on the "datetime" field.
func DatetimeNotIn(vs ...time.Time) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDatetime, p.Without(v...))
	})
}

// DatetimeGT applies the GT predicate on the "datetime" field.
func DatetimeGT(v time.Time) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDatetime, p.GT(v))
	})
}

// DatetimeGTE applies the GTE predicate on the "datetime" field.
func DatetimeGTE(v time.Time) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDatetime, p.GTE(v))
	})
}

// DatetimeLT applies the LT predicate on the "datetime" field.
func DatetimeLT(v time.Time) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDatetime, p.LT(v))
	})
}

// DatetimeLTE applies the LTE predicate on the "datetime" field.
func DatetimeLTE(v time.Time) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDatetime, p.LTE(v))
	})
}

// DatetimeIsNil applies the IsNil predicate on the "datetime" field.
func DatetimeIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldDatetime)
	})
}

// DatetimeNotNil applies the NotNil predicate on the "datetime" field.
func DatetimeNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldDatetime)
	})
}

// DecimalEQ applies the EQ predicate on the "decimal" field.
func DecimalEQ(v float64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDecimal, p.EQ(v))
	})
}

// DecimalNEQ applies the NEQ predicate on the "decimal" field.
func DecimalNEQ(v float64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDecimal, p.NEQ(v))
	})
}

// DecimalIn applies the In predicate on the "decimal" field.
func DecimalIn(vs ...float64) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDecimal, p.Within(v...))
	})
}

// DecimalNotIn applies the NotIn predicate on the "decimal" field.
func DecimalNotIn(vs ...float64) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDecimal, p.Without(v...))
	})
}

// DecimalGT applies the GT predicate on the "decimal" field.
func DecimalGT(v float64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDecimal, p.GT(v))
	})
}

// DecimalGTE applies the GTE predicate on the "decimal" field.
func DecimalGTE(v float64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDecimal, p.GTE(v))
	})
}

// DecimalLT applies the LT predicate on the "decimal" field.
func DecimalLT(v float64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDecimal, p.LT(v))
	})
}

// DecimalLTE applies the LTE predicate on the "decimal" field.
func DecimalLTE(v float64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDecimal, p.LTE(v))
	})
}

// DecimalIsNil applies the IsNil predicate on the "decimal" field.
func DecimalIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldDecimal)
	})
}

// DecimalNotNil applies the NotNil predicate on the "decimal" field.
func DecimalNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldDecimal)
	})
}

// LinkOtherEQ applies the EQ predicate on the "link_other" field.
func LinkOtherEQ(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldLinkOther, p.EQ(v))
	})
}

// LinkOtherNEQ applies the NEQ predicate on the "link_other" field.
func LinkOtherNEQ(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldLinkOther, p.NEQ(v))
	})
}

// LinkOtherIn applies the In predicate on the "link_other" field.
func LinkOtherIn(vs ...*schema.Link) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldLinkOther, p.Within(v...))
	})
}

// LinkOtherNotIn applies the NotIn predicate on the "link_other" field.
func LinkOtherNotIn(vs ...*schema.Link) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldLinkOther, p.Without(v...))
	})
}

// LinkOtherGT applies the GT predicate on the "link_other" field.
func LinkOtherGT(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldLinkOther, p.GT(v))
	})
}

// LinkOtherGTE applies the GTE predicate on the "link_other" field.
func LinkOtherGTE(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldLinkOther, p.GTE(v))
	})
}

// LinkOtherLT applies the LT predicate on the "link_other" field.
func LinkOtherLT(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldLinkOther, p.LT(v))
	})
}

// LinkOtherLTE applies the LTE predicate on the "link_other" field.
func LinkOtherLTE(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldLinkOther, p.LTE(v))
	})
}

// LinkOtherIsNil applies the IsNil predicate on the "link_other" field.
func LinkOtherIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldLinkOther)
	})
}

// LinkOtherNotNil applies the NotNil predicate on the "link_other" field.
func LinkOtherNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldLinkOther)
	})
}

// LinkOtherFuncEQ applies the EQ predicate on the "link_other_func" field.
func LinkOtherFuncEQ(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldLinkOtherFunc, p.EQ(v))
	})
}

// LinkOtherFuncNEQ applies the NEQ predicate on the "link_other_func" field.
func LinkOtherFuncNEQ(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldLinkOtherFunc, p.NEQ(v))
	})
}

// LinkOtherFuncIn applies the In predicate on the "link_other_func" field.
func LinkOtherFuncIn(vs ...*schema.Link) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldLinkOtherFunc, p.Within(v...))
	})
}

// LinkOtherFuncNotIn applies the NotIn predicate on the "link_other_func" field.
func LinkOtherFuncNotIn(vs ...*schema.Link) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldLinkOtherFunc, p.Without(v...))
	})
}

// LinkOtherFuncGT applies the GT predicate on the "link_other_func" field.
func LinkOtherFuncGT(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldLinkOtherFunc, p.GT(v))
	})
}

// LinkOtherFuncGTE applies the GTE predicate on the "link_other_func" field.
func LinkOtherFuncGTE(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldLinkOtherFunc, p.GTE(v))
	})
}

// LinkOtherFuncLT applies the LT predicate on the "link_other_func" field.
func LinkOtherFuncLT(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldLinkOtherFunc, p.LT(v))
	})
}

// LinkOtherFuncLTE applies the LTE predicate on the "link_other_func" field.
func LinkOtherFuncLTE(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldLinkOtherFunc, p.LTE(v))
	})
}

// LinkOtherFuncIsNil applies the IsNil predicate on the "link_other_func" field.
func LinkOtherFuncIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldLinkOtherFunc)
	})
}

// LinkOtherFuncNotNil applies the NotNil predicate on the "link_other_func" field.
func LinkOtherFuncNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldLinkOtherFunc)
	})
}

// MACEQ applies the EQ predicate on the "mac" field.
func MACEQ(v schema.MAC) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldMAC, p.EQ(v))
	})
}

// MACNEQ applies the NEQ predicate on the "mac" field.
func MACNEQ(v schema.MAC) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldMAC, p.NEQ(v))
	})
}

// MACIn applies the In predicate on the "mac" field.
func MACIn(vs ...schema.MAC) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldMAC, p.Within(v...))
	})
}

// MACNotIn applies the NotIn predicate on the "mac" field.
func MACNotIn(vs ...schema.MAC) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldMAC, p.Without(v...))
	})
}

// MACGT applies the GT predicate on the "mac" field.
func MACGT(v schema.MAC) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldMAC, p.GT(v))
	})
}

// MACGTE applies the GTE predicate on the "mac" field.
func MACGTE(v schema.MAC) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldMAC, p.GTE(v))
	})
}

// MACLT applies the LT predicate on the "mac" field.
func MACLT(v schema.MAC) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldMAC, p.LT(v))
	})
}

// MACLTE applies the LTE predicate on the "mac" field.
func MACLTE(v schema.MAC) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldMAC, p.LTE(v))
	})
}

// MACContains applies the Contains predicate on the "mac" field.
func MACContains(v schema.MAC) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldMAC, p.Containing(vc))
	})
}

// MACHasPrefix applies the HasPrefix predicate on the "mac" field.
func MACHasPrefix(v schema.MAC) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldMAC, p.StartingWith(vc))
	})
}

// MACHasSuffix applies the HasSuffix predicate on the "mac" field.
func MACHasSuffix(v schema.MAC) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldMAC, p.EndingWith(vc))
	})
}

// MACIsNil applies the IsNil predicate on the "mac" field.
func MACIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldMAC)
	})
}

// MACNotNil applies the NotNil predicate on the "mac" field.
func MACNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldMAC)
	})
}

// StringArrayEQ applies the EQ predicate on the "string_array" field.
func StringArrayEQ(v schema.Strings) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldStringArray, p.EQ(v))
	})
}

// StringArrayNEQ applies the NEQ predicate on the "string_array" field.
func StringArrayNEQ(v schema.Strings) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldStringArray, p.NEQ(v))
	})
}

// StringArrayIn applies the In predicate on the "string_array" field.
func StringArrayIn(vs ...schema.Strings) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldStringArray, p.Within(v...))
	})
}

// StringArrayNotIn applies the NotIn predicate on the "string_array" field.
func StringArrayNotIn(vs ...schema.Strings) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldStringArray, p.Without(v...))
	})
}

// StringArrayGT applies the GT predicate on the "string_array" field.
func StringArrayGT(v schema.Strings) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldStringArray, p.GT(v))
	})
}

// StringArrayGTE applies the GTE predicate on the "string_array" field.
func StringArrayGTE(v schema.Strings) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldStringArray, p.GTE(v))
	})
}

// StringArrayLT applies the LT predicate on the "string_array" field.
func StringArrayLT(v schema.Strings) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldStringArray, p.LT(v))
	})
}

// StringArrayLTE applies the LTE predicate on the "string_array" field.
func StringArrayLTE(v schema.Strings) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldStringArray, p.LTE(v))
	})
}

// StringArrayIsNil applies the IsNil predicate on the "string_array" field.
func StringArrayIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldStringArray)
	})
}

// StringArrayNotNil applies the NotNil predicate on the "string_array" field.
func StringArrayNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldStringArray)
	})
}

// PasswordEQ applies the EQ predicate on the "password" field.
func PasswordEQ(v string) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldPassword, p.EQ(v))
	})
}

// PasswordNEQ applies the NEQ predicate on the "password" field.
func PasswordNEQ(v string) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldPassword, p.NEQ(v))
	})
}

// PasswordIn applies the In predicate on the "password" field.
func PasswordIn(vs ...string) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldPassword, p.Within(v...))
	})
}

// PasswordNotIn applies the NotIn predicate on the "password" field.
func PasswordNotIn(vs ...string) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldPassword, p.Without(v...))
	})
}

// PasswordGT applies the GT predicate on the "password" field.
func PasswordGT(v string) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldPassword, p.GT(v))
	})
}

// PasswordGTE applies the GTE predicate on the "password" field.
func PasswordGTE(v string) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldPassword, p.GTE(v))
	})
}

// PasswordLT applies the LT predicate on the "password" field.
func PasswordLT(v string) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldPassword, p.LT(v))
	})
}

// PasswordLTE applies the LTE predicate on the "password" field.
func PasswordLTE(v string) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldPassword, p.LTE(v))
	})
}

// PasswordContains applies the Contains predicate on the "password" field.
func PasswordContains(v string) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldPassword, p.Containing(v))
	})
}

// PasswordHasPrefix applies the HasPrefix predicate on the "password" field.
func PasswordHasPrefix(v string) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldPassword, p.StartingWith(v))
	})
}

// PasswordHasSuffix applies the HasSuffix predicate on the "password" field.
func PasswordHasSuffix(v string) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldPassword, p.EndingWith(v))
	})
}

// PasswordIsNil applies the IsNil predicate on the "password" field.
func PasswordIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldPassword)
	})
}

// PasswordNotNil applies the NotNil predicate on the "password" field.
func PasswordNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldPassword)
	})
}

// StringScannerEQ applies the EQ predicate on the "string_scanner" field.
func StringScannerEQ(v schema.StringScanner) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldStringScanner, p.EQ(v))
	})
}

// StringScannerNEQ applies the NEQ predicate on the "string_scanner" field.
func StringScannerNEQ(v schema.StringScanner) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldStringScanner, p.NEQ(v))
	})
}

// StringScannerIn applies the In predicate on the "string_scanner" field.
func StringScannerIn(vs ...schema.StringScanner) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldStringScanner, p.Within(v...))
	})
}

// StringScannerNotIn applies the NotIn predicate on the "string_scanner" field.
func StringScannerNotIn(vs ...schema.StringScanner) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldStringScanner, p.Without(v...))
	})
}

// StringScannerGT applies the GT predicate on the "string_scanner" field.
func StringScannerGT(v schema.StringScanner) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldStringScanner, p.GT(v))
	})
}

// StringScannerGTE applies the GTE predicate on the "string_scanner" field.
func StringScannerGTE(v schema.StringScanner) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldStringScanner, p.GTE(v))
	})
}

// StringScannerLT applies the LT predicate on the "string_scanner" field.
func StringScannerLT(v schema.StringScanner) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldStringScanner, p.LT(v))
	})
}

// StringScannerLTE applies the LTE predicate on the "string_scanner" field.
func StringScannerLTE(v schema.StringScanner) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldStringScanner, p.LTE(v))
	})
}

// StringScannerContains applies the Contains predicate on the "string_scanner" field.
func StringScannerContains(v schema.StringScanner) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldStringScanner, p.Containing(vc))
	})
}

// StringScannerHasPrefix applies the HasPrefix predicate on the "string_scanner" field.
func StringScannerHasPrefix(v schema.StringScanner) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldStringScanner, p.StartingWith(vc))
	})
}

// StringScannerHasSuffix applies the HasSuffix predicate on the "string_scanner" field.
func StringScannerHasSuffix(v schema.StringScanner) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldStringScanner, p.EndingWith(vc))
	})
}

// StringScannerIsNil applies the IsNil predicate on the "string_scanner" field.
func StringScannerIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldStringScanner)
	})
}

// StringScannerNotNil applies the NotNil predicate on the "string_scanner" field.
func StringScannerNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldStringScanner)
	})
}

// DurationEQ applies the EQ predicate on the "duration" field.
func DurationEQ(v time.Duration) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDuration, p.EQ(vc))
	})
}

// DurationNEQ applies the NEQ predicate on the "duration" field.
func DurationNEQ(v time.Duration) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDuration, p.NEQ(vc))
	})
}

// DurationIn applies the In predicate on the "duration" field.
func DurationIn(vs ...time.Duration) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = int64(vs[i])
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDuration, p.Within(v...))
	})
}

// DurationNotIn applies the NotIn predicate on the "duration" field.
func DurationNotIn(vs ...time.Duration) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = int64(vs[i])
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDuration, p.Without(v...))
	})
}

// DurationGT applies the GT predicate on the "duration" field.
func DurationGT(v time.Duration) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDuration, p.GT(vc))
	})
}

// DurationGTE applies the GTE predicate on the "duration" field.
func DurationGTE(v time.Duration) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDuration, p.GTE(vc))
	})
}

// DurationLT applies the LT predicate on the "duration" field.
func DurationLT(v time.Duration) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDuration, p.LT(vc))
	})
}

// DurationLTE applies the LTE predicate on the "duration" field.
func DurationLTE(v time.Duration) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDuration, p.LTE(vc))
	})
}

// DurationIsNil applies the IsNil predicate on the "duration" field.
func DurationIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldDuration)
	})
}

// DurationNotNil applies the NotNil predicate on the "duration" field.
func DurationNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldDuration)
	})
}

// DirEQ applies the EQ predicate on the "dir" field.
func DirEQ(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDir, p.EQ(vc))
	})
}

// DirNEQ applies the NEQ predicate on the "dir" field.
func DirNEQ(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDir, p.NEQ(vc))
	})
}

// DirIn applies the In predicate on the "dir" field.
func DirIn(vs ...http.Dir) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = string(vs[i])
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDir, p.Within(v...))
	})
}

// DirNotIn applies the NotIn predicate on the "dir" field.
func DirNotIn(vs ...http.Dir) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = string(vs[i])
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDir, p.Without(v...))
	})
}

// DirGT applies the GT predicate on the "dir" field.
func DirGT(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDir, p.GT(vc))
	})
}

// DirGTE applies the GTE predicate on the "dir" field.
func DirGTE(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDir, p.GTE(vc))
	})
}

// DirLT applies the LT predicate on the "dir" field.
func DirLT(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDir, p.LT(vc))
	})
}

// DirLTE applies the LTE predicate on the "dir" field.
func DirLTE(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDir, p.LTE(vc))
	})
}

// DirContains applies the Contains predicate on the "dir" field.
func DirContains(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDir, p.Containing(vc))
	})
}

// DirHasPrefix applies the HasPrefix predicate on the "dir" field.
func DirHasPrefix(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDir, p.StartingWith(vc))
	})
}

// DirHasSuffix applies the HasSuffix predicate on the "dir" field.
func DirHasSuffix(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDir, p.EndingWith(vc))
	})
}

// NdirEQ applies the EQ predicate on the "ndir" field.
func NdirEQ(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNdir, p.EQ(vc))
	})
}

// NdirNEQ applies the NEQ predicate on the "ndir" field.
func NdirNEQ(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNdir, p.NEQ(vc))
	})
}

// NdirIn applies the In predicate on the "ndir" field.
func NdirIn(vs ...http.Dir) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = string(vs[i])
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNdir, p.Within(v...))
	})
}

// NdirNotIn applies the NotIn predicate on the "ndir" field.
func NdirNotIn(vs ...http.Dir) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = string(vs[i])
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNdir, p.Without(v...))
	})
}

// NdirGT applies the GT predicate on the "ndir" field.
func NdirGT(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNdir, p.GT(vc))
	})
}

// NdirGTE applies the GTE predicate on the "ndir" field.
func NdirGTE(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNdir, p.GTE(vc))
	})
}

// NdirLT applies the LT predicate on the "ndir" field.
func NdirLT(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNdir, p.LT(vc))
	})
}

// NdirLTE applies the LTE predicate on the "ndir" field.
func NdirLTE(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNdir, p.LTE(vc))
	})
}

// NdirContains applies the Contains predicate on the "ndir" field.
func NdirContains(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNdir, p.Containing(vc))
	})
}

// NdirHasPrefix applies the HasPrefix predicate on the "ndir" field.
func NdirHasPrefix(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNdir, p.StartingWith(vc))
	})
}

// NdirHasSuffix applies the HasSuffix predicate on the "ndir" field.
func NdirHasSuffix(v http.Dir) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNdir, p.EndingWith(vc))
	})
}

// NdirIsNil applies the IsNil predicate on the "ndir" field.
func NdirIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldNdir)
	})
}

// NdirNotNil applies the NotNil predicate on the "ndir" field.
func NdirNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldNdir)
	})
}

// StrEQ applies the EQ predicate on the "str" field.
func StrEQ(v sql.NullString) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldStr, p.EQ(v))
	})
}

// StrNEQ applies the NEQ predicate on the "str" field.
func StrNEQ(v sql.NullString) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldStr, p.NEQ(v))
	})
}

// StrIn applies the In predicate on the "str" field.
func StrIn(vs ...sql.NullString) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldStr, p.Within(v...))
	})
}

// StrNotIn applies the NotIn predicate on the "str" field.
func StrNotIn(vs ...sql.NullString) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldStr, p.Without(v...))
	})
}

// StrGT applies the GT predicate on the "str" field.
func StrGT(v sql.NullString) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldStr, p.GT(v))
	})
}

// StrGTE applies the GTE predicate on the "str" field.
func StrGTE(v sql.NullString) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldStr, p.GTE(v))
	})
}

// StrLT applies the LT predicate on the "str" field.
func StrLT(v sql.NullString) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldStr, p.LT(v))
	})
}

// StrLTE applies the LTE predicate on the "str" field.
func StrLTE(v sql.NullString) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldStr, p.LTE(v))
	})
}

// StrContains applies the Contains predicate on the "str" field.
func StrContains(v sql.NullString) predicate.FieldType {
	vc := v.String
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldStr, p.Containing(vc))
	})
}

// StrHasPrefix applies the HasPrefix predicate on the "str" field.
func StrHasPrefix(v sql.NullString) predicate.FieldType {
	vc := v.String
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldStr, p.StartingWith(vc))
	})
}

// StrHasSuffix applies the HasSuffix predicate on the "str" field.
func StrHasSuffix(v sql.NullString) predicate.FieldType {
	vc := v.String
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldStr, p.EndingWith(vc))
	})
}

// StrIsNil applies the IsNil predicate on the "str" field.
func StrIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldStr)
	})
}

// StrNotNil applies the NotNil predicate on the "str" field.
func StrNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldStr)
	})
}

// NullStrEQ applies the EQ predicate on the "null_str" field.
func NullStrEQ(v *sql.NullString) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullStr, p.EQ(v))
	})
}

// NullStrNEQ applies the NEQ predicate on the "null_str" field.
func NullStrNEQ(v *sql.NullString) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullStr, p.NEQ(v))
	})
}

// NullStrIn applies the In predicate on the "null_str" field.
func NullStrIn(vs ...*sql.NullString) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullStr, p.Within(v...))
	})
}

// NullStrNotIn applies the NotIn predicate on the "null_str" field.
func NullStrNotIn(vs ...*sql.NullString) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullStr, p.Without(v...))
	})
}

// NullStrGT applies the GT predicate on the "null_str" field.
func NullStrGT(v *sql.NullString) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullStr, p.GT(v))
	})
}

// NullStrGTE applies the GTE predicate on the "null_str" field.
func NullStrGTE(v *sql.NullString) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullStr, p.GTE(v))
	})
}

// NullStrLT applies the LT predicate on the "null_str" field.
func NullStrLT(v *sql.NullString) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullStr, p.LT(v))
	})
}

// NullStrLTE applies the LTE predicate on the "null_str" field.
func NullStrLTE(v *sql.NullString) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullStr, p.LTE(v))
	})
}

// NullStrContains applies the Contains predicate on the "null_str" field.
func NullStrContains(v *sql.NullString) predicate.FieldType {
	vc := v.String
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullStr, p.Containing(vc))
	})
}

// NullStrHasPrefix applies the HasPrefix predicate on the "null_str" field.
func NullStrHasPrefix(v *sql.NullString) predicate.FieldType {
	vc := v.String
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullStr, p.StartingWith(vc))
	})
}

// NullStrHasSuffix applies the HasSuffix predicate on the "null_str" field.
func NullStrHasSuffix(v *sql.NullString) predicate.FieldType {
	vc := v.String
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullStr, p.EndingWith(vc))
	})
}

// NullStrIsNil applies the IsNil predicate on the "null_str" field.
func NullStrIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldNullStr)
	})
}

// NullStrNotNil applies the NotNil predicate on the "null_str" field.
func NullStrNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldNullStr)
	})
}

// LinkEQ applies the EQ predicate on the "link" field.
func LinkEQ(v schema.Link) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldLink, p.EQ(v))
	})
}

// LinkNEQ applies the NEQ predicate on the "link" field.
func LinkNEQ(v schema.Link) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldLink, p.NEQ(v))
	})
}

// LinkIn applies the In predicate on the "link" field.
func LinkIn(vs ...schema.Link) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldLink, p.Within(v...))
	})
}

// LinkNotIn applies the NotIn predicate on the "link" field.
func LinkNotIn(vs ...schema.Link) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldLink, p.Without(v...))
	})
}

// LinkGT applies the GT predicate on the "link" field.
func LinkGT(v schema.Link) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldLink, p.GT(v))
	})
}

// LinkGTE applies the GTE predicate on the "link" field.
func LinkGTE(v schema.Link) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldLink, p.GTE(v))
	})
}

// LinkLT applies the LT predicate on the "link" field.
func LinkLT(v schema.Link) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldLink, p.LT(v))
	})
}

// LinkLTE applies the LTE predicate on the "link" field.
func LinkLTE(v schema.Link) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldLink, p.LTE(v))
	})
}

// LinkContains applies the Contains predicate on the "link" field.
func LinkContains(v schema.Link) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldLink, p.Containing(vc))
	})
}

// LinkHasPrefix applies the HasPrefix predicate on the "link" field.
func LinkHasPrefix(v schema.Link) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldLink, p.StartingWith(vc))
	})
}

// LinkHasSuffix applies the HasSuffix predicate on the "link" field.
func LinkHasSuffix(v schema.Link) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldLink, p.EndingWith(vc))
	})
}

// LinkIsNil applies the IsNil predicate on the "link" field.
func LinkIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldLink)
	})
}

// LinkNotNil applies the NotNil predicate on the "link" field.
func LinkNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldLink)
	})
}

// NullLinkEQ applies the EQ predicate on the "null_link" field.
func NullLinkEQ(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullLink, p.EQ(v))
	})
}

// NullLinkNEQ applies the NEQ predicate on the "null_link" field.
func NullLinkNEQ(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullLink, p.NEQ(v))
	})
}

// NullLinkIn applies the In predicate on the "null_link" field.
func NullLinkIn(vs ...*schema.Link) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullLink, p.Within(v...))
	})
}

// NullLinkNotIn applies the NotIn predicate on the "null_link" field.
func NullLinkNotIn(vs ...*schema.Link) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullLink, p.Without(v...))
	})
}

// NullLinkGT applies the GT predicate on the "null_link" field.
func NullLinkGT(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullLink, p.GT(v))
	})
}

// NullLinkGTE applies the GTE predicate on the "null_link" field.
func NullLinkGTE(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullLink, p.GTE(v))
	})
}

// NullLinkLT applies the LT predicate on the "null_link" field.
func NullLinkLT(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullLink, p.LT(v))
	})
}

// NullLinkLTE applies the LTE predicate on the "null_link" field.
func NullLinkLTE(v *schema.Link) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullLink, p.LTE(v))
	})
}

// NullLinkContains applies the Contains predicate on the "null_link" field.
func NullLinkContains(v *schema.Link) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullLink, p.Containing(vc))
	})
}

// NullLinkHasPrefix applies the HasPrefix predicate on the "null_link" field.
func NullLinkHasPrefix(v *schema.Link) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullLink, p.StartingWith(vc))
	})
}

// NullLinkHasSuffix applies the HasSuffix predicate on the "null_link" field.
func NullLinkHasSuffix(v *schema.Link) predicate.FieldType {
	vc := v.String()
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullLink, p.EndingWith(vc))
	})
}

// NullLinkIsNil applies the IsNil predicate on the "null_link" field.
func NullLinkIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldNullLink)
	})
}

// NullLinkNotNil applies the NotNil predicate on the "null_link" field.
func NullLinkNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldNullLink)
	})
}

// ActiveEQ applies the EQ predicate on the "active" field.
func ActiveEQ(v schema.Status) predicate.FieldType {
	vc := bool(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldActive, p.EQ(vc))
	})
}

// ActiveNEQ applies the NEQ predicate on the "active" field.
func ActiveNEQ(v schema.Status) predicate.FieldType {
	vc := bool(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldActive, p.NEQ(vc))
	})
}

// ActiveIsNil applies the IsNil predicate on the "active" field.
func ActiveIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldActive)
	})
}

// ActiveNotNil applies the NotNil predicate on the "active" field.
func ActiveNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldActive)
	})
}

// NullActiveEQ applies the EQ predicate on the "null_active" field.
func NullActiveEQ(v schema.Status) predicate.FieldType {
	vc := bool(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullActive, p.EQ(vc))
	})
}

// NullActiveNEQ applies the NEQ predicate on the "null_active" field.
func NullActiveNEQ(v schema.Status) predicate.FieldType {
	vc := bool(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullActive, p.NEQ(vc))
	})
}

// NullActiveIsNil applies the IsNil predicate on the "null_active" field.
func NullActiveIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldNullActive)
	})
}

// NullActiveNotNil applies the NotNil predicate on the "null_active" field.
func NullActiveNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldNullActive)
	})
}

// DeletedEQ applies the EQ predicate on the "deleted" field.
func DeletedEQ(v *sql.NullBool) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDeleted, p.EQ(v))
	})
}

// DeletedNEQ applies the NEQ predicate on the "deleted" field.
func DeletedNEQ(v *sql.NullBool) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDeleted, p.NEQ(v))
	})
}

// DeletedIsNil applies the IsNil predicate on the "deleted" field.
func DeletedIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldDeleted)
	})
}

// DeletedNotNil applies the NotNil predicate on the "deleted" field.
func DeletedNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldDeleted)
	})
}

// DeletedAtEQ applies the EQ predicate on the "deleted_at" field.
func DeletedAtEQ(v *sql.NullTime) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDeletedAt, p.EQ(v))
	})
}

// DeletedAtNEQ applies the NEQ predicate on the "deleted_at" field.
func DeletedAtNEQ(v *sql.NullTime) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDeletedAt, p.NEQ(v))
	})
}

// DeletedAtIn applies the In predicate on the "deleted_at" field.
func DeletedAtIn(vs ...*sql.NullTime) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDeletedAt, p.Within(v...))
	})
}

// DeletedAtNotIn applies the NotIn predicate on the "deleted_at" field.
func DeletedAtNotIn(vs ...*sql.NullTime) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDeletedAt, p.Without(v...))
	})
}

// DeletedAtGT applies the GT predicate on the "deleted_at" field.
func DeletedAtGT(v *sql.NullTime) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDeletedAt, p.GT(v))
	})
}

// DeletedAtGTE applies the GTE predicate on the "deleted_at" field.
func DeletedAtGTE(v *sql.NullTime) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDeletedAt, p.GTE(v))
	})
}

// DeletedAtLT applies the LT predicate on the "deleted_at" field.
func DeletedAtLT(v *sql.NullTime) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDeletedAt, p.LT(v))
	})
}

// DeletedAtLTE applies the LTE predicate on the "deleted_at" field.
func DeletedAtLTE(v *sql.NullTime) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldDeletedAt, p.LTE(v))
	})
}

// DeletedAtIsNil applies the IsNil predicate on the "deleted_at" field.
func DeletedAtIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldDeletedAt)
	})
}

// DeletedAtNotNil applies the NotNil predicate on the "deleted_at" field.
func DeletedAtNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldDeletedAt)
	})
}

// RawDataEQ applies the EQ predicate on the "raw_data" field.
func RawDataEQ(v []byte) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldRawData, p.EQ(v))
	})
}

// RawDataNEQ applies the NEQ predicate on the "raw_data" field.
func RawDataNEQ(v []byte) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldRawData, p.NEQ(v))
	})
}

// RawDataIn applies the In predicate on the "raw_data" field.
func RawDataIn(vs ...[]byte) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldRawData, p.Within(v...))
	})
}

// RawDataNotIn applies the NotIn predicate on the "raw_data" field.
func RawDataNotIn(vs ...[]byte) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldRawData, p.Without(v...))
	})
}

// RawDataGT applies the GT predicate on the "raw_data" field.
func RawDataGT(v []byte) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldRawData, p.GT(v))
	})
}

// RawDataGTE applies the GTE predicate on the "raw_data" field.
func RawDataGTE(v []byte) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldRawData, p.GTE(v))
	})
}

// RawDataLT applies the LT predicate on the "raw_data" field.
func RawDataLT(v []byte) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldRawData, p.LT(v))
	})
}

// RawDataLTE applies the LTE predicate on the "raw_data" field.
func RawDataLTE(v []byte) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldRawData, p.LTE(v))
	})
}

// RawDataIsNil applies the IsNil predicate on the "raw_data" field.
func RawDataIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldRawData)
	})
}

// RawDataNotNil applies the NotNil predicate on the "raw_data" field.
func RawDataNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldRawData)
	})
}

// SensitiveEQ applies the EQ predicate on the "sensitive" field.
func SensitiveEQ(v []byte) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSensitive, p.EQ(v))
	})
}

// SensitiveNEQ applies the NEQ predicate on the "sensitive" field.
func SensitiveNEQ(v []byte) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSensitive, p.NEQ(v))
	})
}

// SensitiveIn applies the In predicate on the "sensitive" field.
func SensitiveIn(vs ...[]byte) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSensitive, p.Within(v...))
	})
}

// SensitiveNotIn applies the NotIn predicate on the "sensitive" field.
func SensitiveNotIn(vs ...[]byte) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSensitive, p.Without(v...))
	})
}

// SensitiveGT applies the GT predicate on the "sensitive" field.
func SensitiveGT(v []byte) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSensitive, p.GT(v))
	})
}

// SensitiveGTE applies the GTE predicate on the "sensitive" field.
func SensitiveGTE(v []byte) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSensitive, p.GTE(v))
	})
}

// SensitiveLT applies the LT predicate on the "sensitive" field.
func SensitiveLT(v []byte) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSensitive, p.LT(v))
	})
}

// SensitiveLTE applies the LTE predicate on the "sensitive" field.
func SensitiveLTE(v []byte) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSensitive, p.LTE(v))
	})
}

// SensitiveIsNil applies the IsNil predicate on the "sensitive" field.
func SensitiveIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldSensitive)
	})
}

// SensitiveNotNil applies the NotNil predicate on the "sensitive" field.
func SensitiveNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldSensitive)
	})
}

// IPEQ applies the EQ predicate on the "ip" field.
func IPEQ(v net.IP) predicate.FieldType {
	vc := []byte(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldIP, p.EQ(vc))
	})
}

// IPNEQ applies the NEQ predicate on the "ip" field.
func IPNEQ(v net.IP) predicate.FieldType {
	vc := []byte(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldIP, p.NEQ(vc))
	})
}

// IPIn applies the In predicate on the "ip" field.
func IPIn(vs ...net.IP) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = []byte(vs[i])
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldIP, p.Within(v...))
	})
}

// IPNotIn applies the NotIn predicate on the "ip" field.
func IPNotIn(vs ...net.IP) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = []byte(vs[i])
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldIP, p.Without(v...))
	})
}

// IPGT applies the GT predicate on the "ip" field.
func IPGT(v net.IP) predicate.FieldType {
	vc := []byte(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldIP, p.GT(vc))
	})
}

// IPGTE applies the GTE predicate on the "ip" field.
func IPGTE(v net.IP) predicate.FieldType {
	vc := []byte(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldIP, p.GTE(vc))
	})
}

// IPLT applies the LT predicate on the "ip" field.
func IPLT(v net.IP) predicate.FieldType {
	vc := []byte(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldIP, p.LT(vc))
	})
}

// IPLTE applies the LTE predicate on the "ip" field.
func IPLTE(v net.IP) predicate.FieldType {
	vc := []byte(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldIP, p.LTE(vc))
	})
}

// IPIsNil applies the IsNil predicate on the "ip" field.
func IPIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldIP)
	})
}

// IPNotNil applies the NotNil predicate on the "ip" field.
func IPNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldIP)
	})
}

// NullInt64EQ applies the EQ predicate on the "null_int64" field.
func NullInt64EQ(v *sql.NullInt64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullInt64, p.EQ(v))
	})
}

// NullInt64NEQ applies the NEQ predicate on the "null_int64" field.
func NullInt64NEQ(v *sql.NullInt64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullInt64, p.NEQ(v))
	})
}

// NullInt64In applies the In predicate on the "null_int64" field.
func NullInt64In(vs ...*sql.NullInt64) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullInt64, p.Within(v...))
	})
}

// NullInt64NotIn applies the NotIn predicate on the "null_int64" field.
func NullInt64NotIn(vs ...*sql.NullInt64) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullInt64, p.Without(v...))
	})
}

// NullInt64GT applies the GT predicate on the "null_int64" field.
func NullInt64GT(v *sql.NullInt64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullInt64, p.GT(v))
	})
}

// NullInt64GTE applies the GTE predicate on the "null_int64" field.
func NullInt64GTE(v *sql.NullInt64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullInt64, p.GTE(v))
	})
}

// NullInt64LT applies the LT predicate on the "null_int64" field.
func NullInt64LT(v *sql.NullInt64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullInt64, p.LT(v))
	})
}

// NullInt64LTE applies the LTE predicate on the "null_int64" field.
func NullInt64LTE(v *sql.NullInt64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullInt64, p.LTE(v))
	})
}

// NullInt64IsNil applies the IsNil predicate on the "null_int64" field.
func NullInt64IsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldNullInt64)
	})
}

// NullInt64NotNil applies the NotNil predicate on the "null_int64" field.
func NullInt64NotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldNullInt64)
	})
}

// SchemaIntEQ applies the EQ predicate on the "schema_int" field.
func SchemaIntEQ(v schema.Int) predicate.FieldType {
	vc := int(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaInt, p.EQ(vc))
	})
}

// SchemaIntNEQ applies the NEQ predicate on the "schema_int" field.
func SchemaIntNEQ(v schema.Int) predicate.FieldType {
	vc := int(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaInt, p.NEQ(vc))
	})
}

// SchemaIntIn applies the In predicate on the "schema_int" field.
func SchemaIntIn(vs ...schema.Int) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = int(vs[i])
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaInt, p.Within(v...))
	})
}

// SchemaIntNotIn applies the NotIn predicate on the "schema_int" field.
func SchemaIntNotIn(vs ...schema.Int) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = int(vs[i])
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaInt, p.Without(v...))
	})
}

// SchemaIntGT applies the GT predicate on the "schema_int" field.
func SchemaIntGT(v schema.Int) predicate.FieldType {
	vc := int(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaInt, p.GT(vc))
	})
}

// SchemaIntGTE applies the GTE predicate on the "schema_int" field.
func SchemaIntGTE(v schema.Int) predicate.FieldType {
	vc := int(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaInt, p.GTE(vc))
	})
}

// SchemaIntLT applies the LT predicate on the "schema_int" field.
func SchemaIntLT(v schema.Int) predicate.FieldType {
	vc := int(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaInt, p.LT(vc))
	})
}

// SchemaIntLTE applies the LTE predicate on the "schema_int" field.
func SchemaIntLTE(v schema.Int) predicate.FieldType {
	vc := int(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaInt, p.LTE(vc))
	})
}

// SchemaIntIsNil applies the IsNil predicate on the "schema_int" field.
func SchemaIntIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldSchemaInt)
	})
}

// SchemaIntNotNil applies the NotNil predicate on the "schema_int" field.
func SchemaIntNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldSchemaInt)
	})
}

// SchemaInt8EQ applies the EQ predicate on the "schema_int8" field.
func SchemaInt8EQ(v schema.Int8) predicate.FieldType {
	vc := int8(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaInt8, p.EQ(vc))
	})
}

// SchemaInt8NEQ applies the NEQ predicate on the "schema_int8" field.
func SchemaInt8NEQ(v schema.Int8) predicate.FieldType {
	vc := int8(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaInt8, p.NEQ(vc))
	})
}

// SchemaInt8In applies the In predicate on the "schema_int8" field.
func SchemaInt8In(vs ...schema.Int8) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = int8(vs[i])
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaInt8, p.Within(v...))
	})
}

// SchemaInt8NotIn applies the NotIn predicate on the "schema_int8" field.
func SchemaInt8NotIn(vs ...schema.Int8) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = int8(vs[i])
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaInt8, p.Without(v...))
	})
}

// SchemaInt8GT applies the GT predicate on the "schema_int8" field.
func SchemaInt8GT(v schema.Int8) predicate.FieldType {
	vc := int8(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaInt8, p.GT(vc))
	})
}

// SchemaInt8GTE applies the GTE predicate on the "schema_int8" field.
func SchemaInt8GTE(v schema.Int8) predicate.FieldType {
	vc := int8(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaInt8, p.GTE(vc))
	})
}

// SchemaInt8LT applies the LT predicate on the "schema_int8" field.
func SchemaInt8LT(v schema.Int8) predicate.FieldType {
	vc := int8(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaInt8, p.LT(vc))
	})
}

// SchemaInt8LTE applies the LTE predicate on the "schema_int8" field.
func SchemaInt8LTE(v schema.Int8) predicate.FieldType {
	vc := int8(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaInt8, p.LTE(vc))
	})
}

// SchemaInt8IsNil applies the IsNil predicate on the "schema_int8" field.
func SchemaInt8IsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldSchemaInt8)
	})
}

// SchemaInt8NotNil applies the NotNil predicate on the "schema_int8" field.
func SchemaInt8NotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldSchemaInt8)
	})
}

// SchemaInt64EQ applies the EQ predicate on the "schema_int64" field.
func SchemaInt64EQ(v schema.Int64) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaInt64, p.EQ(vc))
	})
}

// SchemaInt64NEQ applies the NEQ predicate on the "schema_int64" field.
func SchemaInt64NEQ(v schema.Int64) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaInt64, p.NEQ(vc))
	})
}

// SchemaInt64In applies the In predicate on the "schema_int64" field.
func SchemaInt64In(vs ...schema.Int64) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = int64(vs[i])
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaInt64, p.Within(v...))
	})
}

// SchemaInt64NotIn applies the NotIn predicate on the "schema_int64" field.
func SchemaInt64NotIn(vs ...schema.Int64) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = int64(vs[i])
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaInt64, p.Without(v...))
	})
}

// SchemaInt64GT applies the GT predicate on the "schema_int64" field.
func SchemaInt64GT(v schema.Int64) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaInt64, p.GT(vc))
	})
}

// SchemaInt64GTE applies the GTE predicate on the "schema_int64" field.
func SchemaInt64GTE(v schema.Int64) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaInt64, p.GTE(vc))
	})
}

// SchemaInt64LT applies the LT predicate on the "schema_int64" field.
func SchemaInt64LT(v schema.Int64) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaInt64, p.LT(vc))
	})
}

// SchemaInt64LTE applies the LTE predicate on the "schema_int64" field.
func SchemaInt64LTE(v schema.Int64) predicate.FieldType {
	vc := int64(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaInt64, p.LTE(vc))
	})
}

// SchemaInt64IsNil applies the IsNil predicate on the "schema_int64" field.
func SchemaInt64IsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldSchemaInt64)
	})
}

// SchemaInt64NotNil applies the NotNil predicate on the "schema_int64" field.
func SchemaInt64NotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldSchemaInt64)
	})
}

// SchemaFloatEQ applies the EQ predicate on the "schema_float" field.
func SchemaFloatEQ(v schema.Float64) predicate.FieldType {
	vc := float64(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaFloat, p.EQ(vc))
	})
}

// SchemaFloatNEQ applies the NEQ predicate on the "schema_float" field.
func SchemaFloatNEQ(v schema.Float64) predicate.FieldType {
	vc := float64(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaFloat, p.NEQ(vc))
	})
}

// SchemaFloatIn applies the In predicate on the "schema_float" field.
func SchemaFloatIn(vs ...schema.Float64) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = float64(vs[i])
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaFloat, p.Within(v...))
	})
}

// SchemaFloatNotIn applies the NotIn predicate on the "schema_float" field.
func SchemaFloatNotIn(vs ...schema.Float64) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = float64(vs[i])
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaFloat, p.Without(v...))
	})
}

// SchemaFloatGT applies the GT predicate on the "schema_float" field.
func SchemaFloatGT(v schema.Float64) predicate.FieldType {
	vc := float64(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaFloat, p.GT(vc))
	})
}

// SchemaFloatGTE applies the GTE predicate on the "schema_float" field.
func SchemaFloatGTE(v schema.Float64) predicate.FieldType {
	vc := float64(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaFloat, p.GTE(vc))
	})
}

// SchemaFloatLT applies the LT predicate on the "schema_float" field.
func SchemaFloatLT(v schema.Float64) predicate.FieldType {
	vc := float64(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaFloat, p.LT(vc))
	})
}

// SchemaFloatLTE applies the LTE predicate on the "schema_float" field.
func SchemaFloatLTE(v schema.Float64) predicate.FieldType {
	vc := float64(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaFloat, p.LTE(vc))
	})
}

// SchemaFloatIsNil applies the IsNil predicate on the "schema_float" field.
func SchemaFloatIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldSchemaFloat)
	})
}

// SchemaFloatNotNil applies the NotNil predicate on the "schema_float" field.
func SchemaFloatNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldSchemaFloat)
	})
}

// SchemaFloat32EQ applies the EQ predicate on the "schema_float32" field.
func SchemaFloat32EQ(v schema.Float32) predicate.FieldType {
	vc := float32(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaFloat32, p.EQ(vc))
	})
}

// SchemaFloat32NEQ applies the NEQ predicate on the "schema_float32" field.
func SchemaFloat32NEQ(v schema.Float32) predicate.FieldType {
	vc := float32(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaFloat32, p.NEQ(vc))
	})
}

// SchemaFloat32In applies the In predicate on the "schema_float32" field.
func SchemaFloat32In(vs ...schema.Float32) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = float32(vs[i])
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaFloat32, p.Within(v...))
	})
}

// SchemaFloat32NotIn applies the NotIn predicate on the "schema_float32" field.
func SchemaFloat32NotIn(vs ...schema.Float32) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = float32(vs[i])
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaFloat32, p.Without(v...))
	})
}

// SchemaFloat32GT applies the GT predicate on the "schema_float32" field.
func SchemaFloat32GT(v schema.Float32) predicate.FieldType {
	vc := float32(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaFloat32, p.GT(vc))
	})
}

// SchemaFloat32GTE applies the GTE predicate on the "schema_float32" field.
func SchemaFloat32GTE(v schema.Float32) predicate.FieldType {
	vc := float32(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaFloat32, p.GTE(vc))
	})
}

// SchemaFloat32LT applies the LT predicate on the "schema_float32" field.
func SchemaFloat32LT(v schema.Float32) predicate.FieldType {
	vc := float32(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaFloat32, p.LT(vc))
	})
}

// SchemaFloat32LTE applies the LTE predicate on the "schema_float32" field.
func SchemaFloat32LTE(v schema.Float32) predicate.FieldType {
	vc := float32(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldSchemaFloat32, p.LTE(vc))
	})
}

// SchemaFloat32IsNil applies the IsNil predicate on the "schema_float32" field.
func SchemaFloat32IsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldSchemaFloat32)
	})
}

// SchemaFloat32NotNil applies the NotNil predicate on the "schema_float32" field.
func SchemaFloat32NotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldSchemaFloat32)
	})
}

// NullFloatEQ applies the EQ predicate on the "null_float" field.
func NullFloatEQ(v *sql.NullFloat64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullFloat, p.EQ(v))
	})
}

// NullFloatNEQ applies the NEQ predicate on the "null_float" field.
func NullFloatNEQ(v *sql.NullFloat64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullFloat, p.NEQ(v))
	})
}

// NullFloatIn applies the In predicate on the "null_float" field.
func NullFloatIn(vs ...*sql.NullFloat64) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullFloat, p.Within(v...))
	})
}

// NullFloatNotIn applies the NotIn predicate on the "null_float" field.
func NullFloatNotIn(vs ...*sql.NullFloat64) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullFloat, p.Without(v...))
	})
}

// NullFloatGT applies the GT predicate on the "null_float" field.
func NullFloatGT(v *sql.NullFloat64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullFloat, p.GT(v))
	})
}

// NullFloatGTE applies the GTE predicate on the "null_float" field.
func NullFloatGTE(v *sql.NullFloat64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullFloat, p.GTE(v))
	})
}

// NullFloatLT applies the LT predicate on the "null_float" field.
func NullFloatLT(v *sql.NullFloat64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullFloat, p.LT(v))
	})
}

// NullFloatLTE applies the LTE predicate on the "null_float" field.
func NullFloatLTE(v *sql.NullFloat64) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNullFloat, p.LTE(v))
	})
}

// NullFloatIsNil applies the IsNil predicate on the "null_float" field.
func NullFloatIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldNullFloat)
	})
}

// NullFloatNotNil applies the NotNil predicate on the "null_float" field.
func NullFloatNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldNullFloat)
	})
}

// RoleEQ applies the EQ predicate on the "role" field.
func RoleEQ(v role.Role) predicate.FieldType {
	vc := v
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldRole, p.EQ(vc))
	})
}

// RoleNEQ applies the NEQ predicate on the "role" field.
func RoleNEQ(v role.Role) predicate.FieldType {
	vc := v
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldRole, p.NEQ(vc))
	})
}

// RoleIn applies the In predicate on the "role" field.
func RoleIn(vs ...role.Role) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldRole, p.Within(v...))
	})
}

// RoleNotIn applies the NotIn predicate on the "role" field.
func RoleNotIn(vs ...role.Role) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldRole, p.Without(v...))
	})
}

// PriorityEQ applies the EQ predicate on the "priority" field.
func PriorityEQ(v role.Priority) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldPriority, p.EQ(v))
	})
}

// PriorityNEQ applies the NEQ predicate on the "priority" field.
func PriorityNEQ(v role.Priority) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldPriority, p.NEQ(v))
	})
}

// PriorityIn applies the In predicate on the "priority" field.
func PriorityIn(vs ...role.Priority) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldPriority, p.Within(v...))
	})
}

// PriorityNotIn applies the NotIn predicate on the "priority" field.
func PriorityNotIn(vs ...role.Priority) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldPriority, p.Without(v...))
	})
}

// PriorityIsNil applies the IsNil predicate on the "priority" field.
func PriorityIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldPriority)
	})
}

// PriorityNotNil applies the NotNil predicate on the "priority" field.
func PriorityNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldPriority)
	})
}

// OptionalUUIDEQ applies the EQ predicate on the "optional_uuid" field.
func OptionalUUIDEQ(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUUID, p.EQ(v))
	})
}

// OptionalUUIDNEQ applies the NEQ predicate on the "optional_uuid" field.
func OptionalUUIDNEQ(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUUID, p.NEQ(v))
	})
}

// OptionalUUIDIn applies the In predicate on the "optional_uuid" field.
func OptionalUUIDIn(vs ...uuid.UUID) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUUID, p.Within(v...))
	})
}

// OptionalUUIDNotIn applies the NotIn predicate on the "optional_uuid" field.
func OptionalUUIDNotIn(vs ...uuid.UUID) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUUID, p.Without(v...))
	})
}

// OptionalUUIDGT applies the GT predicate on the "optional_uuid" field.
func OptionalUUIDGT(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUUID, p.GT(v))
	})
}

// OptionalUUIDGTE applies the GTE predicate on the "optional_uuid" field.
func OptionalUUIDGTE(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUUID, p.GTE(v))
	})
}

// OptionalUUIDLT applies the LT predicate on the "optional_uuid" field.
func OptionalUUIDLT(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUUID, p.LT(v))
	})
}

// OptionalUUIDLTE applies the LTE predicate on the "optional_uuid" field.
func OptionalUUIDLTE(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldOptionalUUID, p.LTE(v))
	})
}

// OptionalUUIDIsNil applies the IsNil predicate on the "optional_uuid" field.
func OptionalUUIDIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldOptionalUUID)
	})
}

// OptionalUUIDNotNil applies the NotNil predicate on the "optional_uuid" field.
func OptionalUUIDNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldOptionalUUID)
	})
}

// NillableUUIDEQ applies the EQ predicate on the "nillable_uuid" field.
func NillableUUIDEQ(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableUUID, p.EQ(v))
	})
}

// NillableUUIDNEQ applies the NEQ predicate on the "nillable_uuid" field.
func NillableUUIDNEQ(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableUUID, p.NEQ(v))
	})
}

// NillableUUIDIn applies the In predicate on the "nillable_uuid" field.
func NillableUUIDIn(vs ...uuid.UUID) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableUUID, p.Within(v...))
	})
}

// NillableUUIDNotIn applies the NotIn predicate on the "nillable_uuid" field.
func NillableUUIDNotIn(vs ...uuid.UUID) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableUUID, p.Without(v...))
	})
}

// NillableUUIDGT applies the GT predicate on the "nillable_uuid" field.
func NillableUUIDGT(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableUUID, p.GT(v))
	})
}

// NillableUUIDGTE applies the GTE predicate on the "nillable_uuid" field.
func NillableUUIDGTE(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableUUID, p.GTE(v))
	})
}

// NillableUUIDLT applies the LT predicate on the "nillable_uuid" field.
func NillableUUIDLT(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableUUID, p.LT(v))
	})
}

// NillableUUIDLTE applies the LTE predicate on the "nillable_uuid" field.
func NillableUUIDLTE(v uuid.UUID) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNillableUUID, p.LTE(v))
	})
}

// NillableUUIDIsNil applies the IsNil predicate on the "nillable_uuid" field.
func NillableUUIDIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldNillableUUID)
	})
}

// NillableUUIDNotNil applies the NotNil predicate on the "nillable_uuid" field.
func NillableUUIDNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldNillableUUID)
	})
}

// StringsIsNil applies the IsNil predicate on the "strings" field.
func StringsIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldStrings)
	})
}

// StringsNotNil applies the NotNil predicate on the "strings" field.
func StringsNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldStrings)
	})
}

// PairEQ applies the EQ predicate on the "pair" field.
func PairEQ(v schema.Pair) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldPair, p.EQ(v))
	})
}

// PairNEQ applies the NEQ predicate on the "pair" field.
func PairNEQ(v schema.Pair) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldPair, p.NEQ(v))
	})
}

// PairIn applies the In predicate on the "pair" field.
func PairIn(vs ...schema.Pair) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldPair, p.Within(v...))
	})
}

// PairNotIn applies the NotIn predicate on the "pair" field.
func PairNotIn(vs ...schema.Pair) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldPair, p.Without(v...))
	})
}

// PairGT applies the GT predicate on the "pair" field.
func PairGT(v schema.Pair) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldPair, p.GT(v))
	})
}

// PairGTE applies the GTE predicate on the "pair" field.
func PairGTE(v schema.Pair) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldPair, p.GTE(v))
	})
}

// PairLT applies the LT predicate on the "pair" field.
func PairLT(v schema.Pair) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldPair, p.LT(v))
	})
}

// PairLTE applies the LTE predicate on the "pair" field.
func PairLTE(v schema.Pair) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldPair, p.LTE(v))
	})
}

// NilPairEQ applies the EQ predicate on the "nil_pair" field.
func NilPairEQ(v *schema.Pair) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNilPair, p.EQ(v))
	})
}

// NilPairNEQ applies the NEQ predicate on the "nil_pair" field.
func NilPairNEQ(v *schema.Pair) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNilPair, p.NEQ(v))
	})
}

// NilPairIn applies the In predicate on the "nil_pair" field.
func NilPairIn(vs ...*schema.Pair) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNilPair, p.Within(v...))
	})
}

// NilPairNotIn applies the NotIn predicate on the "nil_pair" field.
func NilPairNotIn(vs ...*schema.Pair) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNilPair, p.Without(v...))
	})
}

// NilPairGT applies the GT predicate on the "nil_pair" field.
func NilPairGT(v *schema.Pair) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNilPair, p.GT(v))
	})
}

// NilPairGTE applies the GTE predicate on the "nil_pair" field.
func NilPairGTE(v *schema.Pair) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNilPair, p.GTE(v))
	})
}

// NilPairLT applies the LT predicate on the "nil_pair" field.
func NilPairLT(v *schema.Pair) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNilPair, p.LT(v))
	})
}

// NilPairLTE applies the LTE predicate on the "nil_pair" field.
func NilPairLTE(v *schema.Pair) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldNilPair, p.LTE(v))
	})
}

// NilPairIsNil applies the IsNil predicate on the "nil_pair" field.
func NilPairIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldNilPair)
	})
}

// NilPairNotNil applies the NotNil predicate on the "nil_pair" field.
func NilPairNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldNilPair)
	})
}

// VstringEQ applies the EQ predicate on the "vstring" field.
func VstringEQ(v schema.VString) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldVstring, p.EQ(v))
	})
}

// VstringNEQ applies the NEQ predicate on the "vstring" field.
func VstringNEQ(v schema.VString) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldVstring, p.NEQ(v))
	})
}

// VstringIn applies the In predicate on the "vstring" field.
func VstringIn(vs ...schema.VString) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldVstring, p.Within(v...))
	})
}

// VstringNotIn applies the NotIn predicate on the "vstring" field.
func VstringNotIn(vs ...schema.VString) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldVstring, p.Without(v...))
	})
}

// VstringGT applies the GT predicate on the "vstring" field.
func VstringGT(v schema.VString) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldVstring, p.GT(v))
	})
}

// VstringGTE applies the GTE predicate on the "vstring" field.
func VstringGTE(v schema.VString) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldVstring, p.GTE(v))
	})
}

// VstringLT applies the LT predicate on the "vstring" field.
func VstringLT(v schema.VString) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldVstring, p.LT(v))
	})
}

// VstringLTE applies the LTE predicate on the "vstring" field.
func VstringLTE(v schema.VString) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldVstring, p.LTE(v))
	})
}

// VstringContains applies the Contains predicate on the "vstring" field.
func VstringContains(v schema.VString) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldVstring, p.Containing(vc))
	})
}

// VstringHasPrefix applies the HasPrefix predicate on the "vstring" field.
func VstringHasPrefix(v schema.VString) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldVstring, p.StartingWith(vc))
	})
}

// VstringHasSuffix applies the HasSuffix predicate on the "vstring" field.
func VstringHasSuffix(v schema.VString) predicate.FieldType {
	vc := string(v)
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldVstring, p.EndingWith(vc))
	})
}

// TripleEQ applies the EQ predicate on the "triple" field.
func TripleEQ(v schema.Triple) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldTriple, p.EQ(v))
	})
}

// TripleNEQ applies the NEQ predicate on the "triple" field.
func TripleNEQ(v schema.Triple) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldTriple, p.NEQ(v))
	})
}

// TripleIn applies the In predicate on the "triple" field.
func TripleIn(vs ...schema.Triple) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldTriple, p.Within(v...))
	})
}

// TripleNotIn applies the NotIn predicate on the "triple" field.
func TripleNotIn(vs ...schema.Triple) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldTriple, p.Without(v...))
	})
}

// TripleGT applies the GT predicate on the "triple" field.
func TripleGT(v schema.Triple) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldTriple, p.GT(v))
	})
}

// TripleGTE applies the GTE predicate on the "triple" field.
func TripleGTE(v schema.Triple) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldTriple, p.GTE(v))
	})
}

// TripleLT applies the LT predicate on the "triple" field.
func TripleLT(v schema.Triple) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldTriple, p.LT(v))
	})
}

// TripleLTE applies the LTE predicate on the "triple" field.
func TripleLTE(v schema.Triple) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldTriple, p.LTE(v))
	})
}

// BigIntEQ applies the EQ predicate on the "big_int" field.
func BigIntEQ(v schema.BigInt) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldBigInt, p.EQ(v))
	})
}

// BigIntNEQ applies the NEQ predicate on the "big_int" field.
func BigIntNEQ(v schema.BigInt) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldBigInt, p.NEQ(v))
	})
}

// BigIntIn applies the In predicate on the "big_int" field.
func BigIntIn(vs ...schema.BigInt) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldBigInt, p.Within(v...))
	})
}

// BigIntNotIn applies the NotIn predicate on the "big_int" field.
func BigIntNotIn(vs ...schema.BigInt) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldBigInt, p.Without(v...))
	})
}

// BigIntGT applies the GT predicate on the "big_int" field.
func BigIntGT(v schema.BigInt) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldBigInt, p.GT(v))
	})
}

// BigIntGTE applies the GTE predicate on the "big_int" field.
func BigIntGTE(v schema.BigInt) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldBigInt, p.GTE(v))
	})
}

// BigIntLT applies the LT predicate on the "big_int" field.
func BigIntLT(v schema.BigInt) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldBigInt, p.LT(v))
	})
}

// BigIntLTE applies the LTE predicate on the "big_int" field.
func BigIntLTE(v schema.BigInt) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldBigInt, p.LTE(v))
	})
}

// BigIntIsNil applies the IsNil predicate on the "big_int" field.
func BigIntIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldBigInt)
	})
}

// BigIntNotNil applies the NotNil predicate on the "big_int" field.
func BigIntNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldBigInt)
	})
}

// PasswordOtherEQ applies the EQ predicate on the "password_other" field.
func PasswordOtherEQ(v schema.Password) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldPasswordOther, p.EQ(v))
	})
}

// PasswordOtherNEQ applies the NEQ predicate on the "password_other" field.
func PasswordOtherNEQ(v schema.Password) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldPasswordOther, p.NEQ(v))
	})
}

// PasswordOtherIn applies the In predicate on the "password_other" field.
func PasswordOtherIn(vs ...schema.Password) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldPasswordOther, p.Within(v...))
	})
}

// PasswordOtherNotIn applies the NotIn predicate on the "password_other" field.
func PasswordOtherNotIn(vs ...schema.Password) predicate.FieldType {
	v := make([]any, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldPasswordOther, p.Without(v...))
	})
}

// PasswordOtherGT applies the GT predicate on the "password_other" field.
func PasswordOtherGT(v schema.Password) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldPasswordOther, p.GT(v))
	})
}

// PasswordOtherGTE applies the GTE predicate on the "password_other" field.
func PasswordOtherGTE(v schema.Password) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldPasswordOther, p.GTE(v))
	})
}

// PasswordOtherLT applies the LT predicate on the "password_other" field.
func PasswordOtherLT(v schema.Password) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldPasswordOther, p.LT(v))
	})
}

// PasswordOtherLTE applies the LTE predicate on the "password_other" field.
func PasswordOtherLTE(v schema.Password) predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.Has(Label, FieldPasswordOther, p.LTE(v))
	})
}

// PasswordOtherIsNil applies the IsNil predicate on the "password_other" field.
func PasswordOtherIsNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).HasNot(FieldPasswordOther)
	})
}

// PasswordOtherNotNil applies the NotNil predicate on the "password_other" field.
func PasswordOtherNotNil() predicate.FieldType {
	return predicate.FieldType(func(t *dsl.Traversal) {
		t.HasLabel(Label).Has(FieldPasswordOther)
	})
}

// And groups predicates with the AND operator between them.
func And(predicates ...predicate.FieldType) predicate.FieldType {
	return predicate.FieldType(func(tr *dsl.Traversal) {
		trs := make([]any, 0, len(predicates))
		for _, p := range predicates {
			t := __.New()
			p(t)
			trs = append(trs, t)
		}
		tr.Where(__.And(trs...))
	})
}

// Or groups predicates with the OR operator between them.
func Or(predicates ...predicate.FieldType) predicate.FieldType {
	return predicate.FieldType(func(tr *dsl.Traversal) {
		trs := make([]any, 0, len(predicates))
		for _, p := range predicates {
			t := __.New()
			p(t)
			trs = append(trs, t)
		}
		tr.Where(__.Or(trs...))
	})
}

// Not applies the not operator on the given predicate.
func Not(p predicate.FieldType) predicate.FieldType {
	return predicate.FieldType(func(tr *dsl.Traversal) {
		t := __.New()
		p(t)
		tr.Where(__.Not(t))
	})
}
