package chroma

import (
	"testing"

	"github.com/alecthomas/assert"
)

func TestCoalesce(t *testing.T) {
	lexer := Coalesce(MustNewLexer(nil, Rules{
		"root": []Rule{
			{`[!@#$%^&*()]`, Punctuation, nil},
		},
	}))
	actual, err := Tokenise(lexer, nil, "!@#$")
	assert.NoError(t, err)
	expected := []*Token{{Punctuation, "!@#$"}}
	assert.Equal(t, expected, actual)
}
