package machinelearningservices

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AllocationState enumerates the values for allocation state.
type AllocationState string

const (
	// AllocationStateResizing ...
	AllocationStateResizing AllocationState = "Resizing"
	// AllocationStateSteady ...
	AllocationStateSteady AllocationState = "Steady"
)

// PossibleAllocationStateValues returns an array of possible values for the AllocationState const type.
func PossibleAllocationStateValues() []AllocationState {
	return []AllocationState{AllocationStateResizing, AllocationStateSteady}
}

// ApplicationSharingPolicy enumerates the values for application sharing policy.
type ApplicationSharingPolicy string

const (
	// ApplicationSharingPolicyPersonal ...
	ApplicationSharingPolicyPersonal ApplicationSharingPolicy = "Personal"
	// ApplicationSharingPolicyShared ...
	ApplicationSharingPolicyShared ApplicationSharingPolicy = "Shared"
)

// PossibleApplicationSharingPolicyValues returns an array of possible values for the ApplicationSharingPolicy const type.
func PossibleApplicationSharingPolicyValues() []ApplicationSharingPolicy {
	return []ApplicationSharingPolicy{ApplicationSharingPolicyPersonal, ApplicationSharingPolicyShared}
}

// ClusterPurpose enumerates the values for cluster purpose.
type ClusterPurpose string

const (
	// ClusterPurposeDenseProd ...
	ClusterPurposeDenseProd ClusterPurpose = "DenseProd"
	// ClusterPurposeDevTest ...
	ClusterPurposeDevTest ClusterPurpose = "DevTest"
	// ClusterPurposeFastProd ...
	ClusterPurposeFastProd ClusterPurpose = "FastProd"
)

// PossibleClusterPurposeValues returns an array of possible values for the ClusterPurpose const type.
func PossibleClusterPurposeValues() []ClusterPurpose {
	return []ClusterPurpose{ClusterPurposeDenseProd, ClusterPurposeDevTest, ClusterPurposeFastProd}
}

// ComputeInstanceAuthorizationType enumerates the values for compute instance authorization type.
type ComputeInstanceAuthorizationType string

const (
	// ComputeInstanceAuthorizationTypePersonal ...
	ComputeInstanceAuthorizationTypePersonal ComputeInstanceAuthorizationType = "personal"
)

// PossibleComputeInstanceAuthorizationTypeValues returns an array of possible values for the ComputeInstanceAuthorizationType const type.
func PossibleComputeInstanceAuthorizationTypeValues() []ComputeInstanceAuthorizationType {
	return []ComputeInstanceAuthorizationType{ComputeInstanceAuthorizationTypePersonal}
}

// ComputeInstanceState enumerates the values for compute instance state.
type ComputeInstanceState string

const (
	// ComputeInstanceStateCreateFailed ...
	ComputeInstanceStateCreateFailed ComputeInstanceState = "CreateFailed"
	// ComputeInstanceStateCreating ...
	ComputeInstanceStateCreating ComputeInstanceState = "Creating"
	// ComputeInstanceStateDeleting ...
	ComputeInstanceStateDeleting ComputeInstanceState = "Deleting"
	// ComputeInstanceStateJobRunning ...
	ComputeInstanceStateJobRunning ComputeInstanceState = "JobRunning"
	// ComputeInstanceStateRestarting ...
	ComputeInstanceStateRestarting ComputeInstanceState = "Restarting"
	// ComputeInstanceStateRunning ...
	ComputeInstanceStateRunning ComputeInstanceState = "Running"
	// ComputeInstanceStateSettingUp ...
	ComputeInstanceStateSettingUp ComputeInstanceState = "SettingUp"
	// ComputeInstanceStateSetupFailed ...
	ComputeInstanceStateSetupFailed ComputeInstanceState = "SetupFailed"
	// ComputeInstanceStateStarting ...
	ComputeInstanceStateStarting ComputeInstanceState = "Starting"
	// ComputeInstanceStateStopped ...
	ComputeInstanceStateStopped ComputeInstanceState = "Stopped"
	// ComputeInstanceStateStopping ...
	ComputeInstanceStateStopping ComputeInstanceState = "Stopping"
	// ComputeInstanceStateUnknown ...
	ComputeInstanceStateUnknown ComputeInstanceState = "Unknown"
	// ComputeInstanceStateUnusable ...
	ComputeInstanceStateUnusable ComputeInstanceState = "Unusable"
	// ComputeInstanceStateUserSettingUp ...
	ComputeInstanceStateUserSettingUp ComputeInstanceState = "UserSettingUp"
	// ComputeInstanceStateUserSetupFailed ...
	ComputeInstanceStateUserSetupFailed ComputeInstanceState = "UserSetupFailed"
)

// PossibleComputeInstanceStateValues returns an array of possible values for the ComputeInstanceState const type.
func PossibleComputeInstanceStateValues() []ComputeInstanceState {
	return []ComputeInstanceState{ComputeInstanceStateCreateFailed, ComputeInstanceStateCreating, ComputeInstanceStateDeleting, ComputeInstanceStateJobRunning, ComputeInstanceStateRestarting, ComputeInstanceStateRunning, ComputeInstanceStateSettingUp, ComputeInstanceStateSetupFailed, ComputeInstanceStateStarting, ComputeInstanceStateStopped, ComputeInstanceStateStopping, ComputeInstanceStateUnknown, ComputeInstanceStateUnusable, ComputeInstanceStateUserSettingUp, ComputeInstanceStateUserSetupFailed}
}

// ComputeType enumerates the values for compute type.
type ComputeType string

const (
	// ComputeTypeAKS ...
	ComputeTypeAKS ComputeType = "AKS"
	// ComputeTypeAmlCompute ...
	ComputeTypeAmlCompute ComputeType = "AmlCompute"
	// ComputeTypeComputeInstance ...
	ComputeTypeComputeInstance ComputeType = "ComputeInstance"
	// ComputeTypeDatabricks ...
	ComputeTypeDatabricks ComputeType = "Databricks"
	// ComputeTypeDataFactory ...
	ComputeTypeDataFactory ComputeType = "DataFactory"
	// ComputeTypeDataLakeAnalytics ...
	ComputeTypeDataLakeAnalytics ComputeType = "DataLakeAnalytics"
	// ComputeTypeHDInsight ...
	ComputeTypeHDInsight ComputeType = "HDInsight"
	// ComputeTypeKubernetes ...
	ComputeTypeKubernetes ComputeType = "Kubernetes"
	// ComputeTypeSynapseSpark ...
	ComputeTypeSynapseSpark ComputeType = "SynapseSpark"
	// ComputeTypeVirtualMachine ...
	ComputeTypeVirtualMachine ComputeType = "VirtualMachine"
)

// PossibleComputeTypeValues returns an array of possible values for the ComputeType const type.
func PossibleComputeTypeValues() []ComputeType {
	return []ComputeType{ComputeTypeAKS, ComputeTypeAmlCompute, ComputeTypeComputeInstance, ComputeTypeDatabricks, ComputeTypeDataFactory, ComputeTypeDataLakeAnalytics, ComputeTypeHDInsight, ComputeTypeKubernetes, ComputeTypeSynapseSpark, ComputeTypeVirtualMachine}
}

// ComputeTypeBasicCompute enumerates the values for compute type basic compute.
type ComputeTypeBasicCompute string

const (
	// ComputeTypeBasicComputeComputeTypeAKS ...
	ComputeTypeBasicComputeComputeTypeAKS ComputeTypeBasicCompute = "AKS"
	// ComputeTypeBasicComputeComputeTypeAmlCompute ...
	ComputeTypeBasicComputeComputeTypeAmlCompute ComputeTypeBasicCompute = "AmlCompute"
	// ComputeTypeBasicComputeComputeTypeCompute ...
	ComputeTypeBasicComputeComputeTypeCompute ComputeTypeBasicCompute = "Compute"
	// ComputeTypeBasicComputeComputeTypeComputeInstance ...
	ComputeTypeBasicComputeComputeTypeComputeInstance ComputeTypeBasicCompute = "ComputeInstance"
	// ComputeTypeBasicComputeComputeTypeDatabricks ...
	ComputeTypeBasicComputeComputeTypeDatabricks ComputeTypeBasicCompute = "Databricks"
	// ComputeTypeBasicComputeComputeTypeDataFactory ...
	ComputeTypeBasicComputeComputeTypeDataFactory ComputeTypeBasicCompute = "DataFactory"
	// ComputeTypeBasicComputeComputeTypeDataLakeAnalytics ...
	ComputeTypeBasicComputeComputeTypeDataLakeAnalytics ComputeTypeBasicCompute = "DataLakeAnalytics"
	// ComputeTypeBasicComputeComputeTypeHDInsight ...
	ComputeTypeBasicComputeComputeTypeHDInsight ComputeTypeBasicCompute = "HDInsight"
	// ComputeTypeBasicComputeComputeTypeSynapseSpark ...
	ComputeTypeBasicComputeComputeTypeSynapseSpark ComputeTypeBasicCompute = "SynapseSpark"
	// ComputeTypeBasicComputeComputeTypeVirtualMachine ...
	ComputeTypeBasicComputeComputeTypeVirtualMachine ComputeTypeBasicCompute = "VirtualMachine"
)

// PossibleComputeTypeBasicComputeValues returns an array of possible values for the ComputeTypeBasicCompute const type.
func PossibleComputeTypeBasicComputeValues() []ComputeTypeBasicCompute {
	return []ComputeTypeBasicCompute{ComputeTypeBasicComputeComputeTypeAKS, ComputeTypeBasicComputeComputeTypeAmlCompute, ComputeTypeBasicComputeComputeTypeCompute, ComputeTypeBasicComputeComputeTypeComputeInstance, ComputeTypeBasicComputeComputeTypeDatabricks, ComputeTypeBasicComputeComputeTypeDataFactory, ComputeTypeBasicComputeComputeTypeDataLakeAnalytics, ComputeTypeBasicComputeComputeTypeHDInsight, ComputeTypeBasicComputeComputeTypeSynapseSpark, ComputeTypeBasicComputeComputeTypeVirtualMachine}
}

// ComputeTypeBasicComputeSecrets enumerates the values for compute type basic compute secrets.
type ComputeTypeBasicComputeSecrets string

const (
	// ComputeTypeBasicComputeSecretsComputeTypeComputeSecrets ...
	ComputeTypeBasicComputeSecretsComputeTypeComputeSecrets ComputeTypeBasicComputeSecrets = "ComputeSecrets"
	// ComputeTypeBasicComputeSecretsComputeTypeVirtualMachine ...
	ComputeTypeBasicComputeSecretsComputeTypeVirtualMachine ComputeTypeBasicComputeSecrets = "VirtualMachine"
)

// PossibleComputeTypeBasicComputeSecretsValues returns an array of possible values for the ComputeTypeBasicComputeSecrets const type.
func PossibleComputeTypeBasicComputeSecretsValues() []ComputeTypeBasicComputeSecrets {
	return []ComputeTypeBasicComputeSecrets{ComputeTypeBasicComputeSecretsComputeTypeComputeSecrets, ComputeTypeBasicComputeSecretsComputeTypeVirtualMachine}
}

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// CreatedByTypeApplication ...
	CreatedByTypeApplication CreatedByType = "Application"
	// CreatedByTypeKey ...
	CreatedByTypeKey CreatedByType = "Key"
	// CreatedByTypeManagedIdentity ...
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	// CreatedByTypeUser ...
	CreatedByTypeUser CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{CreatedByTypeApplication, CreatedByTypeKey, CreatedByTypeManagedIdentity, CreatedByTypeUser}
}

// DiagnoseResultLevel enumerates the values for diagnose result level.
type DiagnoseResultLevel string

const (
	// DiagnoseResultLevelError ...
	DiagnoseResultLevelError DiagnoseResultLevel = "Error"
	// DiagnoseResultLevelInformation ...
	DiagnoseResultLevelInformation DiagnoseResultLevel = "Information"
	// DiagnoseResultLevelWarning ...
	DiagnoseResultLevelWarning DiagnoseResultLevel = "Warning"
)

// PossibleDiagnoseResultLevelValues returns an array of possible values for the DiagnoseResultLevel const type.
func PossibleDiagnoseResultLevelValues() []DiagnoseResultLevel {
	return []DiagnoseResultLevel{DiagnoseResultLevelError, DiagnoseResultLevelInformation, DiagnoseResultLevelWarning}
}

// EncryptionStatus enumerates the values for encryption status.
type EncryptionStatus string

const (
	// EncryptionStatusDisabled ...
	EncryptionStatusDisabled EncryptionStatus = "Disabled"
	// EncryptionStatusEnabled ...
	EncryptionStatusEnabled EncryptionStatus = "Enabled"
)

// PossibleEncryptionStatusValues returns an array of possible values for the EncryptionStatus const type.
func PossibleEncryptionStatusValues() []EncryptionStatus {
	return []EncryptionStatus{EncryptionStatusDisabled, EncryptionStatusEnabled}
}

// LoadBalancerType enumerates the values for load balancer type.
type LoadBalancerType string

const (
	// LoadBalancerTypeInternalLoadBalancer ...
	LoadBalancerTypeInternalLoadBalancer LoadBalancerType = "InternalLoadBalancer"
	// LoadBalancerTypePublicIP ...
	LoadBalancerTypePublicIP LoadBalancerType = "PublicIp"
)

// PossibleLoadBalancerTypeValues returns an array of possible values for the LoadBalancerType const type.
func PossibleLoadBalancerTypeValues() []LoadBalancerType {
	return []LoadBalancerType{LoadBalancerTypeInternalLoadBalancer, LoadBalancerTypePublicIP}
}

// NodeState enumerates the values for node state.
type NodeState string

const (
	// NodeStateIdle ...
	NodeStateIdle NodeState = "idle"
	// NodeStateLeaving ...
	NodeStateLeaving NodeState = "leaving"
	// NodeStatePreempted ...
	NodeStatePreempted NodeState = "preempted"
	// NodeStatePreparing ...
	NodeStatePreparing NodeState = "preparing"
	// NodeStateRunning ...
	NodeStateRunning NodeState = "running"
	// NodeStateUnusable ...
	NodeStateUnusable NodeState = "unusable"
)

// PossibleNodeStateValues returns an array of possible values for the NodeState const type.
func PossibleNodeStateValues() []NodeState {
	return []NodeState{NodeStateIdle, NodeStateLeaving, NodeStatePreempted, NodeStatePreparing, NodeStateRunning, NodeStateUnusable}
}

// OperationName enumerates the values for operation name.
type OperationName string

const (
	// OperationNameCreate ...
	OperationNameCreate OperationName = "Create"
	// OperationNameDelete ...
	OperationNameDelete OperationName = "Delete"
	// OperationNameReimage ...
	OperationNameReimage OperationName = "Reimage"
	// OperationNameRestart ...
	OperationNameRestart OperationName = "Restart"
	// OperationNameStart ...
	OperationNameStart OperationName = "Start"
	// OperationNameStop ...
	OperationNameStop OperationName = "Stop"
)

// PossibleOperationNameValues returns an array of possible values for the OperationName const type.
func PossibleOperationNameValues() []OperationName {
	return []OperationName{OperationNameCreate, OperationNameDelete, OperationNameReimage, OperationNameRestart, OperationNameStart, OperationNameStop}
}

// OperationStatus enumerates the values for operation status.
type OperationStatus string

const (
	// OperationStatusCreateFailed ...
	OperationStatusCreateFailed OperationStatus = "CreateFailed"
	// OperationStatusDeleteFailed ...
	OperationStatusDeleteFailed OperationStatus = "DeleteFailed"
	// OperationStatusInProgress ...
	OperationStatusInProgress OperationStatus = "InProgress"
	// OperationStatusReimageFailed ...
	OperationStatusReimageFailed OperationStatus = "ReimageFailed"
	// OperationStatusRestartFailed ...
	OperationStatusRestartFailed OperationStatus = "RestartFailed"
	// OperationStatusStartFailed ...
	OperationStatusStartFailed OperationStatus = "StartFailed"
	// OperationStatusStopFailed ...
	OperationStatusStopFailed OperationStatus = "StopFailed"
	// OperationStatusSucceeded ...
	OperationStatusSucceeded OperationStatus = "Succeeded"
)

// PossibleOperationStatusValues returns an array of possible values for the OperationStatus const type.
func PossibleOperationStatusValues() []OperationStatus {
	return []OperationStatus{OperationStatusCreateFailed, OperationStatusDeleteFailed, OperationStatusInProgress, OperationStatusReimageFailed, OperationStatusRestartFailed, OperationStatusStartFailed, OperationStatusStopFailed, OperationStatusSucceeded}
}

// OsType enumerates the values for os type.
type OsType string

const (
	// OsTypeLinux ...
	OsTypeLinux OsType = "Linux"
	// OsTypeWindows ...
	OsTypeWindows OsType = "Windows"
)

// PossibleOsTypeValues returns an array of possible values for the OsType const type.
func PossibleOsTypeValues() []OsType {
	return []OsType{OsTypeLinux, OsTypeWindows}
}

// PrivateEndpointConnectionProvisioningState enumerates the values for private endpoint connection
// provisioning state.
type PrivateEndpointConnectionProvisioningState string

const (
	// PrivateEndpointConnectionProvisioningStateCreating ...
	PrivateEndpointConnectionProvisioningStateCreating PrivateEndpointConnectionProvisioningState = "Creating"
	// PrivateEndpointConnectionProvisioningStateDeleting ...
	PrivateEndpointConnectionProvisioningStateDeleting PrivateEndpointConnectionProvisioningState = "Deleting"
	// PrivateEndpointConnectionProvisioningStateFailed ...
	PrivateEndpointConnectionProvisioningStateFailed PrivateEndpointConnectionProvisioningState = "Failed"
	// PrivateEndpointConnectionProvisioningStateSucceeded ...
	PrivateEndpointConnectionProvisioningStateSucceeded PrivateEndpointConnectionProvisioningState = "Succeeded"
)

// PossiblePrivateEndpointConnectionProvisioningStateValues returns an array of possible values for the PrivateEndpointConnectionProvisioningState const type.
func PossiblePrivateEndpointConnectionProvisioningStateValues() []PrivateEndpointConnectionProvisioningState {
	return []PrivateEndpointConnectionProvisioningState{PrivateEndpointConnectionProvisioningStateCreating, PrivateEndpointConnectionProvisioningStateDeleting, PrivateEndpointConnectionProvisioningStateFailed, PrivateEndpointConnectionProvisioningStateSucceeded}
}

// PrivateEndpointServiceConnectionStatus enumerates the values for private endpoint service connection status.
type PrivateEndpointServiceConnectionStatus string

const (
	// PrivateEndpointServiceConnectionStatusApproved ...
	PrivateEndpointServiceConnectionStatusApproved PrivateEndpointServiceConnectionStatus = "Approved"
	// PrivateEndpointServiceConnectionStatusDisconnected ...
	PrivateEndpointServiceConnectionStatusDisconnected PrivateEndpointServiceConnectionStatus = "Disconnected"
	// PrivateEndpointServiceConnectionStatusPending ...
	PrivateEndpointServiceConnectionStatusPending PrivateEndpointServiceConnectionStatus = "Pending"
	// PrivateEndpointServiceConnectionStatusRejected ...
	PrivateEndpointServiceConnectionStatusRejected PrivateEndpointServiceConnectionStatus = "Rejected"
	// PrivateEndpointServiceConnectionStatusTimeout ...
	PrivateEndpointServiceConnectionStatusTimeout PrivateEndpointServiceConnectionStatus = "Timeout"
)

// PossiblePrivateEndpointServiceConnectionStatusValues returns an array of possible values for the PrivateEndpointServiceConnectionStatus const type.
func PossiblePrivateEndpointServiceConnectionStatusValues() []PrivateEndpointServiceConnectionStatus {
	return []PrivateEndpointServiceConnectionStatus{PrivateEndpointServiceConnectionStatusApproved, PrivateEndpointServiceConnectionStatusDisconnected, PrivateEndpointServiceConnectionStatusPending, PrivateEndpointServiceConnectionStatusRejected, PrivateEndpointServiceConnectionStatusTimeout}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCanceled ...
	ProvisioningStateCanceled ProvisioningState = "Canceled"
	// ProvisioningStateCreating ...
	ProvisioningStateCreating ProvisioningState = "Creating"
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
	// ProvisioningStateUnknown ...
	ProvisioningStateUnknown ProvisioningState = "Unknown"
	// ProvisioningStateUpdating ...
	ProvisioningStateUpdating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCanceled, ProvisioningStateCreating, ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateSucceeded, ProvisioningStateUnknown, ProvisioningStateUpdating}
}

// PublicNetworkAccess enumerates the values for public network access.
type PublicNetworkAccess string

const (
	// PublicNetworkAccessDisabled ...
	PublicNetworkAccessDisabled PublicNetworkAccess = "Disabled"
	// PublicNetworkAccessEnabled ...
	PublicNetworkAccessEnabled PublicNetworkAccess = "Enabled"
)

// PossiblePublicNetworkAccessValues returns an array of possible values for the PublicNetworkAccess const type.
func PossiblePublicNetworkAccessValues() []PublicNetworkAccess {
	return []PublicNetworkAccess{PublicNetworkAccessDisabled, PublicNetworkAccessEnabled}
}

// QuotaUnit enumerates the values for quota unit.
type QuotaUnit string

const (
	// QuotaUnitCount ...
	QuotaUnitCount QuotaUnit = "Count"
)

// PossibleQuotaUnitValues returns an array of possible values for the QuotaUnit const type.
func PossibleQuotaUnitValues() []QuotaUnit {
	return []QuotaUnit{QuotaUnitCount}
}

// ReasonCode enumerates the values for reason code.
type ReasonCode string

const (
	// ReasonCodeNotAvailableForRegion ...
	ReasonCodeNotAvailableForRegion ReasonCode = "NotAvailableForRegion"
	// ReasonCodeNotAvailableForSubscription ...
	ReasonCodeNotAvailableForSubscription ReasonCode = "NotAvailableForSubscription"
	// ReasonCodeNotSpecified ...
	ReasonCodeNotSpecified ReasonCode = "NotSpecified"
)

// PossibleReasonCodeValues returns an array of possible values for the ReasonCode const type.
func PossibleReasonCodeValues() []ReasonCode {
	return []ReasonCode{ReasonCodeNotAvailableForRegion, ReasonCodeNotAvailableForSubscription, ReasonCodeNotSpecified}
}

// RemoteLoginPortPublicAccess enumerates the values for remote login port public access.
type RemoteLoginPortPublicAccess string

const (
	// RemoteLoginPortPublicAccessDisabled ...
	RemoteLoginPortPublicAccessDisabled RemoteLoginPortPublicAccess = "Disabled"
	// RemoteLoginPortPublicAccessEnabled ...
	RemoteLoginPortPublicAccessEnabled RemoteLoginPortPublicAccess = "Enabled"
	// RemoteLoginPortPublicAccessNotSpecified ...
	RemoteLoginPortPublicAccessNotSpecified RemoteLoginPortPublicAccess = "NotSpecified"
)

// PossibleRemoteLoginPortPublicAccessValues returns an array of possible values for the RemoteLoginPortPublicAccess const type.
func PossibleRemoteLoginPortPublicAccessValues() []RemoteLoginPortPublicAccess {
	return []RemoteLoginPortPublicAccess{RemoteLoginPortPublicAccessDisabled, RemoteLoginPortPublicAccessEnabled, RemoteLoginPortPublicAccessNotSpecified}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// ResourceIdentityTypeNone ...
	ResourceIdentityTypeNone ResourceIdentityType = "None"
	// ResourceIdentityTypeSystemAssigned ...
	ResourceIdentityTypeSystemAssigned ResourceIdentityType = "SystemAssigned"
	// ResourceIdentityTypeSystemAssignedUserAssigned ...
	ResourceIdentityTypeSystemAssignedUserAssigned ResourceIdentityType = "SystemAssigned,UserAssigned"
	// ResourceIdentityTypeUserAssigned ...
	ResourceIdentityTypeUserAssigned ResourceIdentityType = "UserAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{ResourceIdentityTypeNone, ResourceIdentityTypeSystemAssigned, ResourceIdentityTypeSystemAssignedUserAssigned, ResourceIdentityTypeUserAssigned}
}

// SSHPublicAccess enumerates the values for ssh public access.
type SSHPublicAccess string

const (
	// SSHPublicAccessDisabled ...
	SSHPublicAccessDisabled SSHPublicAccess = "Disabled"
	// SSHPublicAccessEnabled ...
	SSHPublicAccessEnabled SSHPublicAccess = "Enabled"
)

// PossibleSSHPublicAccessValues returns an array of possible values for the SSHPublicAccess const type.
func PossibleSSHPublicAccessValues() []SSHPublicAccess {
	return []SSHPublicAccess{SSHPublicAccessDisabled, SSHPublicAccessEnabled}
}

// Status enumerates the values for status.
type Status string

const (
	// StatusFailure ...
	StatusFailure Status = "Failure"
	// StatusInvalidQuotaBelowClusterMinimum ...
	StatusInvalidQuotaBelowClusterMinimum Status = "InvalidQuotaBelowClusterMinimum"
	// StatusInvalidQuotaExceedsSubscriptionLimit ...
	StatusInvalidQuotaExceedsSubscriptionLimit Status = "InvalidQuotaExceedsSubscriptionLimit"
	// StatusInvalidVMFamilyName ...
	StatusInvalidVMFamilyName Status = "InvalidVMFamilyName"
	// StatusOperationNotEnabledForRegion ...
	StatusOperationNotEnabledForRegion Status = "OperationNotEnabledForRegion"
	// StatusOperationNotSupportedForSku ...
	StatusOperationNotSupportedForSku Status = "OperationNotSupportedForSku"
	// StatusSuccess ...
	StatusSuccess Status = "Success"
	// StatusUndefined ...
	StatusUndefined Status = "Undefined"
)

// PossibleStatusValues returns an array of possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{StatusFailure, StatusInvalidQuotaBelowClusterMinimum, StatusInvalidQuotaExceedsSubscriptionLimit, StatusInvalidVMFamilyName, StatusOperationNotEnabledForRegion, StatusOperationNotSupportedForSku, StatusSuccess, StatusUndefined}
}

// Status1 enumerates the values for status 1.
type Status1 string

const (
	// Status1Auto ...
	Status1Auto Status1 = "Auto"
	// Status1Disabled ...
	Status1Disabled Status1 = "Disabled"
	// Status1Enabled ...
	Status1Enabled Status1 = "Enabled"
)

// PossibleStatus1Values returns an array of possible values for the Status1 const type.
func PossibleStatus1Values() []Status1 {
	return []Status1{Status1Auto, Status1Disabled, Status1Enabled}
}

// UnderlyingResourceAction enumerates the values for underlying resource action.
type UnderlyingResourceAction string

const (
	// UnderlyingResourceActionDelete ...
	UnderlyingResourceActionDelete UnderlyingResourceAction = "Delete"
	// UnderlyingResourceActionDetach ...
	UnderlyingResourceActionDetach UnderlyingResourceAction = "Detach"
)

// PossibleUnderlyingResourceActionValues returns an array of possible values for the UnderlyingResourceAction const type.
func PossibleUnderlyingResourceActionValues() []UnderlyingResourceAction {
	return []UnderlyingResourceAction{UnderlyingResourceActionDelete, UnderlyingResourceActionDetach}
}

// UsageUnit enumerates the values for usage unit.
type UsageUnit string

const (
	// UsageUnitCount ...
	UsageUnitCount UsageUnit = "Count"
)

// PossibleUsageUnitValues returns an array of possible values for the UsageUnit const type.
func PossibleUsageUnitValues() []UsageUnit {
	return []UsageUnit{UsageUnitCount}
}

// ValueFormat enumerates the values for value format.
type ValueFormat string

const (
	// ValueFormatJSON ...
	ValueFormatJSON ValueFormat = "JSON"
)

// PossibleValueFormatValues returns an array of possible values for the ValueFormat const type.
func PossibleValueFormatValues() []ValueFormat {
	return []ValueFormat{ValueFormatJSON}
}

// VMPriceOSType enumerates the values for vm price os type.
type VMPriceOSType string

const (
	// VMPriceOSTypeLinux ...
	VMPriceOSTypeLinux VMPriceOSType = "Linux"
	// VMPriceOSTypeWindows ...
	VMPriceOSTypeWindows VMPriceOSType = "Windows"
)

// PossibleVMPriceOSTypeValues returns an array of possible values for the VMPriceOSType const type.
func PossibleVMPriceOSTypeValues() []VMPriceOSType {
	return []VMPriceOSType{VMPriceOSTypeLinux, VMPriceOSTypeWindows}
}

// VMPriority enumerates the values for vm priority.
type VMPriority string

const (
	// VMPriorityDedicated ...
	VMPriorityDedicated VMPriority = "Dedicated"
	// VMPriorityLowPriority ...
	VMPriorityLowPriority VMPriority = "LowPriority"
)

// PossibleVMPriorityValues returns an array of possible values for the VMPriority const type.
func PossibleVMPriorityValues() []VMPriority {
	return []VMPriority{VMPriorityDedicated, VMPriorityLowPriority}
}

// VMTier enumerates the values for vm tier.
type VMTier string

const (
	// VMTierLowPriority ...
	VMTierLowPriority VMTier = "LowPriority"
	// VMTierSpot ...
	VMTierSpot VMTier = "Spot"
	// VMTierStandard ...
	VMTierStandard VMTier = "Standard"
)

// PossibleVMTierValues returns an array of possible values for the VMTier const type.
func PossibleVMTierValues() []VMTier {
	return []VMTier{VMTierLowPriority, VMTierSpot, VMTierStandard}
}
