package manifest

import (
	"go.podman.io/image/v5/internal/manifest"
)

// Schema2PlatformSpec describes the platform which a particular manifest is
// specialized for.
type Schema2PlatformSpec = manifest.Schema2PlatformSpec

// Schema2ManifestDescriptor references a platform-specific manifest.
type Schema2ManifestDescriptor = manifest.Schema2ManifestDescriptor

// Schema2List is a list of platform-specific manifests.
type Schema2List = manifest.Schema2ListPublic

// Schema2ListFromComponents creates a Schema2 manifest list instance from the
// supplied data.
func Schema2ListFromComponents(components []Schema2ManifestDescriptor) *Schema2List {
	return manifest.Schema2ListPublicFromComponents(components)
}

// Schema2ListClone creates a deep copy of the passed-in list.
func Schema2ListClone(list *Schema2List) *Schema2List {
	return manifest.Schema2ListPublicClone(list)
}

// Schema2ListFromManifest creates a Schema2 manifest list instance from marshalled
// JSON, presumably generated by encoding a Schema2 manifest list.
func Schema2ListFromManifest(manifestBlob []byte) (*Schema2List, error) {
	return manifest.Schema2ListPublicFromManifest(manifestBlob)
}
