// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/recommender/v1/recommendation.proto

package recommender

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	_struct "github.com/golang/protobuf/ptypes/struct"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	money "google.golang.org/genproto/googleapis/type/money"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The category of the impact.
type Impact_Category int32

const (
	// Default unspecified category. Don't use directly.
	Impact_CATEGORY_UNSPECIFIED Impact_Category = 0
	// Indicates a potential increase or decrease in cost.
	Impact_COST Impact_Category = 1
	// Indicates a potential increase or decrease in security.
	Impact_SECURITY Impact_Category = 2
	// Indicates a potential increase or decrease in performance.
	Impact_PERFORMANCE Impact_Category = 3
	// Indicates a potential increase or decrease in manageability.
	Impact_MANAGEABILITY Impact_Category = 4
)

var Impact_Category_name = map[int32]string{
	0: "CATEGORY_UNSPECIFIED",
	1: "COST",
	2: "SECURITY",
	3: "PERFORMANCE",
	4: "MANAGEABILITY",
}

var Impact_Category_value = map[string]int32{
	"CATEGORY_UNSPECIFIED": 0,
	"COST":                 1,
	"SECURITY":             2,
	"PERFORMANCE":          3,
	"MANAGEABILITY":        4,
}

func (x Impact_Category) String() string {
	return proto.EnumName(Impact_Category_name, int32(x))
}

func (Impact_Category) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4233d28f4e4aebcf, []int{6, 0}
}

// Represents Recommendation State
type RecommendationStateInfo_State int32

const (
	// Default state. Don't use directly.
	RecommendationStateInfo_STATE_UNSPECIFIED RecommendationStateInfo_State = 0
	// Recommendation is active and can be applied. Recommendations content can
	// be updated by Google.
	//
	// ACTIVE recommendations can be marked as CLAIMED, SUCCEEDED, or FAILED.
	RecommendationStateInfo_ACTIVE RecommendationStateInfo_State = 1
	// Recommendation is in claimed state. Recommendations content is
	// immutable and cannot be updated by Google.
	//
	// CLAIMED recommendations can be marked as CLAIMED, SUCCEEDED, or FAILED.
	RecommendationStateInfo_CLAIMED RecommendationStateInfo_State = 6
	// Recommendation is in succeeded state. Recommendations content is
	// immutable and cannot be updated by Google.
	//
	// SUCCEEDED recommendations can be marked as SUCCEEDED, or FAILED.
	RecommendationStateInfo_SUCCEEDED RecommendationStateInfo_State = 3
	// Recommendation is in failed state. Recommendations content is immutable
	// and cannot be updated by Google.
	//
	// FAILED recommendations can be marked as SUCCEEDED, or FAILED.
	RecommendationStateInfo_FAILED RecommendationStateInfo_State = 4
	// Recommendation is in dismissed state. Recommendation content can be
	// updated by Google.
	//
	// DISMISSED recommendations can be marked as ACTIVE.
	RecommendationStateInfo_DISMISSED RecommendationStateInfo_State = 5
)

var RecommendationStateInfo_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "ACTIVE",
	6: "CLAIMED",
	3: "SUCCEEDED",
	4: "FAILED",
	5: "DISMISSED",
}

var RecommendationStateInfo_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"ACTIVE":            1,
	"CLAIMED":           6,
	"SUCCEEDED":         3,
	"FAILED":            4,
	"DISMISSED":         5,
}

func (x RecommendationStateInfo_State) String() string {
	return proto.EnumName(RecommendationStateInfo_State_name, int32(x))
}

func (RecommendationStateInfo_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4233d28f4e4aebcf, []int{7, 0}
}

// A recommendation along with a suggested action. E.g., a rightsizing
// recommendation for an underutilized VM, IAM role recommendations, etc
type Recommendation struct {
	// Name of recommendation.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Free-form human readable summary in English. The maximum length is 500
	// characters.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Contains an identifier for a subtype of recommendations produced for the
	// same recommender. Subtype is a function of content and impact, meaning a
	// new subtype might be added when significant changes to `content` or
	// `primary_impact.category` are introduced. See the Recommenders section
	// to see a list of subtypes for a given Recommender.
	//
	// Examples:
	//   For recommender = "google.iam.policy.Recommender",
	//   recommender_subtype can be one of "REMOVE_ROLE"/"REPLACE_ROLE"
	RecommenderSubtype string `protobuf:"bytes,12,opt,name=recommender_subtype,json=recommenderSubtype,proto3" json:"recommender_subtype,omitempty"`
	// Last time this recommendation was refreshed by the system that created it
	// in the first place.
	LastRefreshTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=last_refresh_time,json=lastRefreshTime,proto3" json:"last_refresh_time,omitempty"`
	// The primary impact that this recommendation can have while trying to
	// optimize for one category.
	PrimaryImpact *Impact `protobuf:"bytes,5,opt,name=primary_impact,json=primaryImpact,proto3" json:"primary_impact,omitempty"`
	// Optional set of additional impact that this recommendation may have when
	// trying to optimize for the primary category. These may be positive
	// or negative.
	AdditionalImpact []*Impact `protobuf:"bytes,6,rep,name=additional_impact,json=additionalImpact,proto3" json:"additional_impact,omitempty"`
	// Content of the recommendation describing recommended changes to resources.
	Content *RecommendationContent `protobuf:"bytes,7,opt,name=content,proto3" json:"content,omitempty"`
	// Information for state. Contains state and metadata.
	StateInfo *RecommendationStateInfo `protobuf:"bytes,10,opt,name=state_info,json=stateInfo,proto3" json:"state_info,omitempty"`
	// Fingerprint of the Recommendation. Provides optimistic locking when
	// updating states.
	Etag                 string   `protobuf:"bytes,11,opt,name=etag,proto3" json:"etag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Recommendation) Reset()         { *m = Recommendation{} }
func (m *Recommendation) String() string { return proto.CompactTextString(m) }
func (*Recommendation) ProtoMessage()    {}
func (*Recommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_4233d28f4e4aebcf, []int{0}
}

func (m *Recommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation.Unmarshal(m, b)
}
func (m *Recommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation.Marshal(b, m, deterministic)
}
func (m *Recommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation.Merge(m, src)
}
func (m *Recommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation.Size(m)
}
func (m *Recommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation proto.InternalMessageInfo

func (m *Recommendation) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Recommendation) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Recommendation) GetRecommenderSubtype() string {
	if m != nil {
		return m.RecommenderSubtype
	}
	return ""
}

func (m *Recommendation) GetLastRefreshTime() *timestamp.Timestamp {
	if m != nil {
		return m.LastRefreshTime
	}
	return nil
}

func (m *Recommendation) GetPrimaryImpact() *Impact {
	if m != nil {
		return m.PrimaryImpact
	}
	return nil
}

func (m *Recommendation) GetAdditionalImpact() []*Impact {
	if m != nil {
		return m.AdditionalImpact
	}
	return nil
}

func (m *Recommendation) GetContent() *RecommendationContent {
	if m != nil {
		return m.Content
	}
	return nil
}

func (m *Recommendation) GetStateInfo() *RecommendationStateInfo {
	if m != nil {
		return m.StateInfo
	}
	return nil
}

func (m *Recommendation) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

// Contains what resources are changing and how they are changing.
type RecommendationContent struct {
	// Operations to one or more Google Cloud resources grouped in such a way
	// that, all operations within one group are expected to be performed
	// atomically and in an order.
	OperationGroups      []*OperationGroup `protobuf:"bytes,2,rep,name=operation_groups,json=operationGroups,proto3" json:"operation_groups,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *RecommendationContent) Reset()         { *m = RecommendationContent{} }
func (m *RecommendationContent) String() string { return proto.CompactTextString(m) }
func (*RecommendationContent) ProtoMessage()    {}
func (*RecommendationContent) Descriptor() ([]byte, []int) {
	return fileDescriptor_4233d28f4e4aebcf, []int{1}
}

func (m *RecommendationContent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RecommendationContent.Unmarshal(m, b)
}
func (m *RecommendationContent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RecommendationContent.Marshal(b, m, deterministic)
}
func (m *RecommendationContent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RecommendationContent.Merge(m, src)
}
func (m *RecommendationContent) XXX_Size() int {
	return xxx_messageInfo_RecommendationContent.Size(m)
}
func (m *RecommendationContent) XXX_DiscardUnknown() {
	xxx_messageInfo_RecommendationContent.DiscardUnknown(m)
}

var xxx_messageInfo_RecommendationContent proto.InternalMessageInfo

func (m *RecommendationContent) GetOperationGroups() []*OperationGroup {
	if m != nil {
		return m.OperationGroups
	}
	return nil
}

// Group of operations that need to be performed atomically.
type OperationGroup struct {
	// List of operations across one or more resources that belong to this group.
	// Loosely based on RFC6902 and should be performed in the order they appear.
	Operations           []*Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *OperationGroup) Reset()         { *m = OperationGroup{} }
func (m *OperationGroup) String() string { return proto.CompactTextString(m) }
func (*OperationGroup) ProtoMessage()    {}
func (*OperationGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_4233d28f4e4aebcf, []int{2}
}

func (m *OperationGroup) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OperationGroup.Unmarshal(m, b)
}
func (m *OperationGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OperationGroup.Marshal(b, m, deterministic)
}
func (m *OperationGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OperationGroup.Merge(m, src)
}
func (m *OperationGroup) XXX_Size() int {
	return xxx_messageInfo_OperationGroup.Size(m)
}
func (m *OperationGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_OperationGroup.DiscardUnknown(m)
}

var xxx_messageInfo_OperationGroup proto.InternalMessageInfo

func (m *OperationGroup) GetOperations() []*Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

// Contains an operation for a resource loosely based on the JSON-PATCH format
// with support for:
//
// * Custom filters for describing partial array patch.
// * Extended path values for describing nested arrays.
// * Custom fields for describing the resource for which the operation is being
//   described.
// * Allows extension to custom operations not natively supported by RFC6902.
// See https://tools.ietf.org/html/rfc6902 for details on the original RFC.
type Operation struct {
	// Type of this operation. Contains one of 'and', 'remove', 'replace', 'move',
	// 'copy', 'test' and custom operations. This field is case-insensitive and
	// always populated.
	Action string `protobuf:"bytes,1,opt,name=action,proto3" json:"action,omitempty"`
	// Type of GCP resource being modified/tested. This field is always populated.
	// Example: cloudresourcemanager.googleapis.com/Project,
	// compute.googleapis.com/Instance
	ResourceType string `protobuf:"bytes,2,opt,name=resource_type,json=resourceType,proto3" json:"resource_type,omitempty"`
	// Contains the fully qualified resource name. This field is always populated.
	// ex: //cloudresourcemanager.googleapis.com/projects/foo.
	Resource string `protobuf:"bytes,3,opt,name=resource,proto3" json:"resource,omitempty"`
	// Path to the target field being operated on. If the operation is at the
	// resource level, then path should be "/". This field is always populated.
	Path string `protobuf:"bytes,4,opt,name=path,proto3" json:"path,omitempty"`
	// Can be set with action 'copy' to copy resource configuration across
	// different resources of the same type. Example: A resource clone can be
	// done via action = 'copy', path = "/", from = "/",
	// source_resource = <source> and resource_name = <target>.
	// This field is empty for all other values of `action`.
	SourceResource string `protobuf:"bytes,5,opt,name=source_resource,json=sourceResource,proto3" json:"source_resource,omitempty"`
	// Can be set with action 'copy' or 'move' to indicate the source field within
	// resource or source_resource, ignored if provided for other operation types.
	SourcePath string `protobuf:"bytes,6,opt,name=source_path,json=sourcePath,proto3" json:"source_path,omitempty"`
	// One of the fields in the following block will be set and intend to
	// describe a value for 'path' field.
	//
	// Types that are valid to be assigned to PathValue:
	//	*Operation_Value
	//	*Operation_ValueMatcher
	PathValue isOperation_PathValue `protobuf_oneof:"path_value"`
	// Set of filters to apply if `path` refers to array elements or nested array
	// elements in order to narrow down to a single unique element that is being
	// tested/modified.
	// This is intended to be an exact match per filter. To perform advanced
	// matching, use path_value_matchers.
	//
	// * Example: {
	//   "/versions/*/name" : "it-123"
	//   "/versions/*/targetSize/percent": 20
	//  }
	// * Example: {
	//   "/bindings/*/role": "roles/admin"
	//   "/bindings/*/condition" : null
	//  }
	// * Example: {
	//   "/bindings/*/role": "roles/admin"
	//   "/bindings/*/members/*" : ["x@google.com", "y@google.com"]
	//  }
	// When both path_filters and path_value_matchers are set, an implicit AND
	// must be performed.
	PathFilters map[string]*_struct.Value `protobuf:"bytes,8,rep,name=path_filters,json=pathFilters,proto3" json:"path_filters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Similar to path_filters, this contains set of filters to apply if `path`
	// field referes to array elements. This is meant to support value matching
	// beyond exact match. To perform exact match, use path_filters.
	// When both path_filters and path_value_matchers are set, an implicit AND
	// must be performed.
	PathValueMatchers    map[string]*ValueMatcher `protobuf:"bytes,11,rep,name=path_value_matchers,json=pathValueMatchers,proto3" json:"path_value_matchers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *Operation) Reset()         { *m = Operation{} }
func (m *Operation) String() string { return proto.CompactTextString(m) }
func (*Operation) ProtoMessage()    {}
func (*Operation) Descriptor() ([]byte, []int) {
	return fileDescriptor_4233d28f4e4aebcf, []int{3}
}

func (m *Operation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Operation.Unmarshal(m, b)
}
func (m *Operation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Operation.Marshal(b, m, deterministic)
}
func (m *Operation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Operation.Merge(m, src)
}
func (m *Operation) XXX_Size() int {
	return xxx_messageInfo_Operation.Size(m)
}
func (m *Operation) XXX_DiscardUnknown() {
	xxx_messageInfo_Operation.DiscardUnknown(m)
}

var xxx_messageInfo_Operation proto.InternalMessageInfo

func (m *Operation) GetAction() string {
	if m != nil {
		return m.Action
	}
	return ""
}

func (m *Operation) GetResourceType() string {
	if m != nil {
		return m.ResourceType
	}
	return ""
}

func (m *Operation) GetResource() string {
	if m != nil {
		return m.Resource
	}
	return ""
}

func (m *Operation) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *Operation) GetSourceResource() string {
	if m != nil {
		return m.SourceResource
	}
	return ""
}

func (m *Operation) GetSourcePath() string {
	if m != nil {
		return m.SourcePath
	}
	return ""
}

type isOperation_PathValue interface {
	isOperation_PathValue()
}

type Operation_Value struct {
	Value *_struct.Value `protobuf:"bytes,7,opt,name=value,proto3,oneof"`
}

type Operation_ValueMatcher struct {
	ValueMatcher *ValueMatcher `protobuf:"bytes,10,opt,name=value_matcher,json=valueMatcher,proto3,oneof"`
}

func (*Operation_Value) isOperation_PathValue() {}

func (*Operation_ValueMatcher) isOperation_PathValue() {}

func (m *Operation) GetPathValue() isOperation_PathValue {
	if m != nil {
		return m.PathValue
	}
	return nil
}

func (m *Operation) GetValue() *_struct.Value {
	if x, ok := m.GetPathValue().(*Operation_Value); ok {
		return x.Value
	}
	return nil
}

func (m *Operation) GetValueMatcher() *ValueMatcher {
	if x, ok := m.GetPathValue().(*Operation_ValueMatcher); ok {
		return x.ValueMatcher
	}
	return nil
}

func (m *Operation) GetPathFilters() map[string]*_struct.Value {
	if m != nil {
		return m.PathFilters
	}
	return nil
}

func (m *Operation) GetPathValueMatchers() map[string]*ValueMatcher {
	if m != nil {
		return m.PathValueMatchers
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Operation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Operation_Value)(nil),
		(*Operation_ValueMatcher)(nil),
	}
}

// Contains various matching options for values for a GCP resource field.
type ValueMatcher struct {
	// Types that are valid to be assigned to MatchVariant:
	//	*ValueMatcher_MatchesPattern
	MatchVariant         isValueMatcher_MatchVariant `protobuf_oneof:"match_variant"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *ValueMatcher) Reset()         { *m = ValueMatcher{} }
func (m *ValueMatcher) String() string { return proto.CompactTextString(m) }
func (*ValueMatcher) ProtoMessage()    {}
func (*ValueMatcher) Descriptor() ([]byte, []int) {
	return fileDescriptor_4233d28f4e4aebcf, []int{4}
}

func (m *ValueMatcher) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ValueMatcher.Unmarshal(m, b)
}
func (m *ValueMatcher) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ValueMatcher.Marshal(b, m, deterministic)
}
func (m *ValueMatcher) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ValueMatcher.Merge(m, src)
}
func (m *ValueMatcher) XXX_Size() int {
	return xxx_messageInfo_ValueMatcher.Size(m)
}
func (m *ValueMatcher) XXX_DiscardUnknown() {
	xxx_messageInfo_ValueMatcher.DiscardUnknown(m)
}

var xxx_messageInfo_ValueMatcher proto.InternalMessageInfo

type isValueMatcher_MatchVariant interface {
	isValueMatcher_MatchVariant()
}

type ValueMatcher_MatchesPattern struct {
	MatchesPattern string `protobuf:"bytes,1,opt,name=matches_pattern,json=matchesPattern,proto3,oneof"`
}

func (*ValueMatcher_MatchesPattern) isValueMatcher_MatchVariant() {}

func (m *ValueMatcher) GetMatchVariant() isValueMatcher_MatchVariant {
	if m != nil {
		return m.MatchVariant
	}
	return nil
}

func (m *ValueMatcher) GetMatchesPattern() string {
	if x, ok := m.GetMatchVariant().(*ValueMatcher_MatchesPattern); ok {
		return x.MatchesPattern
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ValueMatcher) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ValueMatcher_MatchesPattern)(nil),
	}
}

// Contains metadata about how much money a recommendation can save or incur.
type CostProjection struct {
	// An approximate projection on amount saved or amount incurred. Negative cost
	// units indicate cost savings and positive cost units indicate increase.
	// See google.type.Money documentation for positive/negative units.
	Cost *money.Money `protobuf:"bytes,1,opt,name=cost,proto3" json:"cost,omitempty"`
	// Duration for which this cost applies.
	Duration             *duration.Duration `protobuf:"bytes,2,opt,name=duration,proto3" json:"duration,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *CostProjection) Reset()         { *m = CostProjection{} }
func (m *CostProjection) String() string { return proto.CompactTextString(m) }
func (*CostProjection) ProtoMessage()    {}
func (*CostProjection) Descriptor() ([]byte, []int) {
	return fileDescriptor_4233d28f4e4aebcf, []int{5}
}

func (m *CostProjection) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CostProjection.Unmarshal(m, b)
}
func (m *CostProjection) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CostProjection.Marshal(b, m, deterministic)
}
func (m *CostProjection) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CostProjection.Merge(m, src)
}
func (m *CostProjection) XXX_Size() int {
	return xxx_messageInfo_CostProjection.Size(m)
}
func (m *CostProjection) XXX_DiscardUnknown() {
	xxx_messageInfo_CostProjection.DiscardUnknown(m)
}

var xxx_messageInfo_CostProjection proto.InternalMessageInfo

func (m *CostProjection) GetCost() *money.Money {
	if m != nil {
		return m.Cost
	}
	return nil
}

func (m *CostProjection) GetDuration() *duration.Duration {
	if m != nil {
		return m.Duration
	}
	return nil
}

// Contains the impact a recommendation can have for a given category.
type Impact struct {
	// Category that is being targeted.
	Category Impact_Category `protobuf:"varint,1,opt,name=category,proto3,enum=google.cloud.recommender.v1.Impact_Category" json:"category,omitempty"`
	// Contains projections (if any) for this category.
	//
	// Types that are valid to be assigned to Projection:
	//	*Impact_CostProjection
	Projection           isImpact_Projection `protobuf_oneof:"projection"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *Impact) Reset()         { *m = Impact{} }
func (m *Impact) String() string { return proto.CompactTextString(m) }
func (*Impact) ProtoMessage()    {}
func (*Impact) Descriptor() ([]byte, []int) {
	return fileDescriptor_4233d28f4e4aebcf, []int{6}
}

func (m *Impact) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Impact.Unmarshal(m, b)
}
func (m *Impact) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Impact.Marshal(b, m, deterministic)
}
func (m *Impact) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Impact.Merge(m, src)
}
func (m *Impact) XXX_Size() int {
	return xxx_messageInfo_Impact.Size(m)
}
func (m *Impact) XXX_DiscardUnknown() {
	xxx_messageInfo_Impact.DiscardUnknown(m)
}

var xxx_messageInfo_Impact proto.InternalMessageInfo

func (m *Impact) GetCategory() Impact_Category {
	if m != nil {
		return m.Category
	}
	return Impact_CATEGORY_UNSPECIFIED
}

type isImpact_Projection interface {
	isImpact_Projection()
}

type Impact_CostProjection struct {
	CostProjection *CostProjection `protobuf:"bytes,100,opt,name=cost_projection,json=costProjection,proto3,oneof"`
}

func (*Impact_CostProjection) isImpact_Projection() {}

func (m *Impact) GetProjection() isImpact_Projection {
	if m != nil {
		return m.Projection
	}
	return nil
}

func (m *Impact) GetCostProjection() *CostProjection {
	if x, ok := m.GetProjection().(*Impact_CostProjection); ok {
		return x.CostProjection
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Impact) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Impact_CostProjection)(nil),
	}
}

// Information for state. Contains state and metadata.
type RecommendationStateInfo struct {
	// The state of the recommendation, Eg ACTIVE, SUCCEEDED, FAILED.
	State RecommendationStateInfo_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.recommender.v1.RecommendationStateInfo_State" json:"state,omitempty"`
	// A map of metadata for the state, provided by user or automations systems.
	StateMetadata        map[string]string `protobuf:"bytes,2,rep,name=state_metadata,json=stateMetadata,proto3" json:"state_metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *RecommendationStateInfo) Reset()         { *m = RecommendationStateInfo{} }
func (m *RecommendationStateInfo) String() string { return proto.CompactTextString(m) }
func (*RecommendationStateInfo) ProtoMessage()    {}
func (*RecommendationStateInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_4233d28f4e4aebcf, []int{7}
}

func (m *RecommendationStateInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RecommendationStateInfo.Unmarshal(m, b)
}
func (m *RecommendationStateInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RecommendationStateInfo.Marshal(b, m, deterministic)
}
func (m *RecommendationStateInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RecommendationStateInfo.Merge(m, src)
}
func (m *RecommendationStateInfo) XXX_Size() int {
	return xxx_messageInfo_RecommendationStateInfo.Size(m)
}
func (m *RecommendationStateInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_RecommendationStateInfo.DiscardUnknown(m)
}

var xxx_messageInfo_RecommendationStateInfo proto.InternalMessageInfo

func (m *RecommendationStateInfo) GetState() RecommendationStateInfo_State {
	if m != nil {
		return m.State
	}
	return RecommendationStateInfo_STATE_UNSPECIFIED
}

func (m *RecommendationStateInfo) GetStateMetadata() map[string]string {
	if m != nil {
		return m.StateMetadata
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.recommender.v1.Impact_Category", Impact_Category_name, Impact_Category_value)
	proto.RegisterEnum("google.cloud.recommender.v1.RecommendationStateInfo_State", RecommendationStateInfo_State_name, RecommendationStateInfo_State_value)
	proto.RegisterType((*Recommendation)(nil), "google.cloud.recommender.v1.Recommendation")
	proto.RegisterType((*RecommendationContent)(nil), "google.cloud.recommender.v1.RecommendationContent")
	proto.RegisterType((*OperationGroup)(nil), "google.cloud.recommender.v1.OperationGroup")
	proto.RegisterType((*Operation)(nil), "google.cloud.recommender.v1.Operation")
	proto.RegisterMapType((map[string]*_struct.Value)(nil), "google.cloud.recommender.v1.Operation.PathFiltersEntry")
	proto.RegisterMapType((map[string]*ValueMatcher)(nil), "google.cloud.recommender.v1.Operation.PathValueMatchersEntry")
	proto.RegisterType((*ValueMatcher)(nil), "google.cloud.recommender.v1.ValueMatcher")
	proto.RegisterType((*CostProjection)(nil), "google.cloud.recommender.v1.CostProjection")
	proto.RegisterType((*Impact)(nil), "google.cloud.recommender.v1.Impact")
	proto.RegisterType((*RecommendationStateInfo)(nil), "google.cloud.recommender.v1.RecommendationStateInfo")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.recommender.v1.RecommendationStateInfo.StateMetadataEntry")
}

func init() {
	proto.RegisterFile("google/cloud/recommender/v1/recommendation.proto", fileDescriptor_4233d28f4e4aebcf)
}

var fileDescriptor_4233d28f4e4aebcf = []byte{
	// 1161 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x56, 0x5b, 0x6f, 0x1b, 0x45,
	0x14, 0x8e, 0x1d, 0xdb, 0x75, 0x8e, 0x6f, 0x9b, 0xe9, 0x6d, 0xeb, 0x22, 0x1a, 0xb9, 0x52, 0x69,
	0x45, 0xb5, 0x4b, 0x03, 0x08, 0x54, 0x84, 0xc0, 0x59, 0xaf, 0x13, 0x57, 0x71, 0x63, 0x8d, 0xdd,
	0x88, 0xf6, 0x65, 0x99, 0xae, 0x27, 0xae, 0xc1, 0xbb, 0xb3, 0xda, 0x1d, 0x47, 0x8a, 0xaa, 0x4a,
	0xfc, 0x04, 0x1e, 0x78, 0xe2, 0x91, 0x47, 0xf8, 0x5f, 0x3c, 0xf4, 0x4f, 0x80, 0xe6, 0xb2, 0xce,
	0xda, 0x0d, 0x56, 0x5a, 0xde, 0xe6, 0x5c, 0xbe, 0xef, 0xdc, 0xe6, 0xec, 0x2c, 0x7c, 0x36, 0x61,
	0x6c, 0x32, 0xa3, 0xb6, 0x3f, 0x63, 0xf3, 0xb1, 0x1d, 0x53, 0x9f, 0x05, 0x01, 0x0d, 0xc7, 0x34,
	0xb6, 0x4f, 0x1f, 0x9d, 0x8b, 0x84, 0x4f, 0x59, 0x68, 0x45, 0x31, 0xe3, 0x0c, 0xdd, 0x56, 0x08,
	0x4b, 0x22, 0xac, 0x0c, 0xc2, 0x3a, 0x7d, 0xd4, 0xbc, 0xa5, 0xe9, 0x48, 0x34, 0xb5, 0x63, 0x9a,
	0xb0, 0x79, 0xec, 0x53, 0x85, 0x6b, 0x7e, 0xac, 0x4d, 0x52, 0x7a, 0x39, 0x3f, 0xb1, 0xc7, 0xf3,
	0x38, 0xc3, 0xdb, 0xfc, 0x68, 0xd5, 0x9e, 0xf0, 0x78, 0xee, 0x73, 0x6d, 0xbd, 0xb3, 0x6a, 0xe5,
	0xd3, 0x80, 0x26, 0x9c, 0x04, 0x91, 0x76, 0xb8, 0xa9, 0x1d, 0xf8, 0x59, 0x44, 0xed, 0x80, 0x85,
	0xf4, 0x4c, 0x19, 0x5a, 0x7f, 0x15, 0xa1, 0x8e, 0x97, 0x0a, 0x41, 0x08, 0x0a, 0x21, 0x09, 0xa8,
	0x99, 0xdb, 0xc9, 0xdd, 0xdf, 0xc2, 0xf2, 0x8c, 0x76, 0xa0, 0x32, 0xa6, 0x89, 0x1f, 0x4f, 0x23,
	0xe1, 0x62, 0xe6, 0xa5, 0x29, 0xab, 0x42, 0x36, 0x5c, 0xcd, 0x54, 0xeb, 0x25, 0xf3, 0x97, 0x22,
	0x96, 0x59, 0x95, 0x9e, 0x28, 0x63, 0x1a, 0x2a, 0x0b, 0xea, 0xc2, 0xf6, 0x8c, 0x24, 0xdc, 0x8b,
	0xe9, 0x49, 0x4c, 0x93, 0x57, 0x9e, 0x48, 0xd9, 0x2c, 0xec, 0xe4, 0xee, 0x57, 0x76, 0x9b, 0x96,
	0xee, 0x62, 0x5a, 0x8f, 0x35, 0x4a, 0xeb, 0xc1, 0x0d, 0x01, 0xc2, 0x0a, 0x23, 0xb4, 0xe8, 0x09,
	0xd4, 0xa3, 0x78, 0x1a, 0x90, 0xf8, 0xcc, 0x9b, 0x06, 0x11, 0xf1, 0xb9, 0x59, 0x94, 0x24, 0x77,
	0xad, 0x35, 0xa3, 0xb0, 0x7a, 0xd2, 0x15, 0xd7, 0x34, 0x54, 0x89, 0x68, 0x00, 0xdb, 0x64, 0x3c,
	0x9e, 0x8a, 0x82, 0xc8, 0x2c, 0xa5, 0x2b, 0xed, 0x6c, 0x5e, 0x96, 0xce, 0x38, 0x47, 0x6b, 0xc6,
	0x43, 0xb8, 0xe2, 0xb3, 0x90, 0xd3, 0x90, 0x9b, 0x57, 0x64, 0x5a, 0xbb, 0x6b, 0x79, 0x96, 0x47,
	0xe1, 0x28, 0x24, 0x4e, 0x29, 0xd0, 0x10, 0x20, 0xe1, 0x84, 0x53, 0x6f, 0x1a, 0x9e, 0x30, 0x13,
	0x24, 0xe1, 0x17, 0xef, 0x41, 0x38, 0x14, 0xe0, 0x5e, 0x78, 0xc2, 0xf0, 0x56, 0x92, 0x1e, 0xc5,
	0xbc, 0x29, 0x27, 0x13, 0xb3, 0xa2, 0xe6, 0x2d, 0xce, 0x8f, 0x7f, 0xcb, 0xbd, 0x6d, 0xff, 0x9a,
	0x83, 0x07, 0x59, 0x36, 0x15, 0x86, 0x44, 0xd3, 0xc4, 0xf2, 0x59, 0x60, 0xaf, 0xdc, 0x1a, 0x3f,
	0x8a, 0xd9, 0x4f, 0xd4, 0xe7, 0x89, 0xfd, 0x5a, 0x9f, 0xde, 0xd8, 0x33, 0xe6, 0x4b, 0x63, 0x62,
	0xbf, 0x4e, 0x8f, 0x6f, 0xb2, 0x5b, 0x94, 0xd8, 0xaf, 0x33, 0xd2, 0x9b, 0x95, 0x8d, 0xca, 0x5a,
	0x15, 0xb6, 0xc5, 0xe0, 0xfa, 0x85, 0x1d, 0x42, 0xc7, 0x60, 0xb0, 0x88, 0xaa, 0x8d, 0xf1, 0x26,
	0x31, 0x9b, 0x47, 0x89, 0x99, 0x97, 0x73, 0xfb, 0x74, 0x6d, 0x7b, 0x8e, 0x52, 0xd0, 0xbe, 0xc0,
	0xe0, 0x06, 0x5b, 0x92, 0x93, 0xd6, 0x0f, 0x50, 0x5f, 0x76, 0x41, 0x5d, 0x80, 0x85, 0x53, 0x62,
	0xe6, 0x64, 0x8c, 0x7b, 0x97, 0x8b, 0x81, 0x33, 0xc8, 0xd6, 0xdf, 0x45, 0xd8, 0x5a, 0x58, 0xd0,
	0x0d, 0x28, 0x11, 0x5f, 0xae, 0x96, 0xda, 0x3a, 0x2d, 0xa1, 0xbb, 0x50, 0x4b, 0x3f, 0x14, 0x9e,
	0xdc, 0x27, 0xb5, 0x79, 0xd5, 0x54, 0x39, 0x12, 0x9b, 0xd4, 0x84, 0x72, 0x2a, 0x9b, 0x9b, 0xd2,
	0xbe, 0x90, 0xc5, 0x70, 0x23, 0xc2, 0x5f, 0xc9, 0xc5, 0xda, 0xc2, 0xf2, 0x8c, 0x3e, 0x81, 0x86,
	0xa6, 0x5c, 0xc0, 0x8a, 0xd2, 0x5c, 0x57, 0x12, 0x4e, 0xc1, 0x77, 0xa0, 0xa2, 0x1d, 0x25, 0x47,
	0x49, 0x3a, 0x81, 0x52, 0x0d, 0x04, 0x93, 0x05, 0xc5, 0x53, 0x32, 0x9b, 0x53, 0x7d, 0xb7, 0x6f,
	0xbc, 0xb3, 0xb7, 0xc7, 0xc2, 0x7a, 0xb0, 0x81, 0x95, 0x1b, 0x1a, 0x40, 0x4d, 0x1e, 0xbc, 0x80,
	0x70, 0xff, 0x15, 0x8d, 0xf5, 0x15, 0x7e, 0xb0, 0xb6, 0x7f, 0x92, 0xa3, 0xaf, 0x00, 0x07, 0x1b,
	0xb8, 0x7a, 0x9a, 0x91, 0xd1, 0x0b, 0xa8, 0x8a, 0xdc, 0xbc, 0x93, 0xe9, 0x8c, 0xd3, 0x38, 0x31,
	0xcb, 0x72, 0x20, 0x5f, 0x5d, 0x6e, 0x20, 0x96, 0x28, 0xa2, 0xab, 0x90, 0x6e, 0xc8, 0xe3, 0x33,
	0x5c, 0x89, 0xce, 0x35, 0x28, 0x80, 0xab, 0x92, 0x7b, 0x29, 0xe5, 0xc4, 0xac, 0xc8, 0x10, 0xdf,
	0xbe, 0x47, 0x88, 0x6c, 0x05, 0x3a, 0xd0, 0x76, 0xb4, 0xaa, 0x6f, 0x1e, 0x83, 0xb1, 0x9a, 0x0f,
	0x32, 0x60, 0xf3, 0x67, 0x7a, 0xa6, 0x2f, 0x85, 0x38, 0xa2, 0x87, 0x69, 0xcb, 0xf3, 0xeb, 0x5a,
	0xae, 0x1b, 0xfe, 0x38, 0xff, 0x75, 0xae, 0xc9, 0xe0, 0xc6, 0xc5, 0x49, 0x5c, 0xc0, 0xfe, 0xdd,
	0x32, 0xfb, 0xe5, 0x07, 0x93, 0x09, 0xb8, 0x57, 0x05, 0x38, 0xef, 0x5b, 0xeb, 0x09, 0x54, 0xb3,
	0x8e, 0xe8, 0x01, 0x34, 0x54, 0x2b, 0x13, 0x71, 0xab, 0x38, 0x8d, 0xf5, 0x9d, 0x3f, 0xd8, 0xc0,
	0x75, 0x6d, 0x18, 0x28, 0xfd, 0x5e, 0x03, 0x6a, 0x52, 0xe3, 0x9d, 0x92, 0x78, 0x4a, 0x42, 0xde,
	0x62, 0x50, 0x77, 0x58, 0xc2, 0x07, 0xea, 0x03, 0x23, 0x16, 0xe4, 0x1e, 0x14, 0x7c, 0x96, 0x70,
	0x49, 0x51, 0xd9, 0x45, 0x69, 0xbe, 0x62, 0x57, 0xac, 0xbe, 0x78, 0xe7, 0xb0, 0xb4, 0xa3, 0x2f,
	0xa1, 0x9c, 0xbe, 0xa8, 0xba, 0xb6, 0x5b, 0xef, 0x74, 0xae, 0xa3, 0x1d, 0xf0, 0xc2, 0xb5, 0xf5,
	0x7b, 0x1e, 0x4a, 0xfa, 0x4b, 0x7e, 0x00, 0x65, 0x9f, 0x70, 0x3a, 0x61, 0xb1, 0xea, 0x58, 0x7d,
	0xf7, 0xe1, 0x25, 0x9e, 0x04, 0xcb, 0xd1, 0x18, 0xbc, 0x40, 0xa3, 0x63, 0x68, 0x88, 0x9c, 0xbc,
	0x68, 0x51, 0x86, 0x39, 0x96, 0x29, 0xad, 0xff, 0x56, 0x2d, 0x57, 0x2e, 0xda, 0xe5, 0x2f, 0x69,
	0x5a, 0x3f, 0x42, 0x39, 0x8d, 0x86, 0x4c, 0xb8, 0xe6, 0xb4, 0x47, 0xee, 0xfe, 0x11, 0x7e, 0xee,
	0x3d, 0x7b, 0x3a, 0x1c, 0xb8, 0x4e, 0xaf, 0xdb, 0x73, 0x3b, 0xc6, 0x06, 0x2a, 0x43, 0xc1, 0x39,
	0x1a, 0x8e, 0x8c, 0x1c, 0xaa, 0x42, 0x79, 0xe8, 0x3a, 0xcf, 0x70, 0x6f, 0xf4, 0xdc, 0xc8, 0xa3,
	0x06, 0x54, 0x06, 0x2e, 0xee, 0x1e, 0xe1, 0x7e, 0xfb, 0xa9, 0xe3, 0x1a, 0x9b, 0x68, 0x1b, 0x6a,
	0xfd, 0xf6, 0xd3, 0xf6, 0xbe, 0xdb, 0xde, 0xeb, 0x1d, 0x0a, 0x9f, 0x82, 0x9c, 0xec, 0x79, 0xbc,
	0x5f, 0x36, 0xe1, 0xe6, 0x7f, 0xbc, 0x2f, 0x68, 0x00, 0x45, 0xf9, 0xc2, 0xe8, 0x56, 0x3d, 0xfe,
	0x90, 0x47, 0xca, 0x92, 0x27, 0xac, 0x88, 0x50, 0x08, 0x75, 0xf5, 0xf6, 0x05, 0x94, 0x93, 0x31,
	0xe1, 0x44, 0x7f, 0xe0, 0xf7, 0x3f, 0x9c, 0xba, 0xaf, 0x99, 0xd4, 0x4a, 0xd6, 0x92, 0xac, 0xae,
	0xf9, 0x3d, 0xa0, 0x77, 0x9d, 0x2e, 0x58, 0x99, 0x6b, 0xd9, 0x95, 0xd9, 0xca, 0xec, 0x41, 0x8b,
	0x40, 0x51, 0x32, 0xa0, 0xeb, 0xb0, 0x3d, 0x1c, 0xb5, 0x47, 0xee, 0xca, 0x24, 0x00, 0x4a, 0x6d,
	0x67, 0xd4, 0x3b, 0x76, 0x8d, 0x1c, 0xaa, 0xc0, 0x15, 0xe7, 0xb0, 0xdd, 0xeb, 0xbb, 0x1d, 0xa3,
	0x84, 0x6a, 0xb0, 0x35, 0x7c, 0xe6, 0x38, 0xae, 0xdb, 0x71, 0x3b, 0xc6, 0xa6, 0xf0, 0xeb, 0xb6,
	0x7b, 0x87, 0x6e, 0xc7, 0x28, 0x08, 0x53, 0xa7, 0x37, 0xec, 0xf7, 0x86, 0x43, 0xb7, 0x63, 0x14,
	0xf7, 0xfe, 0xc9, 0xbd, 0x6d, 0xcf, 0xe0, 0xde, 0x65, 0x9e, 0x69, 0x1a, 0xa3, 0xbd, 0xff, 0xff,
	0x46, 0xc3, 0x1d, 0x9f, 0x05, 0xeb, 0x3a, 0x3e, 0xc8, 0xbd, 0xe8, 0x6a, 0xf3, 0x84, 0xcd, 0x48,
	0x38, 0xb1, 0x58, 0x3c, 0xb1, 0x27, 0x34, 0x94, 0x6b, 0x66, 0x9f, 0x67, 0x77, 0xe1, 0x4f, 0xf5,
	0x37, 0x19, 0xf1, 0x8f, 0x7c, 0xc1, 0xc1, 0xae, 0xf3, 0x67, 0xfe, 0xf6, 0xbe, 0xe2, 0x73, 0x64,
	0xb8, 0x4c, 0x41, 0xd6, 0xf1, 0xa3, 0x97, 0x25, 0xc9, 0xfb, 0xf9, 0xbf, 0x01, 0x00, 0x00, 0xff,
	0xff, 0x54, 0x30, 0xb6, 0x72, 0xab, 0x0b, 0x00, 0x00,
}
