/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * The execution status of refreshing one data source object.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RefreshDataSourceObjectExecutionStatus extends com.google.api.client.json.GenericJson {

  /**
   * The data execution status.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DataExecutionStatus dataExecutionStatus;

  /**
   * Reference to a data source object being refreshed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DataSourceObjectReference reference;

  /**
   * The data execution status.
   * @return value or {@code null} for none
   */
  public DataExecutionStatus getDataExecutionStatus() {
    return dataExecutionStatus;
  }

  /**
   * The data execution status.
   * @param dataExecutionStatus dataExecutionStatus or {@code null} for none
   */
  public RefreshDataSourceObjectExecutionStatus setDataExecutionStatus(DataExecutionStatus dataExecutionStatus) {
    this.dataExecutionStatus = dataExecutionStatus;
    return this;
  }

  /**
   * Reference to a data source object being refreshed.
   * @return value or {@code null} for none
   */
  public DataSourceObjectReference getReference() {
    return reference;
  }

  /**
   * Reference to a data source object being refreshed.
   * @param reference reference or {@code null} for none
   */
  public RefreshDataSourceObjectExecutionStatus setReference(DataSourceObjectReference reference) {
    this.reference = reference;
    return this;
  }

  @Override
  public RefreshDataSourceObjectExecutionStatus set(String fieldName, Object value) {
    return (RefreshDataSourceObjectExecutionStatus) super.set(fieldName, value);
  }

  @Override
  public RefreshDataSourceObjectExecutionStatus clone() {
    return (RefreshDataSourceObjectExecutionStatus) super.clone();
  }

}
