#include "imgconvertmodule.h"

static PyObject *toRGB565(PyObject *self, PyObject *args){
	gchar* filename;
	gchar* savefilename;
	gint width, height;
        gint behaviour; // = 0;  //default is FIT
	gint autorotate; // = 0;  //default is None
        gint swap_bytes; // = TRUE;
	gint rotate; // = FALSE;
	if(!PyArg_ParseTuple(args, "siiiiiis", &filename, &width, &height, &swap_bytes, &rotate, &behaviour, &autorotate, &savefilename)){
		printf("Argh! Failed to parse tuple!\n");
		exit(1);
	}
       	toRGB565C(filename, width, height, swap_bytes, rotate, behaviour, autorotate, savefilename);
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *fromRGB565(PyObject *self, PyObject *args){
	guchar* rgbdata;
	gint width, height;
	gint swap_bytes; // = TRUE;
	gint rotate; // = FALSE;
	gchar* savefilename; // = "gpixpod_imgconvert_test.png";
	gint rgbdatalen;
	if(!PyArg_ParseTuple(args, "s#iiiis", &rgbdata, &rgbdatalen, &width, &height, &swap_bytes, &rotate, &savefilename)){
		printf("Argh! Failed to parse tuple!\n");
		exit(1);
	}
       	fromRGB565C(rgbdata, width, height, swap_bytes, rotate, savefilename);
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *toInterlacedUYVY(PyObject *self, PyObject *args){
	gchar *filename, *savefilename;
	gint behaviour, autorotate;
	PyArg_ParseTuple(args, "siis", &filename, &behaviour, &autorotate, &savefilename);
	toInterlacedUYVYC(filename, behaviour, autorotate, savefilename);
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *fromInterlacedUYVY(PyObject *self, PyObject *args){
	guchar* yuvdata;
	gchar* savefilename;
	PyArg_ParseTuple(args, "ss", &yuvdata, &savefilename);
	fromInterlacedUYVYC(yuvdata, savefilename);
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *limit(PyObject *self, PyObject *args){
	int x;
	PyArg_ParseTuple(args, "i", &x);
	int y = limit8bit(x);
	return Py_BuildValue("i", y);
}

static PyObject *testall(PyObject *self, PyObject *args){
	testAll();
	Py_INCREF(Py_None);
	return Py_None;
}

static PyMethodDef IMGConvertMethods[] = {
	{"toRGB565", toRGB565, METH_VARARGS, "Convert an image to RGB565"},
	{"fromRGB565", fromRGB565, METH_VARARGS, "Convert a RGB565 stream to pixbuf"},
	{"toInterlacedUYVY", toInterlacedUYVY, METH_VARARGS, "Convert an image to interlaced UYVY"},
	{"fromInterlacedUYVY", fromInterlacedUYVY, METH_VARARGS, "Convert an interlaced UYVY stream to pixbuf"},
	{"limit", limit, METH_VARARGS, "Limit a number in 0-255 range"},
	{"testall", testall, METH_VARARGS, "Test all"},
	{NULL, NULL, 0, NULL}
};

PyMODINIT_FUNC initimgconvert(void){
	(void) Py_InitModule("imgconvert", IMGConvertMethods);
}

int main(int argc, char *argv[]){
	gtk_init(&argc, &argv);
	Py_SetProgramName(argv[0]);
	Py_Initialize();
	initimgconvert();
	return 0;
}
