/* -*- c++ -*- */
/*
 * Copyright 2004 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street,
 * Boston, MA 02110-1301, USA.
 */

/*
 * config.h is generated by configure.  It contains the results
 * of probing for features, options etc.  It should be the first
 * file included in your .cc file.
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gnuradio/io_signature.h>
#include "moving_sum_ff_impl.h"

namespace gr {
  namespace dab {
/*
 * Create a new instance of dab_moving_sum_ff and return
 * a boost shared_ptr.  This is effectively the public constructor.
 */
moving_sum_ff::sptr
moving_sum_ff::make(int length)
{
  return gnuradio::get_initial_sptr
    (new moving_sum_ff_impl(length));
}

/*
 * Specify constraints on number of input and output streams.
 * This info is used to construct the input and output signatures
 * (2nd & 3rd args to gr_block's constructor).  The input and
 * output signatures are used by the runtime system to
 * check that a valid number and type of inputs and outputs
 * are connected to this block.  In this case, we accept
 * only 1 input and 1 output.
 */
static const int MIN_IN = 1;  // mininum number of input streams
static const int MAX_IN = 1;  // maximum number of input streams
static const int MIN_OUT = 1; // minimum number of output streams
static const int MAX_OUT = 1; // maximum number of output streams

/*
 * The private constructor
 */
moving_sum_ff_impl::moving_sum_ff_impl(int length)
  : gr::sync_block("moving_sum_ff",
       gr::io_signature::make (MIN_IN, MAX_IN, sizeof (float)),
       gr::io_signature::make (MIN_OUT, MAX_OUT, sizeof (float))),
    d_sum(0), d_length(length)
{
  assert(length>=0);
  set_history(length+1);
  set_output_multiple(length+1);
}

/*
 * Our virtual destructor.
 */
moving_sum_ff_impl::~moving_sum_ff_impl()
{
  // nothing else required in this example
}

int 
moving_sum_ff_impl::work(int noutput_items,
          gr_vector_const_void_star &input_items,
          gr_vector_void_star &output_items)
{
  const float *in = (const float *) input_items[0];
  float *out = (float *) output_items[0];
  // just so i know, what gnuradio is doing ...
  // printf("noutput_items: %d\n", noutput_items);
  // for (int j=0; j<noutput_items+d_length-1;j++)
  //    printf("in[%d]=%3.2f out[%d]=%3.2f\n",j,in[j],j,out[j]);
  for (int i=0; i < noutput_items; i++) {
    d_sum+=(double)in[i+d_length]-(double)in[i];
    out[i] = (float)d_sum;
  }

  // Tell runtime system how many output items we produced.
  return noutput_items;
}

bool moving_sum_ff_impl::stop()
{
    d_sum = 0;
    return true;
}

}
}
