INCLUDE(FindPkgConfig)
PKG_CHECK_MODULES(PC_GNURADIO_FCD gnuradio-fcd)

FIND_PATH(
    GNURADIO_FCD_INCLUDE_DIRS
    NAMES gnuradio/fcd/api.h
    HINTS $ENV{GNURADIO_FCD_DIR}/include
        ${PC_GNURADIO_FCD_INCLUDEDIR}
    PATHS /usr/local/include
          /usr/include
)

FIND_LIBRARY(
    GNURADIO_FCD_LIBRARIES
    NAMES gnuradio-fcd
    HINTS $ENV{GNURADIO_FCD_DIR}/lib
        ${PC_GNURADIO_FCD_LIBDIR}
    PATHS /usr/local/lib
          /usr/local/lib64
          /usr/lib
          /usr/lib64
)

if(GNURADIO_FCD_INCLUDE_DIRS AND GNURADIO_FCD_LIBRARIES)
  set(GNURADIO_FCD_FOUND TRUE CACHE INTERNAL "gnuradio-fcd found")
  message(STATUS "Found gnuradio-fcd: ${GNURADIO_FCD_INCLUDE_DIRS}, ${GNURADIO_FCD_LIBRARIES}")
else(GNURADIO_FCD_INCLUDE_DIRS AND GNURADIO_FCD_LIBRARIES)
  set(GNURADIO_FCD_FOUND FALSE CACHE INTERNAL "gnuradio-fcd found")
  message(STATUS "gnuradio-fcd not found.")
endif(GNURADIO_FCD_INCLUDE_DIRS AND GNURADIO_FCD_LIBRARIES)

INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(GNURADIO_FCD DEFAULT_MSG GNURADIO_FCD_LIBRARIES GNURADIO_FCD_INCLUDE_DIRS)
MARK_AS_ADVANCED(GNURADIO_FCD_LIBRARIES GNURADIO_FCD_INCLUDE_DIRS)
