
#line 3 "lex.gml.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 37
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define gmlconst const
#else
#define gmlconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (gml_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((gml_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE gmlrestart(gmlin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(gml_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct gml_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t gml_size_t;
#endif

extern gml_size_t gmlleng;

extern FILE *gmlin, *gmlout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define gmlless(n) \
	do \
		{ \
		/* Undo effects of setting up gmltext. */ \
        int gmlless_macro_arg = (n); \
        YY_LESS_LINENO(gmlless_macro_arg);\
		*gml_cp = (gml_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(gml_c_buf_p) = gml_cp = gml_bp + gmlless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up gmltext again */ \
		} \
	while ( 0 )

#define unput(c) gmlunput( c, (gmltext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct gml_buffer_state
	{
	FILE *gml_input_file;

	char *gml_ch_buf;		/* input buffer */
	char *gml_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	gml_size_t gml_buf_size;

	/* Number of characters read into gml_ch_buf, not including EOB
	 * characters.
	 */
	gml_size_t gml_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int gml_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int gml_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int gml_at_bol;

    int gml_bs_lineno; /**< The line count. */
    int gml_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int gml_fill_buffer;

	int gml_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via gmlrestart()), so that the user can continue scanning by
	 * just pointing gmlin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t gml_buffer_stack_top = 0; /**< index of top of stack. */
static size_t gml_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * gml_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (gml_buffer_stack) \
                          ? (gml_buffer_stack)[(gml_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (gml_buffer_stack)[(gml_buffer_stack_top)]

/* gml_hold_char holds the character lost when gmltext is formed. */
static char gml_hold_char;
static gml_size_t gml_n_chars;		/* number of characters read into gml_ch_buf */
gml_size_t gmlleng;

/* Points to current character in buffer. */
static char *gml_c_buf_p = (char *) 0;
static int gml_init = 0;		/* whether we need to initialize */
static int gml_start = 0;	/* start state number */

/* Flag which is used to allow gmlwrap()'s to do buffer switches
 * instead of setting up a fresh gmlin.  A bit of a hack ...
 */
static int gml_did_buffer_switch_on_eof;

void gmlrestart (FILE *input_file  );
void gml_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE gml_create_buffer (FILE *file,int size  );
void gml_delete_buffer (YY_BUFFER_STATE b  );
void gml_flush_buffer (YY_BUFFER_STATE b  );
void gmlpush_buffer_state (YY_BUFFER_STATE new_buffer  );
void gmlpop_buffer_state (void );

static void gmlensure_buffer_stack (void );
static void gml_load_buffer_state (void );
static void gml_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER gml_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE gml_scan_buffer (char *base,gml_size_t size  );
YY_BUFFER_STATE gml_scan_string (gmlconst char *gml_str  );
YY_BUFFER_STATE gml_scan_bytes (gmlconst char *bytes,gml_size_t len  );

void *gmlalloc (gml_size_t  );
void *gmlrealloc (void *,gml_size_t  );
void gmlfree (void *  );

#define gml_new_buffer gml_create_buffer

#define gml_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        gmlensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            gml_create_buffer(gmlin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->gml_is_interactive = is_interactive; \
	}

#define gml_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        gmlensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            gml_create_buffer(gmlin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->gml_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->gml_at_bol)

/* Begin user sect3 */

typedef unsigned char YY_CHAR;

FILE *gmlin = (FILE *) 0, *gmlout = (FILE *) 0;

typedef int gml_state_type;

extern int gmllineno;

int gmllineno = 1;

extern char *gmltext;
#define gmltext_ptr gmltext

static gml_state_type gml_get_previous_state (void );
static gml_state_type gml_try_NUL_trans (gml_state_type current_state  );
static int gml_get_next_buffer (void );
static void gml_fatal_error (gmlconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up gmltext.
 */
#define YY_DO_BEFORE_ACTION \
	(gmltext_ptr) = gml_bp; \
	gmlleng = (size_t) (gml_cp - gml_bp); \
	(gml_hold_char) = *gml_cp; \
	*gml_cp = '\0'; \
	(gml_c_buf_p) = gml_cp;

#define YY_NUM_RULES 39
#define YY_END_OF_BUFFER 40
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct gml_trans_info
	{
	flex_int32_t gml_verify;
	flex_int32_t gml_nxt;
	};
static gmlconst flex_int16_t gml_accept[143] =
    {   0,
        0,    0,    0,    0,   40,   38,    4,    2,   35,   38,
       33,   32,    1,   34,   34,   34,   34,   34,   34,   15,
       34,   34,   34,   34,   34,   34,   34,   14,   12,   13,
        3,   37,    2,   36,   33,   32,   33,    0,   34,   34,
       34,   34,   34,   34,   34,    9,   34,   34,   34,   34,
       34,   34,   34,   34,   34,   34,   34,    3,   37,    0,
       33,   34,   34,   34,   34,   34,   34,   34,   34,   34,
       34,   34,   34,   34,   34,   34,   34,   34,   34,   34,
        7,   20,   34,   34,   34,   26,    6,   34,   34,   34,
       34,   34,   28,   19,   34,   31,   34,   34,   34,    5,

       16,   34,   27,   34,   25,   34,   24,   34,   34,   34,
       34,   34,   34,   10,   11,   34,   34,   34,   34,   34,
       21,    8,   30,   29,   17,   34,   34,   34,   34,   34,
       34,   34,   34,   34,   34,   34,   34,   34,   22,   23,
       18,    0
    } ;

static gmlconst flex_int32_t gml_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    4,    5,    1,    1,    1,    1,    1,
        1,    1,    6,    1,    6,    7,    1,    8,    8,    8,
        8,    8,    8,    8,    8,    8,    8,    1,    1,    1,
        1,    1,    1,    9,   10,   11,   12,   13,   14,   15,
       16,   17,   18,   19,   19,   20,   21,   22,   23,   24,
       19,   25,   26,   27,   28,   19,   29,   30,   31,   32,
        1,    1,    1,    1,   19,    1,   33,   34,   35,   36,

       37,   38,   39,   40,   41,   19,   19,   42,   43,   44,
       45,   46,   19,   47,   48,   49,   50,   19,   51,   52,
       53,   54,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static gmlconst flex_int32_t gml_meta[55] =
    {   0,
        1,    1,    2,    3,    1,    1,    1,    4,    1,    4,
        4,    4,    4,    4,    4,    4,    4,    4,    4,    4,
        4,    4,    4,    4,    4,    4,    4,    4,    4,    4,
        4,    4,    4,    4,    4,    4,    4,    4,    4,    4,
        4,    4,    4,    4,    4,    4,    4,    4,    4,    4,
        4,    4,    4,    4
    } ;

static gmlconst flex_int16_t gml_base[147] =
    {   0,
        0,   78,   52,   54,   75,  301,  301,  301,  301,   52,
       53,   55,  301,    0,   41,   47,   53,   50,   45,    0,
       58,   64,   53,   49,   55,   57,   93,   63,    0,    0,
        0,    0,    0,  301,   71,  102,   79,  105,    0,   76,
       76,   96,   94,   93,  107,    0,  108,   99,  109,   98,
      109,  101,  100,  107,  103,  110,  125,    0,    0,   64,
      301,  118,  125,  130,  128,  122,  128,  143,  144,  145,
      144,  143,  141,  148,  144,  142,  158,  148,  151,  161,
        0,    0,  163,  160,  159,    0,    0,  174,  157,  181,
      180,  185,    0,    0,  185,    0,  177,  195,  190,  191,

      194,  190,    0,  199,    0,  191,    0,  200,  198,  188,
      209,  198,  210,    0,    0,  214,  215,  216,  209,  228,
      217,    0,    0,    0,    0,  224,  222,  221,  234,  223,
      242,  238,  238,  232,  248,  249,  247,  240,    0,    0,
        0,  301,  288,   65,  292,  296
    } ;

static gmlconst flex_int16_t gml_def[147] =
    {   0,
      142,    1,  143,  143,  142,  142,  142,  142,  142,  142,
      142,  142,  142,  144,  144,  144,  144,  144,  144,  144,
      144,  144,  144,  144,  144,  144,  144,  144,  144,  144,
      145,  146,  146,  142,  142,  142,  142,  142,  144,  144,
      144,  144,  144,  144,  144,  144,  144,  144,  144,  144,
      144,  144,  144,  144,  144,  144,  144,  145,  146,  142,
      142,  144,  144,  144,  144,  144,  144,  144,  144,  144,
      144,  144,  144,  144,  144,  144,  144,  144,  144,  144,
      144,  144,  144,  144,  144,  144,  144,  144,  144,  144,
      144,  144,  144,  144,  144,  144,  144,  144,  144,  144,

      144,  144,  144,  144,  144,  144,  144,  144,  144,  144,
      144,  144,  144,  144,  144,  144,  144,  144,  144,  144,
      144,  144,  144,  144,  144,  144,  144,  144,  144,  144,
      144,  144,  144,  144,  144,  144,  144,  144,  144,  144,
      144,    0,  142,  142,  142,  142
    } ;

static gmlconst flex_int16_t gml_nxt[356] =
    {   0,
        6,    7,    8,    9,    6,   10,   11,   12,   13,   14,
       14,   15,   16,   17,   18,   19,   20,   21,   14,   22,
       14,   23,   24,   25,   14,   26,   27,   14,   28,   29,
       30,   14,   14,   14,   15,   16,   17,   18,   19,   20,
       21,   22,   14,   23,   24,   25,   14,   26,   27,   14,
       28,   29,   30,   14,   33,   34,   33,   34,   35,   36,
       37,   35,   36,   40,   41,   42,   38,   43,   39,   45,
       46,   61,   44,   47,  142,   49,   50,   51,   37,   52,
       57,   48,   31,   53,   38,   40,   37,   41,   42,   38,
       43,   45,   38,   46,   44,   62,   47,   49,   50,   51,

       63,   52,   54,   57,   48,   53,   55,   38,   35,   36,
       60,   64,   61,   65,   66,   38,   67,   62,   68,  142,
       69,   70,   63,   56,   71,   54,   72,  142,   73,   55,
       74,   75,   76,   77,   64,   65,   66,   78,   80,   67,
       79,   68,   69,   81,   70,   56,   71,   82,   83,   72,
       73,   84,   74,   75,   76,   77,   85,   86,   87,   92,
       78,   80,   79,   88,   89,   90,   81,   91,   93,   82,
       83,   94,   97,   84,   95,   96,  100,  142,  101,   85,
       86,   87,   92,  103,   98,   88,   89,   90,   99,   91,
       93,  102,  104,  105,   94,   97,   95,   96,  106,  100,

      101,  107,  142,  108,  109,  103,   98,  110,  111,  112,
       99,  113,  114,  116,  102,  104,  105,  115,  117,  118,
      119,  106,  120,  121,  107,  108,  122,  109,  123,  124,
      110,  111,  112,  113,  125,  114,  116,  126,  131,  115,
      117,  118,  127,  119,  120,  128,  121,  129,  130,  122,
      132,  123,  124,  133,  134,  135,  125,  136,  137,  138,
      126,  131,  139,  140,  127,  141,  142,  128,  142,  129,
      130,  142,  142,  132,  142,  133,  142,  134,  135,  136,
      137,  142,  138,  142,  142,  139,  140,  141,   32,   32,
       32,   32,   58,  142,   58,   58,   59,   59,  142,   59,

        5,  142,  142,  142,  142,  142,  142,  142,  142,  142,
      142,  142,  142,  142,  142,  142,  142,  142,  142,  142,
      142,  142,  142,  142,  142,  142,  142,  142,  142,  142,
      142,  142,  142,  142,  142,  142,  142,  142,  142,  142,
      142,  142,  142,  142,  142,  142,  142,  142,  142,  142,
      142,  142,  142,  142,  142
    } ;

static gmlconst flex_int16_t gml_chk[356] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    3,    3,    4,    4,   10,   10,
       11,   12,   12,   15,   16,   17,   11,   18,  144,   19,
       21,   60,   18,   22,    5,   23,   24,   25,   35,   26,
       28,   22,    2,   26,   35,   15,   37,   16,   17,   11,
       18,   19,   37,   21,   18,   40,   22,   23,   24,   25,

       41,   26,   27,   28,   22,   26,   27,   35,   36,   36,
       38,   42,   38,   43,   44,   37,   45,   40,   47,    0,
       48,   49,   41,   27,   50,   27,   51,    0,   52,   27,
       53,   54,   55,   56,   42,   43,   44,   57,   63,   45,
       62,   47,   48,   64,   49,   27,   50,   65,   66,   51,
       52,   67,   53,   54,   55,   56,   68,   69,   70,   75,
       57,   63,   62,   71,   72,   73,   64,   74,   76,   65,
       66,   77,   80,   67,   78,   79,   84,    0,   85,   68,
       69,   70,   75,   89,   83,   71,   72,   73,   83,   74,
       76,   88,   90,   91,   77,   80,   78,   79,   92,   84,

       85,   95,    0,   97,   98,   89,   83,   99,  100,  101,
       83,  102,  104,  108,   88,   90,   91,  106,  109,  110,
      111,   92,  112,  113,   95,   97,  116,   98,  117,  118,
       99,  100,  101,  102,  119,  104,  108,  120,  128,  106,
      109,  110,  121,  111,  112,  121,  113,  126,  127,  116,
      129,  117,  118,  130,  131,  132,  119,  133,  134,  135,
      120,  128,  136,  137,  121,  138,    0,  121,    0,  126,
      127,    0,    0,  129,    0,  130,    0,  131,  132,  133,
      134,    0,  135,    0,    0,  136,  137,  138,  143,  143,
      143,  143,  145,    0,  145,  145,  146,  146,    0,  146,

      142,  142,  142,  142,  142,  142,  142,  142,  142,  142,
      142,  142,  142,  142,  142,  142,  142,  142,  142,  142,
      142,  142,  142,  142,  142,  142,  142,  142,  142,  142,
      142,  142,  142,  142,  142,  142,  142,  142,  142,  142,
      142,  142,  142,  142,  142,  142,  142,  142,  142,  142,
      142,  142,  142,  142,  142
    } ;

static gml_state_type gml_last_accepting_state;
static char *gml_last_accepting_cpos;

extern int gml_flex_debug;
int gml_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define gmlmore() gmlmore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *gmltext;
#line 1 "../../cmd/tools/gmlscan.l"
/* vim:set shiftwidth=4 ts=8: */
#line 4 "../../cmd/tools/gmlscan.l"
#include <stdlib.h>
#include <gml2gv.h>
#include <gmlparse.h>
#include "config.h"

#ifndef HAVE_UNISTD_H
#define YY_NO_UNISTD_H
#endif

#define GRAPH_EOF_TOKEN     '@'     /* lex class must be defined below */

static int line_num = 1;
static int errors;
static FILE* Ifile;

void initgmlscan(FILE *ifile) 
{ 
    if (ifile) {
	Ifile = ifile; 
	line_num = 1;
    }
    errors = 0;
}

#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
        if ((result = fread(buf, 1, max_size, Ifile)) < 0) \
                YY_FATAL_ERROR( "input in flex scanner failed" )
#endif

/* buffer for arbitrary length strings (longer than BUFSIZ) */
static char     *Sbuf,*Sptr,*Send;
static void beginstr(void) 
{
    if (Sbuf == NULL) {
	Sbuf = malloc(BUFSIZ);
	Send = Sbuf + BUFSIZ;
    }
    Sptr = Sbuf;
    *Sptr = 0;
}

static void addstr(char *src) 
{
    char    c;
    if (Sptr > Sbuf) Sptr--;
    do {
	do {c = *Sptr++ = *src++;} while (c && (Sptr < Send));
	if (c) {
	    long    sz = Send - Sbuf;
	    long    off = Sptr - Sbuf;
	    sz *= 2;
	    Sbuf = (char*)realloc(Sbuf,sz);
	    Send = Sbuf + sz;
	    Sptr = Sbuf + off;
	}
    } while (c);
}

static void endstr(void) {
    gmllval.str = strdup(Sbuf);
}


#line 642 "lex.gml.c"

#define INITIAL 0
#define qstring 1

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int gml_init_globals (void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int gmllex_destroy (void );

int gmlget_debug (void );

void gmlset_debug (int debug_flag  );

YY_EXTRA_TYPE gmlget_extra (void );

void gmlset_extra (YY_EXTRA_TYPE user_defined  );

FILE *gmlget_in (void );

void gmlset_in  (FILE * in_str  );

FILE *gmlget_out (void );

void gmlset_out  (FILE * out_str  );

gml_size_t gmlget_leng (void );

char *gmlget_text (void );

int gmlget_lineno (void );

void gmlset_lineno (int line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int gmlwrap (void );
#else
extern int gmlwrap (void );
#endif
#endif

    static void gmlunput (int c,char *buf_ptr  );
    
#ifndef gmltext_ptr
static void gml_flex_strncpy (char *,gmlconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int gml_flex_strlen (gmlconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int gmlinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( gmltext, gmlleng, 1, gmlout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->gml_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( gmlin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( gmlin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, gmlin))==0 && ferror(gmlin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(gmlin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "gmlterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef gmlterminate
#define gmlterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) gml_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int gmllex (void);

#define YY_DECL int gmllex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after gmltext and gmlleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	if ( gmlleng > 0 ) \
		YY_CURRENT_BUFFER_LVALUE->gml_at_bol = \
				(gmltext[gmlleng - 1] == '\n'); \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register gml_state_type gml_current_state;
	register char *gml_cp, *gml_bp;
	register int gml_act;
    
#line 76 "../../cmd/tools/gmlscan.l"

#line 830 "lex.gml.c"

	if ( !(gml_init) )
		{
		(gml_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (gml_start) )
			(gml_start) = 1;	/* first start state */

		if ( ! gmlin )
			gmlin = stdin;

		if ( ! gmlout )
			gmlout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			gmlensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				gml_create_buffer(gmlin,YY_BUF_SIZE );
		}

		gml_load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		gml_cp = (gml_c_buf_p);

		/* Support of gmltext. */
		*gml_cp = (gml_hold_char);

		/* gml_bp points to the position in gml_ch_buf of the start of
		 * the current run.
		 */
		gml_bp = gml_cp;

		gml_current_state = (gml_start);
		gml_current_state += YY_AT_BOL();
gml_match:
		do
			{
			register YY_CHAR gml_c = gml_ec[YY_SC_TO_UI(*gml_cp)];
			if ( gml_accept[gml_current_state] )
				{
				(gml_last_accepting_state) = gml_current_state;
				(gml_last_accepting_cpos) = gml_cp;
				}
			while ( gml_chk[gml_base[gml_current_state] + gml_c] != gml_current_state )
				{
				gml_current_state = (int) gml_def[gml_current_state];
				if ( gml_current_state >= 143 )
					gml_c = gml_meta[(unsigned int) gml_c];
				}
			gml_current_state = gml_nxt[gml_base[gml_current_state] + (unsigned int) gml_c];
			++gml_cp;
			}
		while ( gml_base[gml_current_state] != 301 );

gml_find_action:
		gml_act = gml_accept[gml_current_state];
		if ( gml_act == 0 )
			{ /* have to back up */
			gml_cp = (gml_last_accepting_cpos);
			gml_current_state = (gml_last_accepting_state);
			gml_act = gml_accept[gml_current_state];
			}

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( gml_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*gml_cp = (gml_hold_char);
			gml_cp = (gml_last_accepting_cpos);
			gml_current_state = (gml_last_accepting_state);
			goto gml_find_action;

case 1:
YY_RULE_SETUP
#line 77 "../../cmd/tools/gmlscan.l"
return(EOF);
	YY_BREAK
case 2:
/* rule 2 can match eol */
YY_RULE_SETUP
#line 78 "../../cmd/tools/gmlscan.l"
line_num++;
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 79 "../../cmd/tools/gmlscan.l"
/* ignore # line */
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 80 "../../cmd/tools/gmlscan.l"
/* ignore whitespace */
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 82 "../../cmd/tools/gmlscan.l"
return (GRAPH);
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 83 "../../cmd/tools/gmlscan.l"
return (NODE);
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 84 "../../cmd/tools/gmlscan.l"
return (EDGE);
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 85 "../../cmd/tools/gmlscan.l"
return (DIRECTED);
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 86 "../../cmd/tools/gmlscan.l"
return (ID);
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 87 "../../cmd/tools/gmlscan.l"
return (SOURCE);
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 88 "../../cmd/tools/gmlscan.l"
return (TARGET);
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 89 "../../cmd/tools/gmlscan.l"
return (XVAL);
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 90 "../../cmd/tools/gmlscan.l"
return (YVAL);
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 91 "../../cmd/tools/gmlscan.l"
return (WVAL);
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 92 "../../cmd/tools/gmlscan.l"
return (HVAL);
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 93 "../../cmd/tools/gmlscan.l"
return (LABEL);
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 94 "../../cmd/tools/gmlscan.l"
return (GRAPHICS);;
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 95 "../../cmd/tools/gmlscan.l"
return (LABELGRAPHICS);
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 96 "../../cmd/tools/gmlscan.l"
return (TYPE);
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 97 "../../cmd/tools/gmlscan.l"
return (FILL);
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 98 "../../cmd/tools/gmlscan.l"
return (OUTLINE);
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 99 "../../cmd/tools/gmlscan.l"
return (OUTLINESTYLE);
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 100 "../../cmd/tools/gmlscan.l"
return (OUTLINEWIDTH);
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 101 "../../cmd/tools/gmlscan.l"
return (WIDTH);
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 102 "../../cmd/tools/gmlscan.l"
return (STYLE);
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 103 "../../cmd/tools/gmlscan.l"
return (LINE);
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 104 "../../cmd/tools/gmlscan.l"
return (POINT);
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 105 "../../cmd/tools/gmlscan.l"
return (TEXT);
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 106 "../../cmd/tools/gmlscan.l"
return (FONTSIZE);
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 107 "../../cmd/tools/gmlscan.l"
return (FONTNAME);
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 108 "../../cmd/tools/gmlscan.l"
return (COLOR);
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 109 "../../cmd/tools/gmlscan.l"
{ gmllval.str = strdup(gmltext); return (INTEGER); }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 110 "../../cmd/tools/gmlscan.l"
{ gmllval.str = strdup(gmltext); return (REAL); }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 111 "../../cmd/tools/gmlscan.l"
{ gmllval.str = strdup(gmltext); return (NAME); }
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 112 "../../cmd/tools/gmlscan.l"
BEGIN(qstring); beginstr();
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 114 "../../cmd/tools/gmlscan.l"
BEGIN(INITIAL); endstr(); return (STRING);
	YY_BREAK
case 37:
/* rule 37 can match eol */
YY_RULE_SETUP
#line 115 "../../cmd/tools/gmlscan.l"
addstr(gmltext);
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 117 "../../cmd/tools/gmlscan.l"
return (gmltext[0]);
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 119 "../../cmd/tools/gmlscan.l"
ECHO;
	YY_BREAK
#line 1111 "lex.gml.c"
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(qstring):
	gmlterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int gml_amount_of_matched_text = (int) (gml_cp - (gmltext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*gml_cp = (gml_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->gml_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed gmlin at a new source and called
			 * gmllex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(gml_n_chars) = YY_CURRENT_BUFFER_LVALUE->gml_n_chars;
			YY_CURRENT_BUFFER_LVALUE->gml_input_file = gmlin;
			YY_CURRENT_BUFFER_LVALUE->gml_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for gml_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since gml_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (gml_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->gml_ch_buf[(gml_n_chars)] )
			{ /* This was really a NUL. */
			gml_state_type gml_next_state;

			(gml_c_buf_p) = (gmltext_ptr) + gml_amount_of_matched_text;

			gml_current_state = gml_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * gml_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			gml_next_state = gml_try_NUL_trans( gml_current_state );

			gml_bp = (gmltext_ptr) + YY_MORE_ADJ;

			if ( gml_next_state )
				{
				/* Consume the NUL. */
				gml_cp = ++(gml_c_buf_p);
				gml_current_state = gml_next_state;
				goto gml_match;
				}

			else
				{
				gml_cp = (gml_c_buf_p);
				goto gml_find_action;
				}
			}

		else switch ( gml_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(gml_did_buffer_switch_on_eof) = 0;

				if ( gmlwrap( ) )
					{
					/* Note: because we've taken care in
					 * gml_get_next_buffer() to have set up
					 * gmltext, we can now set up
					 * gml_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(gml_c_buf_p) = (gmltext_ptr) + YY_MORE_ADJ;

					gml_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (gml_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(gml_c_buf_p) =
					(gmltext_ptr) + gml_amount_of_matched_text;

				gml_current_state = gml_get_previous_state(  );

				gml_cp = (gml_c_buf_p);
				gml_bp = (gmltext_ptr) + YY_MORE_ADJ;
				goto gml_match;

			case EOB_ACT_LAST_MATCH:
				(gml_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->gml_ch_buf[(gml_n_chars)];

				gml_current_state = gml_get_previous_state(  );

				gml_cp = (gml_c_buf_p);
				gml_bp = (gmltext_ptr) + YY_MORE_ADJ;
				goto gml_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of gmllex */

/* gml_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int gml_get_next_buffer (void)
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->gml_ch_buf;
	register char *source = (gmltext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (gml_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->gml_ch_buf[(gml_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->gml_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (gml_c_buf_p) - (gmltext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((gml_c_buf_p) - (gmltext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->gml_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->gml_n_chars = (gml_n_chars) = 0;

	else
		{
			gml_size_t num_to_read =
			YY_CURRENT_BUFFER_LVALUE->gml_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int gml_c_buf_p_offset =
				(int) ((gml_c_buf_p) - b->gml_ch_buf);

			if ( b->gml_is_our_buffer )
				{
				gml_size_t new_size = b->gml_buf_size * 2;

				if ( new_size <= 0 )
					b->gml_buf_size += b->gml_buf_size / 8;
				else
					b->gml_buf_size *= 2;

				b->gml_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					gmlrealloc((void *) b->gml_ch_buf,b->gml_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->gml_ch_buf = 0;

			if ( ! b->gml_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(gml_c_buf_p) = &b->gml_ch_buf[gml_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->gml_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->gml_ch_buf[number_to_move]),
			(gml_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->gml_n_chars = (gml_n_chars);
		}

	if ( (gml_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			gmlrestart(gmlin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->gml_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((gml_size_t) ((gml_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->gml_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		gml_size_t new_size = (gml_n_chars) + number_to_move + ((gml_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->gml_ch_buf = (char *) gmlrealloc((void *) YY_CURRENT_BUFFER_LVALUE->gml_ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->gml_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in gml_get_next_buffer()" );
	}

	(gml_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->gml_ch_buf[(gml_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->gml_ch_buf[(gml_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(gmltext_ptr) = &YY_CURRENT_BUFFER_LVALUE->gml_ch_buf[0];

	return ret_val;
}

/* gml_get_previous_state - get the state just before the EOB char was reached */

    static gml_state_type gml_get_previous_state (void)
{
	register gml_state_type gml_current_state;
	register char *gml_cp;
    
	gml_current_state = (gml_start);
	gml_current_state += YY_AT_BOL();

	for ( gml_cp = (gmltext_ptr) + YY_MORE_ADJ; gml_cp < (gml_c_buf_p); ++gml_cp )
		{
		register YY_CHAR gml_c = (*gml_cp ? gml_ec[YY_SC_TO_UI(*gml_cp)] : 1);
		if ( gml_accept[gml_current_state] )
			{
			(gml_last_accepting_state) = gml_current_state;
			(gml_last_accepting_cpos) = gml_cp;
			}
		while ( gml_chk[gml_base[gml_current_state] + gml_c] != gml_current_state )
			{
			gml_current_state = (int) gml_def[gml_current_state];
			if ( gml_current_state >= 143 )
				gml_c = gml_meta[(unsigned int) gml_c];
			}
		gml_current_state = gml_nxt[gml_base[gml_current_state] + (unsigned int) gml_c];
		}

	return gml_current_state;
}

/* gml_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = gml_try_NUL_trans( current_state );
 */
    static gml_state_type gml_try_NUL_trans  (gml_state_type gml_current_state )
{
	register int gml_is_jam;
    	register char *gml_cp = (gml_c_buf_p);

	register YY_CHAR gml_c = 1;
	if ( gml_accept[gml_current_state] )
		{
		(gml_last_accepting_state) = gml_current_state;
		(gml_last_accepting_cpos) = gml_cp;
		}
	while ( gml_chk[gml_base[gml_current_state] + gml_c] != gml_current_state )
		{
		gml_current_state = (int) gml_def[gml_current_state];
		if ( gml_current_state >= 143 )
			gml_c = gml_meta[(unsigned int) gml_c];
		}
	gml_current_state = gml_nxt[gml_base[gml_current_state] + (unsigned int) gml_c];
	gml_is_jam = (gml_current_state == 142);

		return gml_is_jam ? 0 : gml_current_state;
}

    static void gmlunput (int c, register char * gml_bp )
{
	register char *gml_cp;
    
    gml_cp = (gml_c_buf_p);

	/* undo effects of setting up gmltext */
	*gml_cp = (gml_hold_char);

	if ( gml_cp < YY_CURRENT_BUFFER_LVALUE->gml_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register gml_size_t number_to_move = (gml_n_chars) + 2;
		register char *dest = &YY_CURRENT_BUFFER_LVALUE->gml_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->gml_buf_size + 2];
		register char *source =
				&YY_CURRENT_BUFFER_LVALUE->gml_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->gml_ch_buf )
			*--dest = *--source;

		gml_cp += (int) (dest - source);
		gml_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->gml_n_chars =
			(gml_n_chars) = YY_CURRENT_BUFFER_LVALUE->gml_buf_size;

		if ( gml_cp < YY_CURRENT_BUFFER_LVALUE->gml_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--gml_cp = (char) c;

	(gmltext_ptr) = gml_bp;
	(gml_hold_char) = *gml_cp;
	(gml_c_buf_p) = gml_cp;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int gmlinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(gml_c_buf_p) = (gml_hold_char);

	if ( *(gml_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* gml_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (gml_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->gml_ch_buf[(gml_n_chars)] )
			/* This was really a NUL. */
			*(gml_c_buf_p) = '\0';

		else
			{ /* need more input */
			gml_size_t offset = (gml_c_buf_p) - (gmltext_ptr);
			++(gml_c_buf_p);

			switch ( gml_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because gml_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					gmlrestart(gmlin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( gmlwrap( ) )
						return EOF;

					if ( ! (gml_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return gmlinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(gml_c_buf_p) = (gmltext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (gml_c_buf_p);	/* cast for 8-bit char's */
	*(gml_c_buf_p) = '\0';	/* preserve gmltext */
	(gml_hold_char) = *++(gml_c_buf_p);

	YY_CURRENT_BUFFER_LVALUE->gml_at_bol = (c == '\n');

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void gmlrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        gmlensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            gml_create_buffer(gmlin,YY_BUF_SIZE );
	}

	gml_init_buffer(YY_CURRENT_BUFFER,input_file );
	gml_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void gml_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		gmlpop_buffer_state();
	 *		gmlpush_buffer_state(new_buffer);
     */
	gmlensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(gml_c_buf_p) = (gml_hold_char);
		YY_CURRENT_BUFFER_LVALUE->gml_buf_pos = (gml_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->gml_n_chars = (gml_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	gml_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (gmlwrap()) processing, but the only time this flag
	 * is looked at is after gmlwrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(gml_did_buffer_switch_on_eof) = 1;
}

static void gml_load_buffer_state  (void)
{
    	(gml_n_chars) = YY_CURRENT_BUFFER_LVALUE->gml_n_chars;
	(gmltext_ptr) = (gml_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->gml_buf_pos;
	gmlin = YY_CURRENT_BUFFER_LVALUE->gml_input_file;
	(gml_hold_char) = *(gml_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE gml_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) gmlalloc(sizeof( struct gml_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in gml_create_buffer()" );

	b->gml_buf_size = size;

	/* gml_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->gml_ch_buf = (char *) gmlalloc(b->gml_buf_size + 2  );
	if ( ! b->gml_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in gml_create_buffer()" );

	b->gml_is_our_buffer = 1;

	gml_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with gml_create_buffer()
 * 
 */
    void gml_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->gml_is_our_buffer )
		gmlfree((void *) b->gml_ch_buf  );

	gmlfree((void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a gmlrestart() or at EOF.
 */
    static void gml_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	gml_flush_buffer(b );

	b->gml_input_file = file;
	b->gml_fill_buffer = 1;

    /* If b is the current buffer, then gml_init_buffer was _probably_
     * called from gmlrestart() or through gml_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->gml_bs_lineno = 1;
        b->gml_bs_column = 0;
    }

        b->gml_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void gml_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->gml_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->gml_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->gml_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->gml_buf_pos = &b->gml_ch_buf[0];

	b->gml_at_bol = 1;
	b->gml_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		gml_load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void gmlpush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	gmlensure_buffer_stack();

	/* This block is copied from gml_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(gml_c_buf_p) = (gml_hold_char);
		YY_CURRENT_BUFFER_LVALUE->gml_buf_pos = (gml_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->gml_n_chars = (gml_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(gml_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from gml_switch_to_buffer. */
	gml_load_buffer_state( );
	(gml_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void gmlpop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	gml_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((gml_buffer_stack_top) > 0)
		--(gml_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		gml_load_buffer_state( );
		(gml_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void gmlensure_buffer_stack (void)
{
	gml_size_t num_to_alloc;
    
	if (!(gml_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(gml_buffer_stack) = (struct gml_buffer_state**)gmlalloc
								(num_to_alloc * sizeof(struct gml_buffer_state*)
								);
		if ( ! (gml_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in gmlensure_buffer_stack()" );
								  
		memset((gml_buffer_stack), 0, num_to_alloc * sizeof(struct gml_buffer_state*));
				
		(gml_buffer_stack_max) = num_to_alloc;
		(gml_buffer_stack_top) = 0;
		return;
	}

	if ((gml_buffer_stack_top) >= ((gml_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (gml_buffer_stack_max) + grow_size;
		(gml_buffer_stack) = (struct gml_buffer_state**)gmlrealloc
								((gml_buffer_stack),
								num_to_alloc * sizeof(struct gml_buffer_state*)
								);
		if ( ! (gml_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in gmlensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((gml_buffer_stack) + (gml_buffer_stack_max), 0, grow_size * sizeof(struct gml_buffer_state*));
		(gml_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE gml_scan_buffer  (char * base, gml_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) gmlalloc(sizeof( struct gml_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in gml_scan_buffer()" );

	b->gml_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->gml_buf_pos = b->gml_ch_buf = base;
	b->gml_is_our_buffer = 0;
	b->gml_input_file = 0;
	b->gml_n_chars = b->gml_buf_size;
	b->gml_is_interactive = 0;
	b->gml_at_bol = 1;
	b->gml_fill_buffer = 0;
	b->gml_buffer_status = YY_BUFFER_NEW;

	gml_switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to gmllex() will
 * scan from a @e copy of @a str.
 * @param gmlstr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       gml_scan_bytes() instead.
 */
YY_BUFFER_STATE gml_scan_string (gmlconst char * gmlstr )
{
    
	return gml_scan_bytes(gmlstr,strlen(gmlstr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to gmllex() will
 * scan from a @e copy of @a bytes.
 * @param gmlbytes the byte buffer to scan
 * @param _gmlbytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE gml_scan_bytes  (gmlconst char * gmlbytes, gml_size_t  _gmlbytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	gml_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _gmlbytes_len + 2;
	buf = (char *) gmlalloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in gml_scan_bytes()" );

	for ( i = 0; i < _gmlbytes_len; ++i )
		buf[i] = gmlbytes[i];

	buf[_gmlbytes_len] = buf[_gmlbytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = gml_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in gml_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->gml_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void gml_fatal_error (gmlconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine gmlless() so it works in section 3 code. */

#undef gmlless
#define gmlless(n) \
	do \
		{ \
		/* Undo effects of setting up gmltext. */ \
        int gmlless_macro_arg = (n); \
        YY_LESS_LINENO(gmlless_macro_arg);\
		gmltext[gmlleng] = (gml_hold_char); \
		(gml_c_buf_p) = gmltext + gmlless_macro_arg; \
		(gml_hold_char) = *(gml_c_buf_p); \
		*(gml_c_buf_p) = '\0'; \
		gmlleng = gmlless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int gmlget_lineno  (void)
{
        
    return gmllineno;
}

/** Get the input stream.
 * 
 */
FILE *gmlget_in  (void)
{
        return gmlin;
}

/** Get the output stream.
 * 
 */
FILE *gmlget_out  (void)
{
        return gmlout;
}

/** Get the length of the current token.
 * 
 */
gml_size_t gmlget_leng  (void)
{
        return gmlleng;
}

/** Get the current token.
 * 
 */

char *gmlget_text  (void)
{
        return gmltext;
}

/** Set the current line number.
 * @param line_number
 * 
 */
void gmlset_lineno (int  line_number )
{
    
    gmllineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see gml_switch_to_buffer
 */
void gmlset_in (FILE *  in_str )
{
        gmlin = in_str ;
}

void gmlset_out (FILE *  out_str )
{
        gmlout = out_str ;
}

int gmlget_debug  (void)
{
        return gml_flex_debug;
}

void gmlset_debug (int  bdebug )
{
        gml_flex_debug = bdebug ;
}

static int gml_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from gmllex_destroy(), so don't allocate here.
     */

    (gml_buffer_stack) = 0;
    (gml_buffer_stack_top) = 0;
    (gml_buffer_stack_max) = 0;
    (gml_c_buf_p) = (char *) 0;
    (gml_init) = 0;
    (gml_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    gmlin = stdin;
    gmlout = stdout;
#else
    gmlin = (FILE *) 0;
    gmlout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * gmllex_init()
     */
    return 0;
}

/* gmllex_destroy is for both reentrant and non-reentrant scanners. */
int gmllex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		gml_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		gmlpop_buffer_state();
	}

	/* Destroy the stack itself. */
	gmlfree((gml_buffer_stack) );
	(gml_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * gmllex() is called, initialization will occur. */
    gml_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef gmltext_ptr
static void gml_flex_strncpy (char* s1, gmlconst char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int gml_flex_strlen (gmlconst char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *gmlalloc (gml_size_t  size )
{
	return (void *) malloc( size );
}

void *gmlrealloc  (void * ptr, gml_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void gmlfree (void * ptr )
{
	free( (char *) ptr );	/* see gmlrealloc() for (char *) cast */
}

#define YYTABLES_NAME "gmltables"

#line 119 "../../cmd/tools/gmlscan.l"



void gmlerror(char *str)
{
    char    buf[BUFSIZ];
    if (errors)
	return;
    errors = 1;
    sprintf(buf," %s in line %d near '%s'\n", str,line_num,gmltext);
    agerr(AGWARN, "%s", buf);
}

int gmlerrors()
{
    return errors;
}
 
void gmllexeof() { unput(GRAPH_EOF_TOKEN); }

#ifndef YY_CALL_ONLY_ARG
# define YY_CALL_ONLY_ARG void
#endif

int gmlwrap(YY_CALL_ONLY_ARG)
{
    return 1;
}


