/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include <gstreamermm.h>
#include <iostream>

int main(int argc, char** argv)
{
  // Initialize Gstreamermm:
  Gst::init(argc, argv);

  Glib::RefPtr<Gst::Adder> adder = Gst::Adder::create();
  std::cout << "The GType of the newly created adder is " <<
    adder->get_type() << std::endl;

  Glib::RefPtr<Gst::Adder> adder2 = Glib::wrap(adder->gobj(), true);
  std::cout << "The GType of the wrapped adder is " << adder2->get_type() <<
    std::endl;

  return 0;
}
