/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.tag.docbook;

import org.dbdoclet.xiphias.XmlConstants;
import org.dbdoclet.xiphias.XmlServices;

public class Link extends DocBookElement {

	private static final String tag = "link";

	Link() {
		super(tag);
	}

	Link(DocBookElement label, String linkend) {

		this(linkend);
		appendChild(label);
	}

	Link(String linkend) {

		this();

		setAttribute("linkend", hardenId(linkend));
		setFormatType(FORMAT_INLINE);
	}

	Link(String label, String linkend) {

		this(linkend);
		appendChild(XmlServices.textToXml(label));
	}

	public void setHref(String href) {

		if (isDocBook5() == true) {
			setAttributeNS(XmlConstants.NAMESPACE_XLINK, "xl:href", href);
		} else {
			setAttribute("linkend", href);
		}
	}
}
