; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -mtriple=aarch64-linux-gnu -O0 -global-isel -stop-after=irtranslator -o - %s | FileCheck %s

%type = type [4 x {i8, i32}]

define i8*  @translate_element_size1(i64 %arg) {
  ; CHECK-LABEL: name: translate_element_size1
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $x0
  ; CHECK:   [[COPY:%[0-9]+]]:_(s64) = COPY $x0
  ; CHECK:   [[C:%[0-9]+]]:_(p0) = G_CONSTANT i64 0
  ; CHECK:   [[PTR_ADD:%[0-9]+]]:_(p0) = G_PTR_ADD [[C]], [[COPY]](s64)
  ; CHECK:   [[COPY1:%[0-9]+]]:_(p0) = COPY [[PTR_ADD]](p0)
  ; CHECK:   $x0 = COPY [[COPY1]](p0)
  ; CHECK:   RET_ReallyLR implicit $x0
  %tmp = getelementptr i8, i8* null, i64 %arg
  ret i8* %tmp
}

define %type* @first_offset_const(%type* %addr) {

  ; CHECK-LABEL: name: first_offset_const
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $x0
  ; CHECK:   [[COPY:%[0-9]+]]:_(p0) = COPY $x0
  ; CHECK:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 32
  ; CHECK:   [[PTR_ADD:%[0-9]+]]:_(p0) = G_PTR_ADD [[COPY]], [[C]](s64)
  ; CHECK:   $x0 = COPY [[PTR_ADD]](p0)
  ; CHECK:   RET_ReallyLR implicit $x0
  %res = getelementptr %type, %type* %addr, i32 1
  ret %type* %res
}

define %type* @first_offset_trivial(%type* %addr) {

  ; CHECK-LABEL: name: first_offset_trivial
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $x0
  ; CHECK:   [[COPY:%[0-9]+]]:_(p0) = COPY $x0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(p0) = COPY [[COPY]](p0)
  ; CHECK:   $x0 = COPY [[COPY1]](p0)
  ; CHECK:   RET_ReallyLR implicit $x0
  %res = getelementptr %type, %type* %addr, i32 0
  ret %type* %res
}

define %type* @first_offset_variable(%type* %addr, i64 %idx) {

  ; CHECK-LABEL: name: first_offset_variable
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $x0, $x1
  ; CHECK:   [[COPY:%[0-9]+]]:_(p0) = COPY $x0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s64) = COPY $x1
  ; CHECK:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 32
  ; CHECK:   [[MUL:%[0-9]+]]:_(s64) = G_MUL [[COPY1]], [[C]]
  ; CHECK:   [[PTR_ADD:%[0-9]+]]:_(p0) = G_PTR_ADD [[COPY]], [[MUL]](s64)
  ; CHECK:   [[COPY2:%[0-9]+]]:_(p0) = COPY [[PTR_ADD]](p0)
  ; CHECK:   $x0 = COPY [[COPY2]](p0)
  ; CHECK:   RET_ReallyLR implicit $x0
  %res = getelementptr %type, %type* %addr, i64 %idx
  ret %type* %res
}

define %type* @first_offset_ext(%type* %addr, i32 %idx) {

  ; CHECK-LABEL: name: first_offset_ext
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $w1, $x0
  ; CHECK:   [[COPY:%[0-9]+]]:_(p0) = COPY $x0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $w1
  ; CHECK:   [[SEXT:%[0-9]+]]:_(s64) = G_SEXT [[COPY1]](s32)
  ; CHECK:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 32
  ; CHECK:   [[MUL:%[0-9]+]]:_(s64) = G_MUL [[SEXT]], [[C]]
  ; CHECK:   [[PTR_ADD:%[0-9]+]]:_(p0) = G_PTR_ADD [[COPY]], [[MUL]](s64)
  ; CHECK:   [[COPY2:%[0-9]+]]:_(p0) = COPY [[PTR_ADD]](p0)
  ; CHECK:   $x0 = COPY [[COPY2]](p0)
  ; CHECK:   RET_ReallyLR implicit $x0
  %res = getelementptr %type, %type* %addr, i32 %idx
  ret %type* %res
}

%type1 = type [4 x [4 x i32]]
define i32* @const_then_var(%type1* %addr, i64 %idx) {

  ; CHECK-LABEL: name: const_then_var
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $x0, $x1
  ; CHECK:   [[COPY:%[0-9]+]]:_(p0) = COPY $x0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s64) = COPY $x1
  ; CHECK:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 272
  ; CHECK:   [[PTR_ADD:%[0-9]+]]:_(p0) = G_PTR_ADD [[COPY]], [[C]](s64)
  ; CHECK:   [[C1:%[0-9]+]]:_(s64) = G_CONSTANT i64 4
  ; CHECK:   [[MUL:%[0-9]+]]:_(s64) = G_MUL [[COPY1]], [[C1]]
  ; CHECK:   [[PTR_ADD1:%[0-9]+]]:_(p0) = G_PTR_ADD [[PTR_ADD]], [[MUL]](s64)
  ; CHECK:   [[COPY2:%[0-9]+]]:_(p0) = COPY [[PTR_ADD1]](p0)
  ; CHECK:   $x0 = COPY [[COPY2]](p0)
  ; CHECK:   RET_ReallyLR implicit $x0
  %res = getelementptr %type1, %type1* %addr, i32 4, i32 1, i64 %idx
  ret i32* %res
}

define i32* @var_then_const(%type1* %addr, i64 %idx) {

  ; CHECK-LABEL: name: var_then_const
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $x0, $x1
  ; CHECK:   [[COPY:%[0-9]+]]:_(p0) = COPY $x0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s64) = COPY $x1
  ; CHECK:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 64
  ; CHECK:   [[MUL:%[0-9]+]]:_(s64) = G_MUL [[COPY1]], [[C]]
  ; CHECK:   [[PTR_ADD:%[0-9]+]]:_(p0) = G_PTR_ADD [[COPY]], [[MUL]](s64)
  ; CHECK:   [[C1:%[0-9]+]]:_(s64) = G_CONSTANT i64 40
  ; CHECK:   [[PTR_ADD1:%[0-9]+]]:_(p0) = G_PTR_ADD [[PTR_ADD]], [[C1]](s64)
  ; CHECK:   $x0 = COPY [[PTR_ADD1]](p0)
  ; CHECK:   RET_ReallyLR implicit $x0
  %res = getelementptr %type1, %type1* %addr, i64 %idx, i32 2, i32 2
  ret i32* %res
}

@arr = external global [8 x i32]

define <2 x i32*> @vec_gep_scalar_base(<2 x i64> %offs) {
  ; CHECK-LABEL: name: vec_gep_scalar_base
  ; CHECK: bb.1.entry:
  ; CHECK:   liveins: $q0
  ; CHECK:   [[COPY:%[0-9]+]]:_(<2 x s64>) = COPY $q0
  ; CHECK:   [[GV:%[0-9]+]]:_(p0) = G_GLOBAL_VALUE @arr
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<2 x p0>) = G_BUILD_VECTOR [[GV]](p0), [[GV]](p0)
  ; CHECK:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 4
  ; CHECK:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s64>) = G_BUILD_VECTOR [[C]](s64), [[C]](s64)
  ; CHECK:   [[MUL:%[0-9]+]]:_(<2 x s64>) = G_MUL [[COPY]], [[BUILD_VECTOR1]]
  ; CHECK:   [[PTR_ADD:%[0-9]+]]:_(<2 x p0>) = G_PTR_ADD [[BUILD_VECTOR]], [[MUL]](<2 x s64>)
  ; CHECK:   [[COPY1:%[0-9]+]]:_(<2 x p0>) = COPY [[PTR_ADD]](<2 x p0>)
  ; CHECK:   $q0 = COPY [[COPY1]](<2 x p0>)
  ; CHECK:   RET_ReallyLR implicit $q0
entry:
  %0 = getelementptr inbounds [8 x i32], [8 x i32]* @arr, i64 0, <2 x i64> %offs
  ret <2 x i32*> %0
}
