/* BEGIN software license
 *
 * msXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2018 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the msXpertSuite project.
 *
 * The msXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

#pragma once

/////////////////////// stdlib includes


/////////////////////// Qt includes


/////////////////////// pappsomspp includes

/////////////////////// Local includes
#include "MsXpS/libXpertMassCore/jsclassregistrar.h"
#include "MsXpS/libXpertMassCore/globals.hpp"
#include "MsXpS/libXpertMassCore/CleavageAgent.hpp"


namespace MsXpS
{
namespace libXpertMassCore
{

/*  BEGIN CLASS JS REFERENCE
 *  namespace: MsXpS::libXpertMassCore
 *  class name: CleavageConfig
 */

class DECLSPEC CleavageConfig: public CleavageAgent
{
 Q_OBJECT

 Q_PROPERTY(int partials READ getPartials WRITE setPartials MEMBER m_partials)
 Q_PROPERTY(int startIonizeLevel READ getStartIonizeLevel WRITE
        setStartIonizeLevel MEMBER m_startIonizeLevel)
 Q_PROPERTY(int stopIonizeLevel READ getStopIonizeLevel WRITE
        setStopIonizeLevel MEMBER m_stopIonizeLevel)
 Q_PROPERTY(bool sequenceEmbedded READ isSequenceEmbedded WRITE
        setSequenceEmbedded MEMBER m_sequenceEmbedded)

 public:
 Q_INVOKABLE CleavageConfig(QObject *parent = nullptr);

 Q_INVOKABLE CleavageConfig(PolChemDefCstSPtr pol_chem_def_csp,
               const QString &name,
               const QString &pattern,
               int partials       = 0,
               bool is_sequence_embedded = false,
               QObject *parent      = nullptr);

 Q_INVOKABLE CleavageConfig(const CleavageAgent &cleavage_agent,
               int partials       = 0,
               bool is_sequence_embedded = false,
               QObject *parent      = nullptr);

 // Pseudo copy constructor
 Q_INVOKABLE CleavageConfig(const CleavageConfig &other,
               QObject *parent = nullptr);

 ~CleavageConfig();

 Q_INVOKABLE bool initialize(const CleavageConfig &other);

 Q_INVOKABLE bool setCleavageAgent(const CleavageAgent &cleavage_agent);

 void setPartials(int partials);
 int getPartials() const;

 void setStartIonizeLevel(int value);
 int getStartIonizeLevel() const;

 void setStopIonizeLevel(int value);
 int getStopIonizeLevel() const;

 Q_INVOKABLE void setIonizeLevels(int value1, int value2);

 void setSequenceEmbedded(bool is_sequence_embedded);
 bool isSequenceEmbedded() const;

 //////////////// OPERATORS /////////////////////
 CleavageConfig &operator=(const CleavageConfig &other) = delete;
 bool operator==(const CleavageConfig &other) const;
 bool operator!=(const CleavageConfig &other) const;

 static void registerJsConstructor(QJSEngine *engine);

 protected:
 int m_partials = 0;

 // These two values have to be both positive and in increasing order
 // or equal. That is m_stopIonizeLevel >= m_startIonizeLevel. Only
 // use access functions to set their values.
 // Have to be 1 and not 0, otherwise the setting functions ensuring
 // that m_startIonizeLevel>=m_stopIonizeLevel will bug.
 int m_startIonizeLevel = 1;
 int m_stopIonizeLevel = 1;

 bool m_sequenceEmbedded =false;
};


/*  END CLASS JS REFERENCE
 *  namespace: MsXpS::libXpertMassCore
 *  class name: CleavageConfig
 */

} // namespace libXpertMassCore
MSXPS_REGISTER_JS_CLASS(MsXpS::libXpertMassCore, CleavageConfig)
} // namespace MsXpS

