#ifndef _UNIQUE_TEXTURE_H
#define _UNIQUE_TEXTURE_H 1

// A wrapper around an OpenGL texture that is automatically deleted.
// Used only by ImageInput.

#include <epoxy/gl.h>
#include <memory>

struct TextureDeleter {
	void operator() (GLuint *tex)
	{
		glDeleteTextures(1, tex);
		delete tex;
	}
};

typedef std::unique_ptr<GLuint, TextureDeleter> RefCountedTexture;

#endif  // !defined(_REF_COUNTED_TEXTURE)
