/*
 * GeneralCustomizerPanel.java
 *
 * Created on September 28, 2007, 3:19 PM
 */

package org.netbeans.modules.groovy.grailsproject.ui.customizer;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/**
 *
 * @author  schmidtm
 */
public class GeneralCustomizerPanel extends javax.swing.JPanel implements HelpCtx.Provider, DocumentListener {

    private final GrailsProjectProperties uiProperties;

    /** Creates new form GeneralCustomizerPanel */
    public GeneralCustomizerPanel(GrailsProjectProperties uiProperties) {
        this.uiProperties = uiProperties;

        initComponents();

        projectFolderTextField.setText(FileUtil.getFileDisplayName(uiProperties.getProject().getProjectDirectory()));

        // populating the port field

        grailsServerPort.getDocument().addDocumentListener(this);
        grailsServerPort.setText(uiProperties.getPort());

        vmOptionsTextField.getDocument().addDocumentListener(this);
        vmOptionsTextField.setText(uiProperties.getVmOptions());

        // Here we define the indexes for the default enviroments as this:
        // 0 : "Development",
        // 1 : "Production",
        // 2 : "Test"

        grailsEnvChooser.setModel(uiProperties.getEnvironmentModel());
        grailsDisplayBrowser.setModel(uiProperties.getDisplayBrowserModel());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(GeneralCustomizerPanel.class);
    }



    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        activeGrailsEnvironmentLabel = new javax.swing.JLabel();
        grailsEnvChooser = new javax.swing.JComboBox();
        projectFolderLabel = new javax.swing.JLabel();
        projectFolderTextField = new javax.swing.JTextField();
        grailsServerPortLabel = new javax.swing.JLabel();
        grailsServerPort = new javax.swing.JTextField();
        grailsDisplayBrowser = new javax.swing.JCheckBox();
        jSeparator1 = new javax.swing.JSeparator();
        vmOptionsLabel = new javax.swing.JLabel();
        vmOptionsTextField = new javax.swing.JTextField();
        vmOptionsTipLabel = new javax.swing.JLabel();

        activeGrailsEnvironmentLabel.setText(org.openide.util.NbBundle.getMessage(GeneralCustomizerPanel.class, "GeneralCustomizerPanel.activeGrailsEnvironmentLabel.text")); // NOI18N

        grailsEnvChooser.setMaximumRowCount(3);

        projectFolderLabel.setText(org.openide.util.NbBundle.getMessage(GeneralCustomizerPanel.class, "GeneralCustomizerPanel.projectFolderLabel.text")); // NOI18N

        projectFolderTextField.setEditable(false);
        projectFolderTextField.setText(org.openide.util.NbBundle.getMessage(GeneralCustomizerPanel.class, "GeneralCustomizerPanel.projectFolderTextField.text")); // NOI18N

        grailsServerPortLabel.setText(org.openide.util.NbBundle.getMessage(GeneralCustomizerPanel.class, "GeneralCustomizerPanel.grailsServerPortLabel.text")); // NOI18N

        grailsServerPort.setText(org.openide.util.NbBundle.getMessage(GeneralCustomizerPanel.class, "GeneralCustomizerPanel.grailsServerPort.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(grailsDisplayBrowser, NbBundle.getMessage(GeneralCustomizerPanel.class, "GeneralCustomizerPanel.grailsDisplayBrowser.text")); // NOI18N
        grailsDisplayBrowser.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                grailsDisplayBrowserActionPerformed(evt);
            }
        });

        vmOptionsLabel.setLabelFor(vmOptionsTextField);
        org.openide.awt.Mnemonics.setLocalizedText(vmOptionsLabel, org.openide.util.NbBundle.getMessage(GeneralCustomizerPanel.class, "GeneralCustomizerPanel.vmOptionsLabel.text")); // NOI18N

        vmOptionsTipLabel.setText(org.openide.util.NbBundle.getMessage(GeneralCustomizerPanel.class, "GeneralCustomizerPanel.vmOptionsTipLabel.text")); // NOI18N

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(activeGrailsEnvironmentLabel)
                    .add(projectFolderLabel)
                    .add(grailsServerPortLabel))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(grailsServerPort, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 431, Short.MAX_VALUE)
                    .add(projectFolderTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 431, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, grailsEnvChooser, 0, 431, Short.MAX_VALUE)))
            .add(grailsDisplayBrowser, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 607, Short.MAX_VALUE)
            .add(layout.createSequentialGroup()
                .add(vmOptionsLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(vmOptionsTipLabel)
                        .addContainerGap())
                    .add(vmOptionsTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 519, Short.MAX_VALUE)))
            .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                .add(jSeparator1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 607, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(projectFolderLabel)
                    .add(projectFolderTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(activeGrailsEnvironmentLabel)
                    .add(grailsEnvChooser, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(grailsServerPortLabel)
                    .add(grailsServerPort, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(grailsDisplayBrowser)
                .add(18, 18, 18)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(vmOptionsLabel)
                    .add(vmOptionsTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(vmOptionsTipLabel))
            .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                .add(layout.createSequentialGroup()
                    .add(112, 112, 112)
                    .add(jSeparator1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 10, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .addContainerGap(41, Short.MAX_VALUE)))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void grailsDisplayBrowserActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_grailsDisplayBrowserActionPerformed

}//GEN-LAST:event_grailsDisplayBrowserActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel activeGrailsEnvironmentLabel;
    private javax.swing.JCheckBox grailsDisplayBrowser;
    private javax.swing.JComboBox grailsEnvChooser;
    private javax.swing.JTextField grailsServerPort;
    private javax.swing.JLabel grailsServerPortLabel;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JLabel projectFolderLabel;
    private javax.swing.JTextField projectFolderTextField;
    private javax.swing.JLabel vmOptionsLabel;
    private javax.swing.JTextField vmOptionsTextField;
    private javax.swing.JLabel vmOptionsTipLabel;
    // End of variables declaration//GEN-END:variables

    public void insertUpdate(DocumentEvent e) {
        updateTexts(e);
    }

    public void removeUpdate(DocumentEvent e) {
        updateTexts(e);
    }

    public void changedUpdate(DocumentEvent e) {
        updateTexts(e);
    }

    private void updateTexts( DocumentEvent e ) {
        Document doc = e.getDocument();

        // FIXME proper document model would be better
        if (doc == grailsServerPort.getDocument()) {
            uiProperties.setPort(grailsServerPort.getText().trim());
        } else if (doc == vmOptionsTextField.getDocument()) {
            uiProperties.setVmOptions(vmOptionsTextField.getText().trim());
        }
    }

}
