#ifndef _PBUILD_H
#define _PBUILD_H

/* pbuild.h
  
   Public interface to libpbuild.

   Copyright (C) 2007, 2008, 2009 Eloy Paris

   This is part of Network Expect.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
    
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
    
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdint.h>
#include <glib.h>

#define PDU_ERRBUF_SIZE 256

typedef struct _pdu pdu_t; /* The PDU structure; an opaque structure. Needs
			      to be created an accessed using the API
			      provided by libpbuild */

extern int pb_init(void);
extern void pb_dumppdu(const GNode *);
extern size_t pb_len(const GNode *);
extern size_t pb_build(const GNode *, uint8_t *, uint8_t *);
extern void pdu_list(void);
extern const GNode *pb_parsedef(const char *, char *);
extern const char *pb_getname(const GNode *);
extern const GNode *pb_nextpdu(const GNode *);
extern int pb_permutation_count(const GNode *);
extern void pb_destroy(GNode *);

#endif /* _PBUILD_H */
