#ifndef _PDU_VTP_H
#define _PDU_VTP_H

/* pdu-vtp.h
  
   Definitions for Cisco's VLAN Trunking Protocol.

   These defenitions were stolen from the Yersinia project
   (http://www.yersinia.net/). Their copyright notice and license is:
 
   Yersinia
   By David Barroso <tomac@wasahero.org> and Alfredo Andres <slay@wasahero.org>
   Copyright 2005 Alfredo Andres and David Barroso
  
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
 
#define VTP_SUMM_ADVERT   0x01
#define VTP_SUBSET_ADVERT 0x02
#define VTP_REQUEST       0x03
#define VTP_JOIN          0x04

#define VLAN_TYPE_ETHERNET 0x01
#define VLAN_TYPE_FDDI     0x02
#define VLAN_TYPE_TRCRF    0x03
#define VLAN_TYPE_FDDI_NET 0x04
#define VLAN_TYPE_TRBRF    0x05

/* Default values */
#define VTP_DFL_VERSION 0x01
#define VTP_DFL_DOMAIN  "\x0\x0\x0\x0\x0\x0\x0\x0"
#define VTP_DFL_DOM_LEN 0x08
#define VTP_DFL_CODE    VTP_REQUEST

#define VTP_TIMESTAMP_SIZE 12
#define VTP_DOMAIN_SIZE    32

#define VLAN_MAX       64
#define VLAN_NAME_SIZE 32
#define VLAN_ALIGNED_LEN(x)   (4*(((x)+3)/4) )

#define VTP_DOT10_BASE 0x100000

#define VTP_VLAN_ADD     0x00
#define VTP_VLAN_DEL     0x01
#define VTP_VLAN_DEL_ALL 0x02

struct vlan_info {
    uint8_t  len;   
    uint8_t  status;
    uint8_t  type;  
    uint8_t  name_len;
    uint16_t id;     
    uint16_t mtu;    
    uint32_t dot10;   
};

struct vtp_summary {
    uint8_t  version;         
    uint8_t  code;            
    uint8_t  followers;       
    uint8_t  dom_len;         
    uint8_t  domain[VTP_DOMAIN_SIZE]; 
    uint32_t revision;                    
    uint32_t updater;                     
    uint8_t  timestamp[VTP_TIMESTAMP_SIZE];    
    uint8_t  md5[16];
};

struct vtp_subset {
    uint8_t  version;     
    uint8_t  code;        
    uint8_t  seq;    
    uint8_t  dom_len;
    uint8_t  domain[VTP_DOMAIN_SIZE];
    uint32_t revision;       
};

struct vtp_request {
    uint8_t  version; 
    uint8_t  code;    
    uint8_t  reserved;
    uint8_t  dom_len;
    uint8_t  domain[VTP_DOMAIN_SIZE];
    uint16_t start_val;   
};

struct vtp_join {
    uint8_t  version;             
    uint8_t  code;                
    uint8_t  maybe_reserved;
    uint8_t  dom_len;        
    uint8_t  domain[VTP_DOMAIN_SIZE]; 
    uint32_t vlan;          
    uint8_t  unknown[126];
};

#endif /* _PDU_VTP_H */
