#
#
#            Nim's Runtime Library
#        (c) Copyright 2012 Dominik Picheta
#
#    See the file "copying.txt", included in this
#    distribution, for details about the copyright.
#

## This module implements a mimetypes database
import strtabs
from strutils import startsWith, toLowerAscii, strip

type
  MimeDB* = object
    mimes: StringTableRef

const mimes* = {
  "123": "application/vnd.lotus-1-2-3",
  "1km": "application/vnd.1000minds.decision-model+xml",
  "323": "text/h323",
  "3dm": "text/vnd.in3d.3dml",
  "3dmf": "x-world/x-3dmf",
  "3dml": "text/vnd.in3d.3dml",
  "3ds": "image/x-3ds",
  "3g2": "video/3gpp2",
  "3gp": "video/3gpp",
  "3gpp": "audio/3gpp",
  "3gpp2": "video/3gpp2",
  "3mf": "application/vnd.ms-3mfdocument",
  "669": "audio/x-mod",
  "726": "audio/32kadpcm",
  "7z": "application/x-7z-compressed",
  "a": "text/plain",
  "a2l": "application/a2l",
  "aa3": "audio/atrac3",
  "aab": "application/x-authorware-bin",
  "aac": "audio/x-aac",
  "aal": "audio/atrac-advanced-lossless",
  "aam": "application/x-authorware-map",
  "aas": "application/x-authorware-seg",
  "abc": "text/vnd.abc",
  "abw": "application/x-abiword",
  "ac": "application/pkix-attr-cert",
  "ac3": "audio/ac3",
  "acc": "application/vnd.americandynamics.acc",
  "ace": "application/x-ace-compressed",
  "acn": "audio/asc",
  "acu": "application/vnd.acucobol",
  "acutc": "application/vnd.acucorp",
  "acx": "application/internet-property-stream",
  "adp": "audio/adpcm",
  "aep": "application/vnd.audiograph",
  "afl": "video/animaflex",
  "afm": "application/x-font-type1",
  "afp": "application/vnd.ibm.modcap",
  "ahead": "application/vnd.ahead.space",
  "ai": "application/postscript",
  "aif": "audio/x-aiff",
  "aifc": "audio/x-aiff",
  "aiff": "audio/x-aiff",
  "aim": "application/x-aim",
  "aip": "text/x-audiosoft-intra",
  "air": "application/vnd.adobe.air-application-installer-package+zip",
  "ait": "application/vnd.dvb.ait",
  "alc": "chemical/x-alchemy",
  "ami": "application/vnd.amiga.ami",
  "aml": "application/aml",
  "amr": "audio/amr",
  "ani": "application/x-navi-animation",
  "anx": "application/x-annodex",
  "aos": "application/x-nokia-9000-communicator-add-on-software",
  "apinotes": "text/apinotes",
  "apk": "application/vnd.android.package-archive",
  "apkg": "application/vnd.anki",
  "apng": "image/apng",
  "appcache": "text/cache-manifest",
  "appimage": "application/appimage",
  "application": "application/x-ms-application",
  "apr": "application/vnd.lotus-approach",
  "aps": "application/mime",
  "apxml": "application/auth-policy+xml",
  "arc": "application/x-freearc",
  "arj": "application/x-arj",
  "art": "message/rfc822",
  "asar": "binary/asar",
  "asc": "text/plain",
  "ascii": "text/vnd.ascii-art",
  "asf": "application/vnd.ms-asf",
  "asice": "application/vnd.etsi.asic-e+zip",
  "asics": "application/vnd.etsi.asic-s+zip",
  "asm": "text/x-asm",
  "asn": "chemical/x-ncbi-asn1-spec",
  "aso": "application/vnd.accpac.simply.aso",
  "asp": "text/asp",
  "asr": "video/x-ms-asf",
  "asx": "video/x-ms-asf",
  "at3": "audio/atrac3",
  "atc": "application/vnd.acucorp",
  "atf": "application/atf",
  "atfx": "application/atfx",
  "atom": "application/atom+xml",
  "atomcat": "application/atomcat+xml",
  "atomdeleted": "application/atomdeleted+xml",
  "atomsrv": "application/atomserv+xml",
  "atomsvc": "application/atomsvc+xml",
  "atx": "application/vnd.antix.game-component",
  "atxml": "application/atxml",
  "au": "audio/basic",
  "auc": "application/tamp-apex-update-confirm",
  "avi": "video/x-msvideo",
  "avs": "video/avs-video",
  "aw": "application/applixware",
  "awb": "audio/amr-wb",
  "axa": "audio/x-annodex",
  "axs": "application/olescript",
  "axv": "video/x-annodex",
  "azf": "application/vnd.airzip.filesecure.azf",
  "azs": "application/vnd.airzip.filesecure.azs",
  "azv": "image/vnd.airzip.accelerator.azv",
  "azw": "application/vnd.amazon.ebook",
  "azw3": "application/vnd.amazon.mobi8-ebook",
  "b": "chemical/x-molconn-Z",
  "bak": "application/x-trash",
  "bar": "application/vnd.qualcomm.brew-app-res",
  "bas": "text/plain",
  "bash": "text/shell",
  "bat": "application/x-msdos-program",
  "bcpio": "application/x-bcpio",
  "bdf": "application/x-font-bdf",
  "bdm": "application/vnd.syncml.dm+wbxml",
  "bdoc": "application/bdoc",
  "bed": "application/vnd.realvnc.bed",
  "bh2": "application/vnd.fujitsu.oasysprs",
  "bib": "text/x-bibtex",
  "bik": "video/vnd.radgamettools.bink",
  "bin": "application/octet-stream",
  "bk2": "video/vnd.radgamettools.bink",
  "bkm": "application/vnd.nervana",
  "blb": "application/x-blorb",
  "blend": "binary/blender",
  "blorb": "application/x-blorb",
  "bm": "image/bmp",
  "bmed": "multipart/vnd.bint.med-plus",
  "bmi": "application/vnd.bmi",
  "bmml": "application/vnd.balsamiq.bmml+xml",
  "bmp": "image/bmp",
  "bmpr": "application/vnd.balsamiq.bmpr",
  "boo": "application/book",
  "book": "application/book",
  "box": "application/vnd.previewsystems.box",
  "boz": "application/x-bzip2",
  "bpd": "application/vnd.hbci",
  "bpk": "application/octet-stream",
  "brf": "text/plain",
  "bsd": "chemical/x-crossfire",
  "bsh": "application/x-bsh",
  "bsp": "model/vnd.valve.source.compiled-map",
  "btf": "image/prs.btif",
  "btif": "image/prs.btif",
  "bz": "application/x-bzip",
  "bz2": "application/x-bzip2",
  "c": "text/x-csrc",
  "c++": "text/x-c++src",
  "c11amc": "application/vnd.cluetrust.cartomobile-config",
  "c11amz": "application/vnd.cluetrust.cartomobile-config-pkg",
  "c3d": "chemical/x-chem3d",
  "c3ex": "application/cccex",
  "c4d": "application/vnd.clonk.c4group",
  "c4f": "application/vnd.clonk.c4group",
  "c4g": "application/vnd.clonk.c4group",
  "c4p": "application/vnd.clonk.c4group",
  "c4u": "application/vnd.clonk.c4group",
  "cab": "application/vnd.ms-cab-compressed",
  "cac": "chemical/x-cache",
  "cache": "application/x-cache",
  "caf": "audio/x-caf",
  "cap": "application/vnd.tcpdump.pcap",
  "car": "application/vnd.curl.car",
  "cascii": "chemical/x-cactvs-binary",
  "cat": "application/vnd.ms-pki.seccat",
  "cb7": "application/x-cbr",
  "cba": "application/x-cbr",
  "cbin": "chemical/x-cactvs-binary",
  "cbor": "application/cbor",
  "cbr": "application/x-cbr",
  "cbt": "application/x-cbr",
  "cbz": "application/vnd.comicbook+zip",
  "cc": "text/plain",
  "ccad": "application/clariscad",
  "ccc": "text/vnd.net2phone.commcenter.command",
  "ccmp": "application/ccmp+xml",
  "cco": "application/x-cocoa",
  "cct": "application/x-director",
  "ccxml": "application/ccxml+xml",
  "cda": "application/x-cdf",
  "cdbcmsg": "application/vnd.contact.cmsg",
  "cdf": "application/x-netcdf",
  "cdfx": "application/cdfx+xml",
  "cdkey": "application/vnd.mediastation.cdkey",
  "cdmia": "application/cdmi-capability",
  "cdmic": "application/cdmi-container",
  "cdmid": "application/cdmi-domain",
  "cdmio": "application/cdmi-object",
  "cdmiq": "application/cdmi-queue",
  "cdr": "image/x-coreldraw",
  "cdt": "image/x-coreldrawtemplate",
  "cdx": "chemical/x-cdx",
  "cdxml": "application/vnd.chemdraw+xml",
  "cdy": "application/vnd.cinderella",
  "cea": "application/cea",
  "cef": "chemical/x-cxf",
  "cellml": "application/cellml+xml",
  "cer": "application/pkix-cert",
  "cfg": "text/cfg",
  "cfs": "application/x-cfs-compressed",
  "cgm": "image/cgm",
  "cha": "application/x-chat",
  "chat": "application/x-chat",
  "chm": "application/vnd.ms-htmlhelp",
  "chrt": "application/vnd.kde.kchart",
  "cif": "chemical/x-cif",
  "cii": "application/vnd.anser-web-certificate-issue-initiation",
  "cil": "application/vnd.ms-artgalry",
  "cl": "application/simple-filter+xml",
  "cla": "application/vnd.claymore",
  "class": "application/java-vm",
  "clkk": "application/vnd.crick.clicker.keyboard",
  "clkp": "application/vnd.crick.clicker.palette",
  "clkt": "application/vnd.crick.clicker.template",
  "clkw": "application/vnd.crick.clicker.wordbank",
  "clkx": "application/vnd.crick.clicker",
  "clp": "application/x-msclip",
  "cls": "text/x-tex",
  "clue": "application/clue_info+xml",
  "cmake": "text/cmake",
  "cmc": "application/vnd.cosmocaller",
  "cmdf": "chemical/x-cmdf",
  "cml": "chemical/x-cml",
  "cmp": "application/vnd.yellowriver-custom-menu",
  "cmsc": "application/cms",
  "cmx": "image/x-cmx",
  "cnd": "text/jcr-cnd",
  "cnf": "text/cnf",
  "cod": "application/vnd.rim.cod",
  "coffee": "application/vnd.coffeescript",
  "com": "application/x-msdos-program",
  "conf": "text/plain",
  "copyright": "text/vnd.debian.copyright",
  "cpa": "chemical/x-compass",
  "cpio": "application/x-cpio",
  "cpkg": "application/vnd.xmpie.cpkg",
  "cpl": "application/cpl+xml",
  "cpp": "text/x-c++src",
  "cpt": "application/mac-compactpro",
  "cr2": "image/x-canon-cr2",
  "crd": "application/x-mscardfile",
  "crl": "application/pkix-crl",
  "crt": "application/x-x509-ca-cert",
  "crtr": "application/vnd.multiad.creator",
  "crw": "image/x-canon-crw",
  "crx": "application/x-chrome-extension",
  "cryptonote": "application/vnd.rig.cryptonote",
  "cs": "text/c#",
  "csf": "chemical/x-cache-csf",
  "csh": "application/x-csh",
  "csl": "application/vnd.citationstyles.style+xml",
  "csm": "chemical/x-csml",
  "csml": "chemical/x-csml",
  "cson": "text/cson",
  "csp": "application/vnd.commonspace",
  "csrattrs": "application/csrattrs",
  "css": "text/css",
  "cst": "application/vnd.commonspace",
  "csv": "text/csv",
  "csvs": "text/csv-schema",
  "ctab": "chemical/x-cactvs-binary",
  "ctx": "chemical/x-ctx",
  "cu": "application/cu-seeme",
  "cub": "chemical/x-gaussian-cube",
  "cuc": "application/tamp-community-update-confirm",
  "curl": "text/vnd.curl",
  "cw": "application/prs.cww",
  "cww": "application/prs.cww",
  "cxf": "chemical/x-cxf",
  "cxt": "application/x-director",
  "cxx": "text/plain",
  "d": "text/x-dsrc",
  "dae": "model/vnd.collada+xml",
  "daf": "application/vnd.mobius.daf",
  "dart": "application/vnd.dart",
  "dat": "application/x-ns-proxy-autoconfig",
  "dataless": "application/vnd.fdsn.seed",
  "davmount": "application/davmount+xml",
  "dbk": "application/docbook+xml",
  "dcd": "application/dcd",
  "dcf": "application/vnd.oma.drm.content",
  "dcm": "application/dicom",
  "dcr": "application/x-director",
  "dcurl": "text/vnd.curl.dcurl",
  "dd": "application/vnd.oma.dd+xml",
  "dd2": "application/vnd.oma.dd2+xml",
  "ddd": "application/vnd.fujixerox.ddd",
  "ddf": "application/vnd.syncml.dmddf+xml",
  "deb": "application/vnd.debian.binary-package",
  "deepv": "application/x-deepv",
  "def": "text/plain",
  "deploy": "application/octet-stream",
  "der": "application/x-x509-ca-cert",
  "dfac": "application/vnd.dreamfactory",
  "dgc": "application/x-dgc-compressed",
  "dib": "image/bmp",
  "dic": "text/x-c",
  "dif": "video/x-dv",
  "diff": "text/x-diff",
  "dii": "application/dii",
  "dim": "application/vnd.fastcopy-disk-image",
  "dir": "application/x-director",
  "dis": "application/vnd.mobius.dis",
  "disposition-notification": "message/disposition-notification",
  "dist": "application/vnd.apple.installer+xml",
  "distz": "application/vnd.apple.installer+xml",
  "dit": "application/dit",
  "djv": "image/vnd.djvu",
  "djvu": "image/vnd.djvu",
  "dl": "video/dl",
  "dll": "application/x-msdos-program",
  "dls": "audio/dls",
  "dm": "application/vnd.oma.drm.message",
  "dmg": "application/x-apple-diskimage",
  "dmp": "application/vnd.tcpdump.pcap",
  "dms": "text/vnd.dmclientscript",
  "dna": "application/vnd.dna",
  "doc": "application/msword",
  "docjson": "application/vnd.document+json",
  "docm": "application/vnd.ms-word.document.macroenabled.12",
  "docx": "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
  "dor": "model/vnd.gdl",
  "dot": "text/vnd.graphviz",
  "dotm": "application/vnd.ms-word.template.macroenabled.12",
  "dotx": "application/vnd.openxmlformats-officedocument.wordprocessingml.template",
  "dp": "application/vnd.osgi.dp",
  "dpg": "application/vnd.dpgraph",
  "dpgraph": "application/vnd.dpgraph",
  "dpkg": "application/vnd.xmpie.dpkg",
  "dr": "application/vnd.oma.drm.rights+xml",
  "dra": "audio/vnd.dra",
  "drc": "application/vnd.oma.drm.rights+wbxml",
  "drle": "image/dicom-rle",
  "drw": "application/drafting",
  "dsc": "text/prs.lines.tag",
  "dsm": "application/vnd.desmume.movie",
  "dssc": "application/dssc+der",
  "dtb": "application/x-dtbook+xml",
  "dtd": "application/xml-dtd",
  "dts": "audio/vnd.dts",
  "dtshd": "audio/vnd.dts.hd",
  "dump": "application/octet-stream",
  "dv": "video/x-dv",
  "dvb": "video/vnd.dvb.file",
  "dvc": "application/dvcs",
  "dvi": "application/x-dvi",
  "dwf": "model/vnd.dwf",
  "dwg": "image/vnd.dwg",
  "dx": "chemical/x-jcamp-dx",
  "dxf": "image/vnd.dxf",
  "dxp": "application/vnd.spotfire.dxp",
  "dxr": "application/x-director",
  "dzr": "application/vnd.dzr",
  "ear": "binary/zip",
  "ecelp4800": "audio/vnd.nuera.ecelp4800",
  "ecelp7470": "audio/vnd.nuera.ecelp7470",
  "ecelp9600": "audio/vnd.nuera.ecelp9600",
  "ecig": "application/vnd.evolv.ecig.settings",
  "ecigprofile": "application/vnd.evolv.ecig.profile",
  "ecigtheme": "application/vnd.evolv.ecig.theme",
  "ecma": "application/ecmascript",
  "edm": "application/vnd.novadigm.edm",
  "edx": "application/vnd.novadigm.edx",
  "efi": "application/efi",
  "efif": "application/vnd.picsel",
  "ei6": "application/vnd.pg.osasli",
  "ejs": "text/ejs",
  "el": "text/plain",
  "elc": "application/x-bytecode.elisp",
  "emb": "chemical/x-embl-dl-nucleotide",
  "embl": "chemical/x-embl-dl-nucleotide",
  "emf": "image/emf",
  "eml": "message/rfc822",
  "emm": "application/vnd.ibm.electronic-media",
  "emma": "application/emma+xml",
  "emotionml": "application/emotionml+xml",
  "emz": "application/x-msmetafile",
  "ent": "text/xml-external-parsed-entity",
  "entity": "application/vnd.nervana",
  "env": "application/x-envoy",
  "enw": "audio/evrcnw",
  "eol": "audio/vnd.digital-winds",
  "eot": "application/vnd.ms-fontobject",
  "ep": "application/vnd.bluetooth.ep.oob",
  "eps": "application/postscript",
  "eps2": "application/postscript",
  "eps3": "application/postscript",
  "epsf": "application/postscript",
  "epsi": "application/postscript",
  "epub": "application/epub+zip",
  "erb": "text/erb",
  "erf": "image/x-epson-erf",
  "es": "application/ecmascript",
  "es3": "application/vnd.eszigno3+xml",
  "esa": "application/vnd.osgi.subsystem",
  "escn": "text/godot",
  "esf": "application/vnd.epson.esf",
  "espass": "application/vnd.espass-espass+zip",
  "et3": "application/vnd.eszigno3+xml",
  "etx": "text/x-setext",
  "eva": "application/x-eva",
  "evb": "audio/evrcb",
  "evc": "audio/evrc",
  "evw": "audio/evrcwb",
  "evy": "application/x-envoy",
  "exe": "application/x-msdos-program",
  "exi": "application/exi",
  "exr": "image/aces",
  "ext": "application/vnd.novadigm.ext",
  "eyaml": "text/yaml",
  "ez": "application/andrew-inset",
  "ez2": "application/vnd.ezpix-album",
  "ez3": "application/vnd.ezpix-package",
  "f": "text/x-fortran",
  "f4v": "video/x-f4v",
  "f77": "text/x-fortran",
  "f90": "text/plain",
  "fb": "application/x-maker",
  "fbdoc": "application/x-maker",
  "fbs": "image/vnd.fastbidsheet",
  "fbx": "model/filmbox",
  "fcdt": "application/vnd.adobe.formscentral.fcdt",
  "fch": "chemical/x-gaussian-checkpoint",
  "fchk": "chemical/x-gaussian-checkpoint",
  "fcs": "application/vnd.isac.fcs",
  "fdf": "application/vnd.fdf",
  "fdt": "application/fdt+xml",
  "fe_launch": "application/vnd.denovo.fcselayout-link",
  "feature": "text/gherkin",
  "fg5": "application/vnd.fujitsu.oasysgp",
  "fgd": "application/x-director",
  "fh": "image/x-freehand",
  "fh4": "image/x-freehand",
  "fh5": "image/x-freehand",
  "fh7": "image/x-freehand",
  "fhc": "image/x-freehand",
  "fif": "image/fif",
  "fig": "application/x-xfig",
  "finf": "application/fastinfoset",
  "fish": "text/fish",
  "fit": "image/fits",
  "fits": "image/fits",
  "fla": "application/vnd.dtg.local.flash",
  "flac": "audio/x-flac",
  "fli": "video/x-fli",
  "flo": "application/vnd.micrografx.flo",
  "flr": "x-world/x-vrml",
  "flv": "video/x-flv",
  "flw": "application/vnd.kde.kivio",
  "flx": "text/vnd.fmi.flexstor",
  "fly": "text/vnd.fly",
  "fm": "application/vnd.framemaker",
  "fmf": "video/x-atomic3d-feature",
  "fnc": "application/vnd.frogans.fnc",
  "fo": "application/vnd.software602.filler.form+xml",
  "for": "text/x-fortran",
  "fpx": "image/vnd.fpx",
  "frame": "application/vnd.framemaker",
  "frl": "application/freeloader",
  "frm": "application/vnd.ufdl",
  "fsc": "application/vnd.fsc.weblaunch",
  "fst": "image/vnd.fst",
  "ftc": "application/vnd.fluxtime.clip",
  "fti": "application/vnd.anser-web-funds-transfer-initiation",
  "fts": "image/fits",
  "funk": "audio/make",
  "fvt": "video/vnd.fvt",
  "fxm": "video/x-javafx",
  "fxp": "application/vnd.adobe.fxp",
  "fxpl": "application/vnd.adobe.fxp",
  "fzs": "application/vnd.fuzzysheet",
  "g": "text/plain",
  "g2w": "application/vnd.geoplan",
  "g3": "image/g3fax",
  "g3w": "application/vnd.geospace",
  "gac": "application/vnd.groove-account",
  "gal": "chemical/x-gaussian-log",
  "gam": "application/x-tads",
  "gamin": "chemical/x-gamess-input",
  "gau": "chemical/x-gaussian-input",
  "gbr": "application/rpki-ghostbusters",
  "gca": "application/x-gca-compressed",
  "gcd": "text/x-pcs-gcd",
  "gcf": "application/x-graphing-calculator",
  "gcg": "chemical/x-gcg8-sequence",
  "gdl": "model/vnd.gdl",
  "gdoc": "application/vnd.google-apps.document",
  "gemspec": "text/ruby",
  "gen": "chemical/x-genbank",
  "geo": "application/vnd.dynageo",
  "geojson": "application/geo+json",
  "gex": "application/vnd.geometry-explorer",
  "gf": "application/x-tex-gf",
  "ggb": "application/vnd.geogebra.file",
  "ggt": "application/vnd.geogebra.tool",
  "ghf": "application/vnd.groove-help",
  "gif": "image/gif",
  "gim": "application/vnd.groove-identity-message",
  "gjc": "chemical/x-gaussian-input",
  "gjf": "chemical/x-gaussian-input",
  "gl": "video/gl",
  "glb": "model/gltf-binary",
  "gltf": "model/gltf+json",
  "gml": "application/gml+xml",
  "gmx": "application/vnd.gmx",
  "gnumeric": "application/x-gnumeric",
  "go": "text/go",
  "gotmpl": "text/gotmpl",
  "gph": "application/vnd.flographit",
  "gpt": "chemical/x-mopac-graph",
  "gpx": "application/gpx+xml",
  "gqf": "application/vnd.grafeq",
  "gqs": "application/vnd.grafeq",
  "gradle": "text/groovy",
  "gram": "application/srgs",
  "gramps": "application/x-gramps-xml",
  "gre": "application/vnd.geometry-explorer",
  "groovy": "text/groovy",
  "grv": "application/vnd.groove-injector",
  "grxml": "application/srgs+xml",
  "gsd": "audio/x-gsm",
  "gsf": "application/x-font-ghostscript",
  "gsheet": "application/vnd.google-apps.spreadsheet",
  "gslides": "application/vnd.google-apps.presentation",
  "gsm": "model/vnd.gdl",
  "gsp": "application/x-gsp",
  "gss": "application/x-gss",
  "gtar": "application/x-gtar",
  "gtm": "application/vnd.groove-tool-message",
  "gtw": "model/vnd.gtw",
  "gv": "text/vnd.graphviz",
  "gxf": "application/gxf",
  "gxt": "application/vnd.geonext",
  "gyb": "text/gyb",
  "gyp": "text/gyp",
  "gypi": "text/gyp",
  "gz": "application/gzip",
  "h": "text/x-chdr",
  "h++": "text/x-c++hdr",
  "h261": "video/h261",
  "h263": "video/h263",
  "h264": "video/h264",
  "hal": "application/vnd.hal+xml",
  "hbc": "application/vnd.hbci",
  "hbci": "application/vnd.hbci",
  "hbs": "text/x-handlebars-template",
  "hdd": "application/x-virtualbox-hdd",
  "hdf": "application/x-hdf",
  "hdr": "image/vnd.radiance",
  "hdt": "application/vnd.hdt",
  "heic": "image/heic",
  "heics": "image/heic-sequence",
  "heif": "image/heif",
  "heifs": "image/heif-sequence",
  "help": "application/x-helpfile",
  "hgl": "application/vnd.hp-hpgl",
  "hh": "text/plain",
  "hin": "chemical/x-hin",
  "hjson": "application/hjson",
  "hlb": "text/x-script",
  "hlp": "application/winhlp",
  "hpg": "application/vnd.hp-hpgl",
  "hpgl": "application/vnd.hp-hpgl",
  "hpi": "application/vnd.hp-hpid",
  "hpid": "application/vnd.hp-hpid",
  "hpp": "text/x-c++hdr",
  "hps": "application/vnd.hp-hps",
  "hpub": "application/prs.hpub+zip",
  "hqx": "application/mac-binhex40",
  "hs": "text/x-haskell",
  "hta": "application/hta",
  "htc": "text/x-component",
  "htke": "application/vnd.kenameaapp",
  "html": "text/html",
  "htt": "text/webviewhtml",
  "hvd": "application/vnd.yamaha.hv-dic",
  "hvp": "application/vnd.yamaha.hv-voice",
  "hvs": "application/vnd.yamaha.hv-script",
  "hx": "text/haxe",
  "hxml": "text/haxe",
  "hxx": "text/plain",
  "i2g": "application/vnd.intergeo",
  "ic0": "application/vnd.commerce-battelle",
  "ic1": "application/vnd.commerce-battelle",
  "ic2": "application/vnd.commerce-battelle",
  "ic3": "application/vnd.commerce-battelle",
  "ic4": "application/vnd.commerce-battelle",
  "ic5": "application/vnd.commerce-battelle",
  "ic6": "application/vnd.commerce-battelle",
  "ic7": "application/vnd.commerce-battelle",
  "ic8": "application/vnd.commerce-battelle",
  "ica": "application/vnd.commerce-battelle",
  "icc": "application/vnd.iccprofile",
  "icd": "application/vnd.commerce-battelle",
  "ice": "x-conference/x-cooltalk",
  "icf": "application/vnd.commerce-battelle",
  "icm": "application/vnd.iccprofile",
  "icns": "binary/icns",
  "ico": "image/x-icon",
  "ics": "text/calendar",
  "icz": "text/calendar",
  "idc": "text/plain",
  "idl": "text/idl",
  "ief": "image/ief",
  "iefs": "image/ief",
  "ifb": "text/calendar",
  "ifm": "application/vnd.shana.informed.formdata",
  "iges": "model/iges",
  "igl": "application/vnd.igloader",
  "igm": "application/vnd.insors.igm",
  "ign": "application/vnd.coreos.ignition+json",
  "ignition": "application/vnd.coreos.ignition+json",
  "igs": "model/iges",
  "igx": "application/vnd.micrografx.igx",
  "iif": "application/vnd.shana.informed.interchange",
  "iii": "application/x-iphone",
  "ima": "application/x-ima",
  "imap": "application/x-httpd-imap",
  "imf": "application/vnd.imagemeter.folder+zip",
  "img": "application/octet-stream",
  "imgcal": "application/vnd.3lightssoftware.imagescal",
  "imi": "application/vnd.imagemeter.image+zip",
  "imp": "application/vnd.accpac.simply.imp",
  "ims": "application/vnd.ms-ims",
  "imscc": "application/vnd.ims.imsccv1p1",
  "in": "text/plain",
  "inc": "text/inc",
  "inf": "application/inf",
  "info": "application/x-info",
  "ini": "text/ini",
  "ink": "application/inkml+xml",
  "inkml": "application/inkml+xml",
  "inp": "chemical/x-gamess-input",
  "ins": "application/x-internet-signup",
  "install": "application/x-install-instructions",
  "iota": "application/vnd.astraea-software.iota",
  "ip": "application/x-ip2",
  "ipfix": "application/ipfix",
  "ipk": "application/vnd.shana.informed.package",
  "irm": "application/vnd.ibm.rights-management",
  "irp": "application/vnd.irepository.package+xml",
  "ism": "model/vnd.gdl",
  "iso": "application/x-iso9660-image",
  "isp": "application/x-internet-signup",
  "ist": "chemical/x-isostar",
  "istr": "chemical/x-isostar",
  "isu": "video/x-isvideo",
  "it": "audio/it",
  "itp": "application/vnd.shana.informed.formtemplate",
  "its": "application/its+xml",
  "iv": "application/x-inventor",
  "ivp": "application/vnd.immervision-ivp",
  "ivr": "i-world/i-vrml",
  "ivu": "application/vnd.immervision-ivu",
  "ivy": "application/x-livescreen",
  "j2": "text/jinja",
  "jad": "text/vnd.sun.j2me.app-descriptor",
  "jade": "text/jade",
  "jam": "application/vnd.jam",
  "jar": "application/x-java-archive",
  "jardiff": "application/x-java-archive-diff",
  "java": "text/x-java-source",
  "jcm": "application/x-java-commerce",
  "jdx": "chemical/x-jcamp-dx",
  "jenkinsfile": "text/groovy",
  "jfif": "image/jpeg",
  "jinja": "text/jinja",
  "jinja2": "text/jinja",
  "jisp": "application/vnd.jisp",
  "jls": "image/jls",
  "jlt": "application/vnd.hp-jlyt",
  "jl": "text/julia",
  "jmz": "application/x-jmol",
  "jng": "image/x-jng",
  "jnlp": "application/x-java-jnlp-file",
  "joda": "application/vnd.joost.joda-archive",
  "jp2": "image/jp2",
  "jpe": "image/jpeg",
  "jpeg": "image/jpeg",
  "jpf": "image/jpx",
  "jpg": "image/jpeg",
  "jpg2": "image/jp2",
  "jpgm": "image/jpm",
  "jpgv": "video/jpeg",
  "jpm": "image/jpm",
  "jps": "image/x-jps",
  "jpx": "image/jpx",
  "jrd": "application/jrd+json",
  "js": "application/javascript",
  "json": "application/json",
  "json-patch": "application/json-patch+json",
  "json5": "application/json5",
  "jsonld": "application/ld+json",
  "jsonml": "application/jsonml+json",
  "jsx": "text/jsx",
  "jtd": "text/vnd.esmertec.theme-descriptor",
  "jut": "image/jutvision",
  "kar": "audio/midi",
  "karbon": "application/vnd.kde.karbon",
  "kcm": "application/vnd.nervana",
  "key": "application/pgp-keys",
  "keynote": "application/vnd.apple.keynote",
  "kfo": "application/vnd.kde.kformula",
  "kia": "application/vnd.kidspiration",
  "kil": "application/x-killustrator",
  "kin": "chemical/x-kinemage",
  "kml": "application/vnd.google-earth.kml+xml",
  "kmz": "application/vnd.google-earth.kmz",
  "kne": "application/vnd.kinar",
  "knp": "application/vnd.kinar",
  "kom": "application/vnd.hbci",
  "kon": "application/vnd.kde.kontour",
  "koz": "audio/vnd.audikoz",
  "kpr": "application/vnd.kde.kpresenter",
  "kpt": "application/vnd.kde.kpresenter",
  "kpxx": "application/vnd.ds-keypoint",
  "ksh": "application/x-ksh",
  "ksp": "application/vnd.kde.kspread",
  "kt": "text/kotlin",
  "ktr": "application/vnd.kahootz",
  "ktx": "image/ktx",
  "ktz": "application/vnd.kahootz",
  "kwd": "application/vnd.kde.kword",
  "kwt": "application/vnd.kde.kword",
  "l16": "audio/l16",
  "la": "audio/nspaudio",
  "lam": "audio/x-liveaudio",
  "lasjson": "application/vnd.las.las+json",
  "lasxml": "application/vnd.las.las+xml",
  "latex": "application/x-latex",
  "lbc": "audio/ilbc",
  "lbd": "application/vnd.llamagraphics.life-balance.desktop",
  "lbe": "application/vnd.llamagraphics.life-balance.exchange+xml",
  "le": "application/vnd.bluetooth.le.oob",
  "les": "application/vnd.hhe.lesson-player",
  "less": "text/less",
  "lgr": "application/lgr+xml",
  "lha": "application/octet-stream",
  "lhs": "text/x-literate-haskell",
  "lhx": "application/octet-stream",
  "lin": "application/bbolin",
  "link66": "application/vnd.route66.link66+xml",
  "list": "text/plain",
  "list3820": "application/vnd.ibm.modcap",
  "listafp": "application/vnd.ibm.modcap",
  "lmp": "model/vnd.gdl",
  "lnk": "application/x-ms-shortcut",
  "log": "text/plain",
  "lostsyncxml": "application/lostsync+xml",
  "lostxml": "application/lost+xml",
  "lrf": "application/octet-stream",
  "lrm": "application/vnd.ms-lrm",
  "lsf": "video/x-la-asf",
  "lsp": "text/x-script.lisp",
  "lst": "text/plain",
  "lsx": "video/x-la-asf",
  "ltf": "application/vnd.frogans.ltf",
  "ltx": "application/x-latex",
  "lua": "text/x-lua",
  "luac": "application/x-lua-bytecode",
  "lvp": "audio/vnd.lucent.voice",
  "lwp": "application/vnd.lotus-wordpro",
  "lxf": "application/lxf",
  "lyx": "application/x-lyx",
  "lzh": "application/octet-stream",
  "lzx": "application/x-lzx",
  "m": "application/vnd.wolfram.mathematica.package",
  "m13": "application/x-msmediaview",
  "m14": "application/x-msmediaview",
  "m15": "audio/x-mod",
  "m1v": "video/mpeg",
  "m21": "application/mp21",
  "m2a": "audio/mpeg",
  "m2v": "video/mpeg",
  "m3a": "audio/mpeg",
  "m3g": "application/m3g",
  "m3u": "audio/x-mpegurl",
  "m3u8": "application/vnd.apple.mpegurl",
  "m4a": "audio/x-m4a",
  "m4s": "video/iso.segment",
  "m4u": "video/vnd.mpegurl",
  "m4v": "video/x-m4v",
  "ma": "application/mathematica",
  "mads": "application/mads+xml",
  "mag": "application/vnd.ecowin.chart",
  "mail": "message/rfc822",
  "maker": "application/vnd.framemaker",
  "man": "application/x-troff-man",
  "manifest": "text/cache-manifest",
  "map": "application/x-navimap",
  "mar": "text/plain",
  "markdown": "text/markdown",
  "mathml": "application/mathml+xml",
  "mb": "application/mathematica",
  "mbd": "application/mbedlet",
  "mbk": "application/vnd.mobius.mbk",
  "mbox": "application/mbox",
  "mc$": "application/x-magic-cap-package-1.0",
  "mc1": "application/vnd.medcalcdata",
  "mcd": "application/vnd.mcd",
  "mcf": "image/vasa",
  "mcif": "chemical/x-mmcif",
  "mcm": "chemical/x-macmolecule",
  "mcp": "application/netmc",
  "mcurl": "text/vnd.curl.mcurl",
  "md": "text/markdown",
  "mdb": "application/x-msaccess",
  "mdc": "application/vnd.marlin.drm.mdcf",
  "mdi": "image/vnd.ms-modi",
  "me": "application/x-troff-me",
  "med": "audio/x-mod",
  "mesh": "model/mesh",
  "meta4": "application/metalink4+xml",
  "metalink": "application/metalink+xml",
  "mets": "application/mets+xml",
  "mf4": "application/mf4",
  "mfm": "application/vnd.mfmp",
  "mft": "application/rpki-manifest",
  "mgp": "application/vnd.osgeo.mapguide.package",
  "mgz": "application/vnd.proteus.magazine",
  "mht": "message/rfc822",
  "mhtml": "message/rfc822",
  "mib": "text/mib",
  "mid": "audio/midi",
  "midi": "audio/midi",
  "mie": "application/x-mie",
  "mif": "application/x-mif",
  "mime": "message/rfc822",
  "miz": "text/mizar",
  "mj2": "video/mj2",
  "mjf": "audio/x-vnd.audioexplosion.mjuicemediafile",
  "mjp2": "video/mj2",
  "mjpg": "video/x-motion-jpeg",
  "mjs": "application/javascript",
  "mk": "text/makefile",
  "mk3d": "video/x-matroska-3d",
  "mka": "audio/x-matroska",
  "mkd": "text/x-markdown",
  "mks": "video/x-matroska",
  "mkv": "video/x-matroska",
  "mlp": "application/vnd.dolby.mlp",
  "mm": "application/x-freemind",
  "mmd": "application/vnd.chipnuts.karaoke-mmd",
  "mmdb": "application/vnd.maxmind.maxmind-db",
  "mme": "application/base64",
  "mmf": "application/vnd.smaf",
  "mml": "text/mathml",
  "mmod": "chemical/x-macromodel-input",
  "mmr": "image/vnd.fujixerox.edmics-mmr",
  "mms": "application/vnd.wap.mms-message",
  "mng": "video/x-mng",
  "mny": "application/x-msmoney",
  "mobi": "application/x-mobipocket-ebook",
  "moc": "text/x-moc",
  "mod": "audio/x-mod",
  "model-inter": "application/vnd.vd-study",
  "mods": "application/mods+xml",
  "modulemap": "text/modulemap",
  "mol": "chemical/x-mdl-molfile",
  "mol2": "chemical/x-mol2",
  "moml": "model/vnd.moml+xml",
  "moo": "chemical/x-mopac-out",
  "moov": "video/quicktime",
  "mop": "chemical/x-mopac-input",
  "mopcrt": "chemical/x-mopac-input",
  "mov": "video/quicktime",
  "movie": "video/x-sgi-movie",
  "mp1": "audio/mpeg",
  "mp2": "audio/mpeg",
  "mp21": "application/mp21",
  "mp2a": "audio/mpeg",
  "mp3": "audio/mp3",
  "mp4": "video/mp4",
  "mp4a": "audio/mp4",
  "mp4s": "application/mp4",
  "mp4v": "video/mp4",
  "mpa": "video/mpeg",
  "mpc": "application/vnd.mophun.certificate",
  "mpd": "application/dash+xml",
  "mpdd": "application/dashdelta",
  "mpe": "video/mpeg",
  "mpeg": "video/mpeg",
  "mpega": "audio/mpeg",
  "mpf": "text/vnd.ms-mediapackage",
  "mpg": "video/mpeg",
  "mpg4": "video/mp4",
  "mpga": "audio/mpeg",
  "mpkg": "application/vnd.apple.installer+xml",
  "mpm": "application/vnd.blueice.multipass",
  "mpn": "application/vnd.mophun.application",
  "mpp": "application/vnd.ms-project",
  "mpt": "application/vnd.ms-project",
  "mpv": "application/x-project",
  "mpv2": "video/mpeg",
  "mpx": "application/x-project",
  "mpy": "application/vnd.ibm.minipay",
  "mqy": "application/vnd.mobius.mqy",
  "mrc": "application/marc",
  "mrcx": "application/marcxml+xml",
  "ms": "application/x-troff-ms",
  "msa": "application/vnd.msa-disk-image",
  "mscml": "application/mediaservercontrol+xml",
  "msd": "application/vnd.fdsn.mseed",
  "mseed": "application/vnd.fdsn.mseed",
  "mseq": "application/vnd.mseq",
  "msf": "application/vnd.epson.msf",
  "msg": "application/vnd.ms-outlook",
  "msh": "model/mesh",
  "msi": "application/x-msi",
  "msl": "application/vnd.mobius.msl",
  "msm": "model/vnd.gdl",
  "msty": "application/vnd.muvee.style",
  "mtm": "audio/x-mod",
  "mts": "model/vnd.mts",
  "multitrack": "audio/vnd.presonus.multitrack",
  "mus": "application/vnd.musician",
  "musd": "application/mmt-usd+xml",
  "musicxml": "application/vnd.recordare.musicxml+xml",
  "mv": "video/x-sgi-movie",
  "mvb": "application/x-msmediaview",
  "mvt": "application/vnd.mapbox-vector-tile",
  "mwc": "application/vnd.dpgraph",
  "mwf": "application/vnd.mfer",
  "mxf": "application/mxf",
  "mxi": "application/vnd.vd-study",
  "mxl": "application/vnd.recordare.musicxml",
  "mxmf": "audio/mobile-xmf",
  "mxml": "application/xv+xml",
  "mxs": "application/vnd.triscape.mxs",
  "mxu": "video/vnd.mpegurl",
  "my": "audio/make",
  "mzz": "application/x-vnd.audioexplosion.mzz",
  "n-gage": "application/vnd.nokia.n-gage.symbian.install",
  "n3": "text/n3",
  "nap": "image/naplps",
  "naplps": "image/naplps",
  "nb": "application/mathematica",
  "nbp": "application/vnd.wolfram.player",
  "nc": "application/x-netcdf",
  "ncm": "application/vnd.nokia.configuration-message",
  "ncx": "application/x-dtbncx+xml",
  "ndc": "application/vnd.osa.netdeploy",
  "ndjson": "application/json",
  "ndl": "application/vnd.lotus-notes",
  "nds": "application/vnd.nintendo.nitro.rom",
  "nef": "image/x-nikon-nef",
  "nfo": "text/x-nfo",
  "ngdat": "application/vnd.nokia.n-gage.data",
  "ngdoc": "text/ngdoc",
  "nif": "image/x-niff",
  "niff": "image/x-niff",
  "nim": "text/nim",
  "nimble": "text/nimble",
  "nimf": "text/nim",
  "nims": "text/nim",
  "nitf": "application/vnd.nitf",
  "nix": "application/x-mix-transfer",
  "nlu": "application/vnd.neurolanguage.nlu",
  "nml": "application/vnd.enliven",
  "nnd": "application/vnd.noblenet-directory",
  "nns": "application/vnd.noblenet-sealer",
  "nnw": "application/vnd.noblenet-web",
  "notebook": "application/vnd.smart.notebook",
  "npx": "image/vnd.net-fpx",
  "nq": "application/n-quads",
  "ns2": "application/vnd.lotus-notes",
  "ns3": "application/vnd.lotus-notes",
  "ns4": "application/vnd.lotus-notes",
  "nsc": "application/x-conference",
  "nsf": "application/vnd.lotus-notes",
  "nsg": "application/vnd.lotus-notes",
  "nsh": "application/vnd.lotus-notes",
  "nt": "application/n-triples",
  "ntf": "application/vnd.lotus-notes",
  "numbers": "application/vnd.apple.numbers",
  "nvd": "application/x-navidoc",
  "nwc": "application/x-nwc",
  "nws": "message/rfc822",
  "nzb": "application/x-nzb",
  "o": "application/x-object",
  "o4a": "application/vnd.oma.drm.dcf",
  "o4v": "application/vnd.oma.drm.dcf",
  "oa2": "application/vnd.fujitsu.oasys2",
  "oa3": "application/vnd.fujitsu.oasys3",
  "oas": "application/vnd.fujitsu.oasys",
  "obd": "application/x-msbinder",
  "obg": "application/vnd.openblox.game-binary",
  "obgx": "application/vnd.openblox.game+xml",
  "obj": "application/x-tgif",
  "oda": "application/oda",
  "odb": "application/vnd.oasis.opendocument.database",
  "odc": "application/vnd.oasis.opendocument.chart",
  "odd": "application/tei+xml",
  "odf": "application/vnd.oasis.opendocument.formula",
  "odft": "application/vnd.oasis.opendocument.formula-template",
  "odg": "application/vnd.oasis.opendocument.graphics",
  "odi": "application/vnd.oasis.opendocument.image",
  "odm": "application/vnd.oasis.opendocument.text-master",
  "odp": "application/vnd.oasis.opendocument.presentation",
  "ods": "application/vnd.oasis.opendocument.spreadsheet",
  "odt": "application/vnd.oasis.opendocument.text",
  "odx": "application/odx",
  "oeb": "application/vnd.openeye.oeb",
  "oga": "audio/ogg",
  "ogex": "model/vnd.opengex",
  "ogg": "audio/ogg",
  "ogv": "video/ogg",
  "ogx": "application/ogg",
  "old": "application/x-trash",
  "omc": "application/x-omc",
  "omcd": "application/x-omcdatamaker",
  "omcr": "application/x-omcregerator",
  "omdoc": "application/omdoc+xml",
  "omg": "audio/atrac3",
  "onepkg": "application/onenote",
  "onetmp": "application/onenote",
  "onetoc": "application/onenote",
  "onetoc2": "application/onenote",
  "opf": "application/oebps-package+xml",
  "opml": "text/x-opml",
  "oprc": "application/vnd.palm",
  "opus": "audio/ogg",
  "or2": "application/vnd.lotus-organizer",
  "or3": "application/vnd.lotus-organizer",
  "orf": "image/x-olympus-orf",
  "org": "text/x-org",
  "orq": "application/ocsp-request",
  "ors": "application/ocsp-response",
  "osf": "application/vnd.yamaha.openscoreformat",
  "osfpvg": "application/vnd.yamaha.openscoreformat.osfpvg+xml",
  "osm": "application/vnd.openstreetmap.data+xml",
  "otc": "application/vnd.oasis.opendocument.chart-template",
  "otf": "font/otf",
  "otg": "application/vnd.oasis.opendocument.graphics-template",
  "oth": "application/vnd.oasis.opendocument.text-web",
  "oti": "application/vnd.oasis.opendocument.image-template",
  "otp": "application/vnd.oasis.opendocument.presentation-template",
  "ots": "application/vnd.oasis.opendocument.spreadsheet-template",
  "ott": "application/vnd.oasis.opendocument.text-template",
  "ova": "application/x-virtualbox-ova",
  "ovf": "application/x-virtualbox-ovf",
  "owx": "application/owl+xml",
  "oxlicg": "application/vnd.oxli.countgraph",
  "oxps": "application/oxps",
  "oxt": "application/vnd.openofficeorg.extension",
  "oza": "application/x-oz-application",
  "p": "text/x-pascal",
  "p10": "application/pkcs10",
  "p12": "application/pkcs12",
  "p2p": "application/vnd.wfa.p2p",
  "p7a": "application/x-pkcs7-signature",
  "p7b": "application/x-pkcs7-certificates",
  "p7c": "application/pkcs7-mime",
  "p7m": "application/pkcs7-mime",
  "p7r": "application/x-pkcs7-certreqresp",
  "p7s": "application/pkcs7-signature",
  "p8": "application/pkcs8",
  "pac": "application/x-ns-proxy-autoconfig",
  "pack": "application/x-java-pack200",
  "package": "application/vnd.autopackage",
  "pages": "application/vnd.apple.pages",
  "par": "text/plain-bas",
  "part": "application/pro_eng",
  "pas": "text/pascal",
  "pat": "image/x-coreldrawpattern",
  "patch": "text/x-diff",
  "paw": "application/vnd.pawaafile",
  "pbd": "application/vnd.powerbuilder6",
  "pbm": "image/x-portable-bitmap",
  "pcap": "application/vnd.tcpdump.pcap",
  "pcf": "application/x-font-pcf",
  "pcl": "application/vnd.hp-pcl",
  "pclxl": "application/vnd.hp-pclxl",
  "pct": "image/x-pict",
  "pcurl": "application/vnd.curl.pcurl",
  "pcx": "image/x-pcx",
  "pdb": "application/vnd.palm",
  "pde": "text/x-processing",
  "pdf": "application/pdf",
  "pdx": "application/pdx",
  "pem": "text/pem",
  "pfa": "application/x-font-type1",
  "pfb": "application/x-font-type1",
  "pfm": "application/x-font-type1",
  "pfr": "application/font-tdpfr",
  "pfunk": "audio/make",
  "pfx": "application/pkcs12",
  "pgb": "image/vnd.globalgraphics.pgb",
  "pgm": "image/x-portable-graymap",
  "pgn": "application/x-chess-pgn",
  "pgp": "application/pgp-encrypted",
  "php": "application/x-httpd-php",
  "php3": "application/x-httpd-php3",
  "php3p": "application/x-httpd-php3-preprocessed",
  "php4": "application/x-httpd-php4",
  "php5": "application/x-httpd-php5",
  "phps": "application/x-httpd-php-source",
  "pht": "application/x-httpd-php",
  "phtml": "application/x-httpd-php",
  "pic": "image/pict",
  "pict": "image/pict",
  "pil": "application/vnd.piaccess.application-license",
  "pk": "application/x-tex-pk",
  "pkd": "application/vnd.hbci",
  "pkg": "application/vnd.apple.installer+xml",
  "pki": "application/pkixcmp",
  "pkipath": "application/pkix-pkipath",
  "pko": "application/ynd.ms-pkipko",
  "pkpass": "application/vnd.apple.pkpass",
  "pl": "application/x-perl",
  "plantuml": "text/plantuml",
  "plb": "application/vnd.3gpp.pic-bw-large",
  "plc": "application/vnd.mobius.plc",
  "plf": "application/vnd.pocketlearn",
  "plj": "audio/vnd.everad.plj",
  "plp": "application/vnd.panoply",
  "pls": "application/pls+xml",
  "plx": "application/x-pixclscript",
  "ply": "model/stanford",
  "pm": "text/plain",
  "pm4": "application/x-pagemaker",
  "pm5": "application/x-pagemaker",
  "pma": "application/x-perfmon",
  "pmc": "application/x-perfmon",
  "pml": "application/vnd.ctc-posml",
  "pmr": "application/x-perfmon",
  "pmw": "application/x-perfmon",
  "png": "image/png",
  "pnm": "image/x-portable-anymap",
  "po": "text/pofile",
  "pod": "text/x-pod",
  "portpkg": "application/vnd.macports.portpkg",
  "pot": "application/vnd.ms-powerpoint",
  "potm": "application/vnd.ms-powerpoint.template.macroenabled.12",
  "potx": "application/vnd.openxmlformats-officedocument.presentationml.template",
  "pov": "model/x-pov",
  "pp": "text/puppet",
  "ppa": "application/vnd.ms-powerpoint",
  "ppam": "application/vnd.ms-powerpoint.addin.macroenabled.12",
  "ppd": "application/vnd.cups-ppd",
  "ppkg": "application/vnd.xmpie.ppkg",
  "ppm": "image/x-portable-pixmap",
  "pps": "application/vnd.ms-powerpoint",
  "ppsm": "application/vnd.ms-powerpoint.slideshow.macroenabled.12",
  "ppsx": "application/vnd.openxmlformats-officedocument.presentationml.slideshow",
  "ppt": "application/vnd.ms-powerpoint",
  "pptm": "application/vnd.ms-powerpoint.presentation.macroenabled.12",
  "pptx": "application/vnd.openxmlformats-officedocument.presentationml.presentation",
  "ppz": "application/mspowerpoint",
  "pqa": "application/vnd.palm",
  "prc": "application/vnd.palm",
  "pre": "application/vnd.lotus-freelance",
  "preminet": "application/vnd.preminet",
  "prf": "application/pics-rules",
  "proto": "text/proto",
  "provn": "text/provenance-notation",
  "provx": "application/provenance+xml",
  "prt": "application/pro_eng",
  "prz": "application/vnd.lotus-freelance",
  "ps": "application/postscript",
  "psb": "application/vnd.3gpp.pic-bw-small",
  "psd": "image/vnd.adobe.photoshop",
  "pseg3820": "application/vnd.ibm.modcap",
  "psf": "application/x-font-linux-psf",
  "psid": "audio/prs.sid",
  "pskcxml": "application/pskc+xml",
  "pti": "image/prs.pti",
  "ptid": "application/vnd.pvi.ptid1",
  "pub": "application/x-mspublisher",
  "purs": "text/purescript",
  "pvb": "application/vnd.3gpp.pic-bw-var",
  "pvu": "paleovu/x-pv",
  "pwn": "application/vnd.3m.post-it-notes",
  "pwz": "application/vnd.ms-powerpoint",
  "pxd": "text/cython",
  "pxi": "text/cython",
  "py": "text/x-script.phyton",
  "pya": "audio/vnd.ms-playready.media.pya",
  "pyc": "application/x-python-code",
  "pyi": "text/pyi",
  "pyo": "application/x-python-code",
  "pyv": "video/vnd.ms-playready.media.pyv",
  "pyx": "text/cython",
  "qam": "application/vnd.epson.quickanime",
  "qbo": "application/vnd.intu.qbo",
  "qca": "application/vnd.ericsson.quickcall",
  "qcall": "application/vnd.ericsson.quickcall",
  "qcp": "audio/qcelp",
  "qd3": "x-world/x-3dmf",
  "qd3d": "x-world/x-3dmf",
  "qfx": "application/vnd.intu.qfx",
  "qgs": "application/x-qgis",
  "qif": "image/x-quicktime",
  "qps": "application/vnd.publishare-delta-tree",
  "qt": "video/quicktime",
  "qtc": "video/x-qtc",
  "qti": "image/x-quicktime",
  "qtif": "image/x-quicktime",
  "qtl": "application/x-quicktimeplayer",
  "quiz": "application/vnd.quobject-quoxdocument",
  "quox": "application/vnd.quobject-quoxdocument",
  "qvd": "application/vnd.theqvd",
  "qwd": "application/vnd.quark.quarkxpress",
  "qwt": "application/vnd.quark.quarkxpress",
  "qxb": "application/vnd.quark.quarkxpress",
  "qxd": "application/vnd.quark.quarkxpress",
  "qxl": "application/vnd.quark.quarkxpress",
  "qxt": "application/vnd.quark.quarkxpress",
  "r": "text/r",
  "ra": "audio/x-realaudio",
  "ram": "audio/x-pn-realaudio",
  "raml": "application/raml+yaml",
  "rapd": "application/route-apd+xml",
  "rar": "application/x-rar-compressed",
  "ras": "image/x-cmu-raster",
  "rast": "image/cmu-raster",
  "rb": "application/x-ruby",
  "rcprofile": "application/vnd.ipunplugged.rcprofile",
  "rct": "application/prs.nprend",
  "rd": "chemical/x-mdl-rdfile",
  "rda": "text/r",
  "rdata": "text/r",
  "rds": "text/r",
  "rdf": "application/rdf+xml",
  "rdf-crypt": "application/prs.rdf-xml-crypt",
  "rdz": "application/vnd.data-vision.rdz",
  "relo": "application/p2p-overlay+xml",
  "rep": "application/vnd.businessobjects",
  "request": "application/vnd.nervana",
  "res": "application/x-dtbresource+xml",
  "rexx": "text/x-script.rexx",
  "rf": "image/vnd.rn-realflash",
  "rfcxml": "application/rfc+xml",
  "rgb": "image/x-rgb",
  "rgbe": "image/vnd.radiance",
  "rhtml": "application/x-httpd-eruby",
  "rif": "application/reginfo+xml",
  "rip": "audio/vnd.rip",
  "ris": "application/x-research-info-systems",
  "rl": "application/resource-lists+xml",
  "rlc": "image/vnd.fujixerox.edmics-rlc",
  "rld": "application/resource-lists-diff+xml",
  "rlib": "text/rust",
  "rm": "application/vnd.rn-realmedia",
  "rmi": "audio/mid",
  "rmm": "audio/x-pn-realaudio",
  "rmp": "audio/x-pn-realaudio-plugin",
  "rms": "application/vnd.jcp.javame.midlet-rms",
  "rmvb": "application/vnd.rn-realmedia-vbr",
  "rnc": "application/relax-ng-compact-syntax",
  "rnd": "application/prs.nprend",
  "rng": "text/xml",
  "rnx": "application/vnd.rn-realplayer",
  "roa": "application/rpki-roa",
  "roff": "text/troff",
  "ros": "chemical/x-rosdal",
  "rp": "image/vnd.rn-realpix",
  "rp9": "application/vnd.cloanto.rp9",
  "rpm": "application/x-redhat-package-manager",
  "rpss": "application/vnd.nokia.radio-presets",
  "rpst": "application/vnd.nokia.radio-preset",
  "rq": "application/sparql-query",
  "rs": "application/rls-services+xml",
  "rsd": "application/rsd+xml",
  "rsheet": "application/urc-ressheet+xml",
  "rsm": "model/vnd.gdl",
  "rss": "application/rss+xml",
  "rst": "text/prs.fallenstein.rst",
  "rt": "text/richtext",
  "rtf": "text/rtf",
  "rtx": "text/richtext",
  "run": "application/x-makeself",
  "rusd": "application/route-usd+xml",
  "rv": "video/vnd.rn-realvideo",
  "rxn": "chemical/x-mdl-rxnfile",
  "s": "text/x-asm",
  "s11": "video/vnd.sealed.mpeg1",
  "s14": "video/vnd.sealed.mpeg4",
  "s1a": "application/vnd.sealedmedia.softseal.pdf",
  "s1e": "application/vnd.sealed.xls",
  "s1g": "image/vnd.sealedmedia.softseal.gif",
  "s1h": "application/vnd.sealedmedia.softseal.html",
  "s1j": "image/vnd.sealedmedia.softseal.jpg",
  "s1m": "audio/vnd.sealedmedia.softseal.mpeg",
  "s1n": "image/vnd.sealed.png",
  "s1p": "application/vnd.sealed.ppt",
  "s1q": "video/vnd.sealedmedia.softseal.mov",
  "s1w": "application/vnd.sealed.doc",
  "s3df": "application/vnd.sealed.3df",
  "s3m": "audio/s3m",
  "sac": "application/tamp-sequence-adjust-confirm",
  "saf": "application/vnd.yamaha.smaf-audio",
  "sam": "application/vnd.lotus-wordpro",
  "sandboxed": "text/html-sandboxed",
  "sass": "text/x-sass",
  "saveme": "application/octet-stream",
  "sbk": "application/x-tbook",
  "sbml": "application/sbml+xml",
  "sc": "application/vnd.ibm.secure-container",
  "scala": "text/x-scala",
  "scd": "application/x-msschedule",
  "sce": "application/vnd.etsi.asic-e+zip",
  "scim": "application/scim+json",
  "scld": "application/vnd.doremir.scorecloud-binary-document",
  "scm": "application/vnd.lotus-screencam",
  "scq": "application/scvp-cv-request",
  "scr": "application/x-silverlight",
  "scs": "application/scvp-cv-response",
  "scsf": "application/vnd.sealed.csf",
  "scss": "text/x-scss",
  "sct": "text/scriptlet",
  "scurl": "text/vnd.curl.scurl",
  "sd": "chemical/x-mdl-sdfile",
  "sd2": "audio/x-sd2",
  "sda": "application/vnd.stardivision.draw",
  "sdc": "application/vnd.stardivision.calc",
  "sdd": "application/vnd.stardivision.impress",
  "sdf": "application/vnd.kinar",
  "sdkd": "application/vnd.solent.sdkm+xml",
  "sdkm": "application/vnd.solent.sdkm+xml",
  "sdml": "text/plain",
  "sdo": "application/vnd.sealed.doc",
  "sdoc": "application/vnd.sealed.doc",
  "sdp": "application/sdp",
  "sdr": "application/sounder",
  "sdw": "application/vnd.stardivision.writer",
  "sea": "application/x-sea",
  "see": "application/vnd.seemail",
  "seed": "application/vnd.fdsn.seed",
  "sem": "application/vnd.sealed.eml",
  "sema": "application/vnd.sema",
  "semd": "application/vnd.semd",
  "semf": "application/vnd.semf",
  "seml": "application/vnd.sealed.eml",
  "ser": "application/java-serialized-object",
  "set": "application/set",
  "setpay": "application/set-payment-initiation",
  "setreg": "application/set-registration-initiation",
  "sfc": "application/vnd.nintendo.snes.rom",
  "sfd": "application/vnd.font-fontforge-sfd",
  "sfd-hdstx": "application/vnd.hydrostatix.sof-data",
  "sfs": "application/vnd.spotfire.sfs",
  "sfv": "text/x-sfv",
  "sgf": "application/x-go-sgf",
  "sgi": "image/sgi",
  "sgif": "image/vnd.sealedmedia.softseal.gif",
  "sgl": "application/vnd.stardivision.writer-global",
  "sgm": "text/sgml",
  "sgml": "text/sgml",
  "sh": "application/x-sh",
  "shar": "application/x-shar",
  "shex": "text/shex",
  "shf": "application/shf+xml",
  "shp": "application/x-qgis",
  "shx": "application/x-qgis",
  "si": "text/vnd.wap.si",
  "sic": "application/vnd.wap.sic",
  "sid": "image/x-mrsid-image",
  "sieve": "application/sieve",
  "sig": "application/pgp-signature",
  "sik": "application/x-trash",
  "sil": "audio/silk",
  "silo": "model/mesh",
  "sis": "application/vnd.symbian.install",
  "sisx": "x-epoc/x-sisx-app",
  "sit": "application/x-stuffit",
  "sitx": "application/x-stuffitx",
  "siv": "application/sieve",
  "sjp": "image/vnd.sealedmedia.softseal.jpg",
  "sjpg": "image/vnd.sealedmedia.softseal.jpg",
  "skd": "application/vnd.koan",
  "skm": "application/vnd.koan",
  "skp": "application/vnd.koan",
  "skt": "application/vnd.koan",
  "sl": "text/vnd.wap.sl",
  "sla": "application/vnd.scribus",
  "slaz": "application/vnd.scribus",
  "slc": "application/vnd.wap.slc",
  "sldm": "application/vnd.ms-powerpoint.slide.macroenabled.12",
  "sldx": "application/vnd.openxmlformats-officedocument.presentationml.slide",
  "sls": "application/route-s-tsid+xml",
  "slt": "application/vnd.epson.salt",
  "sm": "application/vnd.stepmania.stepchart",
  "smc": "application/vnd.nintendo.snes.rom",
  "smf": "application/vnd.stardivision.math",
  "smh": "application/vnd.sealed.mht",
  "smht": "application/vnd.sealed.mht",
  "smi": "application/smil+xml",
  "smil": "application/smil+xml",
  "smk": "video/vnd.radgamettools.smacker",
  "sml": "application/smil+xml",
  "smo": "video/vnd.sealedmedia.softseal.mov",
  "smov": "video/vnd.sealedmedia.softseal.mov",
  "smp": "audio/vnd.sealedmedia.softseal.mpeg",
  "smp3": "audio/vnd.sealedmedia.softseal.mpeg",
  "smpg": "video/vnd.sealed.mpeg1",
  "sms": "application/vnd.3gpp2.sms",
  "smv": "video/x-smv",
  "smzip": "application/vnd.stepmania.package",
  "snd": "audio/basic",
  "snf": "application/x-font-snf",
  "so": "application/octet-stream",
  "soa": "text/dns",
  "soc": "application/sgml-open-catalog",
  "sol": "application/solids",
  "spc": "text/x-speech",
  "spd": "application/vnd.sealedmedia.softseal.pdf",
  "spdf": "application/vnd.sealedmedia.softseal.pdf",
  "spec": "text/spec",
  "spf": "application/vnd.yamaha.smaf-phrase",
  "spl": "application/x-futuresplash",
  "spn": "image/vnd.sealed.png",
  "spng": "image/vnd.sealed.png",
  "spo": "text/vnd.in3d.spot",
  "spot": "text/vnd.in3d.spot",
  "spp": "application/scvp-vp-response",
  "sppt": "application/vnd.sealed.ppt",
  "spq": "application/scvp-vp-request",
  "spr": "application/x-sprite",
  "sprite": "application/x-sprite",
  "spx": "audio/ogg",
  "sql": "application/x-sql",
  "sr": "application/vnd.sigrok.session",
  "src": "application/x-wais-source",
  "srt": "application/x-subrip",
  "sru": "application/sru+xml",
  "srx": "application/sparql-results+xml",
  "ssdl": "application/ssdl+xml",
  "sse": "application/vnd.kodak-descriptor",
  "ssf": "application/vnd.epson.ssf",
  "ssi": "text/x-server-parsed-html",
  "ssm": "application/streamingmedia",
  "ssml": "application/ssml+xml",
  "sst": "application/vnd.ms-pki.certstore",
  "ssw": "video/vnd.sealed.swf",
  "sswf": "video/vnd.sealed.swf",
  "st": "application/vnd.sailingtracker.track",
  "stc": "application/vnd.sun.xml.calc.template",
  "std": "application/vnd.sun.xml.draw.template",
  "step": "application/step",
  "stf": "application/vnd.wt.stf",
  "sti": "application/vnd.sun.xml.impress.template",
  "stif": "application/vnd.sealed.tiff",
  "stk": "application/hyperstudio",
  "stl": "application/vnd.ms-pki.stl",
  "stm": "audio/x-stm",
  "stml": "application/vnd.sealedmedia.softseal.html",
  "stp": "application/step",
  "str": "application/vnd.pg.format",
  "study-inter": "application/vnd.vd-study",
  "stw": "application/vnd.sun.xml.writer.template",
  "sty": "text/x-tex",
  "styl": "text/stylus",
  "sub": "text/vnd.dvb.subtitle",
  "sus": "application/vnd.sus-calendar",
  "susp": "application/vnd.sus-calendar",
  "sv4cpio": "application/x-sv4cpio",
  "sv4crc": "application/x-sv4crc",
  "svc": "application/vnd.dvb.service",
  "svd": "application/vnd.svd",
  "svf": "image/x-dwg",
  "svg": "image/svg+xml",
  "svgz": "image/svg+xml",
  "sw": "chemical/x-swissprot",
  "swa": "application/x-director",
  "swf": "application/x-shockwave-flash",
  "swfl": "application/x-shockwave-flash",
  "swi": "application/vnd.aristanetworks.swi",
  "swift": "text/swift",
  "swiftdeps": "text/swiftdeps",
  "sxc": "application/vnd.sun.xml.calc",
  "sxd": "application/vnd.sun.xml.draw",
  "sxg": "application/vnd.sun.xml.writer.global",
  "sxi": "application/vnd.sun.xml.impress",
  "sxl": "application/vnd.sealed.xls",
  "sxls": "application/vnd.sealed.xls",
  "sxm": "application/vnd.sun.xml.math",
  "sxw": "application/vnd.sun.xml.writer",
  "t": "text/troff",
  "t3": "application/x-t3vm-image",
  "t38": "image/t38",
  "tac": "text/twisted",
  "tag": "text/prs.lines.tag",
  "taglet": "application/vnd.mynfc",
  "talk": "text/x-speech",
  "tam": "application/vnd.onepager",
  "tamp": "application/vnd.onepagertamp",
  "tamx": "application/vnd.onepagertamx",
  "tao": "application/vnd.tao.intent-module-archive",
  "tap": "image/vnd.tencent.tap",
  "tar": "application/x-tar",
  "tat": "application/vnd.onepagertat",
  "tatp": "application/vnd.onepagertatp",
  "tatx": "application/vnd.onepagertatx",
  "tau": "application/tamp-apex-update",
  "taz": "application/x-gtar",
  "tbk": "application/toolbook",
  "tcap": "application/vnd.3gpp2.tcap",
  "tcl": "application/x-tcl",
  "tcsh": "text/x-script.tcsh",
  "tcu": "application/tamp-community-update",
  "td": "application/urc-targetdesc+xml",
  "teacher": "application/vnd.smart.teacher",
  "tei": "application/tei+xml",
  "teicorpus": "application/tei+xml",
  "ter": "application/tamp-error",
  "tex": "application/x-tex",
  "texi": "application/x-texinfo",
  "texinfo": "application/x-texinfo",
  "text": "text/plain",
  "tf": "text/terraform",
  "tfi": "application/thraud+xml",
  "tfm": "application/x-tex-tfm",
  "tfx": "image/tiff-fx",
  "tga": "image/x-tga",
  "tgf": "chemical/x-mdl-tgf",
  "tgz": "application/gzip",
  "thmx": "application/vnd.ms-officetheme",
  "thrift": "text/thrift",
  "tif": "image/tiff",
  "tiff": "image/tiff",
  "tk": "text/x-tcl",
  "tlclient": "application/vnd.cendio.thinlinc.clientconf",
  "tm": "text/texmacs",
  "tmo": "application/vnd.tmobile-livetv",
  "tnef": "application/vnd.ms-tnef",
  "tnf": "application/vnd.ms-tnef",
  "toml": "text/toml",
  "torrent": "application/x-bittorrent",
  "tpl": "application/vnd.groove-tool-template",
  "tpt": "application/vnd.trid.tpt",
  "tr": "text/troff",
  "tra": "application/vnd.trueapp",
  "tree": "application/vnd.rainstor.data",
  "trig": "application/trig",
  "trm": "application/x-msterminal",
  "ts": "video/mp2t",
  "tsa": "application/tamp-sequence-adjust",
  "tscn": "text/godot",
  "tsd": "application/timestamped-data",
  "tsi": "audio/tsp-audio",
  "tsp": "audio/tsplayer",
  "tsq": "application/timestamp-query",
  "tsr": "application/timestamp-reply",
  "tst": "application/vnd.etsi.timestamp-token",
  "tsv": "text/tab-separated-values",
  "tsx": "text/tsx",
  "ttc": "font/collection",
  "ttf": "font/ttf",
  "ttl": "text/turtle",
  "ttml": "application/ttml+xml",
  "tuc": "application/tamp-update-confirm",
  "tur": "application/tamp-update",
  "turbot": "image/florian",
  "twd": "application/vnd.simtech-mindmapper",
  "twds": "application/vnd.simtech-mindmapper",
  "txd": "application/vnd.genomatix.tuxedo",
  "txf": "application/vnd.mobius.txf",
  "txt": "text/plain",
  "u32": "application/x-authorware-bin",
  "u8dsn": "message/global-delivery-status",
  "u8hdr": "message/global-headers",
  "u8mdn": "message/global-disposition-notification",
  "u8msg": "message/global",
  "udeb": "application/vnd.debian.binary-package",
  "ufd": "application/vnd.ufdl",
  "ufdl": "application/vnd.ufdl",
  "uil": "text/x-uil",
  "uis": "application/urc-uisocketdesc+xml",
  "uls": "text/iuls",
  "ult": "audio/x-mod",
  "ulx": "application/x-glulx",
  "umj": "application/vnd.umajin",
  "uni": "audio/x-mod",
  "unis": "text/uri-list",
  "unityweb": "application/vnd.unity",
  "unv": "application/i-deas",
  "uo": "application/vnd.uoml+xml",
  "uoml": "application/vnd.uoml+xml",
  "upa": "application/vnd.hbci",
  "uri": "text/uri-list",
  "uric": "text/vnd.si.uricatalogue",
  "urim": "application/vnd.uri-map",
  "urimap": "application/vnd.uri-map",
  "uris": "text/uri-list",
  "urls": "text/uri-list",
  "ustar": "application/x-ustar",
  "utz": "application/vnd.uiq.theme",
  "uu": "text/x-uuencode",
  "uue": "text/x-uuencode",
  "uva": "audio/vnd.dece.audio",
  "uvd": "application/vnd.dece.data",
  "uvf": "application/vnd.dece.data",
  "uvg": "image/vnd.dece.graphic",
  "uvh": "video/vnd.dece.hd",
  "uvi": "image/vnd.dece.graphic",
  "uvm": "video/vnd.dece.mobile",
  "uvp": "video/vnd.dece.pd",
  "uvs": "video/vnd.dece.sd",
  "uvt": "application/vnd.dece.ttml+xml",
  "uvu": "video/vnd.dece.mp4",
  "uvv": "video/vnd.dece.video",
  "uvva": "audio/vnd.dece.audio",
  "uvvd": "application/vnd.dece.data",
  "uvvf": "application/vnd.dece.data",
  "uvvg": "image/vnd.dece.graphic",
  "uvvh": "video/vnd.dece.hd",
  "uvvi": "image/vnd.dece.graphic",
  "uvvm": "video/vnd.dece.mobile",
  "uvvp": "video/vnd.dece.pd",
  "uvvs": "video/vnd.dece.sd",
  "uvvt": "application/vnd.dece.ttml+xml",
  "uvvu": "video/vnd.dece.mp4",
  "uvvv": "video/vnd.dece.video",
  "uvvx": "application/vnd.dece.unspecified",
  "uvvz": "application/vnd.dece.zip",
  "uvx": "application/vnd.dece.unspecified",
  "uvz": "application/vnd.dece.zip",
  "val": "chemical/x-ncbi-asn1-binary",
  "vbk": "audio/vnd.nortel.vbk",
  "vbox": "application/x-virtualbox-vbox",
  "vbox-extpack": "application/x-virtualbox-vbox-extpack",
  "vcard": "text/vcard",
  "vcd": "application/x-cdlink",
  "vcf": "text/x-vcard",
  "vcg": "application/vnd.groove-vcard",
  "vcs": "text/x-vcalendar",
  "vcx": "application/vnd.vcx",
  "vda": "application/vda",
  "vdi": "application/x-virtualbox-vdi",
  "vdo": "video/vdo",
  "vdx": "text/vdx",
  "vew": "application/vnd.lotus-approach",
  "vfr": "application/vnd.tml",
  "vhd": "application/x-virtualbox-vhd",
  "viaframe": "application/vnd.tml",
  "vim": "text/vim",
  "vis": "application/vnd.visionary",
  "viv": "video/vnd.vivo",
  "vivo": "video/vivo",
  "vmd": "application/vocaltec-media-desc",
  "vmdk": "application/x-virtualbox-vmdk",
  "vmf": "application/vocaltec-media-file",
  "vms": "chemical/x-vamas-iso14976",
  "vmt": "application/vnd.valve.source.material",
  "vob": "video/x-ms-vob",
  "voc": "audio/voc",
  "vor": "application/vnd.stardivision.writer",
  "vos": "video/vosaic",
  "vox": "audio/voxware",
  "vpm": "multipart/voice-message",
  "vqe": "audio/x-twinvq-plugin",
  "vqf": "audio/x-twinvq",
  "vql": "audio/x-twinvq-plugin",
  "vrm": "x-world/x-vrml",
  "vrml": "model/vrml",
  "vrt": "x-world/x-vrt",
  "vsc": "application/vnd.vidsoft.vidconference",
  "vsd": "application/vnd.visio",
  "vsf": "application/vnd.vsf",
  "vss": "application/vnd.visio",
  "vst": "application/vnd.visio",
  "vsw": "application/vnd.visio",
  "vtf": "image/vnd.valve.source.texture",
  "vtt": "text/vtt",
  "vtu": "model/vnd.vtu",
  "vue": "text/vue",
  "vwx": "application/vnd.vectorworks",
  "vxml": "application/voicexml+xml",
  "w3d": "application/x-director",
  "w60": "application/wordperfect6.0",
  "w61": "application/wordperfect6.1",
  "w6w": "application/msword",
  "wad": "application/x-doom",
  "wadl": "application/vnd.sun.wadl+xml",
  "war": "binary/zip",
  "wasm": "application/wasm",
  "wav": "audio/wave",
  "wax": "audio/x-ms-wax",
  "wb1": "application/x-qpro",
  "wbmp": "image/vnd.wap.wbmp",
  "wbs": "application/vnd.criticaltools.wbs+xml",
  "wbxml": "application/vnd.wap.wbxml",
  "wcm": "application/vnd.ms-works",
  "wdb": "application/vnd.ms-works",
  "wdp": "image/vnd.ms-photo",
  "web": "application/vnd.xara",
  "weba": "audio/webm",
  "webapp": "application/x-web-app-manifest+json",
  "webm": "video/webm",
  "webmanifest": "application/manifest+json",
  "webp": "image/webp",
  "wg": "application/vnd.pmi.widget",
  "wgt": "application/widget",
  "whl": "binary/wheel",
  "wif": "application/watcherinfo+xml",
  "win": "model/vnd.gdl",
  "wiz": "application/msword",
  "wk": "application/x-123",
  "wk1": "application/vnd.lotus-1-2-3",
  "wk3": "application/vnd.lotus-1-2-3",
  "wk4": "application/vnd.lotus-1-2-3",
  "wks": "application/vnd.ms-works",
  "wkt": "text/wkt",
  "wlnk": "application/link-format",
  "wm": "video/x-ms-wm",
  "wma": "audio/x-ms-wma",
  "wmc": "application/vnd.wmc",
  "wmd": "application/x-ms-wmd",
  "wmf": "image/wmf",
  "wml": "text/vnd.wap.wml",
  "wmlc": "application/vnd.wap.wmlc",
  "wmls": "text/vnd.wap.wmlscript",
  "wmlsc": "application/vnd.wap.wmlscriptc",
  "wmv": "video/x-ms-wmv",
  "wmx": "video/x-ms-wmx",
  "wmz": "application/x-ms-wmz",
  "woff": "font/woff",
  "woff2": "font/woff2",
  "word": "application/msword",
  "wp": "application/wordperfect",
  "wp5": "application/wordperfect",
  "wp6": "application/wordperfect",
  "wpd": "application/vnd.wordperfect",
  "wpl": "application/vnd.ms-wpl",
  "wps": "application/vnd.ms-works",
  "wq1": "application/x-lotus",
  "wqd": "application/vnd.wqd",
  "wri": "application/x-mswrite",
  "wrl": "model/vrml",
  "wrz": "model/vrml",
  "wsc": "message/vnd.wfa.wsc",
  "wsdl": "application/wsdl+xml",
  "wsgi": "text/wsgi",
  "wspolicy": "application/wspolicy+xml",
  "wsrc": "application/x-wais-source",
  "wtb": "application/vnd.webturbo",
  "wtk": "application/x-wintalk",
  "wv": "application/vnd.wv.csp+wbxml",
  "wvx": "video/x-ms-wvx",
  "wz": "application/x-wingz",
  "x-png": "image/png",
  "x32": "application/x-authorware-bin",
  "x3d": "application/vnd.hzn-3d-crossword",
  "x3db": "model/x3d+xml",
  "x3dbz": "model/x3d+binary",
  "x3dv": "model/x3d-vrml",
  "x3dvz": "model/x3d-vrml",
  "x3dz": "model/x3d+xml",
  "x_b": "model/vnd.parasolid.transmit.binary",
  "x_t": "model/vnd.parasolid.transmit.text",
  "xaf": "x-world/x-vrml",
  "xaml": "application/xaml+xml",
  "xap": "application/x-silverlight-app",
  "xar": "application/vnd.xara",
  "xav": "application/xcap-att+xml",
  "xbap": "application/x-ms-xbap",
  "xbd": "application/vnd.fujixerox.docuworks.binder",
  "xbm": "image/x-xbitmap",
  "xca": "application/xcap-caps+xml",
  "xcf": "application/x-xcf",
  "xcs": "application/calendar+xml",
  "xct": "application/vnd.fujixerox.docuworks.container",
  "xdd": "application/bacnet-xdd+zip",
  "xdf": "application/xcap-diff+xml",
  "xdm": "application/vnd.syncml.dm+xml",
  "xdp": "application/vnd.adobe.xdp+xml",
  "xdr": "video/x-amt-demorun",
  "xdssc": "application/dssc+xml",
  "xdw": "application/vnd.fujixerox.docuworks",
  "xel": "application/xcap-el+xml",
  "xenc": "application/xenc+xml",
  "xer": "application/patch-ops-error+xml",
  "xfd": "application/vnd.xfdl",
  "xfdf": "application/vnd.adobe.xfdf",
  "xfdl": "application/vnd.xfdl",
  "xgz": "xgl/drawing",
  "xht": "application/xhtml+xml",
  "xhtm": "application/xhtml+xml",
  "xhtml": "application/xhtml+xml",
  "xhvml": "application/xv+xml",
  "xif": "image/vnd.xiff",
  "xl": "application/excel",
  "xla": "application/vnd.ms-excel",
  "xlam": "application/vnd.ms-excel.addin.macroenabled.12",
  "xlb": "application/vndms-excel",
  "xlc": "application/vnd.ms-excel",
  "xlf": "application/x-xliff+xml",
  "xlim": "application/vnd.xmpie.xlim",
  "xlm": "application/vnd.ms-excel",
  "xls": "application/vnd.ms-excel",
  "xlsb": "application/vnd.ms-excel.sheet.binary.macroenabled.12",
  "xlsm": "application/vnd.ms-excel.sheet.macroenabled.12",
  "xlsx": "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
  "xlt": "application/vnd.ms-excel",
  "xltm": "application/vnd.ms-excel.template.macroenabled.12",
  "xltx": "application/vnd.openxmlformats-officedocument.spreadsheetml.template",
  "xlw": "application/vnd.ms-excel",
  "xm": "audio/xm",
  "xml": "text/xml",
  "xmls": "application/dskpp+xml",
  "xmt_bin": "model/vnd.parasolid.transmit.binary",
  "xmt_txt": "model/vnd.parasolid.transmit.text",
  "xmz": "xgl/movie",
  "xns": "application/xcap-ns+xml",
  "xo": "application/vnd.olpc-sugar",
  "xof": "x-world/x-vrml",
  "xop": "application/xop+xml",
  "xpdl": "application/xml",
  "xpi": "application/x-xpinstall",
  "xpix": "application/x-vnd.ls-xpix",
  "xpl": "application/xproc+xml",
  "xpm": "image/x-xpixmap",
  "xpr": "application/vnd.is-xpr",
  "xps": "application/vnd.ms-xpsdocument",
  "xpw": "application/vnd.intercon.formnet",
  "xpx": "application/vnd.intercon.formnet",
  "xq": "text/xquery",
  "xql": "text/xquery",
  "xqm": "text/xquery",
  "xqu": "text/xquery",
  "xquery": "text/xquery",
  "xqy": "text/xquery",
  "xsd": "text/xml",
  "xsf": "application/prs.xsf+xml",
  "xsl": "application/xslt+xml",
  "xslt": "application/xslt+xml",
  "xsm": "application/vnd.syncml+xml",
  "xspf": "application/xspf+xml",
  "xsr": "video/x-amt-showrun",
  "xtel": "chemical/x-xtel",
  "xul": "application/vnd.mozilla.xul+xml",
  "xvm": "application/xv+xml",
  "xvml": "application/xv+xml",
  "xwd": "image/x-xwindowdump",
  "xyz": "chemical/x-xyz",
  "xyze": "image/vnd.radiance",
  "xz": "application/x-xz",
  "yaml": "text/yaml",
  "yang": "application/yang",
  "yin": "application/yin+xml",
  "yme": "application/vnd.yaoweme",
  "yml": "text/yaml",
  "ymp": "text/x-suse-ymp",
  "z1": "application/x-zmachine",
  "z2": "application/x-zmachine",
  "z3": "application/x-zmachine",
  "z4": "application/x-zmachine",
  "z5": "application/x-zmachine",
  "z6": "application/x-zmachine",
  "z7": "application/x-zmachine",
  "z8": "application/x-zmachine",
  "zaz": "application/vnd.zzazz.deck+xml",
  "zfc": "application/vnd.filmit.zfc",
  "zfo": "application/vnd.software602.filler.form-xml-zip",
  "zig": "text/zig",
  "zip": "application/zip",
  "zir": "application/vnd.zul",
  "zirz": "application/vnd.zul",
  "zmm": "application/vnd.handheld-entertainment+xml",
  "zmt": "chemical/x-mopac-input",
  "zone": "text/dns",
  "zoo": "application/octet-stream",
  "zsh": "text/x-script.zsh",
  "~": "application/x-trash"
}


func newMimetypes*(): MimeDB =
  ## Creates a new Mimetypes database. The database will contain the most
  ## common mimetypes.
  result.mimes = mimes.newStringTable()

func getMimetype*(mimedb: MimeDB, ext: string, default = "text/plain"): string =
  ## Gets mimetype which corresponds to ``ext``. Returns ``default`` if ``ext``
  ## could not be found. ``ext`` can start with an optional dot which is ignored.
  ## ``ext`` is lowercased before querying ``mimedb``.
  if ext.startsWith("."):
    result = mimedb.mimes.getOrDefault(ext.toLowerAscii.substr(1))
  else:
    result = mimedb.mimes.getOrDefault(ext.toLowerAscii())
  if result == "":
    return default

func getExt*(mimedb: MimeDB, mimetype: string, default = "txt"): string =
  ## Gets extension which corresponds to ``mimetype``. Returns ``default`` if
  ## ``mimetype`` could not be found. Extensions are returned without the
  ## leading dot. ``mimetype`` is lowercased before querying ``mimedb``.
  result = default
  let mimeLowered = mimetype.toLowerAscii()
  for e, m in mimedb.mimes:
    if m == mimeLowered:
      result = e
      break

func register*(mimedb: var MimeDB, ext: string, mimetype: string) =
  ## Adds ``mimetype`` to the ``mimedb``.
  ## ``mimetype`` and ``ext`` are lowercased before registering on ``mimedb``.
  assert ext.strip.len > 0, "ext argument can not be empty string"
  assert mimetype.strip.len > 0, "mimetype argument can not be empty string"
  mimedb.mimes[ext.toLowerAscii()] = mimetype.toLowerAscii()

runnableExamples:
  var m = newMimetypes()
  assert m.getMimetype("mp4") == "video/mp4"
  assert m.getExt("text/html") == "html"
  ## Values can be uppercase too.
  assert m.getMimetype("MP4") == "video/mp4"
  assert m.getExt("TEXT/HTML") == "html"
  ## If values are invalid then ``default`` is returned.
  assert m.getMimetype("INVALID") == "text/plain"
  assert m.getExt("INVALID/NONEXISTENT") == "txt"
  assert m.getMimetype("") == "text/plain"
  assert m.getExt("") == "txt"
  ## Register new Mimetypes.
  m.register(ext = "fakext", mimetype = "text/fakelang")
  assert m.getMimetype("fakext") == "text/fakelang"
  assert m.getMimetype("FaKeXT") == "text/fakelang"
