if (typeof T === 'undefined') require('../setup');

T('asin', function () {

  function t(n, pr, rm, expected) {
    Decimal.precision = pr;
    Decimal.rounding = rm;
    T.assertEqual(expected, new Decimal(n).asin().valueOf());
  }

  Decimal.config({
    precision: 40,
    rounding: 4,
    toExpNeg: -9e15,
    toExpPos: 9e15,
    minE: -9e15,
    maxE: 9e15
  });

  t('NaN', 40, 4, 'NaN');
  t('1.0000000000000001', 40, 4, 'NaN');
  t('2', 40, 4, 'NaN');
  t('Infinity', 40, 4, 'NaN');
  t('-1.00000000000000000001', 40, 4, 'NaN');
  t('-Infinity', 40, 4, 'NaN');
  t('0', 40, 4, '0');
  t('-0', 40, 4, '-0');

  t('0.365496185994558260858326718937', 10, 5, '0.3741658147');
  t('-0.35641389188', 3, 0, '-0.365');
  t('0.68955841424562468594284036990178287693727890663761450264565153347585586987783918662506831', 7, 6, '0.7608791');
  t('-0.8185571137226394757008542835605396', 1, 1, '-0.9');
  t('0.3909767220307331413111', 5, 3, '0.40169');
  t('0.4973777625990946249943842344354278064648780030532232700989739966171872596183742540844', 7, 0, '0.5205736');
  t('-0.3220586075', 7, 1, '-0.3279031');
  t('-0.4712856183846410563097510893908', 6, 5, '-0.490748');
  t('0.05838677605449046055272817746189607969418472098217185904914', 2, 6, '0.058');
  t('0.8', 9, 5, '0.927295218');
  t('-0.35', 4, 5, '-0.3576');
  t('0.5', 10, 1, '0.5235987755');
  t('0.12', 3, 1, '0.12');
  t('-0.5434', 8, 3, '-0.57448199');
  t('0.0073911', 6, 1, '0.00739116');
  t('0.6413', 9, 5, '0.696191343');
  t('0.6695', 7, 5, '0.7335355');
  t('-0.73867', 9, 0, '-0.831095123');
  t('-0.734541962948526931', 1, 1, '-0.8');
  t('0.8124222852789144395978469359524044494', 9, 5, '0.94829454');
  t('0.01', 6, 1, '0.0100001');
  t('-0.788421', 4, 1, '-0.9082');
  t('-0.3', 2, 2, '-0.3');
  t('0.6608633389456637408497420998651914114139088612446', 2, 4, '0.72');
  t('0.3931549079701655746240375417718660050381124496506720523996527133505517587998', 23, 1, '0.40406030213304057779811');
  t('-0.587605525487010465245800314956501132921', 13, 3, '-0.6280963940928');
  t('-0.5', 52, 3, '-0.5235987755982988730771072305465838140328615665625177');
  t('0.7772699', 16, 4, '0.8903148827665578');
  t('-0.449412073227066332425902525593181', 57, 6, '-0.466107096571843683526424227582248251927561787620454186534');
  t('-0.88842', 56, 4, '-1.0938915908813483958517153077667620622507918440274546335');
  t('-0.5088737561', 24, 3, '-0.533875977309913500769379');
  t('-0.0765762285855571311226935212468317451162677', 61, 0, '-0.07665126622547200709328366279959297473262965998499827526363485');
  t('0.002058774932399380728', 73, 3, '0.002058776386773685135920502914113033566749664057124819063683489089253866675');
  t('0.6191705648197127900333', 20, 3, '0.6676860026273445248');
  t('0.0451', 71, 3, '0.045115302986200826677187000097752946920986469377743210302486079583770366');
  t('0.156883637', 65, 6, '0.15753442001936249496738123179710495311489551498086102245485050903');
  t('0.163388332624365770456915424679194860444773341061114349237610212142206187981629282902', 67, 0, '0.1641241692993679299065215302292638564718643006858786702204768697199');
  t('-0.1958', 17, 5, '-0.19707317438982823');
  t('0.873332', 19, 5, '1.062001065132184521');
  t('-0.8517325896144402', 29, 0, '-1.0192830764340094095462711303');
  t('-0.5110799', 65, 2, '-0.53644070128325494453237503822033662227949443391067147724566337039');
  t('-0.579334355419195148', 31, 3, '-0.617911801796609232511609252874');

  /*
  t('0.63', 1, 5, '0.7');
  t('-0.42', 4, 0, '-0.4335');
  t('-0.3', 3, 0, '-0.305');
  t('-0.23222', 1, 1, '-0.2');
  t('-0.4', 10, 0, '-0.4115168461');
  t('-0.61748379107894', 5, 6, '-0.66554');
  t('0.455009815', 10, 6, '0.4723832362');
  t('0.956', 6, 2, '1.27305');
  t('-0.1775248228585516175158636575038799642565970877089107679', 1, 3, '-0.2');
  t('0.181008275840890023616378785649', 2, 0, '0.19');
  t('0.891', 3, 1, '1.09');
  t('0.1', 5, 5, '0.10017');
  t('-0.686263763995363', 9, 3, '-0.756339763');
  t('0.69724683014091', 8, 1, '0.77154953');
  t('0.651298905027729019177629429885652807833687105873545221358407146248004527', 3, 1, '0.709');
  t('0.75077', 2, 6, '0.85');
  t('0.16653', 7, 1, '0.1673094');
  t('-0.749575', 7, 4, '-0.8474198');
  t('0.3217488475048627713427457352649954429927', 6, 0, '0.327576');
  t('-0.80544', 6, 3, '-0.936418');
  t('-0.37', 2, 3, '-0.38');
  t('0.5248697728', 10, 3, '0.5525621102');
  t('-0.4', 2, 4, '-0.41');
  t('0.9', 5, 0, '1.1198');
  t('0.038634', 1, 0, '0.04');
  t('0.3', 5, 2, '0.3047');
  t('0.6', 11, 5, '0.64350110879');
  t('0.010641', 12, 0, '0.0106412008253');
  t('-0.552842', 2, 3, '-0.59');
  t('-0.18', 2, 3, '-0.19');
  t('-0.36199', 5, 2, '-0.3704');
  t('0.49081206694359', 7, 1, '0.5130215');
  t('0.4399', 1, 2, '0.5');
  t('0.198085495342229388259', 9, 6, '0.199404326');
  t('-0.522549958932947079997634280434708780792733797601311537182351565434743', 2, 2, '-0.54');
  t('0.01833', 7, 4, '0.01833103');
  t('-0.268', 8, 6, '-0.27131649');
  t('-0.239202451910289658387', 8, 0, '-0.24154438');
  t('0.4591', 3, 6, '0.477');
  t('0.78802262831967252920540970413', 2, 4, '0.91');
  t('0.9', 3, 4, '1.12');
  t('-0.88', 5, 5, '-1.0759');
  t('-0.5723', 6, 4, '-0.609308');
  t('0.7', 6, 1, '0.775397');
  t('-0.7', 6, 0, '-0.775398');
  t('-0.4522054', 8, 3, '-0.46923646');
  t('-0.113', 5, 0, '-0.11325');
  t('-0.59544836036780438444908059215410019637924557624130794309', 8, 0, '-0.63782362');
  t('-0.8804947019118704939130792535649732135635599548043341124', 2, 2, '-1');
  t('-0.52717431619592748160776804177287921392640260092349058764002', 10, 4, '-0.5552718383');
  t('-0.829012721483594802508421432835533409949342660577025041776237199892', 4, 3, '-0.9774');
  t('-0.61525293962197', 1, 5, '-0.7');
  t('0.387756961344428886504142532754525460309670339239623120629910689', 4, 6, '0.3982');
  t('0.04847', 10, 2, '0.04848899886');
  t('-0.092944756533698', 6, 1, '-0.0930791');
  t('-0.6', 10, 2, '-0.6435011087');
  t('0.9', 3, 3, '1.11');
  t('0.17313', 5, 0, '0.17401');
  t('0.1439933', 7, 0, '0.1444956');
  t('-0.7770304', 1, 5, '-0.9');
  t('-0.0402', 7, 5, '-0.04021084');
  t('-0.31146236785967723719283', 7, 1, '-0.3167315');
  t('-0.9', 5, 4, '-1.1198');
  t('-0.11931358908883', 4, 4, '-0.1196');
  t('-0.701', 9, 4, '-0.776798739');
  t('0.4', 5, 0, '0.41152');
  t('-0.8993689143436422584255355459267605879928490231754075653278668263', 3, 3, '-1.12');
  t('0.34219', 6, 6, '0.349247');
  t('-0.9642', 1, 2, '-1');
  t('0.6', 5, 0, '0.64351');
  t('0.22656', 3, 0, '0.229');
  t('0.8', 3, 0, '0.928');
  t('0.555', 6, 6, '0.588363');
  t('-0.9', 7, 2, '-1.119769');
  t('0.2945884', 1, 4, '0.3');
  t('0.120848406', 10, 5, '0.1211445079');
  t('-0.9', 3, 6, '-1.12');
  t('-0.9257', 8, 0, '-1.1828821');
  t('-0.37616471244017872054', 2, 2, '-0.38');
  t('-0.1157756923117603310605647347810722526443124459530686783555310338034661982', 2, 1, '-0.11');
  t('-0.041', 5, 3, '-0.041012');
  t('0.237293671', 9, 6, '0.239578999');
  t('0.76', 2, 1, '0.86');
  t('0.59436831223719718487821431508739825011632107', 6, 0, '0.63648');
  t('0.7336894544510273054523385966830850809044651', 2, 4, '0.82');
  t('0.351', 5, 5, '0.35864');
  t('0.0786546928746697509652910267068549', 2, 3, '0.078');
  t('0.01', 10, 2, '0.01000016668');
  t('0.3200311', 3, 6, '0.326');
  t('-0.216644648381156452509718968216656434', 8, 2, '-0.21837617');
  t('0.103', 1, 6, '0.1');
  t('0.28', 7, 5, '0.2837941');
  t('0.0709415', 7, 1, '0.07100113');
  t('0.5822318', 7, 2, '0.6214711');
  t('-0.96', 7, 5, '-1.287002');
  t('0.34479', 4, 1, '0.352');
  t('-0.917444', 9, 2, '-1.16160784');
  t('0.57802', 5, 4, '0.6163');
  t('-0.7688358078701372229283081492614708733791170179074769178295638382044', 9, 1, '-0.877018528');
  t('-0.225439883365270672411', 9, 3, '-0.22739452');
  t('-0.21033', 3, 5, '-0.212');
  t('-0.1675', 8, 4, '-0.16829329');
  t('-0.617', 8, 5, '-0.66492486');
  t('-0.927104', 2, 2, '-1.1');
  t('-0.141447', 7, 3, '-0.141923');
  t('-0.050383992801828175', 2, 3, '-0.051');
  t('0.239022117094843113053902548571950140239391202297872832', 6, 3, '0.241358');
  t('0.2586950729', 7, 4, '0.261671');
  t('0.907964540818538', 2, 1, '1.1');
  t('-0.800488044837154421790417180936088835879209324732903904949839162', 4, 1, '-0.9281');
  t('0.602643', 7, 1, '0.6468089');
  t('0.352142399529899761102056545', 1, 2, '0.4');
  t('-0.3752', 8, 0, '-0.38461253');
  t('0.74', 2, 2, '0.84');
  t('0.76464', 5, 3, '0.87048');
  t('0.441', 7, 3, '0.4567125');
  t('-0.9', 4, 6, '-1.12');
  t('0.1', 6, 4, '0.100167');
  t('-0.5', 2, 5, '-0.52');
  t('-0.5', 9, 1, '-0.523598775');
  t('0.053327854045759137', 9, 3, '0.0533531626');
  t('-0.459844405135307941547798662', 10, 5, '-0.477819971');
  t('0.9768', 7, 5, '1.354971');
  t('-0.72782', 4, 2, '-0.8151');
  t('-0.13193499248', 6, 3, '-0.132321');
  t('-0.08', 2, 6, '-0.08');
  t('-0.109882', 4, 2, '-0.1101');
  t('0.712329', 6, 1, '0.792811');
  t('0.3661032553135184679354126083298596286480428128162671492434245654', 5, 1, '0.37481');
  t('0.49290402205414220423916', 6, 4, '0.515424');
  t('0.6264647', 8, 6, '0.67700926');
  t('0.9384303835636095432873699', 7, 5, '1.218058');
  t('-0.6148', 10, 6, '-0.6621323541');
  t('0.076711692', 2, 1, '0.076');
  t('0.9', 5, 0, '1.1198');
  t('0.777237019', 2, 3, '0.89');
  t('-0.12755969', 1, 6, '-0.1');
  t('0.2', 2, 1, '0.2');
  t('-0.09', 8, 5, '-0.090121945');
  t('-0.366567449704574472588', 7, 3, '-0.375317');
  t('-0.2', 5, 3, '-0.20136');
  t('-0.589619105678072950745817997123194797230295830001452460598930192182557551228', 1, 1, '-0.6');
  t('0.5', 3, 0, '0.524');
  t('-0.51643922124021909421175831823535', 6, 4, '-0.542687');
  t('-0.85', 4, 2, '-1.015');
  t('0.816306', 1, 5, '1');
  t('-0.296', 12, 3, '-0.300502263485');
  t('0.1189382674147513186598892955332505010958649576995317057162822579400492744199313', 18, 3, '0.119220490682749456');
  t('-0.4', 19, 6, '-0.4115168460674880194');
  t('0.02277511555873663', 16, 5, '0.02277708494955459');
  t('0.900867876943271178105288470109342419889565287226604687286044770547497', 12, 6, '1.12176467209');
  t('-0.1125', 5, 4, '-0.11274');
  t('-0.2', 9, 6, '-0.201357921');
  t('-0.91', 9, 2, '-1.14328406');
  t('-0.93175582866430679075', 1, 3, '-2');
  t('0.255035032969825857910675', 13, 3, '0.2578839340994');
  t('0.728937', 14, 4, '0.81676788910487');
  t('-0.6437697', 17, 2, '-0.69941441931670547');
  t('-0.113056', 7, 3, '-0.1132983');
  t('-0.05', 18, 2, '-0.0500208568057700146');
  t('-0.966', 20, 6, '-1.3092836776345883128');
  t('0.3912', 18, 0, '0.401935146489218573');
  t('0.92638514271', 17, 0, '1.1846973510634683');
  t('0.47329567037', 2, 2, '0.5');
  t('0.33591814575421702599636', 5, 2, '0.34258');
  t('0.5235764', 5, 2, '0.55105');
  t('0.3768842', 13, 0, '0.3864301359616');
  t('-0.120235891', 2, 6, '-0.12');
  t('-0.9732390599', 7, 3, '-1.33893');
  t('-0.884287', 19, 1, '-1.084964845911474525');
  t('-0.73505', 7, 2, '-0.8257404');
  t('0.85', 14, 2, '1.0159852938149');
  t('-0.7138415389359997011616777580345310822241', 4, 0, '-0.795');
  t('0.2652139049627332', 18, 6, '0.268425765034485515');
  t('0.53776744497723661', 15, 6, '0.567786813743787');
  t('-0.49486785', 18, 1, '-0.517682748142279263');
  t('0.943538782613835870681596', 3, 6, '1.23');
  t('-0.0301', 20, 2, '-0.03010454700424480901');
  t('0.7', 12, 4, '0.775397496611');
  t('-0.83120363', 20, 5, '-0.9812691201257641077');
  t('-0.2303', 8, 2, '-0.23238595');
  t('0.3042003933281961', 9, 2, '0.30909893');
  t('0.317', 18, 6, '0.322564671042011057');
  t('-0.2', 11, 0, '-0.2013579208');
  t('-0.0834965929059675683890230990563284162647', 20, 3, '-0.083593917149410347054');
  t('-0.084365452438034577900866969139351424273068861100358322133917314597', 8, 6, '-0.084465853');
  t('0.93770496898506', 8, 3, '1.2159646');
  t('-0.195935635516318', 13, 4, '-0.1972114890182');
  t('-0.3691356798927358359', 10, 1, '-0.3780788477');
  t('-0.346206438963729304055013381519396532846', 6, 4, '-0.353524');
  t('0.92869426364', 6, 2, '1.19088');
  t('0.4056', 3, 0, '0.418');
  t('-0.51', 14, 0, '-0.5351847902756');
  t('0.9688100538387653392717235065534415451158', 2, 5, '1.3');
  t('-0.7', 20, 3, '-0.77539749661075306375');
  t('0.98837866022', 13, 0, '1.418192794367');
  t('0.863', 10, 1, '1.041178086');
  t('0.01100229', 7, 2, '0.01100252');
  t('0.7', 1, 2, '0.8');
  t('0.966', 20, 2, '1.3092836776345883129');
  t('0.751725706426246874549877085', 17, 2, '0.85067497550687094');
  t('-0.4', 10, 1, '-0.411516846');
  t('-0.6', 9, 2, '-0.643501108');
  t('-0.74115329346113364256', 13, 0, '-0.8347866416024');
  t('-0.87219826167709', 14, 6, '-1.0596784934336');
  t('0.724', 15, 6, '0.809583593564425');
  t('0.0451', 17, 0, '0.045115302986200827');
  t('0.2', 5, 3, '0.20135');
  t('-0.3', 7, 4, '-0.3046927');
  t('-0.2671348190838033756154768119054559426129215883124539908708797269940573813', 12, 3, '-0.270418570196');
  t('0.7', 17, 3, '0.77539749661075306');
  t('-0.04423891089652', 5, 6, '-0.044253');
  t('0.3', 7, 5, '0.3046927');
  t('0.956820847', 2, 4, '1.3');
  t('0.28', 7, 0, '0.2837942');
  t('-0.073849036', 16, 0, '-0.07391632610814796');
  t('0.97218219897', 2, 5, '1.3');
  t('0.5', 13, 1, '0.5235987755982');
  t('0.567972', 17, 4, '0.60403974207948756');
  t('0.79208985914074716641427597001334', 15, 2, '0.914225160436194');
  t('0.6085', 9, 1, '0.654168987');
  t('-0.59', 11, 5, '-0.63105884078');
  t('0.418', 1, 1, '0.4');
  t('-0.626', 2, 6, '-0.68');
  t('0.6906329873709', 2, 6, '0.76');
  t('-0.9080967937480431', 8, 2, '-1.1387165');
  t('0.524828', 4, 6, '0.5525');
  t('0.5', 2, 2, '0.53');
  t('0.286', 20, 4, '0.29004985708941642842');
  t('0.72037813', 4, 3, '0.8043');
  t('-0.8408235358161428', 14, 2, '-0.9988028070372');
  t('-0.9365619', 19, 4, '-1.212689037111932');
  t('0.510952142014368034735949948', 10, 5, '0.5362920714');
  t('-0.582604186482', 18, 0, '-0.6219291678276465');
  t('0.076248856451812760242578743794169383764890062176767609', 2, 4, '0.076');
  t('0.926', 4, 0, '1.184');
  t('0.1271530013291553992134351', 13, 0, '0.1274981509594');
  t('0.316685978501828764211964615979572098542307922672217639', 1, 5, '0.3');
  t('-0.8', 15, 4, '-0.927295218001612');
  t('0.501416369709526604587612814266516597679771317790097', 9, 1, '0.525235032');
  t('0.15', 13, 5, '0.1505682727767');
  t('0.3', 1, 1, '0.3');
  t('-0.0100114', 20, 2, '-0.010011567244860011205');
  t('0.002414', 16, 2, '0.002414002344561806');
  t('-0.3', 9, 0, '-0.304692655');
  t('0.61', 5, 4, '0.65606');
  t('-0.80402863', 9, 0, '-0.934039981');
  t('-0.86', 17, 0, '-1.0352696724805088');
  t('-0.7224104', 14, 4, '-0.80728193550786');
  t('0.8425709474040469573841295', 8, 6, '1.0020391');
  t('0.04812', 4, 5, '0.04814');
  t('-0.7', 5, 6, '-0.7754');
  t('0.1', 14, 2, '0.10016742116156');
  t('0.4', 6, 6, '0.411517');
  t('-0.14493715757691474822', 18, 1, '-0.145449459142623526');
  t('-0.1', 1, 3, '-0.2');
  t('0.9329835060074', 1, 5, '1');
  t('-0.003', 5, 6, '-0.003');
  t('-0.59892883', 3, 4, '-0.642');
  t('-0.98604036642', 12, 5, '-1.4035107411');
  t('0.404938850204554408251963703', 7, 5, '0.416912');
  t('-0.2', 17, 1, '-0.20135792079033079');
  t('0.6222455', 14, 0, '0.67160791198287');
  t('0.01', 11, 6, '0.010000166674');
  t('-0.96654', 17, 0, '-1.3113805280620826');
  t('0.91313436995648', 9, 6, '1.15090775');
  t('0.440721', 13, 6, '0.4564017287896');
  t('-0.0136', 1, 2, '-0.01');
  t('-0.605985974', 15, 1, '-0.651004760907426');
  t('-0.1892907651155950735544427783388814962564826192', 8, 3, '-0.19043981');
  t('-0.65', 1, 0, '-0.8');
  t('0.358809547304', 16, 6, '0.3669922011162105');
  t('0.9728740131913928304769352327438222457436035584095671257', 18, 1, '1.33734603980186065');
  t('0.6674832905640981296581763957643626616255', 8, 4, '0.73082381');
  t('0.3869138', 1, 1, '0.3');
  t('0.5251210165548090494719722735418175288479347867385618446425', 14, 4, '0.55285730737027');
  t('0.47229', 2, 0, '0.5');
  t('-0.30007262878038', 17, 3, '-0.30476879057615387');
  t('0.1674096502983', 4, 5, '0.1682');
  t('0.447988338619292892151980439343745779406731', 17, 6, '0.46451398590137947');
  t('0.730960004089412', 10, 0, '0.8197276565');
  t('0.056277358507938056009558815145654335303', 6, 2, '0.0563072');
  t('-0.68749033807172235207573235007834', 16, 4, '-0.7580274604478765');
  t('0.44', 13, 6, '0.4555986733958');
  t('0.707907', 12, 0, '0.786530485015');
  t('0.458325110549969332', 9, 4, '0.476109809');
  t('-0.1144302583', 2, 0, '-0.12');
  t('0.1497934612220924612103829458264', 4, 0, '0.1504');
  t('-0.76766908411185811325010984182477443101194230604828', 2, 6, '-0.88');
  t('0.84', 14, 1, '0.99728322237179');
  t('-0.3', 8, 5, '-0.30469265');
  t('-0.41071', 15, 5, '-0.4232326342835');
  t('0.3023597279818520303191129677876795836384121479528541036', 15, 5, '0.30716728652672');
  t('-0.4107104336248181501266675061424', 2, 3, '-0.43');
  t('0.7', 1, 0, '0.8');
  t('-0.524', 15, 5, '-0.551540591306578');
  t('0.853673770767818139', 12, 2, '1.02299901654');
  t('-0.197', 13, 0, '-0.1982970100688');
  t('0.3', 2, 1, '0.3');
  t('-0.22787', 7, 4, '-0.2298896');
  t('0.7', 14, 6, '0.77539749661075');
  t('-0.709953797174034991', 19, 0, '-0.7894326012973310541');
  t('-0.54919296843773782560297024949968', 3, 1, '-0.581');
  t('0.901874471450972', 16, 0, '1.124089123865628');
  t('-0.454621115462736711056810102802204119571763447767392038221175', 16, 0, '-0.4719467823312298');
  t('0.092843970623392', 15, 2, '0.0929778765802304');
  t('0.3', 1, 0, '0.4');
  t('-0.549759263815634959544', 14, 3, '-0.58207601525115');
  t('-0.841', 1, 6, '-1');
  t('0.9', 19, 4, '1.119769514998634187');
  t('0.095929', 12, 0, '0.0960767417038');
  t('-0.214442194739', 38, 6, '-0.21612070327747751292884330498674621216');
  t('0.90456', 26, 1, '1.1303465640173503262170021');
  t('0.42514', 34, 6, '0.439116554315784172224232636961289');
  t('-0.11232964063539206000844646913', 27, 5, '-0.112567220382981483856528312');
  t('0.48103337226643477', 31, 0, '0.5018330355139358592630169769839');
  t('-0.86249247016222106729937', 1, 2, '-1');
  t('0.294145849001529120445733045', 25, 6, '0.2985617083818435365088161');
  t('-0.09264201259223031224732873656', 13, 0, '-0.09277504435828');
  t('0.1', 37, 1, '0.1001674211615597963455231794526933185');
  t('-0.8', 40, 0, '-0.9272952180016122324285124629224288040571');
  t('0.445978250109332766318294', 22, 0, '0.462266926998202347019');
  t('0.9374389978306204625165652372606903259104220700258499', 15, 4, '1.21519986547048');
  t('-0.137', 17, 2, '-0.13743221942503327');
  t('0.45536948061916284200144244035427', 14, 0, '0.47278717578735');
  t('-0.1523262921', 10, 1, '-0.152921608');
  t('-0.4846286263675223', 17, 6, '-0.50593855485683549');
  t('-0.254609', 17, 2, '-0.25744335677490326');
  t('-0.19168361547215937756370914425751831291252899837161', 1, 4, '-0.2');
  t('-0.0355405425900098', 36, 4, '-0.0355480289013274977583242033320119043');
  t('-0.8897', 22, 3, '-1.096687639733042593221');
  t('0.17010191', 7, 2, '0.1709331');
  t('-0.025286197', 25, 3, '-0.02528889240660659621831979');
  t('0.49264384408392639909800886326', 17, 3, '0.51512524396478716');
  t('-0.310852086818574548693074656242386195892780798282312718800170341401433990453459563027524', 19, 3, '-0.3160894021721673686');
  t('-0.75819357879475794976304753', 12, 6, '-0.860538175199');
  t('0.39565364759154714638', 9, 3, '0.406779466');
  t('-0.38486773103224246403129838458978046033229', 5, 6, '-0.39506');
  t('-0.08923189127892126448947354638794724', 28, 0, '-0.08935073322351918181359438341');
  t('0.84438612', 21, 1, '1.00541826536411643404');
  t('0.137950420517414', 22, 3, '0.1383917505295168633674');
  t('-0.9906267834931096', 8, 3, '-1.4337716');
  t('0.2479552466454144', 16, 1, '0.2505690168280783');
  t('0.6570699446206', 18, 4, '0.71692525080945887');
  t('0.898082168919676838903721162818579', 38, 2, '1.1153895002625983129725235829547933528');
  t('0.8', 7, 2, '0.9272953');
  t('0.7', 39, 4, '0.775397496610753063740353352714987113556');
  t('0.4419483025256920284455962', 19, 6, '0.457769436845684137');
  t('0.824140634544280011', 26, 3, '0.96868323985551506438728023');
  t('0.04506476559722269245209774', 17, 3, '0.045080032723175797');
  t('-0.93139921362809228293', 24, 2, '-1.19823813329221799836312');
  t('0.1729991', 7, 5, '0.1738739');
  t('-0.121130266591414365', 12, 0, '-0.121428454457');
  t('0.383425017', 19, 6, '0.3935019006937576522');
  t('-0.209522056780080638407670059490386', 32, 6, '-0.21108614164163226079025384617692');
  t('-0.9599888022399013892', 17, 3, '-1.2869622283275903');
  t('0.74004147', 28, 5, '0.8331320160626251154465436711');
  t('0.4517856216980300365184687211547777315189210155622631960451', 23, 5, '0.46876586114635543427993');
  t('-0.7739', 2, 2, '-0.88');
  t('-0.6518350307955', 35, 3, '-0.71000166117905260831777939676592687');
  t('0.6429839', 17, 3, '0.698387967159417');
  t('0.646344530810939475514571898683', 14, 4, '0.70278402913021');
  t('-0.13843', 16, 5, '-0.1388759758160133');
  t('-0.51', 34, 4, '-0.5351847902755998475404740502029014');
  t('0.943', 19, 4, '1.231532757504771466');
  t('-0.06', 21, 5, '-0.0600360584452784224998');
  t('-0.32371646', 30, 6, '-0.329654826129577205029657467332');
  t('0.989', 28, 0, '1.422336055798236874544506044');
  t('0.836787', 22, 0, '0.9913884482647171037894');
  t('0.43239', 27, 2, '0.447141685741775573557528876');
  t('0.05188827367801', 13, 5, '0.05191158587058');
  t('0.1199', 10, 2, '0.1201891552');
  t('0.26969813296722270712364809918944407', 38, 1, '0.27307953452204108138951668123457840347');
  t('-0.780661', 23, 4, '-0.89572279627921059038907');
  t('-0.483159819865913', 24, 1, '-0.50426016111388050523484');
  t('0.34458227', 36, 2, '0.351793766285238799756626274469063682');
  t('-0.6370086311035339942197', 20, 5, '-0.69061143641317621575');
  t('0.75280528165896709', 38, 1, '0.85231352644037875015466738240213080986');
  t('0.669902569', 15, 2, '0.734077550470747');
  t('-0.51832782142301957259', 10, 4, '-0.5448944412');
  t('-0.11', 39, 3, '-0.110223049987746633176471329435093237487');
  t('0.1109686836089507902070956844359806295826497815215481101961728578777', 10, 0, '0.1111977006');
  t('0.1206799339144384494670508021076546303171474719928947768', 27, 0, '0.120974793752260780894043276');
  t('-0.83', 32, 3, '-0.97910768436835265478823916106724');
  t('-0.397', 5, 6, '-0.40825');
  t('0.03774610274882809554072034855', 3, 0, '0.0378');
  t('-0.00227330837615', 12, 3, '-0.00227331033421');
  t('-0.3', 30, 3, '-0.304692654015397507972002961228');
  t('0.0589686468199023729811487670459085219706255665411254524', 17, 5, '0.05900287569997485');
  t('-0.133710649046340440740274736565', 5, 2, '-0.13411');
  t('-0.288754694896431509083614249277642756259528726520596966415292885940349468', 31, 5, '-0.2929258707945849884702780286348');
  t('-0.85673152660938', 17, 0, '-1.0288987527231478');
  t('-0.89966274351908497311854023521790124088', 23, 5, '-1.1189964125259290577141');
  t('-0.96', 21, 0, '-1.28700221758656877361');
  t('-0.7', 36, 0, '-0.775397496610753063740353352714987114');
  t('-0.6960770858', 18, 1, '-0.76991900030710295');
  t('0.99204081', 35, 2, '1.4445444310930748533015958998604789');
  t('-0.10873809866', 17, 1, '-0.10895353299765856');
  t('-0.944904537058153665591', 20, 2, '-1.2373028529072940371');
  t('0.7751192039672555259', 32, 0, '0.88690374226463417260817604732923');
  t('-0.61775491369465120022960019235335116912185170401034136210833289458037', 16, 6, '-0.665884493051567');
  t('0.2303', 3, 3, '0.232');
  t('0.59068891179984355692759215265', 8, 0, '0.63191236');
  t('-0.364142017501657996664733667433414', 36, 0, '-0.372711405916914280672202082524072966');
  t('-0.4', 29, 6, '-0.41151684606748801938473789762');
  t('0.9512645857', 25, 5, '1.257311087337661820531381');
  t('0.555044564223513030557946443', 29, 0, '0.58841653949885867116753002749');
  t('0.77', 1, 0, '0.9');
  t('0.74951769465392563942637', 11, 5, '0.84733320297');
  t('0.58528728692706285824848037852013900905119890701698772', 20, 2, '0.62523432637968231086');
  t('-0.03013311416564', 5, 5, '-0.030138');
  t('-0.77520756', 37, 3, '-0.8870435990436814974609923156580705139');
  t('0.44902', 34, 5, '0.4656682527542793936519979249023969');
  t('-0.8575', 11, 3, '-1.0303905767');
  t('0.9721702354759497173840587829175741568278214901155520454576848663475567103362394914598', 8, 3, '1.334323');
  t('-0.046', 8, 6, '-0.046016238');
  t('0.6874110905', 10, 3, '0.7579183387');
  t('0.39012', 35, 4, '0.40076191565541987886614505572039159');
  t('-0.941246678013254896453651963690744225939', 8, 6, '-1.226303');
  t('0.169158806641414522195722', 31, 1, '0.1699761132901922320068101828125');
  t('-0.292', 30, 5, '-0.296317307356806630985210367769');
  t('0.8546087603127649', 4, 4, '1.025');
  t('-0.3', 2, 2, '-0.3');
  t('0.9657337775208024135670339241078825398849', 6, 1, '1.30825');
  t('-0.2182', 27, 2, '-0.219969645396290782022143581');
  t('-0.747425510733135870761339000917691875', 3, 5, '-0.844');
  t('0.1', 1, 6, '0.1');
  t('0.67928650694170094260270597650609', 40, 4, '0.74678996728022541083269447625264364662');
  t('-0.6', 23, 1, '-0.6435011087932843868028');
  t('0.22197552234770043642', 39, 1, '0.223840073055066344504871831867081096561');
  t('-0.20882006719810998770027535447976807310479440899918247622', 5, 1, '-0.21036');
  t('0.1', 12, 6, '0.100167421162');
  t('0.1217440321533906902', 5, 4, '0.12205');
  t('-0.8', 18, 3, '-0.927295218001612233');
  t('-0.49887', 17, 2, '-0.52229445472944901');
  t('0.932858', 13, 2, '1.202266568946');
  t('-0.3', 38, 4, '-0.30469265401539750797200296122752916695');
  t('-0.42365097512319913', 30, 0, '-0.437472089275994554863244346646');
  t('0.643302712945', 3, 5, '0.699');
  t('-0.289', 38, 6, '-0.2931820999430600837251965776567802157');
  t('0.2', 10, 2, '0.2013579208');
  t('-0.1377963476057', 26, 1, '-0.13823619201239823203089137');
  t('-0.2958859504665224351467996958715572511035', 30, 2, '-0.300382865595372968757019208095');
  t('-0.36192198695332688', 32, 4, '-0.37032882715023175323464986942378');
  t('-0.7', 12, 6, '-0.775397496611');
  t('0.594094', 39, 3, '0.636138868163068073734589636666972437649');
  t('-0.23873311254864491024665114788368', 18, 1, '-0.24106103142562323');
  t('-0.79149', 25, 1, '-0.9132430620999676247341609');
  t('0.346717675415607232273798344841245496486293786786271985195287863877884', 5, 5, '0.35407');
  t('-0.93', 19, 3, '-1.194412844477168375');
  t('-0.52478919177660352489685496', 4, 1, '-0.5524');
  t('0.88628283525495819629045267572694817976', 26, 0, '1.0892565511812156452168012');
  t('-0.04', 39, 5, '-0.0400106743539889262206207193468971214893');
  t('0.43', 25, 3, '0.4444927769358190387543066');
  t('0.10950546865778', 32, 4, '0.10972551298003848008728520748695');
  t('-0.3412116431091653014335862411', 13, 1, '-0.3482055970088');
  t('-0.543090123665191562870034727400888399519130906623676', 11, 1, '-0.57411289328');
  t('0.93', 1, 4, '1');
  t('-0.55', 11, 3, '-0.58236423787');
  t('0.71662', 33, 5, '0.798944044767300765935737696512365');
  t('-0.73723818066589404', 37, 0, '-0.8289734381053287695276662780605986373');
  t('0.816858689952689985398', 3, 6, '0.956');
  t('0.2', 14, 0, '0.20135792079034');
  t('-0.145292285315228371195516369237719637760407535104', 35, 4, '-0.14580838618458364401102969384285022');
  t('-0.7', 19, 4, '-0.7753974966107530637');
  t('0.09731427', 36, 2, '0.0974685237104366838399482352566622868');
  t('0.2353405584', 5, 4, '0.23757');
  t('0.65447936923863652722973633600583303254441233', 35, 6, '0.71349382278949286067401589886050727');
  t('0.312357073794486797', 5, 3, '0.31767');
  t('0.7835949991', 19, 1, '0.900431399728660782');
  t('0.849280419458671', 14, 4, '1.0146208042391');
  t('-0.82055194', 7, 5, '-0.962376');
  t('-0.69324431204', 23, 5, '-0.76598095939064798068676');
  t('0.9507534', 3, 3, '1.25');
  t('-0.76803851339893870885297974', 14, 3, '-0.87577260955185');
  t('0.1922073682572391416318223775755801001839317570539', 8, 4, '0.19341096');
  t('0.1662631485928568396', 50, 0, '0.16703885134152211681981329607064452691970594049806');
  t('0.888', 36, 4, '1.09297742954269226589937042810364683');
  t('-0.600173928688496707745271940529721', 38, 5, '-0.64371853738381535730491242414725967987');
  t('0.7911', 55, 0, '0.9126052178163792767527734988429844029368769200634337278');
  t('0.3546778058933924693', 17, 5, '0.36256944790399897');
  t('0.54974852945420690728155577708786222', 23, 6, '0.58206316475593915490972');
  t('0.060118090042932345105146', 59, 4, '0.060154362046838886809185813105054944264496587613207177491636');
  t('-0.931958299', 11, 0, '-1.1997771159');
  t('-0.85', 17, 4, '-1.0159852938148251');
  t('0.00484728540163', 38, 6, '0.0048473043839423358237266878523770760074');
  t('0.543498434548813423236124034594', 12, 4, '0.574599242663');
  t('0.69935995211', 26, 5, '0.77450164350724485660825547');
  t('-0.1959144111780857', 9, 2, '-0.197189845');
  t('0.081072313435318647723', 30, 5, '0.0811613880819316048755863791883');
  t('0.027847175660013282145', 61, 0, '0.02785077600243236040169718237935296235016190603593093771583647');
  t('-0.29257050689721', 65, 6, '-0.29691386524227749671153834836081154966816247676375381229171712332');
  t('0.880442932', 31, 0, '1.076795547668899006004509897751');
  t('-0.1', 26, 1, '-0.10016742116155979634552317');
  t('-0.3504', 66, 5, '-0.35799814613742301044937823300551936588578836920295302351995365821');
  t('-0.05', 58, 2, '-0.05002085680577001466274438682046411497780608049468789272874');
  t('0.650141892767202581185769151754239', 36, 1, '0.707771168812129492779933370377238662');
  t('0.1605163037', 69, 3, '0.16121371719225770648458252159445844921574113855345575199470534739585');
  t('-0.7535655075787', 38, 5, '-0.85346922199312588676149594215489582423');
  t('-0.9203', 48, 3, '-1.16884663979539564288537618291137334388911597096');
  t('0.9260585486218169790619', 49, 5, '1.183831004746563842960977686890978399025638691699');
  t('0.32583513517', 7, 5, '0.3318949');
  t('-0.8204561', 45, 0, '-0.962208345429652838601745975034620458311696879');
  t('0.524474', 2, 3, '0.55');
  t('0.4', 8, 1, '0.41151684');
  t('-0.06', 52, 6, '-0.0600360584452784224997511634405409862766168291685094');
  t('0.169508731', 42, 6, '0.170331165037312025219313814970780403778706');
  t('0.014514683968306540918200851247241065338627712672733516127817397321994656418219014572451', 3, 1, '0.0145');
  t('0.75115', 2, 2, '0.85');
  t('-0.7454', 48, 6, '-0.841134684254171395773608179862938182353916999004');
  t('-0.52003603624158707', 61, 5, '-0.5468931400284696606816647744710428429138478153350878673965896');
  t('-0.7', 48, 0, '-0.775397496610753063740353352714987113555788738642');
  t('0.84082406976812389970298868945559736', 49, 0, '0.9988037934462110518444415063382030945161646296509');
  t('-0.55941162250694612150734630451460491683296939178785026286694236079230268', 16, 0, '-0.5936757919861891');
  t('0.76367006417801', 31, 3, '0.8689788347704887864159489127052');
  t('0.651119', 42, 1, '0.709057861612001467774065546164594729375587');
  t('-0.97458023882199493690350269072606', 15, 4, '-1.34483973248817');
  t('-0.683', 19, 3, '-0.751862024267626705');
  t('-0.37062678658436', 54, 5, '-0.379683777892570443243767980497396880129578042156446713');
  t('0.772', 47, 0, '0.88198168883342908500081258739991724104804064211');
  t('0.03895075080098', 78, 0, '0.0389606066245169059426749341279360845319502948822091372005533540922120027411761');
  t('0.64458357502274170940562656317103789175894281961451712', 56, 3, '0.70047847980882727539493872666058654764001890742718993569');
  t('-0.034829766', 51, 4, '-0.0348368119183790349397587623804747126567597027863167');
  t('0.59466310806885381028848788287653604870469769043827', 8, 3, '0.63684655');
  t('-0.7', 68, 2, '-0.77539749661075306374035335271498711355578873864116199359771996373272');
  t('-0.4898004640153758832886082675196127174', 64, 1, '-0.5118608691245448769699850167279641864865419857310431012826768302');
  t('0.95', 42, 5, '1.25323589750337525873710391866600599574114');
  t('0.04359364630809391554694395308296791081205664254257067', 76, 1, '0.04360746573398245418088999959499143862794493157597210874221647317409403809582');
  t('-0.130545518911239137052120114127', 2, 5, '-0.13');
  t('-0.835352934802096605855019', 46, 5, '-0.9887745059126028488539405173511882255838722327');
  t('0.816863860534682138382', 75, 0, '0.955953051519105540757517754095925541302554206023171549716471286314475759031');
  t('-0.00420270887318535819976964925205860758100762530249813246', 4, 4, '-0.004203');
  t('0.38276864903005998348705', 30, 0, '0.392791321314448517627022425141');
  t('-0.1486646656043226847', 28, 6, '-0.1492177954543801610791176693');
  t('-0.0606365964968678', 46, 2, '-0.06067381618631436658284785590514263349205451579');
  t('-0.031219528422346915948014128', 11, 4, '-0.031224602047');
  t('-0.208611897126702214847', 63, 0, '-0.210155414104450948385527563191364660160861010445018360808589475');
  t('-0.226', 60, 2, '-0.227969474016637231157867755678820732310371243748321178666278');
  t('-0.21543667918130054557264720917413702040163472273', 75, 6, '-0.217138987745390864658338187207509171695783936680689777245642210978444348793');
  t('0.97526138650186988106372276108826308796525149', 33, 2, '1.34790042455170230035398152719276');
  t('0.3003741592666055241', 22, 5, '0.3050849037044945622537');
  t('0.33255', 55, 0, '0.3390061808860287544741754482204784760347483748018993759');
  t('0.092672094141983513', 24, 2, '0.0928052558755017546764568');
  t('-0.872', 12, 4, '-1.0592733231');
  t('0.121377839370697059', 42, 2, '0.12167786752899699813296509789358719992707');
  t('-0.72679', 4, 6, '-0.8136');
  t('-0.05', 77, 4, '-0.050020856805770014662744386820464114977806080494687892728743980557038463938966');
  t('0.40089412307553955127806452885487910037228107869828052', 28, 4, '0.4124926222518942558461629927');
  t('-0.7464676833645946285560297214148508678585674194364241950307089362676', 61, 1, '-0.8427377649916848886199721060592557002067035403201115030257907');
  t('-0.484682867317587083890164162041940736690008613', 8, 6, '-0.50600057');
  t('0.113120270070498', 50, 0, '0.11336292145557724571826383182776998307145328515238');
  t('0.34', 10, 5, '0.3469168975');
  t('-0.2926610785739469', 28, 3, '-0.2970085826927033895214703227');
  t('0.59', 38, 1, '0.63105884077802138008065476411889009138');
  t('-0.666004', 56, 2, '-0.72883894869188752508082426773062076470740771016340920745');
  t('-0.95422784743026801105092', 12, 3, '-1.26706730266');
  t('-0.9', 67, 5, '-1.119769514998634186686677055845399615895162186403302882375681863914');
  t('-0.332807758', 19, 6, '-0.3392795075258930194');
  t('-0.95', 21, 5, '-1.25323589750337525874');
  t('-0.221399947969316593', 7, 3, '-0.2232499');
  t('0.366503199947936608548836035815', 76, 0, '0.3752479099732837285966491336016339018492954883700174641896336303715506709124');
  t('0.796578764474897795211746856442048575914', 57, 2, '0.921614640822318447749190939370056438701577282904840049808');
  t('-0.8951817', 26, 3, '-1.1088387080788509960582979');
  t('-0.9409896256123054046284876839902981969882335762', 65, 1, '-1.2255426379859062280463160941613952891818491680479691163432053486');
  t('-0.41324187781140229966', 41, 2, '-0.42601127100914377778551493383700363930714');
  t('0.43266874227539624088526762225947773912327469', 38, 3, '0.44745084295379366863059106258351427345');
  t('0.8461527851501807278', 64, 1, '1.008724532937472369999407408932218781094300767255470631517391649');
  t('-0.115745738523412', 33, 5, '-0.116005751539237493563904774696209');
  t('0.284304737851044381620904888952457483789736031622266595661890845226472739136848559887', 23, 3, '0.28828116234503411819423');
  t('0.932850398775973094771398', 16, 6, '1.202245469329027');
  t('-0.93207232121', 49, 2, '-1.200091730240906248923472509651550501216711826408');
  t('-0.307559341', 53, 4, '-0.3126269787393528134464533769606314913032841594122504');
  t('0.02', 3, 1, '0.02');
  t('0.05409126', 22, 0, '0.05411767207203586238725');
  t('-0.88263', 33, 0, '-1.08142807589689185466198933332415');
  t('-0.6412', 16, 3, '-0.6960610209699352');
  t('0.071', 75, 6, '0.0710597875579649658677311258751004125269524590167389822118077430713114601767');
  t('0.25', 54, 0, '0.252680255142078653485657436993710972252193733096838194');
  t('0.4316106701307', 59, 6, '0.44627756238311788547729132911284077332647248178802965727123');
  t('0.79766', 45, 5, '0.923405295841783325766221839399237615090267575');
  t('-0.86', 74, 3, '-1.0352696724805087972524237712524081954382768243308249843526039026823834384');
  t('0.8917151871549302699804', 39, 2, '1.10112079211449691639797484194623368712');
  t('-0.834217837658', 8, 6, '-0.98671285');
  t('-0.0889902741429280236', 36, 1, '-0.0891081510206886440798660795952769821');
  t('0.159543468885219193682674', 21, 6, '0.160228180910611278557');
  t('0.12539456', 66, 0, '0.125725520241398781288432075737330151158613149351916279601595480571');
  t('-0.77', 59, 0, '-0.87884115166857970601751289000525113783506451415240093231377');
  t('-0.553078003811233', 24, 2, '-0.58605423505194196543817');
  t('0.5041077', 51, 4, '0.528348469238645839832995187757811964852360559008704');
  t('-0.546235796655292521336930382887', 1, 3, '-0.6');
  t('-0.88', 25, 3, '-1.075862200454001096384532');
  t('0.663223870629815', 27, 5, '0.725118146510600214890360632');
  t('0.575345515087178293784283', 72, 3, '0.613026521632428562294026733866840850508453079419516091381141847666300638');
  t('-0.0919426', 3, 0, '-0.0921');
  t('-0.3748729505111603', 5, 3, '-0.38426');
  t('-0.038426210703', 47, 5, '-0.038435673513811703783407201135040014342207364774');
  t('-0.70873', 43, 1, '-0.7876963843899657497726409340831494754261634');
  t('0.033141611149779616601', 75, 3, '0.0331476810890469539588575951732365859575742892515846447531263570596965529946');
  t('0.12641651301996', 40, 5, '0.1267556710065101777375336063974190918591');
  t('0.8942276930150051384899357825253960835535796315329431938595655176754607030956425576565225077672163', 41, 3, '1.1067028255435762602141926028514289352971');
  t('-0.310722', 22, 2, '-0.3159525377694311600708');
  t('-0.09777878645501291325513892221406063785391691064760349', 68, 2, '-0.097935266080218649462426347815668843970149064099533394607639671023005');
  t('-0.210908', 30, 3, '-0.212503761459998181589152663183');
  t('0.0565026468', 19, 2, '0.05653275465343626279');
  t('0.4714', 29, 0, '0.49087755220113448634454431531');
  t('-0.0953273314513416035636672044271510282646', 52, 5, '-0.09547230307940518906019894514985818809668476788314649');
  t('0.64565703768702106868372409749897', 77, 3, '0.70188338704623053407661401041753377761981655204429668322187613422144710272096');
  t('0.1665947', 45, 0, '0.167375092148409359673315873735113047630294574');
  t('0.852744298', 54, 2, '1.0212169442286331053342579271097779547394763850052428');
  t('0.1993546147531281708821212533589233206049989856', 25, 4, '0.2006992714598519215519017');
  t('-0.82839812602', 63, 0, '-0.97624183165075458449651397789110371698700612574734920324364002');
  t('-0.65394271389473563104445198721241352539657370190327516226949358', 49, 5, '-0.7127842540575758779094839198721952069481451657469');
  t('0.4962260182577864', 55, 4, '0.5192464114931555829909478292691012506462215851288879914');
  t('0.1606549866943', 68, 6, '0.1613542236927080239982074248141022972453468706886074646930959043677');
  t('-0.46777550089914572', 79, 4, '-0.4867722604570172115667722286957699058310104595659469697759538669014221766261104');
  t('-0.21', 18, 3, '-0.211574959758095614');
  t('-0.571681105201533092342438196328075930698', 30, 5, '-0.608553335300976040891289451363');
  t('-0.05699621538789649053258914302611322138362326901530074221189', 16, 3, '-0.05702711993955219');
  t('0.5925787905435', 64, 6, '0.6342565135203692635970524299309093326743265057497589153595695378');
  t('0.942', 1, 6, '1');
  t('-0.3061512833793703481610862835094173843657746781110931315241', 58, 3, '-0.3111475475304973793137391108875170350883649765949720959375');
  t('0.45701114240653', 78, 6, '0.474631984157872481159127335480069234889885529123837322052541238359246471744458');
  t('0.2344536089', 10, 1, '0.2366564728');
  t('-0.61', 11, 1, '-0.65606059092');
  t('-0.345766389492404450103125674416450325001625643234531141063827389062676', 56, 4, '-0.35305542948942854948428735153598981479584093095603943541');
  t('-0.429374', 1, 5, '-0.4');
  t('0.12832562558', 46, 4, '0.1286804610288967457778965681388269696339234007');
  t('-0.0474041757368215558873241780259944', 18, 0, '-0.0474219478095239123');
  t('-0.167408156576268584537548735104195960201', 8, 3, '-0.16820014');
  t('0.7', 17, 2, '0.77539749661075307');
  t('-0.992012661576902117130505108397667017029571987095733', 58, 6, '-1.444321079744178461530147066185478523948650582058775186405');
  t('0.384200651951217', 70, 3, '0.3943418680124420669732040703931829664556695205455445385930058222456544');
  t('-0.0563497218707540030366670182237692607491608', 30, 3, '-0.0563795856912166575477715061678');
  t('0.13673385088', 46, 0, '0.137163541899032501535657124447522877338186687');
  t('-0.419618645735831514059739', 40, 3, '-0.4330251469868597344200188008579246680142');
  t('-0.8', 15, 3, '-0.927295218001613');
  t('0.324264375164899823', 22, 6, '0.3302339806920392851348');
  t('0.596311315', 34, 2, '0.6388981813784104566874899118133014');
  t('-0.939234445176982323890299707589044270867945726727', 47, 3, '-1.2203933163763458091477029083623871156388359441');
  t('0.26559685117268269845', 41, 2, '0.26882295573243418565045001452731287045712');
  t('-0.5197501775473520082650103347980525040571008017895758', 32, 4, '-0.54655850151952033221508609978054');
  t('0.98321230829627604074', 131, 3, '1.3873031431594067777959186600010474978340290617104996376537797960018595808682459428362208479584535315237998744268330306117408714751');
  t('-0.8306263096887797', 155, 2, '-0.98023151927426829687943473863594579240034685804617564951176572291968902100856551221322028995733293311017904566162339277118311268477231662889173557914486073');
  t('0.379091939403460776087193452521985326156426704977746874015188855127988988143003230355319182', 76, 6, '0.3888147927233894219559249686057359198013687651505844295408319996189075544492');
  t('0.138183859194653664', 10, 0, '0.1386274465');
  t('-0.636945104654434508184266202782284647', 99, 5, '-0.690529029023082598743072143236329489312548615306269411945391957230849185760204158457282133121855902');
  t('0.098466081988062587713433374045963598976413197390842303300454181888207023266820002440708702106285627166144453217682373816939119', 73, 3, '0.09862589435732260478719256680011196464387958555399270932700769810422680396');
  t('0.22460317747577075', 136, 3, '0.2265357900059584247237015990913650265827549283985583240699651972217568542831290579685417040457506840650089443451214859526553348553201622');
  t('0.4871309085291940793203225175548657462201951518389', 75, 2, '0.508801495760700476147890339935933172807185075951677904340075605078709198526');
  t('-0.911312518334048550842772331751600852138657289539275348553552054', 85, 1, '-1.14646082528887524546415438880104006309957814601729639880723431686126011949154196904');
  t('0.37365936348133955250214930950810747832464153012753285154267113854535143776314499213578925774851', 43, 2, '0.3829510256232298461555772524549519440478305');
  t('-0.66232866829740217220208720202062249394526483380163454300555655659621271695', 41, 5, '-0.7239226582423784570783106601587845218062');
  t('-0.994245714', 43, 4, '-1.463466805054880958297582796049403538063361');
  t('-0.183977258093146027471805229213', 111, 3, '-0.185031258034235643792220377661239335645455910981859668719240161517904068516822560846004041760798432443807857903');
  t('-0.7729793397718', 122, 0, '-0.88352389064640391193039223501748753370173981761823355988722837335611005422188294668361614175552785826760934402784704986076');
  t('-0.083248771027521638377471299937768642867047081544684', 108, 4, '-0.0833452294484917777716066569601253396580122600325716686993517688771803513464826579142949857130580461362003586');
  t('-0.6186956013', 80, 0, '-0.66708129534177493145577713909719544176531899123298300600884771302337433617812067');
  t('-0.01981399888900374668160454728747204564253390884179747350782591212', 151, 1, '-0.019815295596105648088656424226163230937252988270555832416618152776061581386841357532406017661504548242355569912535517486688978058315371021964966524444');
  t('-0.1477', 123, 5, '-0.148242361070174829381615182726297587651970776380051790237606024427909892810361565549611415729396339300784835501044475065138');
  t('0.85206188160264919022321809651148551214585', 45, 1, '1.01991184555336572657990981140243625242024426');
  t('-0.90185946293110377', 37, 4, '-1.124054383035903097573896035868010966');
  t('0.686683042607436303344759565393249675057844291780049', 106, 4, '0.7569163636984284393192694105467873521110575489282968058953689813120166829006196799298729221490180773425572');
  t('-0.80565972', 89, 0, '-0.93678830594642213343472905544988431792098759044535546138099284796048417251330411496076225');
  t('0.8287757689823866845947', 28, 3, '0.9769163623280774412845646514');
  t('0.775539', 69, 2, '0.8875684420329496881879490540638410490180739278032969673385692936232');
  t('0.96', 32, 1, '1.2870022175865687736056184574346');
  t('-0.31767770015317195412244341162', 125, 5, '-0.32327930928330505731471437291801827289742091960978232855078485966537503101308728464505761320662838085510137838139945861364565');
  t('0.216612733952205906882978761821565921293961617321023902334402402212213472448217505361894035909181310933757428262655528', 119, 3, '0.21834348326975442874049982351521606416815648051947798022929796985925930383616238104215899370386061219591470416343571914');
  t('0.34325851643722235829203637', 121, 6, '0.3503840161301225150797367788969630661135190262000780117770896001443114285038832584866773690772241644675494094609344758169');
  t('0.154299188', 24, 1, '0.154918107460239837128979');
  t('-0.41276776722631304800604', 57, 1, '-0.425490687303101681366223788904420681616241189113674303367');
  t('0.043667', 120, 2, '0.0436808893439742248329960559825585485204170917742763118790712722987582440062887973419695026577248022055243993513149230336');
  t('0.6446731488596', 25, 0, '0.700595646970220687498344');
  t('0.67324683', 145, 6, '0.7385911211117660516736949252784083519650082278398862917156832397419061072698839369144264191756696594758385294989950975647221856391512485156186627');
  t('-0.45181098606874', 20, 3, '-0.46879429271111472965');
  t('0.253340816117913343897811543600113227940889125785269060368511128349585628971155444741547', 138, 2, '0.25613218036751232534737792780304504216000556767480653053300732246724737920153933136768449061473267069320632415107565957916186074000883527');
  t('-0.3', 157, 3, '-0.3046926540153975079720029612275291669545600317067763873929779487464729925120331594385999572313631487317349566307855469247966854234324188781871838304561501104');
  t('0.06719', 69, 5, '0.0672406578123116252702557668900516532977792000811102672961609054389803');
  t('-0.2029361475210546849472050839', 148, 4, '-0.2043555353924493763086154552433925626206444604955325328432808534451360476476493234954864145598030057338008420662129607867684546179911887045629193833');
  t('-0.08505004367434599739129751042722551187', 85, 2, '-0.08515291393416652373128316763326521285315921811705725258953678537287920982299629963107');
  t('-0.00315095687644621447913391882472466785408443824', 102, 0, '-0.00315096209053075570313519115225915042540639370245727449636092274914783756966242186928626857801511829216');
  t('0.2166373253670628178680959671935316242903578673260341215573798024044966787602', 133, 0, '0.2183686728132707857773171836454654607516826449616705470677086497852975091508946533120857195602676645410836560739427425089385497687577');
  t('0.92', 60, 0, '1.16808048521423503632107058720450462161850853688309613797297');
  t('0.144196364870930264351342698715747390136512027309915951329840851131402596467769463', 115, 2, '0.1447008018094614787289802107226618992844728575822171026909594506859961543423061540076851920189343818919782027754542');
  t('0.7394013508349718727484541422', 54, 3, '0.832180750380685449194844845873512892231224707396715347');
  t('0.359140110091224523', 93, 6, '0.367346370256250752326050923549225439456036710295143043815361999094323092238737483794980955088');
  t('-0.2434277253', 33, 3, '-0.245898324882648198496205894660443');
  t('0.395', 11, 1, '0.40606785105');
  t('0.600149', 31, 2, '0.6436873718045773971695248426404');
  t('-0.385607', 88, 5, '-0.3958656104336473063722170432706072288184320245342883683023396798759080100105588956287616');
  t('-0.4', 44, 1, '-0.41151684606748801938473789761733560485570113');
  t('-0.5544932', 124, 3, '-0.5877538456705320004042946159576167967598897812104839698663303461388013204899617645696652855341761969812488123590202289149313');
  t('-0.7336726776087398288', 42, 3, '-0.823711243239253788754217507031013050435158');
  t('0.746554277552499912', 126, 1, '0.842867908799419987576179557452805512346118237805372250199749542385971048576970795947600043003468237732940501496422929923932987');
  t('-0.741202735499981493', 139, 3, '-0.8348602918484922216076698543705885173877779435153151457225248422068196783759734977708105108926269451542455920163197670047314737383801545329');
  t('0.230774131592315450798797193', 113, 1, '0.23287321503418185297789975135716073537340864393150654698184144456535513067463880540906387701431479345402277061409');
  t('0.32616662526937009150934277673480248160828903279537897630622325', 131, 1, '0.33224558201868645018572620213626977209063366314966201256867621587722494465699952546312872848108428031384486908911262158004008233394');
  t('0.6119649493', 60, 3, '0.658542704606472833437662388564229010336306815208477418704682');
  t('-0.8951951691773113264060052628327460828307', 48, 0, '-1.10886892917884892643451353315415098754346366112');
  t('0.711085062846373', 151, 0, '0.7910402497367925766783455692121804455421604367308696056778481350211871875859355512323079626552888085537049952628662428282848953095966828325929264327706');
  t('0.4947021349334433640080276423835', 67, 5, '0.5174920552477371779711190390192192183066910339063478417658662634646');
  t('-0.76664', 160, 4, '-0.8735916602520211283221621827355844768003932883581733170571012966030465804643255169631549275449024402058478437496154722641791914358890862566931062182576658742108');
  t('-0.46080796306132', 44, 5, '-0.47890536462936683670408255931095895120553952');
  t('-0.744950131882722', 72, 6, '-0.840460086650120207875953789353972673974493953871082617085932756159307593');
  t('0.78780549737311213805040716365110736444348512', 54, 3, '0.907237890745486886490779436861981360254053442632343642');
  t('-0.06659718684877323748199967485997079751595', 95, 5, '-0.066646513838094146800249598005989290016122431522285492479445283112834767075354324256695349932748');
  t('0.12798198726185', 37, 4, '0.1283339656134996188797525235048533408');
  t('-0.706164', 35, 4, '-0.78406575671649443067176743996694414');
  t('0.103907523449877348868538', 140, 6, '0.10409541543603086977911440753161024265926970775952235507404595749661214604170605747213518139839861888022007258343170993132925385519220020948');
  t('0.01668', 85, 3, '0.01668077355512507761167771548784513250319580127425759455887233961250891032423714853956');
  t('-0.906064765236819730048479090043', 83, 5, '-1.1338893293220078500538611500779007220392095610419807970447447216330823577278369964');
  t('0.75619680828763677601', 58, 2, '0.857481210940358815102581362152055256701937069476920608529');
  t('-0.983936543516578325', 155, 5, '-1.3913157014814642349769802172655781142112051742005235683121626436316279790761647791181950323537474985512494276515584823883371851902454326779247559368927249');
  t('-0.65345673278401974421899879880820991594030266978121080453', 8, 1, '-0.71214206');
  t('-0.81939018834140163991536507382626451576065347807874214885535961383922369450727488', 153, 1, '-0.960346403261851035243149367591474112131075179165486524236271369941497246212642128069271339304657322143978859403774489139494150608813112639489227381616686');
  t('0.78420672433313869692483669887915358731707867672043560842161076188266185039', 39, 6, '0.901416645595194396527010627633902846353');
  t('-0.9069667968167341927291735578', 82, 2, '-1.136025980435285163705240603148539333670605293586015109274989241163604302288297862');
  t('0.95574221728169119003340279435662', 105, 4, '1.27217231620870629157448647439233976200608483339389365466817728775774070255410662889653416638211154624266');
  t('0.92', 63, 3, '1.1680804852142350363210705872045046216185085368830961379729698');
  t('0.38977970108201787997528029150378499929356', 59, 4, '0.40039236137451543607020570058898518288856038892780030618949');
  t('0.626630161270772034637915265955220897673759119113382791557578602858907246459734278124388270388689882191718392530089576223499', 25, 4, '0.6772215608617562687203423');
  t('-0.53578973702960014466544810890666393405259788764300756250844062462549456605229444625249689723280007548445114681296444', 75, 4, '-0.565442787787492665106462409291297625277450789954940169821244394925572476587');
  t('0.7188926352643993731470790324946', 125, 3, '0.80220795087194132429776509280369788228916898109506390874652393385851748361228417482348921992667302990136160410264056503750592');
  t('-0.5', 41, 6, '-0.52359877559829887307710723054658381403286');
  t('0.4651469832', 133, 3, '0.4838006428873029687858035041369955406137974014963981927540235979011568880479586876944895561731851201330130499217277217863897176359224');
  t('0.43', 119, 0, '0.44449277693581903875430660738312207350989641457737200100597008477203144014513385040858895815490413434998101542934826768');
  t('-0.9295', 37, 6, '-1.19305485317919144062809352229568316');
  t('0.643', 30, 2, '0.698408988923301970826329184976');
  t('0.64163666', 128, 4, '0.6966301880149958192599136740426639518599974234324497314559202055530421311601521762957348108024914923976838612969563639399016872');
  t('-0.4150433621129271978961', 107, 2, '-0.42799046351848637503698118946971901189695900215117256299118930882156809903879982358592664619588386172272768');
  t('0.6267020834835856229844083612239', 150, 4, '0.6773138530896259194745957455858453825964708403171517974472171176848857934941211117601114205573820882950832088470622136708809478557415322128731266221');
  t('-0.271939368659632918107831735628221004897320821908219249', 125, 4, '-0.27540777640900587652341994488925508361731058688390688815589473925032964816431926354917787329547837193764677194166596755355692');
  t('0.5663263100453992293021921862144', 128, 4, '0.60204161138206530499657091645398189960694900242410118774607111402882830151929822869497147546804844994155916943406418396689709141');
  t('0.569333606914265707783844549880809194', 14, 2, '0.60569503540499');
  t('0.1692086817432493943834310299804675814548133171631132949138724125757', 133, 5, '0.1700267178811256272245800338741900268727535800098429947426003575890551740105655217377684268604813520184380627979997741763704000868246');
  t('-0.26230778139975648588228', 113, 4, '-0.26541295066810679633781518767049869257256532606426642851859216245184503825802698340534102059562051934299857505325');
  t('0.93', 96, 2, '1.19441284447716837409397671420360100354622302745984740650275469634774017042714456294474724141491');
  t('0.2310592195223252054452161810525601644530108631502208068578609', 101, 0, '0.23316622190701241663551886371080455321039935500763094062003096499091272425011844100163759141773878204');
  t('-0.1437', 101, 3, '-0.14419921299921622567473984961776846873149426777454106513704190005559101588328724485341467271707677852');
  t('0.67575144760660800068976473757166803013376264001549784642314428938890188714353678094110225388058942491337710229754561303067087763819110482', 113, 3, '0.74198365054116972362802303577561437964260454604552573167093264230117954248078517709115352633981244282993619138673');
  t('-0.003', 87, 1, '-0.0030000045000182250976345265832042599611605163280216070219354057283777996472153051943017');
  t('-0.77165968109', 152, 6, '-0.88144645238423101616847120467952204067909710180812225574213505256311265140564677412155226597213485073517504512638914701211417341152458590193809952313294');
  t('-0.221847476868', 77, 6, '-0.2237087533564227289143190136830214065301217047095288123407668363401204722722');
  t('-0.716', 157, 3, '-0.7980555152315012856149924124224969259274787330893166482568838265851118834387771562959201363199455541674133702656913325999366596593695513752826637378709964985');
  t('-0.187', 69, 4, '-0.188107383070739387023686158650083527008820896680577920729154328212616');
  t('0.57318222889648045417278', 72, 6, '0.610384080789595988044172620595742561469112717047496665519927872237688307');
  t('0.78644508210755698631505494473557085812', 103, 1, '0.9050322616632075211094570449803430591074402790127190255467364228254122885846261267095564409095094892828');
  t('-0.617718365968', 128, 2, '-0.66583801743920534212025152595627134750770613102453152190970709196912669278898993405691106586784669914236816149373308805871341161');
  t('0.317957068349409621865384', 84, 5, '0.323573954249384526312351214008419584631620583595363067238008273271778984603291116346');
  t('-0.52', 76, 3, '-0.5468509506959441087909711033442369565338874398245851393603598685786471502318');
  t('0.263077446791286742953074705', 124, 6, '0.2662106309568873654151373956996464629263698330760518509513021153939758382316026629069007248924076755046444296233106664819468');
  t('0.5195765199312319622992542191', 76, 6, '0.5463552436922317854013172500160906430551828060114290958704252068999384515956');
  t('-0.89870208266793516736707667', 133, 6, '-1.116800981508463582079689393605042664437625332230918767902043496225800695418850272686517434002579017085916645343903833698472077830903');
  t('0.342294966589', 91, 2, '0.3493583267786817338198931944127645509535139163567238164385005753485043532430877823000015009');
  t('0.6341029522304', 46, 0, '0.6868478647929256267451915495961272611261353675');
  t('-0.49453', 151, 0, '-0.5172939967508468913534977031559685788002032692314476198808271303872834679065014302758280018235245029138009002062734578015506132652124503783465558184818');
  t('0.19', 51, 4, '0.191162146531059603464576591595274046353204194877988');
  t('0.3690559462292067462', 82, 2, '0.3779930565212133767239947845968378255176060562526991908917281126826455931460946961');
  t('0.3680759357958244768503088384693276073696220657362592641524617050868914930773218166735841413956085984894281928923400243819655302894', 20, 4, '0.37693883018045266413');
  t('-0.20396077615752517162013930347382407072960422911868208620779767395200874615011045671712957735155498331', 117, 4, '-0.205402051274032581385438172753844616523486356209285496839288857895114235637834568885322719358375197517956080180044701');
  t('-0.72783278048207590485', 98, 1, '-0.81515628474982256183348072141490463975494101527626609154297998105681439195651342760621223056025012');
  t('-0.0859430897033196526036235479613051369087141045734191462210545543812332347746868448475884811666', 99, 3, '-0.086049241929912742607535334587037450167355983955064479200233139491681062319334581122237153776546587');
  t('-0.01293248770598231748490154607185121489646779216626', 14, 5, '-0.012932848224569');
  t('0.9870478912472313972551769993282725689651926247579', 151, 1, '1.409674228707015164564017965385904685277087746091181260558650389306276214573484955525394935980065963464895542680515807589458976216041255021478669455445');
  t('-0.8296515313', 134, 6, '-0.9784832136814208040952073913820870030892836042546032627103316202734336032725383951975650906380357973920282063146134430855771515081031');
  t('0.27861602934', 89, 5, '0.28235277556545016858046569418755898828240681176925592326759015587237205841690555253639296');
  t('0.383056869692704', 22, 4, '0.3931033212036723866617');
  t('0.06927077231878520826499152083088596011012096639', 81, 3, '0.0693262908899409006043964069816411612175166104129786373575875780590528113093407677');
  t('-0.9340043046390376316713996569900633414686376', 37, 1, '-1.205461813557572732076176036334590922');
  t('-0.8766834879', 65, 5, '-1.0689242182579654725161683261641027961519547614570426896685697871');
  t('-0.324517794162246563732235606754195180989358231676814829', 46, 3, '-0.330501887259371494086344701133839247327695052');
  t('-0.111922', 109, 6, '-0.1121569928570227536664975598806136195265638731916965800820055098073246158818461225291161041729214806999366103');
  t('0.343021919', 41, 5, '0.35013212491292811167609106992608187090626');
  t('-0.5003652748345533942966272688', 124, 3, '-0.5240206100270143068145238239152653779345586447416954689576493394383750973070785017271091680462659405297081659598413214302671');
  t('0.08301080527394', 37, 3, '0.0831064371695337946076834911242192425');
  t('0.6569416', 52, 0, '0.7167550066365366031482249713955344563333339598879617');
  t('-0.4144972017030450972126', 126, 1, '-0.427390238524059770225386010018426501591250546999748670061560571076103307797989985320538372018633198482434993836770972754666255');
  t('0.63167381', 17, 0, '0.68371041947672611');
  t('-0.2346529787425116', 58, 6, '-0.2368615640388155539483047532392414394284406749258909302668');
  t('-0.70701956157737', 82, 5, '-0.7852748238492539183845263913515525518878921961176311072315759371131773148357277563');
  t('-0.714522922310356204', 151, 0, '-0.7959419513325656457908896102451427122560382453637968548184498490396348105898671639111834211047885102015773818191157996751617280836811201799255618871601');
  t('-0.820802651067349083547043001', 149, 3, '-0.96281477567827605847378848622243219017930949714648703344744019784230473675305593068481443438792750150350875514170306748598964325496260157538322176282');
  t('0.90711358389206871935697952953962200981030380254378677480417405252054597207477803', 121, 4, '1.136374606869968548608655657315515442619397974886718987384082953520117494490055214476742801581057742308718701334287157032');
  t('0.7229873376553716591159794382285005242853677361144936215787931486256', 40, 4, '0.8081166701441270803014959464894182812366');
  t('-0.8934659403546863476200748103344988643123118164488255881482008816', 62, 3, '-1.10500389462813214832651488468055361174995109785133457529405');
  t('-0.8681069974', 261, 3, '-1.05137586993590202160297979520834720455736069163768998233689854548144269757778186886085619716624460752786021187843258753174902795386014660126649469446867655906655009852459704905435536678385837780585002103878725650550102516715943636597282688184618625018050068036');
  t('-0.8980263104842337792201795870137669793103658181985329267768575489480449169688567119596473441872743443244847158860483178798140289296317559008484787656', 37, 5, '-1.11526251600706661275414229685569381');
  t('0.2', 94, 2, '0.2013579207903307914551255522176234102400380814022283862572512434556093746288518503758449300904');
  t('0.9005012294', 287, 2, '1.1209207826812843092416248024196861484074566456587895526279084951456225291542730646203355338604166393108971728394069898493564444091119723338299418248589827937369018520022650672751832620029240687406918959748835851263689281290390255490697712482514929990101414423192387719599288977733440102');
  t('-0.013631847402768', 159, 4, '-0.0136322696328936002583966932409063912186712056256280472637171126862502019227983358821609580388569471089255791143060560356133245861186678401481320172699688833293');
  t('0.32179692973457543799524143300844842232981372903072360723147720293131946025147007724109341776955032301601642945', 294, 5, '0.327626757160629295082129731615335316493546861079654310288060116706010904653972231209194441747023453982010941132011253295854281305875299691252450655237536528832077713286024866709787444863510554085392568338446121383986652476299492064825084501369567255834140025582322922481099777108217929251441237');
  t('0.1469355035663227772039145346053208531445016872949530705297263205768303709640106529603335695104518936020435023890232397334696808272236639833830547504037101204375847998422130724283', 309, 4, '0.147469431348050432763263032306457820921506965813380562586774997477486481515117470181868148530777548575814202535487398342443188084936525620518007488652817744590471764850744052512218368084302636599360052975853487314911960040848484130082927760473719572351370772863437729035045565776064590473391269590364238229288');
  t('0.394312656760297562', 29, 1, '0.40531978650287857279979718938');
  t('0.5', 92, 3, '0.52359877559829887307710723054658381403286156656251763682915743205130273438103483310467247089');
  t('-0.406985212', 159, 6, '-0.419151129527243486161300933330947945223874047750892904179644245782956061952665906096795108173947584241676808738263013731472508905743460023185159960454438626154');
  t('0.064332920383975164370401235469901975007049650079551544946077709238737771334483187153904397255435366074612090872849570788134249712080997775304067097175865106578146332458112484673305247923889429428098776162265283321775309873493128', 125, 5, '0.064377379275763748592750374958154702836270661766534926277598415931952497731199859888069888246004548972990930351569758549789072');
  t('-0.2789868837749', 121, 3, '-0.2827389419789747598536169720966635075340424628000030815365087353883046091260706768092622135219037168636951781574064354269');
  t('-0.30398926995547', 44, 4, '-0.30887731096143812799697728103003266915104565');
  t('0.13795', 35, 5, '0.13839132595279486312092953448864801');
  t('0.4746616444925662902712387971470961772169839975553220502012003569096118222097520330266055787608208519587736192454363385148549851985291158050047425281788436059785440354693123315881323899218731800020743403139912656295008245670548986951137561356936', 260, 3, '0.4945795704987890345365239882303093224770147479518839938219008955326437277816878523960615925654657974516355618386621689857315128467516639005137900842041733167105173718226466755631105666673833736351508946846830562526860910738623979968571560874681673213508622115');
  t('-0.27297258208020383347025438891284012703605554162', 37, 1, '-0.276481615087487211900076140389505358');
  t('-0.203953336010448938724967132838289411532273775536', 48, 2, '-0.205394451375850066853377847528761489636998668219');
  t('0.628779550241498924270377858279819', 233, 5, '0.67998267212538949700396169561578251347799175875930446489570218002792232627659781882295091712675115914000139763454333082983405825665119415250804596214848188657330519697834171125018850633800277291000782014255597243030106735521226352689');
  t('-0.042595952938386', 105, 1, '-0.0426088445911532501809339977453832829108712076786843649435365812411562856487397507647466455495007624891822');
  t('0.990505523', 278, 3, '1.4328866510076940505350144764110147755564834743473897500128204007524101815616380771904565018638112718698755837095784752351808288417770386055429974368751169169376106196306779969663824172213505654886214958071223119059293288996515089955205544675371537636583475155515236251697320927');
  t('0.1319108460101759428196806569841945936320018', 210, 3, '0.132296424684377955553358481338006289588658209211944463014325517203267289164093904391472924215198430672530840500723982014981515573947605314435740530999657833720666905428303962227857859814258217628275939695858395');
  t('-0.3396498993526138405598531688251263583878275337854587573808368079736226277227713', 113, 5, '-0.34654464356125258648686752932699867756441076797443548860154879767604489414834611616351082303382695160979966842989');
  t('0.347470366786306510245', 12, 4, '0.354872024686');
  t('-0.819308362592220273075', 48, 6, '-0.960203674302934430957194909696200595217969188559');
  t('-0.87090459999744810546807754240305947936189564314849678226', 55, 0, '-1.057039996975862465494803874395149096063732977069076254');
  t('-0.6147449074744', 180, 6, '-0.662062502217544144947459783591527790562047772815518843581010120472146004599519949615968029751664098235204433525392133054983697291390882946737520896277768070557828415697706187634614');
  t('0.098747943443777265', 237, 4, '0.0989091362065310738725930960293416905988553734295179874222934317687863202602041510316701768196292411759007407077527691402892308345358731766291438308753224229436814257813943401213427019823321041054980785103092588772672763716598267691930009');
  t('0.2840011569167', 161, 0, '0.2879645294742343534669730017936291172044829604377197717083708150048712596393211810959587377785978290191990610029113634232481158163639715854512324663378090332018');
  t('-0.4553358203248290915830488600703910069130746914671345860193710247910765989', 242, 1, '-0.47274936845008394936082290033909953045116358336735558782822377555134428468362752501850394277069208032783623254189460940620597603922560181810979694061563376515543821418804620287969411884714933662450634361367053308728090744385132168182616825078');
  t('-0.4365168181289', 73, 4, '-0.4517235113672798233102652008582346640042367882401894935708868140507773879');
  t('0.797045540648947489303669241095458699584508184', 109, 0, '0.9223871587099068246037637777542711757458864060437676432103532293992884116666026214446389288119163264873173246');
  t('0.82386366423444139268860400280456149', 153, 5, '0.968194399677324760256916731275417361206186546250614190518275975749867590205578326333253077031915501825694577391267819004278710512789857914606037568455336');
  t('0.898378069622536758006718026367395106408691541519773650063935991369264505682194', 277, 0, '1.116062728068253921166966470225624559902918500411753300013458609611704932975449101761284720252187538898065720676954253117841920578819888483607802560132513907179706617296650478625109941303506348792570480336447137976660550110825257512268009946515516378628674529584009293913980897');
  t('-0.7090461713582538521006278403251002842597945374149287341621856172417569888799', 312, 0, '-0.788144650326741747489426350418310820485591557675394357268689157277511744507576998255452367833173443259877357324690183810006210811325657813801404449645602696163770780898121606770310624321860959912121132289206827972498317724797815498905265928388805546743354759962414877159739737942303383435899206963975380008156922');
  t('-0.0035010845521612124911674524088346982303944053123528', 177, 5, '-0.00350109170467893923139739824468958128519846308163436105827332364932129026073067861155960117161729511879835589715734159703955709917327185404692876942432403515761863203555648314137');
  t('0.6516002529', 165, 5, '0.709692116338926336962325961815002848263480827442720808071830502896315126514228360679414839157591924560033785677250659438816798008829139202560728668579694470658475131');
  t('-0.115151757323', 31, 1, '-0.1154077719018448396984374365118');
  t('0.14747107052', 93, 5, '0.148010896893933098432417539106379022742797530974396970202749125951001792145184521773039116418');
  t('0.19715', 229, 5, '0.1984500106528849668339797158607602737590431245054820491510275431662437027124143616783849979636216854595439961969102648640429911773013105470655424187941990381389137489027153509888923228149590971686824974525622770664310977641295899');
  t('0.3130369721', 43, 1, '0.3183890392543425662545435195302947707924379');
  t('-0.8092088788025011778511562073819364271696454963807373950547581694356156745509', 278, 6, '-0.94280432274424648553952369519948572886798851191173799468615530416741472018903751599413727877043759711387953160387393904797042586984704849186257992030303170848944009837564635223469592529534001256940167933044374084968078026319407788949769160030368898557993417090220134933557077822');
  t('-0.2795174596393597888986509541421584417491049044378435816715262007411766540140618081245404784042748773493418500911542844960213049107873449', 179, 0, '-0.28329149981802802404941754582507919974569014647935336974940899577264257893354415844503696491709887609123031854052066087408804521414123699819622102647915198511035497928924538010456');
  t('-0.794736433', 25, 3, '-0.9185732110321130107983428');
  t('-0.8178910338775543371628772228698509268729654299140695573677875389817857028040819934297156101699095544814698344', 192, 1, '-0.957736022904018480065707113750512563781471936472884821430445260628716812690378665408029581610907728838003950336297460798575543868429549568527876799479700611875881725114626246537162334712180747');
  t('0.2827762785550365029215596998820919441903493859894013860572574563502298750313941543574098106445974833949724508257080942742145781554959603842565547655600328499372383412474174795542019669428415104533709787692609650990429595570087260590411259414907816343551242493024338009388993418118009495900543365576', 179, 5, '0.28668729076971747937989391728596615585176394558393370211156775058721695063715420410243895523610276310294731058892854444517997319737781468172412812130805927142824058735820793418824');
  t('0.127', 65, 1, '0.12734389909773909837046066308932778252068545168145543105246768259');
  t('0.4', 9, 1, '0.411516846');
  t('-0.3517943615774745288529706735544893742', 102, 6, '-0.359487309489057338271171371999746192086001508123700179102597596725102134684104271303274845956438355761');
  t('-0.319385520116411975090409625994837561171888', 51, 2, '-0.325080974249459778581886500570415802691523918580828');
  t('0.8136676082707783544050698201823527263300637773009242145794714232779576069682396767349081891647516894536659472311077212595961764953424256167275137026866798923672207361861949720523077514957552567700734577618951', 224, 4, '0.95043353491896225490961978788561886750741558887080265646347145957588616953534284357952274096126148526672492009673881550497719405198663277888046378041596763705154896129309520362440088613124342550391320947601846326147570481275');
  t('-0.3437971923533', 62, 4, '-0.3509575988751905488462873304283828206403145129113134982114797');
  t('-0.6306108346192414', 99, 2, '-0.682340017534027630623507983819091365261196189868468574095685920062858375350886816455545030061977143');
  t('0.6547518101559529695545869852499017207632747428623186680202292638688163905755130169199871651479', 273, 3, '0.713854212530896211570127487142474929115458390005682178209263143010621164281247265482625370898988167360609899706688536563968873955288242485893562585644649992773779362900413755832501858875468109164181996298396283661260788007123883963675589629890544669932800499903965218404089');
  t('-0.4', 106, 1, '-0.4115168460674880193847378976173356048557011351270258517839467807000952508952740024481263162520611953367592');
  t('0.304194771', 140, 0, '0.30909302778062347927065981448510380004853388916655345978850229761360971470408851519437070473546081343474064086076311965886151839514708877861');
  t('0.8', 59, 6, '0.92729521800161223242851246292242880405707410857224052762187');
  t('0.6339630356492806459547093828118125860234300275008119265052405980711428286965762382508661432', 206, 2, '0.68666693178255364291546142634275155174691433389615914459928705139181396478121268407077731712256013214921715962500475256375298759038383834516075341568878265147751259997270572109862709265806273599154237176018');
  t('0.9', 256, 0, '1.1197695149986341866866770558453996158951621864033028823756818639144375371065333366735674400308878320118633139461511919036868184064869980955016266192921809616426396073547434413494291322739641652375873379505689491916036275099050120332080857244050916727454');
  t('0.39088', 56, 2, '0.40158746162163729639130344367382663094054604807210634936');
  t('-0.04335513884011168072954465341733528056', 14, 4, '-0.043368732553151');
  t('-0.61344840302336828324463379545127254998575860513942879935394406320556208412149814648014291320283919662399660318053505677227925834303532986477228385014727744226860533699', 41, 3, '-0.66041975738608492839641006449799841565997');
  t('-0.97496473741637150699996550201344659329898699135802440097058998993250310943354472134722074959708825305493047889324606147702840083911962724599548039662331478757', 243, 1, '-1.34656240268045339484055040907240215947407025630324109229039573984750171364509733411723528775003678584277246661191146146749044760025700655026034896147107142197550903996330391856428159633833951214774729283534199691599786795542133957718405139985');
  t('0.56622710917892562277930945251014972', 185, 6, '0.60192125341343663130596917752280892951449416699485957628801888620404724042501014023880428798036054261303465891775822649525268158833455891275889693140679322216315672263875732115235009154');
  t('0.6613414289596791706252003237734400632', 76, 1, '0.7226057233550936762668597752839732163185951958699328881794461827083433075433');
  t('-0.26864723058092474840353332422560762604916979168548356789093088524801517742718047509156928811127801', 49, 1, '-0.2719883588856119454620078335366528313283677344209');
  t('-0.7040785437616639169752909209312551549294762619655', 211, 4, '-0.7811247071540582463529861590370091451626482693317742711560764088950077987971462951755360193215197248165533300353947418186318095835006238476313751491837118668928614827215494543546299589359242336555747529771985031');
  t('-0.5967174762', 87, 5, '-0.63940423670925451040112385795056860979879343345373773546000071737606521758975919850213');
  t('-0.6521405414069705179755278535', 214, 2, '-0.7104045875105225682410178481650389987157219767586558871395926453475243067795778603038642886658479193991528310561760079529638850745910251288990110067151252091069816003222915282969549105899708870040948171626139674595');
  t('0.290970755970642093753646717178826463776742734', 308, 0, '0.29524133967314125132234651507617537279025859048613025058824948628470287546136371077112346536067044892167192837384980844354642995879087003395369240880535429409313487085191684015665072165427778933816689218994023693708175765765323319465775861903933707123422746718665373832688839208229999757198124910604890566976');
  t('-0.9088203013', 148, 4, '-1.140447554243191977839732815976348108663238722078422349385301529708516749824397168046731839562711585488393876717394548113900567541345841940847523023');
  t('-0.2408622840808351182486594232472793828779256034464681904431999914539918538177219697759317859980180302166335878', 243, 2, '-0.243254193619656756933739898713660551797011983222179422017766517741087994487744302381788202349864622438247634052739751657947564997954085720254914482588815072679605583018321873451786436903015258747213452644653384598755258904772417249814961267564');
  t('0.609618683382411268622490328344324360224222235758420083244027582007942886586856963581', 303, 5, '0.655579463527432707090546204170992299185574451274211090058608216520391794796777138416881441699980715376483937939555595100324683736991965072269498675599377664561757016556362988686054072295475002402976965060993133161902706412702905247801035084311921450475620564326724137089795795862866058933795618632525185');
  t('-0.0055805', 274, 5, '-0.005580528965042712311445936438418212906718683460846846572319631601096888896809454356192310820963010587741650952460847225789971031599982324853345189755989151394786856970422111062918762548631074239691310729916628295166883452355823841168482391792865349473447881473543324801370071');
  t('0.8829894', 156, 4, '1.08219319518273408878029104503112253369493284450895699634026165716513488006702758918831316725914947086605416306233784317804241188014511768452446021927481247');
  t('-0.63645997783812633836470933948333787475757914134459832881111403693150139546829126728749571862569677847031031', 229, 1, '-0.6898999006886794305350727355185581932000585241509500182033271903399492699129433216244574379483174092168980521236494902638269816419396641762122594080965284461605677781066785966776289863027094969465899135956327834134418118502068427');
  t('0.1277897601173343793336282237792550769322', 288, 2, '0.128140147002831941781570330315004622096003542359665546720767020100380456068057744440981211445228352927703494574645369682048467701466599529901205657847144598932153446211899755614460810545848493394174599621006148803556895222006113446738027143287052538074525259223781859761888971901740066569');
  t('-0.45484196892369044791751455185622831980749388445389650176384849994953031326155440179416239491136134', 115, 4, '-0.472194757158115855173355552713494003607279366353559852721547586095207784358615368325397474528307657165851187385158');
  t('0.115351', 107, 3, '0.11560835116765349824387588927771061499617405145740470821764525878167532578160818135618278075799845148340326');
  t('0.49113784006', 316, 5, '0.5133955104391799841725572091146592371538717224456469775464006608148391687650718538819454166524134769347448346975576131570036120442284360059363006249893794393398597921500812620876704663943967564769211389673181192949081318954111934082886011284256822534486146568118025373848859084238364725038286297188249666200855378999');
  t('0.54183276131811567459312606026005995910825808600999326923686945489140624693183809359787663658282604320429914007', 42, 5, '0.572616176824019338359998743764887028590431');
  t('-0.0482680519146094340448225576649852693032313844709640842708727510230875929072219015873503', 17, 0, '-0.048286814115252291');
  t('0.8147960134020575817491493', 226, 6, '0.9523772538366392986677487672095659951452997609782250515777892433831849728451101501169048222792713586421337691013865079780930234855640416199547395410042705231289598004454521126879170091309609240579614459711872038284609452382416');
  t('0.047687', 101, 1, '0.04770509229051474471493983842950012879012222908032679975298979769124959326443666873921208777005233374');
  t('0.400490847152926227493022819263474379728', 36, 6, '0.41205246684824449728857185713887277');
  t('0.076711', 51, 6, '0.0767864352326065672356988708668838076349497516950746');
  t('0.48924880342545', 309, 0, '0.511228223172015967596781779046839862827649118393469795389563025063971009183310977792162648934648138986287596089113210623764608681664987701391013356880488091529087204571375138593473822860474242053007209366613097984894275287444422155689986187318814343860531143959368436632267846645265974842490047799971336541177');
  t('-0.1590044125696567894', 171, 5, '-0.159682154243990129991828919361095625427440629921080219182964897359828217792772691761490476247540604985939350778160375146273974746443091772870441329506160967060698650882802');
  t('0.477114354340282734', 117, 4, '0.497368308318675873205394968377917652836721820945493503242200939815709292416105643940310683101430871176830828877247157');
  t('-0.030089416945431374523342993802590679498', 56, 5, '-0.030093959153927118895563909371353932795553346621144309701');
  t('0.9248389439877181972310393220783383319591813769296178231129769388374245977285175257446687911279999880455799173798980575677', 44, 6, '1.1806119441436781033967869396227809392123162');
  t('-0.187489873', 214, 4, '-0.1886060763362773360606999545653773759668203591031152776275386706361250513301288566224821970175401576653623337191567481698555934808219729385248311247877497479541035268763932232147409761143419714154934949134099270583');
  t('0.689583358058704619619521095769784813', 301, 1, '0.7609135867028723671937512764158215410177847212391355398846980639269096967670675550870761125521338030634915293482365090543566570475555173976447470118067142194362779856700389409606248298134102987686803493332036884507321152684857983279798335280987942185187264123730747240571970058634737190399566661613536');
  t('0.864295508050287135701787834755100253655441951745957444829108964642320332637794337', 140, 4, '1.0437480577179911926322545427380191847165915544378505354299703964825432370892546105998972912705040198929944911788321147928335138854395351426');
  t('-0.057593585315', 147, 2, '-0.0576254727911039267841843674616767668102282747897303747720704250987293798031093732612161074671404602094500700088031925754170590306561051705986907002');
  t('-0.9157609557092389866947796298923918455543', 115, 2, '-1.157398076625941446421483893356516242496259311136417026207062363132501239687091037722896563866978369878134054019089');
  t('-0.7895869037392359356956095559146680489133004', 125, 4, '-0.91013551425631469441529508780968647162079278116394455802141788012697263436149293934946913448474070666638489026579551100648131');
  t('0.90373837159733070834237270993002057133328', 314, 4, '1.1284233482037720895939485471976291624245623466540080072880372691910508956740979643173007838374393797257146433044932933523229881994411161194371426056652647412021650366098522187742288903189671824231639710452221532721090521102633075588289095066663855258024450648966057057122552692518412057591403862376111509321849503');
  t('-0.3134', 258, 1, '-0.318771302211125075009585645164765066067753035925129465554946595995600426758605923737539666390184296704424418086818870810421720646867222172321479336348377092329651236469392752921824788708136905148875177747824216268144332691741499433796411283705356267655740407');
  t('-0.92321797024555211504025596969164119785792394519777707774', 176, 1, '-1.1763720912665937892425066064885711385346113110476166231456974293465371482722007739351821964621814337217849512831595854111102828870697561585740190873962619376742510989888887911');
  t('-0.7', 21, 6, '-0.77539749661075306374');
  t('-0.473237592166879320274820106309', 29, 2, '-0.49296234326425402920406167446');
  t('0.97479857176822531148564204464605634745805609931', 7, 4, '1.345816');
  t('0.03078045172592011249531263462381405030184076623573561200440940431449097198371086', 226, 1, '0.03078531421839076316548923869348601463017683682576874752022867361866456871111223460707404245017156331535104987032746483833436950750813991141549018685041848674393709301870530913846924024617974092939171543304276791825135899491045');
  t('-0.9037702680153042636268', 220, 5, '-1.128497863570161678510229879652962981431034319779895858476793903777015432979137254160918038576042752240965414432748973261537661447464801403843752336383050705829370276252247268954000644884198914747319143135601324295238846');
  t('0.6934026260236015998623446006885692415413066025066611875167501424144144144100167219157183319356255032836427754532', 180, 4, '0.766200648761702217564687835550026933737171098104302302135353874278450359027201690408901579721339684226252564315381514113391153922622188128152139915667360288209137277124723105155129');
  t('0.6817875805781', 112, 2, '0.750203412494142462810562588602076026065792808585501470997508940050462000684924954003944215500094430437775255744');
  t('-0.863219921531450595020745745616864821640962209465031', 293, 5, '-1.0416135610923886684167687965161815814552955540014934839969299208393182629793975611815318448922288129405102085187992591405660180761094043357244481894642536476129451002752675737946120990417848227884254776660939115159020965910830809163046791461804769245302572722582404585838618161768668420927916');
  t('0.62113', 75, 4, '0.670183745172497705305012968016785178206016340786050650653833433533018248989');
  t('-0.97081483', 81, 3, '-1.32860529606315957519091964178369207510302761893723560671174570022997004472860298');
  t('0.387580487094289', 53, 2, '0.39800547209797859195552166169007747909698639304945746');
  t('-0.628165438989060313515969132913809', 31, 2, '-0.6791931553014339088410184352774');
  t('-0.158087022809689825416865009887227952442623762830709624972834645361015952497326409059932573370885048876720822900214666764342589889287217285948942049549889055980741060665729131160549', 228, 4, '-0.15875301232434135149108980289780049536992939442289065689531936435693938424293382483169033959033175428904155783593764816849547014253915143053059480782095043160805716319676175798099334112094097083189037836553222907260030469465319');
  t('0.4104213810027664745105970666208572279928708', 174, 0, '0.422916107435853097843512790878490430109162312644323362917405235378392700108275517499567388238907282636511100402454243878296733544493814366455191162135100537744461586857381221');
  t('-0.301637201655712139', 131, 2, '-0.30640937194210207446838914920267609876369892349272459255998465781442431279556039810798580870973962757869803532302324268562501717977');
  t('0.93482237202302541890014955753899910808492252711183177369097336073229110133181533539702', 290, 3, '1.207758537204826518005533764307993644324579869822335131080718273333521010735394568676127862423687334840815988536579753814518190271420519432391332924308337047188485208654952502735188926001007864314773257118807720841601531494682183457461987115516352623615808303649212572143802541192729203488');
  t('-0.60135674038101002975715591719470926172466902870325074455819667984171374350542892022303834077988171737140216469043218185382701870371298951774479334400178', 79, 0, '-0.6451981150201027798557008850809148652230304949184771321630399645075788820442644');
  t('-0.8330039798743065918', 157, 2, '-0.9845152278318006801810152435085322537118852068100517794847927671464767330771681907951727457925602090457560511257395328263381467623091737327707106003215009121');
  t('-0.03141154528', 36, 4, '-0.0314167131259140457896719671245270669');
  t('0.2135891659403', 107, 5, '0.21524744116105895112244229626832287025944541377052049375178644229452752016261032422476805752402395174702717');
  t('-0.9067678263839312699737232810857432825846039828815374567987661253922195613524739418049422161264620225057245670213151038832879847003106408997998490845713', 19, 4, '-1.135553833366382442');
  t('-0.631557037', 154, 0, '-0.6835597994159409512220454917556427485102212133329624700200669685307652705507126419039826867112001146860965574075844419488693982709108131829291650194901506');
  t('-0.92448229679999', 75, 6, '-1.17967535094344628992400549122932268589945313798155333398438877720113831443');
  t('0.7', 203, 5, '0.77539749661075306374035335271498711355578873864116199359771996373272021188071119886541090349437287648129472101138705301547788468547740235492287477310723027451717074493441834074179947639522164121434429874');
  t('0.120429790041444089332511', 177, 0, '0.120722812092234512061617081038475621145231351148142571111287929778199332874130079342665172603494995670787182301996813939205506850969549599297747018586794586211120953345128002584');
  t('0.76728455902896578739', 190, 5, '0.8745961281044826926383496398320236849027998190593924050869565055832491194951443188311622672266199969052511512621859303129383628857337850527442452548251171917515064484987753163379905963640884');
  t('0.676296200403884761984554383963773739103469225089572473977466419891176', 189, 0, '0.742722920183546013078569385290886238515893939103498729099945435527438770974681193906280235406562153062565388976741299577308795194687231073003808723089948035909071580836918761852320297503082');
  t('0.556', 33, 2, '0.589565588210120864401647975826429');
  t('-0.68679290629119645332547686986653370136210024817509327690799310579504307950013541', 93, 2, '-0.757067502672989843307400442740906556271718026897281754636743349561322264190122741804256479838');
  t('0.7619810871193173482427486', 211, 0, '0.866366758880222391327473883329870957914108474740314099631926108609412129069607338398040756223392725609940720559933417146379812487912950770698702945540267787480136043793433931773433147382622967106777837309079768');
  t('-0.8657', 25, 6, '-1.046547109974487548310733');
  t('-0.8181007854350594', 257, 4, '-0.95810066616043426429338879741136047038307098991559917199261755571190052797315814381069383622510084503706253007288657933211137502517377208924080332212039673373856020557689085086284079771855525174537704063731936575685871277348272982725140590787184883205424329');
  t('0.80865180712682725', 279, 2, '0.941856767800203289218163773589384613305641784388663137032935726265118209095169196684230053484024665444320053696016424457399755651076319974837573527263444678644658507338033896305716632156880694655972288306460137435149785686960056444100099241803785518134545757293120453778408568103');
  t('-0.7726303476763987327537627319872388678610009813347101199442418136589738280153442132516546850266039567531202584662322156750222212609899267223227264798428383480952961509104467781295599401735168780055', 319, 1, '-0.8829739882385629896667408463407462946704167918806868048790957243650301892287013511117302473814856033870868793330857026089057825685583076636158461502512022853344766659776754110585194510756446853584274994997983708835532535826504053831417589668721195804156312689141138779934940296486865014867755021516155129000501935515042');
  t('0.916549881035908422824586778006174242215451043203042011231843927228267667256328791624281428688937943427215987008872491715754899323168914976801105727312939150604139732246800117685956087631214355020428814640400731618393520972774258261858754223897342275028505', 136, 4, '1.15936634448360989137682659287117342547366940530805620925133871731913895858437111238286462073031716077080843793183875492472045460513897');
  t('0.6', 117, 6, '0.643501108793284386802809228717322638041510591115312382865606118713512474811621088712816844701282748878014338754259478');
  t('0.34512056055', 103, 6, '0.3523672349709244910421999326736380677853490082181533757200161368223188597440200695838164406449177060587');
  t('0.71', 159, 0, '0.789498209346171973007618860883623899916092318857675760459772880703734515802889468146046713104844293677712693132824206808022709769831768944355875090888108522134');
  t('-0.66754582642750086470936489041597467654', 129, 2, '-0.730907795941491817093895133790511650131954192418424954785060201122486921691288200136315015053425931212196680609350523303374624746');
  t('-0.043994800903461', 95, 6, '-0.044009005580335017761197173511358349798378935926146449342537138167677790368106167459999226067585');
  t('-0.433979067962794142505294965320698152072552457191776240092746227667', 54, 1, '-0.448904760244579815796359404337616922277459596923467241');
  t('0.66', 177, 3, '0.720818760870089630031882975302636698716441484371244593399029329865687658168744092978266008235694436693704496371524853690193943742068348914562673095345905009587901248929444739089');
  t('0.91457420620989418033892', 180, 5, '1.15445380872948558079499534442464488242353605743569440430015051530922511426436827787382705424659475744862009029274837879787942942605882536544158149964619842990259764135934087983113');
  t('0.3906916562062902', 184, 6, '0.4013828472246966916285365964789087919399154830332428990369840346899528831817910443467633097906952941427016092641853317872370208304538503710728495306509572201918129539760084495797577653');
  t('0.55186528072680064415498724206645668894582', 136, 2, '0.5845993133717524218549519324150897536188312199481242371133357862506955777907389528802754988370336731170004116359976019574804382331427813');
  t('-0.146075234997972772', 109, 1, '-0.1465997790942712676825653753370189416918213270912295246242873361384311775343868912415051529401843392789372101');
  t('-0.550024', 23, 3, '-0.58239297498899539206011');
  t('-0.16411137353265355881681540111707250634273067', 184, 6, '-0.1648571034484768946302891001431212658344993821627879939313892351117777688597317785881326661687582255839702827637329740737537177159458613901465637224797605786855054895024896941560098374');
  t('-0.6866959219', 150, 2, '-0.756934080566579109104643337594548983092219733274024346686125954546767308573917671928802228176792493366930184477242390254356108873509595652131419113812');
  t('0.54801859001717359916354', 49, 1, '0.5799936078873280810110205575411395390191087669864');
  t('-0.46135770851334328045026394081706', 141, 3, '-0.479524895897516605773499283499192379589817254644453767385087681713398436355361095508420336207889443599830200565765406955721820825483055719875');
  t('-0.402559966751262129147022529711724533594874586968946698089210787246011996074554468386301178673775759', 210, 0, '-0.414311706976558760039501533006652998040983220339068011692833014608955560239964728390507951809285684286664911105014012292373919475760295674403999535458235668527750915569927564100858663303466485301517362383716547');
  t('-0.4683088899874989429974131559432712019786643642466105607421541118589099450073586143', 136, 4, '-0.4873758424536772738317064839528394277408125312902863483637402110598125114755636583929787554760557307190866224939069103052711223987513435');
  t('0.27537677436513', 87, 6, '0.278981608113443061302204521265589288726702807332465059850035628109315137980579961704831');
  t('0.074', 51, 4, '0.0740677043033278163677656592882429618178769948075489');
  t('0.44389577110482845644258561284830564129050187564514', 26, 2, '0.45994159370835232141671786');
  t('0.79151456779862000548551102596495619937826857107625227219953412150705711268861417391389828512169697782015482937949589397871232469972917270170769477448', 80, 1, '0.91328326032801542880239730508620623830327298690925394298003776764030700859387389');
  t('0.6604483265339284113463550547604328503461859', 101, 2, '0.72141567911579108300518209234859278779110897839208168798772642868286322946391455737034328738154270136');
  t('0.524828857', 5, 2, '0.55252');
  t('0.9753104368788756558159787785518486414813770242171223696223603164410618', 134, 6, '1.3481224256497677178017589961876331763675683010476435544661018020130097421729831896635046187698372513391349429527038761918273776681759');
  t('-0.8439', 99, 6, '-1.00451152439708133592915833193380988899666075772544132473189740420096646266079249974274724905765428');
  t('-0.765047086836804', 32, 6, '-0.87111444636980265344878431431314');
  t('-0.8646385624839085860887672235696491', 238, 3, '-1.044430495866221973145197696021981853148111832744033405575782471076644427452810684805391062963538010063758705644886727950240364969925221546788290213560383009092596798009011517979822830786617624969047623316381933738853914843860690504891514');
  t('-0.4589236971374261691850165693145765295308234867706948289043405', 270, 0, '-0.476783415132947908323642346259679690310623190718502202457793869614477625418296545623040346622666841833050681869846098236599936798256093939478968324630131801115831334718884365127843490940903855921608694383526100581608513861150157490842959672063682212981196700083869986192');
  t('0.3896123202596462640243469782579072859666092096691018020981352451', 145, 6, '0.4002106120989776668931051758718787991367561875356896388646369850676906617494355205656926402325949310714153999882796007787625156219933889017506432');
  t('-0.303', 254, 3, '-0.30783907040876792121510536109523187982242884051368525496594226813212357419698266185959575883139074602781263663734367163737121385086938445928188265807214271585884836376698829544634456224901961507384983017559267905307575220542265905880239862946724365803028');
  */
});
