## API Report File for "@microsoft/fast-element"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

// @public
export interface Accessor {
    getValue(source: any): any;
    name: string;
    setValue(source: any, value: any): void;
}

// @public
export type AddBehavior = (behavior: HostBehavior<HTMLElement>) => void;

// @public
export type AddViewBehaviorFactory = (factory: ViewBehaviorFactory) => string;

// @public
export interface ArrayObserver extends SubscriberSet {
    addSplice(splice: Splice): void;
    flush(): void;
    readonly lengthObserver: LengthObserver;
    reset(oldCollection: any[] | undefined): void;
    strategy: SpliceStrategy | null;
}

// @public
export const ArrayObserver: Readonly<{
    readonly enable: () => void;
}>;

// @public
export interface Aspected {
    aspectType: DOMAspect;
    dataBinding?: Binding;
    sourceAspect: string;
    targetAspect: string;
}

// @public
export function attr(config?: DecoratorAttributeConfiguration): (target: {}, property: string) => void;

// @public
export function attr(target: {}, prop: string): void;

// @public
export type AttributeConfiguration = {
    property: string;
    attribute?: string;
    mode?: AttributeMode;
    converter?: ValueConverter;
};

// @public
export const AttributeConfiguration: Readonly<{
    locate: (target: {}) => AttributeConfiguration[];
}>;

// @public
export class AttributeDefinition implements Accessor {
    constructor(Owner: Function, name: string, attribute?: string, mode?: AttributeMode, converter?: ValueConverter);
    readonly attribute: string;
    // @internal
    static collect(Owner: Function, ...attributeLists: (ReadonlyArray<string | AttributeConfiguration> | undefined)[]): ReadonlyArray<AttributeDefinition>;
    readonly converter?: ValueConverter;
    getValue(source: HTMLElement): any;
    readonly mode: AttributeMode;
    readonly name: string;
    // @internal (undocumented)
    onAttributeChangedCallback(element: HTMLElement, value: any): void;
    readonly Owner: Function;
    setValue(source: HTMLElement, newValue: any): void;
}

// Warning: (ae-forgotten-export) The symbol "reflectMode" needs to be exported by the entry point index.d.ts
// Warning: (ae-forgotten-export) The symbol "booleanMode" needs to be exported by the entry point index.d.ts
//
// @public
export type AttributeMode = typeof reflectMode | typeof booleanMode | "fromView";

// @public
export abstract class Binding<TSource = any, TReturn = any, TParent = any> {
    constructor(evaluate: Expression<TSource, TReturn, TParent>, policy?: DOMPolicy | undefined, isVolatile?: boolean);
    abstract createObserver(subscriber: Subscriber, directive: BindingDirective): ExpressionObserver<TSource, TReturn, TParent>;
    // (undocumented)
    evaluate: Expression<TSource, TReturn, TParent>;
    // (undocumented)
    isVolatile: boolean;
    options?: any;
    // (undocumented)
    policy?: DOMPolicy | undefined;
}

// @public
export interface BindingDirective {
    readonly aspectType?: DOMAspect;
    readonly dataBinding: Binding;
    readonly targetAspect?: string;
}

// @public
export const booleanConverter: ValueConverter;

// @public
export type Callable = typeof Function.prototype.call | {
    call(): void;
};

// @public
export interface CaptureType<TSource, TParent> {
}

// @public
export interface ChildListDirectiveOptions<T = any> extends NodeBehaviorOptions<T>, Omit<MutationObserverInit, "subtree" | "childList"> {
}

// @public
export function children<TSource = any, TParent = any>(propertyOrOptions: (keyof TSource & string) | ChildrenDirectiveOptions<keyof TSource & string>): CaptureType<TSource, TParent>;

// @public
export class ChildrenDirective extends NodeObservationDirective<ChildrenDirectiveOptions> {
    constructor(options: ChildrenDirectiveOptions);
    disconnect(target: any): void;
    getNodes(target: Element): Node[];
    observe(target: any): void;
}

// @public
export type ChildrenDirectiveOptions<T = any> = ChildListDirectiveOptions<T> | SubtreeDirectiveOptions<T>;

// @public
export type Class<T, C = {}> = C & Constructable<T> & {
    readonly prototype: T;
};

// @public
export type CompilationStrategy = (
html: string | HTMLTemplateElement,
factories: Record<string, ViewBehaviorFactory>,
policy: DOMPolicy) => HTMLTemplateCompilationResult;

// @public
export type CompiledViewBehaviorFactory = Required<ViewBehaviorFactory>;

// @public
export const Compiler: {
    compile<TSource = any, TParent = any>(html: string | HTMLTemplateElement, factories: Record<string, ViewBehaviorFactory>, policy?: DOMPolicy): HTMLTemplateCompilationResult<TSource, TParent>;
    setDefaultStrategy(strategy: CompilationStrategy): void;
    aggregate(parts: (string | ViewBehaviorFactory)[], policy?: DOMPolicy): ViewBehaviorFactory;
};

// @public
export type ComposableStyles = string | ElementStyles | CSSStyleSheet;

// @public
export type Constructable<T = {}> = {
    new (...args: any[]): T;
};

// @public
export type ConstructibleStyleStrategy = {
    new (styles: (string | CSSStyleSheet)[]): StyleStrategy;
};

// @public
export interface ContentTemplate {
    create(): ContentView;
}

// @public
export interface ContentView {
    bind(source: any, context?: ExecutionContext): void;
    // (undocumented)
    readonly context: ExecutionContext;
    insertBefore(node: Node): void;
    remove(): void;
    unbind(): void;
}

// @public
export const css: CSSTemplateTag;

// @public
export class CSSBindingDirective implements HostBehavior, Subscriber, CSSDirective, BindingDirective {
    constructor(dataBinding: Binding, targetAspect: string);
    addedCallback(controller: HostController<HTMLElement & {
        $cssBindings: Map<CSSBindingDirective, CSSBindingEntry>;
    }>): void;
    connectedCallback(controller: HostController<HTMLElement & {
        $cssBindings: Map<CSSBindingDirective, CSSBindingEntry>;
    }>): void;
    createCSS(add: AddBehavior): ComposableStyles;
    // (undocumented)
    readonly dataBinding: Binding;
    // @internal
    handleChange(_: any, observer: ExpressionObserver): void;
    removedCallback(controller: HostController<HTMLElement & {
        $cssBindings: Map<CSSBindingDirective, CSSBindingEntry>;
    }>): void;
    // (undocumented)
    readonly targetAspect: string;
}

// @public
export interface CSSDirective {
    createCSS(add: AddBehavior): ComposableStyles;
}

// @public
export const CSSDirective: Readonly<{
    getForInstance: (object: any) => CSSDirectiveDefinition<Constructable<CSSDirective>> | undefined;
    getByType: (key: Function) => CSSDirectiveDefinition<Constructable<CSSDirective>> | undefined;
    define<TType extends Constructable<CSSDirective>>(type: any): TType;
}>;

// @public
export function cssDirective(): (type: Constructable<CSSDirective>) => void;

// @public
export interface CSSDirectiveDefinition<TType extends Constructable<CSSDirective> = Constructable<CSSDirective>> {
    readonly type: TType;
}

// @public
export type CSSTemplateTag = (<TSource = any, TParent = any>(strings: TemplateStringsArray, ...values: CSSValue<TSource, TParent>[]) => ElementStyles) & {
    partial<TSource = any, TParent = any>(strings: TemplateStringsArray, ...values: CSSValue<TSource, TParent>[]): CSSDirective;
};

// @public
export type CSSValue<TSource, TParent = any> = Expression<TSource, any, TParent> | Binding<TSource, any, TParent> | ComposableStyles | CSSDirective;

// @public
export function customElement(nameOrDef: string | PartialFASTElementDefinition): (type: Constructable<HTMLElement>) => void;

// @public
export type DecoratorAttributeConfiguration = Omit<AttributeConfiguration, "property">;

// @public
export interface Disposable {
    dispose(): void;
}

// @public
export const DOM: Readonly<{
    readonly policy: DOMPolicy;
    setPolicy(value: DOMPolicy): void;
    setAttribute(element: HTMLElement, attributeName: string, value: any): void;
    setBooleanAttribute(element: HTMLElement, attributeName: string, value: boolean): void;
}>;

// @public
export const DOMAspect: Readonly<{
    readonly none: 0;
    readonly attribute: 1;
    readonly booleanAttribute: 2;
    readonly property: 3;
    readonly content: 4;
    readonly tokenList: 5;
    readonly event: 6;
}>;

// @public
export type DOMAspect = (typeof DOMAspect)[Exclude<keyof typeof DOMAspect, "none">];

// @public
export interface DOMPolicy {
    createHTML(value: string): string;
    protect(tagName: string | null, aspect: DOMAspect, aspectName: string, sink: DOMSink): DOMSink;
}

// @public
export type DOMSink = (target: Node, aspectName: string, value: any, ...args: any[]) => void;

// @public
export class ElementController<TElement extends HTMLElement = HTMLElement> extends PropertyChangeNotifier implements HostController<TElement> {
    // @internal
    constructor(element: TElement, definition: FASTElementDefinition);
    addBehavior(behavior: HostBehavior<TElement>): void;
    addStyles(styles: ElementStyles | HTMLStyleElement | null | undefined): void;
    connect(): void;
    get context(): ExecutionContext;
    readonly definition: FASTElementDefinition;
    disconnect(): void;
    emit(type: string, detail?: any, options?: Omit<CustomEventInit, "detail">): void | boolean;
    static forCustomElement(element: HTMLElement): ElementController;
    get isBound(): boolean;
    get isConnected(): boolean;
    get mainStyles(): ElementStyles | null;
    set mainStyles(value: ElementStyles | null);
    onAttributeChangedCallback(name: string, oldValue: string | null, newValue: string | null): void;
    onUnbind(behavior: {
        unbind(controller: ExpressionController<TElement>): any;
    }): void;
    removeBehavior(behavior: HostBehavior<TElement>, force?: boolean): void;
    removeStyles(styles: ElementStyles | HTMLStyleElement | null | undefined): void;
    static setStrategy(strategy: ElementControllerStrategy): void;
    readonly source: TElement;
    get sourceLifetime(): SourceLifetime | undefined;
    get template(): ElementViewTemplate<TElement> | null;
    set template(value: ElementViewTemplate<TElement> | null);
    readonly view: ElementView<TElement> | null;
}

// @public
export interface ElementControllerStrategy {
    // (undocumented)
    new (element: HTMLElement, definition: FASTElementDefinition): ElementController;
}

// @public
export const elements: (selector?: string) => ElementsFilter;

// @public
export type ElementsFilter = (value: Node, index?: number, array?: Node[]) => boolean;

// @public
export class ElementStyles {
    constructor(styles: ReadonlyArray<ComposableStyles>);
    // @internal (undocumented)
    addStylesTo(target: StyleTarget): void;
    readonly behaviors: ReadonlyArray<HostBehavior<HTMLElement>> | null;
    // @internal (undocumented)
    isAttachedTo(target: StyleTarget): boolean;
    static normalize(styles: ComposableStyles | ComposableStyles[] | undefined): ElementStyles | undefined;
    // @internal (undocumented)
    removeStylesFrom(target: StyleTarget): void;
    static setDefaultStrategy(Strategy: ConstructibleStyleStrategy): void;
    get strategy(): StyleStrategy;
    // (undocumented)
    readonly styles: ReadonlyArray<ComposableStyles>;
    static readonly supportsAdoptedStyleSheets: boolean;
    withBehaviors(...behaviors: HostBehavior<HTMLElement>[]): this;
    withStrategy(Strategy: ConstructibleStyleStrategy): this;
}

// @public
export interface ElementView<TSource = any, TParent = any> extends View<TSource, TParent> {
    appendTo(node: Node): void;
    onUnbind(behavior: {
        unbind(controller: ViewController<TSource, TParent>): any;
    }): void;
    readonly sourceLifetime?: SourceLifetime;
}

// @public
export interface ElementViewTemplate<TSource = any, TParent = any> {
    create(hostBindingTarget: Element): ElementView<TSource, TParent>;
    render(source: TSource, host: Node, hostBindingTarget?: Element): ElementView<TSource, TParent>;
}

// @public
export const emptyArray: readonly never[];

// @public
export interface ExecutionContext<TParent = any> {
    readonly event: Event;
    eventDetail<TDetail>(): TDetail;
    eventTarget<TTarget extends EventTarget>(): TTarget;
    index: number;
    readonly isEven: boolean;
    readonly isFirst: boolean;
    readonly isInMiddle: boolean;
    readonly isLast: boolean;
    readonly isOdd: boolean;
    length: number;
    parent: TParent;
    parentContext: ExecutionContext<TParent>;
}

// @public
export const ExecutionContext: Readonly<{
    default: ExecutionContext<any>;
    getEvent(): Event | null;
    setEvent(event: Event | null): void;
}>;

// @public
export type Expression<TSource = any, TReturn = any, TParent = any> = (source: TSource, context: ExecutionContext<TParent>) => TReturn;

// @public
export interface ExpressionController<TSource = any, TParent = any> {
    readonly context: ExecutionContext<TParent>;
    readonly isBound: boolean;
    onUnbind(behavior: {
        unbind(controller: ExpressionController<TSource, TParent>): any;
    }): void;
    readonly source: TSource;
    readonly sourceLifetime?: SourceLifetime;
}

// @public
export interface ExpressionNotifier<TSource = any, TReturn = any, TParent = any> extends Notifier, ExpressionObserver<TSource, TReturn, TParent>, Disposable {
    observe(source: TSource, context?: ExecutionContext): TReturn;
    records(): IterableIterator<ObservationRecord>;
    setMode(isAsync: boolean): void;
}

// @public
export interface ExpressionObserver<TSource = any, TReturn = any, TParent = any> {
    bind(controller: ExpressionController<TSource, TParent>): TReturn;
}

// @public
export const FAST: FASTGlobal;

// @public
export interface FASTElement extends HTMLElement {
    $emit(type: string, detail?: any, options?: Omit<CustomEventInit, "detail">): boolean | void;
    readonly $fastController: ElementController;
    attributeChangedCallback(name: string, oldValue: string | null, newValue: string | null): void;
    connectedCallback(): void;
    disconnectedCallback(): void;
}

// @public
export const FASTElement: {
    new (): FASTElement;
    define: typeof define;
    compose: typeof compose;
    from: typeof from;
};

// @public
export class FASTElementDefinition<TType extends Constructable<HTMLElement> = Constructable<HTMLElement>> {
    readonly attributeLookup: Record<string, AttributeDefinition>;
    readonly attributes: ReadonlyArray<AttributeDefinition>;
    static compose<TType extends Constructable<HTMLElement> = Constructable<HTMLElement>>(type: TType, nameOrDef?: string | PartialFASTElementDefinition): FASTElementDefinition<TType>;
    define(registry?: CustomElementRegistry): this;
    readonly elementOptions: ElementDefinitionOptions;
    static readonly getByType: (key: Function) => FASTElementDefinition<Constructable<HTMLElement>> | undefined;
    static readonly getForInstance: (object: any) => FASTElementDefinition<Constructable<HTMLElement>> | undefined;
    get isDefined(): boolean;
    readonly name: string;
    readonly propertyLookup: Record<string, AttributeDefinition>;
    // @internal
    static registerBaseType(type: Function): void;
    readonly registry: CustomElementRegistry;
    readonly shadowOptions?: ShadowRootOptions;
    readonly styles?: ElementStyles;
    readonly template?: ElementViewTemplate;
    readonly type: TType;
}

// @public
export interface FASTGlobal {
    addMessages(messages: Record<number, string>): void;
    error(code: number, values?: Record<string, any>): Error;
    getById<T>(id: string | number): T | null;
    // (undocumented)
    getById<T>(id: string | number, initialize: () => T): T;
    readonly versions: string[];
    warn(code: number, values?: Record<string, any>): void;
}

// @public
export interface HostBehavior<TSource = any> {
    addedCallback?(controller: HostController<TSource>): void;
    connectedCallback?(controller: HostController<TSource>): void;
    disconnectedCallback?(controller: HostController<TSource>): void;
    removedCallback?(controller: HostController<TSource>): void;
}

// @public
export interface HostController<TSource = any> extends ExpressionController<TSource> {
    addBehavior(behavior: HostBehavior<TSource>): void;
    addStyles(styles: ElementStyles | HTMLStyleElement | null | undefined): void;
    readonly isConnected: boolean;
    mainStyles: ElementStyles | null;
    removeBehavior(behavior: HostBehavior<TSource>, force?: boolean): void;
    removeStyles(styles: ElementStyles | HTMLStyleElement | null | undefined): void;
}

// @public
export const html: HTMLTemplateTag;

// @public
export class HTMLBindingDirective implements HTMLDirective, ViewBehaviorFactory, ViewBehavior, Aspected, BindingDirective {
    constructor(dataBinding: Binding);
    aspectType: DOMAspect;
    // @internal (undocumented)
    bind(controller: ViewController): void;
    createBehavior(): ViewBehavior;
    createHTML(add: AddViewBehaviorFactory): string;
    // (undocumented)
    dataBinding: Binding;
    // @internal (undocumented)
    handleChange(binding: Expression, observer: ExpressionObserver): void;
    // @internal (undocumented)
    handleEvent(event: Event): void;
    id: string;
    policy: DOMPolicy;
    sourceAspect: string;
    targetAspect: string;
    targetNodeId: string;
    targetTagName: string | null;
    // @internal (undocumented)
    unbind(controller: ViewController): void;
}

// @public
export interface HTMLDirective {
    createHTML(add: AddViewBehaviorFactory): string;
}

// @public
export const HTMLDirective: Readonly<{
    getForInstance: (object: any) => HTMLDirectiveDefinition<Constructable<HTMLDirective>> | undefined;
    getByType: (key: Function) => HTMLDirectiveDefinition<Constructable<HTMLDirective>> | undefined;
    define<TType extends Constructable<HTMLDirective>>(type: TType, options?: PartialHTMLDirectiveDefinition): TType;
    assignAspect(directive: Aspected, value?: string): void;
}>;

// @public
export function htmlDirective(options?: PartialHTMLDirectiveDefinition): (type: Constructable<HTMLDirective>) => void;

// @public
export interface HTMLDirectiveDefinition<TType extends Constructable<HTMLDirective> = Constructable<HTMLDirective>> extends Required<PartialHTMLDirectiveDefinition> {
    readonly type: TType;
}

// @public
export interface HTMLTemplateCompilationResult<TSource = any, TParent = any> {
    createView(hostBindingTarget?: Element): HTMLView<TSource, TParent>;
}

// @public
export type HTMLTemplateTag = (<TSource = any, TParent = any>(strings: TemplateStringsArray, ...values: TemplateValue<TSource, TParent>[]) => ViewTemplate<TSource, TParent>) & {
    partial(html: string): InlineTemplateDirective;
};

// @public
export class HTMLView<TSource = any, TParent = any> implements ElementView<TSource, TParent>, SyntheticView<TSource, TParent>, ExecutionContext<TParent> {
    constructor(fragment: DocumentFragment, factories: ReadonlyArray<CompiledViewBehaviorFactory>, targets: ViewBehaviorTargets);
    appendTo(node: Node): void;
    bind(source: TSource, context?: ExecutionContext<TParent>): void;
    context: ExecutionContext<TParent>;
    dispose(): void;
    static disposeContiguousBatch(views: SyntheticView[]): void;
    get event(): Event;
    eventDetail<TDetail>(): TDetail;
    eventTarget<TTarget extends EventTarget>(): TTarget;
    firstChild: Node;
    index: number;
    insertBefore(node: Node): void;
    isBound: boolean;
    get isEven(): boolean;
    get isFirst(): boolean;
    get isInMiddle(): boolean;
    get isLast(): boolean;
    get isOdd(): boolean;
    lastChild: Node;
    length: number;
    // (undocumented)
    onUnbind(behavior: {
        unbind(controller: ViewController<TSource, TParent>): any;
    }): void;
    readonly parent: TParent;
    readonly parentContext: ExecutionContext<TParent>;
    remove(): void;
    source: TSource | null;
    readonly sourceLifetime: SourceLifetime;
    // (undocumented)
    readonly targets: ViewBehaviorTargets;
    unbind(): void;
}

// @public
export class InlineTemplateDirective implements HTMLDirective {
    constructor(html: string, factories?: Record<string, ViewBehaviorFactory>);
    createHTML(add: AddViewBehaviorFactory): string;
    static readonly empty: InlineTemplateDirective;
}

// @public
export interface LengthObserver extends Subscriber {
    length: number;
}

// @public
export function lengthOf<T>(array: readonly T[]): number;

// @public
export function listener<T = any>(expression: Expression<T>, options?: AddEventListenerOptions): Binding<T>;

// @public
export const Markup: Readonly<{
    interpolation: (id: string) => string;
    attribute: (id: string) => string;
    comment: (id: string) => string;
}>;

// @public
export interface NodeBehaviorOptions<T = any> {
    filter?: ElementsFilter;
    property: T;
}

// @public
export abstract class NodeObservationDirective<T extends NodeBehaviorOptions> extends StatelessAttachedAttributeDirective<T> {
    bind(controller: ViewController): void;
    protected computeNodes(target: any): Node[];
    protected abstract disconnect(target: any): void;
    protected abstract getNodes(target: any): Node[];
    protected getSource(target: Node): any;
    get id(): string;
    set id(value: string);
    protected abstract observe(target: any): void;
    targetNodeId: string;
    unbind(controller: ViewController): void;
    protected updateTarget(source: any, value: ReadonlyArray<any>): void;
}

// @public
export function normalizeBinding<TSource = any, TReturn = any, TParent = any>(value: Expression<TSource, TReturn, TParent> | Binding<TSource, TReturn, TParent> | {}): Binding<TSource, TReturn, TParent>;

// @public
export interface Notifier {
    notify(args: any): void;
    readonly subject: any;
    subscribe(subscriber: Subscriber, propertyToWatch?: any): void;
    unsubscribe(subscriber: Subscriber, propertyToUnwatch?: any): void;
}

// @public
export const nullableBooleanConverter: ValueConverter;

// @public
export const nullableNumberConverter: ValueConverter;

// @public
export const Observable: Readonly<{
    setArrayObserverFactory(factory: (collection: any[]) => Notifier): void;
    getNotifier: <T extends Notifier = Notifier>(source: any) => T;
    track(source: unknown, propertyName: string): void;
    trackVolatile(): void;
    notify(source: unknown, args: any): void;
    defineProperty(target: {}, nameOrAccessor: string | Accessor): void;
    getAccessors: (target: {}) => Accessor[];
    binding<TSource = any, TReturn = any>(expression: Expression<TSource, TReturn, any>, initialSubscriber?: Subscriber, isVolatileBinding?: boolean): ExpressionNotifier<TSource, TReturn, any>;
    isVolatileBinding<TSource_1 = any, TReturn_1 = any>(expression: Expression<TSource_1, TReturn_1, any>): boolean;
}>;

// @public
export function observable(target: {}, nameOrAccessor: string | Accessor): void;

// @public
export interface ObservationRecord {
    propertyName: string;
    propertySource: any;
}

// @public
export function oneTime<T = any>(expression: Expression<T>, policy?: DOMPolicy): Binding<T>;

// @public
export function oneWay<T = any>(expression: Expression<T>, policy?: DOMPolicy, isVolatile?: boolean): Binding<T>;

// @public
export const Parser: Readonly<{
    parse(value: string, factories: Record<string, ViewBehaviorFactory>): (string | ViewBehaviorFactory)[] | null;
}>;

// @public
export interface PartialFASTElementDefinition {
    readonly attributes?: (AttributeConfiguration | string)[];
    readonly elementOptions?: ElementDefinitionOptions;
    readonly name: string;
    readonly registry?: CustomElementRegistry;
    readonly shadowOptions?: Partial<ShadowRootOptions> | null;
    readonly styles?: ComposableStyles | ComposableStyles[];
    readonly template?: ElementViewTemplate;
}

// @public
export interface PartialHTMLDirectiveDefinition {
    aspected?: boolean;
}

// @public
export class PropertyChangeNotifier implements Notifier {
    constructor(subject: any);
    notify(propertyName: string): void;
    readonly subject: any;
    subscribe(subscriber: Subscriber, propertyToWatch?: string): void;
    unsubscribe(subscriber: Subscriber, propertyToUnwatch?: string): void;
}

// @public
export const ref: <TSource = any, TParent = any>(propertyName: keyof TSource & string) => CaptureType<TSource, TParent>;

// @public
export class RefDirective extends StatelessAttachedAttributeDirective<string> {
    bind(controller: ViewController): void;
    targetNodeId: string;
}

// @public
export function repeat<TSource = any, TArray extends ReadonlyArray<any> = ReadonlyArray<any>, TParent = any>(items: Expression<TSource, TArray, TParent> | Binding<TSource, TArray, TParent> | ReadonlyArray<any>, template: Expression<TSource, ViewTemplate<any, TSource>> | Binding<TSource, ViewTemplate<any, TSource>> | ViewTemplate<any, TSource>, options?: RepeatOptions): CaptureType<TSource, TParent>;

// @public
export class RepeatBehavior<TSource = any> implements ViewBehavior, Subscriber {
    constructor(directive: RepeatDirective);
    bind(controller: ViewController): void;
    handleChange(source: any, args: Splice[] | ExpressionObserver): void;
    unbind(): void;
    // @internal (undocumented)
    views: SyntheticView[];
}

// @public
export class RepeatDirective<TSource = any> implements HTMLDirective, ViewBehaviorFactory, BindingDirective {
    constructor(dataBinding: Binding<TSource>, templateBinding: Binding<TSource, SyntheticViewTemplate>, options: RepeatOptions);
    createBehavior(): RepeatBehavior<TSource>;
    createHTML(add: AddViewBehaviorFactory): string;
    // (undocumented)
    readonly dataBinding: Binding<TSource>;
    // (undocumented)
    readonly options: RepeatOptions;
    targetNodeId: string;
    // (undocumented)
    readonly templateBinding: Binding<TSource, SyntheticViewTemplate>;
}

// @public
export interface RepeatOptions {
    positioning?: boolean;
    recycle?: boolean;
}

// @public
export interface ShadowRootOptions extends ShadowRootInit {
    // @beta
    registry?: CustomElementRegistry;
}

// @public
export function slotted<TSource = any, TParent = any>(propertyOrOptions: (keyof TSource & string) | SlottedDirectiveOptions<keyof TSource & string>): CaptureType<TSource, TParent>;

// @public
export class SlottedDirective extends NodeObservationDirective<SlottedDirectiveOptions> {
    disconnect(target: EventSource): void;
    getNodes(target: HTMLSlotElement): Node[];
    // @internal (undocumented)
    handleEvent(event: Event): void;
    observe(target: EventSource): void;
}

// @public
export interface SlottedDirectiveOptions<T = any> extends NodeBehaviorOptions<T>, AssignedNodesOptions {
}

// @public
export const SourceLifetime: Readonly<{
    readonly unknown: undefined;
    readonly coupled: 1;
}>;

// @public
export type SourceLifetime = (typeof SourceLifetime)[keyof typeof SourceLifetime];

// @public
export class Splice {
    constructor(index: number, removed: any[], addedCount: number);
    // (undocumented)
    addedCount: number;
    adjustTo(array: any[]): this;
    // (undocumented)
    index: number;
    // (undocumented)
    removed: any[];
    reset?: boolean;
}

// @public
export interface SpliceStrategy {
    normalize(previous: unknown[] | undefined, current: unknown[], changes: Splice[] | undefined): readonly Splice[];
    pop(array: any[], observer: ArrayObserver, pop: typeof Array.prototype.pop, args: any[]): any;
    push(array: any[], observer: ArrayObserver, push: typeof Array.prototype.push, args: any[]): any;
    reverse(array: any[], observer: ArrayObserver, reverse: typeof Array.prototype.reverse, args: any[]): any;
    shift(array: any[], observer: ArrayObserver, shift: typeof Array.prototype.shift, args: any[]): any;
    sort(array: any[], observer: ArrayObserver, sort: typeof Array.prototype.sort, args: any[]): any[];
    splice(array: any[], observer: ArrayObserver, splice: typeof Array.prototype.splice, args: any[]): any;
    readonly support: SpliceStrategySupport;
    unshift(array: any[], observer: ArrayObserver, unshift: typeof Array.prototype.unshift, args: any[]): any[];
}

// @public
export const SpliceStrategy: Readonly<{
    readonly reset: Splice[];
    readonly setDefaultStrategy: (strategy: SpliceStrategy) => void;
}>;

// @public
export const SpliceStrategySupport: Readonly<{
    readonly reset: 1;
    readonly splice: 2;
    readonly optimized: 3;
}>;

// @public
export type SpliceStrategySupport = (typeof SpliceStrategySupport)[keyof typeof SpliceStrategySupport];

// @public
export abstract class StatelessAttachedAttributeDirective<TOptions> implements HTMLDirective, ViewBehaviorFactory, ViewBehavior {
    constructor(options: TOptions);
    abstract bind(controller: ViewController): void;
    createBehavior(): ViewBehavior;
    createHTML(add: AddViewBehaviorFactory): string;
    // (undocumented)
    protected options: TOptions;
}

// @public
export interface StyleStrategy {
    addStylesTo(target: StyleTarget): void;
    removeStylesFrom(target: StyleTarget): void;
}

// @public
export interface StyleTarget extends Pick<Node, "getRootNode"> {
    adoptedStyleSheets?: CSSStyleSheet[];
    append(styles: HTMLStyleElement): void;
    querySelectorAll<E extends Element = Element>(selectors: string): NodeListOf<E>;
    removeChild(styles: HTMLStyleElement): void;
}

// @public
export interface Subscriber {
    handleChange(subject: any, args: any): void;
}

// @public
export class SubscriberSet implements Notifier {
    constructor(subject: any, initialSubscriber?: Subscriber);
    has(subscriber: Subscriber): boolean;
    notify(args: any): void;
    readonly subject: any;
    subscribe(subscriber: Subscriber): void;
    unsubscribe(subscriber: Subscriber): void;
}

// @public
export interface SubtreeDirectiveOptions<T = any> extends NodeBehaviorOptions<T>, Omit<MutationObserverInit, "subtree" | "childList"> {
    selector: string;
    subtree: boolean;
}

// @public
export interface SyntheticView<TSource = any, TParent = any> extends View<TSource, TParent> {
    readonly firstChild: Node;
    insertBefore(node: Node): void;
    readonly lastChild: Node;
    remove(): void;
}

// @public
export interface SyntheticViewTemplate<TSource = any, TParent = any> {
    create(): SyntheticView<TSource, TParent>;
    inline(): CaptureType<TSource, TParent>;
}

// @public
export type TemplateValue<TSource, TParent = any> = Expression<TSource, any, TParent> | Binding<TSource, any, TParent> | HTMLDirective | CaptureType<TSource, TParent>;

// @public
export type TrustedTypesPolicy = {
    createHTML(html: string): string;
};

// @public
export interface UpdateQueue {
    enqueue(callable: Callable): void;
    next(): Promise<void>;
    process(): void;
    setMode(isAsync: boolean): void;
}

// @public
export const Updates: UpdateQueue;

// @public
export interface ValueConverter {
    fromView(value: any): any;
    toView(value: any): any;
}

// @public
export interface View<TSource = any, TParent = any> extends Disposable {
    bind(source: TSource, context?: ExecutionContext<TParent>): void;
    readonly context: ExecutionContext<TParent>;
    readonly isBound: boolean;
    readonly source: TSource | null;
    unbind(): void;
}

// @public
export interface ViewBehavior<TSource = any, TParent = any> {
    bind(controller: ViewController<TSource, TParent>): void;
}

// @public
export interface ViewBehaviorFactory {
    createBehavior(): ViewBehavior;
    id?: string;
    policy?: DOMPolicy;
    targetNodeId?: string;
    targetTagName?: string | null;
}

// @public
export type ViewBehaviorTargets = {
    [id: string]: Node;
};

// @public
export interface ViewController<TSource = any, TParent = any> extends ExpressionController<TSource, TParent> {
    readonly targets: ViewBehaviorTargets;
}

// @public
export class ViewTemplate<TSource = any, TParent = any> implements ElementViewTemplate<TSource, TParent>, SyntheticViewTemplate<TSource, TParent> {
    constructor(html: string | HTMLTemplateElement, factories?: Record<string, ViewBehaviorFactory>, policy?: DOMPolicy | undefined);
    create(hostBindingTarget?: Element): HTMLView<TSource, TParent>;
    static create<TSource = any, TParent = any>(strings: string[], values: TemplateValue<TSource, TParent>[], policy?: DOMPolicy): ViewTemplate<TSource, TParent>;
    readonly factories: Record<string, ViewBehaviorFactory>;
    readonly html: string | HTMLTemplateElement;
    inline(): CaptureType<TSource, TParent>;
    render(source: TSource, host: Node, hostBindingTarget?: Element): HTMLView<TSource, TParent>;
    withPolicy(policy: DOMPolicy): this;
}

// @public
export function volatile(target: {}, name: string | Accessor, descriptor: PropertyDescriptor): PropertyDescriptor;

// @public
export function when<TSource = any, TReturn = any, TParent = any>(condition: Expression<TSource, TReturn, TParent> | boolean, templateOrTemplateBinding: SyntheticViewTemplate<TSource, TParent> | Expression<TSource, SyntheticViewTemplate<TSource, TParent>, TParent>, elseTemplateOrTemplateBinding?: SyntheticViewTemplate<TSource, TParent> | Expression<TSource, SyntheticViewTemplate<TSource, TParent>, TParent>): CaptureType<TSource, TParent>;

// Warnings were encountered during analysis:
//
// dist/dts/components/fast-element.d.ts:60:5 - (ae-forgotten-export) The symbol "define" needs to be exported by the entry point index.d.ts
// dist/dts/components/fast-element.d.ts:61:5 - (ae-forgotten-export) The symbol "compose" needs to be exported by the entry point index.d.ts
// dist/dts/components/fast-element.d.ts:62:5 - (ae-forgotten-export) The symbol "from" needs to be exported by the entry point index.d.ts
// dist/dts/styles/css-binding-directive.d.ts:35:9 - (ae-forgotten-export) The symbol "CSSBindingEntry" needs to be exported by the entry point index.d.ts

// (No @packageDocumentation comment for this package)

```
