## Usage

```js
const pascalcase = require('{%= name %}');

console.log(pascalcase('a')); //=> 'A'
console.log(pascalcase('foo bar baz')); //=> 'FooBarBaz'
console.log(pascalcase('  foo bar baz  ')); //=> 'FooBarBaz'
console.log(pascalcase('foo_bar-baz')); //=> 'FooBarBaz'
console.log(pascalcase('foo.bar.baz')); //=> 'FooBarBaz'
console.log(pascalcase('foo/bar/baz')); //=> 'FooBarBaz'
console.log(pascalcase('foo[bar)baz')); //=> 'FooBarBaz'
console.log(pascalcase('#foo+bar*baz')); //=> 'FooBarBaz'
console.log(pascalcase('$foo~bar`baz')); //=> 'FooBarBaz'
console.log(pascalcase('_foo_bar-baz-')); //=> 'FooBarBaz'
console.log(pascalcase('foo 2 bar 5 baz')); //=> 'Foo2Bar5Baz'
console.log(pascalcase('foo2bar5baz')); //=> 'Foo2bar5baz'
```
