C> \ingroup nwxc 
C> @{ 
C> 
C> \file nwxcm_c_opt.F 
C> The nwxcm_c_opt functional 
C> 
C> @} 
C> 
C> \ingroup nwxc_priv 
C> @{ 
C> 
C> \brief Evaluate the nwxcm_c_opt functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\alpha^{0.3333333333333333}\\\\ 
C>   {\it t_2} &=& \sqrt{{\it t_1}}\\\\ 
C>   {\it t_3} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_4} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_5} &=& \log \left({{1.269642451250142\,{\it t_2}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.02414199311453321\,{\it t_3}+0.10186556948\right)\,{
C>    \it t_3}+0.22308199064\right)\,{\it t_3}+0.47231125998}}
C>    +1.0\right)\\\\ 
C>   {\it t_6} &=& 0.1325688999052018\,{\it t_4}+1.0\\\\ 
C>   {\it t_7} &=& \log \left({{1.269642451250142\,{\it t_2}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01321299881039884\,{\it t_3}+0.029729725188\right)
C>    \,{\it t_3}+0.12236585478\right)\,{\it t_3}+0.3497952466}}
C>    +1.0\right)\\\\ 
C>   {\it t_8} &=& 0.06901399211255826\,{\it t_4}+1.0\\\\ 
C>   {\it t_9} &=& 0.5848223622634643\,\left(0.0337738\,{\it t_7}
C>    \,{\it t_8}+1.0\,\left(1.709920934161365\,\left(0.0621814\,{
C>    \it t_5}\,{\it t_6}-0.0310907\,\log \left({{1.269642451250142
C>    \,{\it t_2}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01530901310039024\,{\it t_3}+0.10465751434\right)
C>    \,{\it t_3}+0.19269083139\right)\,{\it t_3}+0.43896648423}}
C>    +1.0\right)\,\left(0.1274696188700087\,{\it t_4}
C>    +1.0\right)\right)-0.0337738\,{\it t_7}\,{\it t_8}\right)\right)
C>    -0.0621814\,{\it t_5}\,{\it t_6}\\\\ 
C>   {\it t_{10}} &=& \rho_\beta^{0.3333333333333333}\\\\ 
C>   {\it t_{11}} &=& \sqrt{{\it t_{10}}}\\\\ 
C>   {\it t_{12}} &=& {{1}\over{{\it t_{11}}}}\\\\ 
C>   {\it t_{13}} &=& {{1}\over{{\it t_{10}}}}\\\\ 
C>   {\it t_{14}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{11}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.02414199311453321\,{\it t_{12}}+0.10186556948\right)
C>    \,{\it t_{12}}+0.22308199064\right)\,{\it t_{12}}
C>    +0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{15}} &=& 0.1325688999052018\,{\it t_{13}}+1.0\\\\ 
C>   {\it t_{16}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{11}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01321299881039884\,{\it t_{12}}
C>    +0.029729725188\right)\,{\it t_{12}}+0.12236585478\right)\,{
C>    \it t_{12}}+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{17}} &=& 0.06901399211255826\,{\it t_{13}}+1.0\\\\ 
C>   {\it t_{18}} &=& 0.5848223622634643\,\left(0.0337738\,{
C>    \it t_{16}}\,{\it t_{17}}+1.0\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{14}}\,{\it t_{15}}-0.0310907
C>    \,\log \left({{1.269642451250142\,{\it t_{11}}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01530901310039024\,{\it t_{12}}+0.10465751434\right)
C>    \,{\it t_{12}}+0.19269083139\right)\,{\it t_{12}}
C>    +0.43896648423}}+1.0\right)\,\left(0.1274696188700087\,{
C>    \it t_{13}}+1.0\right)\right)-0.0337738\,{\it t_{16}}\,{
C>    \it t_{17}}\right)\right)-0.0621814\,{\it t_{14}}\,{
C>    \it t_{15}}\\\\ 
C>   {\it t_{19}} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_{20}} &=& {\it t_{19}}^{0.3333333333333333}\\\\ 
C>   {\it t_{21}} &=& {{1}\over{{\it t_{20}}}}\\\\ 
C>   {\it t_{22}} &=& 0.1325688999052018\,{\it t_{21}}+1.0\\\\ 
C>   {\it t_{23}} &=& \sqrt{{\it t_{20}}}\\\\ 
C>   {\it t_{24}} &=& {{1}\over{{\it t_{23}}}}\\\\ 
C>   {\it t_{25}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{23}}}\over{0.7876233178997433\,{\it t_{24}}\,
C>    \left(0.7876233178997433\,{\it t_{24}}\,
C>    \left(0.02414199311453321\,{\it t_{24}}+0.10186556948\right)
C>    +0.22308199064\right)+0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{26}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{27}} &=& {{1}\over{{\it t_{19}}}}\\\\ 
C>   {\it t_{28}} &=& 1.0-{\it t_{26}}\,{\it t_{27}}\\\\ 
C>   {\it t_{29}} &=& {\it t_{26}}\,{\it t_{27}}+1.0\\\\ 
C>   {\it t_{30}} &=& 0.06901399211255826\,{\it t_{21}}+1.0\\\\ 
C>   {\it t_{31}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{23}}}\over{0.7876233178997433\,{\it t_{24}}\,
C>    \left(0.7876233178997433\,{\it t_{24}}\,
C>    \left(0.01321299881039884\,{\it t_{24}}+0.029729725188\right)
C>    +0.12236585478\right)+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{32}} &=& 0.5848223622634648\,\left(1.923661050931536
C>    \,{\it t_{29}}^{{{4}\over{3}}}+1.923661050931536\,{
C>    \it t_{28}}^{{{4}\over{3}}}-3.847322101863072\right)\,
C>    \left({{{\it t_{26}}^4\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{22}}\,{\it t_{25}}-0.0310907\,
C>    \left(0.1274696188700087\,{\it t_{21}}+1.0\right)\,\log 
C>    \left({{1.269642451250142\,{\it t_{23}}}
C>    \over{0.7876233178997433\,{\it t_{24}}\,
C>    \left(0.7876233178997433\,{\it t_{24}}\,
C>    \left(0.01530901310039024\,{\it t_{24}}+0.10465751434\right)
C>    +0.19269083139\right)+0.43896648423}}+1.0\right)\right)
C>    -0.0337738\,{\it t_{30}}\,{\it t_{31}}\right)}\over{{
C>    \it t_{19}}^4}}+0.0337738\,{\it t_{30}}\,{\it t_{31}}\right)
C>    -0.0621814\,{\it t_{22}}\,{\it t_{25}}\\\\ 
C>   {\it t_{33}} &=& {{1}\over{
C>    \left(\rho_\alpha^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_{34}} &=& {{1}\over{e^{80.85523023512745\,{\it t_9}}}}
C>    -1.0\\\\ 
C>   {\it t_{35}} &=& {{0.2717804421747981\,{\it t_{33}}\,
C>    \sigma_{\alpha\alpha}}\over{{\it t_{34}}}}\\\\ 
C>   {\it t_{36}} &=& {{1}\over{
C>    \left(\rho_\beta^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_{37}} &=& {{1}\over{e^{80.85523023512745\,{\it t_{18}}}}}
C>    -1.0\\\\ 
C>   {\it t_{38}} &=& {{0.2717804421747981\,{\it t_{36}}\,
C>    \sigma_{\beta\beta}}\over{{\it t_{37}}}}\\\\ 
C>   {\it t_{39}} &=& 0.5\,{\it t_{29}}^{{{2}\over{3}}}+0.5\,{
C>    \it t_{28}}^{{{2}\over{3}}}\\\\ 
C>   {\it t_{40}} &=& {\it t_{39}}^{3.0}\\\\ 
C>   {\it t_{41}} &=& {{1}\over{\left({
C>    \it t_{19}}^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_{42}} &=& {{1}\over{{\it t_{39}}^{2.0}}}\\\\ 
C>   {\it t_{43}} &=& \sigma_{\beta\beta}+2.0\,\sigma_{\alpha\beta}
C>    +\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{44}} &=& {{1}\over{e^{{{40.42761511756372\,{
C>    \it t_{32}}}\over{{\it t_{40}}}}}}}-1.0\\\\ 
C>   {\it t_{45}} &=& {{0.1712109500228822\,{\it t_{41}}\,{
C>    \it t_{42}}\,{\it t_{43}}}\over{{\it t_{44}}}}\\\\ 
C>   f &=& 0.02473556743557577\,{\it t_{19}}\,{\it t_{40}}
C>    \,\log \left({{0.1712109500228822\,{\it t_{41}}\,{\it t_{42}}
C>    \,{\it t_{43}}\,\left({\it t_{45}}+1.0\right)}
C>    \over{{{0.02931318940773787\,\left({\it t_{41}}\,{
C>    \it t_{43}}\right)^{2.0}}\over{{\it t_{39}}^{4.0}\,{
C>    \it t_{44}}^{2.0}}}+{\it t_{45}}+1.0}}+1.0\right)
C>    -0.01236778371778788\,\rho_\beta\,\log 
C>    \left({{0.2717804421747981\,{\it t_{36}}\,\sigma_{\beta\beta}
C>    \,\left({\it t_{38}}+1.0\right)}\over{{{0.0738646087487288
C>    \,\left({\it t_{36}}\,\sigma_{\beta\beta}\right)^{2.0}}
C>    \over{{\it t_{37}}^{2.0}}}+{\it t_{38}}+1.0}}+1.0\right)
C>    -0.01236778371778788\,\rho_\alpha\,\log 
C>    \left({{0.2717804421747981\,{\it t_{33}}\,
C>    \sigma_{\alpha\alpha}\,\left({\it t_{35}}+1.0\right)}
C>    \over{{{0.0738646087487288\,\left({\it t_{33}}\,
C>    \sigma_{\alpha\alpha}\right)^{2.0}}\over{{\it t_{34}}^{2.0}}}
C>    +{\it t_{35}}+1.0}}+1.0\right)+1.0\,{\it t_{19}}\,{\it t_{32}}
C>    -1.0\,{\it t_{18}}\,\rho_\beta-1.0\,{\it t_9}\,\rho_\alpha\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 0.0\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] NC Handy, AJ Cohen, Mol.Phys. 99, 607 (2001)  , DOI: 
C> <a href="http://dx.doi.org/10.1080/00268970010023435 "> 
C> 10.1080/00268970010023435 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_opt(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,fnc,Amat,Cmat) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision rgamma(nq,*) !< [Input] The norm of the density 
                                    !< gradients 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,*)   !< [Output] The derivative wrt rgamma 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          if (rhoa.gt.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1.530901310039024d-2*t3+1.0465751434d-1
            t5 = 7.876233178997433d-1*t3*t4+1.9269083139d-1
            t6 = 7.876233178997433d-1*t3*t5+4.3896648423d-1
            t7 = 1/t6
            t8 = 1.269642451250142d+0*t2*t7+1.0d+0
            t9 = log(t8)
            t10 = 1/t1
            t11 = 1.2746961887000874d-1*t10+1.0d+0
            t12 = 2.4141993114533214d-2*t3+1.0186556948d-1
            t13 = 7.876233178997433d-1*t12*t3+2.2308199064d-1
            t14 = 7.876233178997433d-1*t13*t3+4.7231125998d-1
            t15 = 1/t14
            t16 = 1.269642451250142d+0*t15*t2+1.0d+0
            t17 = log(t16)
            t18 = 1.325688999052018d-1*t10+1.0d+0
            t19 = 1.3212998810398843d-2*t3+2.9729725188d-2
            t20 = 7.876233178997433d-1*t19*t3+1.2236585478d-1
            t21 = 7.876233178997433d-1*t20*t3+3.497952466d-1
            t22 = 1/t21
            t23 = 1.269642451250142d+0*t2*t22+1.0d+0
            t24 = log(t23)
            t25 = 6.901399211255826d-2*t10+1.0d+0
            t26 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t17*t18-3.10907d-2*t11*t9)-3.37738d-2*t24*t25)+3
     2         .37738d-2*t24*t25)-6.21814d-2*t17*t18
            t27 = log(1.4251254664507676d+0*t2/(7.016926042943223d-1*t3*
     1         (7.016926042943223d-1*(2.150807071909054d-2*t3+1.01865569
     2         48d-1)*t3+2.2308199064d-1)+4.7231125998d-1)+1.0d+0)
            t28 = 1.0522000558389215d-1*t10+1.0d+0
            t29 = rhoa**1.1666666666666667d+0
            t30 = 1/t29**2.0d+0
            t31 = exp(-8.085523023512745d+1*t26)
            t32 = t31-1.0d+0
            t33 = 1/t32
            t34 = 2.7178044217479813d-1*gammaaa*t30*t33
            t35 = t34+1.0d+0
            t36 = (gammaaa*t30)**2.0d+0
            t37 = 1/t32**2.0d+0
            t38 = 7.38646087487288d-2*t36*t37+t34+1.0d+0
            t39 = 1/t38
            t40 = 2.7178044217479813d-1*gammaaa*t30*t35*t39+1.0d+0
            t41 = log(t40)
            t42 = exp(2.5138457066712766d+0*t27*t28)-1.0d+0
            t43 = 1.35890221087399d-1*gammaaa*t30/t42
            t44 = 2.1508070719090538d-2*t3+1.0186556948d-1
            t45 = 7.016926042943222d-1*t3*t44+2.2308199064d-1
            t46 = 7.016926042943222d-1*t3*t45+4.7231125998d-1
            t47 = 1/t46
            t48 = 1.425125466450768d+0*t2*t47+1.0d+0
            t49 = log(t48)
            t50 = 1.0522000558389213d-1*t10+1.0d+0
            t51 = 1/rhoa**1.3333333333333333d+0
            t52 = 1/rhoa**1.3333333333333336d+0
            t53 = 1/t2**3
            t54 = 1/rhoa**6.666666666666667d-1
            t55 = 1.090454542535705d-3*t49*t51-6.21814d-2*t50*(1.1876045
     1         553756398d-1*t3*t47*t54-1.425125466450768d+0*t2*(7.016926
     2         042943222d-1*t3*(-5.847438369119352d-2*t44*t53*t54-1.2576
     3         711796854242d-3*t52)-5.847438369119352d-2*t45*t53*t54)/t4
     4         6**2)/t48
            t56 = 1/t16
            t57 = 2.11607075208357d-1*t15*t3*t54-1.269642451250142d+0*t2
     1         *(7.876233178997433d-1*t3*(-1.3127055298329054d-1*t12*t53
     2         *t54-3.169132786263567d-3*t52)-1.3127055298329054d-1*t13*
     3         t53*t54)/t14**2
            t58 = 1/t23
            t59 = 2.11607075208357d-1*t22*t3*t54-1.269642451250142d+0*t2
     1         *(7.876233178997433d-1*t3*(-1.3127055298329054d-1*t19*t53
     2         *t54-1.7344776604086162d-3*t52)-1.3127055298329054d-1*t20
     3         *t53*t54)/t21**2
            t60 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(1.
     1         3210398931339265d-3*t51*t9-3.10907d-2*t11*(2.116070752083
     2         57d-1*t3*t54*t7-1.269642451250142d+0*t2*(7.87623317899743
     3         3d-1*t3*(-1.3127055298329054d-1*t4*t53*t54-2.009622615316
     4         6658d-3*t52)-1.3127055298329054d-1*t5*t53*t54)/t6**2)/t8+
     5         6.21814d-2*t18*t56*t57-2.747773264188438d-3*t17*t51)-3.37
     6         738d-2*t25*t58*t59+7.769549222703733d-4*t24*t51)+3.37738d
     7         -2*t25*t58*t59-7.769549222703733d-4*t24*t51)-6.21814d-2*t
     8         18*t56*t57+2.747773264188438d-3*t17*t51
            t61 = 1/t40
            t62 = rhoa**1.6666666666666674d-1
            t63 = 1/t29**3.0d+0
            t64 = -6.34154365074529d-1*gammaaa*t33*t62*t63
            t65 = 2.1974870225448048d+1*gammaaa*t30*t31*t60/t32**2
            t66 = 1/t38**2
            t67 = gammaaa**2
            t68 = 1/t29**5.0d+0
            t69 = exp(2.5138457066712766d+0*t49*t50)
            t70 = t69-1.0d+0
            t71 = 1/t70
            t72 = 1.3589022108739904d-1*gammaaa*t30*t71
            t73 = t72+1.0d+0
            t74 = 1/t70**2.0d+0
            t75 = 1.8466152187182186d-2*t36*t74+t72+1.0d+0
            t76 = 1/t75
            t77 = 1.3589022108739904d-1*gammaaa*t30*t73*t76+1.0d+0
            t78 = 1/t77
            t79 = -1.585385912686322d-1*gammaaa*t62*t63*t71
            t80 = 5.493717556362009d+0*gammaaa*t30*t55*t69/t70**2
            t81 = 1/t75**2
            t82 = 1/t29**4.0d+0
            fnc(iq) = (4.947113487115154d-2*rhoa*log(1.35890221087399d-1
     1         *gammaaa*t30*(t43+1.0d+0)/(t43+1.8466152187182178d-2*t36/
     2         t42**2.0d+0+1.0d+0)+1.0d+0)-2.4735567435575762d-2*rhoa*t4
     3         1-1.243628d-1*rhoa*t27*t28-2.0d+0*rhoa*t26)*wght+fnc(iq)
            Amat(iq,D1_RA) = (4.947113487115154d-2*rhoa*t78*(-1.35890221
     1         08739904d-1*gammaaa*t30*t73*(t80+t79-4.308768843675843d-2
     2         *t62*t67*t68*t74+1.4930849866515178d+0*t36*t55*t69/t70**3
     3         .0d+0)*t81+1.3589022108739904d-1*gammaaa*t30*t76*(t80+t79
     4         )-1.585385912686322d-1*gammaaa*t62*t63*t73*t76)+2.4735567
     5         43557577d-2*log(t77)-1.2367783717787881d-2*rhoa*t61*(-2.7
     6         178044217479813d-1*gammaaa*t30*t35*t66*(-3.44701507494067
     7         75d-1*t37*t62*t67*t68+t65+t64+1.1944679893212153d+1*t31*t
     8         36*t60/t32**3.0d+0)+2.7178044217479813d-1*gammaaa*t30*t39
     9         *(t65+t64)-6.34154365074529d-1*gammaaa*t35*t39*t62*t63)-1
     :         .0d+0*rhoa*t60+2.0d+0*rhoa*t55-6.21814d-2*t49*t50-1.23677
     ;         83717787881d-2*t41-1.0d+0*t26)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = (4.947113487115154d-2*rhoa*t78*(-1.3589022
     1         108739904d-1*gammaaa*t30*t73*t81*(9.233076093591093d-3*ga
     2         mmaaa*t74*t82+3.397255527184976d-2*t30*t71)+4.61653804679
     3         55464d-3*gammaaa*t71*t76*t82+3.397255527184976d-2*t30*t73
     4         *t76)-1.2367783717787881d-2*rhoa*t61*(-2.7178044217479813
     5         d-1*gammaaa*t30*t35*t66*(1.477292174974576d-1*gammaaa*t37
     6         *t82+2.7178044217479813d-1*t30*t33)+7.386460874872879d-2*
     7         gammaaa*t33*t39*t82+2.7178044217479813d-1*t30*t35*t39))*w
     8         ght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = 4.947113487115154d-2*rhoa*t78*(-1.35890221
     1         08739904d-1*gammaaa*t30*t73*t81*(1.8466152187182186d-2*ga
     2         mmaaa*t74*t82+6.794511054369952d-2*t30*t71)+9.23307609359
     3         1093d-3*gammaaa*t71*t76*t82+6.794511054369952d-2*t30*t73*
     4         t76)*wght+Cmat(iq,D1_GAB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1.530901310039024d-2*t3+1.0465751434d-1
            t5 = 7.876233178997433d-1*t3*t4+1.9269083139d-1
            t6 = 7.876233178997433d-1*t3*t5+4.3896648423d-1
            t7 = 1/t6
            t8 = 1.269642451250142d+0*t2*t7+1.0d+0
            t9 = log(t8)
            t10 = 1/t1
            t11 = 1.2746961887000874d-1*t10+1.0d+0
            t12 = 2.4141993114533214d-2*t3+1.0186556948d-1
            t13 = 7.876233178997433d-1*t12*t3+2.2308199064d-1
            t14 = 7.876233178997433d-1*t13*t3+4.7231125998d-1
            t15 = 1/t14
            t16 = 1.269642451250142d+0*t15*t2+1.0d+0
            t17 = log(t16)
            t18 = 1.325688999052018d-1*t10+1.0d+0
            t19 = 1.3212998810398843d-2*t3+2.9729725188d-2
            t20 = 7.876233178997433d-1*t19*t3+1.2236585478d-1
            t21 = 7.876233178997433d-1*t20*t3+3.497952466d-1
            t22 = 1/t21
            t23 = 1.269642451250142d+0*t2*t22+1.0d+0
            t24 = log(t23)
            t25 = 6.901399211255826d-2*t10+1.0d+0
            t26 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t17*t18-3.10907d-2*t11*t9)-3.37738d-2*t24*t25)+3
     2         .37738d-2*t24*t25)-6.21814d-2*t17*t18
            t27 = rhoa**1.1666666666666667d+0
            t28 = 1/t27**2.0d+0
            t29 = exp(-8.085523023512745d+1*t26)
            t30 = t29-1.0d+0
            t31 = 1/t30
            t32 = 2.7178044217479813d-1*gammaaa*t28*t31
            t33 = t32+1.0d+0
            t34 = (gammaaa*t28)**2.0d+0
            t35 = 1/t30**2.0d+0
            t36 = 7.38646087487288d-2*t34*t35+t32+1.0d+0
            t37 = 1/t36
            t38 = 2.7178044217479813d-1*gammaaa*t28*t33*t37+1.0d+0
            t39 = log(t38)
            t40 = rhob**3.333333333333333d-1
            t41 = t40**5.0d-1
            t42 = 1/t41
            t43 = 1.530901310039024d-2*t42+1.0465751434d-1
            t44 = 7.876233178997433d-1*t42*t43+1.9269083139d-1
            t45 = 7.876233178997433d-1*t42*t44+4.3896648423d-1
            t46 = 1/t45
            t47 = 1.269642451250142d+0*t41*t46+1.0d+0
            t48 = log(t47)
            t49 = 1/t40
            t50 = 1.2746961887000874d-1*t49+1.0d+0
            t51 = 2.4141993114533214d-2*t42+1.0186556948d-1
            t52 = 7.876233178997433d-1*t42*t51+2.2308199064d-1
            t53 = 7.876233178997433d-1*t42*t52+4.7231125998d-1
            t54 = 1/t53
            t55 = 1.269642451250142d+0*t41*t54+1.0d+0
            t56 = log(t55)
            t57 = 1.325688999052018d-1*t49+1.0d+0
            t58 = 1.3212998810398843d-2*t42+2.9729725188d-2
            t59 = 7.876233178997433d-1*t42*t58+1.2236585478d-1
            t60 = 7.876233178997433d-1*t42*t59+3.497952466d-1
            t61 = 1/t60
            t62 = 1.269642451250142d+0*t41*t61+1.0d+0
            t63 = log(t62)
            t64 = 6.901399211255826d-2*t49+1.0d+0
            t65 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t56*t57-3.10907d-2*t48*t50)-3.37738d-2*t63*t64)+
     2         3.37738d-2*t63*t64)-6.21814d-2*t56*t57
            t66 = rhob+rhoa
            t67 = t66**3.333333333333333d-1
            t68 = 1/t67
            t69 = 1.325688999052018d-1*t68+1.0d+0
            t70 = t67**5.0d-1
            t71 = 1/t70
            t72 = 2.4141993114533214d-2*t71+1.0186556948d-1
            t73 = 7.876233178997433d-1*t71*t72+2.2308199064d-1
            t74 = 7.876233178997433d-1*t71*t73+4.7231125998d-1
            t75 = 1/t74
            t76 = 1.269642451250142d+0*t70*t75+1.0d+0
            t77 = log(t76)
            t78 = rhoa-rhob
            t79 = 1/t66
            t80 = 1.0d+0-t78*t79
            t81 = t78*t79+1.0d+0
            t82 = 1.923661050931536d+0*t81**1.3333333333333333d+0+1.9236
     1         61050931536d+0*t80**1.3333333333333333d+0-3.8473221018630
     2         72d+0
            t83 = 6.901399211255826d-2*t68+1.0d+0
            t84 = 1.3212998810398843d-2*t71+2.9729725188d-2
            t85 = 7.876233178997433d-1*t71*t84+1.2236585478d-1
            t86 = 7.876233178997433d-1*t71*t85+3.497952466d-1
            t87 = 1/t86
            t88 = 1.269642451250142d+0*t70*t87+1.0d+0
            t89 = log(t88)
            t90 = t78**4
            t91 = 1/t66**4
            t92 = 1.2746961887000874d-1*t68+1.0d+0
            t93 = 1.530901310039024d-2*t71+1.0465751434d-1
            t94 = 7.876233178997433d-1*t71*t93+1.9269083139d-1
            t95 = 7.876233178997433d-1*t71*t94+4.3896648423d-1
            t96 = 1/t95
            t97 = 1.269642451250142d+0*t70*t96+1.0d+0
            t98 = log(t97)
            t99 = 1.709920934161365d+0*(6.21814d-2*t69*t77-3.10907d-2*t9
     1         2*t98)-3.37738d-2*t83*t89
            t100 = t90*t91*t99+3.37738d-2*t83*t89
            t101 = 5.848223622634648d-1*t100*t82-6.21814d-2*t69*t77
            t102 = rhob**1.1666666666666667d+0
            t103 = 1/t102**2.0d+0
            t104 = exp(-8.085523023512745d+1*t65)
            t105 = t104-1.0d+0
            t106 = 1/t105
            t107 = 2.7178044217479813d-1*gammabb*t103*t106
            t108 = t107+1.0d+0
            t109 = (gammabb*t103)**2.0d+0
            t110 = 1/t105**2.0d+0
            t111 = 7.38646087487288d-2*t109*t110+t107+1.0d+0
            t112 = 1/t111
            t113 = 2.7178044217479813d-1*gammabb*t103*t108*t112+1.0d+0
            t114 = log(t113)
            t115 = 5.0d-1*t81**6.666666666666666d-1+5.0d-1*t80**6.666666
     1         666666666d-1
            t116 = t115**3.0d+0
            t117 = gammabb+2.0d+0*gammaab+gammaaa
            t118 = t66**1.1666666666666667d+0
            t119 = 1/t118**2.0d+0
            t120 = t115**2.0d+0
            t121 = 1/t120
            t122 = 1/t116
            t123 = exp(-4.042761511756372d+1*t101*t122)
            t124 = t123-1.0d+0
            t125 = 1/t124
            t126 = 1.7121095002288222d-1*t117*t119*t121*t125
            t127 = t126+1.0d+0
            t128 = 1/t115**4.0d+0
            t129 = (t117*t119)**2.0d+0
            t130 = 1/t124**2.0d+0
            t131 = 2.931318940773787d-2*t128*t129*t130+t126+1.0d+0
            t132 = 1/t131
            t133 = 1.7121095002288222d-1*t117*t119*t121*t127*t132+1.0d+0
            t134 = log(t133)
            t135 = 1/rhoa**1.3333333333333333d+0
            t136 = 1/rhoa**1.3333333333333336d+0
            t137 = 1/t2**3
            t138 = 1/rhoa**6.666666666666667d-1
            t139 = 1/t16
            t140 = 2.11607075208357d-1*t138*t15*t3-1.269642451250142d+0*
     1         t2*(7.876233178997433d-1*(-1.3127055298329054d-1*t12*t137
     2         *t138-3.169132786263567d-3*t136)*t3-1.3127055298329054d-1
     3         *t13*t137*t138)/t14**2
            t141 = 1/t23
            t142 = 2.11607075208357d-1*t138*t22*t3-1.269642451250142d+0*
     1         t2*(7.876233178997433d-1*(-1.3127055298329054d-1*t137*t13
     2         8*t19-1.7344776604086162d-3*t136)*t3-1.3127055298329054d-
     3         1*t137*t138*t20)/t21**2
            t143 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(1
     1         .3210398931339265d-3*t135*t9-3.10907d-2*t11*(2.1160707520
     2         8357d-1*t138*t3*t7-1.269642451250142d+0*t2*(7.87623317899
     3         7433d-1*t3*(-1.3127055298329054d-1*t137*t138*t4-2.0096226
     4         153166658d-3*t136)-1.3127055298329054d-1*t137*t138*t5)/t6
     5         **2)/t8+6.21814d-2*t139*t140*t18-2.747773264188438d-3*t13
     6         5*t17)-3.37738d-2*t141*t142*t25+7.769549222703733d-4*t135
     7         *t24)+3.37738d-2*t141*t142*t25-7.769549222703733d-4*t135*
     8         t24)-6.21814d-2*t139*t140*t18+2.747773264188438d-3*t135*t
     9         17
            t144 = 1/t38
            t145 = rhoa**1.6666666666666674d-1
            t146 = 1/t27**3.0d+0
            t147 = -6.34154365074529d-1*gammaaa*t145*t146*t31
            t148 = 2.1974870225448048d+1*gammaaa*t143*t28*t29/t30**2
            t149 = 1/t36**2
            t150 = 1/t66**1.3333333333333336d+0
            t151 = 1/t66**6.666666666666667d-1
            t152 = 1/t70**3
            t153 = 2.11607075208357d-1*t151*t71*t75-1.269642451250142d+0
     1         *t70*(7.876233178997433d-1*t71*(-1.3127055298329054d-1*t1
     2         51*t152*t72-3.169132786263567d-3*t150)-1.3127055298329054
     3         d-1*t151*t152*t73)/t74**2
            t154 = 1/t76
            t155 = -6.21814d-2*t153*t154*t69
            t156 = 1/t66**1.3333333333333333d+0
            t157 = 2.747773264188438d-3*t156*t77
            t158 = 2.11607075208357d-1*t151*t71*t87-1.269642451250142d+0
     1         *t70*(7.876233178997433d-1*t71*(-1.3127055298329054d-1*t1
     2         51*t152*t84-1.7344776604086162d-3*t150)-1.312705529832905
     3         4d-1*t151*t152*t85)/t86**2
            t159 = 1/t88
            t160 = 3.37738d-2*t158*t159*t83
            t161 = -7.769549222703733d-4*t156*t89
            t162 = t90*t91*(1.709920934161365d+0*(1.3210398931339265d-3*
     1         t156*t98-3.10907d-2*t92*(2.11607075208357d-1*t151*t71*t96
     2         -1.269642451250142d+0*t70*(7.876233178997433d-1*t71*(-1.3
     3         127055298329054d-1*t151*t152*t93-2.0096226153166658d-3*t1
     4         50)-1.3127055298329054d-1*t151*t152*t94)/t95**2)/t97-2.74
     5         7773264188438d-3*t156*t77+6.21814d-2*t153*t154*t69)+7.769
     6         549222703733d-4*t156*t89-3.37738d-2*t158*t159*t83)
            t163 = -4*t90*t99/t66**5
            t164 = t78**3
            t165 = 1/t66**2
            t166 = t165*t78
            t167 = -t79
            t168 = t167+t166
            t169 = t80**3.333333333333333d-1
            t170 = -t165*t78
            t171 = t79+t170
            t172 = t81**3.333333333333333d-1
            t173 = 5.848223622634648d-1*t82*(4*t164*t91*t99+t163+t162+t1
     1         61+t160)+5.848223622634648d-1*t100*(2.564881401242048d+0*
     2         t171*t172+2.564881401242048d+0*t168*t169)+t157+t155
            t174 = 1.0d+0*t101
            t175 = 1/t133
            t176 = 1/t169
            t177 = 1/t172
            t178 = 3.333333333333333d-1*t171*t177+3.333333333333333d-1*t
     1         168*t176
            t179 = t66**1.6666666666666674d-1
            t180 = 1/t118**3.0d+0
            t181 = -3.994922167200585d-1*t117*t121*t127*t132*t179*t180
            t182 = -3.4242190004576445d-1*t117*t119*t122*t125*t178
            t183 = -3.994922167200585d-1*t117*t121*t125*t179*t180
            t184 = 1/t124**2
            t185 = 1.2128284535269115d+2*t101*t128*t178-4.04276151175637
     1         2d+1*t122*t173
            t186 = -1.7121095002288222d-1*t117*t119*t121*t123*t184*t185
            t187 = 1/t131**2
            t188 = -1.3679488390277675d-1*t117**2*t128*t130*t179/t118**5
     1         .0d+0
            t189 = 1/t115**5.0d+0
            t190 = 1/t124**3.0d+0
            t191 = 2.473556743557577d-2*t116*t134
            t192 = 1/rhob**1.3333333333333333d+0
            t193 = 1/rhob**1.3333333333333336d+0
            t194 = 1/t41**3
            t195 = 1/rhob**6.666666666666667d-1
            t196 = 1/t55
            t197 = 2.11607075208357d-1*t195*t42*t54-1.269642451250142d+0
     1         *t41*(7.876233178997433d-1*t42*(-1.3127055298329054d-1*t1
     2         94*t195*t51-3.169132786263567d-3*t193)-1.3127055298329054
     3         d-1*t194*t195*t52)/t53**2
            t198 = 1/t62
            t199 = 2.11607075208357d-1*t195*t42*t61-1.269642451250142d+0
     1         *t41*(7.876233178997433d-1*t42*(-1.3127055298329054d-1*t1
     2         94*t195*t58-1.7344776604086162d-3*t193)-1.312705529832905
     3         4d-1*t194*t195*t59)/t60**2
            t200 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t198*t199*t
     1         64+7.769549222703733d-4*t192*t63+1.709920934161365d+0*(6.
     2         21814d-2*t196*t197*t57-2.747773264188438d-3*t192*t56-3.10
     3         907d-2*(2.11607075208357d-1*t195*t42*t46-1.26964245125014
     4         2d+0*t41*(7.876233178997433d-1*t42*(-1.3127055298329054d-
     5         1*t194*t195*t43-2.0096226153166658d-3*t193)-1.31270552983
     6         29054d-1*t194*t195*t44)/t45**2)*t50/t47+1.321039893133926
     7         5d-3*t192*t48))+3.37738d-2*t198*t199*t64-7.76954922270373
     8         3d-4*t192*t63)-6.21814d-2*t196*t197*t57+2.747773264188438
     9         d-3*t192*t56
            t201 = 1/t113
            t202 = rhob**1.6666666666666674d-1
            t203 = 1/t102**3.0d+0
            t204 = -6.34154365074529d-1*gammabb*t106*t202*t203
            t205 = 2.1974870225448048d+1*gammabb*t103*t104*t200/t105**2
            t206 = 1/t111**2
            t207 = t79+t166
            t208 = t170+t167
            t209 = 5.848223622634648d-1*t82*(-4*t164*t91*t99+t163+t162+t
     1         161+t160)+5.848223622634648d-1*t100*(2.564881401242048d+0
     2         *t172*t208+2.564881401242048d+0*t169*t207)+t157+t155
            t210 = 3.333333333333333d-1*t177*t208+3.333333333333333d-1*t
     1         176*t207
            t211 = -3.4242190004576445d-1*t117*t119*t122*t125*t210
            t212 = 1.2128284535269115d+2*t101*t128*t210-4.04276151175637
     1         2d+1*t122*t209
            t213 = -1.7121095002288222d-1*t117*t119*t121*t123*t184*t212
            t214 = 1/t27**4.0d+0
            t215 = 1/t118**4.0d+0
            t216 = 2.473556743557577d-2*t116*t175*(-1.7121095002288222d-
     1         1*t117*t119*t121*t127*t187*(5.862637881547574d-2*t117*t12
     2         8*t130*t215+1.7121095002288222d-1*t119*t121*t125)+2.93131
     3         8940773787d-2*t117*t125*t128*t132*t215+1.7121095002288222
     4         d-1*t119*t121*t127*t132)*t66
            t217 = 1/t102**4.0d+0
            fnc(iq) = (2.473556743557577d-2*t116*t134*t66+1.0d+0*t101*t6
     1         6-1.0d+0*rhob*t65-1.2367783717787881d-2*rhoa*t39-1.0d+0*r
     2         hoa*t26-1.2367783717787881d-2*rhob*t114)*wght+fnc(iq)
            Amat(iq,D1_RA) = (2.473556743557577d-2*t116*t175*(-1.7121095
     1         002288222d-1*t117*t119*t121*t127*t187*(-5.862637881547574
     2         d-2*t123*t128*t129*t185*t190-1.172527576309515d-1*t129*t1
     3         30*t178*t189+t188+t186+t183+t182)+1.7121095002288222d-1*t
     4         117*t119*t121*t132*(t186+t183+t182)+t181-3.42421900045764
     5         45d-1*t117*t119*t122*t127*t132*t178)*t66+7.42067023067273
     6         1d-2*t120*t134*t178*t66+1.0d+0*t173*t66-1.236778371778788
     7         1d-2*t39-1.2367783717787881d-2*rhoa*t144*(-6.341543650745
     8         29d-1*gammaaa*t145*t146*t33*t37+2.7178044217479813d-1*gam
     9         maaa*(t148+t147)*t28*t37-2.7178044217479813d-1*gammaaa*t1
     :         49*t28*t33*(-3.4470150749406775d-1*gammaaa**2*t145*t35/t2
     ;         7**5.0d+0+1.1944679893212153d+1*t143*t29*t34/t30**3.0d+0+
     <         t148+t147))-1.0d+0*t26+t191+t174-1.0d+0*rhoa*t143)*wght+A
     =         mat(iq,D1_RA)
            Amat(iq,D1_RB) = (2.473556743557577d-2*t116*t175*(-1.7121095
     1         002288222d-1*t117*t119*t121*t127*t187*(t213-5.86263788154
     2         7574d-2*t123*t128*t129*t190*t212+t211-1.172527576309515d-
     3         1*t129*t130*t189*t210+t188+t183)+1.7121095002288222d-1*t1
     4         17*t119*t121*t132*(t213+t211+t183)-3.4242190004576445d-1*
     5         t117*t119*t122*t127*t132*t210+t181)*t66+7.420670230672731
     6         d-2*t120*t134*t210*t66+1.0d+0*t209*t66-1.0d+0*t65-1.23677
     7         83717787881d-2*rhob*t201*(-2.7178044217479813d-1*gammabb*
     8         t103*t108*(t205+t204-3.4470150749406775d-1*gammabb**2*t11
     9         0*t202/t102**5.0d+0+1.1944679893212153d+1*t104*t109*t200/
     :         t105**3.0d+0)*t206+2.7178044217479813d-1*gammabb*t103*t11
     ;         2*(t205+t204)-6.34154365074529d-1*gammabb*t108*t112*t202*
     <         t203)-1.0d+0*rhob*t200+t191+t174-1.2367783717787881d-2*t1
     =         14)*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GAA) = (t216-1.2367783717787881d-2*rhoa*t144*(2.7
     1         178044217479813d-1*t28*t33*t37+7.386460874872879d-2*gamma
     2         aa*t214*t31*t37-2.7178044217479813d-1*gammaaa*t149*t28*t3
     3         3*(1.477292174974576d-1*gammaaa*t214*t35+2.71780442174798
     4         13d-1*t28*t31)))*wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = 2.473556743557577d-2*t116*t175*(-1.7121095
     1         002288222d-1*t117*t119*t121*t127*t187*(1.172527576309515d
     2         -1*t117*t128*t130*t215+3.4242190004576445d-1*t119*t121*t1
     3         25)+5.862637881547574d-2*t117*t125*t128*t132*t215+3.42421
     4         90004576445d-1*t119*t121*t127*t132)*t66*wght+Cmat(iq,D1_G
     5         AB)
            Cmat(iq,D1_GBB) = (t216-1.2367783717787881d-2*rhob*t201*(-2.
     1         7178044217479813d-1*gammabb*t103*t108*t206*(1.47729217497
     2         4576d-1*gammabb*t110*t217+2.7178044217479813d-1*t103*t106
     3         )+7.386460874872879d-2*gammabb*t106*t112*t217+2.717804421
     4         7479813d-1*t103*t108*t112))*wght+Cmat(iq,D1_GBB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            fnc(iq) = fnc(iq)
            Amat(iq,D1_RA) = Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            fnc(iq) = fnc(iq)
            Amat(iq,D1_RB) = Amat(iq,D1_RB)
            Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_opt functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\alpha^{0.3333333333333333}\\\\ 
C>   {\it t_2} &=& \sqrt{{\it t_1}}\\\\ 
C>   {\it t_3} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_4} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_5} &=& \log \left({{1.269642451250142\,{\it t_2}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.02414199311453321\,{\it t_3}+0.10186556948\right)\,{
C>    \it t_3}+0.22308199064\right)\,{\it t_3}+0.47231125998}}
C>    +1.0\right)\\\\ 
C>   {\it t_6} &=& 0.1325688999052018\,{\it t_4}+1.0\\\\ 
C>   {\it t_7} &=& \log \left({{1.269642451250142\,{\it t_2}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01321299881039884\,{\it t_3}+0.029729725188\right)
C>    \,{\it t_3}+0.12236585478\right)\,{\it t_3}+0.3497952466}}
C>    +1.0\right)\\\\ 
C>   {\it t_8} &=& 0.06901399211255826\,{\it t_4}+1.0\\\\ 
C>   {\it t_9} &=& 0.5848223622634643\,\left(0.0337738\,{\it t_7}
C>    \,{\it t_8}+1.0\,\left(1.709920934161365\,\left(0.0621814\,{
C>    \it t_5}\,{\it t_6}-0.0310907\,\log \left({{1.269642451250142
C>    \,{\it t_2}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01530901310039024\,{\it t_3}+0.10465751434\right)
C>    \,{\it t_3}+0.19269083139\right)\,{\it t_3}+0.43896648423}}
C>    +1.0\right)\,\left(0.1274696188700087\,{\it t_4}
C>    +1.0\right)\right)-0.0337738\,{\it t_7}\,{\it t_8}\right)\right)
C>    -0.0621814\,{\it t_5}\,{\it t_6}\\\\ 
C>   {\it t_{10}} &=& \rho_\beta^{0.3333333333333333}\\\\ 
C>   {\it t_{11}} &=& \sqrt{{\it t_{10}}}\\\\ 
C>   {\it t_{12}} &=& {{1}\over{{\it t_{11}}}}\\\\ 
C>   {\it t_{13}} &=& {{1}\over{{\it t_{10}}}}\\\\ 
C>   {\it t_{14}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{11}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.02414199311453321\,{\it t_{12}}+0.10186556948\right)
C>    \,{\it t_{12}}+0.22308199064\right)\,{\it t_{12}}
C>    +0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{15}} &=& 0.1325688999052018\,{\it t_{13}}+1.0\\\\ 
C>   {\it t_{16}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{11}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01321299881039884\,{\it t_{12}}
C>    +0.029729725188\right)\,{\it t_{12}}+0.12236585478\right)\,{
C>    \it t_{12}}+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{17}} &=& 0.06901399211255826\,{\it t_{13}}+1.0\\\\ 
C>   {\it t_{18}} &=& 0.5848223622634643\,\left(0.0337738\,{
C>    \it t_{16}}\,{\it t_{17}}+1.0\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{14}}\,{\it t_{15}}-0.0310907
C>    \,\log \left({{1.269642451250142\,{\it t_{11}}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01530901310039024\,{\it t_{12}}+0.10465751434\right)
C>    \,{\it t_{12}}+0.19269083139\right)\,{\it t_{12}}
C>    +0.43896648423}}+1.0\right)\,\left(0.1274696188700087\,{
C>    \it t_{13}}+1.0\right)\right)-0.0337738\,{\it t_{16}}\,{
C>    \it t_{17}}\right)\right)-0.0621814\,{\it t_{14}}\,{
C>    \it t_{15}}\\\\ 
C>   {\it t_{19}} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_{20}} &=& {\it t_{19}}^{0.3333333333333333}\\\\ 
C>   {\it t_{21}} &=& {{1}\over{{\it t_{20}}}}\\\\ 
C>   {\it t_{22}} &=& 0.1325688999052018\,{\it t_{21}}+1.0\\\\ 
C>   {\it t_{23}} &=& \sqrt{{\it t_{20}}}\\\\ 
C>   {\it t_{24}} &=& {{1}\over{{\it t_{23}}}}\\\\ 
C>   {\it t_{25}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{23}}}\over{0.7876233178997433\,{\it t_{24}}\,
C>    \left(0.7876233178997433\,{\it t_{24}}\,
C>    \left(0.02414199311453321\,{\it t_{24}}+0.10186556948\right)
C>    +0.22308199064\right)+0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{26}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{27}} &=& {{1}\over{{\it t_{19}}}}\\\\ 
C>   {\it t_{28}} &=& 1.0-{\it t_{26}}\,{\it t_{27}}\\\\ 
C>   {\it t_{29}} &=& {\it t_{26}}\,{\it t_{27}}+1.0\\\\ 
C>   {\it t_{30}} &=& 0.06901399211255826\,{\it t_{21}}+1.0\\\\ 
C>   {\it t_{31}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{23}}}\over{0.7876233178997433\,{\it t_{24}}\,
C>    \left(0.7876233178997433\,{\it t_{24}}\,
C>    \left(0.01321299881039884\,{\it t_{24}}+0.029729725188\right)
C>    +0.12236585478\right)+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{32}} &=& 0.5848223622634648\,\left(1.923661050931536
C>    \,{\it t_{29}}^{{{4}\over{3}}}+1.923661050931536\,{
C>    \it t_{28}}^{{{4}\over{3}}}-3.847322101863072\right)\,
C>    \left({{{\it t_{26}}^4\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{22}}\,{\it t_{25}}-0.0310907\,
C>    \left(0.1274696188700087\,{\it t_{21}}+1.0\right)\,\log 
C>    \left({{1.269642451250142\,{\it t_{23}}}
C>    \over{0.7876233178997433\,{\it t_{24}}\,
C>    \left(0.7876233178997433\,{\it t_{24}}\,
C>    \left(0.01530901310039024\,{\it t_{24}}+0.10465751434\right)
C>    +0.19269083139\right)+0.43896648423}}+1.0\right)\right)
C>    -0.0337738\,{\it t_{30}}\,{\it t_{31}}\right)}\over{{
C>    \it t_{19}}^4}}+0.0337738\,{\it t_{30}}\,{\it t_{31}}\right)
C>    -0.0621814\,{\it t_{22}}\,{\it t_{25}}\\\\ 
C>   {\it t_{33}} &=& {{1}\over{
C>    \left(\rho_\alpha^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_{34}} &=& {{1}\over{e^{80.85523023512745\,{\it t_9}}}}
C>    -1.0\\\\ 
C>   {\it t_{35}} &=& {{0.2717804421747981\,{\it t_{33}}\,
C>    \sigma_{\alpha\alpha}}\over{{\it t_{34}}}}\\\\ 
C>   {\it t_{36}} &=& {{1}\over{
C>    \left(\rho_\beta^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_{37}} &=& {{1}\over{e^{80.85523023512745\,{\it t_{18}}}}}
C>    -1.0\\\\ 
C>   {\it t_{38}} &=& {{0.2717804421747981\,{\it t_{36}}\,
C>    \sigma_{\beta\beta}}\over{{\it t_{37}}}}\\\\ 
C>   {\it t_{39}} &=& 0.5\,{\it t_{29}}^{{{2}\over{3}}}+0.5\,{
C>    \it t_{28}}^{{{2}\over{3}}}\\\\ 
C>   {\it t_{40}} &=& {\it t_{39}}^{3.0}\\\\ 
C>   {\it t_{41}} &=& {{1}\over{\left({
C>    \it t_{19}}^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_{42}} &=& {{1}\over{{\it t_{39}}^{2.0}}}\\\\ 
C>   {\it t_{43}} &=& \sigma_{\beta\beta}+2.0\,\sigma_{\alpha\beta}
C>    +\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{44}} &=& {{1}\over{e^{{{40.42761511756372\,{
C>    \it t_{32}}}\over{{\it t_{40}}}}}}}-1.0\\\\ 
C>   {\it t_{45}} &=& {{0.1712109500228822\,{\it t_{41}}\,{
C>    \it t_{42}}\,{\it t_{43}}}\over{{\it t_{44}}}}\\\\ 
C>   f &=& 0.02473556743557577\,{\it t_{19}}\,{\it t_{40}}
C>    \,\log \left({{0.1712109500228822\,{\it t_{41}}\,{\it t_{42}}
C>    \,{\it t_{43}}\,\left({\it t_{45}}+1.0\right)}
C>    \over{{{0.02931318940773787\,\left({\it t_{41}}\,{
C>    \it t_{43}}\right)^{2.0}}\over{{\it t_{39}}^{4.0}\,{
C>    \it t_{44}}^{2.0}}}+{\it t_{45}}+1.0}}+1.0\right)
C>    -0.01236778371778788\,\rho_\beta\,\log 
C>    \left({{0.2717804421747981\,{\it t_{36}}\,\sigma_{\beta\beta}
C>    \,\left({\it t_{38}}+1.0\right)}\over{{{0.0738646087487288
C>    \,\left({\it t_{36}}\,\sigma_{\beta\beta}\right)^{2.0}}
C>    \over{{\it t_{37}}^{2.0}}}+{\it t_{38}}+1.0}}+1.0\right)
C>    -0.01236778371778788\,\rho_\alpha\,\log 
C>    \left({{0.2717804421747981\,{\it t_{33}}\,
C>    \sigma_{\alpha\alpha}\,\left({\it t_{35}}+1.0\right)}
C>    \over{{{0.0738646087487288\,\left({\it t_{33}}\,
C>    \sigma_{\alpha\alpha}\right)^{2.0}}\over{{\it t_{34}}^{2.0}}}
C>    +{\it t_{35}}+1.0}}+1.0\right)+1.0\,{\it t_{19}}\,{\it t_{32}}
C>    -1.0\,{\it t_{18}}\,\rho_\beta-1.0\,{\it t_9}\,\rho_\alpha\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 0.0\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] NC Handy, AJ Cohen, Mol.Phys. 99, 607 (2001)  , DOI: 
C> <a href="http://dx.doi.org/10.1080/00268970010023435 "> 
C> 10.1080/00268970010023435 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_opt_d2(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,fnc,Amat,Amat2,Cmat,Cmat2) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision rgamma(nq,*) !< [Input] The norm of the density 
                                    !< gradients 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,*)   !< [Output] The derivative wrt rgamma 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,*)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,*)  !< [Output] The 2nd derivative wrt rgamma 
                                    !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          if (rhoa.gt.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1.530901310039024d-2*t3+1.0465751434d-1
            t5 = 7.876233178997433d-1*t3*t4+1.9269083139d-1
            t6 = 7.876233178997433d-1*t3*t5+4.3896648423d-1
            t7 = 1/t6
            t8 = 1.269642451250142d+0*t2*t7+1.0d+0
            t9 = log(t8)
            t10 = 1/t1
            t11 = 1.2746961887000874d-1*t10+1.0d+0
            t12 = 2.4141993114533214d-2*t3+1.0186556948d-1
            t13 = 7.876233178997433d-1*t12*t3+2.2308199064d-1
            t14 = 7.876233178997433d-1*t13*t3+4.7231125998d-1
            t15 = 1/t14
            t16 = 1.269642451250142d+0*t15*t2+1.0d+0
            t17 = log(t16)
            t18 = 1.325688999052018d-1*t10+1.0d+0
            t19 = 1.3212998810398843d-2*t3+2.9729725188d-2
            t20 = 7.876233178997433d-1*t19*t3+1.2236585478d-1
            t21 = 7.876233178997433d-1*t20*t3+3.497952466d-1
            t22 = 1/t21
            t23 = 1.269642451250142d+0*t2*t22+1.0d+0
            t24 = log(t23)
            t25 = 6.901399211255826d-2*t10+1.0d+0
            t26 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t17*t18-3.10907d-2*t11*t9)-3.37738d-2*t24*t25)+3
     2         .37738d-2*t24*t25)-6.21814d-2*t17*t18
            t27 = log(1.4251254664507676d+0*t2/(7.016926042943223d-1*t3*
     1         (7.016926042943223d-1*(2.150807071909054d-2*t3+1.01865569
     2         48d-1)*t3+2.2308199064d-1)+4.7231125998d-1)+1.0d+0)
            t28 = 1.0522000558389215d-1*t10+1.0d+0
            t29 = rhoa**1.1666666666666667d+0
            t30 = 1/t29**2.0d+0
            t31 = exp(-8.085523023512745d+1*t26)
            t32 = t31-1.0d+0
            t33 = 1/t32
            t34 = 2.7178044217479813d-1*gammaaa*t30*t33
            t35 = t34+1.0d+0
            t36 = (gammaaa*t30)**2.0d+0
            t37 = 1/t32**2.0d+0
            t38 = 7.38646087487288d-2*t36*t37+t34+1.0d+0
            t39 = 1/t38
            t40 = 2.7178044217479813d-1*gammaaa*t30*t35*t39+1.0d+0
            t41 = log(t40)
            t42 = exp(2.5138457066712766d+0*t27*t28)-1.0d+0
            t43 = 1.35890221087399d-1*gammaaa*t30/t42
            t44 = 2.1508070719090538d-2*t3+1.0186556948d-1
            t45 = 7.016926042943222d-1*t3*t44+2.2308199064d-1
            t46 = 7.016926042943222d-1*t3*t45+4.7231125998d-1
            t47 = 1/t46
            t48 = 1.425125466450768d+0*t2*t47+1.0d+0
            t49 = log(t48)
            t50 = 1.0522000558389213d-1*t10+1.0d+0
            t51 = 1/rhoa**1.3333333333333333d+0
            t52 = 1/t48
            t53 = 1/t46**2
            t54 = 1/rhoa**1.3333333333333336d+0
            t55 = 1/t2**3
            t56 = 1/rhoa**6.666666666666667d-1
            t57 = -5.847438369119352d-2*t44*t55*t56-1.2576711796854242d-
     1         3*t54
            t58 = 7.016926042943222d-1*t3*t57-5.847438369119352d-2*t45*t
     1         55*t56
            t59 = 1.1876045553756398d-1*t3*t47*t56-1.425125466450768d+0*
     1         t2*t53*t58
            t60 = 1.090454542535705d-3*t49*t51-6.21814d-2*t50*t52*t59
            t61 = 1/t8
            t62 = 1/t6**2
            t63 = -1.3127055298329054d-1*t4*t55*t56-2.0096226153166658d-
     1         3*t54
            t64 = 7.876233178997433d-1*t3*t63-1.3127055298329054d-1*t5*t
     1         55*t56
            t65 = 2.11607075208357d-1*t3*t56*t7-1.269642451250142d+0*t2*
     1         t62*t64
            t66 = 1/t16
            t67 = 1/t14**2
            t68 = -1.3127055298329054d-1*t12*t55*t56-3.169132786263567d-
     1         3*t54
            t69 = 7.876233178997433d-1*t3*t68-1.3127055298329054d-1*t13*
     1         t55*t56
            t70 = 2.11607075208357d-1*t15*t3*t56-1.269642451250142d+0*t2
     1         *t67*t69
            t71 = 1/t23
            t72 = 1/t21**2
            t73 = -1.3127055298329054d-1*t19*t55*t56-1.7344776604086162d
     1         -3*t54
            t74 = 7.876233178997433d-1*t3*t73-1.3127055298329054d-1*t20*
     1         t55*t56
            t75 = 2.11607075208357d-1*t22*t3*t56-1.269642451250142d+0*t2
     1         *t72*t74
            t76 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(1.
     1         3210398931339265d-3*t51*t9+6.21814d-2*t18*t66*t70-3.10907
     2         d-2*t11*t61*t65-2.747773264188438d-3*t17*t51)-3.37738d-2*
     3         t25*t71*t75+7.769549222703733d-4*t24*t51)+3.37738d-2*t25*
     4         t71*t75-7.769549222703733d-4*t24*t51)-6.21814d-2*t18*t66*
     5         t70+2.747773264188438d-3*t17*t51
            t77 = 1/t40
            t78 = rhoa**1.6666666666666674d-1
            t79 = 1/t29**3.0d+0
            t80 = -6.34154365074529d-1*gammaaa*t33*t78*t79
            t81 = 1/t32**2
            t82 = 2.1974870225448048d+1*gammaaa*t30*t31*t76*t81
            t83 = t82+t80
            t84 = 1/t38**2
            t85 = gammaaa**2
            t86 = 1/t29**5.0d+0
            t87 = 1/t32**3.0d+0
            t88 = 1.1944679893212153d+1*t31*t36*t76*t87-3.44701507494067
     1         75d-1*t37*t78*t85*t86+t82+t80
            t89 = -2.7178044217479813d-1*gammaaa*t30*t35*t84*t88+2.71780
     1         44217479813d-1*gammaaa*t30*t39*t83-6.34154365074529d-1*ga
     2         mmaaa*t35*t39*t78*t79
            t90 = exp(2.5138457066712766d+0*t49*t50)
            t91 = t90-1.0d+0
            t92 = 1/t91
            t93 = 1.3589022108739904d-1*gammaaa*t30*t92
            t94 = t93+1.0d+0
            t95 = 1/t91**2.0d+0
            t96 = 1.8466152187182186d-2*t36*t95+t93+1.0d+0
            t97 = 1/t96
            t98 = 1.3589022108739904d-1*gammaaa*t30*t94*t97+1.0d+0
            t99 = 1/t98
            t100 = -1.585385912686322d-1*gammaaa*t78*t79*t92
            t101 = 1/t91**2
            t102 = 5.493717556362009d+0*gammaaa*t101*t30*t60*t90
            t103 = t102+t100
            t104 = 1/t96**2
            t105 = 1/t91**3.0d+0
            t106 = -4.308768843675843d-2*t78*t85*t86*t95+1.4930849866515
     1         178d+0*t105*t36*t60*t90+t102+t100
            t107 = -1.585385912686322d-1*gammaaa*t78*t79*t94*t97+1.35890
     1         22108739904d-1*gammaaa*t103*t30*t97-1.3589022108739904d-1
     2         *gammaaa*t104*t106*t30*t94
            t108 = log(t98)
            t109 = 1/t29**4.0d+0
            t110 = 1.477292174974576d-1*gammaaa*t109*t37+2.7178044217479
     1         813d-1*t30*t33
            t111 = -2.7178044217479813d-1*gammaaa*t110*t30*t35*t84+2.717
     1         8044217479813d-1*t30*t35*t39+7.386460874872879d-2*gammaaa
     2         *t109*t33*t39
            t112 = 9.233076093591093d-3*gammaaa*t109*t95+3.3972555271849
     1         76d-2*t30*t92
            t113 = 3.397255527184976d-2*t30*t94*t97+4.6165380467955464d-
     1         3*gammaaa*t109*t92*t97-1.3589022108739904d-1*gammaaa*t104
     2         *t112*t30*t94
            t114 = 1.8466152187182186d-2*gammaaa*t109*t95+6.794511054369
     1         952d-2*t30*t92
            t115 = 6.794511054369952d-2*t30*t94*t97+9.233076093591093d-3
     1         *gammaaa*t109*t92*t97-1.3589022108739904d-1*gammaaa*t104*
     2         t114*t30*t94
            t116 = 2.0d+0*t60
            t117 = 1/rhoa**2.333333333333333d+0
            t118 = -7.269696950238034d-4*t117*t49
            t119 = log(1.425125466450768d+0*t2/(7.016926042943222d-1*t3*
     1         (7.016926042943222d-1*(1.1771443702974158d-2*t3+2.9729725
     2         188d-2)*t3+1.2236585478d-1)+3.497952466d-1)+1.0d+0)
            t120 = 5.477644184000001d-2*t10+1.0d+0
            t121 = 1/rhoa**2
            t122 = 2.18090908507141d-3*t51*t52*t59
            t123 = 6.21814d-2*t50*t59**2/t48**2
            t124 = 1/rhoa**2.3333333333333334d+0
            t125 = 1/rhoa**1.6666666666666669d+0
            t126 = 1/t2**5
            t127 = -6.21814d-2*t50*t52*(2.850250932901536d+0*t2*t58**2/t
     1         46**3-2.3752091107512796d-1*t3*t53*t56*t58-1.425125466450
     2         768d+0*t2*t53*(-1.1694876738238703d-1*t55*t56*t57+7.01692
     3         6042943222d-1*t3*(1.949146123039784d-2*t125*t44*t55+1.461
     4         8595922798375d-2*t126*t44*t54+9.432533847640683d-4*t124)+
     5         1.949146123039784d-2*t125*t45*t55+1.4618595922798375d-2*t
     6         126*t45*t54)-9.896704628130328d-3*t47*t54*t55-3.958681851
     7         2521327d-2*t125*t3*t47)
            t128 = t127+t123+t122+8.443450000000001d-3*t119*t120*t121+t1
     1         18
            t129 = 1/t16**2
            t130 = t70**2
            t131 = 2.539284902500284d+0*t2*t69**2/t14**3-4.2321415041671
     1         4d-1*t3*t56*t67*t69-1.269642451250142d+0*t2*t67*(-2.62541
     2         1059665811d-1*t55*t56*t68+7.876233178997433d-1*t3*(8.7513
     3         70198886037d-2*t12*t125*t55+6.563527649164527d-2*t12*t126
     4         *t54+4.753699179395351d-3*t124)+8.751370198886037d-2*t125
     5         *t13*t55+6.563527649164527d-2*t126*t13*t54)-3.52678458680
     6         595d-2*t15*t54*t55-1.4107138347223802d-1*t125*t15*t3
            t132 = 1/t23**2
            t133 = t75**2
            t134 = 2.539284902500284d+0*t2*t74**2/t21**3-4.2321415041671
     1         4d-1*t3*t56*t72*t74-1.269642451250142d+0*t2*t72*(-2.62541
     2         1059665811d-1*t55*t56*t73+7.876233178997433d-1*t3*(8.7513
     3         70198886037d-2*t125*t19*t55+6.563527649164527d-2*t126*t19
     4         *t54+2.601716490612924d-3*t124)+8.751370198886037d-2*t125
     5         *t20*t55+6.563527649164527d-2*t126*t20*t54)-3.52678458680
     6         595d-2*t22*t54*t55-1.4107138347223802d-1*t125*t22*t3
            t135 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(-
     1         1.7613865241785687d-3*t117*t9+3.10907d-2*t11*t65**2/t8**2
     2         -5.495546528376876d-3*t51*t66*t70-3.10907d-2*t11*t61*(-3.
     3         52678458680595d-2*t54*t55*t7-1.4107138347223802d-1*t125*t
     4         3*t7+2.539284902500284d+0*t2*t64**2/t6**3-4.2321415041671
     5         4d-1*t3*t56*t62*t64-1.269642451250142d+0*t2*t62*(-2.62541
     6         1059665811d-1*t55*t56*t63+7.876233178997433d-1*t3*(8.7513
     7         70198886037d-2*t125*t4*t55+6.563527649164527d-2*t126*t4*t
     8         54+3.0144339229749983d-3*t124)+8.751370198886037d-2*t125*
     9         t5*t55+6.563527649164527d-2*t126*t5*t54))+6.21814d-2*t131
     :         *t18*t66+2.642079786267853d-3*t51*t61*t65-6.21814d-2*t129
     ;         *t130*t18+3.663697685584584d-3*t117*t17)+1.55390984454074
     <         65d-3*t51*t71*t75-3.37738d-2*t134*t25*t71+3.37738d-2*t132
     =         *t133*t25-1.0359398963604977d-3*t117*t24)-1.5539098445407
     >         465d-3*t51*t71*t75+3.37738d-2*t134*t25*t71-3.37738d-2*t13
     ?         2*t133*t25+1.0359398963604977d-3*t117*t24)+5.495546528376
     @         876d-3*t51*t66*t70-6.21814d-2*t131*t18*t66+6.21814d-2*t12
     1         9*t130*t18-3.663697685584584d-3*t117*t17
            t136 = rhoa**3.333333333333335d-1
            t137 = 1/rhoa**8.333333333333333d-1
            t138 = t76**2
            t139 = exp(-1.617104604702549d+2*t26)
            t140 = 3.553566382931298d+3*gammaaa*t138*t139*t30/t32**3
            t141 = 2.2195402777608514d+0*gammaaa*t109*t136*t33
            t142 = -1.0569239417908823d-1*gammaaa*t137*t33*t79
            t143 = -1.0254939438542422d+2*gammaaa*t31*t76*t78*t79*t81
            t144 = -1.776783191465649d+3*gammaaa*t138*t30*t31*t81
            t145 = 2.1974870225448048d+1*gammaaa*t135*t30*t31*t81
            t146 = 1/t29**6.0d+0
            t147 = 1/t38**3
            t148 = 1/t40**2
            t149 = 1/t98**2
            t150 = -4.947113487115154d-2*rhoa*t107**2*t149
            t151 = 4.947113487115154d-2*t107
            t152 = 2.774425347201063d-1*gammaaa*t109*t136*t94*t97
            t153 = -1.321154927238602d-2*gammaaa*t137*t79*t94*t97
            t154 = -3.170771825372644d-1*gammaaa*t103*t78*t79*t97
            t155 = 3.170771825372644d-1*gammaaa*t104*t106*t78*t79*t94
            t156 = -2.717804421747981d-1*gammaaa*t103*t104*t106*t30
            t157 = 1/t96**3
            t158 = 2.717804421747981d-1*gammaaa*t106**2*t157*t30*t94
            t159 = 2.774425347201063d-1*gammaaa*t109*t136*t92
            t160 = -1.321154927238602d-2*gammaaa*t137*t79*t92
            t161 = 1.5098913454155444d-2*gammaaa*t121*t30*t92
            t162 = -1.281867429817802d+1*gammaaa*t101*t60*t78*t79*t90
            t163 = t60**2
            t164 = -2.2209789893320597d+2*gammaaa*t101*t163*t30*t90
            t165 = 4.189742844452126d-1*t121*t49*t50-4.042761511756372d+
     1         1*t128
            t166 = -1.3589022108739904d-1*gammaaa*t101*t165*t30*t90
            t167 = 1/t91**3
            t168 = exp(5.027691413342553d+0*t49*t50)
            t169 = 4.4419579786641195d+2*gammaaa*t163*t167*t168*t30
            t170 = 1.2567242460721215d-1*t136*t146*t85*t95
            t171 = -3.590640703063204d-3*t137*t85*t86*t95
            t172 = -6.967729937707083d+0*t105*t60*t78*t85*t86*t90
            t173 = 1.8108559553448098d+2*t163*t168*t36/t91**4.0d+0
            t174 = 1/rhoa
            t175 = t127+t123+t122-8.44345d-3*t119*t120*t121+t118
            t176 = -1.509891345415545d-2*gammaaa*t121*t30*t92
            t177 = -2.2209789893320595d+2*gammaaa*t101*t163*t30*t90
            t178 = -4.1897428444521273d-1*t121*t49*t50-4.042761511756372
     1         d+1*t175
            t179 = -1.3589022108739904d-1*gammaaa*t101*t178*t30*t90
            t180 = 4.441957978664119d+2*gammaaa*t163*t167*t168*t30
            t181 = -6.34154365074529d-1*t33*t78*t79
            t182 = 2.1974870225448048d+1*t30*t31*t76*t81
            t183 = -4.947113487115154d-2*rhoa*t107*t113*t149
            t184 = -3.9634647817158053d-2*t78*t79*t92
            t185 = 1.3734293890905022d+0*t101*t30*t60*t90
            t186 = (4.947113487115154d-2*rhoa*(-3.9634647817158053d-2*t7
     1         8*t79*t94*t97-5.385961054594804d-3*gammaaa*t78*t86*t92*t9
     2         7+1.3589022108739904d-1*gammaaa*(t185+t184)*t30*t97+3.397
     3         255527184976d-2*t103*t30*t97-1.3589022108739904d-1*gammaa
     4         a*t104*t30*t94*(-2.1543844218379216d-2*gammaaa*t78*t86*t9
     5         5+7.465424933257588d-1*gammaaa*t105*t109*t60*t90+t185+t18
     6         4)+1.585385912686322d-1*gammaaa*t104*t112*t78*t79*t94+2.7
     7         17804421747981d-1*gammaaa*t106*t112*t157*t30*t94-3.397255
     8         527184976d-2*t104*t106*t30*t94-4.6165380467955464d-3*gamm
     9         aaa*t104*t106*t109*t92-1.3589022108739904d-1*gammaaa*t103
     :         *t104*t112*t30)+2.473556743557577d-2*t113)*t99
            t187 = -7.926929563431611d-2*t78*t79*t92
            t188 = 2.7468587781810044d+0*t101*t30*t60*t90
            t189 = -4.947113487115154d-2*rhoa*t113**2*t149
            t190 = -6.794511054369952d-2*t104*t112*t30*t94
            t191 = -9.233076093591093d-3*gammaaa*t104*t109*t112*t92
            t192 = 4.947113487115154d-2*rhoa*(2.3082690233977732d-3*t109
     1         *t92*t97-3.136711879187181d-4*gammaaa*t104*t146*t94*t95+2
     2         .717804421747981d-1*gammaaa*t112**2*t157*t30*t94+t191+t19
     3         0)*t99
            fnc(iq) = (4.947113487115154d-2*rhoa*log(1.35890221087399d-1
     1         *gammaaa*t30*(t43+1.0d+0)/(t43+1.8466152187182178d-2*t36/
     2         t42**2.0d+0+1.0d+0)+1.0d+0)-2.4735567435575762d-2*rhoa*t4
     3         1-1.243628d-1*rhoa*t27*t28-2.0d+0*rhoa*t26)*wght+fnc(iq)
            Amat(iq,D1_RA) = (4.947113487115154d-2*rhoa*t107*t99-1.23677
     1         83717787881d-2*rhoa*t77*t89-1.0d+0*rhoa*t76+2.0d+0*rhoa*t
     2         60-6.21814d-2*t49*t50-1.2367783717787881d-2*t41-1.0d+0*t2
     3         6+2.473556743557577d-2*t108)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = (4.947113487115154d-2*rhoa*t113*t99-1.2367
     1         783717787881d-2*rhoa*t111*t77)*wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = 4.947113487115154d-2*rhoa*t115*t99*wght+Cm
     1         at(iq,D1_GAB)
            Amat2(iq,D2_RA_RA) = ((4.947113487115154d-2*rhoa*(1.50989134
     1         54155444d-2*gammaaa*t121*t30*t94*t97+1.3589022108739904d-
     2         1*gammaaa*(t169+t166+t164+t162+t161+t160+t159)*t30*t97-1.
     3         3589022108739904d-1*gammaaa*t104*t30*t94*(4.1035893749293
     4         734d-3*t121*t36*t95-3.693230437436437d-2*t105*t165*t36*t9
     5         0-6.036186517816032d+1*t105*t163*t36*t90+t173+t172+t171+t
     6         170+t169+t166+t164+t162+t161+t160+t159)+t158+t156+t155+t1
     7         54+t153+t152)+t151)*t99+1.2367783717787881d-2*rhoa*t148*t
     8         89**2+t77*(-2.4735567435575762d-2*t89-1.2367783717787881d
     9         -2*rhoa*(5.435608843495963d-1*gammaaa*t147*t30*t35*t88**2
     :         -5.435608843495963d-1*gammaaa*t30*t83*t84*t88+1.268308730
     ;         149058d+0*gammaaa*t35*t78*t79*t84*t88-2.7178044217479813d
     <         -1*gammaaa*t30*t35*t84*(-1.1148367900331342d+2*t31*t76*t7
     =         8*t85*t86*t87-9.657898428505661d+2*t138*t31*t36*t87+1.194
     >         4679893212153d+1*t135*t31*t36*t87-5.745025124901132d-2*t1
     ?         37*t37*t85*t86+2.0107587937153953d+0*t136*t146*t37*t85+2.
     @         897369528551698d+3*t138*t139*t36/t32**4.0d+0+t145+t144+t1
     1         43+t142+t141+t140)-1.268308730149058d+0*gammaaa*t39*t78*t
     2         79*t83-1.0569239417908823d-1*gammaaa*t137*t35*t39*t79+2.2
     3         195402777608514d+0*gammaaa*t109*t136*t35*t39+2.7178044217
     4         479813d-1*gammaaa*(t145+t144+t143+t142+t141+t140)*t30*t39
     5         ))-2.0d+0*t76-8.245189145191921d-3*t108*t174+t150-1.0d+0*
     6         rhoa*t135+2.0d+0*rhoa*t128+t116)*wght+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = ((4.947113487115154d-2*rhoa*(-1.5098913
     1         45415545d-2*gammaaa*t121*t30*t94*t97+1.3589022108739904d-
     2         1*gammaaa*(t180+t179+t177+t176+t162+t160+t159)*t30*t97-1.
     3         3589022108739904d-1*gammaaa*t104*t30*t94*(-4.103589374929
     4         3745d-3*t121*t36*t95-3.693230437436437d-2*t105*t178*t36*t
     5         90-6.036186517816031d+1*t105*t163*t36*t90+t180+t179+t177+
     6         t176+t173+t172+t171+t170+t162+t160+t159)+t158+t156+t155+t
     7         154+t153+t152)+t151)*t99+2.0d+0*rhoa*t175+8.2451891451919
     8         22d-3*t108*t174+t150+t116)*wght+Amat2(iq,D2_RA_RB)
            Cmat2(iq,D2_RA_GAA) = (1.2367783717787881d-2*rhoa*t111*t148*
     1         t89+t77*(-1.2367783717787881d-2*rhoa*(-2.7178044217479813
     2         d-1*t30*t35*t84*t88-7.386460874872879d-2*gammaaa*t109*t33
     3         *t84*t88+5.435608843495963d-1*gammaaa*t110*t147*t30*t35*t
     4         88-2.7178044217479813d-1*gammaaa*t30*t35*t84*(2.388935978
     5         6424305d+1*gammaaa*t109*t31*t76*t87-6.894030149881355d-1*
     6         gammaaa*t37*t78*t86+t182+t181)-1.7235075374703387d-1*gamm
     7         aaa*t33*t39*t78*t86-2.7178044217479813d-1*gammaaa*t110*t3
     8         0*t83*t84+6.34154365074529d-1*gammaaa*t110*t35*t78*t79*t8
     9         4+2.7178044217479813d-1*t30*t39*t83-6.34154365074529d-1*t
     :         35*t39*t78*t79+2.7178044217479813d-1*gammaaa*(t182+t181)*
     ;         t30*t39)-1.2367783717787881d-2*t111)+t186+t183)*wght+Cmat
     <         2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = ((4.947113487115154d-2*rhoa*(-7.926929
     1         563431611d-2*t78*t79*t94*t97-1.0771922109189608d-2*gammaa
     2         a*t78*t86*t92*t97+1.3589022108739904d-1*gammaaa*(t188+t18
     3         7)*t30*t97+6.794511054369952d-2*t103*t30*t97-1.3589022108
     4         739904d-1*gammaaa*t104*t30*t94*(-4.308768843675843d-2*gam
     5         maaa*t78*t86*t95+1.4930849866515178d+0*gammaaa*t105*t109*
     6         t60*t90+t188+t187)+1.585385912686322d-1*gammaaa*t104*t114
     7         *t78*t79*t94+2.717804421747981d-1*gammaaa*t106*t114*t157*
     8         t30*t94-6.794511054369952d-2*t104*t106*t30*t94-9.23307609
     9         3591093d-3*gammaaa*t104*t106*t109*t92-1.3589022108739904d
     :         -1*gammaaa*t103*t104*t114*t30)+2.473556743557577d-2*t115)
     ;         *t99-4.947113487115154d-2*rhoa*t107*t115*t149)*wght+Cmat2
     <         (iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = (t186+t183)*wght+Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_GAA_GAA) = (-1.2367783717787881d-2*rhoa*t77*(-4.
     1         014991205359595d-2*gammaaa*t146*t35*t37*t84-5.43560884349
     2         5963d-1*t110*t30*t35*t84-1.4772921749745757d-1*gammaaa*t1
     3         09*t110*t33*t84+1.4772921749745757d-1*t109*t33*t39+5.4356
     4         08843495963d-1*gammaaa*t110**2*t147*t30*t35)+t192+t189+1.
     5         2367783717787881d-2*rhoa*t111**2*t148)*wght+Cmat2(iq,D2_G
     6         AA_GAA)
            Cmat2(iq,D2_GAA_GAB) = (4.947113487115154d-2*rhoa*(4.6165380
     1         467955464d-3*t109*t92*t97-6.273423758374362d-4*gammaaa*t1
     2         04*t146*t94*t95+2.717804421747981d-1*gammaaa*t112*t114*t1
     3         57*t30*t94-3.397255527184976d-2*t104*t114*t30*t94-4.61653
     4         80467955464d-3*gammaaa*t104*t109*t114*t92+t191+t190)*t99-
     5         4.947113487115154d-2*rhoa*t113*t115*t149)*wght+Cmat2(iq,D
     6         2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = (t192+t189)*wght+Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = 4.947113487115154d-2*rhoa*(9.23307609
     1         3591093d-3*t109*t92*t97-1.2546847516748727d-3*gammaaa*t10
     2         4*t146*t94*t95+2.717804421747981d-1*gammaaa*t114**2*t157*
     3         t30*t94-1.3589022108739904d-1*t104*t114*t30*t94-1.8466152
     4         187182186d-2*gammaaa*t104*t109*t114*t92)*t99*wght-4.94711
     5         3487115154d-2*rhoa*t115**2*t149*wght+Cmat2(iq,D2_GAB_GAB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1.530901310039024d-2*t3+1.0465751434d-1
            t5 = 7.876233178997433d-1*t3*t4+1.9269083139d-1
            t6 = 7.876233178997433d-1*t3*t5+4.3896648423d-1
            t7 = 1/t6
            t8 = 1.269642451250142d+0*t2*t7+1.0d+0
            t9 = log(t8)
            t10 = 1/t1
            t11 = 1.2746961887000874d-1*t10+1.0d+0
            t12 = 2.4141993114533214d-2*t3+1.0186556948d-1
            t13 = 7.876233178997433d-1*t12*t3+2.2308199064d-1
            t14 = 7.876233178997433d-1*t13*t3+4.7231125998d-1
            t15 = 1/t14
            t16 = 1.269642451250142d+0*t15*t2+1.0d+0
            t17 = log(t16)
            t18 = 1.325688999052018d-1*t10+1.0d+0
            t19 = 1.3212998810398843d-2*t3+2.9729725188d-2
            t20 = 7.876233178997433d-1*t19*t3+1.2236585478d-1
            t21 = 7.876233178997433d-1*t20*t3+3.497952466d-1
            t22 = 1/t21
            t23 = 1.269642451250142d+0*t2*t22+1.0d+0
            t24 = log(t23)
            t25 = 6.901399211255826d-2*t10+1.0d+0
            t26 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t17*t18-3.10907d-2*t11*t9)-3.37738d-2*t24*t25)+3
     2         .37738d-2*t24*t25)-6.21814d-2*t17*t18
            t27 = rhoa**1.1666666666666667d+0
            t28 = 1/t27**2.0d+0
            t29 = exp(-8.085523023512745d+1*t26)
            t30 = t29-1.0d+0
            t31 = 1/t30
            t32 = 2.7178044217479813d-1*gammaaa*t28*t31
            t33 = t32+1.0d+0
            t34 = (gammaaa*t28)**2.0d+0
            t35 = 1/t30**2.0d+0
            t36 = 7.38646087487288d-2*t34*t35+t32+1.0d+0
            t37 = 1/t36
            t38 = 2.7178044217479813d-1*gammaaa*t28*t33*t37+1.0d+0
            t39 = log(t38)
            t40 = rhob**3.333333333333333d-1
            t41 = t40**5.0d-1
            t42 = 1/t41
            t43 = 1.530901310039024d-2*t42+1.0465751434d-1
            t44 = 7.876233178997433d-1*t42*t43+1.9269083139d-1
            t45 = 7.876233178997433d-1*t42*t44+4.3896648423d-1
            t46 = 1/t45
            t47 = 1.269642451250142d+0*t41*t46+1.0d+0
            t48 = log(t47)
            t49 = 1/t40
            t50 = 1.2746961887000874d-1*t49+1.0d+0
            t51 = 2.4141993114533214d-2*t42+1.0186556948d-1
            t52 = 7.876233178997433d-1*t42*t51+2.2308199064d-1
            t53 = 7.876233178997433d-1*t42*t52+4.7231125998d-1
            t54 = 1/t53
            t55 = 1.269642451250142d+0*t41*t54+1.0d+0
            t56 = log(t55)
            t57 = 1.325688999052018d-1*t49+1.0d+0
            t58 = 1.3212998810398843d-2*t42+2.9729725188d-2
            t59 = 7.876233178997433d-1*t42*t58+1.2236585478d-1
            t60 = 7.876233178997433d-1*t42*t59+3.497952466d-1
            t61 = 1/t60
            t62 = 1.269642451250142d+0*t41*t61+1.0d+0
            t63 = log(t62)
            t64 = 6.901399211255826d-2*t49+1.0d+0
            t65 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t56*t57-3.10907d-2*t48*t50)-3.37738d-2*t63*t64)+
     2         3.37738d-2*t63*t64)-6.21814d-2*t56*t57
            t66 = rhob+rhoa
            t67 = t66**3.333333333333333d-1
            t68 = 1/t67
            t69 = 1.325688999052018d-1*t68+1.0d+0
            t70 = t67**5.0d-1
            t71 = 1/t70
            t72 = 2.4141993114533214d-2*t71+1.0186556948d-1
            t73 = 7.876233178997433d-1*t71*t72+2.2308199064d-1
            t74 = 7.876233178997433d-1*t71*t73+4.7231125998d-1
            t75 = 1/t74
            t76 = 1.269642451250142d+0*t70*t75+1.0d+0
            t77 = log(t76)
            t78 = rhoa-rhob
            t79 = 1/t66
            t80 = 1.0d+0-t78*t79
            t81 = t80**1.3333333333333333d+0
            t82 = t78*t79+1.0d+0
            t83 = t82**1.3333333333333333d+0
            t84 = 1.923661050931536d+0*t83+1.923661050931536d+0*t81-3.84
     1         7322101863072d+0
            t85 = 6.901399211255826d-2*t68+1.0d+0
            t86 = 1.3212998810398843d-2*t71+2.9729725188d-2
            t87 = 7.876233178997433d-1*t71*t86+1.2236585478d-1
            t88 = 7.876233178997433d-1*t71*t87+3.497952466d-1
            t89 = 1/t88
            t90 = 1.269642451250142d+0*t70*t89+1.0d+0
            t91 = log(t90)
            t92 = t78**4
            t93 = 1/t66**4
            t94 = 1.2746961887000874d-1*t68+1.0d+0
            t95 = 1.530901310039024d-2*t71+1.0465751434d-1
            t96 = 7.876233178997433d-1*t71*t95+1.9269083139d-1
            t97 = 7.876233178997433d-1*t71*t96+4.3896648423d-1
            t98 = 1/t97
            t99 = 1.269642451250142d+0*t70*t98+1.0d+0
            t100 = log(t99)
            t101 = 1.709920934161365d+0*(6.21814d-2*t69*t77-3.10907d-2*t
     1         100*t94)-3.37738d-2*t85*t91
            t102 = t101*t92*t93+3.37738d-2*t85*t91
            t103 = 5.848223622634648d-1*t102*t84-6.21814d-2*t69*t77
            t104 = rhob**1.1666666666666667d+0
            t105 = 1/t104**2.0d+0
            t106 = exp(-8.085523023512745d+1*t65)
            t107 = t106-1.0d+0
            t108 = 1/t107
            t109 = 2.7178044217479813d-1*gammabb*t105*t108
            t110 = t109+1.0d+0
            t111 = (gammabb*t105)**2.0d+0
            t112 = 1/t107**2.0d+0
            t113 = 7.38646087487288d-2*t111*t112+t109+1.0d+0
            t114 = 1/t113
            t115 = 2.7178044217479813d-1*gammabb*t105*t110*t114+1.0d+0
            t116 = log(t115)
            t117 = t80**6.666666666666666d-1
            t118 = t82**6.666666666666666d-1
            t119 = 5.0d-1*t118+5.0d-1*t117
            t120 = t119**3.0d+0
            t121 = gammabb+2.0d+0*gammaab+gammaaa
            t122 = t66**1.1666666666666667d+0
            t123 = 1/t122**2.0d+0
            t124 = t119**2.0d+0
            t125 = 1/t124
            t126 = 1/t120
            t127 = exp(-4.042761511756372d+1*t103*t126)
            t128 = t127-1.0d+0
            t129 = 1/t128
            t130 = 1.7121095002288222d-1*t121*t123*t125*t129
            t131 = t130+1.0d+0
            t132 = 1/t119**4.0d+0
            t133 = (t121*t123)**2.0d+0
            t134 = 1/t128**2.0d+0
            t135 = 2.931318940773787d-2*t132*t133*t134+t130+1.0d+0
            t136 = 1/t135
            t137 = 1.7121095002288222d-1*t121*t123*t125*t131*t136+1.0d+0
            t138 = log(t137)
            t139 = 1/rhoa**1.3333333333333333d+0
            t140 = 1/t8
            t141 = 1/t6**2
            t142 = 1/rhoa**1.3333333333333336d+0
            t143 = 1/t2**3
            t144 = 1/rhoa**6.666666666666667d-1
            t145 = -1.3127055298329054d-1*t143*t144*t4-2.009622615316665
     1         8d-3*t142
            t146 = 7.876233178997433d-1*t145*t3-1.3127055298329054d-1*t1
     1         43*t144*t5
            t147 = 2.11607075208357d-1*t144*t3*t7-1.269642451250142d+0*t
     1         141*t146*t2
            t148 = 1/t16
            t149 = 1/t14**2
            t150 = -1.3127055298329054d-1*t12*t143*t144-3.16913278626356
     1         7d-3*t142
            t151 = 7.876233178997433d-1*t150*t3-1.3127055298329054d-1*t1
     1         3*t143*t144
            t152 = 2.11607075208357d-1*t144*t15*t3-1.269642451250142d+0*
     1         t149*t151*t2
            t153 = 1/t23
            t154 = 1/t21**2
            t155 = -1.3127055298329054d-1*t143*t144*t19-1.73447766040861
     1         62d-3*t142
            t156 = 7.876233178997433d-1*t155*t3-1.3127055298329054d-1*t1
     1         43*t144*t20
            t157 = 2.11607075208357d-1*t144*t22*t3-1.269642451250142d+0*
     1         t154*t156*t2
            t158 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(1
     1         .3210398931339265d-3*t139*t9+6.21814d-2*t148*t152*t18-2.7
     2         47773264188438d-3*t139*t17-3.10907d-2*t11*t140*t147)-3.37
     3         738d-2*t153*t157*t25+7.769549222703733d-4*t139*t24)+3.377
     4         38d-2*t153*t157*t25-7.769549222703733d-4*t139*t24)-6.2181
     5         4d-2*t148*t152*t18+2.747773264188438d-3*t139*t17
            t159 = 1/t38
            t160 = rhoa**1.6666666666666674d-1
            t161 = 1/t27**3.0d+0
            t162 = -6.34154365074529d-1*gammaaa*t160*t161*t31
            t163 = 1/t30**2
            t164 = 2.1974870225448048d+1*gammaaa*t158*t163*t28*t29
            t165 = t164+t162
            t166 = 1/t36**2
            t167 = gammaaa**2
            t168 = 1/t27**5.0d+0
            t169 = 1/t30**3.0d+0
            t170 = -3.4470150749406775d-1*t160*t167*t168*t35+1.194467989
     1         3212153d+1*t158*t169*t29*t34+t164+t162
            t171 = -6.34154365074529d-1*gammaaa*t160*t161*t33*t37+2.7178
     1         044217479813d-1*gammaaa*t165*t28*t37-2.7178044217479813d-
     2         1*gammaaa*t166*t170*t28*t33
            t172 = 1/t66**1.3333333333333336d+0
            t173 = 1/t66**6.666666666666667d-1
            t174 = 1/t70**3
            t175 = -1.3127055298329054d-1*t173*t174*t72-3.16913278626356
     1         7d-3*t172
            t176 = 7.876233178997433d-1*t175*t71-1.3127055298329054d-1*t
     1         173*t174*t73
            t177 = 1/t74**2
            t178 = 2.11607075208357d-1*t173*t71*t75-1.269642451250142d+0
     1         *t176*t177*t70
            t179 = 1/t76
            t180 = -6.21814d-2*t178*t179*t69
            t181 = 1/t66**1.3333333333333333d+0
            t182 = 2.747773264188438d-3*t181*t77
            t183 = -1.3127055298329054d-1*t173*t174*t86-1.73447766040861
     1         62d-3*t172
            t184 = 7.876233178997433d-1*t183*t71-1.3127055298329054d-1*t
     1         173*t174*t87
            t185 = 1/t88**2
            t186 = 2.11607075208357d-1*t173*t71*t89-1.269642451250142d+0
     1         *t184*t185*t70
            t187 = 1/t90
            t188 = 3.37738d-2*t186*t187*t85
            t189 = -7.769549222703733d-4*t181*t91
            t190 = -1.3127055298329054d-1*t173*t174*t95-2.00962261531666
     1         58d-3*t172
            t191 = 7.876233178997433d-1*t190*t71-1.3127055298329054d-1*t
     1         173*t174*t96
            t192 = 1/t97**2
            t193 = 2.11607075208357d-1*t173*t71*t98-1.269642451250142d+0
     1         *t191*t192*t70
            t194 = 1/t99
            t195 = 1.709920934161365d+0*(-3.10907d-2*t193*t194*t94-2.747
     1         773264188438d-3*t181*t77+6.21814d-2*t178*t179*t69+1.32103
     2         98931339265d-3*t100*t181)+7.769549222703733d-4*t181*t91-3
     3         .37738d-2*t186*t187*t85
            t196 = t195*t92*t93
            t197 = 1/t66**5
            t198 = -4*t101*t197*t92
            t199 = t78**3
            t200 = 4*t101*t199*t93+t198+t196+t189+t188
            t201 = 1/t66**2
            t202 = t201*t78
            t203 = -t79
            t204 = t203+t202
            t205 = t80**3.333333333333333d-1
            t206 = -t201*t78
            t207 = t79+t206
            t208 = t82**3.333333333333333d-1
            t209 = 2.564881401242048d+0*t207*t208+2.564881401242048d+0*t
     1         204*t205
            t210 = 5.848223622634648d-1*t200*t84+5.848223622634648d-1*t1
     1         02*t209+t182+t180
            t211 = 1.0d+0*t103
            t212 = 1/t137
            t213 = 1/t205
            t214 = 1/t208
            t215 = 3.333333333333333d-1*t207*t214+3.333333333333333d-1*t
     1         204*t213
            t216 = t66**1.6666666666666674d-1
            t217 = 1/t122**3.0d+0
            t218 = -3.994922167200585d-1*t121*t125*t131*t136*t216*t217
            t219 = -3.4242190004576445d-1*t121*t123*t126*t129*t215
            t220 = -3.994922167200585d-1*t121*t125*t129*t216*t217
            t221 = 1/t128**2
            t222 = 1.2128284535269115d+2*t103*t132*t215-4.04276151175637
     1         2d+1*t126*t210
            t223 = -1.7121095002288222d-1*t121*t123*t125*t127*t221*t222
            t224 = t223+t220+t219
            t225 = 1/t135**2
            t226 = t121**2
            t227 = 1/t122**5.0d+0
            t228 = -1.3679488390277675d-1*t132*t134*t216*t226*t227
            t229 = 1/t119**5.0d+0
            t230 = 1/t128**3.0d+0
            t231 = -5.862637881547574d-2*t127*t132*t133*t222*t230-1.1725
     1         27576309515d-1*t133*t134*t215*t229+t228+t223+t220+t219
            t232 = -1.7121095002288222d-1*t121*t123*t125*t131*t225*t231+
     1         1.7121095002288222d-1*t121*t123*t125*t136*t224+t218-3.424
     2         2190004576445d-1*t121*t123*t126*t131*t136*t215
            t233 = 2.473556743557577d-2*t120*t138
            t234 = 1/rhob**1.3333333333333333d+0
            t235 = 1/t47
            t236 = 1/t45**2
            t237 = 1/rhob**1.3333333333333336d+0
            t238 = 1/t41**3
            t239 = 1/rhob**6.666666666666667d-1
            t240 = -1.3127055298329054d-1*t238*t239*t43-2.00962261531666
     1         58d-3*t237
            t241 = 7.876233178997433d-1*t240*t42-1.3127055298329054d-1*t
     1         238*t239*t44
            t242 = 2.11607075208357d-1*t239*t42*t46-1.269642451250142d+0
     1         *t236*t241*t41
            t243 = 1/t55
            t244 = 1/t53**2
            t245 = -1.3127055298329054d-1*t238*t239*t51-3.16913278626356
     1         7d-3*t237
            t246 = 7.876233178997433d-1*t245*t42-1.3127055298329054d-1*t
     1         238*t239*t52
            t247 = 2.11607075208357d-1*t239*t42*t54-1.269642451250142d+0
     1         *t244*t246*t41
            t248 = 1/t62
            t249 = 1/t60**2
            t250 = -1.3127055298329054d-1*t238*t239*t58-1.73447766040861
     1         62d-3*t237
            t251 = 7.876233178997433d-1*t250*t42-1.3127055298329054d-1*t
     1         238*t239*t59
            t252 = 2.11607075208357d-1*t239*t42*t61-1.269642451250142d+0
     1         *t249*t251*t41
            t253 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t248*t252*t
     1         64+7.769549222703733d-4*t234*t63+1.709920934161365d+0*(6.
     2         21814d-2*t243*t247*t57-2.747773264188438d-3*t234*t56-3.10
     3         907d-2*t235*t242*t50+1.3210398931339265d-3*t234*t48))+3.3
     4         7738d-2*t248*t252*t64-7.769549222703733d-4*t234*t63)-6.21
     5         814d-2*t243*t247*t57+2.747773264188438d-3*t234*t56
            t254 = 1/t115
            t255 = rhob**1.6666666666666674d-1
            t256 = 1/t104**3.0d+0
            t257 = -6.34154365074529d-1*gammabb*t108*t255*t256
            t258 = 1/t107**2
            t259 = 2.1974870225448048d+1*gammabb*t105*t106*t253*t258
            t260 = t259+t257
            t261 = 1/t113**2
            t262 = gammabb**2
            t263 = 1/t104**5.0d+0
            t264 = 1/t107**3.0d+0
            t265 = 1.1944679893212153d+1*t106*t111*t253*t264-3.447015074
     1         9406775d-1*t112*t255*t262*t263+t259+t257
            t266 = -2.7178044217479813d-1*gammabb*t105*t110*t261*t265+2.
     1         7178044217479813d-1*gammabb*t105*t114*t260-6.341543650745
     2         29d-1*gammabb*t110*t114*t255*t256
            t267 = -4*t101*t199*t93+t198+t196+t189+t188
            t268 = t79+t202
            t269 = t206+t203
            t270 = 2.564881401242048d+0*t208*t269+2.564881401242048d+0*t
     1         205*t268
            t271 = 5.848223622634648d-1*t267*t84+5.848223622634648d-1*t1
     1         02*t270+t182+t180
            t272 = 3.333333333333333d-1*t214*t269+3.333333333333333d-1*t
     1         213*t268
            t273 = -3.4242190004576445d-1*t121*t123*t126*t129*t272
            t274 = 1.2128284535269115d+2*t103*t132*t272-4.04276151175637
     1         2d+1*t126*t271
            t275 = -1.7121095002288222d-1*t121*t123*t125*t127*t221*t274
            t276 = t275+t273+t220
            t277 = t275-5.862637881547574d-2*t127*t132*t133*t230*t274+t2
     1         73-1.172527576309515d-1*t133*t134*t229*t272+t228+t220
            t278 = -1.7121095002288222d-1*t121*t123*t125*t131*t225*t277+
     1         1.7121095002288222d-1*t121*t123*t125*t136*t276-3.42421900
     2         04576445d-1*t121*t123*t126*t131*t136*t272+t218
            t279 = 1/t27**4.0d+0
            t280 = 1.477292174974576d-1*gammaaa*t279*t35+2.7178044217479
     1         813d-1*t28*t31
            t281 = 2.7178044217479813d-1*t28*t33*t37+7.386460874872879d-
     1         2*gammaaa*t279*t31*t37-2.7178044217479813d-1*gammaaa*t166
     2         *t28*t280*t33
            t282 = 1/t122**4.0d+0
            t283 = 5.862637881547574d-2*t121*t132*t134*t282+1.7121095002
     1         288222d-1*t123*t125*t129
            t284 = -1.7121095002288222d-1*t121*t123*t125*t131*t225*t283+
     1         2.931318940773787d-2*t121*t129*t132*t136*t282+1.712109500
     2         2288222d-1*t123*t125*t131*t136
            t285 = 2.473556743557577d-2*t120*t212*t284*t66
            t286 = 1.172527576309515d-1*t121*t132*t134*t282+3.4242190004
     1         576445d-1*t123*t125*t129
            t287 = -1.7121095002288222d-1*t121*t123*t125*t131*t225*t286+
     1         5.862637881547574d-2*t121*t129*t132*t136*t282+3.424219000
     2         4576445d-1*t123*t125*t131*t136
            t288 = 1/t104**4.0d+0
            t289 = 1.477292174974576d-1*gammabb*t112*t288+2.717804421747
     1         9813d-1*t105*t108
            t290 = -2.7178044217479813d-1*gammabb*t105*t110*t261*t289+7.
     1         386460874872879d-2*gammabb*t108*t114*t288+2.7178044217479
     2         813d-1*t105*t110*t114
            t291 = 1/rhoa**2.333333333333333d+0
            t292 = 1/rhoa**2.3333333333333334d+0
            t293 = 1/rhoa**1.6666666666666669d+0
            t294 = 1/t2**5
            t295 = 1/t16**2
            t296 = t152**2
            t297 = -1.269642451250142d+0*t149*t2*(7.876233178997433d-1*(
     1         6.563527649164527d-2*t12*t142*t294+8.751370198886037d-2*t
     2         12*t143*t293+4.753699179395351d-3*t292)*t3+6.563527649164
     3         527d-2*t13*t142*t294+8.751370198886037d-2*t13*t143*t293-2
     4         .625411059665811d-1*t143*t144*t150)-1.4107138347223802d-1
     5         *t15*t293*t3-4.23214150416714d-1*t144*t149*t151*t3+2.5392
     6         84902500284d+0*t151**2*t2/t14**3-3.52678458680595d-2*t142
     7         *t143*t15
            t298 = 1/t23**2
            t299 = t157**2
            t300 = -1.269642451250142d+0*t154*t2*(7.876233178997433d-1*(
     1         6.563527649164527d-2*t142*t19*t294+8.751370198886037d-2*t
     2         143*t19*t293+2.601716490612924d-3*t292)*t3+6.563527649164
     3         527d-2*t142*t20*t294+8.751370198886037d-2*t143*t20*t293-2
     4         .625411059665811d-1*t143*t144*t155)-1.4107138347223802d-1
     5         *t22*t293*t3-4.23214150416714d-1*t144*t154*t156*t3-3.5267
     6         8458680595d-2*t142*t143*t22+2.539284902500284d+0*t156**2*
     7         t2/t21**3
            t301 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(-
     1         1.7613865241785687d-3*t291*t9+3.10907d-2*t11*t147**2/t8**
     2         2-3.10907d-2*t11*t140*(-1.4107138347223802d-1*t293*t3*t7-
     3         3.52678458680595d-2*t142*t143*t7+2.539284902500284d+0*t14
     4         6**2*t2/t6**3-1.269642451250142d+0*t141*t2*(6.56352764916
     5         4527d-2*t142*t294*t5+8.751370198886037d-2*t143*t293*t5+7.
     6         876233178997433d-1*t3*(6.563527649164527d-2*t142*t294*t4+
     7         8.751370198886037d-2*t143*t293*t4+3.0144339229749983d-3*t
     8         292)-2.625411059665811d-1*t143*t144*t145)-4.2321415041671
     9         4d-1*t141*t144*t146*t3)+6.21814d-2*t148*t18*t297-6.21814d
     :         -2*t18*t295*t296+3.663697685584584d-3*t17*t291-5.49554652
     ;         8376876d-3*t139*t148*t152+2.642079786267853d-3*t139*t140*
     <         t147)-3.37738d-2*t153*t25*t300+3.37738d-2*t25*t298*t299-1
     =         .0359398963604977d-3*t24*t291+1.5539098445407465d-3*t139*
     >         t153*t157)+3.37738d-2*t153*t25*t300-3.37738d-2*t25*t298*t
     ?         299+1.0359398963604977d-3*t24*t291-1.5539098445407465d-3*
     @         t139*t153*t157)-6.21814d-2*t148*t18*t297+6.21814d-2*t18*t
     1         295*t296-3.663697685584584d-3*t17*t291+5.495546528376876d
     2         -3*t139*t148*t152
            t302 = rhoa**3.333333333333335d-1
            t303 = 1/rhoa**8.333333333333333d-1
            t304 = t158**2
            t305 = exp(-1.617104604702549d+2*t26)
            t306 = 3.553566382931298d+3*gammaaa*t28*t304*t305/t30**3
            t307 = 2.2195402777608514d+0*gammaaa*t279*t302*t31
            t308 = -1.0569239417908823d-1*gammaaa*t161*t303*t31
            t309 = -1.0254939438542422d+2*gammaaa*t158*t160*t161*t163*t2
     1         9
            t310 = -1.776783191465649d+3*gammaaa*t163*t28*t29*t304
            t311 = 2.1974870225448048d+1*gammaaa*t163*t28*t29*t301
            t312 = 1/t27**6.0d+0
            t313 = 1/t36**3
            t314 = 1/t38**2
            t315 = t178**2
            t316 = 1/t76**2
            t317 = 6.21814d-2*t315*t316*t69
            t318 = 1/t66**2.3333333333333334d+0
            t319 = 1/t70**5
            t320 = 1/t66**1.6666666666666669d+0
            t321 = -1.4107138347223802d-1*t320*t71*t75-3.52678458680595d
     1         -2*t172*t174*t75+2.539284902500284d+0*t176**2*t70/t74**3-
     2         1.269642451250142d+0*t177*t70*(8.751370198886037d-2*t174*
     3         t320*t73+6.563527649164527d-2*t172*t319*t73+7.87623317899
     4         7433d-1*t71*(8.751370198886037d-2*t174*t320*t72+6.5635276
     5         49164527d-2*t172*t319*t72+4.753699179395351d-3*t318)-2.62
     6         5411059665811d-1*t173*t174*t175)-4.23214150416714d-1*t173
     7         *t176*t177*t71
            t322 = -6.21814d-2*t179*t321*t69
            t323 = 5.495546528376876d-3*t178*t179*t181
            t324 = 1/t66**2.333333333333333d+0
            t325 = -3.663697685584584d-3*t324*t77
            t326 = t186**2
            t327 = 1/t90**2
            t328 = -3.37738d-2*t326*t327*t85
            t329 = -1.4107138347223802d-1*t320*t71*t89-3.52678458680595d
     1         -2*t172*t174*t89+2.539284902500284d+0*t184**2*t70/t88**3-
     2         1.269642451250142d+0*t185*t70*(8.751370198886037d-2*t174*
     3         t320*t87+6.563527649164527d-2*t172*t319*t87+7.87623317899
     4         7433d-1*t71*(8.751370198886037d-2*t174*t320*t86+6.5635276
     5         49164527d-2*t172*t319*t86+2.601716490612924d-3*t318)-2.62
     6         5411059665811d-1*t173*t174*t183)-4.23214150416714d-1*t173
     7         *t184*t185*t71
            t330 = 3.37738d-2*t187*t329*t85
            t331 = -1.5539098445407465d-3*t181*t186*t187
            t332 = 1.0359398963604977d-3*t324*t91
            t333 = t92*t93*(1.709920934161365d+0*(3.10907d-2*t193**2*t94
     1         /t99**2-3.10907d-2*t194*t94*(-1.4107138347223802d-1*t320*
     2         t71*t98-3.52678458680595d-2*t172*t174*t98+2.5392849025002
     3         84d+0*t191**2*t70/t97**3-1.269642451250142d+0*t192*t70*(8
     4         .751370198886037d-2*t174*t320*t96+6.563527649164527d-2*t1
     5         72*t319*t96+7.876233178997433d-1*t71*(8.751370198886037d-
     6         2*t174*t320*t95+6.563527649164527d-2*t172*t319*t95+3.0144
     7         339229749983d-3*t318)-2.625411059665811d-1*t173*t174*t190
     8         )-4.23214150416714d-1*t173*t191*t192*t71)+3.6636976855845
     9         84d-3*t324*t77+6.21814d-2*t179*t321*t69-6.21814d-2*t315*t
     :         316*t69-1.7613865241785687d-3*t100*t324+2.642079786267853
     ;         d-3*t181*t193*t194-5.495546528376876d-3*t178*t179*t181)-1
     <         .0359398963604977d-3*t324*t91-3.37738d-2*t187*t329*t85+3.
     =         37738d-2*t326*t327*t85+1.5539098445407465d-3*t181*t186*t1
     >         87)
            t334 = -8*t195*t197*t92
            t335 = 20*t101*t92/t66**6
            t336 = t78**2
            t337 = 12*t101*t336*t93
            t338 = t204**2
            t339 = 1/t117
            t340 = 1/t66**3
            t341 = -2*t340*t78
            t342 = 2*t201
            t343 = t342+t341
            t344 = t207**2
            t345 = 1/t118
            t346 = 2*t340*t78
            t347 = -2*t201
            t348 = t347+t346
            t349 = 5.848223622634648d-1*t84*(8*t195*t199*t93+t337+t335+t
     1         334+t333+t332+t331+t330+t328-32*t101*t197*t199)+5.8482236
     2         22634648d-1*t102*(2.564881401242048d+0*t208*t348+8.549604
     3         670806825d-1*t344*t345+2.564881401242048d+0*t205*t343+8.5
     4         49604670806825d-1*t338*t339)+t325+t323+t322+t317+1.169644
     5         7245269297d+0*t200*t209
            t350 = t215**2
            t351 = 1/t81
            t352 = 1/t83
            t353 = -1.111111111111111d-1*t344*t352-1.111111111111111d-1*
     1         t338*t351+3.333333333333333d-1*t214*t348+3.33333333333333
     2         3d-1*t213*t343
            t354 = t66**3.333333333333335d-1
            t355 = 1.398222758520205d+0*t121*t125*t131*t136*t282*t354
            t356 = 1/t66**8.333333333333333d-1
            t357 = -6.658203612000978d-2*t121*t125*t131*t136*t217*t356
            t358 = 1.0272657001372934d+0*t121*t123*t129*t132*t350
            t359 = -3.4242190004576445d-1*t121*t123*t126*t129*t353
            t360 = 1.5979688668802342d+0*t121*t126*t129*t215*t216*t217
            t361 = 1.398222758520205d+0*t121*t125*t129*t282*t354
            t362 = -6.658203612000978d-2*t121*t125*t129*t217*t356
            t363 = 1.2128284535269115d+2*t103*t132*t353-4.85131381410764
     1         6d+2*t103*t229*t350-4.042761511756372d+1*t126*t349+2.4256
     2         56907053823d+2*t132*t210*t215
            t364 = -1.7121095002288222d-1*t121*t123*t125*t127*t221*t363
            t365 = 6.848438000915289d-1*t121*t123*t126*t127*t215*t221*t2
     1         22
            t366 = 7.98984433440117d-1*t121*t125*t127*t216*t217*t221*t22
     1         2
            t367 = exp(-8.085523023512744d+1*t103*t126)
            t368 = 1/t128**3
            t369 = t222**2
            t370 = 3.4242190004576445d-1*t121*t123*t125*t367*t368*t369
            t371 = -1.7121095002288222d-1*t121*t123*t125*t127*t221*t369
            t372 = 1/t122**6.0d+0
            t373 = 7.979701560995311d-1*t132*t134*t226*t354*t372
            t374 = -2.2799147317129467d-2*t132*t134*t226*t227*t356
            t375 = 1/t119**6.0d+0
            t376 = 1/t128**4.0d+0
            t377 = 1/t135**3
            t378 = 1/t137**2
            t379 = 5.848223622634648d-1*t84*(-12*t101*t336*t93+t335+t334
     1         +t333+t332+t331+t330+t328)+5.848223622634648d-1*t102*(5.1
     2         29762802484096d+0*t208*t340*t78-5.129762802484096d+0*t205
     3         *t340*t78+8.549604670806825d-1*t207*t269*t345+8.549604670
     4         806825d-1*t204*t268*t339)+t325+t323+t322+t317+5.848223622
     5         634648d-1*t200*t270+5.848223622634648d-1*t209*t267
            t380 = 6.666666666666666d-1*t214*t340*t78-6.666666666666666d
     1         -1*t213*t340*t78-1.111111111111111d-1*t207*t269*t352-1.11
     2         1111111111111d-1*t204*t268*t351
            t381 = 1.0272657001372934d+0*t121*t123*t129*t132*t215*t272
            t382 = -3.4242190004576445d-1*t121*t123*t126*t129*t380
            t383 = 7.98984433440117d-1*t121*t126*t129*t216*t217*t272
            t384 = 7.98984433440117d-1*t121*t126*t129*t215*t216*t217
            t385 = 1.2128284535269115d+2*t103*t132*t380-4.04276151175637
     1         2d+1*t126*t379-4.851313814107646d+2*t103*t215*t229*t272+1
     2         .2128284535269115d+2*t132*t210*t272+1.2128284535269115d+2
     3         *t132*t215*t271
            t386 = -1.7121095002288222d-1*t121*t123*t125*t127*t221*t385
            t387 = 3.4242190004576445d-1*t121*t123*t126*t127*t215*t221*t
     1         274
            t388 = 3.994922167200585d-1*t121*t125*t127*t216*t217*t221*t2
     1         74
            t389 = 3.4242190004576445d-1*t121*t123*t126*t127*t221*t222*t
     1         272
            t390 = 3.994922167200585d-1*t121*t125*t127*t216*t217*t221*t2
     1         22
            t391 = 3.4242190004576445d-1*t121*t123*t125*t222*t274*t367*t
     1         368
            t392 = -1.7121095002288222d-1*t121*t123*t125*t127*t221*t222*
     1         t274
            t393 = 1/rhob**2.333333333333333d+0
            t394 = 1/rhob**2.3333333333333334d+0
            t395 = 1/rhob**1.6666666666666669d+0
            t396 = 1/t41**5
            t397 = 1/t55**2
            t398 = t247**2
            t399 = -1.4107138347223802d-1*t395*t42*t54-3.52678458680595d
     1         -2*t237*t238*t54+2.539284902500284d+0*t246**2*t41/t53**3-
     2         1.269642451250142d+0*t244*t41*(6.563527649164527d-2*t237*
     3         t396*t52+8.751370198886037d-2*t238*t395*t52+7.87623317899
     4         7433d-1*t42*(6.563527649164527d-2*t237*t396*t51+8.7513701
     5         98886037d-2*t238*t395*t51+4.753699179395351d-3*t394)-2.62
     6         5411059665811d-1*t238*t239*t245)-4.23214150416714d-1*t239
     7         *t244*t246*t42
            t400 = 1/t62**2
            t401 = t252**2
            t402 = -1.4107138347223802d-1*t395*t42*t61-3.52678458680595d
     1         -2*t237*t238*t61+2.539284902500284d+0*t251**2*t41/t60**3-
     2         1.269642451250142d+0*t249*t41*(6.563527649164527d-2*t237*
     3         t396*t59+8.751370198886037d-2*t238*t395*t59+7.87623317899
     4         7433d-1*t42*(6.563527649164527d-2*t237*t396*t58+8.7513701
     5         98886037d-2*t238*t395*t58+2.601716490612924d-3*t394)-2.62
     6         5411059665811d-1*t238*t239*t250)-4.23214150416714d-1*t239
     7         *t249*t251*t42
            t403 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t248*t402*t
     1         64+3.37738d-2*t400*t401*t64-1.0359398963604977d-3*t393*t6
     2         3+1.709920934161365d+0*(6.21814d-2*t243*t399*t57-6.21814d
     3         -2*t397*t398*t57+3.663697685584584d-3*t393*t56+3.10907d-2
     4         *t242**2*t50/t47**2-3.10907d-2*t235*(-1.4107138347223802d
     5         -1*t395*t42*t46-3.52678458680595d-2*t237*t238*t46+2.53928
     6         4902500284d+0*t241**2*t41/t45**3-1.269642451250142d+0*t23
     7         6*t41*(6.563527649164527d-2*t237*t396*t44+8.7513701988860
     8         37d-2*t238*t395*t44+7.876233178997433d-1*t42*(6.563527649
     9         164527d-2*t237*t396*t43+8.751370198886037d-2*t238*t395*t4
     :         3+3.0144339229749983d-3*t394)-2.625411059665811d-1*t238*t
     ;         239*t240)-4.23214150416714d-1*t236*t239*t241*t42)*t50-1.7
     <         613865241785687d-3*t393*t48-5.495546528376876d-3*t234*t24
     =         3*t247+2.642079786267853d-3*t234*t235*t242)+1.55390984454
     >         07465d-3*t234*t248*t252)+3.37738d-2*t248*t402*t64-3.37738
     ?         d-2*t400*t401*t64+1.0359398963604977d-3*t393*t63-1.553909
     @         8445407465d-3*t234*t248*t252)-6.21814d-2*t243*t399*t57+6.
     1         21814d-2*t397*t398*t57-3.663697685584584d-3*t393*t56+5.49
     2         5546528376876d-3*t234*t243*t247
            t404 = rhob**3.333333333333335d-1
            t405 = 1/rhob**8.333333333333333d-1
            t406 = t253**2
            t407 = exp(-1.617104604702549d+2*t65)
            t408 = 3.553566382931298d+3*gammabb*t105*t406*t407/t107**3
            t409 = 2.2195402777608514d+0*gammabb*t108*t288*t404
            t410 = -1.0569239417908823d-1*gammabb*t108*t256*t405
            t411 = -1.0254939438542422d+2*gammabb*t106*t253*t255*t256*t2
     1         58
            t412 = -1.776783191465649d+3*gammabb*t105*t106*t258*t406
            t413 = 2.1974870225448048d+1*gammabb*t105*t106*t258*t403
            t414 = 1/t104**6.0d+0
            t415 = 1/t113**3
            t416 = 1/t115**2
            t417 = t268**2
            t418 = t347+t341
            t419 = t269**2
            t420 = t346+t342
            t421 = 5.848223622634648d-1*t84*(-8*t195*t199*t93+t337+t335+
     1         t334+t333+t332+t331+t330+t328+32*t101*t197*t199)+5.848223
     2         622634648d-1*t102*(2.564881401242048d+0*t208*t420+8.54960
     3         4670806825d-1*t345*t419+2.564881401242048d+0*t205*t418+8.
     4         549604670806825d-1*t339*t417)+t325+t323+t322+t317+1.16964
     5         47245269297d+0*t267*t270
            t422 = t272**2
            t423 = 3.333333333333333d-1*t214*t420-1.111111111111111d-1*t
     1         352*t419+3.333333333333333d-1*t213*t418-1.111111111111111
     2         d-1*t351*t417
            t424 = 1.0272657001372934d+0*t121*t123*t129*t132*t422
            t425 = -3.4242190004576445d-1*t121*t123*t126*t129*t423
            t426 = 1.5979688668802342d+0*t121*t126*t129*t216*t217*t272
            t427 = 1.2128284535269115d+2*t103*t132*t423-4.85131381410764
     1         6d+2*t103*t229*t422-4.042761511756372d+1*t126*t421+2.4256
     2         56907053823d+2*t132*t271*t272
            t428 = -1.7121095002288222d-1*t121*t123*t125*t127*t221*t427
            t429 = 6.848438000915289d-1*t121*t123*t126*t127*t221*t272*t2
     1         74
            t430 = 7.98984433440117d-1*t121*t125*t127*t216*t217*t221*t27
     1         4
            t431 = t274**2
            t432 = 3.4242190004576445d-1*t121*t123*t125*t367*t368*t431
            t433 = -1.7121095002288222d-1*t121*t123*t125*t127*t221*t431
            t434 = -6.34154365074529d-1*t160*t161*t31
            t435 = 2.1974870225448048d+1*t158*t163*t28*t29
            t436 = -2.473556743557577d-2*t120*t232*t284*t378*t66
            t437 = 2.473556743557577d-2*t120*t284
            t438 = 3.994922167200585d-1*t121*t125*t131*t216*t217*t225*t2
     1         83
            t439 = -3.994922167200585d-1*t125*t131*t136*t216*t217
            t440 = -6.839744195138837d-2*t121*t129*t132*t136*t216*t227
            t441 = -3.4242190004576445d-1*t123*t126*t129*t215
            t442 = -3.994922167200585d-1*t125*t129*t216*t217
            t443 = -1.7121095002288222d-1*t123*t125*t127*t221*t222
            t444 = -2.735897678055535d-1*t121*t132*t134*t216*t227
            t445 = t212*(2.473556743557577d-2*t120*(-1.7121095002288222d
     1         -1*t121*t123*t125*t131*t225*(t444+t443+t442+t441-1.172527
     2         576309515d-1*t121*t127*t132*t222*t230*t282-2.345055152619
     3         03d-1*t121*t134*t215*t229*t282)+1.7121095002288222d-1*t12
     4         1*t123*t125*t136*(t443+t442+t441)+t440+t439+t438+3.424219
     5         0004576445d-1*t121*t123*t125*t131*t231*t283*t377-1.712109
     6         5002288222d-1*t121*t123*t125*t224*t225*t283+3.42421900045
     7         76445d-1*t121*t123*t126*t131*t215*t225*t283-2.93131894077
     8         3787d-2*t121*t129*t132*t225*t231*t282-5.862637881547574d-
     9         2*t121*t129*t136*t215*t229*t282-1.7121095002288222d-1*t12
     :         3*t125*t131*t225*t231+1.7121095002288222d-1*t123*t125*t13
     ;         6*t224-3.4242190004576445d-1*t123*t126*t131*t136*t215)*t6
     <         6+7.420670230672731d-2*t124*t215*t284*t66+t437)
            t446 = 2.473556743557577d-2*t120*t287
            t447 = 3.994922167200585d-1*t121*t125*t131*t216*t217*t225*t2
     1         86
            t448 = -7.98984433440117d-1*t125*t131*t136*t216*t217
            t449 = -1.3679488390277675d-1*t121*t129*t132*t136*t216*t227
            t450 = -6.848438000915289d-1*t123*t126*t129*t215
            t451 = -7.98984433440117d-1*t125*t129*t216*t217
            t452 = -3.4242190004576445d-1*t123*t125*t127*t221*t222
            t453 = -5.47179535611107d-1*t121*t132*t134*t216*t227
            t454 = -2.473556743557577d-2*t120*t278*t284*t378*t66
            t455 = -3.4242190004576445d-1*t123*t126*t129*t272
            t456 = -1.7121095002288222d-1*t123*t125*t127*t221*t274
            t457 = t212*(2.473556743557577d-2*t120*(-1.7121095002288222d
     1         -1*t121*t123*t125*t131*t225*(t456+t455+t444+t442-1.172527
     2         576309515d-1*t121*t127*t132*t230*t274*t282-2.345055152619
     3         03d-1*t121*t134*t229*t272*t282)+1.7121095002288222d-1*t12
     4         1*t123*t125*t136*(t456+t455+t442)+t440+t439+t438+3.424219
     5         0004576445d-1*t121*t123*t125*t131*t277*t283*t377-1.712109
     6         5002288222d-1*t121*t123*t125*t225*t276*t283+3.42421900045
     7         76445d-1*t121*t123*t126*t131*t225*t272*t283-2.93131894077
     8         3787d-2*t121*t129*t132*t225*t277*t282-5.862637881547574d-
     9         2*t121*t129*t136*t229*t272*t282-1.7121095002288222d-1*t12
     :         3*t125*t131*t225*t277+1.7121095002288222d-1*t123*t125*t13
     ;         6*t276-3.4242190004576445d-1*t123*t126*t131*t136*t272)*t6
     <         6+7.420670230672731d-2*t124*t272*t284*t66+t437)
            t458 = -6.848438000915289d-1*t123*t126*t129*t272
            t459 = -3.4242190004576445d-1*t123*t125*t127*t221*t274
            t460 = -6.34154365074529d-1*t108*t255*t256
            t461 = 2.1974870225448048d+1*t105*t106*t253*t258
            t462 = -2.473556743557577d-2*t120*t284**2*t378*t66
            t463 = -3.4242190004576445d-1*t123*t125*t131*t225*t283
            t464 = -5.862637881547574d-2*t121*t129*t132*t225*t282*t283
            t465 = 2.473556743557577d-2*t120*t212*(t464+t463+3.424219000
     1         4576445d-1*t121*t123*t125*t131*t283**2*t377-1.00374780133
     2         9898d-2*t121*t131*t134*t225*t372*t375+5.862637881547574d-
     3         2*t129*t132*t136*t282)*t66
            t466 = t464+t463+3.4242190004576445d-1*t121*t123*t125*t131*t
     1         283*t286*t377-2.007495602679796d-2*t121*t131*t134*t225*t3
     2         72*t375-2.931318940773787d-2*t121*t129*t132*t225*t282*t28
     3         6-1.7121095002288222d-1*t123*t125*t131*t225*t286+1.172527
     4         576309515d-1*t129*t132*t136*t282
            fnc(iq) = (2.473556743557577d-2*t120*t138*t66+1.0d+0*t103*t6
     1         6-1.0d+0*rhob*t65-1.2367783717787881d-2*rhoa*t39-1.0d+0*r
     2         hoa*t26-1.2367783717787881d-2*rhob*t116)*wght+fnc(iq)
            Amat(iq,D1_RA) = (2.473556743557577d-2*t120*t212*t232*t66+7.
     1         420670230672731d-2*t124*t138*t215*t66+1.0d+0*t210*t66-1.2
     2         367783717787881d-2*t39-1.0d+0*t26+t233+t211-1.23677837177
     3         87881d-2*rhoa*t159*t171-1.0d+0*rhoa*t158)*wght+Amat(iq,D1
     4         _RA)
            Amat(iq,D1_RB) = (2.473556743557577d-2*t120*t212*t278*t66+7.
     1         420670230672731d-2*t124*t138*t272*t66+1.0d+0*t271*t66-1.0
     2         d+0*t65-1.2367783717787881d-2*rhob*t254*t266-1.0d+0*rhob*
     3         t253+t233+t211-1.2367783717787881d-2*t116)*wght+Amat(iq,D
     4         1_RB)
            Cmat(iq,D1_GAA) = (t285-1.2367783717787881d-2*rhoa*t159*t281
     1         )*wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = 2.473556743557577d-2*t120*t212*t287*t66*wg
     1         ht+Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = (t285-1.2367783717787881d-2*rhob*t254*t290
     1         )*wght+Cmat(iq,D1_GBB)
            Amat2(iq,D2_RA_RA) = (t212*(2.473556743557577d-2*t120*(3.424
     1         2190004576445d-1*t121*t123*t125*t131*t231**2*t377-1.71210
     2         95002288222d-1*t121*t123*t125*t131*t225*(1.75879136446427
     3         25d-1*t132*t133*t367*t369*t376+5.862637881547574d-1*t133*
     4         t134*t350*t375+t374+t373+t371+t370-5.862637881547574d-2*t
     5         127*t132*t133*t230*t369+t366+t365+t364-5.862637881547574d
     6         -2*t127*t132*t133*t230*t363+t362+t361+t360+t359+t358-1.17
     7         2527576309515d-1*t133*t134*t229*t353+4.69011030523806d-1*
     8         t127*t133*t215*t222*t229*t230+5.47179535611107d-1*t127*t1
     9         32*t216*t222*t226*t227*t230+1.094359071222214d+0*t134*t21
     :         5*t216*t226*t227*t229)+1.7121095002288222d-1*t121*t123*t1
     ;         25*t136*(t371+t370+t366+t365+t364+t362+t361+t360+t359+t35
     <         8)+t357+t355-3.4242190004576445d-1*t121*t123*t126*t131*t1
     =         36*t353+1.0272657001372934d+0*t121*t123*t131*t132*t136*t3
     >         50-3.4242190004576445d-1*t121*t123*t125*t224*t225*t231+7.
     ?         98984433440117d-1*t121*t125*t131*t216*t217*t225*t231+6.84
     @         8438000915289d-1*t121*t123*t126*t131*t215*t225*t231-7.989
     1         84433440117d-1*t121*t125*t136*t216*t217*t224-6.8484380009
     2         15289d-1*t121*t123*t126*t136*t215*t224+1.5979688668802342
     3         d+0*t121*t126*t131*t136*t215*t216*t217)*t66+1.48413404613
     4         45462d-1*t124*t215*t232*t66+4.947113487115154d-2*t120*t23
     5         2)-2.473556743557577d-2*t120*t232**2*t378*t66+7.420670230
     6         672731d-2*t124*t138*t353*t66+1.4841340461345462d-1*t119*t
     7         138*t350*t66+1.0d+0*t349*t66+t159*(-1.2367783717787881d-2
     8         *rhoa*(-1.0569239417908823d-1*gammaaa*t161*t303*t33*t37+2
     9         .2195402777608514d+0*gammaaa*t279*t302*t33*t37+2.71780442
     :         17479813d-1*gammaaa*t28*(t311+t310+t309+t308+t307+t306)*t
     ;         37-1.268308730149058d+0*gammaaa*t160*t161*t165*t37-2.7178
     <         044217479813d-1*gammaaa*t166*t28*t33*(2.0107587937153953d
     =         +0*t167*t302*t312*t35-5.745025124901132d-2*t167*t168*t303
     >         *t35+2.897369528551698d+3*t304*t305*t34/t30**4.0d+0-9.657
     ?         898428505661d+2*t169*t29*t304*t34+1.1944679893212153d+1*t
     @         169*t29*t301*t34+t311+t310+t309+t308+t307+t306-1.11483679
     1         00331342d+2*t158*t160*t167*t168*t169*t29)+5.4356088434959
     2         63d-1*gammaaa*t170**2*t28*t313*t33+1.268308730149058d+0*g
     3         ammaaa*t160*t161*t166*t170*t33-5.435608843495963d-1*gamma
     4         aa*t165*t166*t170*t28)-2.4735567435575762d-2*t171)+1.2367
     5         783717787881d-2*rhoa*t171**2*t314-1.0d+0*rhoa*t301+1.4841
     6         340461345462d-1*t124*t138*t215+2.0d+0*t210-2.0d+0*t158)*w
     7         ght+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = (t212*(2.473556743557577d-2*t120*(-1.71
     1         21095002288222d-1*t121*t123*t125*t131*t225*(t392+t391+t39
     2         0+t389+t388+t387+t386-5.862637881547574d-2*t127*t132*t133
     3         *t230*t385+t384+t383+t382+t381-1.172527576309515d-1*t133*
     4         t134*t229*t380+1.7587913644642725d-1*t132*t133*t222*t274*
     5         t367*t376+5.862637881547574d-1*t133*t134*t215*t272*t375+t
     6         374+t373+t362+t361+2.34505515261903d-1*t127*t133*t215*t22
     7         9*t230*t274+2.735897678055535d-1*t127*t132*t216*t226*t227
     8         *t230*t274-5.862637881547574d-2*t127*t132*t133*t222*t230*
     9         t274+2.34505515261903d-1*t127*t133*t222*t229*t230*t272+5.
     :         47179535611107d-1*t134*t216*t226*t227*t229*t272+2.7358976
     ;         78055535d-1*t127*t132*t216*t222*t226*t227*t230+5.47179535
     <         611107d-1*t134*t215*t216*t226*t227*t229)+1.71210950022882
     =         22d-1*t121*t123*t125*t136*(t392+t391+t390+t389+t388+t387+
     >         t386+t384+t383+t382+t381+t362+t361)-3.4242190004576445d-1
     ?         *t121*t123*t126*t131*t136*t380+3.4242190004576445d-1*t121
     @         *t123*t125*t131*t231*t277*t377+t357+t355-1.71210950022882
     1         22d-1*t121*t123*t125*t224*t225*t277+3.994922167200585d-1*
     2         t121*t125*t131*t216*t217*t225*t277+3.4242190004576445d-1*
     3         t121*t123*t126*t131*t215*t225*t277-1.7121095002288222d-1*
     4         t121*t123*t125*t225*t231*t276-3.994922167200585d-1*t121*t
     5         125*t136*t216*t217*t276-3.4242190004576445d-1*t121*t123*t
     6         126*t136*t215*t276+3.4242190004576445d-1*t121*t123*t126*t
     7         131*t225*t231*t272-3.4242190004576445d-1*t121*t123*t126*t
     8         136*t224*t272+7.98984433440117d-1*t121*t126*t131*t136*t21
     9         6*t217*t272+1.0272657001372934d+0*t121*t123*t131*t132*t13
     :         6*t215*t272+3.994922167200585d-1*t121*t125*t131*t216*t217
     ;         *t225*t231-3.994922167200585d-1*t121*t125*t136*t216*t217*
     <         t224+7.98984433440117d-1*t121*t126*t131*t136*t215*t216*t2
     =         17)*t66+7.420670230672731d-2*t124*t215*t278*t66+7.4206702
     >         30672731d-2*t124*t232*t272*t66+2.473556743557577d-2*t120*
     ?         t278+2.473556743557577d-2*t120*t232)+7.420670230672731d-2
     @         *t124*t138*t380*t66+1.0d+0*t379*t66-2.473556743557577d-2*
     1         t120*t232*t278*t378*t66+1.4841340461345462d-1*t119*t138*t
     2         215*t272*t66+7.420670230672731d-2*t124*t138*t272+1.0d+0*t
     3         271+7.420670230672731d-2*t124*t138*t215+1.0d+0*t210)*wght
     4         +Amat2(iq,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = (t212*(2.473556743557577d-2*t120*(-1.71
     1         21095002288222d-1*t121*t123*t125*t131*t225*(t433+t432+1.7
     2         587913644642725d-1*t132*t133*t367*t376*t431-5.86263788154
     3         7574d-2*t127*t132*t133*t230*t431+t430+t429+t428-5.8626378
     4         81547574d-2*t127*t132*t133*t230*t427+t426+t425+t424-1.172
     5         527576309515d-1*t133*t134*t229*t423+5.862637881547574d-1*
     6         t133*t134*t375*t422+t374+t373+t362+t361+4.69011030523806d
     7         -1*t127*t133*t229*t230*t272*t274+5.47179535611107d-1*t127
     8         *t132*t216*t226*t227*t230*t274+1.094359071222214d+0*t134*
     9         t216*t226*t227*t229*t272)+1.7121095002288222d-1*t121*t123
     :         *t125*t136*(t433+t432+t430+t429+t428+t426+t425+t424+t362+
     ;         t361)-3.4242190004576445d-1*t121*t123*t126*t131*t136*t423
     <         +1.0272657001372934d+0*t121*t123*t131*t132*t136*t422+3.42
     =         42190004576445d-1*t121*t123*t125*t131*t277**2*t377+t357+t
     >         355-3.4242190004576445d-1*t121*t123*t125*t225*t276*t277+6
     ?         .848438000915289d-1*t121*t123*t126*t131*t225*t272*t277+7.
     @         98984433440117d-1*t121*t125*t131*t216*t217*t225*t277-6.84
     1         8438000915289d-1*t121*t123*t126*t136*t272*t276-7.98984433
     2         440117d-1*t121*t125*t136*t216*t217*t276+1.597968866880234
     3         2d+0*t121*t126*t131*t136*t216*t217*t272)*t66+1.4841340461
     4         345462d-1*t124*t272*t278*t66+4.947113487115154d-2*t120*t2
     5         78)+7.420670230672731d-2*t124*t138*t423*t66+1.48413404613
     6         45462d-1*t119*t138*t422*t66+1.0d+0*t421*t66-2.47355674355
     7         7577d-2*t120*t278**2*t378*t66+1.2367783717787881d-2*rhob*
     8         t266**2*t416+t254*(-1.2367783717787881d-2*rhob*(5.4356088
     9         43495963d-1*gammabb*t105*t110*t265**2*t415-2.717804421747
     :         9813d-1*gammabb*t105*t110*t261*(2.0107587937153953d+0*t11
     ;         2*t262*t404*t414+t413+t412+t411+t410+t409+t408+2.89736952
     <         8551698d+3*t111*t406*t407/t107**4.0d+0-9.657898428505661d
     =         +2*t106*t111*t264*t406-5.745025124901132d-2*t112*t262*t26
     >         3*t405+1.1944679893212153d+1*t106*t111*t264*t403-1.114836
     ?         7900331342d+2*t106*t253*t255*t262*t263*t264)+2.7178044217
     @         479813d-1*gammabb*t105*t114*(t413+t412+t411+t410+t409+t40
     1         8)-1.0569239417908823d-1*gammabb*t110*t114*t256*t405+2.21
     2         95402777608514d+0*gammabb*t110*t114*t288*t404-5.435608843
     3         495963d-1*gammabb*t105*t260*t261*t265+1.268308730149058d+
     4         0*gammabb*t110*t255*t256*t261*t265-1.268308730149058d+0*g
     5         ammabb*t114*t255*t256*t260)-2.4735567435575762d-2*t266)-1
     6         .0d+0*rhob*t403+1.4841340461345462d-1*t124*t138*t272+2.0d
     7         +0*t271-2.0d+0*t253)*wght+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RA_GAA) = (t445+t436+t159*(-1.2367783717787881d-
     1         2*rhoa*(-2.7178044217479813d-1*gammaaa*t166*t28*t33*(t435
     2         +t434-6.894030149881355d-1*gammaaa*t160*t168*t35+2.388935
     3         9786424305d+1*gammaaa*t158*t169*t279*t29)+2.7178044217479
     4         813d-1*gammaaa*t28*t37*(t435+t434)-6.34154365074529d-1*t1
     5         60*t161*t33*t37-1.7235075374703387d-1*gammaaa*t160*t168*t
     6         31*t37+2.7178044217479813d-1*t165*t28*t37+5.4356088434959
     7         63d-1*gammaaa*t170*t28*t280*t313*t33+6.34154365074529d-1*
     8         gammaaa*t160*t161*t166*t280*t33-2.7178044217479813d-1*t16
     9         6*t170*t28*t33-7.386460874872879d-2*gammaaa*t166*t170*t27
     :         9*t31-2.7178044217479813d-1*gammaaa*t165*t166*t28*t280)-1
     ;         .2367783717787881d-2*t281)+1.2367783717787881d-2*rhoa*t17
     <         1*t281*t314)*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = (t212*(2.473556743557577d-2*t120*(-1.7
     1         121095002288222d-1*t121*t123*t125*t131*t225*(t453+t452+t4
     2         51+t450-2.34505515261903d-1*t121*t127*t132*t222*t230*t282
     3         -4.69011030523806d-1*t121*t134*t215*t229*t282)+1.71210950
     4         02288222d-1*t121*t123*t125*t136*(t452+t451+t450)+t449+t44
     5         8+t447+3.4242190004576445d-1*t121*t123*t125*t131*t231*t28
     6         6*t377-1.7121095002288222d-1*t121*t123*t125*t224*t225*t28
     7         6+3.4242190004576445d-1*t121*t123*t126*t131*t215*t225*t28
     8         6-5.862637881547574d-2*t121*t129*t132*t225*t231*t282-1.17
     9         2527576309515d-1*t121*t129*t136*t215*t229*t282-3.42421900
     :         04576445d-1*t123*t125*t131*t225*t231+3.4242190004576445d-
     ;         1*t123*t125*t136*t224-6.848438000915289d-1*t123*t126*t131
     <         *t136*t215)*t66+7.420670230672731d-2*t124*t215*t287*t66+t
     =         446)-2.473556743557577d-2*t120*t232*t287*t378*t66)*wght+C
     >         mat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = (t445+t436)*wght+Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_RB_GAA) = (t457+t454)*wght+Cmat2(iq,D2_RB_GAA)
            Cmat2(iq,D2_RB_GAB) = (t212*(2.473556743557577d-2*t120*(-1.7
     1         121095002288222d-1*t121*t123*t125*t131*t225*(t459+t458+t4
     2         53+t451-2.34505515261903d-1*t121*t127*t132*t230*t274*t282
     3         -4.69011030523806d-1*t121*t134*t229*t272*t282)+1.71210950
     4         02288222d-1*t121*t123*t125*t136*(t459+t458+t451)+t449+t44
     5         8+t447+3.4242190004576445d-1*t121*t123*t125*t131*t277*t28
     6         6*t377-1.7121095002288222d-1*t121*t123*t125*t225*t276*t28
     7         6+3.4242190004576445d-1*t121*t123*t126*t131*t225*t272*t28
     8         6-5.862637881547574d-2*t121*t129*t132*t225*t277*t282-1.17
     9         2527576309515d-1*t121*t129*t136*t229*t272*t282-3.42421900
     :         04576445d-1*t123*t125*t131*t225*t277+3.4242190004576445d-
     ;         1*t123*t125*t136*t276-6.848438000915289d-1*t123*t126*t131
     <         *t136*t272)*t66+7.420670230672731d-2*t124*t272*t287*t66+t
     =         446)-2.473556743557577d-2*t120*t278*t287*t378*t66)*wght+C
     >         mat2(iq,D2_RB_GAB)
            Cmat2(iq,D2_RB_GBB) = (t254*(-1.2367783717787881d-2*rhob*(-2
     1         .7178044217479813d-1*gammabb*t105*t110*t261*(t461+t460+2.
     2         3889359786424305d+1*gammabb*t106*t253*t264*t288-6.8940301
     3         49881355d-1*gammabb*t112*t255*t263)+2.7178044217479813d-1
     4         *gammabb*t105*t114*(t461+t460)+5.435608843495963d-1*gamma
     5         bb*t105*t110*t265*t289*t415-2.7178044217479813d-1*gammabb
     6         *t105*t260*t261*t289+6.34154365074529d-1*gammabb*t110*t25
     7         5*t256*t261*t289-7.386460874872879d-2*gammabb*t108*t261*t
     8         265*t288-2.7178044217479813d-1*t105*t110*t261*t265-1.7235
     9         075374703387d-1*gammabb*t108*t114*t255*t263+2.71780442174
     :         79813d-1*t105*t114*t260-6.34154365074529d-1*t110*t114*t25
     ;         5*t256)-1.2367783717787881d-2*t290)+t457+t454+1.236778371
     <         7787881d-2*rhob*t266*t290*t416)*wght+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GAA_GAA) = (t465+t462-1.2367783717787881d-2*rhoa
     1         *t159*(1.4772921749745757d-1*t279*t31*t37-4.0149912053595
     2         95d-2*gammaaa*t166*t312*t33*t35+5.435608843495963d-1*gamm
     3         aaa*t28*t280**2*t313*t33-5.435608843495963d-1*t166*t28*t2
     4         80*t33-1.4772921749745757d-1*gammaaa*t166*t279*t280*t31)+
     5         1.2367783717787881d-2*rhoa*t281**2*t314)*wght+Cmat2(iq,D2
     6         _GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = (2.473556743557577d-2*t120*t212*t466*
     1         t66-2.473556743557577d-2*t120*t284*t287*t378*t66)*wght+Cm
     2         at2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = (t465+t462)*wght+Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = -2.473556743557577d-2*t120*t287**2*t3
     1         78*t66*wght+2.473556743557577d-2*t120*t212*(3.42421900045
     2         76445d-1*t121*t123*t125*t131*t286**2*t377-4.0149912053595
     3         92d-2*t121*t131*t134*t225*t372*t375-1.172527576309515d-1*
     4         t121*t129*t132*t225*t282*t286-6.848438000915289d-1*t123*t
     5         125*t131*t225*t286+2.34505515261903d-1*t129*t132*t136*t28
     6         2)*t66*wght+Cmat2(iq,D2_GAB_GAB)
            Cmat2(iq,D2_GAB_GBB) = 2.473556743557577d-2*t120*t212*t466*t
     1         66*wght-2.473556743557577d-2*t120*t284*t287*t378*t66*wght
     2         +Cmat2(iq,D2_GAB_GBB)
            Cmat2(iq,D2_GBB_GBB) = (t465+t462+1.2367783717787881d-2*rhob
     1         *t290**2*t416-1.2367783717787881d-2*rhob*t254*(5.43560884
     2         3495963d-1*gammabb*t105*t110*t289**2*t415-4.0149912053595
     3         95d-2*gammabb*t110*t112*t261*t414-1.4772921749745757d-1*g
     4         ammabb*t108*t261*t288*t289-5.435608843495963d-1*t105*t110
     5         *t261*t289+1.4772921749745757d-1*t108*t114*t288))*wght+Cm
     6         at2(iq,D2_GBB_GBB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            fnc(iq) = fnc(iq)
            Amat(iq,D1_RA) = Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
            Amat2(iq,D2_RA_RA) = Amat2(iq,D2_RA_RA)
            Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            fnc(iq) = fnc(iq)
            Amat(iq,D1_RB) = Amat(iq,D1_RB)
            Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
            Amat2(iq,D2_RB_RB) = Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_opt functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\alpha^{0.3333333333333333}\\\\ 
C>   {\it t_2} &=& \sqrt{{\it t_1}}\\\\ 
C>   {\it t_3} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_4} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_5} &=& \log \left({{1.269642451250142\,{\it t_2}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.02414199311453321\,{\it t_3}+0.10186556948\right)\,{
C>    \it t_3}+0.22308199064\right)\,{\it t_3}+0.47231125998}}
C>    +1.0\right)\\\\ 
C>   {\it t_6} &=& 0.1325688999052018\,{\it t_4}+1.0\\\\ 
C>   {\it t_7} &=& \log \left({{1.269642451250142\,{\it t_2}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01321299881039884\,{\it t_3}+0.029729725188\right)
C>    \,{\it t_3}+0.12236585478\right)\,{\it t_3}+0.3497952466}}
C>    +1.0\right)\\\\ 
C>   {\it t_8} &=& 0.06901399211255826\,{\it t_4}+1.0\\\\ 
C>   {\it t_9} &=& 0.5848223622634643\,\left(0.0337738\,{\it t_7}
C>    \,{\it t_8}+1.0\,\left(1.709920934161365\,\left(0.0621814\,{
C>    \it t_5}\,{\it t_6}-0.0310907\,\log \left({{1.269642451250142
C>    \,{\it t_2}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01530901310039024\,{\it t_3}+0.10465751434\right)
C>    \,{\it t_3}+0.19269083139\right)\,{\it t_3}+0.43896648423}}
C>    +1.0\right)\,\left(0.1274696188700087\,{\it t_4}
C>    +1.0\right)\right)-0.0337738\,{\it t_7}\,{\it t_8}\right)\right)
C>    -0.0621814\,{\it t_5}\,{\it t_6}\\\\ 
C>   {\it t_{10}} &=& \rho_\beta^{0.3333333333333333}\\\\ 
C>   {\it t_{11}} &=& \sqrt{{\it t_{10}}}\\\\ 
C>   {\it t_{12}} &=& {{1}\over{{\it t_{11}}}}\\\\ 
C>   {\it t_{13}} &=& {{1}\over{{\it t_{10}}}}\\\\ 
C>   {\it t_{14}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{11}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.02414199311453321\,{\it t_{12}}+0.10186556948\right)
C>    \,{\it t_{12}}+0.22308199064\right)\,{\it t_{12}}
C>    +0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{15}} &=& 0.1325688999052018\,{\it t_{13}}+1.0\\\\ 
C>   {\it t_{16}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{11}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01321299881039884\,{\it t_{12}}
C>    +0.029729725188\right)\,{\it t_{12}}+0.12236585478\right)\,{
C>    \it t_{12}}+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{17}} &=& 0.06901399211255826\,{\it t_{13}}+1.0\\\\ 
C>   {\it t_{18}} &=& 0.5848223622634643\,\left(0.0337738\,{
C>    \it t_{16}}\,{\it t_{17}}+1.0\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{14}}\,{\it t_{15}}-0.0310907
C>    \,\log \left({{1.269642451250142\,{\it t_{11}}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01530901310039024\,{\it t_{12}}+0.10465751434\right)
C>    \,{\it t_{12}}+0.19269083139\right)\,{\it t_{12}}
C>    +0.43896648423}}+1.0\right)\,\left(0.1274696188700087\,{
C>    \it t_{13}}+1.0\right)\right)-0.0337738\,{\it t_{16}}\,{
C>    \it t_{17}}\right)\right)-0.0621814\,{\it t_{14}}\,{
C>    \it t_{15}}\\\\ 
C>   {\it t_{19}} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_{20}} &=& {\it t_{19}}^{0.3333333333333333}\\\\ 
C>   {\it t_{21}} &=& {{1}\over{{\it t_{20}}}}\\\\ 
C>   {\it t_{22}} &=& 0.1325688999052018\,{\it t_{21}}+1.0\\\\ 
C>   {\it t_{23}} &=& \sqrt{{\it t_{20}}}\\\\ 
C>   {\it t_{24}} &=& {{1}\over{{\it t_{23}}}}\\\\ 
C>   {\it t_{25}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{23}}}\over{0.7876233178997433\,{\it t_{24}}\,
C>    \left(0.7876233178997433\,{\it t_{24}}\,
C>    \left(0.02414199311453321\,{\it t_{24}}+0.10186556948\right)
C>    +0.22308199064\right)+0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{26}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{27}} &=& {{1}\over{{\it t_{19}}}}\\\\ 
C>   {\it t_{28}} &=& 1.0-{\it t_{26}}\,{\it t_{27}}\\\\ 
C>   {\it t_{29}} &=& {\it t_{26}}\,{\it t_{27}}+1.0\\\\ 
C>   {\it t_{30}} &=& 0.06901399211255826\,{\it t_{21}}+1.0\\\\ 
C>   {\it t_{31}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{23}}}\over{0.7876233178997433\,{\it t_{24}}\,
C>    \left(0.7876233178997433\,{\it t_{24}}\,
C>    \left(0.01321299881039884\,{\it t_{24}}+0.029729725188\right)
C>    +0.12236585478\right)+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{32}} &=& 0.5848223622634648\,\left(1.923661050931536
C>    \,{\it t_{29}}^{{{4}\over{3}}}+1.923661050931536\,{
C>    \it t_{28}}^{{{4}\over{3}}}-3.847322101863072\right)\,
C>    \left({{{\it t_{26}}^4\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{22}}\,{\it t_{25}}-0.0310907\,
C>    \left(0.1274696188700087\,{\it t_{21}}+1.0\right)\,\log 
C>    \left({{1.269642451250142\,{\it t_{23}}}
C>    \over{0.7876233178997433\,{\it t_{24}}\,
C>    \left(0.7876233178997433\,{\it t_{24}}\,
C>    \left(0.01530901310039024\,{\it t_{24}}+0.10465751434\right)
C>    +0.19269083139\right)+0.43896648423}}+1.0\right)\right)
C>    -0.0337738\,{\it t_{30}}\,{\it t_{31}}\right)}\over{{
C>    \it t_{19}}^4}}+0.0337738\,{\it t_{30}}\,{\it t_{31}}\right)
C>    -0.0621814\,{\it t_{22}}\,{\it t_{25}}\\\\ 
C>   {\it t_{33}} &=& {{1}\over{
C>    \left(\rho_\alpha^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_{34}} &=& {{1}\over{e^{80.85523023512745\,{\it t_9}}}}
C>    -1.0\\\\ 
C>   {\it t_{35}} &=& {{0.2717804421747981\,{\it t_{33}}\,
C>    \sigma_{\alpha\alpha}}\over{{\it t_{34}}}}\\\\ 
C>   {\it t_{36}} &=& {{1}\over{
C>    \left(\rho_\beta^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_{37}} &=& {{1}\over{e^{80.85523023512745\,{\it t_{18}}}}}
C>    -1.0\\\\ 
C>   {\it t_{38}} &=& {{0.2717804421747981\,{\it t_{36}}\,
C>    \sigma_{\beta\beta}}\over{{\it t_{37}}}}\\\\ 
C>   {\it t_{39}} &=& 0.5\,{\it t_{29}}^{{{2}\over{3}}}+0.5\,{
C>    \it t_{28}}^{{{2}\over{3}}}\\\\ 
C>   {\it t_{40}} &=& {\it t_{39}}^{3.0}\\\\ 
C>   {\it t_{41}} &=& {{1}\over{\left({
C>    \it t_{19}}^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_{42}} &=& {{1}\over{{\it t_{39}}^{2.0}}}\\\\ 
C>   {\it t_{43}} &=& \sigma_{\beta\beta}+2.0\,\sigma_{\alpha\beta}
C>    +\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{44}} &=& {{1}\over{e^{{{40.42761511756372\,{
C>    \it t_{32}}}\over{{\it t_{40}}}}}}}-1.0\\\\ 
C>   {\it t_{45}} &=& {{0.1712109500228822\,{\it t_{41}}\,{
C>    \it t_{42}}\,{\it t_{43}}}\over{{\it t_{44}}}}\\\\ 
C>   f &=& 0.02473556743557577\,{\it t_{19}}\,{\it t_{40}}
C>    \,\log \left({{0.1712109500228822\,{\it t_{41}}\,{\it t_{42}}
C>    \,{\it t_{43}}\,\left({\it t_{45}}+1.0\right)}
C>    \over{{{0.02931318940773787\,\left({\it t_{41}}\,{
C>    \it t_{43}}\right)^{2.0}}\over{{\it t_{39}}^{4.0}\,{
C>    \it t_{44}}^{2.0}}}+{\it t_{45}}+1.0}}+1.0\right)
C>    -0.01236778371778788\,\rho_\beta\,\log 
C>    \left({{0.2717804421747981\,{\it t_{36}}\,\sigma_{\beta\beta}
C>    \,\left({\it t_{38}}+1.0\right)}\over{{{0.0738646087487288
C>    \,\left({\it t_{36}}\,\sigma_{\beta\beta}\right)^{2.0}}
C>    \over{{\it t_{37}}^{2.0}}}+{\it t_{38}}+1.0}}+1.0\right)
C>    -0.01236778371778788\,\rho_\alpha\,\log 
C>    \left({{0.2717804421747981\,{\it t_{33}}\,
C>    \sigma_{\alpha\alpha}\,\left({\it t_{35}}+1.0\right)}
C>    \over{{{0.0738646087487288\,\left({\it t_{33}}\,
C>    \sigma_{\alpha\alpha}\right)^{2.0}}\over{{\it t_{34}}^{2.0}}}
C>    +{\it t_{35}}+1.0}}+1.0\right)+1.0\,{\it t_{19}}\,{\it t_{32}}
C>    -1.0\,{\it t_{18}}\,\rho_\beta-1.0\,{\it t_9}\,\rho_\alpha\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 0.0\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] NC Handy, AJ Cohen, Mol.Phys. 99, 607 (2001)  , DOI: 
C> <a href="http://dx.doi.org/10.1080/00268970010023435 "> 
C> 10.1080/00268970010023435 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_opt_d3(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,fnc,Amat,Amat2,Amat3, 
     +Cmat,Cmat2,Cmat3) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision rgamma(nq,*) !< [Input] The norm of the density 
                                    !< gradients 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,*)   !< [Output] The derivative wrt rgamma 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,*)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,*)  !< [Output] The 2nd derivative wrt rgamma 
                                    !< and possibly rho 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat3(nq,*)  !< [Output] The 3rd derivative wrt rho 
      double precision Cmat3(nq,*)  !< [Output] The 3rd derivative wrt rgamma 
                                    !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          if (rhoa.gt.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1.530901310039024d-2*t3+1.0465751434d-1
            t5 = 7.876233178997433d-1*t3*t4+1.9269083139d-1
            t6 = 7.876233178997433d-1*t3*t5+4.3896648423d-1
            t7 = 1/t6
            t8 = 1.269642451250142d+0*t2*t7+1.0d+0
            t9 = log(t8)
            t10 = 1/t1
            t11 = 1.2746961887000874d-1*t10+1.0d+0
            t12 = 2.4141993114533214d-2*t3+1.0186556948d-1
            t13 = 7.876233178997433d-1*t12*t3+2.2308199064d-1
            t14 = 7.876233178997433d-1*t13*t3+4.7231125998d-1
            t15 = 1/t14
            t16 = 1.269642451250142d+0*t15*t2+1.0d+0
            t17 = log(t16)
            t18 = 1.325688999052018d-1*t10+1.0d+0
            t19 = 1.3212998810398843d-2*t3+2.9729725188d-2
            t20 = 7.876233178997433d-1*t19*t3+1.2236585478d-1
            t21 = 7.876233178997433d-1*t20*t3+3.497952466d-1
            t22 = 1/t21
            t23 = 1.269642451250142d+0*t2*t22+1.0d+0
            t24 = log(t23)
            t25 = 6.901399211255826d-2*t10+1.0d+0
            t26 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t17*t18-3.10907d-2*t11*t9)-3.37738d-2*t24*t25)+3
     2         .37738d-2*t24*t25)-6.21814d-2*t17*t18
            t27 = log(1.4251254664507676d+0*t2/(7.016926042943223d-1*t3*
     1         (7.016926042943223d-1*(2.150807071909054d-2*t3+1.01865569
     2         48d-1)*t3+2.2308199064d-1)+4.7231125998d-1)+1.0d+0)
            t28 = 1.0522000558389215d-1*t10+1.0d+0
            t29 = rhoa**1.1666666666666667d+0
            t30 = 1/t29**2.0d+0
            t31 = exp(-8.085523023512745d+1*t26)
            t32 = t31-1.0d+0
            t33 = 1/t32
            t34 = 2.7178044217479813d-1*gammaaa*t30*t33
            t35 = t34+1.0d+0
            t36 = (gammaaa*t30)**2.0d+0
            t37 = 1/t32**2.0d+0
            t38 = 7.38646087487288d-2*t36*t37+t34+1.0d+0
            t39 = 1/t38
            t40 = 2.7178044217479813d-1*gammaaa*t30*t35*t39+1.0d+0
            t41 = log(t40)
            t42 = exp(2.5138457066712766d+0*t27*t28)-1.0d+0
            t43 = 1.35890221087399d-1*gammaaa*t30/t42
            t44 = 2.1508070719090538d-2*t3+1.0186556948d-1
            t45 = 7.016926042943222d-1*t3*t44+2.2308199064d-1
            t46 = 7.016926042943222d-1*t3*t45+4.7231125998d-1
            t47 = 1/t46
            t48 = 1.425125466450768d+0*t2*t47+1.0d+0
            t49 = log(t48)
            t50 = 1.0522000558389213d-1*t10+1.0d+0
            t51 = 1/rhoa**1.3333333333333333d+0
            t52 = 1/t48
            t53 = 1/t46**2
            t54 = 1/rhoa**1.3333333333333336d+0
            t55 = 1/t2**3
            t56 = 1/rhoa**6.666666666666667d-1
            t57 = -5.847438369119352d-2*t44*t55*t56-1.2576711796854242d-
     1         3*t54
            t58 = 7.016926042943222d-1*t3*t57-5.847438369119352d-2*t45*t
     1         55*t56
            t59 = 1.1876045553756398d-1*t3*t47*t56-1.425125466450768d+0*
     1         t2*t53*t58
            t60 = 1.090454542535705d-3*t49*t51-6.21814d-2*t50*t52*t59
            t61 = 1/t8
            t62 = 1/t6**2
            t63 = -1.3127055298329054d-1*t4*t55*t56-2.0096226153166658d-
     1         3*t54
            t64 = 7.876233178997433d-1*t3*t63-1.3127055298329054d-1*t5*t
     1         55*t56
            t65 = 2.11607075208357d-1*t3*t56*t7-1.269642451250142d+0*t2*
     1         t62*t64
            t66 = 1/t16
            t67 = 1/t14**2
            t68 = -1.3127055298329054d-1*t12*t55*t56-3.169132786263567d-
     1         3*t54
            t69 = 7.876233178997433d-1*t3*t68-1.3127055298329054d-1*t13*
     1         t55*t56
            t70 = 2.11607075208357d-1*t15*t3*t56-1.269642451250142d+0*t2
     1         *t67*t69
            t71 = 1/t23
            t72 = 1/t21**2
            t73 = -1.3127055298329054d-1*t19*t55*t56-1.7344776604086162d
     1         -3*t54
            t74 = 7.876233178997433d-1*t3*t73-1.3127055298329054d-1*t20*
     1         t55*t56
            t75 = 2.11607075208357d-1*t22*t3*t56-1.269642451250142d+0*t2
     1         *t72*t74
            t76 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(1.
     1         3210398931339265d-3*t51*t9+6.21814d-2*t18*t66*t70-3.10907
     2         d-2*t11*t61*t65-2.747773264188438d-3*t17*t51)-3.37738d-2*
     3         t25*t71*t75+7.769549222703733d-4*t24*t51)+3.37738d-2*t25*
     4         t71*t75-7.769549222703733d-4*t24*t51)-6.21814d-2*t18*t66*
     5         t70+2.747773264188438d-3*t17*t51
            t77 = 1/t40
            t78 = rhoa**1.6666666666666674d-1
            t79 = 1/t29**3.0d+0
            t80 = -6.34154365074529d-1*gammaaa*t33*t78*t79
            t81 = 1/t32**2
            t82 = 2.1974870225448048d+1*gammaaa*t30*t31*t76*t81
            t83 = t82+t80
            t84 = 1/t38**2
            t85 = gammaaa**2
            t86 = 1/t29**5.0d+0
            t87 = 1/t32**3.0d+0
            t88 = 1.1944679893212153d+1*t31*t36*t76*t87-3.44701507494067
     1         75d-1*t37*t78*t85*t86+t82+t80
            t89 = -2.7178044217479813d-1*gammaaa*t30*t35*t84*t88+2.71780
     1         44217479813d-1*gammaaa*t30*t39*t83-6.34154365074529d-1*ga
     2         mmaaa*t35*t39*t78*t79
            t90 = exp(2.5138457066712766d+0*t49*t50)
            t91 = t90-1.0d+0
            t92 = 1/t91
            t93 = 1.3589022108739904d-1*gammaaa*t30*t92
            t94 = t93+1.0d+0
            t95 = 1/t91**2.0d+0
            t96 = 1.8466152187182186d-2*t36*t95+t93+1.0d+0
            t97 = 1/t96
            t98 = 1.3589022108739904d-1*gammaaa*t30*t94*t97+1.0d+0
            t99 = 1/t98
            t100 = -1.585385912686322d-1*gammaaa*t78*t79*t92
            t101 = 1/t91**2
            t102 = 5.493717556362009d+0*gammaaa*t101*t30*t60*t90
            t103 = t102+t100
            t104 = 1/t96**2
            t105 = 1/t91**3.0d+0
            t106 = -4.308768843675843d-2*t78*t85*t86*t95+1.4930849866515
     1         178d+0*t105*t36*t60*t90+t102+t100
            t107 = -1.585385912686322d-1*gammaaa*t78*t79*t94*t97+1.35890
     1         22108739904d-1*gammaaa*t103*t30*t97-1.3589022108739904d-1
     2         *gammaaa*t104*t106*t30*t94
            t108 = log(t98)
            t109 = 1/t29**4.0d+0
            t110 = 1.477292174974576d-1*gammaaa*t109*t37+2.7178044217479
     1         813d-1*t30*t33
            t111 = -2.7178044217479813d-1*gammaaa*t110*t30*t35*t84+2.717
     1         8044217479813d-1*t30*t35*t39+7.386460874872879d-2*gammaaa
     2         *t109*t33*t39
            t112 = 9.233076093591093d-3*gammaaa*t109*t95+3.3972555271849
     1         76d-2*t30*t92
            t113 = 3.397255527184976d-2*t30*t94*t97+4.6165380467955464d-
     1         3*gammaaa*t109*t92*t97-1.3589022108739904d-1*gammaaa*t104
     2         *t112*t30*t94
            t114 = 1.8466152187182186d-2*gammaaa*t109*t95+6.794511054369
     1         952d-2*t30*t92
            t115 = 6.794511054369952d-2*t30*t94*t97+9.233076093591093d-3
     1         *gammaaa*t109*t92*t97-1.3589022108739904d-1*gammaaa*t104*
     2         t114*t30*t94
            t116 = 2.0d+0*t60
            t117 = 1/rhoa**2.333333333333333d+0
            t118 = -7.269696950238034d-4*t117*t49
            t119 = 1.1771443702974158d-2*t3+2.9729725188d-2
            t120 = 7.016926042943222d-1*t119*t3+1.2236585478d-1
            t121 = 7.016926042943222d-1*t120*t3+3.497952466d-1
            t122 = 1/t121
            t123 = 1.425125466450768d+0*t122*t2+1.0d+0
            t124 = log(t123)
            t125 = 5.477644184000001d-2*t10+1.0d+0
            t126 = 1/rhoa**2
            t127 = 2.18090908507141d-3*t51*t52*t59
            t128 = 1/t48**2
            t129 = t59**2
            t130 = 6.21814d-2*t128*t129*t50
            t131 = 1/t46**3
            t132 = t58**2
            t133 = 1/rhoa**2.3333333333333334d+0
            t134 = 1/rhoa**1.6666666666666669d+0
            t135 = 1/t2**5
            t136 = 1.949146123039784d-2*t134*t44*t55+1.4618595922798375d
     1         -2*t135*t44*t54+9.432533847640683d-4*t133
            t137 = -1.1694876738238703d-1*t55*t56*t57+1.949146123039784d
     1         -2*t134*t45*t55+1.4618595922798375d-2*t135*t45*t54+7.0169
     2         26042943222d-1*t136*t3
            t138 = -2.3752091107512796d-1*t3*t53*t56*t58-9.8967046281303
     1         28d-3*t47*t54*t55-1.425125466450768d+0*t137*t2*t53-3.9586
     2         818512521327d-2*t134*t3*t47+2.850250932901536d+0*t131*t13
     3         2*t2
            t139 = -6.21814d-2*t138*t50*t52
            t140 = t139+t130+t127+8.443450000000001d-3*t124*t125*t126+t1
     1         18
            t141 = 1/t8**2
            t142 = t65**2
            t143 = 1/t6**3
            t144 = t64**2
            t145 = 8.751370198886037d-2*t134*t4*t55+6.563527649164527d-2
     1         *t135*t4*t54+3.0144339229749983d-3*t133
            t146 = -2.625411059665811d-1*t55*t56*t63+8.751370198886037d-
     1         2*t134*t5*t55+6.563527649164527d-2*t135*t5*t54+7.87623317
     2         8997433d-1*t145*t3
            t147 = -3.52678458680595d-2*t54*t55*t7-1.4107138347223802d-1
     1         *t134*t3*t7-4.23214150416714d-1*t3*t56*t62*t64-1.26964245
     2         1250142d+0*t146*t2*t62+2.539284902500284d+0*t143*t144*t2
            t148 = 1/t16**2
            t149 = t70**2
            t150 = 1/t14**3
            t151 = t69**2
            t152 = 8.751370198886037d-2*t12*t134*t55+6.563527649164527d-
     1         2*t12*t135*t54+4.753699179395351d-3*t133
            t153 = -2.625411059665811d-1*t55*t56*t68+8.751370198886037d-
     1         2*t13*t134*t55+6.563527649164527d-2*t13*t135*t54+7.876233
     2         178997433d-1*t152*t3
            t154 = -4.23214150416714d-1*t3*t56*t67*t69-1.269642451250142
     1         d+0*t153*t2*t67-3.52678458680595d-2*t15*t54*t55-1.4107138
     2         347223802d-1*t134*t15*t3+2.539284902500284d+0*t150*t151*t
     3         2
            t155 = 1/t23**2
            t156 = t75**2
            t157 = 1/t21**3
            t158 = t74**2
            t159 = 8.751370198886037d-2*t134*t19*t55+6.563527649164527d-
     1         2*t135*t19*t54+2.601716490612924d-3*t133
            t160 = -2.625411059665811d-1*t55*t56*t73+8.751370198886037d-
     1         2*t134*t20*t55+6.563527649164527d-2*t135*t20*t54+7.876233
     2         178997433d-1*t159*t3
            t161 = -4.23214150416714d-1*t3*t56*t72*t74-1.269642451250142
     1         d+0*t160*t2*t72-3.52678458680595d-2*t22*t54*t55-1.4107138
     2         347223802d-1*t134*t22*t3+2.539284902500284d+0*t157*t158*t
     3         2
            t162 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(-
     1         1.7613865241785687d-3*t117*t9-5.495546528376876d-3*t51*t6
     2         6*t70+6.21814d-2*t154*t18*t66+2.642079786267853d-3*t51*t6
     3         1*t65-3.10907d-2*t11*t147*t61-6.21814d-2*t148*t149*t18+3.
     4         663697685584584d-3*t117*t17+3.10907d-2*t11*t141*t142)+1.5
     5         539098445407465d-3*t51*t71*t75-3.37738d-2*t161*t25*t71+3.
     6         37738d-2*t155*t156*t25-1.0359398963604977d-3*t117*t24)-1.
     7         5539098445407465d-3*t51*t71*t75+3.37738d-2*t161*t25*t71-3
     8         .37738d-2*t155*t156*t25+1.0359398963604977d-3*t117*t24)+5
     9         .495546528376876d-3*t51*t66*t70-6.21814d-2*t154*t18*t66+6
     :         .21814d-2*t148*t149*t18-3.663697685584584d-3*t117*t17
            t163 = rhoa**3.333333333333335d-1
            t164 = 1/rhoa**8.333333333333333d-1
            t165 = t76**2
            t166 = exp(-1.617104604702549d+2*t26)
            t167 = 1/t32**3
            t168 = 3.553566382931298d+3*gammaaa*t165*t166*t167*t30
            t169 = 2.2195402777608514d+0*gammaaa*t109*t163*t33
            t170 = -1.0569239417908823d-1*gammaaa*t164*t33*t79
            t171 = -1.0254939438542422d+2*gammaaa*t31*t76*t78*t79*t81
            t172 = -1.776783191465649d+3*gammaaa*t165*t30*t31*t81
            t173 = 2.1974870225448048d+1*gammaaa*t162*t30*t31*t81
            t174 = t173+t172+t171+t170+t169+t168
            t175 = 1/t32**4.0d+0
            t176 = 1/t29**6.0d+0
            t177 = -1.1148367900331342d+2*t31*t76*t78*t85*t86*t87-9.6578
     1         98428505661d+2*t165*t31*t36*t87+1.1944679893212153d+1*t16
     2         2*t31*t36*t87-5.745025124901132d-2*t164*t37*t85*t86+2.010
     3         7587937153953d+0*t163*t176*t37*t85+2.897369528551698d+3*t
     4         165*t166*t175*t36+t173+t172+t171+t170+t169+t168
            t178 = 1/t38**3
            t179 = t88**2
            t180 = -5.435608843495963d-1*gammaaa*t30*t83*t84*t88+1.26830
     1         8730149058d+0*gammaaa*t35*t78*t79*t84*t88-2.7178044217479
     2         813d-1*gammaaa*t177*t30*t35*t84-1.268308730149058d+0*gamm
     3         aaa*t39*t78*t79*t83-1.0569239417908823d-1*gammaaa*t164*t3
     4         5*t39*t79+2.2195402777608514d+0*gammaaa*t109*t163*t35*t39
     5         +2.7178044217479813d-1*gammaaa*t174*t30*t39+5.43560884349
     6         5963d-1*gammaaa*t178*t179*t30*t35
            t181 = -2.4735567435575762d-2*t89-1.2367783717787881d-2*rhoa
     1         *t180
            t182 = 1/t40**2
            t183 = t89**2
            t184 = 1/t98**2
            t185 = t107**2
            t186 = -4.947113487115154d-2*rhoa*t184*t185
            t187 = 4.947113487115154d-2*t107
            t188 = 2.774425347201063d-1*gammaaa*t109*t163*t94*t97
            t189 = -1.321154927238602d-2*gammaaa*t164*t79*t94*t97
            t190 = -3.170771825372644d-1*gammaaa*t103*t78*t79*t97
            t191 = 3.170771825372644d-1*gammaaa*t104*t106*t78*t79*t94
            t192 = -2.717804421747981d-1*gammaaa*t103*t104*t106*t30
            t193 = 1/t96**3
            t194 = t106**2
            t195 = 2.717804421747981d-1*gammaaa*t193*t194*t30*t94
            t196 = 2.774425347201063d-1*gammaaa*t109*t163*t92
            t197 = -1.321154927238602d-2*gammaaa*t164*t79*t92
            t198 = 1.5098913454155444d-2*gammaaa*t126*t30*t92
            t199 = -1.281867429817802d+1*gammaaa*t101*t60*t78*t79*t90
            t200 = t60**2
            t201 = -2.2209789893320597d+2*gammaaa*t101*t200*t30*t90
            t202 = 4.189742844452126d-1*t126*t49*t50-4.042761511756372d+
     1         1*t140
            t203 = -1.3589022108739904d-1*gammaaa*t101*t202*t30*t90
            t204 = 1/t91**3
            t205 = exp(5.027691413342553d+0*t49*t50)
            t206 = 4.4419579786641195d+2*gammaaa*t200*t204*t205*t30
            t207 = t206+t203+t201+t199+t198+t197+t196
            t208 = 1.2567242460721215d-1*t163*t176*t85*t95
            t209 = -3.590640703063204d-3*t164*t85*t86*t95
            t210 = -6.967729937707083d+0*t105*t60*t78*t85*t86*t90
            t211 = 1/t91**4.0d+0
            t212 = 1.8108559553448098d+2*t200*t205*t211*t36
            t213 = 4.1035893749293734d-3*t126*t36*t95-3.693230437436437d
     1         -2*t105*t202*t36*t90-6.036186517816032d+1*t105*t200*t36*t
     2         90+t212+t210+t209+t208+t206+t203+t201+t199+t198+t197+t196
            t214 = 1.5098913454155444d-2*gammaaa*t126*t30*t94*t97+1.3589
     1         022108739904d-1*gammaaa*t207*t30*t97-1.3589022108739904d-
     2         1*gammaaa*t104*t213*t30*t94+t195+t192+t191+t190+t189+t188
            t215 = 4.947113487115154d-2*rhoa*t214+t187
            t216 = 1/rhoa
            t217 = t139+t130+t127-8.44345d-3*t124*t125*t126+t118
            t218 = -1.509891345415545d-2*gammaaa*t126*t30*t92
            t219 = -2.2209789893320595d+2*gammaaa*t101*t200*t30*t90
            t220 = -4.1897428444521273d-1*t126*t49*t50-4.042761511756372
     1         d+1*t217
            t221 = -1.3589022108739904d-1*gammaaa*t101*t220*t30*t90
            t222 = 4.441957978664119d+2*gammaaa*t200*t204*t205*t30
            t223 = t222+t221+t219+t218+t199+t197+t196
            t224 = -4.1035893749293745d-3*t126*t36*t95-3.693230437436437
     1         d-2*t105*t220*t36*t90-6.036186517816031d+1*t105*t200*t36*
     2         t90+t222+t221+t219+t218+t212+t210+t209+t208+t199+t197+t19
     3         6
            t225 = -1.509891345415545d-2*gammaaa*t126*t30*t94*t97+1.3589
     1         022108739904d-1*gammaaa*t223*t30*t97-1.3589022108739904d-
     2         1*gammaaa*t104*t224*t30*t94+t195+t192+t191+t190+t189+t188
            t226 = 4.947113487115154d-2*rhoa*t225+t187
            t227 = -6.34154365074529d-1*t33*t78*t79
            t228 = 2.1974870225448048d+1*t30*t31*t76*t81
            t229 = t228+t227
            t230 = 2.3889359786424305d+1*gammaaa*t109*t31*t76*t87-6.8940
     1         30149881355d-1*gammaaa*t37*t78*t86+t228+t227
            t231 = -2.7178044217479813d-1*t30*t35*t84*t88-7.386460874872
     1         879d-2*gammaaa*t109*t33*t84*t88+5.435608843495963d-1*gamm
     2         aaa*t110*t178*t30*t35*t88-1.7235075374703387d-1*gammaaa*t
     3         33*t39*t78*t86-2.7178044217479813d-1*gammaaa*t110*t30*t83
     4         *t84+6.34154365074529d-1*gammaaa*t110*t35*t78*t79*t84-2.7
     5         178044217479813d-1*gammaaa*t230*t30*t35*t84+2.71780442174
     6         79813d-1*t30*t39*t83-6.34154365074529d-1*t35*t39*t78*t79+
     7         2.7178044217479813d-1*gammaaa*t229*t30*t39
            t232 = -1.2367783717787881d-2*rhoa*t231-1.2367783717787881d-
     1         2*t111
            t233 = -4.947113487115154d-2*rhoa*t107*t113*t184
            t234 = -3.9634647817158053d-2*t78*t79*t92
            t235 = 1.3734293890905022d+0*t101*t30*t60*t90
            t236 = t235+t234
            t237 = -2.1543844218379216d-2*gammaaa*t78*t86*t95+7.46542493
     1         3257588d-1*gammaaa*t105*t109*t60*t90+t235+t234
            t238 = -3.9634647817158053d-2*t78*t79*t94*t97-5.385961054594
     1         804d-3*gammaaa*t78*t86*t92*t97+1.3589022108739904d-1*gamm
     2         aaa*t236*t30*t97+3.397255527184976d-2*t103*t30*t97+1.5853
     3         85912686322d-1*gammaaa*t104*t112*t78*t79*t94-1.3589022108
     4         739904d-1*gammaaa*t104*t237*t30*t94+2.717804421747981d-1*
     5         gammaaa*t106*t112*t193*t30*t94-3.397255527184976d-2*t104*
     6         t106*t30*t94-4.6165380467955464d-3*gammaaa*t104*t106*t109
     7         *t92-1.3589022108739904d-1*gammaaa*t103*t104*t112*t30
            t239 = 4.947113487115154d-2*rhoa*t238+2.473556743557577d-2*t
     1         113
            t240 = t239*t99
            t241 = -7.926929563431611d-2*t78*t79*t92
            t242 = 2.7468587781810044d+0*t101*t30*t60*t90
            t243 = t242+t241
            t244 = -4.308768843675843d-2*gammaaa*t78*t86*t95+1.493084986
     1         6515178d+0*gammaaa*t105*t109*t60*t90+t242+t241
            t245 = -7.926929563431611d-2*t78*t79*t94*t97-1.0771922109189
     1         608d-2*gammaaa*t78*t86*t92*t97+1.3589022108739904d-1*gamm
     2         aaa*t243*t30*t97+6.794511054369952d-2*t103*t30*t97+1.5853
     3         85912686322d-1*gammaaa*t104*t114*t78*t79*t94-1.3589022108
     4         739904d-1*gammaaa*t104*t244*t30*t94+2.717804421747981d-1*
     5         gammaaa*t106*t114*t193*t30*t94-6.794511054369952d-2*t104*
     6         t106*t30*t94-9.233076093591093d-3*gammaaa*t104*t106*t109*
     7         t92-1.3589022108739904d-1*gammaaa*t103*t104*t114*t30
            t246 = 4.947113487115154d-2*rhoa*t245+2.473556743557577d-2*t
     1         115
            t247 = t111**2
            t248 = t110**2
            t249 = -4.014991205359595d-2*gammaaa*t176*t35*t37*t84-5.4356
     1         08843495963d-1*t110*t30*t35*t84-1.4772921749745757d-1*gam
     2         maaa*t109*t110*t33*t84+1.4772921749745757d-1*t109*t33*t39
     3         +5.435608843495963d-1*gammaaa*t178*t248*t30*t35
            t250 = t113**2
            t251 = -4.947113487115154d-2*rhoa*t184*t250
            t252 = t112**2
            t253 = -6.794511054369952d-2*t104*t112*t30*t94
            t254 = -9.233076093591093d-3*gammaaa*t104*t109*t112*t92
            t255 = 2.3082690233977732d-3*t109*t92*t97-3.136711879187181d
     1         -4*gammaaa*t104*t176*t94*t95+2.717804421747981d-1*gammaaa
     2         *t193*t252*t30*t94+t254+t253
            t256 = 4.947113487115154d-2*rhoa*t255*t99
            t257 = 4.6165380467955464d-3*t109*t92*t97-6.273423758374362d
     1         -4*gammaaa*t104*t176*t94*t95+2.717804421747981d-1*gammaaa
     2         *t112*t114*t193*t30*t94-3.397255527184976d-2*t104*t114*t3
     3         0*t94-4.6165380467955464d-3*gammaaa*t104*t109*t114*t92+t2
     4         54+t253
            t258 = t115**2
            t259 = t114**2
            t260 = 9.233076093591093d-3*t109*t92*t97-1.2546847516748727d
     1         -3*gammaaa*t104*t176*t94*t95+2.717804421747981d-1*gammaaa
     2         *t193*t259*t30*t94-1.3589022108739904d-1*t104*t114*t30*t9
     3         4-1.8466152187182186d-2*gammaaa*t104*t109*t114*t92
            t261 = 1/rhoa**3.333333333333333d+0
            t262 = 8.48131310861104d-4*t261*t49
            t263 = 1/rhoa**3
            t264 = -2.1809090850714105d-3*t117*t52*t59
            t265 = 3.37738d-2*t125*(1.1876045553756398d-1*t122*t3*t56-1.
     1         425125466450768d+0*t2*(7.016926042943222d-1*t3*(-5.847438
     2         369119352d-2*t119*t55*t56-6.883279156869946d-4*t54)-5.847
     3         438369119352d-2*t120*t55*t56)/t121**2)/t123-3.08334765235
     4         9653d-4*t124*t51
            t266 = -3.2713636276071156d-3*t128*t129*t51
            t267 = 3.2713636276071156d-3*t138*t51*t52
            t268 = -1.243628d-1*t50*t59**3/t48**3
            t269 = 1.865442d-1*t128*t138*t50*t59
            t270 = 1/rhoa**3.3333333333333337d+0
            t271 = 1/rhoa**2.666666666666667d+0
            t272 = 1/t2**7
            t273 = 1/rhoa**2.0d+0
            t274 = -6.21814d-2*t50*t52*(-8.550752798704606d+0*t2*t58**3/
     1         t46**4+2.969011388439098d-2*t53*t54*t55*t58+1.18760455537
     2         56398d-1*t134*t3*t53*t58+8.550752798704606d+0*t131*t137*t
     3         2*t58-1.425125466450768d+0*t2*t53*(5.847438369119352d-2*t
     4         134*t55*t57+4.385578776839513d-2*t135*t54*t57-1.754231510
     5         7358056d-1*t136*t55*t56+7.016926042943222d-1*t3*(-1.62428
     6         84358664864d-2*t271*t44*t55-6.091081634499322d-3*t272*t27
     7         3*t44-1.4618595922798375d-2*t133*t135*t44-1.1615990756816
     8         77d-3*t270)-1.6242884358664864d-2*t271*t45*t55-6.09108163
     9         4499322d-3*t272*t273*t45-1.4618595922798375d-2*t133*t135*
     :         t45)-3.5628136661269194d-1*t137*t3*t53*t56+7.125627332253
     ;         839d-1*t131*t132*t3*t56+9.89670462813033d-3*t133*t47*t55+
     <         3.29890154271011d-2*t271*t3*t47+2.474176157032582d-3*t135
     =         *t273*t47)
            t275 = t274+t269+t268+t267+t266+7.500000000000002d-1*t126*t2
     1         65+t264-2.533035d-2*t124*t125*t263+t262
            t276 = 1/t16**3
            t277 = t70**3
            t278 = -7.617854707500852d+0*t2*t69**3/t14**4+1.058035376041
     1         7849d-1*t54*t55*t67*t69+4.2321415041671406d-1*t134*t3*t67
     2         *t69+7.617854707500852d+0*t150*t153*t2*t69-1.269642451250
     3         142d+0*t2*t67*(2.625411059665811d-1*t134*t55*t68+1.969058
     4         2947493582d-1*t135*t54*t68-3.9381165894987163d-1*t152*t55
     5         *t56+7.876233178997433d-1*t3*(-1.4585616998143394d-1*t12*
     6         t271*t55-5.469606374303773d-2*t12*t272*t273-1.17081850159
     7         18181d-2*t270-1.3127055298329054d-1*t12*t133*t135)-1.4585
     8         616998143394d-1*t13*t271*t55-5.469606374303773d-2*t13*t27
     9         2*t273-1.3127055298329054d-1*t13*t133*t135)-6.34821225625
     :         071d-1*t153*t3*t56*t67+1.269642451250142d+0*t150*t151*t3*
     ;         t56+7.053569173611901d-2*t133*t15*t55+2.3511897245373004d
     <         -1*t15*t271*t3+1.763392293402975d-2*t135*t15*t273
            t279 = 1/t23**3
            t280 = t75**3
            t281 = -7.617854707500852d+0*t2*t74**3/t21**4+1.058035376041
     1         7849d-1*t54*t55*t72*t74+4.2321415041671406d-1*t134*t3*t72
     2         *t74+7.617854707500852d+0*t157*t160*t2*t74-1.269642451250
     3         142d+0*t2*t72*(2.625411059665811d-1*t134*t55*t73+1.969058
     4         2947493582d-1*t135*t54*t73-3.9381165894987163d-1*t159*t55
     5         *t56+7.876233178997433d-1*t3*(-1.4585616998143394d-1*t19*
     6         t271*t55-5.469606374303773d-2*t19*t272*t273-6.40793135650
     7         9611d-3*t270-1.3127055298329054d-1*t133*t135*t19)-1.45856
     8         16998143394d-1*t20*t271*t55-5.469606374303773d-2*t20*t272
     9         *t273-1.3127055298329054d-1*t133*t135*t20)-6.348212256250
     :         71d-1*t160*t3*t56*t72+1.269642451250142d+0*t157*t158*t3*t
     ;         56+7.053569173611901d-2*t133*t22*t55+2.3511897245373004d-
     <         1*t22*t271*t3+1.763392293402975d-2*t135*t22*t273
            t282 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(4
     1         .1099018897499934d-3*t261*t9-6.21814d-2*t11*t65**3/t8**3+
     2         1.0991093056753751d-2*t117*t66*t70-1.865442d-1*t148*t154*
     3         t18*t70-3.10907d-2*t11*t61*(7.053569173611901d-2*t133*t55
     4         *t7+2.3511897245373004d-1*t271*t3*t7+1.763392293402975d-2
     5         *t135*t273*t7-7.617854707500852d+0*t2*t64**3/t6**4+1.0580
     6         353760417849d-1*t54*t55*t62*t64+4.2321415041671406d-1*t13
     7         4*t3*t62*t64+7.617854707500852d+0*t143*t146*t2*t64-1.2696
     8         42451250142d+0*t2*t62*(2.625411059665811d-1*t134*t55*t63+
     9         1.9690582947493582d-1*t135*t54*t63-3.9381165894987163d-1*
     :         t145*t55*t56+7.876233178997433d-1*t3*(-1.4585616998143394
     ;         d-1*t271*t4*t55-5.469606374303773d-2*t272*t273*t4-1.31270
     <         55298329054d-1*t133*t135*t4-7.424439106586571d-3*t270)-1.
     =         4585616998143394d-1*t271*t5*t55-5.469606374303773d-2*t272
     >         *t273*t5-1.3127055298329054d-1*t133*t135*t5)-6.3482122562
     ?         5071d-1*t146*t3*t56*t62+1.269642451250142d+0*t143*t144*t3
     @         *t56)-8.243319792565315d-3*t154*t51*t66+6.21814d-2*t18*t2
     1         78*t66-5.284159572535706d-3*t117*t61*t65+9.32720999999999
     2         9d-2*t11*t141*t147*t65+3.96311967940178d-3*t147*t51*t61+8
     3         .243319792565315d-3*t148*t149*t51-3.96311967940178d-3*t14
     4         1*t142*t51+1.243628d-1*t18*t276*t277-8.548627933030694d-3
     5         *t17*t261)-3.107819689081493d-3*t117*t71*t75+1.013214d-1*
     6         t155*t161*t25*t75+2.33086476681112d-3*t161*t51*t71-3.3773
     7         8d-2*t25*t281*t71-2.33086476681112d-3*t155*t156*t51-6.754
     8         76d-2*t25*t279*t280+2.4171930915078277d-3*t24*t261)+3.107
     9         819689081493d-3*t117*t71*t75-1.013214d-1*t155*t161*t25*t7
     :         5-2.33086476681112d-3*t161*t51*t71+3.37738d-2*t25*t281*t7
     ;         1+2.33086476681112d-3*t155*t156*t51+6.75476d-2*t25*t279*t
     <         280-2.4171930915078277d-3*t24*t261)-1.0991093056753751d-2
     =         *t117*t66*t70+1.865442d-1*t148*t154*t18*t70+8.24331979256
     >         5315d-3*t154*t51*t66-6.21814d-2*t18*t278*t66-8.2433197925
     ?         65315d-3*t148*t149*t51-1.243628d-1*t18*t276*t277+8.548627
     @         933030694d-3*t17*t261
            t283 = rhoa**5.000000000000002d-1
            t284 = 1/rhoa**6.666666666666665d-1
            t285 = 1/rhoa**1.8333333333333332d+0
            t286 = t76**3
            t287 = exp(-2.4256569070538234d+2*t26)
            t288 = 8.619732841431575d+5*gammaaa*t286*t287*t30/t32**4
            t289 = -2.4874964680519085d+4*gammaaa*t165*t166*t167*t78*t79
            t290 = -8.619732841431575d+5*gammaaa*t166*t167*t286*t30
            t291 = 1.0660699148793894d+4*gammaaa*t162*t166*t167*t30*t76
            t292 = -1.035785462955064d+1*gammaaa*t283*t33*t86
            t293 = 1.1097701388804264d+0*gammaaa*t109*t284*t33
            t294 = 8.807699514924018d-2*gammaaa*t285*t33*t79
            t295 = 5.383843205234772d+2*gammaaa*t109*t163*t31*t76*t81
            t296 = -2.563734859635607d+1*gammaaa*t164*t31*t76*t79*t81
            t297 = 1.2437482340259542d+4*gammaaa*t165*t31*t78*t79*t81
            t298 = -1.5382409157813634d+2*gammaaa*t162*t31*t78*t79*t81
            t299 = 1.436622140238596d+5*gammaaa*t286*t30*t31*t81
            t300 = -5.330349574396946d+3*gammaaa*t162*t30*t31*t76*t81
            t301 = 2.1974870225448048d+1*gammaaa*t282*t30*t31*t81
            t302 = 1/t29**7.0d+0
            t303 = 1/t38**4
            t304 = 1/t40**3
            t305 = 1/t98**3
            t306 = 9.894226974230308d-2*rhoa*t107**3*t305
            t307 = -2.473556743557577d-2*t185
            t308 = -t107*t215
            t309 = -6.473659143469149d-1*gammaaa*t283*t86*t94*t97
            t310 = 6.936063368002663d-2*gammaaa*t109*t284*t94*t97
            t311 = -3.963464781715806d-2*gammaaa*t103*t164*t79*t97
            t312 = 3.963464781715806d-2*gammaaa*t104*t106*t164*t79*t94
            t313 = 9.512315476117932d-1*gammaaa*t103*t104*t106*t78*t79
            t314 = -9.512315476117932d-1*gammaaa*t193*t194*t78*t79*t94
            t315 = 1/t96**4
            t316 = -8.153413265243942d-1*gammaaa*t106**3*t30*t315*t94
            t317 = -6.473659143469149d-1*gammaaa*t283*t86*t92
            t318 = 6.936063368002663d-2*gammaaa*t109*t284*t92
            t319 = -4.734138489271654d-2*gammaaa*t285*t79*t92
            t320 = -4.529674036246635d-2*gammaaa*t263*t30*t92
            t321 = 3.3649020032717303d+1*gammaaa*t101*t109*t163*t60*t90
            t322 = -1.602334287272253d+0*gammaaa*t101*t164*t60*t79*t90
            t323 = 7.773426462662208d+2*gammaaa*t101*t200*t78*t79*t90
            t324 = 4.756157738058966d-1*gammaaa*t101*t202*t78*t79*t90
            t325 = t60**3
            t326 = 8.978888376491218d+3*gammaaa*t101*t30*t325*t90
            t327 = 1.8312391854540025d+0*gammaaa*t101*t126*t30*t60*t90
            t328 = -2.0213807558781852d+1*t126*t60-1.2569228533356386d+0
     1         *t263*t49*t50-4.042761511756372d+1*t275
            t329 = -1.3589022108739904d-1*gammaaa*t101*t30*t328*t90
            t330 = 1.6481152669086024d+1*gammaaa*t101*t202*t30*t60*t90
            t331 = -1.5546852925324417d+3*gammaaa*t200*t204*t205*t78*t79
            t332 = -5.38733302589473d+4*gammaaa*t204*t205*t30*t325
            t333 = -3.296230533817205d+1*gammaaa*t202*t204*t205*t30*t60
            t334 = exp(7.54153712001383d+0*t49*t50)
            t335 = 5.387333025894729d+4*gammaaa*t30*t325*t334/t91**4
            t336 = -4.398534861252425d-1*t283*t302*t85*t95
            t337 = 3.141810615180306d-2*t176*t284*t85*t95
            t338 = 2.4402862532009373d+3*t105*t325*t36*t90
            t339 = -2.1962576278808435d+4*t205*t211*t325*t36
            t340 = 2.928343503841125d+4*t325*t334*t36/t91**5.0d+0
            t341 = t274+t269+t268+t267+t266-2.4999999999999994d-1*t126*t
     1         265+t264+8.44345d-3*t124*t125*t263+t262
            t342 = 2.3120211226675536d-2*gammaaa*t285*t79*t92
            t343 = 1.5098913454155452d-2*gammaaa*t263*t30*t92
            t344 = -1.602334287272253d+0*gammaaa*t101*t164*t60*t79*t90
            t345 = 7.77342646266221d+2*gammaaa*t101*t200*t78*t79*t90
            t346 = 3.170771825372644d-1*gammaaa*t101*t220*t78*t79*t90
            t347 = 1.585385912686322d-1*gammaaa*t101*t202*t78*t79*t90
            t348 = -6.104130618180013d-1*gammaaa*t101*t126*t30*t60*t90
            t349 = 6.737935852927288d+0*t126*t60+4.189742844452128d-1*t2
     1         63*t49*t50-4.042761511756372d+1*t341
            t350 = -1.3589022108739904d-1*gammaaa*t101*t30*t349*t90
            t351 = 1.0987435112724019d+1*gammaaa*t101*t220*t30*t60*t90
            t352 = 5.493717556362009d+0*gammaaa*t101*t202*t30*t60*t90
            t353 = -1.554685292532442d+3*gammaaa*t200*t204*t205*t78*t79
            t354 = -2.1974870225448037d+1*gammaaa*t204*t205*t220*t30*t60
            t355 = -1.0987435112724019d+1*gammaaa*t202*t204*t205*t30*t60
            t356 = 3.553566382931298d+3*t165*t166*t167*t30
            t357 = 2.2195402777608514d+0*t109*t163*t33
            t358 = -1.0569239417908823d-1*t164*t33*t79
            t359 = -1.0254939438542422d+2*t31*t76*t78*t79*t81
            t360 = -1.776783191465649d+3*t165*t30*t31*t81
            t361 = 2.1974870225448048d+1*t162*t30*t31*t81
            t362 = 9.894226974230308d-2*rhoa*t113*t185*t305
            t363 = 4.947113487115154d-2*t238
            t364 = -2.774425347201063d-1*gammaaa*t104*t109*t112*t163*t94
            t365 = 1.321154927238602d-2*gammaaa*t104*t112*t164*t79*t94
            t366 = 6.936063368002658d-2*t109*t163*t94*t97
            t367 = -3.3028873180965046d-3*t164*t79*t94*t97
            t368 = 9.425431845540909d-3*gammaaa*t163*t176*t92*t97
            t369 = -4.488300878829006d-4*gammaaa*t164*t86*t92*t97
            t370 = -3.170771825372644d-1*gammaaa*t236*t78*t79*t97
            t371 = 3.170771825372644d-1*gammaaa*t104*t237*t78*t79*t94
            t372 = 3.170771825372644d-1*gammaaa*t103*t104*t112*t78*t79
            t373 = -7.926929563431611d-2*t103*t78*t79*t97
            t374 = -2.717804421747981d-1*gammaaa*t103*t104*t237*t30
            t375 = -6.341543650745288d-1*gammaaa*t106*t112*t193*t78*t79*
     1         t94
            t376 = 7.926929563431611d-2*t104*t106*t78*t79*t94
            t377 = 1.0771922109189608d-2*gammaaa*t104*t106*t78*t86*t92
            t378 = -2.717804421747981d-1*gammaaa*t104*t106*t236*t30
            t379 = 5.435608843495962d-1*gammaaa*t106*t193*t237*t30*t94
            t380 = 5.435608843495962d-1*gammaaa*t103*t106*t112*t193*t30
            t381 = -6.794511054369952d-2*t103*t104*t106*t30
            t382 = -8.153413265243942d-1*gammaaa*t112*t194*t30*t315*t94
            t383 = 6.794511054369952d-2*t193*t194*t30*t94
            t384 = 9.233076093591093d-3*gammaaa*t109*t193*t194*t92
            t385 = 6.936063368002658d-2*t109*t163*t92
            t386 = -3.3028873180965046d-3*t164*t79*t92
            t387 = 3.774728363538861d-3*t126*t30*t92
            t388 = -3.204668574544505d+0*t101*t60*t78*t79*t90
            t389 = -5.55244747333015d+1*t101*t200*t30*t90
            t390 = -3.397255527184976d-2*t101*t202*t30*t90
            t391 = 1.1104894946660299d+2*t200*t204*t205*t30
            t392 = 6.283621230360608d-2*gammaaa*t163*t176*t95
            t393 = -1.795320351531602d-3*gammaaa*t164*t86*t95
            t394 = -3.4838649688535417d+0*gammaaa*t105*t60*t78*t86*t90
            t395 = 9.054279776724049d+1*gammaaa*t109*t200*t205*t211
            t396 = (4.947113487115154d-2*rhoa*(3.774728363538861d-3*t126
     1         *t30*t94*t97+5.129486718661717d-4*gammaaa*t109*t126*t92*t
     2         97+1.3589022108739904d-1*gammaaa*t30*(t391+t390+t389+t388
     3         +t387+t386+t385)*t97+3.397255527184976d-2*t207*t30*t97-1.
     4         3589022108739904d-1*gammaaa*t104*t30*t94*(2.0517946874646
     5         867d-3*gammaaa*t109*t126*t95-1.8466152187182186d-2*gammaa
     6         a*t105*t109*t202*t90-3.018093258908016d+1*gammaaa*t105*t1
     7         09*t200*t90+t395+t394+t393+t392+t391+t390+t389+t388+t387+
     8         t386+t385)+2.717804421747981d-1*gammaaa*t112*t193*t213*t3
     9         0*t94-3.397255527184976d-2*t104*t213*t30*t94-1.5098913454
     :         155444d-2*gammaaa*t104*t112*t126*t30*t94-4.61653804679554
     ;         64d-3*gammaaa*t104*t109*t213*t92+t384+t383+t382+t381+t380
     <         +t379+t378+t377+t376+t375+t374+t373+t372+t371+t370+t369+t
     =         368+t367+t366+t365+t364-1.3589022108739904d-1*gammaaa*t10
     >         4*t112*t207*t30)+t363-8.245189145191921d-3*t113*t216)*t99
            t397 = -9.894226974230308d-2*rhoa*t107*t238
            t398 = t184*(t397-t113*t215)
            t399 = 9.894226974230308d-2*rhoa*t115*t185*t305
            t400 = 4.947113487115154d-2*t245
            t401 = -2.774425347201063d-1*gammaaa*t104*t109*t114*t163*t94
            t402 = 1.321154927238602d-2*gammaaa*t104*t114*t164*t79*t94
            t403 = 1.3872126736005316d-1*t109*t163*t94*t97
            t404 = -6.605774636193009d-3*t164*t79*t94*t97
            t405 = 1.885086369108182d-2*gammaaa*t163*t176*t92*t97
            t406 = -8.976601757658011d-4*gammaaa*t164*t86*t92*t97
            t407 = -3.170771825372644d-1*gammaaa*t243*t78*t79*t97
            t408 = 3.170771825372644d-1*gammaaa*t104*t244*t78*t79*t94
            t409 = 3.170771825372644d-1*gammaaa*t103*t104*t114*t78*t79
            t410 = -1.585385912686322d-1*t103*t78*t79*t97
            t411 = -2.717804421747981d-1*gammaaa*t103*t104*t244*t30
            t412 = -6.341543650745288d-1*gammaaa*t106*t114*t193*t78*t79*
     1         t94
            t413 = 1.585385912686322d-1*t104*t106*t78*t79*t94
            t414 = 2.1543844218379216d-2*gammaaa*t104*t106*t78*t86*t92
            t415 = -2.717804421747981d-1*gammaaa*t104*t106*t243*t30
            t416 = 5.435608843495962d-1*gammaaa*t106*t193*t244*t30*t94
            t417 = 5.435608843495962d-1*gammaaa*t103*t106*t114*t193*t30
            t418 = -1.3589022108739904d-1*t103*t104*t106*t30
            t419 = -8.153413265243942d-1*gammaaa*t114*t194*t30*t315*t94
            t420 = 1.3589022108739904d-1*t193*t194*t30*t94
            t421 = 1.8466152187182186d-2*gammaaa*t109*t193*t194*t92
            t422 = 1.3872126736005316d-1*t109*t163*t92
            t423 = -6.605774636193009d-3*t164*t79*t92
            t424 = 7.549456727077722d-3*t126*t30*t92
            t425 = -6.40933714908901d+0*t101*t60*t78*t79*t90
            t426 = -1.1104894946660299d+2*t101*t200*t30*t90
            t427 = -6.794511054369952d-2*t101*t202*t30*t90
            t428 = 2.2209789893320597d+2*t200*t204*t205*t30
            t429 = 1.2567242460721215d-1*gammaaa*t163*t176*t95
            t430 = -3.590640703063204d-3*gammaaa*t164*t86*t95
            t431 = -6.967729937707083d+0*gammaaa*t105*t60*t78*t86*t90
            t432 = 1.8108559553448098d+2*gammaaa*t109*t200*t205*t211
            t433 = -9.894226974230308d-2*rhoa*t107*t245
            t434 = -3.774728363538862d-3*t126*t30*t92
            t435 = -5.552447473330149d+1*t101*t200*t30*t90
            t436 = -3.397255527184976d-2*t101*t220*t30*t90
            t437 = 1.1104894946660297d+2*t200*t204*t205*t30
            t438 = -7.549456727077724d-3*t126*t30*t92
            t439 = -1.1104894946660297d+2*t101*t200*t30*t90
            t440 = -6.794511054369952d-2*t101*t220*t30*t90
            t441 = 2.2209789893320595d+2*t200*t204*t205*t30
            t442 = 9.894226974230308d-2*rhoa*t107*t250*t305
            t443 = 7.926929563431611d-2*t104*t112*t78*t79*t94
            t444 = 1.0771922109189608d-2*gammaaa*t104*t112*t78*t86*t92
            t445 = 6.794511054369952d-2*t236*t30*t97
            t446 = -6.794511054369952d-2*t104*t237*t30*t94
            t447 = -9.233076093591093d-3*gammaaa*t104*t109*t237*t92
            t448 = -6.794511054369952d-2*t103*t104*t112*t30
            t449 = 1.3589022108739904d-1*t106*t112*t193*t30*t94
            t450 = 1.8466152187182186d-2*gammaaa*t106*t109*t112*t193*t92
            t451 = (4.947113487115154d-2*rhoa*(-2.692980527297402d-3*t78
     1         *t86*t92*t97-1.3589022108739904d-1*gammaaa*t104*t30*t94*(
     2         1.866356233314397d-1*t105*t109*t60*t90-5.385961054594804d
     3         -3*t78*t86*t95)+3.6594971923850445d-4*gammaaa*t104*t302*t
     4         78*t94*t95+6.273423758374362d-4*gammaaa*t106*t176*t193*t9
     5         4*t95-3.136711879187181d-4*gammaaa*t103*t104*t176*t95-3.1
     6         70771825372644d-1*gammaaa*t193*t252*t78*t79*t94-8.1534132
     7         65243942d-1*gammaaa*t106*t252*t30*t315*t94+5.435608843495
     8         962d-1*gammaaa*t112*t193*t237*t30*t94-2.3082690233977732d
     9         -3*t104*t106*t109*t92+t450+t449+t448+t447+t446+t445+t444+
     :         t443+2.717804421747981d-1*gammaaa*t103*t193*t252*t30-2.71
     ;         7804421747981d-1*gammaaa*t104*t112*t236*t30)+2.4735567435
     <         57577d-2*t255)*t99
            t452 = t184*(-4.947113487115154d-2*rhoa*t107*t255-t113*t239-
     1         4.947113487115154d-2*rhoa*t113*t238)
            t453 = 9.894226974230308d-2*rhoa*t107*t113*t115*t305
            t454 = (4.947113487115154d-2*rhoa*(-5.385961054594804d-3*t78
     1         *t86*t92*t97+3.397255527184976d-2*t243*t30*t97-1.35890221
     2         08739904d-1*gammaaa*t104*t30*t94*(3.732712466628794d-1*t1
     3         05*t109*t60*t90-1.0771922109189608d-2*t78*t86*t95)+7.3189
     4         94384770089d-4*gammaaa*t104*t302*t78*t94*t95+1.2546847516
     5         748727d-3*gammaaa*t106*t176*t193*t94*t95-6.27342375837436
     6         2d-4*gammaaa*t103*t104*t176*t95-3.170771825372644d-1*gamm
     7         aaa*t112*t114*t193*t78*t79*t94+3.9634647817158053d-2*t104
     8         *t114*t78*t79*t94-8.153413265243942d-1*gammaaa*t106*t112*
     9         t114*t30*t315*t94+2.717804421747981d-1*gammaaa*t112*t193*
     :         t244*t30*t94-3.397255527184976d-2*t104*t244*t30*t94+2.717
     ;         804421747981d-1*gammaaa*t114*t193*t237*t30*t94+6.79451105
     <         4369952d-2*t106*t114*t193*t30*t94+5.385961054594804d-3*ga
     =         mmaaa*t104*t114*t78*t86*t92-4.6165380467955464d-3*gammaaa
     >         *t104*t109*t244*t92+9.233076093591093d-3*gammaaa*t106*t10
     ?         9*t114*t193*t92-4.6165380467955464d-3*t104*t106*t109*t92+
     @         t450+t449+t448+t447+t446+t445+t444+t443-1.358902210873990
     1         4d-1*gammaaa*t104*t112*t243*t30-1.3589022108739904d-1*gam
     2         maaa*t104*t114*t236*t30+2.717804421747981d-1*gammaaa*t103
     3         *t112*t114*t193*t30-3.397255527184976d-2*t103*t104*t114*t
     4         30)+2.473556743557577d-2*t257)*t99
            t455 = -4.947113487115154d-2*rhoa*t107*t257
            t456 = (t452+t451+t442)*wght
            t457 = 1/t29**8.0d+0
            t458 = 9.894226974230308d-2*rhoa*t113**3*t305
            t459 = 4.947113487115154d-2*rhoa*(1.882027127512309d-3*gamma
     1         aa*t112*t176*t193*t94*t95-2.3525339093903863d-4*t104*t176
     2         *t94*t95-8.153413265243942d-1*gammaaa*t112**3*t30*t315*t9
     3         4+2.0383533163109854d-1*t193*t252*t30*t94+2.7699228280773
     4         28d-2*gammaaa*t109*t193*t252*t92-6.92480707019332d-3*t104
     5         *t109*t112*t92-3.1968635306266263d-5*gammaaa*t104*t105*t4
     6         57)*t99
            t460 = -1.4841340461345462d-1*rhoa*t113*t184*t255
            t461 = 2.5093695033497454d-3*gammaaa*t112*t176*t193*t94*t95
            t462 = -9.233076093591093d-3*t104*t109*t112*t92
            t463 = (4.947113487115154d-2*rhoa*(6.273423758374362d-4*gamm
     1         aaa*t114*t176*t193*t94*t95-4.7050678187807726d-4*t104*t17
     2         6*t94*t95-8.153413265243942d-1*gammaaa*t114*t252*t30*t315
     3         *t94+1.3589022108739904d-1*t193*t252*t30*t94+1.3589022108
     4         739904d-1*t112*t114*t193*t30*t94+1.8466152187182186d-2*ga
     5         mmaaa*t109*t193*t252*t92+1.8466152187182186d-2*gammaaa*t1
     6         09*t112*t114*t193*t92-2.3082690233977732d-3*t104*t109*t11
     7         4*t92+t462+t461-6.393727061253253d-5*gammaaa*t104*t105*t4
     8         57)*t99+9.894226974230308d-2*rhoa*t115*t250*t305+t184*(-9
     9         .894226974230308d-2*rhoa*t113*t257-4.947113487115154d-2*r
     :         hoa*t115*t255))*wght
            fnc(iq) = (4.947113487115154d-2*rhoa*log(1.35890221087399d-1
     1         *gammaaa*t30*(t43+1.0d+0)/(t43+1.8466152187182178d-2*t36/
     2         t42**2.0d+0+1.0d+0)+1.0d+0)-2.4735567435575762d-2*rhoa*t4
     3         1-1.243628d-1*rhoa*t27*t28-2.0d+0*rhoa*t26)*wght+fnc(iq)
            Amat(iq,D1_RA) = (4.947113487115154d-2*rhoa*t107*t99-1.23677
     1         83717787881d-2*rhoa*t77*t89-1.0d+0*rhoa*t76+2.0d+0*rhoa*t
     2         60-6.21814d-2*t49*t50-1.2367783717787881d-2*t41-1.0d+0*t2
     3         6+2.473556743557577d-2*t108)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = (4.947113487115154d-2*rhoa*t113*t99-1.2367
     1         783717787881d-2*rhoa*t111*t77)*wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = 4.947113487115154d-2*rhoa*t115*t99*wght+Cm
     1         at(iq,D1_GAB)
            Amat2(iq,D2_RA_RA) = (t215*t99+t181*t77-2.0d+0*t76-8.2451891
     1         45191921d-3*t108*t216+t186+1.2367783717787881d-2*rhoa*t18
     2         2*t183-1.0d+0*rhoa*t162+2.0d+0*rhoa*t140+t116)*wght+Amat2
     3         (iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = (t226*t99+2.0d+0*rhoa*t217+8.2451891451
     1         91922d-3*t108*t216+t186+t116)*wght+Amat2(iq,D2_RA_RB)
            Cmat2(iq,D2_RA_GAA) = (1.2367783717787881d-2*rhoa*t111*t182*
     1         t89+t232*t77+t240+t233)*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = (t246*t99-4.947113487115154d-2*rhoa*t1
     1         07*t115*t184)*wght+Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = (t240+t233)*wght+Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_GAA_GAA) = (-1.2367783717787881d-2*rhoa*t249*t77
     1         +t256+t251+1.2367783717787881d-2*rhoa*t182*t247)*wght+Cma
     2         t2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = (4.947113487115154d-2*rhoa*t257*t99-4
     1         .947113487115154d-2*rhoa*t113*t115*t184)*wght+Cmat2(iq,D2
     2         _GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = (t256+t251)*wght+Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = 4.947113487115154d-2*rhoa*t260*t99*wg
     1         ht-4.947113487115154d-2*rhoa*t184*t258*wght+Cmat2(iq,D2_G
     2         AB_GAB)
            Amat3(iq,D3_RA_RA_RA) = ((4.947113487115154d-2*rhoa*(-4.7341
     1         38489271654d-2*gammaaa*t285*t79*t94*t97-4.529674036246635
     2         d-2*gammaaa*t263*t30*t94*t97-4.756157738058966d-1*gammaaa
     3         *t207*t78*t79*t97+1.3589022108739904d-1*gammaaa*t30*(t335
     4         +t333+t332+t331+t330+t329+t327+t326+t324+t323+t322+t321+t
     5         320+t319+t318+t317)*t97+4.529674036246633d-2*gammaaa*t103
     6         *t126*t30*t97+8.32327604160319d-1*gammaaa*t103*t109*t163*
     7         t97-1.3589022108739904d-1*gammaaa*t104*t30*t94*(-2.722902
     8         533156262d-2*t285*t85*t86*t95-1.2310768124788125d-2*t263*
     9         t36*t95+2.5852613062055063d-1*t105*t202*t78*t85*t86*t90+4
     :         .2253305624712234d+2*t105*t200*t78*t85*t86*t90-8.70966242
     ;         2133856d-1*t105*t164*t60*t85*t86*t90+3.04838184774685d+1*
     <         t105*t163*t176*t60*t85*t90+4.4792549599545534d+0*t105*t20
     =         2*t36*t60*t90+9.953899911010116d-1*t105*t126*t36*t60*t90-
     >         3.693230437436437d-2*t105*t328*t36*t90-1.2675991687413668
     ?         d+3*t200*t205*t211*t78*t85*t86-1.343776487986366d+1*t202*
     @         t205*t211*t36*t60+t340+t339+t338+t337+t336+t335+t333+t332
     1         +t331+t330+t329+t327+t326+t324+t323+t322+t321+t320+t319+t
     2         318+t317)+4.756157738058966d-1*gammaaa*t104*t213*t78*t79*
     3         t94+8.153413265243942d-1*gammaaa*t106*t193*t213*t30*t94-4
     4         .529674036246633d-2*gammaaa*t104*t106*t126*t30*t94-8.3232
     5         7604160319d-1*gammaaa*t104*t106*t109*t163*t94+t316+t314+t
     6         313+t312+t311+t310+t309-4.076706632621971d-1*gammaaa*t103
     7         *t104*t213*t30-4.076706632621971d-1*gammaaa*t104*t106*t20
     8         7*t30+8.153413265243942d-1*gammaaa*t103*t193*t194*t30)-2.
     9         473556743557576d-2*t107*t216+7.420670230672731d-2*t214)*t
     :         99-2.4735567435575762d-2*rhoa*t304*t89**3+t182*(-t181*t89
     ;         +2.4735567435575762d-2*rhoa*t180*t89+1.2367783717787881d-
     <         2*t183)+t77*(-1.2367783717787881d-2*rhoa*(-1.630682653048
     =         789d+0*gammaaa*t30*t303*t35*t88**3+3.8049261904471743d+0*
     >         gammaaa*t78*t79*t83*t84*t88+3.170771825372647d-1*gammaaa*
     ?         t164*t35*t79*t84*t88-6.658620833282555d+0*gammaaa*t109*t1
     @         63*t35*t84*t88-8.153413265243944d-1*gammaaa*t174*t30*t84*
     1         t88+1.630682653048789d+0*gammaaa*t177*t178*t30*t35*t88-2.
     2         7178044217479813d-1*gammaaa*t30*t35*t84*(1.35210577999079
     3         26d+4*t165*t31*t78*t85*t86*t87-1.6722551850497014d+2*t162
     4         *t31*t78*t85*t86*t87-2.787091975082837d+1*t164*t31*t76*t8
     5         5*t86*t87+9.754821912789926d+2*t163*t176*t31*t76*t85*t87-
     6         2.8973695285516987d+3*t162*t31*t36*t76*t87+7.808916010243
     7         009d+4*t286*t31*t36*t87+1.1944679893212153d+1*t282*t31*t3
     8         6*t87-4.0563173399723773d+4*t165*t166*t175*t78*t85*t86+4.
     9         78752093741761d-2*t285*t37*t85*t86-1.4075311556007766d+1*
     :         t283*t302*t37*t85+1.0053793968576981d+0*t176*t284*t37*t85
     ;         +8.692108585655094d+3*t162*t166*t175*t36*t76+9.3706992122
     <         9161d+5*t286*t287*t36/t32**5.0d+0-7.028024409218707d+5*t1
     =         66*t175*t286*t36+t301+t300+t299+t298+t297+t296+t295+t294+
     >         t293+t292+t291+t290+t289+t288)-1.035785462955064d+1*gamma
     ?         aa*t283*t35*t39*t86-8.153413265243944d-1*gammaaa*t177*t30
     @         *t83*t84+1.9024630952235871d+0*gammaaa*t177*t35*t78*t79*t
     1         84-3.170771825372647d-1*gammaaa*t164*t39*t79*t83+6.658620
     2         833282555d+0*gammaaa*t109*t163*t39*t83+1.630682653048789d
     3         +0*gammaaa*t178*t179*t30*t83-1.9024630952235871d+0*gammaa
     4         a*t174*t39*t78*t79-3.8049261904471743d+0*gammaaa*t178*t17
     5         9*t35*t78*t79+8.807699514924018d-2*gammaaa*t285*t35*t39*t
     6         79+1.1097701388804264d+0*gammaaa*t109*t284*t35*t39+2.7178
     7         044217479813d-1*gammaaa*t30*(t301+t300+t299+t298+t297+t29
     8         6+t295+t294+t293+t292+t291+t290+t289+t288)*t39)-3.7103351
     9         15336365d-2*t180)+t184*(t308+t307-9.894226974230308d-2*rh
     :         oa*t107*t214)+t306-1.0d+0*rhoa*t282+2.0d+0*rhoa*t275-3.0d
     ;         +0*t162+3.0d+0*t140+1.2367783717787893d-2*t108*t126)*wght
     <         +Amat3(iq,D3_RA_RA_RA)
            Amat3(iq,D3_RA_RA_RB) = ((4.947113487115154d-2*rhoa*(2.31202
     1         11226675536d-2*gammaaa*t285*t79*t94*t97+1.509891345415545
     2         2d-2*gammaaa*t263*t30*t94*t97-3.170771825372644d-1*gammaa
     3         a*t223*t78*t79*t97-1.585385912686322d-1*gammaaa*t207*t78*
     4         t79*t97+1.3589022108739904d-1*gammaaa*t30*(t355+t354+t353
     5         +t352+t351+t350+t348+t347+t346+t345+t344+t343+t342+t335+t
     6         332+t326+t321+t318+t317)*t97-1.5098913454155452d-2*gammaa
     7         a*t103*t126*t30*t97+8.323276041603189d-1*gammaaa*t103*t10
     8         9*t163*t97-1.3589022108739904d-1*gammaaa*t104*t30*t94*(1.
     9         1071142167778211d-2*t285*t85*t86*t95+4.103589374929375d-3
     :         *t263*t36*t95+1.7235075374703374d-1*t105*t220*t78*t85*t86
     ;         *t90+8.617537687351686d-2*t105*t202*t78*t85*t86*t90+4.225
     <         330562471223d+2*t105*t200*t78*t85*t86*t90-8.7096624221338
     =         57d-1*t105*t164*t60*t85*t86*t90+3.0483818477468494d+1*t10
     >         5*t163*t176*t60*t85*t90+2.9861699733030356d+0*t105*t220*t
     ?         36*t60*t90+1.4930849866515178d+0*t105*t202*t36*t60*t90-3.
     @         317966637003373d-1*t105*t126*t36*t60*t90-3.69323043743643
     1         7d-2*t105*t349*t36*t90-1.267599168741367d+3*t200*t205*t21
     2         1*t78*t85*t86-8.958509919909107d+0*t205*t211*t220*t36*t60
     3         -4.4792549599545534d+0*t202*t205*t211*t36*t60+t355+t354+t
     4         353+t352+t351+t350+t348+t347+t346+t345+t344+t343+t342+t34
     5         0+t339+t338+t337+t336+t335+t332+t326+t321+t318+t317)+3.17
     6         0771825372644d-1*gammaaa*t104*t224*t78*t79*t94+1.58538591
     7         2686322d-1*gammaaa*t104*t213*t78*t79*t94+5.43560884349596
     8         2d-1*gammaaa*t106*t193*t224*t30*t94+2.717804421747981d-1*
     9         gammaaa*t106*t193*t213*t30*t94+1.5098913454155452d-2*gamm
     :         aaa*t104*t106*t126*t30*t94-8.323276041603189d-1*gammaaa*t
     ;         104*t106*t109*t163*t94+t316+t314+t313+t312+t311+t310+t309
     <         -2.717804421747981d-1*gammaaa*t103*t104*t224*t30-2.717804
     =         421747981d-1*gammaaa*t104*t106*t223*t30-1.358902210873990
     >         4d-1*gammaaa*t103*t104*t213*t30-1.3589022108739904d-1*gam
     ?         maaa*t104*t106*t207*t30+8.153413265243943d-1*gammaaa*t103
     @         *t193*t194*t30)+4.947113487115154d-2*t225+8.2451891451919
     1         25d-3*t107*t216+2.473556743557577d-2*t214)*t99+2.0d+0*rho
     2         a*t341+t184*(t308+t307-9.894226974230308d-2*rhoa*t107*t22
     3         5)+t306+2.0d+0*t217+1.0d+0*t140-4.1225945725959623d-3*t10
     4         8*t126)*wght+Amat3(iq,D3_RA_RA_RB)
            Cmat3(iq,D3_RA_RA_GAA) = (t182*(2.4735567435575762d-2*rhoa*t
     1         231*t89-t111*t181)+t77*(-1.2367783717787881d-2*rhoa*(3.44
     2         70150749406775d-1*gammaaa*t33*t78*t84*t86*t88-5.435608843
     3         495963d-1*t30*t83*t84*t88+1.268308730149058d+0*t35*t78*t7
     4         9*t84*t88-5.435608843495963d-1*gammaaa*t229*t30*t84*t88+1
     5         .0871217686991926d+0*gammaaa*t110*t178*t30*t83*t88-2.5366
     6         17460298116d+0*gammaaa*t110*t178*t35*t78*t79*t88+1.087121
     7         7686991926d+0*gammaaa*t178*t230*t30*t35*t88-2.71780442174
     8         79813d-1*gammaaa*t30*t35*t84*(-2.2296735800662684d+2*gamm
     9         aaa*t31*t76*t78*t86*t87-1.9315796857011325d+3*gammaaa*t10
     :         9*t165*t31*t87+2.3889359786424305d+1*gammaaa*t109*t162*t3
     ;         1*t87-1.1490050249802264d-1*gammaaa*t164*t37*t86+4.021517
     <         5874307907d+0*gammaaa*t163*t176*t37+t361+t360+t359+t358+t
     =         357+t356+5.794739057103396d+3*gammaaa*t109*t165*t166*t175
     >         )-2.872512562450566d-2*gammaaa*t164*t33*t39*t86+1.2683087
     ?         30149058d+0*gammaaa*t110*t78*t79*t83*t84-5.43560884349596
     @         3d-1*gammaaa*t230*t30*t83*t84+1.268308730149058d+0*gammaa
     1         a*t230*t35*t78*t79*t84+1.0569239417908823d-1*gammaaa*t110
     2         *t164*t35*t79*t84-2.7178044217479813d-1*t177*t30*t35*t84-
     3         2.2195402777608514d+0*gammaaa*t109*t110*t163*t35*t84-7.38
     4         6460874872879d-2*gammaaa*t109*t177*t33*t84-2.717804421747
     5         9813d-1*gammaaa*t110*t174*t30*t84-1.268308730149058d+0*t3
     6         9*t78*t79*t83-1.268308730149058d+0*gammaaa*t229*t39*t78*t
     7         79-1.0569239417908823d-1*t164*t35*t39*t79+2.7178044217479
     8         813d-1*gammaaa*t30*(t361+t360+t359+t358+t357+t356)*t39+2.
     9         2195402777608514d+0*t109*t163*t35*t39+6.032276381146184d-
     :         1*gammaaa*t163*t176*t33*t39+2.7178044217479813d-1*t174*t3
     ;         0*t39-1.630682653048789d+0*gammaaa*t110*t179*t30*t303*t35
     <         +5.435608843495963d-1*t178*t179*t30*t35+5.435608843495963
     =         d-1*gammaaa*t110*t177*t178*t30*t35+1.4772921749745757d-1*
     >         gammaaa*t109*t178*t179*t33)-2.4735567435575762d-2*t231)+t
     ?         398+t396+t362-2.4735567435575762d-2*rhoa*t111*t183*t304)*
     @         wght+Cmat3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_RA_GAB) = ((4.947113487115154d-2*rhoa*(7.5494
     1         56727077722d-3*t126*t30*t94*t97+1.0258973437323433d-3*gam
     2         maaa*t109*t126*t92*t97+1.3589022108739904d-1*gammaaa*t30*
     3         (t428+t427+t426+t425+t424+t423+t422)*t97+6.79451105436995
     4         2d-2*t207*t30*t97-1.3589022108739904d-1*gammaaa*t104*t30*
     5         t94*(4.1035893749293734d-3*gammaaa*t109*t126*t95-3.693230
     6         437436437d-2*gammaaa*t105*t109*t202*t90-6.036186517816032
     7         d+1*gammaaa*t105*t109*t200*t90+t432+t431+t430+t429+t428+t
     8         427+t426+t425+t424+t423+t422)+2.717804421747981d-1*gammaa
     9         a*t114*t193*t213*t30*t94-6.794511054369952d-2*t104*t213*t
     :         30*t94-1.5098913454155444d-2*gammaaa*t104*t114*t126*t30*t
     ;         94-9.233076093591093d-3*gammaaa*t104*t109*t213*t92+t421+t
     <         420+t419+t418+t417+t416+t415+t414+t413+t412+t411+t410+t40
     =         9+t408+t407+t406+t405+t404+t403+t402+t401-1.3589022108739
     >         904d-1*gammaaa*t104*t114*t207*t30)+t400-8.245189145191921
     ?         d-3*t115*t216)*t99+t184*(t433-t115*t215)+t399)*wght+Cmat3
     @         (iq,D3_RA_RA_GAB)
            Cmat3(iq,D3_RA_RA_GBB) = (t398+t396+t362)*wght+Cmat3(iq,D3_R
     1         A_RA_GBB)
            Cmat3(iq,D3_RA_RB_GAA) = ((4.947113487115154d-2*rhoa*(-3.774
     1         728363538862d-3*t126*t30*t94*t97-5.129486718661718d-4*gam
     2         maaa*t109*t126*t92*t97+1.3589022108739904d-1*gammaaa*t30*
     3         (t437+t436+t435+t434+t388+t386+t385)*t97+3.39725552718497
     4         6d-2*t223*t30*t97-1.3589022108739904d-1*gammaaa*t104*t30*
     5         t94*(-2.0517946874646872d-3*gammaaa*t109*t126*t95-1.84661
     6         52187182186d-2*gammaaa*t105*t109*t220*t90-3.0180932589080
     7         156d+1*gammaaa*t105*t109*t200*t90+t437+t436+t435+t434+t39
     8         5+t394+t393+t392+t388+t386+t385)+2.717804421747981d-1*gam
     9         maaa*t112*t193*t224*t30*t94-3.397255527184976d-2*t104*t22
     :         4*t30*t94+1.509891345415545d-2*gammaaa*t104*t112*t126*t30
     ;         *t94-4.6165380467955464d-3*gammaaa*t104*t109*t224*t92+t38
     <         4+t383+t382+t381+t380+t379+t378+t377+t376+t375+t374+t373+
     =         t372+t371+t370+t369+t368+t367+t366+t365+t364-1.3589022108
     >         739904d-1*gammaaa*t104*t112*t223*t30)+t363+8.245189145191
     ?         922d-3*t113*t216)*t99+t184*(t397-t113*t226)+t362)*wght+Cm
     @         at3(iq,D3_RA_RB_GAA)
            Cmat3(iq,D3_RA_RB_GAB) = ((4.947113487115154d-2*rhoa*(-7.549
     1         456727077724d-3*t126*t30*t94*t97-1.0258973437323436d-3*ga
     2         mmaaa*t109*t126*t92*t97+1.3589022108739904d-1*gammaaa*t30
     3         *(t441+t440+t439+t438+t425+t423+t422)*t97+6.7945110543699
     4         52d-2*t223*t30*t97-1.3589022108739904d-1*gammaaa*t104*t30
     5         *t94*(-4.1035893749293745d-3*gammaaa*t109*t126*t95-3.6932
     6         30437436437d-2*gammaaa*t105*t109*t220*t90-6.0361865178160
     7         31d+1*gammaaa*t105*t109*t200*t90+t441+t440+t439+t438+t432
     8         +t431+t430+t429+t425+t423+t422)+2.717804421747981d-1*gamm
     9         aaa*t114*t193*t224*t30*t94-6.794511054369952d-2*t104*t224
     :         *t30*t94+1.509891345415545d-2*gammaaa*t104*t114*t126*t30*
     ;         t94-9.233076093591093d-3*gammaaa*t104*t109*t224*t92+t421+
     <         t420+t419+t418+t417+t416+t415+t414+t413+t412+t411+t410+t4
     =         09+t408+t407+t406+t405+t404+t403+t402+t401-1.358902210873
     >         9904d-1*gammaaa*t104*t114*t223*t30)+t400+8.24518914519192
     ?         2d-3*t115*t216)*t99+t184*(t433-t115*t226)+t399)*wght+Cmat
     @         3(iq,D3_RA_RB_GAB)
            Cmat3(iq,D3_RA_GAA_GAA) = (t182*(1.2367783717787881d-2*rhoa*
     1         t249*t89-t111*t232+1.2367783717787881d-2*rhoa*t111*t231)-
     2         2.4735567435575762d-2*rhoa*t247*t304*t89+t77*(-1.23677837
     3         17787881d-2*rhoa*(-1.4772921749745757d-1*t109*t33*t84*t88
     4         +8.02998241071919d-2*gammaaa*t176*t178*t35*t37*t88-1.6306
     5         82653048789d+0*gammaaa*t248*t30*t303*t35*t88+1.0871217686
     6         991926d+0*t110*t178*t30*t35*t88+2.9545843499491514d-1*gam
     7         maaa*t109*t110*t178*t33*t88-2.7178044217479813d-1*gammaaa
     8         *t30*t35*t84*(2.3889359786424305d+1*t109*t31*t76*t87-6.89
     9         4030149881355d-1*t37*t78*t86)+3.4470150749406775d-1*gamma
     :         aa*t110*t33*t78*t84*t86-3.4470150749406775d-1*t33*t39*t78
     ;         *t86-4.014991205359595d-2*gammaaa*t176*t37*t83*t84-5.4356
     <         08843495963d-1*t110*t30*t83*t84+1.268308730149058d+0*t110
     =         *t35*t78*t79*t84+9.368312812505724d-2*gammaaa*t302*t35*t3
     >         7*t78*t84-5.435608843495963d-1*t230*t30*t35*t84-1.4772921
     ?         749745757d-1*gammaaa*t109*t230*t33*t84-5.435608843495963d
     @         -1*gammaaa*t110*t229*t30*t84+5.435608843495963d-1*gammaaa
     1         *t178*t248*t30*t83-1.268308730149058d+0*gammaaa*t178*t248
     2         *t35*t78*t79+5.435608843495963d-1*t229*t30*t39+1.08712176
     3         86991926d+0*gammaaa*t110*t178*t230*t30*t35)-1.23677837177
     4         87881d-2*t249)+t452+t451+t442)*wght+Cmat3(iq,D3_RA_GAA_GA
     5         A)
            Cmat3(iq,D3_RA_GAA_GAB) = (t184*(t455-4.947113487115154d-2*r
     1         hoa*t113*t245-t115*t239)+t454+t453)*wght+Cmat3(iq,D3_RA_G
     2         AA_GAB)
            Cmat3(iq,D3_RA_GAA_GBB) = t456+Cmat3(iq,D3_RA_GAA_GBB)
            Cmat3(iq,D3_RA_GAB_GAB) = ((4.947113487115154d-2*rhoa*(-1.07
     1         71922109189608d-2*t78*t86*t92*t97+1.3589022108739904d-1*t
     2         243*t30*t97-1.3589022108739904d-1*gammaaa*t104*t30*t94*(7
     3         .465424933257588d-1*t105*t109*t60*t90-2.1543844218379216d
     4         -2*t78*t86*t95)+1.4637988769540178d-3*gammaaa*t104*t302*t
     5         78*t94*t95+2.5093695033497454d-3*gammaaa*t106*t176*t193*t
     6         94*t95-1.2546847516748727d-3*gammaaa*t103*t104*t176*t95-3
     7         .170771825372644d-1*gammaaa*t193*t259*t78*t79*t94+1.58538
     8         5912686322d-1*t104*t114*t78*t79*t94-8.153413265243942d-1*
     9         gammaaa*t106*t259*t30*t315*t94+5.435608843495962d-1*gamma
     :         aa*t114*t193*t244*t30*t94-1.3589022108739904d-1*t104*t244
     ;         *t30*t94+2.717804421747981d-1*t106*t114*t193*t30*t94+2.15
     <         43844218379216d-2*gammaaa*t104*t114*t78*t86*t92-1.8466152
     =         187182186d-2*gammaaa*t104*t109*t244*t92+3.693230437436437
     >         d-2*gammaaa*t106*t109*t114*t193*t92-9.233076093591093d-3*
     ?         t104*t106*t109*t92+2.717804421747981d-1*gammaaa*t103*t193
     @         *t259*t30-2.717804421747981d-1*gammaaa*t104*t114*t243*t30
     1         -1.3589022108739904d-1*t103*t104*t114*t30)+2.473556743557
     2         577d-2*t260)*t99+9.894226974230308d-2*rhoa*t107*t258*t305
     3         +t184*(-4.947113487115154d-2*rhoa*t107*t260-t115*t246-4.9
     4         47113487115154d-2*rhoa*t115*t245))*wght+Cmat3(iq,D3_RA_GA
     5         B_GAB)
            Cmat3(iq,D3_RA_GAB_GBB) = (t184*(t455-t113*t246-4.9471134871
     1         15154d-2*rhoa*t115*t238)+t454+t453)*wght+Cmat3(iq,D3_RA_G
     2         AB_GBB)
            Cmat3(iq,D3_RA_GBB_GBB) = t456+Cmat3(iq,D3_RA_GBB_GBB)
            Cmat3(iq,D3_GAA_GAA_GAA) = (-1.2367783717787881d-2*rhoa*t77*
     1         (-3.2735882553616696d-2*gammaaa*t457*t84*t87-1.2044973616
     2         078786d-1*t176*t35*t37*t84-4.431876524923727d-1*t109*t110
     3         *t33*t84+2.4089947232157571d-1*gammaaa*t110*t176*t178*t35
     4         *t37-1.630682653048789d+0*gammaaa*t110**3*t30*t303*t35+1.
     5         630682653048789d+0*t178*t248*t30*t35+4.431876524923727d-1
     6         *gammaaa*t109*t178*t248*t33)+t460+t459+t458-2.47355674355
     7         75762d-2*rhoa*t111**3*t304+3.710335115336365d-2*rhoa*t111
     8         *t182*t249)*wght+Cmat3(iq,D3_GAA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAB) = t463+Cmat3(iq,D3_GAA_GAA_GAB)
            Cmat3(iq,D3_GAA_GAA_GBB) = (t460+t459+t458)*wght+Cmat3(iq,D3
     1         _GAA_GAA_GBB)
            Cmat3(iq,D3_GAA_GAB_GAB) = (4.947113487115154d-2*rhoa*(2.509
     1         3695033497454d-3*gammaaa*t114*t176*t193*t94*t95-9.4101356
     2         37561545d-4*t104*t176*t94*t95-8.153413265243942d-1*gammaa
     3         a*t112*t259*t30*t315*t94+6.794511054369952d-2*t193*t259*t
     4         30*t94+2.717804421747981d-1*t112*t114*t193*t30*t94+9.2330
     5         76093591093d-3*gammaaa*t109*t193*t259*t92+3.6932304374364
     6         37d-2*gammaaa*t109*t112*t114*t193*t92-9.233076093591093d-
     7         3*t104*t109*t114*t92+t462+t461-1.2787454122506506d-4*gamm
     8         aaa*t104*t105*t457)*t99+9.894226974230308d-2*rhoa*t113*t2
     9         58*t305+t184*(-4.947113487115154d-2*rhoa*t113*t260-9.8942
     :         26974230308d-2*rhoa*t115*t257))*wght+Cmat3(iq,D3_GAA_GAB_
     ;         GAB)
            Cmat3(iq,D3_GAA_GAB_GBB) = t463+Cmat3(iq,D3_GAA_GAB_GBB)
            Cmat3(iq,D3_GAB_GAB_GAB) = 4.947113487115154d-2*rhoa*(7.5281
     1         08510049236d-3*gammaaa*t114*t176*t193*t94*t95-1.882027127
     2         512309d-3*t104*t176*t94*t95-8.153413265243942d-1*gammaaa*
     3         t114**3*t30*t315*t94+4.076706632621971d-1*t193*t259*t30*t
     4         94+5.539845656154656d-2*gammaaa*t109*t193*t259*t92-2.7699
     5         22828077328d-2*t104*t109*t114*t92-2.557490824501301d-4*ga
     6         mmaaa*t104*t105*t457)*t99*wght+9.894226974230308d-2*rhoa*
     7         t115**3*t305*wght-1.4841340461345462d-1*rhoa*t115*t184*t2
     8         60*wght+Cmat3(iq,D3_GAB_GAB_GAB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1.530901310039024d-2*t3+1.0465751434d-1
            t5 = 7.876233178997433d-1*t3*t4+1.9269083139d-1
            t6 = 7.876233178997433d-1*t3*t5+4.3896648423d-1
            t7 = 1/t6
            t8 = 1.269642451250142d+0*t2*t7+1.0d+0
            t9 = log(t8)
            t10 = 1/t1
            t11 = 1.2746961887000874d-1*t10+1.0d+0
            t12 = 2.4141993114533214d-2*t3+1.0186556948d-1
            t13 = 7.876233178997433d-1*t12*t3+2.2308199064d-1
            t14 = 7.876233178997433d-1*t13*t3+4.7231125998d-1
            t15 = 1/t14
            t16 = 1.269642451250142d+0*t15*t2+1.0d+0
            t17 = log(t16)
            t18 = 1.325688999052018d-1*t10+1.0d+0
            t19 = 1.3212998810398843d-2*t3+2.9729725188d-2
            t20 = 7.876233178997433d-1*t19*t3+1.2236585478d-1
            t21 = 7.876233178997433d-1*t20*t3+3.497952466d-1
            t22 = 1/t21
            t23 = 1.269642451250142d+0*t2*t22+1.0d+0
            t24 = log(t23)
            t25 = 6.901399211255826d-2*t10+1.0d+0
            t26 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t17*t18-3.10907d-2*t11*t9)-3.37738d-2*t24*t25)+3
     2         .37738d-2*t24*t25)-6.21814d-2*t17*t18
            t27 = rhoa**1.1666666666666667d+0
            t28 = 1/t27**2.0d+0
            t29 = exp(-8.085523023512745d+1*t26)
            t30 = t29-1.0d+0
            t31 = 1/t30
            t32 = 2.7178044217479813d-1*gammaaa*t28*t31
            t33 = t32+1.0d+0
            t34 = (gammaaa*t28)**2.0d+0
            t35 = 1/t30**2.0d+0
            t36 = 7.38646087487288d-2*t34*t35+t32+1.0d+0
            t37 = 1/t36
            t38 = 2.7178044217479813d-1*gammaaa*t28*t33*t37+1.0d+0
            t39 = log(t38)
            t40 = rhob**3.333333333333333d-1
            t41 = t40**5.0d-1
            t42 = 1/t41
            t43 = 1.530901310039024d-2*t42+1.0465751434d-1
            t44 = 7.876233178997433d-1*t42*t43+1.9269083139d-1
            t45 = 7.876233178997433d-1*t42*t44+4.3896648423d-1
            t46 = 1/t45
            t47 = 1.269642451250142d+0*t41*t46+1.0d+0
            t48 = log(t47)
            t49 = 1/t40
            t50 = 1.2746961887000874d-1*t49+1.0d+0
            t51 = 2.4141993114533214d-2*t42+1.0186556948d-1
            t52 = 7.876233178997433d-1*t42*t51+2.2308199064d-1
            t53 = 7.876233178997433d-1*t42*t52+4.7231125998d-1
            t54 = 1/t53
            t55 = 1.269642451250142d+0*t41*t54+1.0d+0
            t56 = log(t55)
            t57 = 1.325688999052018d-1*t49+1.0d+0
            t58 = 1.3212998810398843d-2*t42+2.9729725188d-2
            t59 = 7.876233178997433d-1*t42*t58+1.2236585478d-1
            t60 = 7.876233178997433d-1*t42*t59+3.497952466d-1
            t61 = 1/t60
            t62 = 1.269642451250142d+0*t41*t61+1.0d+0
            t63 = log(t62)
            t64 = 6.901399211255826d-2*t49+1.0d+0
            t65 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t56*t57-3.10907d-2*t48*t50)-3.37738d-2*t63*t64)+
     2         3.37738d-2*t63*t64)-6.21814d-2*t56*t57
            t66 = rhob+rhoa
            t67 = t66**3.333333333333333d-1
            t68 = 1/t67
            t69 = 1.325688999052018d-1*t68+1.0d+0
            t70 = t67**5.0d-1
            t71 = 1/t70
            t72 = 2.4141993114533214d-2*t71+1.0186556948d-1
            t73 = 7.876233178997433d-1*t71*t72+2.2308199064d-1
            t74 = 7.876233178997433d-1*t71*t73+4.7231125998d-1
            t75 = 1/t74
            t76 = 1.269642451250142d+0*t70*t75+1.0d+0
            t77 = log(t76)
            t78 = rhoa-rhob
            t79 = 1/t66
            t80 = 1.0d+0-t78*t79
            t81 = t80**1.3333333333333333d+0
            t82 = t78*t79+1.0d+0
            t83 = t82**1.3333333333333333d+0
            t84 = 1.923661050931536d+0*t83+1.923661050931536d+0*t81-3.84
     1         7322101863072d+0
            t85 = 6.901399211255826d-2*t68+1.0d+0
            t86 = 1.3212998810398843d-2*t71+2.9729725188d-2
            t87 = 7.876233178997433d-1*t71*t86+1.2236585478d-1
            t88 = 7.876233178997433d-1*t71*t87+3.497952466d-1
            t89 = 1/t88
            t90 = 1.269642451250142d+0*t70*t89+1.0d+0
            t91 = log(t90)
            t92 = t78**4
            t93 = 1/t66**4
            t94 = 1.2746961887000874d-1*t68+1.0d+0
            t95 = 1.530901310039024d-2*t71+1.0465751434d-1
            t96 = 7.876233178997433d-1*t71*t95+1.9269083139d-1
            t97 = 7.876233178997433d-1*t71*t96+4.3896648423d-1
            t98 = 1/t97
            t99 = 1.269642451250142d+0*t70*t98+1.0d+0
            t100 = log(t99)
            t101 = 1.709920934161365d+0*(6.21814d-2*t69*t77-3.10907d-2*t
     1         100*t94)-3.37738d-2*t85*t91
            t102 = t101*t92*t93+3.37738d-2*t85*t91
            t103 = 5.848223622634648d-1*t102*t84-6.21814d-2*t69*t77
            t104 = rhob**1.1666666666666667d+0
            t105 = 1/t104**2.0d+0
            t106 = exp(-8.085523023512745d+1*t65)
            t107 = t106-1.0d+0
            t108 = 1/t107
            t109 = 2.7178044217479813d-1*gammabb*t105*t108
            t110 = t109+1.0d+0
            t111 = (gammabb*t105)**2.0d+0
            t112 = 1/t107**2.0d+0
            t113 = 7.38646087487288d-2*t111*t112+t109+1.0d+0
            t114 = 1/t113
            t115 = 2.7178044217479813d-1*gammabb*t105*t110*t114+1.0d+0
            t116 = log(t115)
            t117 = t80**6.666666666666666d-1
            t118 = t82**6.666666666666666d-1
            t119 = 5.0d-1*t118+5.0d-1*t117
            t120 = t119**3.0d+0
            t121 = gammabb+2.0d+0*gammaab+gammaaa
            t122 = t66**1.1666666666666667d+0
            t123 = 1/t122**2.0d+0
            t124 = t119**2.0d+0
            t125 = 1/t124
            t126 = 1/t120
            t127 = exp(-4.042761511756372d+1*t103*t126)
            t128 = t127-1.0d+0
            t129 = 1/t128
            t130 = 1.7121095002288222d-1*t121*t123*t125*t129
            t131 = t130+1.0d+0
            t132 = 1/t119**4.0d+0
            t133 = (t121*t123)**2.0d+0
            t134 = 1/t128**2.0d+0
            t135 = 2.931318940773787d-2*t132*t133*t134+t130+1.0d+0
            t136 = 1/t135
            t137 = 1.7121095002288222d-1*t121*t123*t125*t131*t136+1.0d+0
            t138 = log(t137)
            t139 = 1/rhoa**1.3333333333333333d+0
            t140 = 1/t8
            t141 = 1/t6**2
            t142 = 1/rhoa**1.3333333333333336d+0
            t143 = 1/t2**3
            t144 = 1/rhoa**6.666666666666667d-1
            t145 = -1.3127055298329054d-1*t143*t144*t4-2.009622615316665
     1         8d-3*t142
            t146 = 7.876233178997433d-1*t145*t3-1.3127055298329054d-1*t1
     1         43*t144*t5
            t147 = 2.11607075208357d-1*t144*t3*t7-1.269642451250142d+0*t
     1         141*t146*t2
            t148 = 1/t16
            t149 = 1/t14**2
            t150 = -1.3127055298329054d-1*t12*t143*t144-3.16913278626356
     1         7d-3*t142
            t151 = 7.876233178997433d-1*t150*t3-1.3127055298329054d-1*t1
     1         3*t143*t144
            t152 = 2.11607075208357d-1*t144*t15*t3-1.269642451250142d+0*
     1         t149*t151*t2
            t153 = 1/t23
            t154 = 1/t21**2
            t155 = -1.3127055298329054d-1*t143*t144*t19-1.73447766040861
     1         62d-3*t142
            t156 = 7.876233178997433d-1*t155*t3-1.3127055298329054d-1*t1
     1         43*t144*t20
            t157 = 2.11607075208357d-1*t144*t22*t3-1.269642451250142d+0*
     1         t154*t156*t2
            t158 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(1
     1         .3210398931339265d-3*t139*t9+6.21814d-2*t148*t152*t18-2.7
     2         47773264188438d-3*t139*t17-3.10907d-2*t11*t140*t147)-3.37
     3         738d-2*t153*t157*t25+7.769549222703733d-4*t139*t24)+3.377
     4         38d-2*t153*t157*t25-7.769549222703733d-4*t139*t24)-6.2181
     5         4d-2*t148*t152*t18+2.747773264188438d-3*t139*t17
            t159 = 1/t38
            t160 = rhoa**1.6666666666666674d-1
            t161 = 1/t27**3.0d+0
            t162 = -6.34154365074529d-1*gammaaa*t160*t161*t31
            t163 = 1/t30**2
            t164 = 2.1974870225448048d+1*gammaaa*t158*t163*t28*t29
            t165 = t164+t162
            t166 = 1/t36**2
            t167 = gammaaa**2
            t168 = 1/t27**5.0d+0
            t169 = 1/t30**3.0d+0
            t170 = -3.4470150749406775d-1*t160*t167*t168*t35+1.194467989
     1         3212153d+1*t158*t169*t29*t34+t164+t162
            t171 = -6.34154365074529d-1*gammaaa*t160*t161*t33*t37+2.7178
     1         044217479813d-1*gammaaa*t165*t28*t37-2.7178044217479813d-
     2         1*gammaaa*t166*t170*t28*t33
            t172 = 1/t66**1.3333333333333336d+0
            t173 = 1/t66**6.666666666666667d-1
            t174 = 1/t70**3
            t175 = -1.3127055298329054d-1*t173*t174*t72-3.16913278626356
     1         7d-3*t172
            t176 = 7.876233178997433d-1*t175*t71-1.3127055298329054d-1*t
     1         173*t174*t73
            t177 = 1/t74**2
            t178 = 2.11607075208357d-1*t173*t71*t75-1.269642451250142d+0
     1         *t176*t177*t70
            t179 = 1/t76
            t180 = -6.21814d-2*t178*t179*t69
            t181 = 1/t66**1.3333333333333333d+0
            t182 = 2.747773264188438d-3*t181*t77
            t183 = -1.3127055298329054d-1*t173*t174*t86-1.73447766040861
     1         62d-3*t172
            t184 = 7.876233178997433d-1*t183*t71-1.3127055298329054d-1*t
     1         173*t174*t87
            t185 = 1/t88**2
            t186 = 2.11607075208357d-1*t173*t71*t89-1.269642451250142d+0
     1         *t184*t185*t70
            t187 = 1/t90
            t188 = 3.37738d-2*t186*t187*t85
            t189 = -7.769549222703733d-4*t181*t91
            t190 = -1.3127055298329054d-1*t173*t174*t95-2.00962261531666
     1         58d-3*t172
            t191 = 7.876233178997433d-1*t190*t71-1.3127055298329054d-1*t
     1         173*t174*t96
            t192 = 1/t97**2
            t193 = 2.11607075208357d-1*t173*t71*t98-1.269642451250142d+0
     1         *t191*t192*t70
            t194 = 1/t99
            t195 = 1.709920934161365d+0*(-3.10907d-2*t193*t194*t94-2.747
     1         773264188438d-3*t181*t77+6.21814d-2*t178*t179*t69+1.32103
     2         98931339265d-3*t100*t181)+7.769549222703733d-4*t181*t91-3
     3         .37738d-2*t186*t187*t85
            t196 = t195*t92*t93
            t197 = 1/t66**5
            t198 = -4*t101*t197*t92
            t199 = t78**3
            t200 = 4*t101*t199*t93+t198+t196+t189+t188
            t201 = 1/t66**2
            t202 = t201*t78
            t203 = -t79
            t204 = t203+t202
            t205 = t80**3.333333333333333d-1
            t206 = -t201*t78
            t207 = t79+t206
            t208 = t82**3.333333333333333d-1
            t209 = 2.564881401242048d+0*t207*t208+2.564881401242048d+0*t
     1         204*t205
            t210 = 5.848223622634648d-1*t200*t84+5.848223622634648d-1*t1
     1         02*t209+t182+t180
            t211 = 1.0d+0*t103
            t212 = 1/t137
            t213 = 1/t205
            t214 = 1/t208
            t215 = 3.333333333333333d-1*t207*t214+3.333333333333333d-1*t
     1         204*t213
            t216 = t66**1.6666666666666674d-1
            t217 = 1/t122**3.0d+0
            t218 = -3.994922167200585d-1*t121*t125*t131*t136*t216*t217
            t219 = -3.4242190004576445d-1*t121*t123*t126*t129*t215
            t220 = -3.994922167200585d-1*t121*t125*t129*t216*t217
            t221 = 1/t128**2
            t222 = 1.2128284535269115d+2*t103*t132*t215-4.04276151175637
     1         2d+1*t126*t210
            t223 = -1.7121095002288222d-1*t121*t123*t125*t127*t221*t222
            t224 = t223+t220+t219
            t225 = 1/t135**2
            t226 = t121**2
            t227 = 1/t122**5.0d+0
            t228 = -1.3679488390277675d-1*t132*t134*t216*t226*t227
            t229 = 1/t119**5.0d+0
            t230 = 1/t128**3.0d+0
            t231 = -5.862637881547574d-2*t127*t132*t133*t222*t230-1.1725
     1         27576309515d-1*t133*t134*t215*t229+t228+t223+t220+t219
            t232 = -1.7121095002288222d-1*t121*t123*t125*t131*t225*t231+
     1         1.7121095002288222d-1*t121*t123*t125*t136*t224+t218-3.424
     2         2190004576445d-1*t121*t123*t126*t131*t136*t215
            t233 = 2.473556743557577d-2*t120*t138
            t234 = 1/rhob**1.3333333333333333d+0
            t235 = 1/t47
            t236 = 1/t45**2
            t237 = 1/rhob**1.3333333333333336d+0
            t238 = 1/t41**3
            t239 = 1/rhob**6.666666666666667d-1
            t240 = -1.3127055298329054d-1*t238*t239*t43-2.00962261531666
     1         58d-3*t237
            t241 = 7.876233178997433d-1*t240*t42-1.3127055298329054d-1*t
     1         238*t239*t44
            t242 = 2.11607075208357d-1*t239*t42*t46-1.269642451250142d+0
     1         *t236*t241*t41
            t243 = 1/t55
            t244 = 1/t53**2
            t245 = -1.3127055298329054d-1*t238*t239*t51-3.16913278626356
     1         7d-3*t237
            t246 = 7.876233178997433d-1*t245*t42-1.3127055298329054d-1*t
     1         238*t239*t52
            t247 = 2.11607075208357d-1*t239*t42*t54-1.269642451250142d+0
     1         *t244*t246*t41
            t248 = 1/t62
            t249 = 1/t60**2
            t250 = -1.3127055298329054d-1*t238*t239*t58-1.73447766040861
     1         62d-3*t237
            t251 = 7.876233178997433d-1*t250*t42-1.3127055298329054d-1*t
     1         238*t239*t59
            t252 = 2.11607075208357d-1*t239*t42*t61-1.269642451250142d+0
     1         *t249*t251*t41
            t253 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t248*t252*t
     1         64+7.769549222703733d-4*t234*t63+1.709920934161365d+0*(6.
     2         21814d-2*t243*t247*t57-2.747773264188438d-3*t234*t56-3.10
     3         907d-2*t235*t242*t50+1.3210398931339265d-3*t234*t48))+3.3
     4         7738d-2*t248*t252*t64-7.769549222703733d-4*t234*t63)-6.21
     5         814d-2*t243*t247*t57+2.747773264188438d-3*t234*t56
            t254 = 1/t115
            t255 = rhob**1.6666666666666674d-1
            t256 = 1/t104**3.0d+0
            t257 = -6.34154365074529d-1*gammabb*t108*t255*t256
            t258 = 1/t107**2
            t259 = 2.1974870225448048d+1*gammabb*t105*t106*t253*t258
            t260 = t259+t257
            t261 = 1/t113**2
            t262 = gammabb**2
            t263 = 1/t104**5.0d+0
            t264 = 1/t107**3.0d+0
            t265 = 1.1944679893212153d+1*t106*t111*t253*t264-3.447015074
     1         9406775d-1*t112*t255*t262*t263+t259+t257
            t266 = -2.7178044217479813d-1*gammabb*t105*t110*t261*t265+2.
     1         7178044217479813d-1*gammabb*t105*t114*t260-6.341543650745
     2         29d-1*gammabb*t110*t114*t255*t256
            t267 = -4*t101*t199*t93+t198+t196+t189+t188
            t268 = t79+t202
            t269 = t206+t203
            t270 = 2.564881401242048d+0*t208*t269+2.564881401242048d+0*t
     1         205*t268
            t271 = 5.848223622634648d-1*t267*t84+5.848223622634648d-1*t1
     1         02*t270+t182+t180
            t272 = 3.333333333333333d-1*t214*t269+3.333333333333333d-1*t
     1         213*t268
            t273 = -3.4242190004576445d-1*t121*t123*t126*t129*t272
            t274 = 1.2128284535269115d+2*t103*t132*t272-4.04276151175637
     1         2d+1*t126*t271
            t275 = -1.7121095002288222d-1*t121*t123*t125*t127*t221*t274
            t276 = t275+t273+t220
            t277 = t275-5.862637881547574d-2*t127*t132*t133*t230*t274+t2
     1         73-1.172527576309515d-1*t133*t134*t229*t272+t228+t220
            t278 = -1.7121095002288222d-1*t121*t123*t125*t131*t225*t277+
     1         1.7121095002288222d-1*t121*t123*t125*t136*t276-3.42421900
     2         04576445d-1*t121*t123*t126*t131*t136*t272+t218
            t279 = 1/t27**4.0d+0
            t280 = 1.477292174974576d-1*gammaaa*t279*t35+2.7178044217479
     1         813d-1*t28*t31
            t281 = 2.7178044217479813d-1*t28*t33*t37+7.386460874872879d-
     1         2*gammaaa*t279*t31*t37-2.7178044217479813d-1*gammaaa*t166
     2         *t28*t280*t33
            t282 = 1/t122**4.0d+0
            t283 = 5.862637881547574d-2*t121*t132*t134*t282+1.7121095002
     1         288222d-1*t123*t125*t129
            t284 = -1.7121095002288222d-1*t121*t123*t125*t131*t225*t283+
     1         2.931318940773787d-2*t121*t129*t132*t136*t282+1.712109500
     2         2288222d-1*t123*t125*t131*t136
            t285 = 2.473556743557577d-2*t120*t212*t284*t66
            t286 = 1.172527576309515d-1*t121*t132*t134*t282+3.4242190004
     1         576445d-1*t123*t125*t129
            t287 = -1.7121095002288222d-1*t121*t123*t125*t131*t225*t286+
     1         5.862637881547574d-2*t121*t129*t132*t136*t282+3.424219000
     2         4576445d-1*t123*t125*t131*t136
            t288 = 1/t104**4.0d+0
            t289 = 1.477292174974576d-1*gammabb*t112*t288+2.717804421747
     1         9813d-1*t105*t108
            t290 = -2.7178044217479813d-1*gammabb*t105*t110*t261*t289+7.
     1         386460874872879d-2*gammabb*t108*t114*t288+2.7178044217479
     2         813d-1*t105*t110*t114
            t291 = 1/rhoa**2.333333333333333d+0
            t292 = 1/t8**2
            t293 = t147**2
            t294 = 1/t6**3
            t295 = t146**2
            t296 = 1/rhoa**2.3333333333333334d+0
            t297 = 1/rhoa**1.6666666666666669d+0
            t298 = 1/t2**5
            t299 = 6.563527649164527d-2*t142*t298*t4+8.751370198886037d-
     1         2*t143*t297*t4+3.0144339229749983d-3*t296
            t300 = 6.563527649164527d-2*t142*t298*t5+8.751370198886037d-
     1         2*t143*t297*t5+7.876233178997433d-1*t299*t3-2.62541105966
     2         5811d-1*t143*t144*t145
            t301 = -1.4107138347223802d-1*t297*t3*t7-3.52678458680595d-2
     1         *t142*t143*t7-1.269642451250142d+0*t141*t2*t300-4.2321415
     2         0416714d-1*t141*t144*t146*t3+2.539284902500284d+0*t2*t294
     3         *t295
            t302 = 1/t16**2
            t303 = t152**2
            t304 = 1/t14**3
            t305 = t151**2
            t306 = 6.563527649164527d-2*t12*t142*t298+8.751370198886037d
     1         -2*t12*t143*t297+4.753699179395351d-3*t296
            t307 = 7.876233178997433d-1*t3*t306+6.563527649164527d-2*t13
     1         *t142*t298+8.751370198886037d-2*t13*t143*t297-2.625411059
     2         665811d-1*t143*t144*t150
            t308 = -1.269642451250142d+0*t149*t2*t307+2.539284902500284d
     1         +0*t2*t304*t305-1.4107138347223802d-1*t15*t297*t3-4.23214
     2         150416714d-1*t144*t149*t151*t3-3.52678458680595d-2*t142*t
     3         143*t15
            t309 = 1/t23**2
            t310 = t157**2
            t311 = 1/t21**3
            t312 = t156**2
            t313 = 6.563527649164527d-2*t142*t19*t298+8.751370198886037d
     1         -2*t143*t19*t297+2.601716490612924d-3*t296
            t314 = 7.876233178997433d-1*t3*t313+6.563527649164527d-2*t14
     1         2*t20*t298+8.751370198886037d-2*t143*t20*t297-2.625411059
     2         665811d-1*t143*t144*t155
            t315 = -1.269642451250142d+0*t154*t2*t314+2.539284902500284d
     1         +0*t2*t311*t312-1.4107138347223802d-1*t22*t297*t3-4.23214
     2         150416714d-1*t144*t154*t156*t3-3.52678458680595d-2*t142*t
     3         143*t22
            t316 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(-
     1         1.7613865241785687d-3*t291*t9+6.21814d-2*t148*t18*t308-6.
     2         21814d-2*t18*t302*t303-3.10907d-2*t11*t140*t301+3.10907d-
     3         2*t11*t292*t293+3.663697685584584d-3*t17*t291-5.495546528
     4         376876d-3*t139*t148*t152+2.642079786267853d-3*t139*t140*t
     5         147)-3.37738d-2*t153*t25*t315+3.37738d-2*t25*t309*t310-1.
     6         0359398963604977d-3*t24*t291+1.5539098445407465d-3*t139*t
     7         153*t157)+3.37738d-2*t153*t25*t315-3.37738d-2*t25*t309*t3
     8         10+1.0359398963604977d-3*t24*t291-1.5539098445407465d-3*t
     9         139*t153*t157)-6.21814d-2*t148*t18*t308+6.21814d-2*t18*t3
     :         02*t303-3.663697685584584d-3*t17*t291+5.495546528376876d-
     ;         3*t139*t148*t152
            t317 = rhoa**3.333333333333335d-1
            t318 = 1/rhoa**8.333333333333333d-1
            t319 = t158**2
            t320 = exp(-1.617104604702549d+2*t26)
            t321 = 1/t30**3
            t322 = 3.553566382931298d+3*gammaaa*t28*t319*t320*t321
            t323 = 2.2195402777608514d+0*gammaaa*t279*t31*t317
            t324 = -1.0569239417908823d-1*gammaaa*t161*t31*t318
            t325 = -1.0254939438542422d+2*gammaaa*t158*t160*t161*t163*t2
     1         9
            t326 = -1.776783191465649d+3*gammaaa*t163*t28*t29*t319
            t327 = 2.1974870225448048d+1*gammaaa*t163*t28*t29*t316
            t328 = t327+t326+t325+t324+t323+t322
            t329 = 1/t30**4.0d+0
            t330 = 1/t27**6.0d+0
            t331 = 2.0107587937153953d+0*t167*t317*t330*t35-5.7450251249
     1         01132d-2*t167*t168*t318*t35+2.897369528551698d+3*t319*t32
     2         0*t329*t34-9.657898428505661d+2*t169*t29*t319*t34+1.19446
     3         79893212153d+1*t169*t29*t316*t34+t327+t326+t325+t324+t323
     4         +t322-1.1148367900331342d+2*t158*t160*t167*t168*t169*t29
            t332 = 1/t36**3
            t333 = t170**2
            t334 = -1.0569239417908823d-1*gammaaa*t161*t318*t33*t37+2.21
     1         95402777608514d+0*gammaaa*t279*t317*t33*t37+2.71780442174
     2         79813d-1*gammaaa*t28*t328*t37-1.268308730149058d+0*gammaa
     3         a*t160*t161*t165*t37+5.435608843495963d-1*gammaaa*t28*t33
     4         *t332*t333-2.7178044217479813d-1*gammaaa*t166*t28*t33*t33
     5         1+1.268308730149058d+0*gammaaa*t160*t161*t166*t170*t33-5.
     6         435608843495963d-1*gammaaa*t165*t166*t170*t28
            t335 = -1.2367783717787881d-2*rhoa*t334-2.4735567435575762d-
     1         2*t171
            t336 = 1/t38**2
            t337 = t171**2
            t338 = t178**2
            t339 = 1/t76**2
            t340 = 6.21814d-2*t338*t339*t69
            t341 = t176**2
            t342 = 1/t74**3
            t343 = 1/t66**2.3333333333333334d+0
            t344 = 1/t70**5
            t345 = 1/t66**1.6666666666666669d+0
            t346 = 8.751370198886037d-2*t174*t345*t72+6.563527649164527d
     1         -2*t172*t344*t72+4.753699179395351d-3*t343
            t347 = 8.751370198886037d-2*t174*t345*t73+6.563527649164527d
     1         -2*t172*t344*t73+7.876233178997433d-1*t346*t71-2.62541105
     2         9665811d-1*t173*t174*t175
            t348 = -1.4107138347223802d-1*t345*t71*t75-3.52678458680595d
     1         -2*t172*t174*t75-4.23214150416714d-1*t173*t176*t177*t71-1
     2         .269642451250142d+0*t177*t347*t70+2.539284902500284d+0*t3
     3         41*t342*t70
            t349 = -6.21814d-2*t179*t348*t69
            t350 = 5.495546528376876d-3*t178*t179*t181
            t351 = 1/t66**2.333333333333333d+0
            t352 = -3.663697685584584d-3*t351*t77
            t353 = t186**2
            t354 = 1/t90**2
            t355 = -3.37738d-2*t353*t354*t85
            t356 = t184**2
            t357 = 1/t88**3
            t358 = 8.751370198886037d-2*t174*t345*t86+6.563527649164527d
     1         -2*t172*t344*t86+2.601716490612924d-3*t343
            t359 = 8.751370198886037d-2*t174*t345*t87+6.563527649164527d
     1         -2*t172*t344*t87+7.876233178997433d-1*t358*t71-2.62541105
     2         9665811d-1*t173*t174*t183
            t360 = -1.4107138347223802d-1*t345*t71*t89-3.52678458680595d
     1         -2*t172*t174*t89-4.23214150416714d-1*t173*t184*t185*t71-1
     2         .269642451250142d+0*t185*t359*t70+2.539284902500284d+0*t3
     3         56*t357*t70
            t361 = 3.37738d-2*t187*t360*t85
            t362 = -1.5539098445407465d-3*t181*t186*t187
            t363 = 1.0359398963604977d-3*t351*t91
            t364 = t193**2
            t365 = 1/t99**2
            t366 = t191**2
            t367 = 1/t97**3
            t368 = 8.751370198886037d-2*t174*t345*t95+6.563527649164527d
     1         -2*t172*t344*t95+3.0144339229749983d-3*t343
            t369 = 8.751370198886037d-2*t174*t345*t96+6.563527649164527d
     1         -2*t172*t344*t96+7.876233178997433d-1*t368*t71-2.62541105
     2         9665811d-1*t173*t174*t190
            t370 = -1.4107138347223802d-1*t345*t71*t98-3.52678458680595d
     1         -2*t172*t174*t98-4.23214150416714d-1*t173*t191*t192*t71-1
     2         .269642451250142d+0*t192*t369*t70+2.539284902500284d+0*t3
     3         66*t367*t70
            t371 = 1.709920934161365d+0*(-3.10907d-2*t194*t370*t94+3.109
     1         07d-2*t364*t365*t94+3.663697685584584d-3*t351*t77+6.21814
     2         d-2*t179*t348*t69-6.21814d-2*t338*t339*t69-1.761386524178
     3         5687d-3*t100*t351+2.642079786267853d-3*t181*t193*t194-5.4
     4         95546528376876d-3*t178*t179*t181)-1.0359398963604977d-3*t
     5         351*t91-3.37738d-2*t187*t360*t85+3.37738d-2*t353*t354*t85
     6         +1.5539098445407465d-3*t181*t186*t187
            t372 = t371*t92*t93
            t373 = -8*t195*t197*t92
            t374 = 1/t66**6
            t375 = 20*t101*t374*t92
            t376 = t78**2
            t377 = 12*t101*t376*t93
            t378 = 8*t195*t199*t93+t377+t375+t373+t372+t363+t362+t361+t3
     1         55-32*t101*t197*t199
            t379 = t204**2
            t380 = 1/t117
            t381 = 1/t66**3
            t382 = -2*t381*t78
            t383 = 2*t201
            t384 = t383+t382
            t385 = t207**2
            t386 = 1/t118
            t387 = 2*t381*t78
            t388 = -2*t201
            t389 = t388+t387
            t390 = 2.564881401242048d+0*t208*t389+8.549604670806825d-1*t
     1         385*t386+2.564881401242048d+0*t205*t384+8.549604670806825
     2         d-1*t379*t380
            t391 = 5.848223622634648d-1*t378*t84+5.848223622634648d-1*t1
     1         02*t390+t352+t350+t349+t340+1.1696447245269297d+0*t200*t2
     2         09
            t392 = t215**2
            t393 = 1/t81
            t394 = 1/t83
            t395 = -1.111111111111111d-1*t385*t394-1.111111111111111d-1*
     1         t379*t393+3.333333333333333d-1*t214*t389+3.33333333333333
     2         3d-1*t213*t384
            t396 = t66**3.333333333333335d-1
            t397 = 1.398222758520205d+0*t121*t125*t131*t136*t282*t396
            t398 = 1/t66**8.333333333333333d-1
            t399 = -6.658203612000978d-2*t121*t125*t131*t136*t217*t398
            t400 = 1.0272657001372934d+0*t121*t123*t129*t132*t392
            t401 = -3.4242190004576445d-1*t121*t123*t126*t129*t395
            t402 = 1.5979688668802342d+0*t121*t126*t129*t215*t216*t217
            t403 = 1.398222758520205d+0*t121*t125*t129*t282*t396
            t404 = -6.658203612000978d-2*t121*t125*t129*t217*t398
            t405 = 1.2128284535269115d+2*t103*t132*t395-4.85131381410764
     1         6d+2*t103*t229*t392-4.042761511756372d+1*t126*t391+2.4256
     2         56907053823d+2*t132*t210*t215
            t406 = -1.7121095002288222d-1*t121*t123*t125*t127*t221*t405
            t407 = 6.848438000915289d-1*t121*t123*t126*t127*t215*t221*t2
     1         22
            t408 = 7.98984433440117d-1*t121*t125*t127*t216*t217*t221*t22
     1         2
            t409 = exp(-8.085523023512744d+1*t103*t126)
            t410 = 1/t128**3
            t411 = t222**2
            t412 = 3.4242190004576445d-1*t121*t123*t125*t409*t410*t411
            t413 = -1.7121095002288222d-1*t121*t123*t125*t127*t221*t411
            t414 = t413+t412+t408+t407+t406+t404+t403+t402+t401+t400
            t415 = 1/t122**6.0d+0
            t416 = 7.979701560995311d-1*t132*t134*t226*t396*t415
            t417 = -2.2799147317129467d-2*t132*t134*t226*t227*t398
            t418 = 1/t119**6.0d+0
            t419 = 1/t128**4.0d+0
            t420 = 1.7587913644642725d-1*t132*t133*t409*t411*t419+5.8626
     1         37881547574d-1*t133*t134*t392*t418+t417+t416+t413+t412-5.
     2         862637881547574d-2*t127*t132*t133*t230*t411+t408+t407+t40
     3         6-5.862637881547574d-2*t127*t132*t133*t230*t405+t404+t403
     4         +t402+t401+t400-1.172527576309515d-1*t133*t134*t229*t395+
     5         4.69011030523806d-1*t127*t133*t215*t222*t229*t230+5.47179
     6         535611107d-1*t127*t132*t216*t222*t226*t227*t230+1.0943590
     7         71222214d+0*t134*t215*t216*t226*t227*t229
            t421 = 1/t135**3
            t422 = t231**2
            t423 = 3.4242190004576445d-1*t121*t123*t125*t131*t421*t422-1
     1         .7121095002288222d-1*t121*t123*t125*t131*t225*t420+1.7121
     2         095002288222d-1*t121*t123*t125*t136*t414+t399+t397-3.4242
     3         190004576445d-1*t121*t123*t126*t131*t136*t395+1.027265700
     4         1372934d+0*t121*t123*t131*t132*t136*t392-3.42421900045764
     5         45d-1*t121*t123*t125*t224*t225*t231+7.98984433440117d-1*t
     6         121*t125*t131*t216*t217*t225*t231+6.848438000915289d-1*t1
     7         21*t123*t126*t131*t215*t225*t231-7.98984433440117d-1*t121
     8         *t125*t136*t216*t217*t224-6.848438000915289d-1*t121*t123*
     9         t126*t136*t215*t224+1.5979688668802342d+0*t121*t126*t131*
     :         t136*t215*t216*t217
            t424 = 2.473556743557577d-2*t120*t423*t66+1.4841340461345462
     1         d-1*t124*t215*t232*t66+4.947113487115154d-2*t120*t232
            t425 = 1/t137**2
            t426 = t232**2
            t427 = -12*t101*t376*t93+t375+t373+t372+t363+t362+t361+t355
            t428 = 5.129762802484096d+0*t208*t381*t78-5.129762802484096d
     1         +0*t205*t381*t78+8.549604670806825d-1*t207*t269*t386+8.54
     2         9604670806825d-1*t204*t268*t380
            t429 = 5.848223622634648d-1*t427*t84+5.848223622634648d-1*t1
     1         02*t428+t352+t350+t349+t340+5.848223622634648d-1*t200*t27
     2         0+5.848223622634648d-1*t209*t267
            t430 = 6.666666666666666d-1*t214*t381*t78-6.666666666666666d
     1         -1*t213*t381*t78-1.111111111111111d-1*t207*t269*t394-1.11
     2         1111111111111d-1*t204*t268*t393
            t431 = 1.0272657001372934d+0*t121*t123*t129*t132*t215*t272
            t432 = -3.4242190004576445d-1*t121*t123*t126*t129*t430
            t433 = 7.98984433440117d-1*t121*t126*t129*t216*t217*t272
            t434 = 7.98984433440117d-1*t121*t126*t129*t215*t216*t217
            t435 = 1.2128284535269115d+2*t103*t132*t430-4.04276151175637
     1         2d+1*t126*t429-4.851313814107646d+2*t103*t215*t229*t272+1
     2         .2128284535269115d+2*t132*t210*t272+1.2128284535269115d+2
     3         *t132*t215*t271
            t436 = -1.7121095002288222d-1*t121*t123*t125*t127*t221*t435
            t437 = 3.4242190004576445d-1*t121*t123*t126*t127*t215*t221*t
     1         274
            t438 = 3.994922167200585d-1*t121*t125*t127*t216*t217*t221*t2
     1         74
            t439 = 3.4242190004576445d-1*t121*t123*t126*t127*t221*t222*t
     1         272
            t440 = 3.994922167200585d-1*t121*t125*t127*t216*t217*t221*t2
     1         22
            t441 = 3.4242190004576445d-1*t121*t123*t125*t222*t274*t409*t
     1         410
            t442 = -1.7121095002288222d-1*t121*t123*t125*t127*t221*t222*
     1         t274
            t443 = t442+t441+t440+t439+t438+t437+t436+t434+t433+t432+t43
     1         1+t404+t403
            t444 = t442+t441+t440+t439+t438+t437+t436-5.862637881547574d
     1         -2*t127*t132*t133*t230*t435+t434+t433+t432+t431-1.1725275
     2         76309515d-1*t133*t134*t229*t430+1.7587913644642725d-1*t13
     3         2*t133*t222*t274*t409*t419+5.862637881547574d-1*t133*t134
     4         *t215*t272*t418+t417+t416+t404+t403+2.34505515261903d-1*t
     5         127*t133*t215*t229*t230*t274+2.735897678055535d-1*t127*t1
     6         32*t216*t226*t227*t230*t274-5.862637881547574d-2*t127*t13
     7         2*t133*t222*t230*t274+2.34505515261903d-1*t127*t133*t222*
     8         t229*t230*t272+5.47179535611107d-1*t134*t216*t226*t227*t2
     9         29*t272+2.735897678055535d-1*t127*t132*t216*t222*t226*t22
     :         7*t230+5.47179535611107d-1*t134*t215*t216*t226*t227*t229
            t445 = -1.7121095002288222d-1*t121*t123*t125*t131*t225*t444+
     1         1.7121095002288222d-1*t121*t123*t125*t136*t443-3.42421900
     2         04576445d-1*t121*t123*t126*t131*t136*t430+3.4242190004576
     3         445d-1*t121*t123*t125*t131*t231*t277*t421+t399+t397-1.712
     4         1095002288222d-1*t121*t123*t125*t224*t225*t277+3.99492216
     5         7200585d-1*t121*t125*t131*t216*t217*t225*t277+3.424219000
     6         4576445d-1*t121*t123*t126*t131*t215*t225*t277-1.712109500
     7         2288222d-1*t121*t123*t125*t225*t231*t276-3.99492216720058
     8         5d-1*t121*t125*t136*t216*t217*t276-3.4242190004576445d-1*
     9         t121*t123*t126*t136*t215*t276+3.4242190004576445d-1*t121*
     :         t123*t126*t131*t225*t231*t272-3.4242190004576445d-1*t121*
     ;         t123*t126*t136*t224*t272+7.98984433440117d-1*t121*t126*t1
     <         31*t136*t216*t217*t272+1.0272657001372934d+0*t121*t123*t1
     =         31*t132*t136*t215*t272+3.994922167200585d-1*t121*t125*t13
     >         1*t216*t217*t225*t231-3.994922167200585d-1*t121*t125*t136
     ?         *t216*t217*t224+7.98984433440117d-1*t121*t126*t131*t136*t
     @         215*t216*t217
            t446 = 2.473556743557577d-2*t120*t445*t66+7.420670230672731d
     1         -2*t124*t215*t278*t66+7.420670230672731d-2*t124*t232*t272
     2         *t66+2.473556743557577d-2*t120*t278+2.473556743557577d-2*
     3         t120*t232
            t447 = 1/rhob**2.333333333333333d+0
            t448 = 1/t47**2
            t449 = t242**2
            t450 = 1/t45**3
            t451 = t241**2
            t452 = 1/rhob**2.3333333333333334d+0
            t453 = 1/rhob**1.6666666666666669d+0
            t454 = 1/t41**5
            t455 = 6.563527649164527d-2*t237*t43*t454+8.751370198886037d
     1         -2*t238*t43*t453+3.0144339229749983d-3*t452
            t456 = 7.876233178997433d-1*t42*t455+6.563527649164527d-2*t2
     1         37*t44*t454+8.751370198886037d-2*t238*t44*t453-2.62541105
     2         9665811d-1*t238*t239*t240
            t457 = -1.4107138347223802d-1*t42*t453*t46-3.52678458680595d
     1         -2*t237*t238*t46-1.269642451250142d+0*t236*t41*t456+2.539
     2         284902500284d+0*t41*t450*t451-4.23214150416714d-1*t236*t2
     3         39*t241*t42
            t458 = 1/t55**2
            t459 = t247**2
            t460 = 1/t53**3
            t461 = t246**2
            t462 = 6.563527649164527d-2*t237*t454*t51+8.751370198886037d
     1         -2*t238*t453*t51+4.753699179395351d-3*t452
            t463 = 6.563527649164527d-2*t237*t454*t52+8.751370198886037d
     1         -2*t238*t453*t52+7.876233178997433d-1*t42*t462-2.62541105
     2         9665811d-1*t238*t239*t245
            t464 = -1.4107138347223802d-1*t42*t453*t54-3.52678458680595d
     1         -2*t237*t238*t54-1.269642451250142d+0*t244*t41*t463+2.539
     2         284902500284d+0*t41*t460*t461-4.23214150416714d-1*t239*t2
     3         44*t246*t42
            t465 = 1/t62**2
            t466 = t252**2
            t467 = 1/t60**3
            t468 = t251**2
            t469 = 6.563527649164527d-2*t237*t454*t58+8.751370198886037d
     1         -2*t238*t453*t58+2.601716490612924d-3*t452
            t470 = 6.563527649164527d-2*t237*t454*t59+8.751370198886037d
     1         -2*t238*t453*t59+7.876233178997433d-1*t42*t469-2.62541105
     2         9665811d-1*t238*t239*t250
            t471 = -1.4107138347223802d-1*t42*t453*t61-3.52678458680595d
     1         -2*t237*t238*t61-1.269642451250142d+0*t249*t41*t470+2.539
     2         284902500284d+0*t41*t467*t468-4.23214150416714d-1*t239*t2
     3         49*t251*t42
            t472 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t248*t471*t
     1         64+3.37738d-2*t465*t466*t64-1.0359398963604977d-3*t447*t6
     2         3+1.709920934161365d+0*(6.21814d-2*t243*t464*t57-6.21814d
     3         -2*t458*t459*t57+3.663697685584584d-3*t447*t56-3.10907d-2
     4         *t235*t457*t50+3.10907d-2*t448*t449*t50-1.761386524178568
     5         7d-3*t447*t48-5.495546528376876d-3*t234*t243*t247+2.64207
     6         9786267853d-3*t234*t235*t242)+1.5539098445407465d-3*t234*
     7         t248*t252)+3.37738d-2*t248*t471*t64-3.37738d-2*t465*t466*
     8         t64+1.0359398963604977d-3*t447*t63-1.5539098445407465d-3*
     9         t234*t248*t252)-6.21814d-2*t243*t464*t57+6.21814d-2*t458*
     :         t459*t57-3.663697685584584d-3*t447*t56+5.495546528376876d
     ;         -3*t234*t243*t247
            t473 = rhob**3.333333333333335d-1
            t474 = 1/rhob**8.333333333333333d-1
            t475 = t253**2
            t476 = exp(-1.617104604702549d+2*t65)
            t477 = 1/t107**3
            t478 = 3.553566382931298d+3*gammabb*t105*t475*t476*t477
            t479 = 2.2195402777608514d+0*gammabb*t108*t288*t473
            t480 = -1.0569239417908823d-1*gammabb*t108*t256*t474
            t481 = -1.0254939438542422d+2*gammabb*t106*t253*t255*t256*t2
     1         58
            t482 = -1.776783191465649d+3*gammabb*t105*t106*t258*t475
            t483 = 2.1974870225448048d+1*gammabb*t105*t106*t258*t472
            t484 = t483+t482+t481+t480+t479+t478
            t485 = 1/t107**4.0d+0
            t486 = 1/t104**6.0d+0
            t487 = 2.0107587937153953d+0*t112*t262*t473*t486+2.897369528
     1         551698d+3*t111*t475*t476*t485+t483+t482+t481+t480+t479+t4
     2         78-9.657898428505661d+2*t106*t111*t264*t475-5.74502512490
     3         1132d-2*t112*t262*t263*t474+1.1944679893212153d+1*t106*t1
     4         11*t264*t472-1.1148367900331342d+2*t106*t253*t255*t262*t2
     5         63*t264
            t488 = 1/t113**3
            t489 = t265**2
            t490 = 5.435608843495963d-1*gammabb*t105*t110*t488*t489-2.71
     1         78044217479813d-1*gammabb*t105*t110*t261*t487+2.717804421
     2         7479813d-1*gammabb*t105*t114*t484-1.0569239417908823d-1*g
     3         ammabb*t110*t114*t256*t474+2.2195402777608514d+0*gammabb*
     4         t110*t114*t288*t473-5.435608843495963d-1*gammabb*t105*t26
     5         0*t261*t265+1.268308730149058d+0*gammabb*t110*t255*t256*t
     6         261*t265-1.268308730149058d+0*gammabb*t114*t255*t256*t260
            t491 = -1.2367783717787881d-2*rhob*t490-2.4735567435575762d-
     1         2*t266
            t492 = 1/t115**2
            t493 = t266**2
            t494 = -8*t195*t199*t93+t377+t375+t373+t372+t363+t362+t361+t
     1         355+32*t101*t197*t199
            t495 = t268**2
            t496 = t388+t382
            t497 = t269**2
            t498 = t387+t383
            t499 = 2.564881401242048d+0*t208*t498+8.549604670806825d-1*t
     1         386*t497+2.564881401242048d+0*t205*t496+8.549604670806825
     2         d-1*t380*t495
            t500 = 5.848223622634648d-1*t494*t84+5.848223622634648d-1*t1
     1         02*t499+t352+t350+t349+t340+1.1696447245269297d+0*t267*t2
     2         70
            t501 = t272**2
            t502 = 3.333333333333333d-1*t214*t498-1.111111111111111d-1*t
     1         394*t497+3.333333333333333d-1*t213*t496-1.111111111111111
     2         d-1*t393*t495
            t503 = 1.0272657001372934d+0*t121*t123*t129*t132*t501
            t504 = -3.4242190004576445d-1*t121*t123*t126*t129*t502
            t505 = 1.5979688668802342d+0*t121*t126*t129*t216*t217*t272
            t506 = 1.2128284535269115d+2*t103*t132*t502-4.85131381410764
     1         6d+2*t103*t229*t501-4.042761511756372d+1*t126*t500+2.4256
     2         56907053823d+2*t132*t271*t272
            t507 = -1.7121095002288222d-1*t121*t123*t125*t127*t221*t506
            t508 = 6.848438000915289d-1*t121*t123*t126*t127*t221*t272*t2
     1         74
            t509 = 7.98984433440117d-1*t121*t125*t127*t216*t217*t221*t27
     1         4
            t510 = t274**2
            t511 = 3.4242190004576445d-1*t121*t123*t125*t409*t410*t510
            t512 = -1.7121095002288222d-1*t121*t123*t125*t127*t221*t510
            t513 = t512+t511+t509+t508+t507+t505+t504+t503+t404+t403
            t514 = t512+t511+1.7587913644642725d-1*t132*t133*t409*t419*t
     1         510-5.862637881547574d-2*t127*t132*t133*t230*t510+t509+t5
     2         08+t507-5.862637881547574d-2*t127*t132*t133*t230*t506+t50
     3         5+t504+t503-1.172527576309515d-1*t133*t134*t229*t502+5.86
     4         2637881547574d-1*t133*t134*t418*t501+t417+t416+t404+t403+
     5         4.69011030523806d-1*t127*t133*t229*t230*t272*t274+5.47179
     6         535611107d-1*t127*t132*t216*t226*t227*t230*t274+1.0943590
     7         71222214d+0*t134*t216*t226*t227*t229*t272
            t515 = t277**2
            t516 = 3.4242190004576445d-1*t121*t123*t125*t131*t421*t515-1
     1         .7121095002288222d-1*t121*t123*t125*t131*t225*t514+1.7121
     2         095002288222d-1*t121*t123*t125*t136*t513-3.42421900045764
     3         45d-1*t121*t123*t126*t131*t136*t502+1.0272657001372934d+0
     4         *t121*t123*t131*t132*t136*t501+t399+t397-3.42421900045764
     5         45d-1*t121*t123*t125*t225*t276*t277+6.848438000915289d-1*
     6         t121*t123*t126*t131*t225*t272*t277+7.98984433440117d-1*t1
     7         21*t125*t131*t216*t217*t225*t277-6.848438000915289d-1*t12
     8         1*t123*t126*t136*t272*t276-7.98984433440117d-1*t121*t125*
     9         t136*t216*t217*t276+1.5979688668802342d+0*t121*t126*t131*
     :         t136*t216*t217*t272
            t517 = 2.473556743557577d-2*t120*t516*t66+1.4841340461345462
     1         d-1*t124*t272*t278*t66+4.947113487115154d-2*t120*t278
            t518 = t278**2
            t519 = -6.34154365074529d-1*t160*t161*t31
            t520 = 2.1974870225448048d+1*t158*t163*t28*t29
            t521 = t520+t519
            t522 = t520+t519-6.894030149881355d-1*gammaaa*t160*t168*t35+
     1         2.3889359786424305d+1*gammaaa*t158*t169*t279*t29
            t523 = -2.7178044217479813d-1*gammaaa*t166*t28*t33*t522+2.71
     1         78044217479813d-1*gammaaa*t28*t37*t521-6.34154365074529d-
     2         1*t160*t161*t33*t37-1.7235075374703387d-1*gammaaa*t160*t1
     3         68*t31*t37+2.7178044217479813d-1*t165*t28*t37+5.435608843
     4         495963d-1*gammaaa*t170*t28*t280*t33*t332+6.34154365074529
     5         d-1*gammaaa*t160*t161*t166*t280*t33-2.7178044217479813d-1
     6         *t166*t170*t28*t33-7.386460874872879d-2*gammaaa*t166*t170
     7         *t279*t31-2.7178044217479813d-1*gammaaa*t165*t166*t28*t28
     8         0
            t524 = -1.2367783717787881d-2*rhoa*t523-1.2367783717787881d-
     1         2*t281
            t525 = -2.473556743557577d-2*t120*t232*t284*t425*t66
            t526 = 2.473556743557577d-2*t120*t284
            t527 = 3.994922167200585d-1*t121*t125*t131*t216*t217*t225*t2
     1         83
            t528 = -3.994922167200585d-1*t125*t131*t136*t216*t217
            t529 = -6.839744195138837d-2*t121*t129*t132*t136*t216*t227
            t530 = -3.4242190004576445d-1*t123*t126*t129*t215
            t531 = -3.994922167200585d-1*t125*t129*t216*t217
            t532 = -1.7121095002288222d-1*t123*t125*t127*t221*t222
            t533 = t532+t531+t530
            t534 = -2.735897678055535d-1*t121*t132*t134*t216*t227
            t535 = t534+t532+t531+t530-1.172527576309515d-1*t121*t127*t1
     1         32*t222*t230*t282-2.34505515261903d-1*t121*t134*t215*t229
     2         *t282
            t536 = -1.7121095002288222d-1*t121*t123*t125*t131*t225*t535+
     1         1.7121095002288222d-1*t121*t123*t125*t136*t533+t529+t528+
     2         t527+3.4242190004576445d-1*t121*t123*t125*t131*t231*t283*
     3         t421-1.7121095002288222d-1*t121*t123*t125*t224*t225*t283+
     4         3.4242190004576445d-1*t121*t123*t126*t131*t215*t225*t283-
     5         2.931318940773787d-2*t121*t129*t132*t225*t231*t282-5.8626
     6         37881547574d-2*t121*t129*t136*t215*t229*t282-1.7121095002
     7         288222d-1*t123*t125*t131*t225*t231+1.7121095002288222d-1*
     8         t123*t125*t136*t224-3.4242190004576445d-1*t123*t126*t131*
     9         t136*t215
            t537 = 2.473556743557577d-2*t120*t536*t66+7.420670230672731d
     1         -2*t124*t215*t284*t66+t526
            t538 = t212*t537
            t539 = 2.473556743557577d-2*t120*t287
            t540 = 3.994922167200585d-1*t121*t125*t131*t216*t217*t225*t2
     1         86
            t541 = -7.98984433440117d-1*t125*t131*t136*t216*t217
            t542 = -1.3679488390277675d-1*t121*t129*t132*t136*t216*t227
            t543 = -6.848438000915289d-1*t123*t126*t129*t215
            t544 = -7.98984433440117d-1*t125*t129*t216*t217
            t545 = -3.4242190004576445d-1*t123*t125*t127*t221*t222
            t546 = t545+t544+t543
            t547 = -5.47179535611107d-1*t121*t132*t134*t216*t227
            t548 = t547+t545+t544+t543-2.34505515261903d-1*t121*t127*t13
     1         2*t222*t230*t282-4.69011030523806d-1*t121*t134*t215*t229*
     2         t282
            t549 = -1.7121095002288222d-1*t121*t123*t125*t131*t225*t548+
     1         1.7121095002288222d-1*t121*t123*t125*t136*t546+t542+t541+
     2         t540+3.4242190004576445d-1*t121*t123*t125*t131*t231*t286*
     3         t421-1.7121095002288222d-1*t121*t123*t125*t224*t225*t286+
     4         3.4242190004576445d-1*t121*t123*t126*t131*t215*t225*t286-
     5         5.862637881547574d-2*t121*t129*t132*t225*t231*t282-1.1725
     6         27576309515d-1*t121*t129*t136*t215*t229*t282-3.4242190004
     7         576445d-1*t123*t125*t131*t225*t231+3.4242190004576445d-1*
     8         t123*t125*t136*t224-6.848438000915289d-1*t123*t126*t131*t
     9         136*t215
            t550 = 2.473556743557577d-2*t120*t549*t66+7.420670230672731d
     1         -2*t124*t215*t287*t66+t539
            t551 = -2.473556743557577d-2*t120*t278*t284*t425*t66
            t552 = -3.4242190004576445d-1*t123*t126*t129*t272
            t553 = -1.7121095002288222d-1*t123*t125*t127*t221*t274
            t554 = t553+t552+t531
            t555 = t553+t552+t534+t531-1.172527576309515d-1*t121*t127*t1
     1         32*t230*t274*t282-2.34505515261903d-1*t121*t134*t229*t272
     2         *t282
            t556 = -1.7121095002288222d-1*t121*t123*t125*t131*t225*t555+
     1         1.7121095002288222d-1*t121*t123*t125*t136*t554+t529+t528+
     2         t527+3.4242190004576445d-1*t121*t123*t125*t131*t277*t283*
     3         t421-1.7121095002288222d-1*t121*t123*t125*t225*t276*t283+
     4         3.4242190004576445d-1*t121*t123*t126*t131*t225*t272*t283-
     5         2.931318940773787d-2*t121*t129*t132*t225*t277*t282-5.8626
     6         37881547574d-2*t121*t129*t136*t229*t272*t282-1.7121095002
     7         288222d-1*t123*t125*t131*t225*t277+1.7121095002288222d-1*
     8         t123*t125*t136*t276-3.4242190004576445d-1*t123*t126*t131*
     9         t136*t272
            t557 = 2.473556743557577d-2*t120*t556*t66+7.420670230672731d
     1         -2*t124*t272*t284*t66+t526
            t558 = t212*t557
            t559 = -6.848438000915289d-1*t123*t126*t129*t272
            t560 = -3.4242190004576445d-1*t123*t125*t127*t221*t274
            t561 = t560+t559+t544
            t562 = t560+t559+t547+t544-2.34505515261903d-1*t121*t127*t13
     1         2*t230*t274*t282-4.69011030523806d-1*t121*t134*t229*t272*
     2         t282
            t563 = -1.7121095002288222d-1*t121*t123*t125*t131*t225*t562+
     1         1.7121095002288222d-1*t121*t123*t125*t136*t561+t542+t541+
     2         t540+3.4242190004576445d-1*t121*t123*t125*t131*t277*t286*
     3         t421-1.7121095002288222d-1*t121*t123*t125*t225*t276*t286+
     4         3.4242190004576445d-1*t121*t123*t126*t131*t225*t272*t286-
     5         5.862637881547574d-2*t121*t129*t132*t225*t277*t282-1.1725
     6         27576309515d-1*t121*t129*t136*t229*t272*t282-3.4242190004
     7         576445d-1*t123*t125*t131*t225*t277+3.4242190004576445d-1*
     8         t123*t125*t136*t276-6.848438000915289d-1*t123*t126*t131*t
     9         136*t272
            t564 = 2.473556743557577d-2*t120*t563*t66+7.420670230672731d
     1         -2*t124*t272*t287*t66+t539
            t565 = -6.34154365074529d-1*t108*t255*t256
            t566 = 2.1974870225448048d+1*t105*t106*t253*t258
            t567 = t566+t565
            t568 = t566+t565+2.3889359786424305d+1*gammabb*t106*t253*t26
     1         4*t288-6.894030149881355d-1*gammabb*t112*t255*t263
            t569 = -2.7178044217479813d-1*gammabb*t105*t110*t261*t568+2.
     1         7178044217479813d-1*gammabb*t105*t114*t567+5.435608843495
     2         963d-1*gammabb*t105*t110*t265*t289*t488-2.717804421747981
     3         3d-1*gammabb*t105*t260*t261*t289+6.34154365074529d-1*gamm
     4         abb*t110*t255*t256*t261*t289-7.386460874872879d-2*gammabb
     5         *t108*t261*t265*t288-2.7178044217479813d-1*t105*t110*t261
     6         *t265-1.7235075374703387d-1*gammabb*t108*t114*t255*t263+2
     7         .7178044217479813d-1*t105*t114*t260-6.34154365074529d-1*t
     8         110*t114*t255*t256
            t570 = -1.2367783717787881d-2*rhob*t569-1.2367783717787881d-
     1         2*t290
            t571 = t281**2
            t572 = t280**2
            t573 = 5.435608843495963d-1*gammaaa*t28*t33*t332*t572+1.4772
     1         921749745757d-1*t279*t31*t37-4.014991205359595d-2*gammaaa
     2         *t166*t33*t330*t35-5.435608843495963d-1*t166*t28*t280*t33
     3         -1.4772921749745757d-1*gammaaa*t166*t279*t280*t31
            t574 = t284**2
            t575 = -2.473556743557577d-2*t120*t425*t574*t66
            t576 = t283**2
            t577 = -3.4242190004576445d-1*t123*t125*t131*t225*t283
            t578 = -5.862637881547574d-2*t121*t129*t132*t225*t282*t283
            t579 = t578+t577+3.4242190004576445d-1*t121*t123*t125*t131*t
     1         421*t576-1.003747801339898d-2*t121*t131*t134*t225*t415*t4
     2         18+5.862637881547574d-2*t129*t132*t136*t282
            t580 = 2.473556743557577d-2*t120*t212*t579*t66
            t581 = t578+t577+3.4242190004576445d-1*t121*t123*t125*t131*t
     1         283*t286*t421-2.007495602679796d-2*t121*t131*t134*t225*t4
     2         15*t418-2.931318940773787d-2*t121*t129*t132*t225*t282*t28
     3         6-1.7121095002288222d-1*t123*t125*t131*t225*t286+1.172527
     4         576309515d-1*t129*t132*t136*t282
            t582 = t287**2
            t583 = t286**2
            t584 = 3.4242190004576445d-1*t121*t123*t125*t131*t421*t583-4
     1         .014991205359592d-2*t121*t131*t134*t225*t415*t418-1.17252
     2         7576309515d-1*t121*t129*t132*t225*t282*t286-6.84843800091
     3         5289d-1*t123*t125*t131*t225*t286+2.34505515261903d-1*t129
     4         *t132*t136*t282
            t585 = t290**2
            t586 = t289**2
            t587 = 5.435608843495963d-1*gammabb*t105*t110*t488*t586-4.01
     1         4991205359595d-2*gammabb*t110*t112*t261*t486-1.4772921749
     2         745757d-1*gammabb*t108*t261*t288*t289-5.435608843495963d-
     3         1*t105*t110*t261*t289+1.4772921749745757d-1*t108*t114*t28
     4         8
            t588 = 1/rhoa**3.333333333333333d+0
            t589 = 1/rhoa**3.3333333333333337d+0
            t590 = 1/rhoa**2.666666666666667d+0
            t591 = 1/t2**7
            t592 = 1/rhoa**2.0d+0
            t593 = 1/t16**3
            t594 = t152**3
            t595 = -1.269642451250142d+0*t149*t2*(7.876233178997433d-1*t
     1         3*(-5.469606374303773d-2*t12*t591*t592-1.4585616998143394
     2         d-1*t12*t143*t590-1.1708185015918181d-2*t589-1.3127055298
     3         329054d-1*t12*t296*t298)-5.469606374303773d-2*t13*t591*t5
     4         92-1.4585616998143394d-1*t13*t143*t590-3.9381165894987163
     5         d-1*t143*t144*t306-1.3127055298329054d-1*t13*t296*t298+1.
     6         9690582947493582d-1*t142*t150*t298+2.625411059665811d-1*t
     7         143*t150*t297)+1.763392293402975d-2*t15*t298*t592+2.35118
     8         97245373004d-1*t15*t3*t590+7.617854707500852d+0*t151*t2*t
     9         304*t307-6.34821225625071d-1*t144*t149*t3*t307+1.26964245
     :         1250142d+0*t144*t3*t304*t305+4.2321415041671406d-1*t149*t
     ;         151*t297*t3+7.053569173611901d-2*t143*t15*t296-7.61785470
     <         7500852d+0*t151**3*t2/t14**4+1.0580353760417849d-1*t142*t
     =         143*t149*t151
            t596 = 1/t23**3
            t597 = t157**3
            t598 = -1.269642451250142d+0*t154*t2*(7.876233178997433d-1*t
     1         3*(-5.469606374303773d-2*t19*t591*t592-1.4585616998143394
     2         d-1*t143*t19*t590-6.407931356509611d-3*t589-1.31270552983
     3         29054d-1*t19*t296*t298)-5.469606374303773d-2*t20*t591*t59
     4         2-1.4585616998143394d-1*t143*t20*t590-3.9381165894987163d
     5         -1*t143*t144*t313-1.3127055298329054d-1*t20*t296*t298+1.9
     6         690582947493582d-1*t142*t155*t298+2.625411059665811d-1*t1
     7         43*t155*t297)+1.763392293402975d-2*t22*t298*t592+2.351189
     8         7245373004d-1*t22*t3*t590+7.617854707500852d+0*t156*t2*t3
     9         11*t314-6.34821225625071d-1*t144*t154*t3*t314+1.269642451
     :         250142d+0*t144*t3*t311*t312+4.2321415041671406d-1*t154*t1
     ;         56*t297*t3+7.053569173611901d-2*t143*t22*t296-7.617854707
     <         500852d+0*t156**3*t2/t21**4+1.0580353760417849d-1*t142*t1
     =         43*t154*t156
            t599 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(4
     1         .1099018897499934d-3*t588*t9-6.21814d-2*t11*t147**3/t8**3
     2         -3.10907d-2*t11*t140*(1.763392293402975d-2*t298*t592*t7+2
     3         .3511897245373004d-1*t3*t590*t7+7.053569173611901d-2*t143
     4         *t296*t7-7.617854707500852d+0*t146**3*t2/t6**4-1.26964245
     5         1250142d+0*t141*t2*(7.876233178997433d-1*t3*(-5.469606374
     6         303773d-2*t4*t591*t592-1.4585616998143394d-1*t143*t4*t590
     7         -7.424439106586571d-3*t589-1.3127055298329054d-1*t296*t29
     8         8*t4)-5.469606374303773d-2*t5*t591*t592-1.458561699814339
     9         4d-1*t143*t5*t590-1.3127055298329054d-1*t296*t298*t5-3.93
     :         81165894987163d-1*t143*t144*t299+1.9690582947493582d-1*t1
     ;         42*t145*t298+2.625411059665811d-1*t143*t145*t297)-6.34821
     <         225625071d-1*t141*t144*t3*t300+7.617854707500852d+0*t146*
     =         t2*t294*t300+4.2321415041671406d-1*t141*t146*t297*t3+1.26
     >         9642451250142d+0*t144*t294*t295*t3+1.0580353760417849d-1*
     ?         t141*t142*t143*t146)+6.21814d-2*t148*t18*t595+1.243628d-1
     @         *t18*t593*t594-8.548627933030694d-3*t17*t588-1.865442d-1*
     1         t152*t18*t302*t308-8.243319792565315d-3*t139*t148*t308+8.
     2         243319792565315d-3*t139*t302*t303+9.327209999999999d-2*t1
     3         1*t147*t292*t301+3.96311967940178d-3*t139*t140*t301-3.963
     4         11967940178d-3*t139*t292*t293+1.0991093056753751d-2*t148*
     5         t152*t291-5.284159572535706d-3*t140*t147*t291)-3.37738d-2
     6         *t153*t25*t598-6.75476d-2*t25*t596*t597+2.417193091507827
     7         7d-3*t24*t588+1.013214d-1*t157*t25*t309*t315+2.3308647668
     8         1112d-3*t139*t153*t315-2.33086476681112d-3*t139*t309*t310
     9         -3.107819689081493d-3*t153*t157*t291)+3.37738d-2*t153*t25
     :         *t598+6.75476d-2*t25*t596*t597-2.4171930915078277d-3*t24*
     ;         t588-1.013214d-1*t157*t25*t309*t315-2.33086476681112d-3*t
     <         139*t153*t315+2.33086476681112d-3*t139*t309*t310+3.107819
     =         689081493d-3*t153*t157*t291)-6.21814d-2*t148*t18*t595-1.2
     >         43628d-1*t18*t593*t594+8.548627933030694d-3*t17*t588+1.86
     ?         5442d-1*t152*t18*t302*t308+8.243319792565315d-3*t139*t148
     @         *t308-8.243319792565315d-3*t139*t302*t303-1.0991093056753
     1         751d-2*t148*t152*t291
            t600 = rhoa**5.000000000000002d-1
            t601 = 1/rhoa**6.666666666666665d-1
            t602 = 1/rhoa**1.8333333333333332d+0
            t603 = t158**3
            t604 = exp(-2.4256569070538234d+2*t26)
            t605 = 8.619732841431575d+5*gammaaa*t28*t603*t604/t30**4
            t606 = -2.4874964680519085d+4*gammaaa*t160*t161*t319*t320*t3
     1         21
            t607 = -8.619732841431575d+5*gammaaa*t28*t320*t321*t603
            t608 = 1.0660699148793894d+4*gammaaa*t158*t28*t316*t320*t321
            t609 = -1.035785462955064d+1*gammaaa*t168*t31*t600
            t610 = 1.1097701388804264d+0*gammaaa*t279*t31*t601
            t611 = 8.807699514924018d-2*gammaaa*t161*t31*t602
            t612 = 5.383843205234772d+2*gammaaa*t158*t163*t279*t29*t317
            t613 = -2.563734859635607d+1*gammaaa*t158*t161*t163*t29*t318
            t614 = 1.2437482340259542d+4*gammaaa*t160*t161*t163*t29*t319
            t615 = -1.5382409157813634d+2*gammaaa*t160*t161*t163*t29*t31
     1         6
            t616 = 1.436622140238596d+5*gammaaa*t163*t28*t29*t603
            t617 = -5.330349574396946d+3*gammaaa*t158*t163*t28*t29*t316
            t618 = 2.1974870225448048d+1*gammaaa*t163*t28*t29*t599
            t619 = 1/t27**7.0d+0
            t620 = 1/t36**4
            t621 = 1/t38**3
            t622 = t178**3
            t623 = 1/t76**3
            t624 = -1.243628d-1*t622*t623*t69
            t625 = 1.865442d-1*t178*t339*t348*t69
            t626 = -8.243319792565315d-3*t181*t338*t339
            t627 = 1/t66**3.3333333333333337d+0
            t628 = 1/t66**2.0d+0
            t629 = 1/t70**7
            t630 = 1/t66**2.666666666666667d+0
            t631 = 2.3511897245373004d-1*t630*t71*t75+1.763392293402975d
     1         -2*t344*t628*t75+7.053569173611901d-2*t174*t343*t75-7.617
     2         854707500852d+0*t176**3*t70/t74**4-1.269642451250142d+0*t
     3         177*t70*(-1.4585616998143394d-1*t174*t630*t73-5.469606374
     4         303773d-2*t628*t629*t73-1.3127055298329054d-1*t343*t344*t
     5         73+7.876233178997433d-1*t71*(-1.4585616998143394d-1*t174*
     6         t630*t72-5.469606374303773d-2*t628*t629*t72-1.31270552983
     7         29054d-1*t343*t344*t72-1.1708185015918181d-2*t627)-3.9381
     8         165894987163d-1*t173*t174*t346+2.625411059665811d-1*t174*
     9         t175*t345+1.9690582947493582d-1*t172*t175*t344)-6.3482122
     :         5625071d-1*t173*t177*t347*t71+4.2321415041671406d-1*t176*
     ;         t177*t345*t71+1.269642451250142d+0*t173*t341*t342*t71+7.6
     <         17854707500852d+0*t176*t342*t347*t70+1.0580353760417849d-
     =         1*t172*t174*t176*t177
            t632 = -6.21814d-2*t179*t631*t69
            t633 = 8.243319792565315d-3*t179*t181*t348
            t634 = -1.0991093056753751d-2*t178*t179*t351
            t635 = 1/t66**3.333333333333333d+0
            t636 = 8.548627933030694d-3*t635*t77
            t637 = t204**3
            t638 = 1/t80**1.6666666666666669d+0
            t639 = 6*t78*t93
            t640 = -6*t381
            t641 = t640+t639
            t642 = t207**3
            t643 = 1/t82**1.6666666666666669d+0
            t644 = -6*t78*t93
            t645 = 6*t381
            t646 = t645+t644
            t647 = t186**3
            t648 = 1/t90**3
            t649 = 6.75476d-2*t647*t648*t85
            t650 = -1.013214d-1*t186*t354*t360*t85
            t651 = 2.33086476681112d-3*t181*t353*t354
            t652 = 2.3511897245373004d-1*t630*t71*t89+1.763392293402975d
     1         -2*t344*t628*t89+7.053569173611901d-2*t174*t343*t89-7.617
     2         854707500852d+0*t184**3*t70/t88**4-1.269642451250142d+0*t
     3         185*t70*(-1.4585616998143394d-1*t174*t630*t87-5.469606374
     4         303773d-2*t628*t629*t87-1.3127055298329054d-1*t343*t344*t
     5         87+7.876233178997433d-1*t71*(-1.4585616998143394d-1*t174*
     6         t630*t86-5.469606374303773d-2*t628*t629*t86-1.31270552983
     7         29054d-1*t343*t344*t86-6.407931356509611d-3*t627)-3.93811
     8         65894987163d-1*t173*t174*t358+2.625411059665811d-1*t174*t
     9         183*t345+1.9690582947493582d-1*t172*t183*t344)-6.34821225
     :         625071d-1*t173*t185*t359*t71+1.269642451250142d+0*t173*t3
     ;         56*t357*t71+4.2321415041671406d-1*t184*t185*t345*t71+7.61
     <         7854707500852d+0*t184*t357*t359*t70+1.0580353760417849d-1
     =         *t172*t174*t184*t185
            t653 = 3.37738d-2*t187*t652*t85
            t654 = -2.33086476681112d-3*t181*t187*t360
            t655 = 3.107819689081493d-3*t186*t187*t351
            t656 = -2.4171930915078277d-3*t635*t91
            t657 = t92*t93*(1.709920934161365d+0*(-6.21814d-2*t193**3*t9
     1         4/t99**3-3.10907d-2*t194*t94*(2.3511897245373004d-1*t630*
     2         t71*t98+1.763392293402975d-2*t344*t628*t98+7.053569173611
     3         901d-2*t174*t343*t98-7.617854707500852d+0*t191**3*t70/t97
     4         **4-1.269642451250142d+0*t192*t70*(-1.4585616998143394d-1
     5         *t174*t630*t96-5.469606374303773d-2*t628*t629*t96-1.31270
     6         55298329054d-1*t343*t344*t96+7.876233178997433d-1*t71*(-1
     7         .4585616998143394d-1*t174*t630*t95-5.469606374303773d-2*t
     8         628*t629*t95-1.3127055298329054d-1*t343*t344*t95-7.424439
     9         106586571d-3*t627)-3.9381165894987163d-1*t173*t174*t368+2
     :         .625411059665811d-1*t174*t190*t345+1.9690582947493582d-1*
     ;         t172*t190*t344)-6.34821225625071d-1*t173*t192*t369*t71+1.
     <         269642451250142d+0*t173*t366*t367*t71+4.2321415041671406d
     =         -1*t191*t192*t345*t71+7.617854707500852d+0*t191*t367*t369
     >         *t70+1.0580353760417849d-1*t172*t174*t191*t192)+9.3272099
     ?         99999999d-2*t193*t365*t370*t94-8.548627933030694d-3*t635*
     @         t77+6.21814d-2*t179*t631*t69+1.243628d-1*t622*t623*t69-1.
     1         865442d-1*t178*t339*t348*t69+4.1099018897499934d-3*t100*t
     2         635+3.96311967940178d-3*t181*t194*t370-3.96311967940178d-
     3         3*t181*t364*t365-5.284159572535706d-3*t193*t194*t351+1.09
     4         91093056753751d-2*t178*t179*t351-8.243319792565315d-3*t17
     5         9*t181*t348+8.243319792565315d-3*t181*t338*t339)+2.417193
     6         0915078277d-3*t635*t91-3.37738d-2*t187*t652*t85-6.75476d-
     7         2*t647*t648*t85+1.013214d-1*t186*t354*t360*t85+2.33086476
     8         681112d-3*t181*t187*t360-2.33086476681112d-3*t181*t353*t3
     9         54-3.107819689081493d-3*t186*t187*t351)
            t658 = -12*t197*t371*t92
            t659 = 60*t195*t374*t92
            t660 = 36*t195*t376*t93
            t661 = -120*t101*t92/t66**7
            t662 = -144*t101*t197*t376
            t663 = 24*t101*t78*t93
            t664 = 5.848223622634648d-1*t84*(12*t199*t371*t93+t663+t662+
     1         t661+t660+t659+t658+t657+t656+t655+t654+t653+t651+t650+t6
     2         49+240*t101*t199*t374-96*t195*t197*t199)+5.84822362263464
     3         8d-1*t102*(2.564881401242048d+0*t208*t646-5.6997364472045
     4         5d-1*t642*t643+2.564881401242048d+0*t205*t641-5.699736447
     5         20455d-1*t637*t638+2.5648814012420473d+0*t207*t386*t389+2
     6         .5648814012420473d+0*t204*t380*t384)+t636+t634+t633+t632+
     7         t626+t625+t624+1.7544670867903944d+0*t200*t390+1.75446708
     8         67903944d+0*t209*t378
            t665 = t215**3
            t666 = 1/t80**2.3333333333333334d+0
            t667 = 1/t82**2.3333333333333334d+0
            t668 = 1.4814814814814814d-1*t642*t667+1.4814814814814814d-1
     1         *t637*t666+3.333333333333333d-1*t214*t646+3.3333333333333
     2         33d-1*t213*t641-3.333333333333333d-1*t207*t389*t394-3.333
     3         333333333333d-1*t204*t384*t393
            t669 = t66**5.000000000000002d-1
            t670 = -6.525039539760956d+0*t121*t125*t131*t136*t227*t669
            t671 = 1/t66**6.666666666666665d-1
            t672 = 6.991113792601027d-1*t121*t125*t131*t136*t282*t671
            t673 = 1/t66**1.8333333333333332d+0
            t674 = 5.548503010000815d-2*t121*t125*t131*t136*t217*t673
            t675 = -4.1090628005491736d+0*t121*t123*t129*t229*t665
            t676 = 3.08179710041188d+0*t121*t123*t129*t132*t215*t395
            t677 = -7.190859900961053d+0*t121*t129*t132*t216*t217*t392
            t678 = -3.4242190004576445d-1*t121*t123*t126*t129*t668
            t679 = 2.396953300320351d+0*t121*t126*t129*t216*t217*t395
            t680 = -8.389336551121229d+0*t121*t126*t129*t215*t282*t396
            t681 = 3.9949221672005863d-1*t121*t126*t129*t215*t217*t398
            t682 = -6.525039539760956d+0*t121*t125*t129*t227*t669
            t683 = 6.991113792601027d-1*t121*t125*t129*t282*t671
            t684 = 5.548503010000815d-2*t121*t125*t129*t217*t673
            t685 = 1.0272657001372934d+0*t121*t123*t126*t127*t215*t221*t
     1         405
            t686 = 1.1984766501601755d+0*t121*t125*t127*t216*t217*t221*t
     1         405
            t687 = -3.08179710041188d+0*t121*t123*t127*t132*t221*t222*t3
     1         92
            t688 = 1.0272657001372934d+0*t121*t123*t126*t127*t221*t222*t
     1         395
            t689 = -4.793906600640702d+0*t121*t126*t127*t215*t216*t217*t
     1         221*t222
            t690 = -4.1946682755606146d+0*t121*t125*t127*t221*t222*t282*
     1         t396
            t691 = 1.9974610836002932d-1*t121*t125*t127*t217*t221*t222*t
     1         398
            t692 = 1.0272657001372934d+0*t121*t123*t125*t222*t405*t409*t
     1         410
            t693 = -5.136328500686467d-1*t121*t123*t125*t127*t221*t222*t
     1         405
            t694 = 2.425656907053823d+2*t103*t132*t215-8.085523023512744
     1         d+1*t126*t210
            t695 = 3.4242190004576445d-1*t121*t123*t125*t409*t410*t411*t
     1         694
            t696 = 1.2128284535269115d+2*t103*t132*t668+2.42565690705382
     1         3d+3*t103*t418*t665-4.042761511756372d+1*t126*t664-1.4553
     2         94144232294d+3*t103*t215*t229*t395+3.638485360580735d+2*t
     3         132*t210*t395-1.455394144232294d+3*t210*t229*t392+3.63848
     4         5360580735d+2*t132*t215*t391
            t697 = -1.7121095002288222d-1*t121*t123*t125*t127*t221*t696
            t698 = -2.0545314002745868d+0*t121*t123*t126*t215*t409*t410*
     1         t411
            t699 = -2.396953300320351d+0*t121*t125*t216*t217*t409*t410*t
     1         411
            t700 = 1.0272657001372934d+0*t121*t123*t126*t127*t215*t221*t
     1         411
            t701 = 1.1984766501601755d+0*t121*t125*t127*t216*t217*t221*t
     1         411
            t702 = exp(-1.2128284535269115d+2*t103*t126)
            t703 = 1/t128**4
            t704 = t222**3
            t705 = -1.0272657001372934d+0*t121*t123*t125*t702*t703*t704
            t706 = 3.4242190004576445d-1*t121*t123*t125*t409*t410*t704
            t707 = -1.7121095002288222d-1*t121*t123*t125*t127*t221*t704
            t708 = 1/t122**7.0d+0
            t709 = -5.585791092696718d+0*t132*t134*t226*t669*t708
            t710 = 3.9898507804976574d-1*t132*t134*t226*t415*t671
            t711 = 1.8999289430941224d-2*t132*t134*t226*t227*t673
            t712 = 1/t119**7.0d+0
            t713 = 1/t128**5.0d+0
            t714 = 1/t135**4
            t715 = -2.473556743557577d-2*t120*t426
            t716 = 1/t137**3
            t717 = 2.0d+0*t429
            t718 = t639-2*t381
            t719 = t644+2*t381
            t720 = -12*t195*t376*t93
            t721 = 48*t101*t197*t376
            t722 = -24*t101*t78*t93
            t723 = 5.848223622634648d-1*t84*(4*t199*t371*t93+t722+t721+t
     1         720+t661+t659+t658+t657+t656+t655+t654+t653+t651+t650+t64
     2         9+80*t101*t199*t374-32*t195*t197*t199)+5.848223622634648d
     3         -1*t102*(3.41984186832273d+0*t207*t381*t386*t78-3.4198418
     4         6832273d+0*t204*t380*t381*t78+2.564881401242048d+0*t208*t
     5         719+2.564881401242048d+0*t205*t718-5.69973644720455d-1*t2
     6         69*t385*t643-5.69973644720455d-1*t268*t379*t638+8.5496046
     7         70806825d-1*t269*t386*t389+8.549604670806825d-1*t268*t380
     8         *t384)+t636+t634+t633+t632+t626+t625+t624+1.1696447245269
     9         297d+0*t200*t428+1.1696447245269297d+0*t209*t427+5.848223
     :         622634648d-1*t267*t390+5.848223622634648d-1*t270*t378
            t724 = 1.4841340461345462d-1*t124*t215*t278
            t725 = 1.4841340461345462d-1*t124*t232*t272
            t726 = 4.947113487115154d-2*t120*t445
            t727 = -4.793906600640702d+0*t121*t131*t132*t136*t215*t216*t
     1         217*t272
            t728 = 1.5979688668802342d+0*t121*t126*t131*t136*t216*t217*t
     1         430
            t729 = -4.444444444444444d-1*t207*t381*t394*t78+4.4444444444
     1         44444d-1*t204*t381*t393*t78+3.333333333333333d-1*t214*t71
     2         9+3.333333333333333d-1*t213*t718+1.4814814814814814d-1*t2
     3         69*t385*t667+1.4814814814814814d-1*t268*t379*t666-1.11111
     4         1111111111d-1*t269*t389*t394-1.111111111111111d-1*t268*t3
     5         84*t393
            t730 = 1.5979688668802342d+0*t121*t126*t136*t215*t216*t217*t
     1         276
            t731 = -1.5979688668802342d+0*t121*t126*t131*t215*t216*t217*
     1         t225*t277
            t732 = 1.5979688668802342d+0*t121*t126*t136*t216*t217*t224*t
     1         272
            t733 = 7.98984433440117d-1*t121*t125*t216*t217*t224*t225*t27
     1         7
            t734 = -1.5979688668802342d+0*t121*t126*t131*t216*t217*t225*
     1         t231*t272
            t735 = 7.98984433440117d-1*t121*t125*t216*t217*t225*t231*t27
     1         6
            t736 = -1.5979688668802342d+0*t121*t125*t131*t216*t217*t231*
     1         t277*t421
            t737 = -7.98984433440117d-1*t121*t125*t136*t216*t217*t443
            t738 = 7.98984433440117d-1*t121*t125*t131*t216*t217*t225*t44
     1         4
            t739 = -4.1090628005491736d+0*t121*t123*t129*t229*t272*t392
            t740 = 1.0272657001372934d+0*t121*t123*t129*t132*t272*t395
            t741 = 2.0545314002745868d+0*t121*t123*t129*t132*t215*t430
            t742 = -4.793906600640702d+0*t121*t129*t132*t215*t216*t217*t
     1         272
            t743 = -2.396953300320351d+0*t121*t129*t132*t216*t217*t392
            t744 = 1.5979688668802342d+0*t121*t126*t129*t216*t217*t430
            t745 = -3.4242190004576445d-1*t121*t123*t126*t129*t729
            t746 = 7.98984433440117d-1*t121*t126*t129*t216*t217*t395
            t747 = -2.79644551704041d+0*t121*t126*t129*t272*t282*t396
            t748 = 1.3316407224001955d-1*t121*t126*t129*t217*t272*t398
            t749 = -5.59289103408082d+0*t121*t126*t129*t215*t282*t396
            t750 = 2.663281444800391d-1*t121*t126*t129*t215*t217*t398
            t751 = 6.848438000915289d-1*t121*t123*t126*t127*t215*t221*t4
     1         35
            t752 = 7.98984433440117d-1*t121*t125*t127*t216*t217*t221*t43
     1         5
            t753 = 3.4242190004576445d-1*t121*t123*t126*t127*t221*t272*t
     1         405
            t754 = 3.994922167200585d-1*t121*t125*t127*t216*t217*t221*t4
     1         05
            t755 = -1.0272657001372934d+0*t121*t123*t127*t132*t221*t274*
     1         t392
            t756 = 3.4242190004576445d-1*t121*t123*t126*t127*t221*t274*t
     1         395
            t757 = -1.5979688668802342d+0*t121*t126*t127*t215*t216*t217*
     1         t221*t274
            t758 = -1.398222758520205d+0*t121*t125*t127*t221*t274*t282*t
     1         396
            t759 = 6.658203612000978d-2*t121*t125*t127*t217*t221*t274*t3
     1         98
            t760 = 3.4242190004576445d-1*t121*t123*t125*t274*t405*t409*t
     1         410
            t761 = -1.7121095002288222d-1*t121*t123*t125*t127*t221*t274*
     1         t405
            t762 = -2.0545314002745868d+0*t121*t123*t127*t132*t215*t221*
     1         t222*t272
            t763 = 6.848438000915289d-1*t121*t123*t126*t127*t221*t222*t4
     1         30
            t764 = -1.5979688668802342d+0*t121*t126*t127*t216*t217*t221*
     1         t222*t272
            t765 = -1.5979688668802342d+0*t121*t126*t127*t215*t216*t217*
     1         t221*t222
            t766 = -2.79644551704041d+0*t121*t125*t127*t221*t222*t282*t3
     1         96
            t767 = 1.3316407224001955d-1*t121*t125*t127*t217*t221*t222*t
     1         398
            t768 = 6.848438000915289d-1*t121*t123*t125*t222*t409*t410*t4
     1         35
            t769 = -3.4242190004576445d-1*t121*t123*t125*t127*t221*t222*
     1         t435
            t770 = -1.3696876001830577d+0*t121*t123*t126*t215*t222*t274*
     1         t409*t410
            t771 = -1.5979688668802342d+0*t121*t125*t216*t217*t222*t274*
     1         t409*t410
            t772 = 6.848438000915289d-1*t121*t123*t126*t127*t215*t221*t2
     1         22*t274
            t773 = 7.98984433440117d-1*t121*t125*t127*t216*t217*t221*t22
     1         2*t274
            t774 = 1.2128284535269115d+2*t103*t132*t729-4.04276151175637
     1         2d+1*t126*t723-9.702627628215292d+2*t103*t215*t229*t430+2
     2         .425656907053823d+2*t132*t210*t430+2.425656907053823d+2*t
     3         132*t215*t429+2.425656907053823d+3*t103*t272*t392*t418-4.
     4         851313814107646d+2*t103*t229*t272*t395+1.2128284535269115
     5         d+2*t132*t271*t395-4.851313814107646d+2*t229*t271*t392+1.
     6         2128284535269115d+2*t132*t272*t391-9.702627628215292d+2*t
     7         210*t215*t229*t272
            t775 = -1.7121095002288222d-1*t121*t123*t125*t127*t221*t774
            t776 = -6.848438000915289d-1*t121*t123*t126*t272*t409*t410*t
     1         411
            t777 = -7.98984433440117d-1*t121*t125*t216*t217*t409*t410*t4
     1         11
            t778 = 3.4242190004576445d-1*t121*t123*t126*t127*t221*t272*t
     1         411
            t779 = 3.994922167200585d-1*t121*t125*t127*t216*t217*t221*t4
     1         11
            t780 = -1.0272657001372934d+0*t121*t123*t125*t274*t411*t702*
     1         t703
            t781 = 3.4242190004576445d-1*t121*t123*t125*t274*t409*t410*t
     1         411
            t782 = -1.7121095002288222d-1*t121*t123*t125*t127*t221*t274*
     1         t411
            t783 = 2.425656907053823d+2*t103*t132*t272-8.085523023512744
     1         d+1*t126*t271
            t784 = 3.4242190004576445d-1*t121*t123*t125*t409*t410*t411*t
     1         783
            t785 = -5.47179535611107d+0*t134*t215*t216*t226*t227*t272*t4
     1         18
            t786 = 1.094359071222214d+0*t134*t216*t226*t227*t229*t430
            t787 = 5.47179535611107d-1*t127*t132*t216*t226*t227*t230*t43
     1         5
            t788 = -2.188718142444428d+0*t127*t215*t216*t226*t227*t229*t
     1         230*t274
            t789 = -2.188718142444428d+0*t127*t216*t222*t226*t227*t229*t
     1         230*t272
            t790 = -1.641538606833321d+0*t132*t216*t222*t226*t227*t274*t
     1         409*t419
            t791 = 5.47179535611107d-1*t127*t132*t216*t222*t226*t227*t23
     1         0*t274
            t792 = 2.9682680922690924d-1*t119*t138*t215*t272
            t793 = 1.4841340461345462d-1*t124*t138*t430
            t794 = 5.848223622634648d-1*t102*(-1.5389288407452287d+1*t20
     1         8*t78*t93+1.5389288407452287d+1*t205*t78*t93+3.4198418683
     2         2273d+0*t269*t381*t386*t78-3.41984186832273d+0*t268*t380*
     3         t381*t78-5.69973644720455d-1*t207*t497*t643-5.69973644720
     4         455d-1*t204*t495*t638+8.549604670806825d-1*t207*t386*t498
     5         +8.549604670806825d-1*t204*t380*t496-5.129762802484096d+0
     6         *t208*t381+5.129762802484096d+0*t205*t381)+5.848223622634
     7         648d-1*t84*(-4*t199*t371*t93+t721+t720+t663+t661+t659+t65
     8         8+t657+t656+t655+t654+t653+t651+t650+t649-80*t101*t199*t3
     9         74+32*t195*t197*t199)+t636+t634+t633+t632+t626+t625+t624+
     :         5.848223622634648d-1*t200*t499+5.848223622634648d-1*t209*
     ;         t494+1.1696447245269297d+0*t267*t428+1.1696447245269297d+
     <         0*t270*t427
            t795 = -2.0d+0*t214*t78*t93+2.0d+0*t213*t78*t93-4.4444444444
     1         44444d-1*t269*t381*t394*t78+4.444444444444444d-1*t268*t38
     2         1*t393*t78+1.4814814814814814d-1*t207*t497*t667+1.4814814
     3         814814814d-1*t204*t495*t666-1.111111111111111d-1*t207*t39
     4         4*t498-1.111111111111111d-1*t204*t393*t496-6.666666666666
     5         666d-1*t214*t381+6.666666666666666d-1*t213*t381
            t796 = -4.1090628005491736d+0*t121*t123*t129*t215*t229*t501
            t797 = 2.0545314002745868d+0*t121*t123*t129*t132*t272*t430
            t798 = 1.0272657001372934d+0*t121*t123*t129*t132*t215*t502
            t799 = -2.396953300320351d+0*t121*t129*t132*t216*t217*t501
            t800 = -3.4242190004576445d-1*t121*t123*t126*t129*t795
            t801 = 7.98984433440117d-1*t121*t126*t129*t216*t217*t502
            t802 = -5.59289103408082d+0*t121*t126*t129*t272*t282*t396
            t803 = 2.663281444800391d-1*t121*t126*t129*t217*t272*t398
            t804 = -2.79644551704041d+0*t121*t126*t129*t215*t282*t396
            t805 = 1.3316407224001955d-1*t121*t126*t129*t215*t217*t398
            t806 = 6.848438000915289d-1*t121*t123*t126*t127*t221*t272*t4
     1         35
            t807 = 3.4242190004576445d-1*t121*t123*t126*t127*t215*t221*t
     1         506
            t808 = 3.994922167200585d-1*t121*t125*t127*t216*t217*t221*t5
     1         06
            t809 = -2.0545314002745868d+0*t121*t123*t127*t132*t215*t221*
     1         t272*t274
            t810 = 6.848438000915289d-1*t121*t123*t126*t127*t221*t274*t4
     1         30
            t811 = -1.5979688668802342d+0*t121*t126*t127*t216*t217*t221*
     1         t272*t274
            t812 = -2.79644551704041d+0*t121*t125*t127*t221*t274*t282*t3
     1         96
            t813 = 1.3316407224001955d-1*t121*t125*t127*t217*t221*t274*t
     1         398
            t814 = 6.848438000915289d-1*t121*t123*t125*t274*t409*t410*t4
     1         35
            t815 = -3.4242190004576445d-1*t121*t123*t125*t127*t221*t274*
     1         t435
            t816 = -1.0272657001372934d+0*t121*t123*t127*t132*t221*t222*
     1         t501
            t817 = 3.4242190004576445d-1*t121*t123*t126*t127*t221*t222*t
     1         502
            t818 = -1.398222758520205d+0*t121*t125*t127*t221*t222*t282*t
     1         396
            t819 = 6.658203612000978d-2*t121*t125*t127*t217*t221*t222*t3
     1         98
            t820 = 3.4242190004576445d-1*t121*t123*t125*t222*t409*t410*t
     1         506
            t821 = -1.7121095002288222d-1*t121*t123*t125*t127*t221*t222*
     1         t506
            t822 = -1.3696876001830577d+0*t121*t123*t126*t222*t272*t274*
     1         t409*t410
            t823 = 6.848438000915289d-1*t121*t123*t126*t127*t221*t222*t2
     1         72*t274
            t824 = 3.4242190004576445d-1*t121*t123*t125*t222*t274*t409*t
     1         410*t783
            t825 = -1.0272657001372934d+0*t121*t123*t125*t222*t510*t702*
     1         t703
            t826 = 3.4242190004576445d-1*t121*t123*t125*t222*t409*t410*t
     1         510
            t827 = -1.7121095002288222d-1*t121*t123*t125*t127*t221*t222*
     1         t510
            t828 = 1.2128284535269115d+2*t103*t132*t795-4.04276151175637
     1         2d+1*t126*t794-4.851313814107646d+2*t103*t215*t229*t502+1
     2         .2128284535269115d+2*t132*t210*t502+2.425656907053823d+3*
     3         t103*t215*t418*t501-4.851313814107646d+2*t210*t229*t501+1
     4         .2128284535269115d+2*t132*t215*t500-9.702627628215292d+2*
     5         t103*t229*t272*t430+2.425656907053823d+2*t132*t271*t430+2
     6         .425656907053823d+2*t132*t272*t429-9.702627628215292d+2*t
     7         215*t229*t271*t272
            t829 = -1.7121095002288222d-1*t121*t123*t125*t127*t221*t828
            t830 = -6.848438000915289d-1*t121*t123*t126*t215*t409*t410*t
     1         510
            t831 = -7.98984433440117d-1*t121*t125*t216*t217*t409*t410*t5
     1         10
            t832 = 3.4242190004576445d-1*t121*t123*t126*t127*t215*t221*t
     1         510
            t833 = 3.994922167200585d-1*t121*t125*t127*t216*t217*t221*t5
     1         10
            t834 = 1/rhob**3.333333333333333d+0
            t835 = 1/rhob**3.3333333333333337d+0
            t836 = 1/rhob**2.666666666666667d+0
            t837 = 1/t41**7
            t838 = 1/rhob**2.0d+0
            t839 = 1/t55**3
            t840 = t247**3
            t841 = -1.269642451250142d+0*t244*t41*(7.876233178997433d-1*
     1         t42*(-5.469606374303773d-2*t51*t837*t838-1.45856169981433
     2         94d-1*t238*t51*t836-1.1708185015918181d-2*t835-1.31270552
     3         98329054d-1*t452*t454*t51)-5.469606374303773d-2*t52*t837*
     4         t838-1.4585616998143394d-1*t238*t52*t836-1.31270552983290
     5         54d-1*t452*t454*t52-3.9381165894987163d-1*t238*t239*t462+
     6         1.9690582947493582d-1*t237*t245*t454+2.625411059665811d-1
     7         *t238*t245*t453)+1.763392293402975d-2*t454*t54*t838+2.351
     8         1897245373004d-1*t42*t54*t836+7.053569173611901d-2*t238*t
     9         452*t54-7.617854707500852d+0*t246**3*t41/t53**4+7.6178547
     :         07500852d+0*t246*t41*t460*t463-6.34821225625071d-1*t239*t
     ;         244*t42*t463+1.269642451250142d+0*t239*t42*t460*t461+4.23
     <         21415041671406d-1*t244*t246*t42*t453+1.0580353760417849d-
     =         1*t237*t238*t244*t246
            t842 = 1/t62**3
            t843 = t252**3
            t844 = -1.269642451250142d+0*t249*t41*(7.876233178997433d-1*
     1         t42*(-5.469606374303773d-2*t58*t837*t838-1.45856169981433
     2         94d-1*t238*t58*t836-6.407931356509611d-3*t835-1.312705529
     3         8329054d-1*t452*t454*t58)-5.469606374303773d-2*t59*t837*t
     4         838-1.4585616998143394d-1*t238*t59*t836-1.312705529832905
     5         4d-1*t452*t454*t59-3.9381165894987163d-1*t238*t239*t469+1
     6         .9690582947493582d-1*t237*t250*t454+2.625411059665811d-1*
     7         t238*t250*t453)+1.763392293402975d-2*t454*t61*t838+2.3511
     8         897245373004d-1*t42*t61*t836+7.053569173611901d-2*t238*t4
     9         52*t61-7.617854707500852d+0*t251**3*t41/t60**4+7.61785470
     :         7500852d+0*t251*t41*t467*t470-6.34821225625071d-1*t239*t2
     ;         49*t42*t470+1.269642451250142d+0*t239*t42*t467*t468+4.232
     <         1415041671406d-1*t249*t251*t42*t453+1.0580353760417849d-1
     =         *t237*t238*t249*t251
            t845 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t248*t64*t8
     1         44-6.75476d-2*t64*t842*t843+1.709920934161365d+0*(6.21814
     2         d-2*t243*t57*t841+1.243628d-1*t57*t839*t840-3.10907d-2*t2
     3         35*t50*(-1.269642451250142d+0*t236*t41*(7.876233178997433
     4         d-1*t42*(-5.469606374303773d-2*t43*t837*t838-1.4585616998
     5         143394d-1*t238*t43*t836-7.424439106586571d-3*t835-1.31270
     6         55298329054d-1*t43*t452*t454)-5.469606374303773d-2*t44*t8
     7         37*t838-1.4585616998143394d-1*t238*t44*t836-3.93811658949
     8         87163d-1*t238*t239*t455-1.3127055298329054d-1*t44*t452*t4
     9         54+1.9690582947493582d-1*t237*t240*t454+2.625411059665811
     :         d-1*t238*t240*t453)+1.763392293402975d-2*t454*t46*t838+2.
     ;         3511897245373004d-1*t42*t46*t836+7.053569173611901d-2*t23
     <         8*t452*t46+7.617854707500852d+0*t241*t41*t450*t456-6.3482
     =         1225625071d-1*t236*t239*t42*t456+4.2321415041671406d-1*t2
     >         36*t241*t42*t453+1.269642451250142d+0*t239*t42*t450*t451-
     ?         7.617854707500852d+0*t241**3*t41/t45**4+1.058035376041784
     @         9d-1*t236*t237*t238*t241)-8.548627933030694d-3*t56*t834+4
     1         .1099018897499934d-3*t48*t834-1.865442d-1*t247*t458*t464*
     2         t57-6.21814d-2*t242**3*t50/t47**3+9.327209999999999d-2*t2
     3         42*t448*t457*t50-8.243319792565315d-3*t234*t243*t464+8.24
     4         3319792565315d-3*t234*t458*t459+3.96311967940178d-3*t234*
     5         t235*t457-3.96311967940178d-3*t234*t448*t449+1.0991093056
     6         753751d-2*t243*t247*t447-5.284159572535706d-3*t235*t242*t
     7         447)+2.4171930915078277d-3*t63*t834+1.013214d-1*t252*t465
     8         *t471*t64+2.33086476681112d-3*t234*t248*t471-2.3308647668
     9         1112d-3*t234*t465*t466-3.107819689081493d-3*t248*t252*t44
     :         7)+3.37738d-2*t248*t64*t844+6.75476d-2*t64*t842*t843-2.41
     ;         71930915078277d-3*t63*t834-1.013214d-1*t252*t465*t471*t64
     <         -2.33086476681112d-3*t234*t248*t471+2.33086476681112d-3*t
     =         234*t465*t466+3.107819689081493d-3*t248*t252*t447)-6.2181
     >         4d-2*t243*t57*t841-1.243628d-1*t57*t839*t840+8.5486279330
     ?         30694d-3*t56*t834+1.865442d-1*t247*t458*t464*t57+8.243319
     @         792565315d-3*t234*t243*t464-8.243319792565315d-3*t234*t45
     1         8*t459-1.0991093056753751d-2*t243*t247*t447
            t846 = rhob**5.000000000000002d-1
            t847 = 1/rhob**6.666666666666665d-1
            t848 = 1/rhob**1.8333333333333332d+0
            t849 = t253**3
            t850 = exp(-2.4256569070538234d+2*t65)
            t851 = 8.619732841431575d+5*gammabb*t105*t849*t850/t107**4
            t852 = -2.4874964680519085d+4*gammabb*t255*t256*t475*t476*t4
     1         77
            t853 = -8.619732841431575d+5*gammabb*t105*t476*t477*t849
            t854 = 1.0660699148793894d+4*gammabb*t105*t253*t472*t476*t47
     1         7
            t855 = -1.035785462955064d+1*gammabb*t108*t263*t846
            t856 = 1.1097701388804264d+0*gammabb*t108*t288*t847
            t857 = 8.807699514924018d-2*gammabb*t108*t256*t848
            t858 = 5.383843205234772d+2*gammabb*t106*t253*t258*t288*t473
            t859 = -2.563734859635607d+1*gammabb*t106*t253*t256*t258*t47
     1         4
            t860 = 1.2437482340259542d+4*gammabb*t106*t255*t256*t258*t47
     1         5
            t861 = -1.5382409157813634d+2*gammabb*t106*t255*t256*t258*t4
     1         72
            t862 = 1.436622140238596d+5*gammabb*t105*t106*t258*t849
            t863 = -5.330349574396946d+3*gammabb*t105*t106*t253*t258*t47
     1         2
            t864 = 2.1974870225448048d+1*gammabb*t105*t106*t258*t845
            t865 = 1/t104**7.0d+0
            t866 = 1/t113**4
            t867 = 1/t115**3
            t868 = t268**3
            t869 = t645+t639
            t870 = t269**3
            t871 = t644+t640
            t872 = 5.848223622634648d-1*t84*(-12*t199*t371*t93+t722+t662
     1         +t661+t660+t659+t658+t657+t656+t655+t654+t653+t651+t650+t
     2         649-240*t101*t199*t374+96*t195*t197*t199)+5.8482236226346
     3         48d-1*t102*(2.564881401242048d+0*t208*t871-5.699736447204
     4         55d-1*t643*t870+2.564881401242048d+0*t205*t869-5.69973644
     5         720455d-1*t638*t868+2.5648814012420473d+0*t269*t386*t498+
     6         2.5648814012420473d+0*t268*t380*t496)+t636+t634+t633+t632
     7         +t626+t625+t624+1.7544670867903944d+0*t267*t499+1.7544670
     8         867903944d+0*t270*t494
            t873 = t272**3
            t874 = 3.333333333333333d-1*t214*t871+1.4814814814814814d-1*
     1         t667*t870+3.333333333333333d-1*t213*t869+1.48148148148148
     2         14d-1*t666*t868-3.333333333333333d-1*t269*t394*t498-3.333
     3         333333333333d-1*t268*t393*t496
            t875 = -4.1090628005491736d+0*t121*t123*t129*t229*t873
            t876 = 3.08179710041188d+0*t121*t123*t129*t132*t272*t502
            t877 = -7.190859900961053d+0*t121*t129*t132*t216*t217*t501
            t878 = -3.4242190004576445d-1*t121*t123*t126*t129*t874
            t879 = 2.396953300320351d+0*t121*t126*t129*t216*t217*t502
            t880 = -8.389336551121229d+0*t121*t126*t129*t272*t282*t396
            t881 = 3.9949221672005863d-1*t121*t126*t129*t217*t272*t398
            t882 = 1.0272657001372934d+0*t121*t123*t126*t127*t221*t272*t
     1         506
            t883 = 1.1984766501601755d+0*t121*t125*t127*t216*t217*t221*t
     1         506
            t884 = -3.08179710041188d+0*t121*t123*t127*t132*t221*t274*t5
     1         01
            t885 = 1.0272657001372934d+0*t121*t123*t126*t127*t221*t274*t
     1         502
            t886 = -4.793906600640702d+0*t121*t126*t127*t216*t217*t221*t
     1         272*t274
            t887 = -4.1946682755606146d+0*t121*t125*t127*t221*t274*t282*
     1         t396
            t888 = 1.9974610836002932d-1*t121*t125*t127*t217*t221*t274*t
     1         398
            t889 = 1.0272657001372934d+0*t121*t123*t125*t274*t409*t410*t
     1         506
            t890 = -5.136328500686467d-1*t121*t123*t125*t127*t221*t274*t
     1         506
            t891 = 3.4242190004576445d-1*t121*t123*t125*t409*t410*t510*t
     1         783
            t892 = 1.2128284535269115d+2*t103*t132*t874+2.42565690705382
     1         3d+3*t103*t418*t873-4.042761511756372d+1*t126*t872-1.4553
     2         94144232294d+3*t103*t229*t272*t502+3.638485360580735d+2*t
     3         132*t271*t502-1.455394144232294d+3*t229*t271*t501+3.63848
     4         5360580735d+2*t132*t272*t500
            t893 = -1.7121095002288222d-1*t121*t123*t125*t127*t221*t892
            t894 = -2.0545314002745868d+0*t121*t123*t126*t272*t409*t410*
     1         t510
            t895 = -2.396953300320351d+0*t121*t125*t216*t217*t409*t410*t
     1         510
            t896 = 1.0272657001372934d+0*t121*t123*t126*t127*t221*t272*t
     1         510
            t897 = 1.1984766501601755d+0*t121*t125*t127*t216*t217*t221*t
     1         510
            t898 = t274**3
            t899 = -1.0272657001372934d+0*t121*t123*t125*t702*t703*t898
            t900 = 3.4242190004576445d-1*t121*t123*t125*t409*t410*t898
            t901 = -1.7121095002288222d-1*t121*t123*t125*t127*t221*t898
            t902 = 3.553566382931298d+3*t28*t319*t320*t321
            t903 = 2.2195402777608514d+0*t279*t31*t317
            t904 = -1.0569239417908823d-1*t161*t31*t318
            t905 = -1.0254939438542422d+2*t158*t160*t161*t163*t29
            t906 = -1.776783191465649d+3*t163*t28*t29*t319
            t907 = 2.1974870225448048d+1*t163*t28*t29*t316
            t908 = -1.398222758520205d+0*t121*t125*t131*t225*t282*t283*t
     1         396
            t909 = 6.658203612000978d-2*t121*t125*t131*t217*t225*t283*t3
     1         98
            t910 = 1.5979688668802342d+0*t126*t131*t136*t215*t216*t217
            t911 = 1.398222758520205d+0*t125*t131*t136*t282*t396
            t912 = -6.658203612000978d-2*t125*t131*t136*t217*t398
            t913 = 2.735897678055535d-1*t121*t129*t136*t215*t216*t227*t2
     1         29
            t914 = 2.3939104682985932d-1*t121*t129*t132*t136*t396*t415
            t915 = -1.1399573658564734d-2*t121*t129*t132*t136*t227*t398
            t916 = -7.98984433440117d-1*t125*t136*t216*t217*t224
            t917 = 7.98984433440117d-1*t125*t131*t216*t217*t225*t231
            t918 = 1.3679488390277675d-1*t121*t129*t132*t216*t225*t227*t
     1         231
            t919 = 1.0272657001372934d+0*t123*t129*t132*t392
            t920 = -3.4242190004576445d-1*t123*t126*t129*t395
            t921 = 1.5979688668802342d+0*t126*t129*t215*t216*t217
            t922 = 1.398222758520205d+0*t125*t129*t282*t396
            t923 = -6.658203612000978d-2*t125*t129*t217*t398
            t924 = -1.7121095002288222d-1*t123*t125*t127*t221*t405
            t925 = 6.848438000915289d-1*t123*t126*t127*t215*t221*t222
            t926 = 7.98984433440117d-1*t125*t127*t216*t217*t221*t222
            t927 = 3.4242190004576445d-1*t123*t125*t409*t410*t411
            t928 = -1.7121095002288222d-1*t123*t125*t127*t221*t411
            t929 = 2.188718142444428d+0*t121*t134*t215*t216*t227*t229
            t930 = 1.5959403121990623d+0*t121*t132*t134*t396*t415
            t931 = -4.5598294634258935d-2*t121*t132*t134*t227*t398
            t932 = 1.094359071222214d+0*t121*t127*t132*t216*t222*t227*t2
     1         30
            t933 = t212*(2.473556743557577d-2*t120*t66*(-1.7121095002288
     1         222d-1*t121*t123*t125*t131*t225*(t932+t931+t930+t929+t928
     2         +t927+t926+t925+t924+t923+t922+t921+t920+t919+3.517582728
     3         928545d-1*t121*t132*t282*t409*t411*t419+1.172527576309514
     4         8d+0*t121*t134*t282*t392*t418-1.172527576309515d-1*t121*t
     5         127*t132*t230*t282*t411-1.172527576309515d-1*t121*t127*t1
     6         32*t230*t282*t405-2.34505515261903d-1*t121*t134*t229*t282
     7         *t395+9.38022061047612d-1*t121*t127*t215*t222*t229*t230*t
     8         282)+1.7121095002288222d-1*t121*t123*t125*t136*(t928+t927
     9         +t926+t925+t924+t923+t922+t921+t920+t919)+t918+t917+t916+
     :         t915+t914+t913+t912+t911+t910+t909+t908-1.027265700137293
     ;         4d+0*t121*t123*t125*t131*t283*t422*t714+6.848438000915289
     <         d-1*t121*t123*t125*t131*t231*t421*t535-3.4242190004576445
     =         d-1*t121*t123*t125*t224*t225*t535+7.98984433440117d-1*t12
     >         1*t125*t131*t216*t217*t225*t535+6.848438000915289d-1*t121
     ?         *t123*t126*t131*t215*t225*t535-3.4242190004576445d-1*t121
     @         *t123*t125*t225*t231*t533-7.98984433440117d-1*t121*t125*t
     1         136*t216*t217*t533-6.848438000915289d-1*t121*t123*t126*t1
     2         36*t215*t533+5.862637881547574d-2*t121*t129*t132*t282*t42
     3         1*t422+3.4242190004576445d-1*t123*t125*t131*t421*t422+3.4
     4         242190004576445d-1*t121*t123*t125*t131*t283*t420*t421+6.8
     5         48438000915289d-1*t121*t123*t125*t224*t231*t283*t421-1.59
     6         79688668802342d+0*t121*t125*t131*t216*t217*t231*t283*t421
     7         -1.3696876001830577d+0*t121*t123*t126*t131*t215*t231*t283
     8         *t421-2.931318940773787d-2*t121*t129*t132*t225*t282*t420-
     9         1.7121095002288222d-1*t123*t125*t131*t225*t420+1.75879136
     :         44642725d-1*t121*t129*t136*t282*t392*t418-1.7121095002288
     ;         222d-1*t121*t123*t125*t225*t283*t414+1.7121095002288222d-
     <         1*t123*t125*t136*t414+3.4242190004576445d-1*t121*t123*t12
     =         6*t131*t225*t283*t395-5.862637881547574d-2*t121*t129*t136
     >         *t229*t282*t395-3.4242190004576445d-1*t123*t126*t131*t136
     ?         *t395-1.0272657001372934d+0*t121*t123*t131*t132*t225*t283
     @         *t392+1.0272657001372934d+0*t123*t131*t132*t136*t392+7.98
     1         984433440117d-1*t121*t125*t216*t217*t224*t225*t283+6.8484
     2         38000915289d-1*t121*t123*t126*t215*t224*t225*t283-1.59796
     3         88668802342d+0*t121*t126*t131*t215*t216*t217*t225*t283+1.
     4         172527576309515d-1*t121*t129*t215*t225*t229*t231*t282-3.4
     5         242190004576445d-1*t123*t125*t224*t225*t231+6.84843800091
     6         5289d-1*t123*t126*t131*t215*t225*t231-6.848438000915289d-
     7         1*t123*t126*t136*t215*t224)+1.4841340461345462d-1*t124*t2
     8         15*t536*t66+7.420670230672731d-2*t124*t284*t395*t66+1.484
     9         1340461345462d-1*t119*t284*t392*t66+4.947113487115154d-2*
     :         t120*t536+1.4841340461345462d-1*t124*t215*t284)
            t934 = t425*(-4.947113487115154d-2*t120*t232*t536*t66-t284*t
     1         424)
            t935 = 4.947113487115154d-2*t120*t284*t426*t66*t716
            t936 = -1.398222758520205d+0*t121*t125*t131*t225*t282*t286*t
     1         396
            t937 = 6.658203612000978d-2*t121*t125*t131*t217*t225*t286*t3
     1         98
            t938 = 2.79644551704041d+0*t125*t131*t136*t282*t396
            t939 = -1.3316407224001955d-1*t125*t131*t136*t217*t398
            t940 = 4.7878209365971863d-1*t121*t129*t132*t136*t396*t415
            t941 = -2.2799147317129467d-2*t121*t129*t132*t136*t227*t398
            t942 = 2.0545314002745868d+0*t123*t129*t132*t392
            t943 = -6.848438000915289d-1*t123*t126*t129*t395
            t944 = 3.1959377337604683d+0*t126*t129*t215*t216*t217
            t945 = 2.79644551704041d+0*t125*t129*t282*t396
            t946 = -1.3316407224001955d-1*t125*t129*t217*t398
            t947 = -3.4242190004576445d-1*t123*t125*t127*t221*t405
            t948 = 1.3696876001830577d+0*t123*t126*t127*t215*t221*t222
            t949 = 1.5979688668802342d+0*t125*t127*t216*t217*t221*t222
            t950 = 6.848438000915289d-1*t123*t125*t409*t410*t411
            t951 = -3.4242190004576445d-1*t123*t125*t127*t221*t411
            t952 = 3.1918806243981246d+0*t121*t132*t134*t396*t415
            t953 = -9.119658926851787d-2*t121*t132*t134*t227*t398
            t954 = 1.0272657001372934d+0*t123*t129*t132*t215*t272
            t955 = -3.4242190004576445d-1*t123*t126*t129*t430
            t956 = 7.98984433440117d-1*t126*t129*t216*t217*t272
            t957 = 7.98984433440117d-1*t126*t129*t215*t216*t217
            t958 = -1.7121095002288222d-1*t123*t125*t127*t221*t435
            t959 = 3.4242190004576445d-1*t123*t126*t127*t215*t221*t274
            t960 = 3.994922167200585d-1*t125*t127*t216*t217*t221*t274
            t961 = 3.4242190004576445d-1*t123*t126*t127*t221*t222*t272
            t962 = 3.994922167200585d-1*t125*t127*t216*t217*t221*t222
            t963 = 3.4242190004576445d-1*t123*t125*t222*t274*t409*t410
            t964 = -1.7121095002288222d-1*t123*t125*t127*t221*t222*t274
            t965 = (t212*(2.473556743557577d-2*t120*t66*(-1.712109500228
     1         8222d-1*t121*t123*t125*t131*t225*(t964+t963+t962+t961+t96
     2         0+t959+t958+t957+t956+t955+t954+t931+t930+t923+t922-1.172
     3         527576309515d-1*t121*t127*t132*t230*t282*t435-2.345055152
     4         61903d-1*t121*t134*t229*t282*t430+3.517582728928545d-1*t1
     5         21*t132*t222*t274*t282*t409*t419+1.1725275763095148d+0*t1
     6         21*t134*t215*t272*t282*t418+4.69011030523806d-1*t121*t127
     7         *t215*t229*t230*t274*t282-1.172527576309515d-1*t121*t127*
     8         t132*t222*t230*t274*t282+4.69011030523806d-1*t121*t127*t2
     9         22*t229*t230*t272*t282+5.47179535611107d-1*t121*t127*t132
     :         *t216*t227*t230*t274+1.094359071222214d+0*t121*t134*t216*
     ;         t227*t229*t272+5.47179535611107d-1*t121*t127*t132*t216*t2
     <         22*t227*t230+1.094359071222214d+0*t121*t134*t215*t216*t22
     =         7*t229)+1.7121095002288222d-1*t121*t123*t125*t136*(t964+t
     >         963+t962+t961+t960+t959+t958+t957+t956+t955+t954+t923+t92
     ?         2)+t915+t914+t912+t911+t909+t908-1.0272657001372934d+0*t1
     @         21*t123*t125*t131*t231*t277*t283*t714+3.4242190004576445d
     1         -1*t121*t123*t125*t131*t231*t421*t555-1.7121095002288222d
     2         -1*t121*t123*t125*t224*t225*t555+3.994922167200585d-1*t12
     3         1*t125*t131*t216*t217*t225*t555+3.4242190004576445d-1*t12
     4         1*t123*t126*t131*t215*t225*t555-1.7121095002288222d-1*t12
     5         1*t123*t125*t225*t231*t554-3.994922167200585d-1*t121*t125
     6         *t136*t216*t217*t554-3.4242190004576445d-1*t121*t123*t126
     7         *t136*t215*t554+3.4242190004576445d-1*t121*t123*t125*t131
     8         *t277*t421*t535-1.7121095002288222d-1*t121*t123*t125*t225
     9         *t276*t535+3.4242190004576445d-1*t121*t123*t126*t131*t225
     :         *t272*t535+3.994922167200585d-1*t121*t125*t131*t216*t217*
     ;         t225*t535-1.7121095002288222d-1*t121*t123*t125*t225*t277*
     <         t533-3.4242190004576445d-1*t121*t123*t126*t136*t272*t533-
     =         3.994922167200585d-1*t121*t125*t136*t216*t217*t533+3.4242
     >         190004576445d-1*t121*t123*t125*t131*t283*t421*t444-2.9313
     ?         18940773787d-2*t121*t129*t132*t225*t282*t444-1.7121095002
     @         288222d-1*t123*t125*t131*t225*t444-1.7121095002288222d-1*
     1         t121*t123*t125*t225*t283*t443+1.7121095002288222d-1*t123*
     2         t125*t136*t443+3.4242190004576445d-1*t121*t123*t126*t131*
     3         t225*t283*t430-5.862637881547574d-2*t121*t129*t136*t229*t
     4         282*t430-3.4242190004576445d-1*t123*t126*t131*t136*t430+3
     5         .4242190004576445d-1*t121*t123*t125*t224*t277*t283*t421-7
     6         .98984433440117d-1*t121*t125*t131*t216*t217*t277*t283*t42
     7         1-6.848438000915289d-1*t121*t123*t126*t131*t215*t277*t283
     8         *t421+3.4242190004576445d-1*t121*t123*t125*t231*t276*t283
     9         *t421-6.848438000915289d-1*t121*t123*t126*t131*t231*t272*
     :         t283*t421-7.98984433440117d-1*t121*t125*t131*t216*t217*t2
     ;         31*t283*t421+5.862637881547574d-2*t121*t129*t132*t231*t27
     <         7*t282*t421+3.4242190004576445d-1*t123*t125*t131*t231*t27
     =         7*t421+1.7587913644642725d-1*t121*t129*t136*t215*t272*t28
     >         2*t418+3.994922167200585d-1*t121*t125*t216*t217*t225*t276
     ?         *t283+3.4242190004576445d-1*t121*t123*t126*t215*t225*t276
     @         *t283+3.4242190004576445d-1*t121*t123*t126*t224*t225*t272
     1         *t283-7.98984433440117d-1*t121*t126*t131*t216*t217*t225*t
     2         272*t283-1.0272657001372934d+0*t121*t123*t131*t132*t215*t
     3         225*t272*t283+3.994922167200585d-1*t121*t125*t216*t217*t2
     4         24*t225*t283-7.98984433440117d-1*t121*t126*t131*t215*t216
     5         *t217*t225*t283+5.862637881547574d-2*t121*t129*t215*t225*
     6         t229*t277*t282+5.862637881547574d-2*t121*t129*t225*t229*t
     7         231*t272*t282+6.839744195138837d-2*t121*t129*t132*t216*t2
     8         25*t227*t277-1.7121095002288222d-1*t123*t125*t224*t225*t2
     9         77+3.994922167200585d-1*t125*t131*t216*t217*t225*t277+3.4
     :         242190004576445d-1*t123*t126*t131*t215*t225*t277-1.712109
     ;         5002288222d-1*t123*t125*t225*t231*t276-3.994922167200585d
     <         -1*t125*t136*t216*t217*t276-3.4242190004576445d-1*t123*t1
     =         26*t136*t215*t276+3.4242190004576445d-1*t123*t126*t131*t2
     >         25*t231*t272+1.3679488390277675d-1*t121*t129*t136*t216*t2
     ?         27*t229*t272-3.4242190004576445d-1*t123*t126*t136*t224*t2
     @         72+7.98984433440117d-1*t126*t131*t136*t216*t217*t272+1.02
     1         72657001372934d+0*t123*t131*t132*t136*t215*t272+6.8397441
     2         95138837d-2*t121*t129*t132*t216*t225*t227*t231+3.99492216
     3         7200585d-1*t125*t131*t216*t217*t225*t231+1.36794883902776
     4         75d-1*t121*t129*t136*t215*t216*t227*t229-3.99492216720058
     5         5d-1*t125*t136*t216*t217*t224+7.98984433440117d-1*t126*t1
     6         31*t136*t215*t216*t217)+7.420670230672731d-2*t124*t215*t5
     7         56*t66+7.420670230672731d-2*t124*t272*t536*t66+7.42067023
     8         0672731d-2*t124*t284*t430*t66+1.4841340461345462d-1*t119*
     9         t215*t272*t284*t66+2.473556743557577d-2*t120*t556+2.47355
     :         6743557577d-2*t120*t536+7.420670230672731d-2*t124*t272*t2
     ;         84+7.420670230672731d-2*t124*t215*t284)+4.947113487115154
     <         d-2*t120*t232*t278*t284*t66*t716+t425*(-2.473556743557577
     =         d-2*t120*t232*t556*t66-2.473556743557577d-2*t120*t278*t53
     >         6*t66-t284*t446))*wght
            t966 = 1.5979688668802342d+0*t126*t131*t136*t216*t217*t272
            t967 = 2.735897678055535d-1*t121*t129*t136*t216*t227*t229*t2
     1         72
            t968 = -7.98984433440117d-1*t125*t136*t216*t217*t276
            t969 = 7.98984433440117d-1*t125*t131*t216*t217*t225*t277
            t970 = 1.3679488390277675d-1*t121*t129*t132*t216*t225*t227*t
     1         277
            t971 = 2.0545314002745868d+0*t123*t129*t132*t215*t272
            t972 = -6.848438000915289d-1*t123*t126*t129*t430
            t973 = 1.5979688668802342d+0*t126*t129*t216*t217*t272
            t974 = -3.4242190004576445d-1*t123*t125*t127*t221*t435
            t975 = 6.848438000915289d-1*t123*t126*t127*t215*t221*t274
            t976 = 7.98984433440117d-1*t125*t127*t216*t217*t221*t274
            t977 = 6.848438000915289d-1*t123*t126*t127*t221*t222*t272
            t978 = 6.848438000915289d-1*t123*t125*t222*t274*t409*t410
            t979 = -3.4242190004576445d-1*t123*t125*t127*t221*t222*t274
            t980 = 2.188718142444428d+0*t121*t134*t216*t227*t229*t272
            t981 = 1.094359071222214d+0*t121*t127*t132*t216*t227*t230*t2
     1         74
            t982 = 1.0272657001372934d+0*t123*t129*t132*t501
            t983 = -3.4242190004576445d-1*t123*t126*t129*t502
            t984 = -1.7121095002288222d-1*t123*t125*t127*t221*t506
            t985 = 6.848438000915289d-1*t123*t126*t127*t221*t272*t274
            t986 = 3.4242190004576445d-1*t123*t125*t409*t410*t510
            t987 = -1.7121095002288222d-1*t123*t125*t127*t221*t510
            t988 = t212*(2.473556743557577d-2*t120*t66*(-1.7121095002288
     1         222d-1*t121*t123*t125*t131*t225*(t987+t986+t985+t984+t983
     2         +t982+t981+t980+t976+t973+t931+t930+t923+t922+3.517582728
     3         928545d-1*t121*t132*t282*t409*t419*t510-1.172527576309515
     4         d-1*t121*t127*t132*t230*t282*t510-1.172527576309515d-1*t1
     5         21*t127*t132*t230*t282*t506-2.34505515261903d-1*t121*t134
     6         *t229*t282*t502+1.1725275763095148d+0*t121*t134*t282*t418
     7         *t501+9.38022061047612d-1*t121*t127*t229*t230*t272*t274*t
     8         282)+1.7121095002288222d-1*t121*t123*t125*t136*(t987+t986
     9         +t985+t984+t983+t982+t976+t973+t923+t922)+t970+t969+t968+
     :         t967+t966+t915+t914+t912+t911+t909+t908-1.027265700137293
     ;         4d+0*t121*t123*t125*t131*t283*t515*t714+6.848438000915289
     <         d-1*t121*t123*t125*t131*t277*t421*t555-3.4242190004576445
     =         d-1*t121*t123*t125*t225*t276*t555+6.848438000915289d-1*t1
     >         21*t123*t126*t131*t225*t272*t555+7.98984433440117d-1*t121
     ?         *t125*t131*t216*t217*t225*t555-3.4242190004576445d-1*t121
     @         *t123*t125*t225*t277*t554-6.848438000915289d-1*t121*t123*
     1         t126*t136*t272*t554-7.98984433440117d-1*t121*t125*t136*t2
     2         16*t217*t554+5.862637881547574d-2*t121*t129*t132*t282*t42
     3         1*t515+3.4242190004576445d-1*t123*t125*t131*t421*t515+3.4
     4         242190004576445d-1*t121*t123*t125*t131*t283*t421*t514-2.9
     5         31318940773787d-2*t121*t129*t132*t225*t282*t514-1.7121095
     6         002288222d-1*t123*t125*t131*t225*t514-1.7121095002288222d
     7         -1*t121*t123*t125*t225*t283*t513+1.7121095002288222d-1*t1
     8         23*t125*t136*t513+3.4242190004576445d-1*t121*t123*t126*t1
     9         31*t225*t283*t502-5.862637881547574d-2*t121*t129*t136*t22
     :         9*t282*t502-3.4242190004576445d-1*t123*t126*t131*t136*t50
     ;         2+1.7587913644642725d-1*t121*t129*t136*t282*t418*t501-1.0
     <         272657001372934d+0*t121*t123*t131*t132*t225*t283*t501+1.0
     =         272657001372934d+0*t123*t131*t132*t136*t501+6.84843800091
     >         5289d-1*t121*t123*t125*t276*t277*t283*t421-1.369687600183
     ?         0577d+0*t121*t123*t126*t131*t272*t277*t283*t421-1.5979688
     @         668802342d+0*t121*t125*t131*t216*t217*t277*t283*t421+6.84
     1         8438000915289d-1*t121*t123*t126*t225*t272*t276*t283+7.989
     2         84433440117d-1*t121*t125*t216*t217*t225*t276*t283-1.59796
     3         88668802342d+0*t121*t126*t131*t216*t217*t225*t272*t283+1.
     4         172527576309515d-1*t121*t129*t225*t229*t272*t277*t282-3.4
     5         242190004576445d-1*t123*t125*t225*t276*t277+6.84843800091
     6         5289d-1*t123*t126*t131*t225*t272*t277-6.848438000915289d-
     7         1*t123*t126*t136*t272*t276)+1.4841340461345462d-1*t124*t2
     8         72*t556*t66+7.420670230672731d-2*t124*t284*t502*t66+1.484
     9         1340461345462d-1*t119*t284*t501*t66+4.947113487115154d-2*
     :         t120*t556+1.4841340461345462d-1*t124*t272*t284)
            t989 = t425*(-4.947113487115154d-2*t120*t278*t556*t66-t284*t
     1         517)
            t990 = 4.947113487115154d-2*t120*t284*t518*t66*t716
            t991 = 2.0545314002745868d+0*t123*t129*t132*t501
            t992 = -6.848438000915289d-1*t123*t126*t129*t502
            t993 = 3.1959377337604683d+0*t126*t129*t216*t217*t272
            t994 = -3.4242190004576445d-1*t123*t125*t127*t221*t506
            t995 = 1.3696876001830577d+0*t123*t126*t127*t221*t272*t274
            t996 = 1.5979688668802342d+0*t125*t127*t216*t217*t221*t274
            t997 = 6.848438000915289d-1*t123*t125*t409*t410*t510
            t998 = -3.4242190004576445d-1*t123*t125*t127*t221*t510
            t999 = 3.553566382931298d+3*t105*t475*t476*t477
            t1000 = 2.2195402777608514d+0*t108*t288*t473
            t1001 = -1.0569239417908823d-1*t108*t256*t474
            t1002 = -1.0254939438542422d+2*t106*t253*t255*t256*t258
            t1003 = -1.776783191465649d+3*t105*t106*t258*t475
            t1004 = 2.1974870225448048d+1*t105*t106*t258*t472
            t1005 = 4.947113487115154d-2*t120*t232*t574*t66*t716
            t1006 = 2.473556743557577d-2*t120*t579
            t1007 = -7.98984433440117d-1*t121*t125*t131*t216*t217*t421*t
     1         576
            t1008 = 6.848438000915289d-1*t123*t126*t131*t215*t225*t283
            t1009 = 7.98984433440117d-1*t125*t131*t216*t217*t225*t283
            t1010 = 2.3420782031264287d-2*t121*t131*t134*t216*t225*t418*
     1         t708
            t1011 = 1.172527576309515d-1*t121*t129*t215*t225*t229*t282*t
     1         283
            t1012 = 1.3679488390277675d-1*t121*t129*t132*t216*t225*t227*
     1         t283
            t1013 = -1.3679488390277675d-1*t129*t132*t136*t216*t227
            t1014 = -2.735897678055535d-1*t132*t134*t216*t227
            t1015 = 3.4242190004576445d-1*t123*t125*t136*t533
            t1016 = -3.4242190004576445d-1*t123*t125*t131*t225*t535
            t1017 = -5.862637881547574d-2*t121*t129*t132*t225*t282*t535
            t1018 = -3.4242190004576445d-1*t123*t125*t224*t225*t283
            t1019 = 6.848438000915289d-1*t123*t125*t131*t231*t283*t421
            t1020 = 1.172527576309515d-1*t121*t129*t132*t231*t282*t283*t
     1         421
            t1021 = t212*(2.473556743557577d-2*t120*t66*(-1.027265700137
     1         2934d+0*t121*t123*t125*t131*t231*t576*t714+2.007495602679
     2         796d-2*t121*t131*t134*t215*t225*t415*t712+3.4242190004576
     3         445d-1*t121*t123*t125*t224*t421*t576-6.848438000915289d-1
     4         *t121*t123*t126*t131*t215*t421*t576+6.848438000915289d-1*
     5         t121*t123*t125*t131*t283*t421*t535-3.4242190004576445d-1*
     6         t121*t123*t125*t225*t283*t533+2.007495602679796d-2*t121*t
     7         131*t134*t231*t415*t418*t421-1.003747801339898d-2*t121*t1
     8         34*t224*t225*t415*t418-1.7121095002288222d-1*t121*t123*t1
     9         25*t131*t225*(-1.172527576309515d-1*t127*t132*t222*t230*t
     :         282-2.34505515261903d-1*t134*t215*t229*t282+t1014)-5.8626
     ;         37881547574d-2*t129*t132*t225*t231*t282-1.172527576309515
     <         d-1*t129*t136*t215*t229*t282+t1020+t1019+t1018+t1017+t101
     =         6+t1015+t1013+t1012+t1011+t1010+t1009+t1008+t1007)+7.4206
     >         70230672731d-2*t124*t215*t579*t66+t1006)
            t1022 = t425*(-2.473556743557577d-2*t120*t232*t579*t66-2.473
     1         556743557577d-2*t120*t284*t536*t66-t284*t537)
            t1023 = 4.947113487115154d-2*t120*t232*t284*t287*t66*t716
            t1024 = 2.473556743557577d-2*t120*t581
            t1025 = -7.98984433440117d-1*t121*t125*t131*t216*t217*t283*t
     1         286*t421
            t1026 = 3.994922167200585d-1*t125*t131*t216*t217*t225*t286
            t1027 = 4.6841564062528573d-2*t121*t131*t134*t216*t225*t418*
     1         t708
            t1028 = 6.839744195138837d-2*t121*t129*t132*t216*t225*t227*t
     1         286
            t1029 = -2.735897678055535d-1*t129*t132*t136*t216*t227
            t1030 = -5.47179535611107d-1*t132*t134*t216*t227
            t1031 = t212*(2.473556743557577d-2*t120*t66*(-1.027265700137
     1         2934d+0*t121*t123*t125*t131*t231*t283*t286*t714+4.0149912
     2         05359592d-2*t121*t131*t134*t215*t225*t415*t712+3.42421900
     3         04576445d-1*t121*t123*t125*t131*t283*t421*t548-2.93131894
     4         0773787d-2*t121*t129*t132*t225*t282*t548-1.71210950022882
     5         22d-1*t123*t125*t131*t225*t548-1.7121095002288222d-1*t121
     6         *t123*t125*t225*t283*t546+1.7121095002288222d-1*t123*t125
     7         *t136*t546+3.4242190004576445d-1*t121*t123*t125*t131*t286
     8         *t421*t535-1.7121095002288222d-1*t121*t123*t125*t225*t286
     9         *t533+4.014991205359592d-2*t121*t131*t134*t231*t415*t418*
     :         t421+3.4242190004576445d-1*t121*t123*t125*t224*t283*t286*
     ;         t421-6.848438000915289d-1*t121*t123*t126*t131*t215*t283*t
     <         286*t421+5.862637881547574d-2*t121*t129*t132*t231*t282*t2
     =         86*t421+3.4242190004576445d-1*t123*t125*t131*t231*t286*t4
     >         21-2.007495602679796d-2*t121*t134*t224*t225*t415*t418+5.8
     ?         62637881547574d-2*t121*t129*t215*t225*t229*t282*t286-1.71
     @         21095002288222d-1*t123*t125*t224*t225*t286+3.424219000457
     1         6445d-1*t123*t126*t131*t215*t225*t286-1.7121095002288222d
     2         -1*t121*t123*t125*t131*t225*(-2.34505515261903d-1*t127*t1
     3         32*t222*t230*t282-4.69011030523806d-1*t134*t215*t229*t282
     4         +t1030)-1.172527576309515d-1*t129*t132*t225*t231*t282-2.3
     5         4505515261903d-1*t129*t136*t215*t229*t282+t1029+t1028+t10
     6         27+t1026+t1025+t1020+t1019+t1018+t1017+t1016+t1015+t1012+
     7         t1011+t1009+t1008)+7.420670230672731d-2*t124*t215*t581*t6
     8         6+t1024)
            t1032 = -2.473556743557577d-2*t120*t232*t581*t66
            t1033 = (t1022+t1021+t1005)*wght
            t1034 = 2.473556743557577d-2*t120*t584
            t1035 = -7.98984433440117d-1*t121*t125*t131*t216*t217*t421*t
     1         583
            t1036 = 1.5979688668802342d+0*t125*t131*t216*t217*t225*t286
            t1037 = 9.368312812505715d-2*t121*t131*t134*t216*t225*t418*t
     1         708
            t1038 = 2.735897678055535d-1*t121*t129*t132*t216*t225*t227*t
     1         286
            t1039 = -5.47179535611107d-1*t129*t132*t136*t216*t227
            t1040 = -1.094359071222214d+0*t132*t134*t216*t227
            t1041 = 4.947113487115154d-2*t120*t278*t574*t66*t716
            t1042 = 6.848438000915289d-1*t123*t126*t131*t225*t272*t283
            t1043 = 1.172527576309515d-1*t121*t129*t225*t229*t272*t282*t
     1         283
            t1044 = 3.4242190004576445d-1*t123*t125*t136*t554
            t1045 = -3.4242190004576445d-1*t123*t125*t131*t225*t555
            t1046 = -5.862637881547574d-2*t121*t129*t132*t225*t282*t555
            t1047 = -3.4242190004576445d-1*t123*t125*t225*t276*t283
            t1048 = 6.848438000915289d-1*t123*t125*t131*t277*t283*t421
            t1049 = 1.172527576309515d-1*t121*t129*t132*t277*t282*t283*t
     1         421
            t1050 = t212*(2.473556743557577d-2*t120*t66*(-1.027265700137
     1         2934d+0*t121*t123*t125*t131*t277*t576*t714+2.007495602679
     2         796d-2*t121*t131*t134*t225*t272*t415*t712+3.4242190004576
     3         445d-1*t121*t123*t125*t276*t421*t576-6.848438000915289d-1
     4         *t121*t123*t126*t131*t272*t421*t576+6.848438000915289d-1*
     5         t121*t123*t125*t131*t283*t421*t555-3.4242190004576445d-1*
     6         t121*t123*t125*t225*t283*t554+2.007495602679796d-2*t121*t
     7         131*t134*t277*t415*t418*t421-1.003747801339898d-2*t121*t1
     8         34*t225*t276*t415*t418-1.7121095002288222d-1*t121*t123*t1
     9         25*t131*t225*(-1.172527576309515d-1*t127*t132*t230*t274*t
     :         282-2.34505515261903d-1*t134*t229*t272*t282+t1014)-5.8626
     ;         37881547574d-2*t129*t132*t225*t277*t282-1.172527576309515
     <         d-1*t129*t136*t229*t272*t282+t1049+t1048+t1047+t1046+t104
     =         5+t1044+t1043+t1042+t1013+t1012+t1010+t1009+t1007)+7.4206
     >         70230672731d-2*t124*t272*t579*t66+t1006)
            t1051 = t425*(-2.473556743557577d-2*t120*t278*t579*t66-2.473
     1         556743557577d-2*t120*t284*t556*t66-t284*t557)
            t1052 = (t1051+t1050+t1041)*wght
            t1053 = 4.947113487115154d-2*t120*t278*t284*t287*t66*t716
            t1054 = t212*(2.473556743557577d-2*t120*t66*(-1.027265700137
     1         2934d+0*t121*t123*t125*t131*t277*t283*t286*t714+4.0149912
     2         05359592d-2*t121*t131*t134*t225*t272*t415*t712+3.42421900
     3         04576445d-1*t121*t123*t125*t131*t283*t421*t562-2.93131894
     4         0773787d-2*t121*t129*t132*t225*t282*t562-1.71210950022882
     5         22d-1*t123*t125*t131*t225*t562-1.7121095002288222d-1*t121
     6         *t123*t125*t225*t283*t561+1.7121095002288222d-1*t123*t125
     7         *t136*t561+3.4242190004576445d-1*t121*t123*t125*t131*t286
     8         *t421*t555-1.7121095002288222d-1*t121*t123*t125*t225*t286
     9         *t554+4.014991205359592d-2*t121*t131*t134*t277*t415*t418*
     :         t421+3.4242190004576445d-1*t121*t123*t125*t276*t283*t286*
     ;         t421-6.848438000915289d-1*t121*t123*t126*t131*t272*t283*t
     <         286*t421+5.862637881547574d-2*t121*t129*t132*t277*t282*t2
     =         86*t421+3.4242190004576445d-1*t123*t125*t131*t277*t286*t4
     >         21-2.007495602679796d-2*t121*t134*t225*t276*t415*t418+5.8
     ?         62637881547574d-2*t121*t129*t225*t229*t272*t282*t286-1.71
     @         21095002288222d-1*t123*t125*t225*t276*t286+3.424219000457
     1         6445d-1*t123*t126*t131*t225*t272*t286-1.7121095002288222d
     2         -1*t121*t123*t125*t131*t225*(-2.34505515261903d-1*t127*t1
     3         32*t230*t274*t282-4.69011030523806d-1*t134*t229*t272*t282
     4         +t1030)-1.172527576309515d-1*t129*t132*t225*t277*t282-2.3
     5         4505515261903d-1*t129*t136*t229*t272*t282+t1049+t1048+t10
     6         47+t1046+t1045+t1044+t1043+t1042+t1029+t1028+t1027+t1026+
     7         t1025+t1012+t1009)+7.420670230672731d-2*t124*t272*t581*t6
     8         6+t1024)
            t1055 = -2.473556743557577d-2*t120*t278*t581*t66
            t1056 = 4.947113487115154d-2*t120*t284**3*t66*t716
            t1057 = 1/t122**8.0d+0
            t1058 = 1/t119**8.0d+0
            t1059 = 2.473556743557577d-2*t120*t212*t66*(-1.0272657001372
     1         934d+0*t121*t123*t125*t131*t283**3*t714+1.758791364464272
     2         5d-1*t121*t129*t132*t282*t421*t576+1.0272657001372934d+0*
     3         t123*t125*t131*t421*t576+6.022486808039389d-2*t121*t131*t
     4         134*t283*t415*t418*t421-3.0112434040196945d-2*t131*t134*t
     5         225*t415*t418-1.7587913644642725d-1*t129*t132*t225*t282*t
     6         283-5.155578439523496d-3*t1057*t1058*t121*t225*t230)
            t1060 = -7.420670230672731d-2*t120*t284*t425*t579*t66
            t1061 = 8.029982410719184d-2*t121*t131*t134*t283*t415*t418*t
     1         421
            t1062 = -2.34505515261903d-1*t129*t132*t225*t282*t283
            t1063 = -1.0272657001372934d+0*t121*t123*t125*t131*t286*t576
     1         *t714+1.172527576309515d-1*t121*t129*t132*t282*t421*t576+
     2         6.848438000915289d-1*t123*t125*t131*t421*t576+2.007495602
     3         679796d-2*t121*t131*t134*t286*t415*t418*t421+1.1725275763
     4         09515d-1*t121*t129*t132*t282*t283*t286*t421+6.84843800091
     5         5289d-1*t123*t125*t131*t283*t286*t421-6.022486808039389d-
     6         2*t131*t134*t225*t415*t418-5.862637881547574d-2*t129*t132
     7         *t225*t282*t286-1.0311156879046991d-2*t1057*t1058*t121*t2
     8         25*t230+t1062+t1061
            t1064 = (4.947113487115154d-2*t120*t287*t574*t66*t716+t425*(
     1         -4.947113487115154d-2*t120*t284*t581*t66-2.47355674355757
     2         7d-2*t120*t287*t579*t66)+2.473556743557577d-2*t1063*t120*
     3         t212*t66)*wght
            t1065 = (t1060+t1059+t1056)*wght
            t1066 = -1.0272657001372934d+0*t121*t123*t125*t131*t283*t583
     1         *t714+5.862637881547574d-2*t121*t129*t132*t282*t421*t583+
     2         3.4242190004576445d-1*t123*t125*t131*t421*t583+8.02998241
     3         0719184d-2*t121*t131*t134*t286*t415*t418*t421+2.345055152
     4         61903d-1*t121*t129*t132*t282*t283*t286*t421+1.36968760018
     5         30577d+0*t123*t125*t131*t283*t286*t421-1.2044973616078777
     6         d-1*t131*t134*t225*t415*t418-2.34505515261903d-1*t129*t13
     7         2*t225*t282*t286-2.0622313758093982d-2*t1057*t1058*t121*t
     8         225*t230+t1062+t1061
            fnc(iq) = (2.473556743557577d-2*t120*t138*t66+1.0d+0*t103*t6
     1         6-1.0d+0*rhob*t65-1.2367783717787881d-2*rhoa*t39-1.0d+0*r
     2         hoa*t26-1.2367783717787881d-2*rhob*t116)*wght+fnc(iq)
            Amat(iq,D1_RA) = (2.473556743557577d-2*t120*t212*t232*t66+7.
     1         420670230672731d-2*t124*t138*t215*t66+1.0d+0*t210*t66-1.2
     2         367783717787881d-2*t39-1.0d+0*t26+t233+t211-1.23677837177
     3         87881d-2*rhoa*t159*t171-1.0d+0*rhoa*t158)*wght+Amat(iq,D1
     4         _RA)
            Amat(iq,D1_RB) = (2.473556743557577d-2*t120*t212*t278*t66+7.
     1         420670230672731d-2*t124*t138*t272*t66+1.0d+0*t271*t66-1.0
     2         d+0*t65-1.2367783717787881d-2*rhob*t254*t266-1.0d+0*rhob*
     3         t253+t233+t211-1.2367783717787881d-2*t116)*wght+Amat(iq,D
     4         1_RB)
            Cmat(iq,D1_GAA) = (t285-1.2367783717787881d-2*rhoa*t159*t281
     1         )*wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = 2.473556743557577d-2*t120*t212*t287*t66*wg
     1         ht+Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = (t285-1.2367783717787881d-2*rhob*t254*t290
     1         )*wght+Cmat(iq,D1_GBB)
            Amat2(iq,D2_RA_RA) = (-2.473556743557577d-2*t120*t425*t426*t
     1         66+7.420670230672731d-2*t124*t138*t395*t66+1.484134046134
     2         5462d-1*t119*t138*t392*t66+1.0d+0*t391*t66+t212*t424+1.23
     3         67783717787881d-2*rhoa*t336*t337+t159*t335-1.0d+0*rhoa*t3
     4         16+1.4841340461345462d-1*t124*t138*t215+2.0d+0*t210-2.0d+
     5         0*t158)*wght+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = (7.420670230672731d-2*t124*t138*t430*t6
     1         6+1.0d+0*t429*t66-2.473556743557577d-2*t120*t232*t278*t42
     2         5*t66+1.4841340461345462d-1*t119*t138*t215*t272*t66+t212*
     3         t446+7.420670230672731d-2*t124*t138*t272+1.0d+0*t271+7.42
     4         0670230672731d-2*t124*t138*t215+1.0d+0*t210)*wght+Amat2(i
     5         q,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = (-2.473556743557577d-2*t120*t425*t518*t
     1         66+7.420670230672731d-2*t124*t138*t502*t66+1.484134046134
     2         5462d-1*t119*t138*t501*t66+1.0d+0*t500*t66+t212*t517+1.23
     3         67783717787881d-2*rhob*t492*t493+t254*t491-1.0d+0*rhob*t4
     4         72+1.4841340461345462d-1*t124*t138*t272+2.0d+0*t271-2.0d+
     5         0*t253)*wght+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RA_GAA) = (t538+t525+t159*t524+1.236778371778788
     1         1d-2*rhoa*t171*t281*t336)*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = (t212*t550-2.473556743557577d-2*t120*t
     1         232*t287*t425*t66)*wght+Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = (t538+t525)*wght+Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_RB_GAA) = (t558+t551)*wght+Cmat2(iq,D2_RB_GAA)
            Cmat2(iq,D2_RB_GAB) = (t212*t564-2.473556743557577d-2*t120*t
     1         278*t287*t425*t66)*wght+Cmat2(iq,D2_RB_GAB)
            Cmat2(iq,D2_RB_GBB) = (t254*t570+t558+t551+1.236778371778788
     1         1d-2*rhob*t266*t290*t492)*wght+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GAA_GAA) = (t580+t575-1.2367783717787881d-2*rhoa
     1         *t159*t573+1.2367783717787881d-2*rhoa*t336*t571)*wght+Cma
     2         t2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = (2.473556743557577d-2*t120*t212*t581*
     1         t66-2.473556743557577d-2*t120*t284*t287*t425*t66)*wght+Cm
     2         at2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = (t580+t575)*wght+Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = 2.473556743557577d-2*t120*t212*t584*t
     1         66*wght-2.473556743557577d-2*t120*t425*t582*t66*wght+Cmat
     2         2(iq,D2_GAB_GAB)
            Cmat2(iq,D2_GAB_GBB) = 2.473556743557577d-2*t120*t212*t581*t
     1         66*wght-2.473556743557577d-2*t120*t284*t287*t425*t66*wght
     2         +Cmat2(iq,D2_GAB_GBB)
            Cmat2(iq,D2_GBB_GBB) = (-1.2367783717787881d-2*rhob*t254*t58
     1         7+1.2367783717787881d-2*rhob*t492*t585+t580+t575)*wght+Cm
     2         at2(iq,D2_GBB_GBB)
            Amat3(iq,D3_RA_RA_RA) = (4.947113487115154d-2*t120*t232**3*t
     1         66*t716+t425*(t715-7.420670230672731d-2*t124*t215*t426*t6
     2         6-4.947113487115154d-2*t120*t232*t423*t66-t232*t424)+t212
     3         *(2.473556743557577d-2*t120*t66*(-1.0272657001372934d+0*t
     4         121*t123*t125*t131*t231**3*t714-1.7121095002288222d-1*t12
     5         1*t123*t125*t131*t225*(-7.03516545785709d-1*t132*t133*t70
     6         2*t704*t713-3.5175827289285444d+0*t133*t134*t665*t712+t71
     7         1+t710+t709+t707+t706+t705+1.7587913644642725d-1*t132*t13
     8         3*t409*t419*t704-5.862637881547574d-2*t127*t132*t133*t230
     9         *t704+t701+t700+t699+t698+t697-5.862637881547574d-2*t127*
     :         t132*t133*t230*t696+t695+1.7587913644642725d-1*t132*t133*
     ;         t409*t411*t419*t694+t693+t692+t691+t690+t689+t688+t687+t6
     <         86+t685+t684+t683+t682+t681+t680+t679+t678+t677+t676+t675
     =         -1.172527576309515d-1*t133*t134*t229*t668-2.1105496373571
     >         27d+0*t133*t215*t229*t409*t411*t419-2.4623079102499817d+0
     ?         *t132*t216*t226*t227*t409*t411*t419+5.276374093392817d-1*
     @         t132*t133*t222*t405*t409*t419+1.7587913644642722d+0*t133*
     1         t134*t215*t395*t418-3.5175827289285444d+0*t127*t133*t222*
     2         t230*t392*t418-8.207693034166604d+0*t134*t216*t226*t227*t
     3         392*t418-4.7878209365971874d+0*t127*t132*t222*t226*t230*t
     4         396*t415-9.575641873194375d+0*t134*t215*t226*t229*t396*t4
     5         15+7.03516545785709d-1*t127*t133*t215*t229*t230*t411+8.20
     6         7693034166605d-1*t127*t132*t216*t226*t227*t230*t411+7.035
     7         16545785709d-1*t127*t133*t215*t229*t230*t405+8.2076930341
     8         66605d-1*t127*t132*t216*t226*t227*t230*t405-1.75879136446
     9         42725d-1*t127*t132*t133*t222*t230*t405+1.367948839027768d
     :         -1*t127*t132*t222*t226*t227*t230*t398+2.735897678055536d-
     ;         1*t134*t215*t226*t227*t229*t398+7.03516545785709d-1*t127*
     <         t133*t222*t229*t230*t395+1.641538606833321d+0*t134*t216*t
     =         226*t227*t229*t395-6.566154427333284d+0*t127*t215*t216*t2
     >         22*t226*t227*t229*t230)+1.7121095002288222d-1*t121*t123*t
     ?         125*t136*(t707+t706+t705+t701+t700+t699+t698+t697+t695+t6
     @         93+t692+t691+t690+t689+t688+t687+t686+t685+t684+t683+t682
     1         +t681+t680+t679+t678+t677+t676+t675)+t674+t672+t670-3.424
     2         2190004576445d-1*t121*t123*t126*t131*t136*t668-4.10906280
     3         05491736d+0*t121*t123*t131*t136*t229*t665+1.0272657001372
     4         934d+0*t121*t123*t125*t224*t421*t422-2.396953300320351d+0
     5         *t121*t125*t131*t216*t217*t421*t422-2.0545314002745868d+0
     6         *t121*t123*t126*t131*t215*t421*t422+1.0272657001372934d+0
     7         *t121*t123*t125*t131*t231*t420*t421-5.136328500686467d-1*
     8         t121*t123*t125*t224*t225*t420+1.1984766501601755d+0*t121*
     9         t125*t131*t216*t217*t225*t420+1.0272657001372934d+0*t121*
     :         t123*t126*t131*t215*t225*t420-5.136328500686467d-1*t121*t
     ;         123*t125*t225*t231*t414-1.1984766501601755d+0*t121*t125*t
     <         136*t216*t217*t414-1.0272657001372934d+0*t121*t123*t126*t
     =         136*t215*t414+1.9974610836002932d-1*t121*t125*t131*t217*t
     >         225*t231*t398-1.9974610836002932d-1*t121*t125*t136*t217*t
     ?         224*t398+3.9949221672005863d-1*t121*t126*t131*t136*t215*t
     @         217*t398-4.1946682755606146d+0*t121*t125*t131*t225*t231*t
     1         282*t396+4.1946682755606146d+0*t121*t125*t136*t224*t282*t
     2         396-8.389336551121229d+0*t121*t126*t131*t136*t215*t282*t3
     3         96+1.0272657001372934d+0*t121*t123*t126*t131*t225*t231*t3
     4         95-1.0272657001372934d+0*t121*t123*t126*t136*t224*t395+2.
     5         396953300320351d+0*t121*t126*t131*t136*t216*t217*t395+3.0
     6         8179710041188d+0*t121*t123*t131*t132*t136*t215*t395-3.081
     7         79710041188d+0*t121*t123*t131*t132*t225*t231*t392+3.08179
     8         710041188d+0*t121*t123*t132*t136*t224*t392-7.190859900961
     9         053d+0*t121*t131*t132*t136*t216*t217*t392+2.3969533003203
     :         51d+0*t121*t125*t216*t217*t224*t225*t231+2.05453140027458
     ;         68d+0*t121*t123*t126*t215*t224*t225*t231-4.79390660064070
     <         2d+0*t121*t126*t131*t215*t216*t217*t225*t231+4.7939066006
     =         40702d+0*t121*t126*t136*t215*t216*t217*t224)+2.2262010692
     >         018191d-1*t124*t215*t423*t66+2.2262010692018191d-1*t124*t
     ?         232*t395*t66+4.4524021384036383d-1*t119*t232*t392*t66+7.4
     @         20670230672731d-2*t120*t423+4.4524021384036383d-1*t124*t2
     1         15*t232)+7.420670230672731d-2*t124*t138*t66*t668+1.484134
     2         0461345462d-1*t138*t66*t665+1.0d+0*t66*t664+4.45240213840
     3         36383d-1*t119*t138*t215*t395*t66-2.4735567435575762d-2*rh
     4         oa*t171**3*t621+t159*(-1.2367783717787881d-2*rhoa*(-1.630
     5         682653048789d+0*gammaaa*t170**3*t28*t33*t620-2.7178044217
     6         479813d-1*gammaaa*t166*t28*t33*(-1.4075311556007766d+1*t1
     7         67*t35*t600*t619+t618+t617+t616+t615+t614+t613+t612+t611+
     8         t610+t609+t608+t607+t606+t605+9.37069921229161d+5*t34*t60
     9         3*t604/t30**5.0d+0-7.028024409218707d+5*t320*t329*t34*t60
     :         3+7.808916010243009d+4*t169*t29*t34*t603+4.78752093741761
     ;         d-2*t167*t168*t35*t602+1.0053793968576981d+0*t167*t330*t3
     <         5*t601+1.1944679893212153d+1*t169*t29*t34*t599+8.69210858
     =         5655094d+3*t158*t316*t320*t329*t34-2.8973695285516987d+3*
     >         t158*t169*t29*t316*t34+9.754821912789926d+2*t158*t167*t16
     ?         9*t29*t317*t330-4.0563173399723773d+4*t160*t167*t168*t319
     @         *t320*t329+1.3521057799907926d+4*t160*t167*t168*t169*t29*
     1         t319-2.787091975082837d+1*t158*t167*t168*t169*t29*t318-1.
     2         6722551850497014d+2*t160*t167*t168*t169*t29*t316)+2.71780
     3         44217479813d-1*gammaaa*t28*t37*(t618+t617+t616+t615+t614+
     4         t613+t612+t611+t610+t609+t608+t607+t606+t605)+8.807699514
     5         924018d-2*gammaaa*t161*t33*t37*t602+1.1097701388804264d+0
     6         *gammaaa*t279*t33*t37*t601-1.035785462955064d+1*gammaaa*t
     7         168*t33*t37*t600-1.9024630952235871d+0*gammaaa*t160*t161*
     8         t328*t37-3.170771825372647d-1*gammaaa*t161*t165*t318*t37+
     9         6.658620833282555d+0*gammaaa*t165*t279*t317*t37-3.8049261
     :         904471743d+0*gammaaa*t160*t161*t33*t332*t333+1.6306826530
     ;         48789d+0*gammaaa*t165*t28*t332*t333+1.630682653048789d+0*
     <         gammaaa*t170*t28*t33*t331*t332+1.9024630952235871d+0*gamm
     =         aaa*t160*t161*t166*t33*t331-8.153413265243944d-1*gammaaa*
     >         t165*t166*t28*t331+3.170771825372647d-1*gammaaa*t161*t166
     ?         *t170*t318*t33-6.658620833282555d+0*gammaaa*t166*t170*t27
     @         9*t317*t33-8.153413265243944d-1*gammaaa*t166*t170*t28*t32
     1         8+3.8049261904471743d+0*gammaaa*t160*t161*t165*t166*t170)
     2         -3.710335115336365d-2*t334)-1.0d+0*rhoa*t599+2.2262010692
     3         018191d-1*t124*t138*t395+4.4524021384036383d-1*t119*t138*
     4         t392+3.0d+0*t391+t336*(1.2367783717787881d-2*t337-t171*t3
     5         35+2.4735567435575762d-2*rhoa*t171*t334)-3.0d+0*t316)*wgh
     6         t+Amat3(iq,D3_RA_RA_RA)
            Amat3(iq,D3_RA_RA_RB) = (t793+t792+t212*(2.473556743557577d-
     1         2*t120*t66*(-1.7121095002288222d-1*t121*t123*t125*t131*t2
     2         25*(t791+t790+t789+t788+t787+t786+t785+t784+1.75879136446
     3         42725d-1*t132*t133*t409*t411*t419*t783+t782+t781+t780+t77
     4         9+t778+t777+t776+t775-5.862637881547574d-2*t127*t132*t133
     5         *t230*t774+t773+t772+t771+t770+t769+t768+t767+t766+t765+t
     6         764+t763+t762+t761+t760+t759+t758+t757+t756+t755+t754+t75
     7         3+t752+t751+t750+t749+t748+t747+t746+t745+t744+t743+t742+
     8         t741+t740+t739-1.172527576309515d-1*t133*t134*t229*t729-7
     9         .03516545785709d-1*t132*t133*t274*t411*t702*t713-3.517582
     :         7289285444d+0*t133*t134*t272*t392*t712+t711+t710+t709+t68
     ;         4+t683+t682+3.517582728928545d-1*t132*t133*t222*t409*t419
     <         *t435+4.69011030523806d-1*t127*t133*t215*t229*t230*t435-1
     =         .172527576309515d-1*t127*t132*t133*t222*t230*t435+1.17252
     >         75763095148d+0*t133*t134*t215*t418*t430+4.69011030523806d
     ?         -1*t127*t133*t222*t229*t230*t430+1.7587913644642725d-1*t1
     @         32*t133*t274*t409*t411*t419-7.03516545785709d-1*t133*t229
     1         *t272*t409*t411*t419-8.207693034166605d-1*t132*t216*t226*
     2         t227*t409*t411*t419+1.7587913644642725d-1*t132*t133*t274*
     3         t405*t409*t419-1.407033091571418d+0*t133*t215*t222*t229*t
     4         274*t409*t419+5.862637881547574d-1*t133*t134*t272*t395*t4
     5         18-1.1725275763095148d+0*t127*t133*t230*t274*t392*t418-2.
     6         735897678055535d+0*t134*t216*t226*t227*t392*t418-2.345055
     7         1526190297d+0*t127*t133*t215*t222*t230*t272*t418-1.595940
     8         3121990623d+0*t127*t132*t226*t230*t274*t396*t415-3.191880
     9         6243981246d+0*t134*t226*t229*t272*t396*t415-3.19188062439
     :         81246d+0*t127*t132*t222*t226*t230*t396*t415-6.38376124879
     ;         6249d+0*t134*t215*t226*t229*t396*t415-5.862637881547574d-
     <         2*t127*t132*t133*t230*t274*t411+2.34505515261903d-1*t127*
     =         t133*t229*t230*t272*t411+2.735897678055535d-1*t127*t132*t
     >         216*t226*t227*t230*t411-5.862637881547574d-2*t127*t132*t1
     ?         33*t230*t274*t405+2.34505515261903d-1*t127*t133*t229*t230
     @         *t272*t405+2.735897678055535d-1*t127*t132*t216*t226*t227*
     1         t230*t405+4.5598294634258935d-2*t127*t132*t226*t227*t230*
     2         t274*t398+9.119658926851787d-2*t134*t226*t227*t229*t272*t
     3         398+9.119658926851787d-2*t127*t132*t222*t226*t227*t230*t3
     4         98+1.8239317853703574d-1*t134*t215*t226*t227*t229*t398+2.
     5         34505515261903d-1*t127*t133*t229*t230*t274*t395+5.4717953
     6         5611107d-1*t134*t216*t226*t227*t229*t395+4.69011030523806
     7         d-1*t127*t133*t215*t222*t229*t230*t274-2.188718142444428d
     8         +0*t127*t215*t216*t222*t226*t227*t229*t230)+1.71210950022
     9         88222d-1*t121*t123*t125*t136*(t784+t782+t781+t780+t779+t7
     :         78+t777+t776+t775+t773+t772+t771+t770+t769+t768+t767+t766
     ;         +t765+t764+t763+t762+t761+t760+t759+t758+t757+t756+t755+t
     <         754+t753+t752+t751+t750+t749+t748+t747+t746+t745+t744+t74
     =         3+t742+t741+t740+t739+t684+t683+t682)+t738+t737+t736+t735
     >         +t734+t733+t732+t731+t730-3.4242190004576445d-1*t121*t123
     ?         *t126*t131*t136*t729+t728+t727-1.0272657001372934d+0*t121
     @         *t123*t125*t131*t277*t422*t714+t674+t672+t670+6.848438000
     1         915289d-1*t121*t123*t125*t131*t231*t421*t444-3.4242190004
     2         576445d-1*t121*t123*t125*t224*t225*t444+6.848438000915289
     3         d-1*t121*t123*t126*t131*t215*t225*t444-3.4242190004576445
     4         d-1*t121*t123*t125*t225*t231*t443-6.848438000915289d-1*t1
     5         21*t123*t126*t136*t215*t443+6.848438000915289d-1*t121*t12
     6         3*t126*t131*t225*t231*t430-6.848438000915289d-1*t121*t123
     7         *t126*t136*t224*t430+2.0545314002745868d+0*t121*t123*t131
     8         *t132*t136*t215*t430+3.4242190004576445d-1*t121*t123*t125
     9         *t276*t421*t422-6.848438000915289d-1*t121*t123*t126*t131*
     :         t272*t421*t422-7.98984433440117d-1*t121*t125*t131*t216*t2
     ;         17*t421*t422+3.4242190004576445d-1*t121*t123*t125*t131*t2
     <         77*t420*t421+6.848438000915289d-1*t121*t123*t125*t224*t23
     =         1*t277*t421-1.3696876001830577d+0*t121*t123*t126*t131*t21
     >         5*t231*t277*t421-1.7121095002288222d-1*t121*t123*t125*t22
     ?         5*t276*t420+3.4242190004576445d-1*t121*t123*t126*t131*t22
     @         5*t272*t420+3.994922167200585d-1*t121*t125*t131*t216*t217
     1         *t225*t420-1.7121095002288222d-1*t121*t123*t125*t225*t277
     2         *t414-3.4242190004576445d-1*t121*t123*t126*t136*t272*t414
     3         -3.994922167200585d-1*t121*t125*t136*t216*t217*t414+6.658
     4         203612000978d-2*t121*t125*t131*t217*t225*t277*t398-6.6582
     5         03612000978d-2*t121*t125*t136*t217*t276*t398+1.3316407224
     6         001955d-1*t121*t126*t131*t136*t217*t272*t398+1.3316407224
     7         001955d-1*t121*t125*t131*t217*t225*t231*t398-1.3316407224
     8         001955d-1*t121*t125*t136*t217*t224*t398+2.663281444800391
     9         d-1*t121*t126*t131*t136*t215*t217*t398-1.398222758520205d
     :         +0*t121*t125*t131*t225*t277*t282*t396+1.398222758520205d+
     ;         0*t121*t125*t136*t276*t282*t396-2.79644551704041d+0*t121*
     <         t126*t131*t136*t272*t282*t396-2.79644551704041d+0*t121*t1
     =         25*t131*t225*t231*t282*t396+2.79644551704041d+0*t121*t125
     >         *t136*t224*t282*t396-5.59289103408082d+0*t121*t126*t131*t
     ?         136*t215*t282*t396+3.4242190004576445d-1*t121*t123*t126*t
     @         131*t225*t277*t395-3.4242190004576445d-1*t121*t123*t126*t
     1         136*t276*t395+1.0272657001372934d+0*t121*t123*t131*t132*t
     2         136*t272*t395+7.98984433440117d-1*t121*t126*t131*t136*t21
     3         6*t217*t395-1.0272657001372934d+0*t121*t123*t131*t132*t22
     4         5*t277*t392+1.0272657001372934d+0*t121*t123*t132*t136*t27
     5         6*t392-4.1090628005491736d+0*t121*t123*t131*t136*t229*t27
     6         2*t392-2.396953300320351d+0*t121*t131*t132*t136*t216*t217
     7         *t392+6.848438000915289d-1*t121*t123*t126*t215*t224*t225*
     8         t277+6.848438000915289d-1*t121*t123*t126*t215*t225*t231*t
     9         276+6.848438000915289d-1*t121*t123*t126*t224*t225*t231*t2
     :         72-2.0545314002745868d+0*t121*t123*t131*t132*t215*t225*t2
     ;         31*t272+2.0545314002745868d+0*t121*t123*t132*t136*t215*t2
     <         24*t272+7.98984433440117d-1*t121*t125*t216*t217*t224*t225
     =         *t231-1.5979688668802342d+0*t121*t126*t131*t215*t216*t217
     >         *t225*t231+1.5979688668802342d+0*t121*t126*t136*t215*t216
     ?         *t217*t224)+t726+t725+t724+1.4841340461345462d-1*t124*t21
     @         5*t445*t66+1.4841340461345462d-1*t124*t232*t430*t66+7.420
     1         670230672731d-2*t124*t272*t423*t66+7.420670230672731d-2*t
     2         124*t278*t395*t66+1.4841340461345462d-1*t119*t278*t392*t6
     3         6+2.9682680922690924d-1*t119*t215*t232*t272*t66+2.4735567
     4         43557577d-2*t120*t423+1.4841340461345462d-1*t124*t215*t23
     5         2)+7.420670230672731d-2*t124*t138*t66*t729+1.0d+0*t66*t72
     6         3+t717+4.947113487115154d-2*t120*t278*t426*t66*t716+t425*
     7         (t715-4.947113487115154d-2*t120*t232*t445*t66-7.420670230
     8         672731d-2*t124*t272*t426*t66-t278*t424)+2.968268092269092
     9         4d-1*t119*t138*t215*t430*t66+1.4841340461345462d-1*t119*t
     :         138*t272*t395*t66+1.4841340461345462d-1*t138*t272*t392*t6
     ;         6+7.420670230672731d-2*t124*t138*t395+1.4841340461345462d
     <         -1*t119*t138*t392+1.0d+0*t391)*wght+Amat3(iq,D3_RA_RA_RB)
            Amat3(iq,D3_RA_RB_RB) = (t212*(2.473556743557577d-2*t120*t66
     1         *(-1.7121095002288222d-1*t121*t123*t125*t131*t225*(t833+t
     2         832+t831+t830+t829-5.862637881547574d-2*t127*t132*t133*t2
     3         30*t828+t827+t826+t825+t824+t823+t822+t821+t820+t819+t818
     4         +t817+t816+t815+t814+t813+t812+t811+t810+t809+t808+t807+t
     5         806+t805+t804+t803+t802+t801+t800+t799+t798+t797+t796-1.1
     6         72527576309515d-1*t133*t134*t229*t795+t791+t790+t789+t788
     7         +t787+t786+t785+1.7587913644642725d-1*t132*t133*t222*t274
     8         *t409*t419*t783+t773+t771+t764+t757+t752+t744+t742-7.0351
     9         6545785709d-1*t132*t133*t222*t510*t702*t713-3.51758272892
     :         85444d+0*t133*t134*t215*t501*t712+t711+t710+t709+t684+t68
     ;         3+t682-7.03516545785709d-1*t133*t215*t229*t409*t419*t510-
     <         8.207693034166605d-1*t132*t216*t226*t227*t409*t419*t510+1
     =         .7587913644642725d-1*t132*t133*t222*t409*t419*t510+2.3450
     >         5515261903d-1*t127*t133*t215*t229*t230*t510+2.73589767805
     ?         5535d-1*t127*t132*t216*t226*t227*t230*t510-5.862637881547
     @         574d-2*t127*t132*t133*t222*t230*t510+1.7587913644642725d-
     1         1*t132*t133*t222*t409*t419*t506+2.34505515261903d-1*t127*
     2         t133*t215*t229*t230*t506+2.735897678055535d-1*t127*t132*t
     3         216*t226*t227*t230*t506-5.862637881547574d-2*t127*t132*t1
     4         33*t222*t230*t506+5.862637881547574d-1*t133*t134*t215*t41
     5         8*t502+2.34505515261903d-1*t127*t133*t222*t229*t230*t502+
     6         5.47179535611107d-1*t134*t216*t226*t227*t229*t502-1.17252
     7         75763095148d+0*t127*t133*t222*t230*t418*t501-2.7358976780
     8         55535d+0*t134*t216*t226*t227*t418*t501+3.517582728928545d
     9         -1*t132*t133*t274*t409*t419*t435-1.172527576309515d-1*t12
     :         7*t132*t133*t230*t274*t435+4.69011030523806d-1*t127*t133*
     ;         t229*t230*t272*t435+1.1725275763095148d+0*t133*t134*t272*
     <         t418*t430+4.69011030523806d-1*t127*t133*t229*t230*t274*t4
     =         30-1.407033091571418d+0*t133*t222*t229*t272*t274*t409*t41
     >         9-2.3450551526190297d+0*t127*t133*t215*t230*t272*t274*t41
     ?         8-3.1918806243981246d+0*t127*t132*t226*t230*t274*t396*t41
     @         5-6.383761248796249d+0*t134*t226*t229*t272*t396*t415-1.59
     1         59403121990623d+0*t127*t132*t222*t226*t230*t396*t415-3.19
     2         18806243981246d+0*t134*t215*t226*t229*t396*t415+9.1196589
     3         26851787d-2*t127*t132*t226*t227*t230*t274*t398+1.82393178
     4         53703574d-1*t134*t226*t227*t229*t272*t398+4.5598294634258
     5         935d-2*t127*t132*t222*t226*t227*t230*t398+9.1196589268517
     6         87d-2*t134*t215*t226*t227*t229*t398-2.188718142444428d+0*
     7         t127*t216*t226*t227*t229*t230*t272*t274+4.69011030523806d
     8         -1*t127*t133*t222*t229*t230*t272*t274)+1.7121095002288222
     9         d-1*t121*t123*t125*t136*(t833+t832+t831+t830+t829+t827+t8
     :         26+t825+t824+t823+t822+t821+t820+t819+t818+t817+t816+t815
     ;         +t814+t813+t812+t811+t810+t809+t808+t807+t806+t805+t804+t
     <         803+t802+t801+t800+t799+t798+t797+t796+t773+t771+t764+t75
     =         7+t752+t744+t742+t684+t683+t682)-3.4242190004576445d-1*t1
     >         21*t123*t126*t131*t136*t795+t738+t737+t736+t735+t734+t733
     ?         +t732+t731+t730+t728+t727-1.0272657001372934d+0*t121*t123
     @         *t125*t131*t231*t515*t714+t674+t672+t670+3.42421900045764
     1         45d-1*t121*t123*t125*t224*t421*t515-7.98984433440117d-1*t
     2         121*t125*t131*t216*t217*t421*t515-6.848438000915289d-1*t1
     3         21*t123*t126*t131*t215*t421*t515+3.4242190004576445d-1*t1
     4         21*t123*t125*t131*t231*t421*t514-1.7121095002288222d-1*t1
     5         21*t123*t125*t224*t225*t514+3.994922167200585d-1*t121*t12
     6         5*t131*t216*t217*t225*t514+3.4242190004576445d-1*t121*t12
     7         3*t126*t131*t215*t225*t514-1.7121095002288222d-1*t121*t12
     8         3*t125*t225*t231*t513-3.994922167200585d-1*t121*t125*t136
     9         *t216*t217*t513-3.4242190004576445d-1*t121*t123*t126*t136
     :         *t215*t513+3.4242190004576445d-1*t121*t123*t126*t131*t225
     ;         *t231*t502-3.4242190004576445d-1*t121*t123*t126*t136*t224
     <         *t502+7.98984433440117d-1*t121*t126*t131*t136*t216*t217*t
     =         502+1.0272657001372934d+0*t121*t123*t131*t132*t136*t215*t
     >         502-1.0272657001372934d+0*t121*t123*t131*t132*t225*t231*t
     ?         501-4.1090628005491736d+0*t121*t123*t131*t136*t215*t229*t
     @         501+1.0272657001372934d+0*t121*t123*t132*t136*t224*t501-2
     1         .396953300320351d+0*t121*t131*t132*t136*t216*t217*t501+6.
     2         848438000915289d-1*t121*t123*t125*t131*t277*t421*t444-3.4
     3         242190004576445d-1*t121*t123*t125*t225*t276*t444+6.848438
     4         000915289d-1*t121*t123*t126*t131*t225*t272*t444-3.4242190
     5         004576445d-1*t121*t123*t125*t225*t277*t443-6.848438000915
     6         289d-1*t121*t123*t126*t136*t272*t443+6.848438000915289d-1
     7         *t121*t123*t126*t131*t225*t277*t430-6.848438000915289d-1*
     8         t121*t123*t126*t136*t276*t430+2.0545314002745868d+0*t121*
     9         t123*t131*t132*t136*t272*t430+6.848438000915289d-1*t121*t
     :         123*t125*t231*t276*t277*t421-1.3696876001830577d+0*t121*t
     ;         123*t126*t131*t231*t272*t277*t421+1.3316407224001955d-1*t
     <         121*t125*t131*t217*t225*t277*t398-1.3316407224001955d-1*t
     =         121*t125*t136*t217*t276*t398+2.663281444800391d-1*t121*t1
     >         26*t131*t136*t217*t272*t398+6.658203612000978d-2*t121*t12
     ?         5*t131*t217*t225*t231*t398-6.658203612000978d-2*t121*t125
     @         *t136*t217*t224*t398+1.3316407224001955d-1*t121*t126*t131
     1         *t136*t215*t217*t398-2.79644551704041d+0*t121*t125*t131*t
     2         225*t277*t282*t396+2.79644551704041d+0*t121*t125*t136*t27
     3         6*t282*t396-5.59289103408082d+0*t121*t126*t131*t136*t272*
     4         t282*t396-1.398222758520205d+0*t121*t125*t131*t225*t231*t
     5         282*t396+1.398222758520205d+0*t121*t125*t136*t224*t282*t3
     6         96-2.79644551704041d+0*t121*t126*t131*t136*t215*t282*t396
     7         +7.98984433440117d-1*t121*t125*t216*t217*t225*t276*t277+6
     8         .848438000915289d-1*t121*t123*t126*t215*t225*t276*t277+6.
     9         848438000915289d-1*t121*t123*t126*t224*t225*t272*t277-1.5
     :         979688668802342d+0*t121*t126*t131*t216*t217*t225*t272*t27
     ;         7-2.0545314002745868d+0*t121*t123*t131*t132*t215*t225*t27
     <         2*t277+6.848438000915289d-1*t121*t123*t126*t225*t231*t272
     =         *t276+1.5979688668802342d+0*t121*t126*t136*t216*t217*t272
     >         *t276+2.0545314002745868d+0*t121*t123*t132*t136*t215*t272
     ?         *t276)+t726+t725+t724+7.420670230672731d-2*t124*t215*t516
     @         *t66+7.420670230672731d-2*t124*t232*t502*t66+1.4841340461
     1         345462d-1*t119*t232*t501*t66+1.4841340461345462d-1*t124*t
     2         272*t445*t66+1.4841340461345462d-1*t124*t278*t430*t66+2.9
     3         682680922690924d-1*t119*t215*t272*t278*t66+2.473556743557
     4         577d-2*t120*t516+1.4841340461345462d-1*t124*t272*t278)+7.
     5         420670230672731d-2*t124*t138*t66*t795+1.0d+0*t66*t794+t79
     6         3+t792+t717+4.947113487115154d-2*t120*t232*t518*t66*t716+
     7         t425*(-2.473556743557577d-2*t120*t232*t516*t66-2.47355674
     8         3557577d-2*t120*t278*t445*t66-7.420670230672731d-2*t124*t
     9         232*t272*t278*t66-t278*t446-2.473556743557577d-2*t120*t23
     :         2*t278)+1.4841340461345462d-1*t119*t138*t215*t502*t66+1.4
     ;         841340461345462d-1*t138*t215*t501*t66+2.9682680922690924d
     <         -1*t119*t138*t272*t430*t66+7.420670230672731d-2*t124*t138
     =         *t502+1.4841340461345462d-1*t119*t138*t501+1.0d+0*t500)*w
     >         ght+Amat3(iq,D3_RA_RB_RB)
            Amat3(iq,D3_RB_RB_RB) = (t212*(2.473556743557577d-2*t120*t66
     1         *(-1.7121095002288222d-1*t121*t123*t125*t131*t225*(t901+t
     2         900+t899-7.03516545785709d-1*t132*t133*t702*t713*t898+1.7
     3         587913644642725d-1*t132*t133*t409*t419*t898-5.86263788154
     4         7574d-2*t127*t132*t133*t230*t898+t897+t896+t895+t894+t893
     5         -5.862637881547574d-2*t127*t132*t133*t230*t892+t891+t890+
     6         t889+t888+t887+t886+t885+t884+t883+t882+t881+t880+t879+t8
     7         78+t877+t876+t875-1.172527576309515d-1*t133*t134*t229*t87
     8         4-3.5175827289285444d+0*t133*t134*t712*t873+1.75879136446
     9         42725d-1*t132*t133*t409*t419*t510*t783+t711+t710+t709+t68
     :         4+t683+t682-2.110549637357127d+0*t133*t229*t272*t409*t419
     ;         *t510-2.4623079102499817d+0*t132*t216*t226*t227*t409*t419
     <         *t510+7.03516545785709d-1*t127*t133*t229*t230*t272*t510+8
     =         .207693034166605d-1*t127*t132*t216*t226*t227*t230*t510+5.
     >         276374093392817d-1*t132*t133*t274*t409*t419*t506-1.758791
     ?         3644642725d-1*t127*t132*t133*t230*t274*t506+7.03516545785
     @         709d-1*t127*t133*t229*t230*t272*t506+8.207693034166605d-1
     1         *t127*t132*t216*t226*t227*t230*t506+1.7587913644642722d+0
     2         *t133*t134*t272*t418*t502+7.03516545785709d-1*t127*t133*t
     3         229*t230*t274*t502+1.641538606833321d+0*t134*t216*t226*t2
     4         27*t229*t502-3.5175827289285444d+0*t127*t133*t230*t274*t4
     5         18*t501-8.207693034166604d+0*t134*t216*t226*t227*t418*t50
     6         1-4.7878209365971874d+0*t127*t132*t226*t230*t274*t396*t41
     7         5-9.575641873194375d+0*t134*t226*t229*t272*t396*t415+1.36
     8         7948839027768d-1*t127*t132*t226*t227*t230*t274*t398+2.735
     9         897678055536d-1*t134*t226*t227*t229*t272*t398-6.566154427
     :         333284d+0*t127*t216*t226*t227*t229*t230*t272*t274)+1.7121
     ;         095002288222d-1*t121*t123*t125*t136*(t901+t900+t899+t897+
     <         t896+t895+t894+t893+t891+t890+t889+t888+t887+t886+t885+t8
     =         84+t883+t882+t881+t880+t879+t878+t877+t876+t875+t684+t683
     >         +t682)-3.4242190004576445d-1*t121*t123*t126*t131*t136*t87
     ?         4-4.1090628005491736d+0*t121*t123*t131*t136*t229*t873-1.0
     @         272657001372934d+0*t121*t123*t125*t131*t277**3*t714+t674+
     1         t672+t670+1.0272657001372934d+0*t121*t123*t125*t276*t421*
     2         t515-2.0545314002745868d+0*t121*t123*t126*t131*t272*t421*
     3         t515-2.396953300320351d+0*t121*t125*t131*t216*t217*t421*t
     4         515+1.0272657001372934d+0*t121*t123*t125*t131*t277*t421*t
     5         514-5.136328500686467d-1*t121*t123*t125*t225*t276*t514+1.
     6         0272657001372934d+0*t121*t123*t126*t131*t225*t272*t514+1.
     7         1984766501601755d+0*t121*t125*t131*t216*t217*t225*t514-5.
     8         136328500686467d-1*t121*t123*t125*t225*t277*t513-1.027265
     9         7001372934d+0*t121*t123*t126*t136*t272*t513-1.19847665016
     :         01755d+0*t121*t125*t136*t216*t217*t513+1.0272657001372934
     ;         d+0*t121*t123*t126*t131*t225*t277*t502-1.0272657001372934
     <         d+0*t121*t123*t126*t136*t276*t502+3.08179710041188d+0*t12
     =         1*t123*t131*t132*t136*t272*t502+2.396953300320351d+0*t121
     >         *t126*t131*t136*t216*t217*t502-3.08179710041188d+0*t121*t
     ?         123*t131*t132*t225*t277*t501+3.08179710041188d+0*t121*t12
     @         3*t132*t136*t276*t501-7.190859900961053d+0*t121*t131*t132
     1         *t136*t216*t217*t501+1.9974610836002932d-1*t121*t125*t131
     2         *t217*t225*t277*t398-1.9974610836002932d-1*t121*t125*t136
     3         *t217*t276*t398+3.9949221672005863d-1*t121*t126*t131*t136
     4         *t217*t272*t398-4.1946682755606146d+0*t121*t125*t131*t225
     5         *t277*t282*t396+4.1946682755606146d+0*t121*t125*t136*t276
     6         *t282*t396-8.389336551121229d+0*t121*t126*t131*t136*t272*
     7         t282*t396+2.0545314002745868d+0*t121*t123*t126*t225*t272*
     8         t276*t277+2.396953300320351d+0*t121*t125*t216*t217*t225*t
     9         276*t277-4.793906600640702d+0*t121*t126*t131*t216*t217*t2
     :         25*t272*t277+4.793906600640702d+0*t121*t126*t136*t216*t21
     ;         7*t272*t276)+2.2262010692018191d-1*t124*t272*t516*t66+2.2
     <         262010692018191d-1*t124*t278*t502*t66+4.4524021384036383d
     =         -1*t119*t278*t501*t66+7.420670230672731d-2*t120*t516+4.45
     >         24021384036383d-1*t124*t272*t278)+7.420670230672731d-2*t1
     ?         24*t138*t66*t874+1.4841340461345462d-1*t138*t66*t873+1.0d
     @         +0*t66*t872-2.4735567435575762d-2*rhob*t266**3*t867+t254*
     1         (-1.2367783717787881d-2*rhob*(-1.630682653048789d+0*gamma
     2         bb*t105*t110*t265**3*t866-2.7178044217479813d-1*gammabb*t
     3         105*t110*t261*(-1.4075311556007766d+1*t112*t262*t846*t865
     4         +t864+t863+t862+t861+t860+t859+t858+t857+t856+t855+t854+t
     5         853+t852+t851+9.37069921229161d+5*t111*t849*t850/t107**5.
     6         0d+0-7.028024409218707d+5*t111*t476*t485*t849+7.808916010
     7         243009d+4*t106*t111*t264*t849+4.78752093741761d-2*t112*t2
     8         62*t263*t848+1.0053793968576981d+0*t112*t262*t486*t847+1.
     9         1944679893212153d+1*t106*t111*t264*t845+9.754821912789926
     :         d+2*t106*t253*t262*t264*t473*t486-4.0563173399723773d+4*t
     ;         255*t262*t263*t475*t476*t485+8.692108585655094d+3*t111*t2
     <         53*t472*t476*t485+1.3521057799907926d+4*t106*t255*t262*t2
     =         63*t264*t475-2.787091975082837d+1*t106*t253*t262*t263*t26
     >         4*t474-1.6722551850497014d+2*t106*t255*t262*t263*t264*t47
     ?         2-2.8973695285516987d+3*t106*t111*t253*t264*t472)+2.71780
     @         44217479813d-1*gammabb*t105*t114*(t864+t863+t862+t861+t86
     1         0+t859+t858+t857+t856+t855+t854+t853+t852+t851)+8.8076995
     2         14924018d-2*gammabb*t110*t114*t256*t848+1.109770138880426
     3         4d+0*gammabb*t110*t114*t288*t847-1.035785462955064d+1*gam
     4         mabb*t110*t114*t263*t846+1.630682653048789d+0*gammabb*t10
     5         5*t260*t488*t489-3.8049261904471743d+0*gammabb*t110*t255*
     6         t256*t488*t489+1.630682653048789d+0*gammabb*t105*t110*t26
     7         5*t487*t488-8.153413265243944d-1*gammabb*t105*t260*t261*t
     8         487+1.9024630952235871d+0*gammabb*t110*t255*t256*t261*t48
     9         7-8.153413265243944d-1*gammabb*t105*t261*t265*t484-1.9024
     :         630952235871d+0*gammabb*t114*t255*t256*t484+3.17077182537
     ;         2647d-1*gammabb*t110*t256*t261*t265*t474-3.17077182537264
     <         7d-1*gammabb*t114*t256*t260*t474-6.658620833282555d+0*gam
     =         mabb*t110*t261*t265*t288*t473+6.658620833282555d+0*gammab
     >         b*t114*t260*t288*t473+3.8049261904471743d+0*gammabb*t255*
     ?         t256*t260*t261*t265)-3.710335115336365d-2*t490)-1.0d+0*rh
     @         ob*t845+4.947113487115154d-2*t120*t278**3*t66*t716+t425*(
     1         -7.420670230672731d-2*t124*t272*t518*t66-4.94711348711515
     2         4d-2*t120*t278*t516*t66-2.473556743557577d-2*t120*t518-t2
     3         78*t517)+4.4524021384036383d-1*t119*t138*t272*t502*t66+2.
     4         2262010692018191d-1*t124*t138*t502+4.4524021384036383d-1*
     5         t119*t138*t501+3.0d+0*t500+t492*(1.2367783717787881d-2*t4
     6         93-t266*t491+2.4735567435575762d-2*rhob*t266*t490)-3.0d+0
     7         *t472)*wght+Amat3(iq,D3_RB_RB_RB)
            Cmat3(iq,D3_RA_RA_GAA) = (t935+t934+t933+t159*(-1.2367783717
     1         787881d-2*rhoa*(-2.7178044217479813d-1*gammaaa*t166*t28*t
     2         33*(t907+t906+t905+t904+t903+t902+4.0215175874307907d+0*g
     3         ammaaa*t317*t330*t35-1.1490050249802264d-1*gammaaa*t168*t
     4         318*t35+5.794739057103396d+3*gammaaa*t279*t319*t320*t329-
     5         1.9315796857011325d+3*gammaaa*t169*t279*t29*t319+2.388935
     6         9786424305d+1*gammaaa*t169*t279*t29*t316-2.22967358006626
     7         84d+2*gammaaa*t158*t160*t168*t169*t29)+2.7178044217479813
     8         d-1*gammaaa*t28*t37*(t907+t906+t905+t904+t903+t902)-1.630
     9         682653048789d+0*gammaaa*t28*t280*t33*t333*t620+1.08712176
     :         86991926d+0*gammaaa*t170*t28*t33*t332*t522+1.268308730149
     ;         058d+0*gammaaa*t160*t161*t166*t33*t522-5.435608843495963d
     <         -1*gammaaa*t165*t166*t28*t522-1.268308730149058d+0*gammaa
     =         a*t160*t161*t37*t521-5.435608843495963d-1*gammaaa*t166*t1
     >         70*t28*t521+6.032276381146184d-1*gammaaa*t31*t317*t330*t3
     ?         7-1.0569239417908823d-1*t161*t318*t33*t37+2.2195402777608
     @         514d+0*t279*t317*t33*t37+2.7178044217479813d-1*t28*t328*t
     1         37-2.872512562450566d-2*gammaaa*t168*t31*t318*t37-1.26830
     2         8730149058d+0*t160*t161*t165*t37+5.435608843495963d-1*t28
     3         *t33*t332*t333+1.4772921749745757d-1*gammaaa*t279*t31*t33
     4         2*t333+5.435608843495963d-1*gammaaa*t28*t280*t33*t331*t33
     5         2-2.536617460298116d+0*gammaaa*t160*t161*t170*t280*t33*t3
     6         32+1.0871217686991926d+0*gammaaa*t165*t170*t28*t280*t332-
     7         2.7178044217479813d-1*t166*t28*t33*t331-7.386460874872879
     8         d-2*gammaaa*t166*t279*t31*t331+1.0569239417908823d-1*gamm
     9         aaa*t161*t166*t280*t318*t33-2.2195402777608514d+0*gammaaa
     :         *t166*t279*t280*t317*t33+1.268308730149058d+0*t160*t161*t
     ;         166*t170*t33-2.7178044217479813d-1*gammaaa*t166*t28*t280*
     <         t328+3.4470150749406775d-1*gammaaa*t160*t166*t168*t170*t3
     =         1+1.268308730149058d+0*gammaaa*t160*t161*t165*t166*t280-5
     >         .435608843495963d-1*t165*t166*t170*t28)-2.473556743557576
     ?         2d-2*t523)-2.4735567435575762d-2*rhoa*t281*t337*t621+t336
     @         *(2.4735567435575762d-2*rhoa*t171*t523-t281*t335))*wght+C
     1         mat3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_RA_GAB) = (t212*(2.473556743557577d-2*t120*t6
     1         6*(-1.7121095002288222d-1*t121*t123*t125*t131*t225*(t953+
     2         t952+t951+t950+t949+t948+t947+t946+t945+t944+t943+t942+7.
     3         03516545785709d-1*t121*t132*t282*t409*t411*t419+2.3450551
     4         526190297d+0*t121*t134*t282*t392*t418-2.34505515261903d-1
     5         *t121*t127*t132*t230*t282*t411-2.34505515261903d-1*t121*t
     6         127*t132*t230*t282*t405-4.69011030523806d-1*t121*t134*t22
     7         9*t282*t395+1.876044122095224d+0*t121*t127*t215*t222*t229
     8         *t230*t282+2.188718142444428d+0*t121*t127*t132*t216*t222*
     9         t227*t230+4.377436284888856d+0*t121*t134*t215*t216*t227*t
     :         229)+1.7121095002288222d-1*t121*t123*t125*t136*(t951+t950
     ;         +t949+t948+t947+t946+t945+t944+t943+t942)+t941+t940+t939+
     <         t938+t937+t936-1.0272657001372934d+0*t121*t123*t125*t131*
     =         t286*t422*t714+6.848438000915289d-1*t121*t123*t125*t131*t
     >         231*t421*t548-3.4242190004576445d-1*t121*t123*t125*t224*t
     ?         225*t548+7.98984433440117d-1*t121*t125*t131*t216*t217*t22
     @         5*t548+6.848438000915289d-1*t121*t123*t126*t131*t215*t225
     1         *t548-3.4242190004576445d-1*t121*t123*t125*t225*t231*t546
     2         -7.98984433440117d-1*t121*t125*t136*t216*t217*t546-6.8484
     3         38000915289d-1*t121*t123*t126*t136*t215*t546+1.1725275763
     4         09515d-1*t121*t129*t132*t282*t421*t422+6.848438000915289d
     5         -1*t123*t125*t131*t421*t422+3.4242190004576445d-1*t121*t1
     6         23*t125*t131*t286*t420*t421+6.848438000915289d-1*t121*t12
     7         3*t125*t224*t231*t286*t421-1.5979688668802342d+0*t121*t12
     8         5*t131*t216*t217*t231*t286*t421-1.3696876001830577d+0*t12
     9         1*t123*t126*t131*t215*t231*t286*t421-5.862637881547574d-2
     :         *t121*t129*t132*t225*t282*t420-3.4242190004576445d-1*t123
     ;         *t125*t131*t225*t420+3.517582728928545d-1*t121*t129*t136*
     <         t282*t392*t418-1.7121095002288222d-1*t121*t123*t125*t225*
     =         t286*t414+3.4242190004576445d-1*t123*t125*t136*t414+3.424
     >         2190004576445d-1*t121*t123*t126*t131*t225*t286*t395-1.172
     ?         527576309515d-1*t121*t129*t136*t229*t282*t395-6.848438000
     @         915289d-1*t123*t126*t131*t136*t395-1.0272657001372934d+0*
     1         t121*t123*t131*t132*t225*t286*t392+2.0545314002745868d+0*
     2         t123*t131*t132*t136*t392+7.98984433440117d-1*t121*t125*t2
     3         16*t217*t224*t225*t286+6.848438000915289d-1*t121*t123*t12
     4         6*t215*t224*t225*t286-1.5979688668802342d+0*t121*t126*t13
     5         1*t215*t216*t217*t225*t286+2.34505515261903d-1*t121*t129*
     6         t215*t225*t229*t231*t282+2.735897678055535d-1*t121*t129*t
     7         132*t216*t225*t227*t231-6.848438000915289d-1*t123*t125*t2
     8         24*t225*t231+1.5979688668802342d+0*t125*t131*t216*t217*t2
     9         25*t231+1.3696876001830577d+0*t123*t126*t131*t215*t225*t2
     :         31+5.47179535611107d-1*t121*t129*t136*t215*t216*t227*t229
     ;         -1.5979688668802342d+0*t125*t136*t216*t217*t224-1.3696876
     <         001830577d+0*t123*t126*t136*t215*t224+3.1959377337604683d
     =         +0*t126*t131*t136*t215*t216*t217)+1.4841340461345462d-1*t
     >         124*t215*t549*t66+7.420670230672731d-2*t124*t287*t395*t66
     ?         +1.4841340461345462d-1*t119*t287*t392*t66+4.9471134871151
     @         54d-2*t120*t549+1.4841340461345462d-1*t124*t215*t287)+4.9
     1         47113487115154d-2*t120*t287*t426*t66*t716+t425*(-4.947113
     2         487115154d-2*t120*t232*t549*t66-t287*t424))*wght+Cmat3(iq
     3         ,D3_RA_RA_GAB)
            Cmat3(iq,D3_RA_RA_GBB) = (t935+t934+t933)*wght+Cmat3(iq,D3_R
     1         A_RA_GBB)
            Cmat3(iq,D3_RA_RB_GAA) = t965+Cmat3(iq,D3_RA_RB_GAA)
            Cmat3(iq,D3_RA_RB_GAB) = (t212*(2.473556743557577d-2*t120*t6
     1         6*(-1.7121095002288222d-1*t121*t123*t125*t131*t225*(t981+
     2         t980+t979+t978+t977+t976+t975+t974+t973+t972+t971+t953+t9
     3         52+t946+t945+t932+t929+t926+t921-2.34505515261903d-1*t121
     4         *t127*t132*t230*t282*t435-4.69011030523806d-1*t121*t134*t
     5         229*t282*t430+7.03516545785709d-1*t121*t132*t222*t274*t28
     6         2*t409*t419+2.3450551526190297d+0*t121*t134*t215*t272*t28
     7         2*t418+9.38022061047612d-1*t121*t127*t215*t229*t230*t274*
     8         t282-2.34505515261903d-1*t121*t127*t132*t222*t230*t274*t2
     9         82+9.38022061047612d-1*t121*t127*t222*t229*t230*t272*t282
     :         )+1.7121095002288222d-1*t121*t123*t125*t136*(t979+t978+t9
     ;         77+t976+t975+t974+t973+t972+t971+t946+t945+t926+t921)+t97
     <         0+t969+t968+t967+t966+t941+t940+t939+t938+t937+t936+t918+
     =         t917+t916+t913+t910-1.0272657001372934d+0*t121*t123*t125*
     >         t131*t231*t277*t286*t714+3.4242190004576445d-1*t121*t123*
     ?         t125*t131*t231*t421*t562-1.7121095002288222d-1*t121*t123*
     @         t125*t224*t225*t562+3.994922167200585d-1*t121*t125*t131*t
     1         216*t217*t225*t562+3.4242190004576445d-1*t121*t123*t126*t
     2         131*t215*t225*t562-1.7121095002288222d-1*t121*t123*t125*t
     3         225*t231*t561-3.994922167200585d-1*t121*t125*t136*t216*t2
     4         17*t561-3.4242190004576445d-1*t121*t123*t126*t136*t215*t5
     5         61+3.4242190004576445d-1*t121*t123*t125*t131*t277*t421*t5
     6         48-1.7121095002288222d-1*t121*t123*t125*t225*t276*t548+3.
     7         4242190004576445d-1*t121*t123*t126*t131*t225*t272*t548+3.
     8         994922167200585d-1*t121*t125*t131*t216*t217*t225*t548-1.7
     9         121095002288222d-1*t121*t123*t125*t225*t277*t546-3.424219
     :         0004576445d-1*t121*t123*t126*t136*t272*t546-3.99492216720
     ;         0585d-1*t121*t125*t136*t216*t217*t546+3.4242190004576445d
     <         -1*t121*t123*t125*t131*t286*t421*t444-5.862637881547574d-
     =         2*t121*t129*t132*t225*t282*t444-3.4242190004576445d-1*t12
     >         3*t125*t131*t225*t444-1.7121095002288222d-1*t121*t123*t12
     ?         5*t225*t286*t443+3.4242190004576445d-1*t123*t125*t136*t44
     @         3+3.4242190004576445d-1*t121*t123*t126*t131*t225*t286*t43
     1         0-1.172527576309515d-1*t121*t129*t136*t229*t282*t430-6.84
     2         8438000915289d-1*t123*t126*t131*t136*t430+3.4242190004576
     3         445d-1*t121*t123*t125*t224*t277*t286*t421-7.9898443344011
     4         7d-1*t121*t125*t131*t216*t217*t277*t286*t421-6.8484380009
     5         15289d-1*t121*t123*t126*t131*t215*t277*t286*t421+3.424219
     6         0004576445d-1*t121*t123*t125*t231*t276*t286*t421-6.848438
     7         000915289d-1*t121*t123*t126*t131*t231*t272*t286*t421-7.98
     8         984433440117d-1*t121*t125*t131*t216*t217*t231*t286*t421+1
     9         .172527576309515d-1*t121*t129*t132*t231*t277*t282*t421+6.
     :         848438000915289d-1*t123*t125*t131*t231*t277*t421+3.517582
     ;         728928545d-1*t121*t129*t136*t215*t272*t282*t418+3.9949221
     <         67200585d-1*t121*t125*t216*t217*t225*t276*t286+3.42421900
     =         04576445d-1*t121*t123*t126*t215*t225*t276*t286+3.42421900
     >         04576445d-1*t121*t123*t126*t224*t225*t272*t286-7.98984433
     ?         440117d-1*t121*t126*t131*t216*t217*t225*t272*t286-1.02726
     @         57001372934d+0*t121*t123*t131*t132*t215*t225*t272*t286+3.
     1         994922167200585d-1*t121*t125*t216*t217*t224*t225*t286-7.9
     2         8984433440117d-1*t121*t126*t131*t215*t216*t217*t225*t286+
     3         1.172527576309515d-1*t121*t129*t215*t225*t229*t277*t282+1
     4         .172527576309515d-1*t121*t129*t225*t229*t231*t272*t282-3.
     5         4242190004576445d-1*t123*t125*t224*t225*t277+6.8484380009
     6         15289d-1*t123*t126*t131*t215*t225*t277-3.4242190004576445
     7         d-1*t123*t125*t225*t231*t276-6.848438000915289d-1*t123*t1
     8         26*t136*t215*t276+6.848438000915289d-1*t123*t126*t131*t22
     9         5*t231*t272-6.848438000915289d-1*t123*t126*t136*t224*t272
     :         +2.0545314002745868d+0*t123*t131*t132*t136*t215*t272)+7.4
     ;         20670230672731d-2*t124*t215*t563*t66+7.420670230672731d-2
     <         *t124*t272*t549*t66+7.420670230672731d-2*t124*t287*t430*t
     =         66+1.4841340461345462d-1*t119*t215*t272*t287*t66+2.473556
     >         743557577d-2*t120*t563+2.473556743557577d-2*t120*t549+7.4
     ?         20670230672731d-2*t124*t272*t287+7.420670230672731d-2*t12
     @         4*t215*t287)+4.947113487115154d-2*t120*t232*t278*t287*t66
     1         *t716+t425*(-2.473556743557577d-2*t120*t232*t563*t66-2.47
     2         3556743557577d-2*t120*t278*t549*t66-t287*t446))*wght+Cmat
     3         3(iq,D3_RA_RB_GAB)
            Cmat3(iq,D3_RA_RB_GBB) = t965+Cmat3(iq,D3_RA_RB_GBB)
            Cmat3(iq,D3_RB_RB_GAA) = (t990+t989+t988)*wght+Cmat3(iq,D3_R
     1         B_RB_GAA)
            Cmat3(iq,D3_RB_RB_GAB) = (t212*(2.473556743557577d-2*t120*t6
     1         6*(-1.7121095002288222d-1*t121*t123*t125*t131*t225*(t998+
     2         t997+t996+t995+t994+t993+t992+t991+t953+t952+t946+t945+7.
     3         03516545785709d-1*t121*t132*t282*t409*t419*t510-2.3450551
     4         5261903d-1*t121*t127*t132*t230*t282*t510-2.34505515261903
     5         d-1*t121*t127*t132*t230*t282*t506-4.69011030523806d-1*t12
     6         1*t134*t229*t282*t502+2.3450551526190297d+0*t121*t134*t28
     7         2*t418*t501+1.876044122095224d+0*t121*t127*t229*t230*t272
     8         *t274*t282+2.188718142444428d+0*t121*t127*t132*t216*t227*
     9         t230*t274+4.377436284888856d+0*t121*t134*t216*t227*t229*t
     :         272)+1.7121095002288222d-1*t121*t123*t125*t136*(t998+t997
     ;         +t996+t995+t994+t993+t992+t991+t946+t945)+t941+t940+t939+
     <         t938+t937+t936-1.0272657001372934d+0*t121*t123*t125*t131*
     =         t286*t515*t714+6.848438000915289d-1*t121*t123*t125*t131*t
     >         277*t421*t562-3.4242190004576445d-1*t121*t123*t125*t225*t
     ?         276*t562+6.848438000915289d-1*t121*t123*t126*t131*t225*t2
     @         72*t562+7.98984433440117d-1*t121*t125*t131*t216*t217*t225
     1         *t562-3.4242190004576445d-1*t121*t123*t125*t225*t277*t561
     2         -6.848438000915289d-1*t121*t123*t126*t136*t272*t561-7.989
     3         84433440117d-1*t121*t125*t136*t216*t217*t561+1.1725275763
     4         09515d-1*t121*t129*t132*t282*t421*t515+6.848438000915289d
     5         -1*t123*t125*t131*t421*t515+3.4242190004576445d-1*t121*t1
     6         23*t125*t131*t286*t421*t514-5.862637881547574d-2*t121*t12
     7         9*t132*t225*t282*t514-3.4242190004576445d-1*t123*t125*t13
     8         1*t225*t514-1.7121095002288222d-1*t121*t123*t125*t225*t28
     9         6*t513+3.4242190004576445d-1*t123*t125*t136*t513+3.424219
     :         0004576445d-1*t121*t123*t126*t131*t225*t286*t502-1.172527
     ;         576309515d-1*t121*t129*t136*t229*t282*t502-6.848438000915
     <         289d-1*t123*t126*t131*t136*t502+3.517582728928545d-1*t121
     =         *t129*t136*t282*t418*t501-1.0272657001372934d+0*t121*t123
     >         *t131*t132*t225*t286*t501+2.0545314002745868d+0*t123*t131
     ?         *t132*t136*t501+6.848438000915289d-1*t121*t123*t125*t276*
     @         t277*t286*t421-1.3696876001830577d+0*t121*t123*t126*t131*
     1         t272*t277*t286*t421-1.5979688668802342d+0*t121*t125*t131*
     2         t216*t217*t277*t286*t421+6.848438000915289d-1*t121*t123*t
     3         126*t225*t272*t276*t286+7.98984433440117d-1*t121*t125*t21
     4         6*t217*t225*t276*t286-1.5979688668802342d+0*t121*t126*t13
     5         1*t216*t217*t225*t272*t286+2.34505515261903d-1*t121*t129*
     6         t225*t229*t272*t277*t282-6.848438000915289d-1*t123*t125*t
     7         225*t276*t277+1.3696876001830577d+0*t123*t126*t131*t225*t
     8         272*t277+2.735897678055535d-1*t121*t129*t132*t216*t225*t2
     9         27*t277+1.5979688668802342d+0*t125*t131*t216*t217*t225*t2
     :         77-1.3696876001830577d+0*t123*t126*t136*t272*t276-1.59796
     ;         88668802342d+0*t125*t136*t216*t217*t276+5.47179535611107d
     <         -1*t121*t129*t136*t216*t227*t229*t272+3.1959377337604683d
     =         +0*t126*t131*t136*t216*t217*t272)+1.4841340461345462d-1*t
     >         124*t272*t563*t66+7.420670230672731d-2*t124*t287*t502*t66
     ?         +1.4841340461345462d-1*t119*t287*t501*t66+4.9471134871151
     @         54d-2*t120*t563+1.4841340461345462d-1*t124*t272*t287)+4.9
     1         47113487115154d-2*t120*t287*t518*t66*t716+t425*(-4.947113
     2         487115154d-2*t120*t278*t563*t66-t287*t517))*wght+Cmat3(iq
     3         ,D3_RB_RB_GAB)
            Cmat3(iq,D3_RB_RB_GBB) = (t254*(-1.2367783717787881d-2*rhob*
     1         (-2.7178044217479813d-1*gammabb*t105*t110*t261*(t999+4.02
     2         15175874307907d+0*gammabb*t112*t473*t486+5.79473905710339
     3         6d+3*gammabb*t288*t475*t476*t485-1.9315796857011325d+3*ga
     4         mmabb*t106*t264*t288*t475-1.1490050249802264d-1*gammabb*t
     5         112*t263*t474+2.3889359786424305d+1*gammabb*t106*t264*t28
     6         8*t472-2.2296735800662684d+2*gammabb*t106*t253*t255*t263*
     7         t264+t1004+t1003+t1002+t1001+t1000)+2.7178044217479813d-1
     8         *gammabb*t105*t114*(t999+t1004+t1003+t1002+t1001+t1000)-1
     9         .630682653048789d+0*gammabb*t105*t110*t289*t489*t866+1.08
     :         71217686991926d+0*gammabb*t105*t110*t265*t488*t568-5.4356
     ;         08843495963d-1*gammabb*t105*t260*t261*t568+1.268308730149
     <         058d+0*gammabb*t110*t255*t256*t261*t568-5.435608843495963
     =         d-1*gammabb*t105*t261*t265*t567-1.268308730149058d+0*gamm
     >         abb*t114*t255*t256*t567+1.4772921749745757d-1*gammabb*t10
     ?         8*t288*t488*t489+5.435608843495963d-1*t105*t110*t488*t489
     @         +5.435608843495963d-1*gammabb*t105*t110*t289*t487*t488+1.
     1         0871217686991926d+0*gammabb*t105*t260*t265*t289*t488-2.53
     2         6617460298116d+0*gammabb*t110*t255*t256*t265*t289*t488-7.
     3         386460874872879d-2*gammabb*t108*t261*t288*t487-2.71780442
     4         17479813d-1*t105*t110*t261*t487+6.032276381146184d-1*gamm
     5         abb*t108*t114*t473*t486-2.7178044217479813d-1*gammabb*t10
     6         5*t261*t289*t484+2.7178044217479813d-1*t105*t114*t484+1.0
     7         569239417908823d-1*gammabb*t110*t256*t261*t289*t474-2.872
     8         512562450566d-2*gammabb*t108*t114*t263*t474-1.05692394179
     9         08823d-1*t110*t114*t256*t474-2.2195402777608514d+0*gammab
     :         b*t110*t261*t288*t289*t473+2.2195402777608514d+0*t110*t11
     ;         4*t288*t473+1.268308730149058d+0*gammabb*t255*t256*t260*t
     <         261*t289+3.4470150749406775d-1*gammabb*t108*t255*t261*t26
     =         3*t265-5.435608843495963d-1*t105*t260*t261*t265+1.2683087
     >         30149058d+0*t110*t255*t256*t261*t265-1.268308730149058d+0
     ?         *t114*t255*t256*t260)-2.4735567435575762d-2*t569)+t990+t9
     @         89+t988-2.4735567435575762d-2*rhob*t290*t493*t867+t492*(2
     1         .4735567435575762d-2*rhob*t266*t569-t290*t491))*wght+Cmat
     2         3(iq,D3_RB_RB_GBB)
            Cmat3(iq,D3_RA_GAA_GAA) = (-2.4735567435575762d-2*rhoa*t171*
     1         t571*t621+t159*(-1.2367783717787881d-2*rhoa*(-1.630682653
     2         048789d+0*gammaaa*t170*t28*t33*t572*t620+9.36831281250572
     3         4d-2*gammaaa*t160*t166*t33*t35*t619-1.268308730149058d+0*
     4         gammaaa*t160*t161*t33*t332*t572+5.435608843495963d-1*gamm
     5         aaa*t165*t28*t332*t572+1.0871217686991926d+0*gammaaa*t28*
     6         t280*t33*t332*t522-5.435608843495963d-1*t166*t28*t33*t522
     7         -1.4772921749745757d-1*gammaaa*t166*t279*t31*t522+5.43560
     8         8843495963d-1*t28*t37*t521-5.435608843495963d-1*gammaaa*t
     9         166*t28*t280*t521-3.4470150749406775d-1*t160*t168*t31*t37
     :         -2.7178044217479813d-1*gammaaa*t166*t28*t33*(2.3889359786
     ;         424305d+1*t158*t169*t279*t29-6.894030149881355d-1*t160*t1
     <         68*t35)+8.02998241071919d-2*gammaaa*t170*t33*t330*t332*t3
     =         5-4.014991205359595d-2*gammaaa*t165*t166*t330*t35+1.08712
     >         17686991926d+0*t170*t28*t280*t33*t332+2.9545843499491514d
     ?         -1*gammaaa*t170*t279*t280*t31*t332+1.268308730149058d+0*t
     @         160*t161*t166*t280*t33+3.4470150749406775d-1*gammaaa*t160
     1         *t166*t168*t280*t31-1.4772921749745757d-1*t166*t170*t279*
     2         t31-5.435608843495963d-1*t165*t166*t28*t280)-1.2367783717
     3         787881d-2*t573)+t336*(1.2367783717787881d-2*rhoa*t171*t57
     4         3-t281*t524+1.2367783717787881d-2*rhoa*t281*t523)+t1022+t
     5         1021+t1005)*wght+Cmat3(iq,D3_RA_GAA_GAA)
            Cmat3(iq,D3_RA_GAA_GAB) = (t425*(-2.473556743557577d-2*t120*
     1         t284*t549*t66-t287*t537+t1032)+t1031+t1023)*wght+Cmat3(iq
     2         ,D3_RA_GAA_GAB)
            Cmat3(iq,D3_RA_GAA_GBB) = t1033+Cmat3(iq,D3_RA_GAA_GBB)
            Cmat3(iq,D3_RA_GAB_GAB) = (4.947113487115154d-2*t120*t232*t5
     1         82*t66*t716+t212*(2.473556743557577d-2*t120*t66*(-1.02726
     2         57001372934d+0*t121*t123*t125*t131*t231*t583*t714+8.02998
     3         2410719184d-2*t121*t131*t134*t215*t225*t415*t712+3.424219
     4         0004576445d-1*t121*t123*t125*t224*t421*t583-6.84843800091
     5         5289d-1*t121*t123*t126*t131*t215*t421*t583+6.848438000915
     6         289d-1*t121*t123*t125*t131*t286*t421*t548-1.1725275763095
     7         15d-1*t121*t129*t132*t225*t282*t548-6.848438000915289d-1*
     8         t123*t125*t131*t225*t548-3.4242190004576445d-1*t121*t123*
     9         t125*t225*t286*t546+6.848438000915289d-1*t123*t125*t136*t
     :         546+8.029982410719184d-2*t121*t131*t134*t231*t415*t418*t4
     ;         21+2.34505515261903d-1*t121*t129*t132*t231*t282*t286*t421
     <         +1.3696876001830577d+0*t123*t125*t131*t231*t286*t421-4.01
     =         4991205359592d-2*t121*t134*t224*t225*t415*t418+2.34505515
     >         261903d-1*t121*t129*t215*t225*t229*t282*t286-6.8484380009
     ?         15289d-1*t123*t125*t224*t225*t286+1.3696876001830577d+0*t
     @         123*t126*t131*t215*t225*t286-1.7121095002288222d-1*t121*t
     1         123*t125*t131*t225*(-4.69011030523806d-1*t127*t132*t222*t
     2         230*t282-9.38022061047612d-1*t134*t215*t229*t282+t1040)-2
     3         .34505515261903d-1*t129*t132*t225*t231*t282-4.69011030523
     4         806d-1*t129*t136*t215*t229*t282+t1039+t1038+t1037+t1036+t
     5         1035)+7.420670230672731d-2*t124*t215*t584*t66+t1034)+t425
     6         *(-2.473556743557577d-2*t120*t232*t584*t66-2.473556743557
     7         577d-2*t120*t287*t549*t66-t287*t550))*wght+Cmat3(iq,D3_RA
     8         _GAB_GAB)
            Cmat3(iq,D3_RA_GAB_GBB) = (t425*(-2.473556743557577d-2*t120*
     1         t287*t536*t66-t284*t550+t1032)+t1031+t1023)*wght+Cmat3(iq
     2         ,D3_RA_GAB_GBB)
            Cmat3(iq,D3_RA_GBB_GBB) = t1033+Cmat3(iq,D3_RA_GBB_GBB)
            Cmat3(iq,D3_RB_GAA_GAA) = t1052+Cmat3(iq,D3_RB_GAA_GAA)
            Cmat3(iq,D3_RB_GAA_GAB) = (t425*(-2.473556743557577d-2*t120*
     1         t284*t563*t66-t287*t557+t1055)+t1054+t1053)*wght+Cmat3(iq
     2         ,D3_RB_GAA_GAB)
            Cmat3(iq,D3_RB_GAA_GBB) = t1052+Cmat3(iq,D3_RB_GAA_GBB)
            Cmat3(iq,D3_RB_GAB_GAB) = (4.947113487115154d-2*t120*t278*t5
     1         82*t66*t716+t212*(2.473556743557577d-2*t120*t66*(-1.02726
     2         57001372934d+0*t121*t123*t125*t131*t277*t583*t714+8.02998
     3         2410719184d-2*t121*t131*t134*t225*t272*t415*t712+3.424219
     4         0004576445d-1*t121*t123*t125*t276*t421*t583-6.84843800091
     5         5289d-1*t121*t123*t126*t131*t272*t421*t583+6.848438000915
     6         289d-1*t121*t123*t125*t131*t286*t421*t562-1.1725275763095
     7         15d-1*t121*t129*t132*t225*t282*t562-6.848438000915289d-1*
     8         t123*t125*t131*t225*t562-3.4242190004576445d-1*t121*t123*
     9         t125*t225*t286*t561+6.848438000915289d-1*t123*t125*t136*t
     :         561+8.029982410719184d-2*t121*t131*t134*t277*t415*t418*t4
     ;         21+2.34505515261903d-1*t121*t129*t132*t277*t282*t286*t421
     <         +1.3696876001830577d+0*t123*t125*t131*t277*t286*t421-4.01
     =         4991205359592d-2*t121*t134*t225*t276*t415*t418+2.34505515
     >         261903d-1*t121*t129*t225*t229*t272*t282*t286-6.8484380009
     ?         15289d-1*t123*t125*t225*t276*t286+1.3696876001830577d+0*t
     @         123*t126*t131*t225*t272*t286-1.7121095002288222d-1*t121*t
     1         123*t125*t131*t225*(-4.69011030523806d-1*t127*t132*t230*t
     2         274*t282-9.38022061047612d-1*t134*t229*t272*t282+t1040)-2
     3         .34505515261903d-1*t129*t132*t225*t277*t282-4.69011030523
     4         806d-1*t129*t136*t229*t272*t282+t1039+t1038+t1037+t1036+t
     5         1035)+7.420670230672731d-2*t124*t272*t584*t66+t1034)+t425
     6         *(-2.473556743557577d-2*t120*t278*t584*t66-2.473556743557
     7         577d-2*t120*t287*t563*t66-t287*t564))*wght+Cmat3(iq,D3_RB
     8         _GAB_GAB)
            Cmat3(iq,D3_RB_GAB_GBB) = (t425*(-2.473556743557577d-2*t120*
     1         t287*t556*t66-t284*t564+t1055)+t1054+t1053)*wght+Cmat3(iq
     2         ,D3_RB_GAB_GBB)
            Cmat3(iq,D3_RB_GBB_GBB) = (-2.4735567435575762d-2*rhob*t266*
     1         t585*t867+t254*(-1.2367783717787881d-2*rhob*(-1.630682653
     2         048789d+0*gammabb*t105*t110*t265*t586*t866+9.368312812505
     3         724d-2*gammabb*t110*t112*t255*t261*t865+5.435608843495963
     4         d-1*gammabb*t105*t260*t488*t586-1.268308730149058d+0*gamm
     5         abb*t110*t255*t256*t488*t586+1.0871217686991926d+0*gammab
     6         b*t105*t110*t289*t488*t568-1.4772921749745757d-1*gammabb*
     7         t108*t261*t288*t568-5.435608843495963d-1*t105*t110*t261*t
     8         568-5.435608843495963d-1*gammabb*t105*t261*t289*t567+5.43
     9         5608843495963d-1*t105*t114*t567+8.02998241071919d-2*gamma
     :         bb*t110*t112*t265*t486*t488+2.9545843499491514d-1*gammabb
     ;         *t108*t265*t288*t289*t488+1.0871217686991926d+0*t105*t110
     <         *t265*t289*t488-4.014991205359595d-2*gammabb*t112*t260*t2
     =         61*t486+3.4470150749406775d-1*gammabb*t108*t255*t261*t263
     >         *t289-5.435608843495963d-1*t105*t260*t261*t289+1.26830873
     ?         0149058d+0*t110*t255*t256*t261*t289-2.7178044217479813d-1
     @         *gammabb*t105*t110*t261*(2.3889359786424305d+1*t106*t253*
     1         t264*t288-6.894030149881355d-1*t112*t255*t263)-1.47729217
     2         49745757d-1*t108*t261*t265*t288-3.4470150749406775d-1*t10
     3         8*t114*t255*t263)-1.2367783717787881d-2*t587)+t492*(1.236
     4         7783717787881d-2*rhob*t266*t587-t290*t570+1.2367783717787
     5         881d-2*rhob*t290*t569)+t1051+t1050+t1041)*wght+Cmat3(iq,D
     6         3_RB_GBB_GBB)
            Cmat3(iq,D3_GAA_GAA_GAA) = (-2.4735567435575762d-2*rhoa*t281
     1         **3*t621-1.2367783717787881d-2*rhoa*t159*(-1.630682653048
     2         789d+0*gammaaa*t28*t280**3*t33*t620+1.630682653048789d+0*
     3         t28*t33*t332*t572+4.431876524923727d-1*gammaaa*t279*t31*t
     4         332*t572+2.4089947232157571d-1*gammaaa*t280*t33*t330*t332
     5         *t35-1.2044973616078786d-1*t166*t33*t330*t35-4.4318765249
     6         23727d-1*t166*t279*t280*t31-3.2735882553616696d-2*gammaaa
     7         *t166*t169/t27**8.0d+0)+3.710335115336365d-2*rhoa*t281*t3
     8         36*t573+t1060+t1059+t1056)*wght+Cmat3(iq,D3_GAA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAB) = t1064+Cmat3(iq,D3_GAA_GAA_GAB)
            Cmat3(iq,D3_GAA_GAA_GBB) = t1065+Cmat3(iq,D3_GAA_GAA_GBB)
            Cmat3(iq,D3_GAA_GAB_GAB) = (4.947113487115154d-2*t120*t284*t
     1         582*t66*t716+t425*(-2.473556743557577d-2*t120*t284*t584*t
     2         66-4.947113487115154d-2*t120*t287*t581*t66)+2.47355674355
     3         7577d-2*t1066*t120*t212*t66)*wght+Cmat3(iq,D3_GAA_GAB_GAB
     4         )
            Cmat3(iq,D3_GAA_GAB_GBB) = t1064+Cmat3(iq,D3_GAA_GAB_GBB)
            Cmat3(iq,D3_GAA_GBB_GBB) = t1065+Cmat3(iq,D3_GAA_GBB_GBB)
            Cmat3(iq,D3_GAB_GAB_GAB) = 4.947113487115154d-2*t120*t287**3
     1         *t66*t716*wght+2.473556743557577d-2*t120*t212*t66*(-1.027
     2         2657001372934d+0*t121*t123*t125*t131*t286**3*t714+3.51758
     3         2728928545d-1*t121*t129*t132*t282*t421*t583+2.05453140027
     4         45868d+0*t123*t125*t131*t421*t583+2.4089947232157555d-1*t
     5         121*t131*t134*t286*t415*t418*t421-2.4089947232157555d-1*t
     6         131*t134*t225*t415*t418-7.03516545785709d-1*t129*t132*t22
     7         5*t282*t286-4.1244627516187965d-2*t1057*t1058*t121*t225*t
     8         230)*wght-7.420670230672731d-2*t120*t287*t425*t584*t66*wg
     9         ht+Cmat3(iq,D3_GAB_GAB_GAB)
            Cmat3(iq,D3_GAB_GAB_GBB) = t425*(-2.473556743557577d-2*t120*
     1         t284*t584*t66*wght-4.947113487115154d-2*t120*t287*t581*t6
     2         6*wght)+4.947113487115154d-2*t120*t284*t582*t66*t716*wght
     3         +2.473556743557577d-2*t1066*t120*t212*t66*wght+Cmat3(iq,D
     4         3_GAB_GAB_GBB)
            Cmat3(iq,D3_GAB_GBB_GBB) = t425*(-4.947113487115154d-2*t120*
     1         t284*t581*t66*wght-2.473556743557577d-2*t120*t287*t579*t6
     2         6*wght)+4.947113487115154d-2*t120*t287*t574*t66*t716*wght
     3         +2.473556743557577d-2*t1063*t120*t212*t66*wght+Cmat3(iq,D
     4         3_GAB_GBB_GBB)
            Cmat3(iq,D3_GBB_GBB_GBB) = (-2.4735567435575762d-2*rhob*t290
     1         **3*t867-1.2367783717787881d-2*rhob*t254*(-1.630682653048
     2         789d+0*gammabb*t105*t110*t289**3*t866+4.431876524923727d-
     3         1*gammabb*t108*t288*t488*t586+1.630682653048789d+0*t105*t
     4         110*t488*t586+2.4089947232157571d-1*gammabb*t110*t112*t28
     5         9*t486*t488-1.2044973616078786d-1*t110*t112*t261*t486-4.4
     6         31876524923727d-1*t108*t261*t288*t289-3.2735882553616696d
     7         -2*gammabb*t261*t264/t104**8.0d+0)+3.710335115336365d-2*r
     8         hob*t290*t492*t587+t1060+t1059+t1056)*wght+Cmat3(iq,D3_GB
     9         B_GBB_GBB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            fnc(iq) = fnc(iq)
            Amat(iq,D1_RA) = Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
            Amat2(iq,D2_RA_RA) = Amat2(iq,D2_RA_RA)
            Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
            Amat3(iq,D3_RA_RA_RA) = Amat3(iq,D3_RA_RA_RA)
            Cmat3(iq,D3_RA_RA_GAA) = Cmat3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_GAA_GAA) = Cmat3(iq,D3_RA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAA) = Cmat3(iq,D3_GAA_GAA_GAA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            fnc(iq) = fnc(iq)
            Amat(iq,D1_RB) = Amat(iq,D1_RB)
            Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
            Amat2(iq,D2_RB_RB) = Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
            Amat3(iq,D3_RB_RB_RB) = Amat3(iq,D3_RB_RB_RB)
            Cmat3(iq,D3_RB_RB_GBB) = Cmat3(iq,D3_RB_RB_GBB)
            Cmat3(iq,D3_RB_GBB_GBB) = Cmat3(iq,D3_RB_GBB_GBB)
            Cmat3(iq,D3_GBB_GBB_GBB) = Cmat3(iq,D3_GBB_GBB_GBB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> @} 
