/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.actions;

import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.turbine.modules.Action;
import org.apache.turbine.services.localization.Localization;
import org.apache.turbine.util.RunData;
import org.chefproject.core.UserEdit;
import org.chefproject.exception.IdInvalidException;
import org.chefproject.exception.IdUsedException;
import org.chefproject.service.ServerConfigurationService;
import org.chefproject.service.UserDirectoryService;

public class ChefNewUserAction
extends Action {
    public void doPerform(RunData data) throws Exception {
        String lastName;
        String id = data.getParameters().getString("id", "");
        String email = data.getParameters().getString("email", "");
        String pass1 = data.getParameters().getString("password", "");
        String pass2 = data.getParameters().getString("password_confirm", "");
        String firstName = data.getParameters().getString("first-name", "");
        if (firstName.trim().length() == 0) {
            firstName = null;
        }
        if ((lastName = data.getParameters().getString("last-name", "")).trim().length() == 0) {
            lastName = null;
        }
        if (pass1.length() == 0 || pass2.length() == 0 || !pass1.equals(pass2)) {
            data.setMessage(Localization.getString("CREATENEWUSERANDCONFIRM_PWNOTMATCH"));
            data.setScreenTemplate("NewAccount");
            return;
        }
        if (id.length() == 0) {
            data.setMessage(Localization.getString("CREATENEWUSERANDCONFIRM_NOUSERNAME"));
            data.setScreenTemplate("NewAccount");
            return;
        }
        if (email.length() == 0) {
            data.setMessage(Localization.getString("CREATENEWUSERANDCONFIRM_NOEMAIL"));
            data.setScreenTemplate("NewAccount");
            return;
        }
        try {
            UserEdit userEdit = UserDirectoryService.addUser(id);
            userEdit.setEmail(email);
            userEdit.setPassword(pass1);
            userEdit.setFirstName(firstName);
            userEdit.setLastName(lastName);
            UserDirectoryService.commitEdit(userEdit);
            JetspeedSecurity.login((String)id, (String)pass1);
            String link = ServerConfigurationService.getPortalUrl();
            data.setRedirectURI(link);
        }
        catch (IdInvalidException e) {
            data.setMessage("Invalid user id");
            data.setScreenTemplate("NewAccount");
            return;
        }
        catch (IdUsedException e) {
            data.setMessage("User id already in use");
            data.setScreenTemplate("NewAccount");
            return;
        }
    }
}

