/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.actions;

import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.turbine.modules.ActionEvent;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.chefproject.util.MyPortalsTool;

public class ActionTeamlet
extends ActionEvent {
    public void executeEvents(RunData data) throws Exception {
        super.executeEvents(data);
        ActionTeamlet.redirectToPane((JetspeedRunData)data);
    }

    public void doPerform(RunData data) throws Exception {
        Log.warn("chef", this + ".doPerform(): unexpected call");
    }

    public static void redirectToPane(JetspeedRunData data) {
        String url = ActionTeamlet.computeRedirectUrl(data);
        if (url != null) {
            data.setRedirectURI(url);
        }
    }

    public static String computeRedirectUrl(JetspeedRunData data) {
        try {
            String paneInRequest;
            String rootId = data.getProfile().getDocument().getPortlets().getId();
            String pane = null;
            SessionState panestate = data.getPortletSessionState(rootId);
            if (panestate != null) {
                pane = (String)panestate.getAttribute("js_pane");
            }
            if ((paneInRequest = data.getParameters().getString("js_pane")) != null && paneInRequest.trim().length() > 0) {
                pane = paneInRequest;
            }
            String link = MyPortalsTool.getSiteUrl();
            String panel = data.getParameters().getString("panel");
            String template = data.getParameters().getString("template");
            String peid = data.getJs_peid();
            String floating = data.getParameters().getString("float");
            boolean floatTemplate = "float".equals(template);
            if (panel != null) {
                link = link + "/panel/" + panel + "/template/" + template + "/js_peid/" + peid;
            } else if (floatTemplate) {
                link = link + "/template/" + template + "/js_peid/" + peid;
            } else if (pane != null) {
                link = link + "/js_pane/" + pane;
            }
            if (floating != null) {
                link = link + "/float/" + floating;
            }
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", " ** redirect url: " + link);
            }
            return link;
        }
        catch (Exception e) {
            Log.warn("chef", "ActionTeamlet.computeRedirectUrl: exception processing redirect: " + e);
            return null;
        }
    }
}

